-- Create catalog.set_images table for optimized set images
CREATE TABLE IF NOT EXISTS catalog.set_images (
  id SERIAL PRIMARY KEY,
  set_id INTEGER NOT NULL, -- FK to product_creator.product_sets
  
  -- File paths
  url TEXT NOT NULL,
  filename TEXT NOT NULL,
  
  -- Optimized image versions (generated automatically)
  thumbnail_url TEXT,
  medium_url TEXT,
  
  -- Image type
  image_type VARCHAR(30) NOT NULL, -- 'packshot', 'render', 'visualization'
  
  -- SEO attributes
  alt_text TEXT,
  title TEXT,
  
  -- Tags (multiple selection)
  tags TEXT[] DEFAULT ARRAY[]::TEXT[],
  
  -- Display order
  sort_order INTEGER DEFAULT 0,
  
  -- Is this the primary image (packshot for list)
  is_primary BOOLEAN DEFAULT false,
  
  created_at TIMESTAMP DEFAULT NOW(),
  updated_at TIMESTAMP DEFAULT NOW()
);

-- Create index on set_id for fast lookups
CREATE INDEX IF NOT EXISTS idx_set_images_set_id ON catalog.set_images(set_id);

-- Create index on is_primary for fast primary image lookups
CREATE INDEX IF NOT EXISTS idx_set_images_is_primary ON catalog.set_images(is_primary) WHERE is_primary = true;
