-- ========================================
-- NAPRAWA PRODUCTION: Order Numbers i Order Codes
-- ========================================

-- KROK 1: Utwórz trigger dla auto-increment order_number
CREATE OR REPLACE FUNCTION commerce.set_order_number()
RETURNS TRIGGER AS $$
BEGIN
    IF NEW.order_number IS NULL THEN
        NEW.order_number := nextval('commerce.order_number_seq');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS set_order_number_trigger ON commerce.orders;
CREATE TRIGGER set_order_number_trigger
BEFORE INSERT ON commerce.orders
FOR EACH ROW
EXECUTE FUNCTION commerce.set_order_number();

-- KROK 2: Napraw istniejące zamówienia (nadaj im order_number)
UPDATE commerce.orders
SET order_number = nextval('commerce.order_number_seq')
WHERE order_number IS NULL;

-- KROK 3: Przebuduj tabelę z order_code zaraz po order_number
-- Najpierw usuń kolumnę order_code
ALTER TABLE commerce.orders DROP COLUMN IF EXISTS order_code;

-- Dodaj kolumnę order_code zaraz po order_number
ALTER TABLE commerce.orders 
ADD COLUMN order_code VARCHAR(20) GENERATED ALWAYS AS ('ORD-' || LPAD(order_number::TEXT, 6, '0')) STORED;

-- Gotowe! ✅
