# Moduł Produkcji - Roadmap

## 📋 Struktura Menu

**Produkcja** (główna sekcja w sidebar):
1. **Panel główny** - Dashboard z KPI i statusem produkcji
2. **Zlecenia produkcyjne (ZLP)** - Tworzenie i zarządzanie zleceniami
3. **Marszruty** - Definicje przepływu produkcji
4. **Gniazda robocze** - Stanowiska (Piła, Oklejarek, Wiertarki, etc.)
5. **Lokalizacje & Bufory** - Magazyny międzyoperacyjne
6. **Nośniki** - Palety, wózki ✅ DONE
7. **Ustawienia** - Konfiguracja (podzielone na zakładki):
   - **Główne** - Podstawowe ustawienia produkcji
   - **Normatywy** - Wydajności, czasy, koszty
   - **Rozszerzenia** - Dodatkowe funkcje

## 🏭 Kontekst Biznesowy - Alpma

### Stanowiska robocze (Work Centers):
- Piła panelowa Masterwood
- Okleiniarka Falit
- Okleiniarka Masterwood
- Wiertarka Master 1
- Wiertarka Master 2
- Wiertarka Next
- Kompletowanie
- Pakowanie

### Lokalizacje/Bufory:
- Bufor przed piłą panelową
- Bufor przed oklejarką
- Transport między działami (na paletach/samochodem do innej hali)
- Bufor przed wiertarkami
- Bufor przed pakowaniem
- Bufor wysyłkowy
- Linia pakowania - magazyn gotowych spakowanych
- Magazyn niespakowanych przygotowanych do pakowania

## 🔄 Przepływ Pracy (Workflow)

```
1. PRZYJĘCIE ZLECENIA
   ↓
2. SPRAWDZENIE MATERIAŁÓW (integracja z BOM)
   ↓
3. GENEROWANIE OPERACJI (na podstawie marszruty)
   ↓
4. KOLEJKOWANIE W BUFORACH
   ↓
5. WYKONANIE NA GNIAZDACH (pracownik skanuje start/stop)
   ↓
6. TRANSPORT MIĘDZYOPERACYJNY (śledzenie lokalizacji)
   ↓
7. KONTROLA JAKOŚCI
   ↓
8. PAKOWANIE & WYSYŁKA
```

## 📊 Dashboard KPI - Panel główny

### Mapa WIP (Work in Progress):
- Wizualizacja elementów w każdym buforze
- Status w czasie rzeczywistym

### Wydajność gniazd:
- Czas takt vs rzeczywisty
- Wykorzystanie maszyn (%)
- Czas przestoju

### Wąskie gardła:
- Mapa cieplna opóźnień
- Analiza przepustowości

### Zamówienia:
- Daty obietnic vs realizacja
- Odchylenie kosztów od planu
- Wydajność pracowników

## 🎯 Priorytety Implementacji

### FAZA P0 - Fundament (MVP)
- ✅ Schemat bazy danych (14 tabel)
- ✅ Backend: settings, norms, carriers
- ✅ Frontend: production-settings.tsx
- ✅ Frontend: production-carriers.tsx
- 🔲 **NEXT: Lokalizacje & Bufory**
  - Hierarchia: Hala → Dział → Bufor → Półka
  - 8 buforów produkcyjnych
  - Śledzenie pojemności i statusu

### FAZA P1 - Gniazda & Marszruty
- 🔲 **Gniazda robocze** (Work Centers):
  - 8 stanowisk Alpma
  - Przypisanie pracowników
  - Normatywy: wydajność, koszty, czasy
  - Kalendarz pracy, dostępność
  
- 🔲 **Marszruty produkcyjne**:
  - Definicje operacji (ciecie → oklejanie → wiercenie → pakowanie)
  - Czasy standardowe
  - Kolejność obowiązkowa/opcjonalna
  - Link do BOM

### FAZA P2 - Wykonanie
- 🔲 **Zlecenia produkcyjne (ZLP)**:
  - Tworzenie z zamówień
  - Status tracking
  - Przypisanie do gniazd
  - Materiały (link do BOM)
  
- 🔲 **Terminal dla pracowników**:
  - Tablet/ekran przy każdym gnieździe
  - Skanowanie kodów kreskowych (nośniki, produkty)
  - Start/Stop operacji
  - Zgłaszanie problemów (Digital Andon)
  - Przeniesienie do kolejnego bufora
  - Potwierdzenie jakości

### FAZA P3 - Analityka & Optymalizacja
- 🔲 Dashboard KPI
- 🔲 Raporty wydajności
- 🔲 Analiza kosztów
- 🔲 Predykcja opóźnień
- 🔲 What-if scheduler
- 🔲 Bottleneck analysis

## 💡 Best Practices (Odoo + Przemysł)

1. **Wielokrotne użycie marszrut** - Jedna marszruta dla wielu produktów
2. **Kanban dla buforów** - Wizualne sygnały przepełnienia
3. **Skanowanie kodów** - Każdy transfer potwierdzony skanerem
4. **Koszty pracy** - Automatyczne zliczanie czasu pracownika
5. **Konserwacje** - Integracja z kalendarzem maintenance
6. **Digital Andon** - Natychmiastowe alerty o problemach
7. **What-if scheduler** - Symulacja zmian w planie
8. **Predykcyjne alerty** - AI/ML dla wykrywania problemów

## 🗄️ Schemat Bazy Danych

### Istniejące tabele:
1. `production_settings` - Ustawienia główne
2. `production_norm_groups` - Grupy normatywów
3. `production_norms` - Normatywy
4. `production_carrier_groups` - Grupy nośników
5. `production_carriers` - Nośniki (palety, wózki)
6. `production_locations` - Lokalizacje hierarchiczne
7. `production_work_centers` - Gniazda robocze
8. `production_work_center_resources` - Zasoby (pracownicy, maszyny)
9. `production_routings` - Marszruty
10. `production_routing_operations` - Operacje w marszrutach
11. `production_orders` - Zlecenia produkcyjne
12. `production_order_operations` - Operacje w zleceniach
13. `production_order_materials` - Materiały do zleceń
14. `production_order_tracking` - Śledzenie statusu

## 🚀 Kolejne Kroki

1. **Lokalizacje & Bufory** (1-2 dni)
   - Backend: CRUD dla hierarchii lokalizacji
   - Frontend: Wizualizacja z drzewem lokalizacji
   - 8 buforów produkcyjnych Alpma

2. **Gniazda robocze** (2-3 dni)
   - Backend: Work centers + resources
   - Frontend: Lista gniazd z przypisaniem pracowników
   - Normatywy dla każdego gniazda

3. **Marszruty** (2-3 dni)
   - Backend: Routings + operations
   - Frontend: Builder marszrut (drag & drop?)
   - Szablony dla typowych przepływów

4. **Zlecenia produkcyjne** (3-4 dni)
   - Backend: Orders + tracking
   - Frontend: Tworzenie i monitoring ZLP
   - Integracja z BOM i zamówieniami

## 📝 Notatki Techniczne

- **Architektura**: Modular backend (routes + services), react-hook-form na frontend
- **Walidacja**: Zod schemas dla wszystkich API endpoints
- **State management**: TanStack Query z proper invalidation
- **Testing**: data-testid dla wszystkich elementów interaktywnych
- **Database**: PostgreSQL Pool (zgodnie z projektem)
- **Schemat**: `production.*` (dedykowany namespace)

---

**Ostatnia aktualizacja:** 2025-11-09
**Status:** Faza P0 w trakcie (Lokalizacje & Bufory - NEXT)
