-- Add indexes for catalog search optimization
-- Enables pg_trgm extension for trigram indexes

-- Enable pg_trgm extension if not already enabled
CREATE EXTENSION IF NOT EXISTS pg_trgm;

-- Btree indexes for SKU prefix search
CREATE INDEX IF NOT EXISTS idx_products_sku_lower ON catalog.products (lower(sku));
CREATE INDEX IF NOT EXISTS idx_product_sets_sku_lower ON product_creator.product_sets (lower(sku));

-- GIN trigram indexes for title contains search (ILIKE '%term%')
CREATE INDEX IF NOT EXISTS idx_products_title_trgm ON catalog.products USING gin (lower(title) gin_trgm_ops);
CREATE INDEX IF NOT EXISTS idx_product_sets_title_trgm ON product_creator.product_sets USING gin (lower(title) gin_trgm_ops);

-- Partial indexes for common filter combinations (only active items)
CREATE INDEX IF NOT EXISTS idx_products_color_lower ON catalog.products (lower(color)) WHERE is_active = true;
CREATE INDEX IF NOT EXISTS idx_products_length ON catalog.products (length) WHERE is_active = true;
CREATE INDEX IF NOT EXISTS idx_products_width ON catalog.products (width) WHERE is_active = true;
CREATE INDEX IF NOT EXISTS idx_products_type_lower ON catalog.products (lower(product_type)) WHERE is_active = true;

CREATE INDEX IF NOT EXISTS idx_product_sets_color_lower ON product_creator.product_sets (lower(color)) WHERE is_active = true;
CREATE INDEX IF NOT EXISTS idx_product_sets_depth ON product_creator.product_sets (depth) WHERE is_active = true;
