-- Migration: Add catalog product/set references to order_items
-- Date: 2025-01-13

ALTER TABLE commerce.order_items 
ADD COLUMN IF NOT EXISTS catalog_product_id INTEGER REFERENCES catalog.products(id) ON DELETE SET NULL,
ADD COLUMN IF NOT EXISTS catalog_set_id INTEGER REFERENCES product_creator.product_sets(id) ON DELETE SET NULL,
ADD COLUMN IF NOT EXISTS original_offer_id VARCHAR(255),
ADD COLUMN IF NOT EXISTS modified_at TIMESTAMP,
ADD COLUMN IF NOT EXISTS modified_by INTEGER;

CREATE INDEX IF NOT EXISTS idx_order_items_catalog_product ON commerce.order_items(catalog_product_id) WHERE catalog_product_id IS NOT NULL;
CREATE INDEX IF NOT EXISTS idx_order_items_catalog_set ON commerce.order_items(catalog_set_id) WHERE catalog_set_id IS NOT NULL;
CREATE INDEX IF NOT EXISTS idx_products_color ON catalog.products(color) WHERE color IS NOT NULL;
CREATE INDEX IF NOT EXISTS idx_products_color_length ON catalog.products(color, length) WHERE color IS NOT NULL;
CREATE INDEX IF NOT EXISTS idx_product_sets_color ON product_creator.product_sets(color) WHERE color IS NOT NULL;
