import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { ExternalLink, FileText, Key } from "lucide-react";
import { Link } from "wouter";

export default function ApiDocsPage() {
  return (
    <div className="flex flex-col h-full">
      <div className="p-4 border-b flex items-center justify-between gap-4 flex-wrap">
        <div>
          <h1 className="text-2xl font-bold" data-testid="text-page-title">
            Dokumentacja API
          </h1>
          <p className="text-muted-foreground text-sm">
            Interaktywna dokumentacja REST API dla integracji zewnętrznych
          </p>
        </div>
        <div className="flex gap-2">
          <Link href="/api-tokens">
            <Button variant="outline" size="sm" data-testid="button-manage-tokens">
              <Key className="h-4 w-4 mr-2" />
              Zarządzaj tokenami
            </Button>
          </Link>
          <Link href="/api-token-logs">
            <Button variant="outline" size="sm" data-testid="button-api-logs">
              <FileText className="h-4 w-4 mr-2" />
              Logi API
            </Button>
          </Link>
          <a href="/api-docs/" target="_blank" rel="noopener noreferrer">
            <Button variant="outline" size="sm" data-testid="button-open-new-tab">
              <ExternalLink className="h-4 w-4 mr-2" />
              Otwórz w nowej karcie
            </Button>
          </a>
        </div>
      </div>
      
      <div className="flex-1 min-h-0">
        <iframe
          src="/api-docs/"
          className="w-full h-full border-0"
          title="Alpma OMS API Documentation"
          data-testid="iframe-swagger-ui"
        />
      </div>
    </div>
  );
}
