import { createRoot } from "react-dom/client";
import App from "./App";
import "./index.css";

// Global error handlers for debugging
window.onerror = function(message, source, lineno, colno, error) {
  const messageStr = String(message);
  
  if (messageStr.includes('ResizeObserver loop')) {
    return true;
  }
  
  console.error('🔴 Global error caught:', {
    message,
    source,
    lineno,
    colno,
    error,
    stack: error?.stack
  });
  return false;
};

window.addEventListener('unhandledrejection', function(event) {
  console.error('🔴 Unhandled promise rejection:', {
    reason: event.reason,
    promise: event.promise,
    stack: event.reason?.stack
  });
});

createRoot(document.getElementById("root")!).render(<App />);
