import { Link, useRoute } from "wouter";
import { Plus, BookOpen, Palette, Box, Grid3x3, DoorClosed, Footprints, Shirt, Package, Ruler, Component, Trash2, Scissors } from "lucide-react";
import { Button } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import type { DictionaryType } from "@shared/schema";

const DICTIONARY_TYPES: { 
  value: DictionaryType; 
  label: string; 
  icon: typeof BookOpen;
  category?: string;
}[] = [
  { value: "product_type", label: "Rodzaj produktu", icon: Box, category: "Produkty" },
  { value: "component_cz1", label: "Komponenty cz1", icon: Component, category: "Produkty" },
  { value: "component_cz2", label: "Komponenty cz2", icon: Component, category: "Produkty" },
  { value: "unit", label: "Jednostka", icon: Grid3x3, category: "Produkty" },
  { value: "color", label: "Kolor", icon: Palette, category: "Produkty" },
  { value: "material", label: "Materiał", icon: Package, category: "Produkty" },
  { value: "product_group", label: "Grupa produktów", icon: Grid3x3, category: "Produkty" },
  { value: "door", label: "Drzwi", icon: DoorClosed, category: "Produkty" },
  { value: "leg", label: "Nóżki", icon: Footprints, category: "Produkty" },
  { value: "fabric", label: "Tkaniny", icon: Shirt, category: "Produkty" },
  { value: "dimension_length", label: "Wymiar - długość", icon: Ruler, category: "Wymiary" },
  { value: "dimension_width", label: "Wymiar - szerokość", icon: Ruler, category: "Wymiary" },
  { value: "dimension_height", label: "Wymiar - wysokość", icon: Ruler, category: "Wymiary" },
  { value: "scrap_reason_product", label: "Złomowanie - produkty", icon: Trash2, category: "Złomowanie" },
  { value: "scrap_reason_cutting", label: "Złomowanie - formatki", icon: Scissors, category: "Złomowanie" },
];

interface DictionariesSubmenuProps {
  onAddNew?: () => void;
}

export function DictionariesSubmenu({ onAddNew }: DictionariesSubmenuProps) {
  const [, params] = useRoute("/dictionaries/:type");
  const activeType = params?.type as DictionaryType | undefined;

  return (
    <div className="flex flex-col h-full">
      {/* Header */}
      <div className="border-b px-4 py-4 flex items-center justify-between gap-2">
        <h2 className="text-lg font-semibold">Słowniki</h2>
        {onAddNew && (
          <Button 
            size="icon" 
            variant="ghost"
            onClick={onAddNew}
            data-testid="button-add-dictionary-type"
          >
            <Plus className="h-4 w-4" />
          </Button>
        )}
      </div>

      {/* Menu items */}
      <div className="flex-1 overflow-y-auto">
        <div className="p-2">
          <div className="px-3 py-2 text-sm font-medium text-muted-foreground">
            Typy słowników
          </div>
          <nav className="space-y-1">
            {DICTIONARY_TYPES.map((dict) => {
              const Icon = dict.icon;
              const isActive = activeType === dict.value;
              
              return (
                <Link 
                  key={dict.value}
                  href={`/dictionaries/${dict.value}`}
                  data-testid={`link-dictionary-${dict.value}`}
                >
                  <div
                    className={cn(
                      "flex items-center gap-3 px-3 py-2 rounded-md text-sm transition-colors hover-elevate active-elevate-2",
                      isActive 
                        ? "bg-accent text-accent-foreground font-medium" 
                        : "text-foreground"
                    )}
                  >
                    <Icon className="h-4 w-4 flex-shrink-0" />
                    <span className="truncate">{dict.label}</span>
                  </div>
                </Link>
              );
            })}
          </nav>
        </div>
      </div>
    </div>
  );
}
