# 📥 Jak pobrać pliki projektu z Replit

## Metoda 1: Pobierz jako ZIP (Najprostsza) ⭐

1. W Replit, kliknij na **folder główny projektu** (workspace) w panelu Files
2. Kliknij **prawym przyciskiem myszy**
3. Wybierz **"Download as zip"**
4. Zapisz plik na swoim komputerze

> ⚠️ Ta opcja może być dostępna tylko dla użytkowników Replit Explorer/Hacker

## Metoda 2: Przez Git (Zalecana dla deweloperów)

### Jeśli masz już sklonowane repozytorium:
```bash
git pull origin main
```

### Jeśli chcesz pobrać projekt po raz pierwszy:
```bash
# Sklonuj repozytorium
git clone YOUR_REPLIT_GIT_URL
cd your-project-name

# Pobierz wszystkie pliki
git pull
```

URL Git znajdziesz w Replit:
- Kliknij **Version Control** (ikona gałęzi)
- Skopiuj **Git URL**

## Metoda 3: Ręczne pobieranie najważniejszych plików

### Krok 1: Pobierz backupy bazy danych
```bash
# W Replit Files, przejdź do folderu: backups/
# Kliknij prawym na plik backup-*.sql i wybierz Download
```

### Krok 2: Pobierz kluczowe pliki konfiguracyjne

Kliknij prawym przyciskiem i **Download** na:
- ✅ `.env` (zmienne środowiskowe - BARDZO WAŻNE!)
- ✅ `package.json`
- ✅ `tsconfig.json`
- ✅ `vite.config.ts`
- ✅ `drizzle.config.ts`

### Krok 3: Pobierz kod źródłowy

Pobierz całe foldery (kliknij prawym → Download):
- ✅ `/server` - cały kod backendu
- ✅ `/client` - cały kod frontendu
- ✅ `/shared` - współdzielone typy
- ✅ `/scripts` - skrypty backupu i narzędzia

### Krok 4: Pobierz dodatkowe zasoby
- ✅ `/attached_assets` - załączone pliki i obrazy
- ✅ `/public` - pliki publiczne

## Metoda 4: SCP (jeśli masz dostęp SSH)

```bash
# Pobierz cały projekt
scp -r user@your-replit-host:/path/to/project ./local-backup/

# Lub tylko wybrane foldery
scp -r user@your-replit-host:/path/to/project/server ./local-backup/
```

## 📋 Checklist - Co musi być w backupie

✅ **Baza danych**: 
- [ ] Pliki .sql z folderu `/backups`

✅ **Kod źródłowy**:
- [ ] Folder `/server`
- [ ] Folder `/client`
- [ ] Folder `/shared`
- [ ] Folder `/scripts`

✅ **Konfiguracja**:
- [ ] Plik `.env` (KRYTYCZNY!)
- [ ] Plik `package.json`
- [ ] Plik `tsconfig.json`
- [ ] Pliki config (vite, drizzle)

✅ **Zasoby**:
- [ ] Folder `/attached_assets`
- [ ] Folder `/public`

✅ **Dokumentacja**:
- [ ] Plik `BACKUP_INSTRUKCJA.md`
- [ ] Plik `replit.md`
- [ ] Plik `README.md` (jeśli istnieje)

## 🔒 Bezpieczeństwo

**NIGDY nie udostępniaj publicznie:**
- ❌ Plik `.env` (zawiera klucze API!)
- ❌ Pliki `.sql` (zawierają dane klientów!)
- ❌ Folder `backups/`
- ❌ Folder `node_modules/` (można pobrać przez npm install)

## 📦 Kompresja backupu (opcjonalnie)

Po pobraniu wszystkich plików, możesz je skompresować:

```bash
# Na systemie lokalnym
tar -czf alpma-oms-backup-$(date +%Y%m%d).tar.gz \
  backups/ \
  server/ \
  client/ \
  shared/ \
  scripts/ \
  .env \
  package.json \
  *.config.ts \
  *.md
```

## ✅ Weryfikacja backupu

Po pobraniu sprawdź czy masz:
1. ✅ Plik .sql (baza danych) - około 20-30 MB
2. ✅ Plik .env (konfiguracja)
3. ✅ Wszystkie foldery z kodem
4. ✅ Rozmiar całkowity: około 50-100 MB (bez node_modules)

## 🔄 Restore na nowej maszynie

1. Skopiuj wszystkie pliki
2. Zainstaluj zależności (w terminalu projektu)
3. Przywróć bazę: `tsx scripts/restore-database.ts backup-*.sql`
4. Uruchom aplikację

---

📅 **Ostatnia aktualizacja:** 2025-10-14  
💡 **Wskazówka:** Rób backup regularnie - najlepiej codziennie!
