from odoo import api, fields, models


class AllegroDelivery(models.Model):
    _name = 'trilab_allegro.delivery'
    _description = 'Allegro Delivery'
    _check_company_auto = True
    _sql_constraints = [
        ('method_uniq', 'unique (method, account_id)', 'Delivery Method already exists for this account!')
    ]

    name = fields.Char(string='Allegro Delivery Method', index=True)
    method = fields.Char(string='Delivery Method ID', index=True)
    carrier = fields.Char(string='Carrier ID')
    marketplace_ids = fields.Many2many('trilab.market.marketplace', string='Marketplaces')
    account_id = fields.Many2one('trilab.market.account', string='Account')
    company_id = fields.Many2one('res.company', related='account_id.company_id')
    carrier_id = fields.Many2one('delivery.carrier', string='Odoo Delivery Method', check_company=True)

    @api.model
    def parse_allegro_data(self, data):
        return {
            'name': data['name'],
            'carrier': data['carrierId'],
            'method': data['id']['deliveryMethodId'],
            'marketplace_ids': [
                fields.Command.set(
                    self.env['trilab.market.marketplace'].search([('name', 'in', data['marketplaces'])]).ids
                )
            ],
        }
