-- Migration: Add reserved_quantity to production_plan_lines
-- Purpose: Track per-line warehouse reservations instead of only global totals

ALTER TABLE production.production_plan_lines
ADD COLUMN IF NOT EXISTS reserved_quantity INTEGER NOT NULL DEFAULT 0;

-- Backfill: Set reserved_quantity to quantity for all lines where packed_product exists
UPDATE production.production_plan_lines ppl
SET reserved_quantity = ppl.quantity
FROM catalog.products cp
JOIN warehouse.packed_products wpp ON wpp.catalog_product_id = cp.id
WHERE ppl.product_id = cp.id
  AND ppl.deleted_at IS NULL
  AND ppl.reserved_quantity = 0;

-- Create index for faster queries
CREATE INDEX IF NOT EXISTS idx_plan_lines_reserved ON production.production_plan_lines(reserved_quantity);

COMMENT ON COLUMN production.production_plan_lines.reserved_quantity IS 'Ilość zarezerwowana przez tę linię planu (per-line tracking)';
