CREATE SCHEMA "bom";
--> statement-breakpoint
CREATE SCHEMA "catalog";
--> statement-breakpoint
CREATE SCHEMA "product_creator";
--> statement-breakpoint
CREATE SCHEMA "production";
--> statement-breakpoint
CREATE SCHEMA "warehouse";
--> statement-breakpoint
CREATE TABLE "catalog"."accessories" (
	"id" serial PRIMARY KEY NOT NULL,
	"group_id" integer,
	"warehouse_material_id" integer,
	"name" text NOT NULL,
	"code" text NOT NULL,
	"alpma_code" text,
	"description" text,
	"price" numeric(10, 2),
	"image_url" text,
	"display_order" integer DEFAULT 0 NOT NULL,
	"is_active" boolean DEFAULT true NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "accessories_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "catalog"."accessory_groups" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"code" text NOT NULL,
	"category" text,
	"description" text,
	"display_order" integer DEFAULT 0 NOT NULL,
	"is_active" boolean DEFAULT true NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "accessory_groups_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "catalog"."addon_images" (
	"id" serial PRIMARY KEY NOT NULL,
	"addon_id" integer NOT NULL,
	"url" text NOT NULL,
	"filename" text NOT NULL,
	"alt_text" text,
	"title" text,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "catalog"."ai_generation_requests" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"template_id" integer,
	"status" varchar(20) DEFAULT 'pending' NOT NULL,
	"prompt" text,
	"response" text,
	"cost_metadata" jsonb,
	"created_by" integer,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "ai_prompt_settings" (
	"id" serial PRIMARY KEY NOT NULL,
	"system_instructions" text DEFAULT '',
	"product_material_info" text DEFAULT 'płyta meblowa 18mm renomowanych polskich firm',
	"edge_band_info" text DEFAULT 'obrzeże ABS 0.8mm',
	"include_product_table" boolean DEFAULT true,
	"product_table_header" text DEFAULT 'Wymiary produktu',
	"top_banner_image_id" integer,
	"bottom_banner_image_id" integer,
	"custom_instructions" text DEFAULT '',
	"prompt_intro" text,
	"prompt_features" text,
	"prompt_safety" text,
	"prompt_care" text,
	"prompt_warranty" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "allegro_connections" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"client_id" text NOT NULL,
	"client_secret" text NOT NULL,
	"access_token" text,
	"refresh_token" text,
	"token_expires_at" timestamp,
	"is_active" boolean DEFAULT false,
	"connection_error" text,
	"last_error_at" timestamp,
	"requires_reauth" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "allegro_fee_summaries" (
	"id" serial PRIMARY KEY NOT NULL,
	"summary_date" timestamp NOT NULL,
	"commission_total" numeric(10, 2) DEFAULT '0',
	"commission_count" integer DEFAULT 0,
	"listing_total" numeric(10, 2) DEFAULT '0',
	"listing_count" integer DEFAULT 0,
	"ads_total" numeric(10, 2) DEFAULT '0',
	"ads_count" integer DEFAULT 0,
	"delivery_total" numeric(10, 2) DEFAULT '0',
	"delivery_count" integer DEFAULT 0,
	"refunds_total" numeric(10, 2) DEFAULT '0',
	"refunds_count" integer DEFAULT 0,
	"other_total" numeric(10, 2) DEFAULT '0',
	"other_count" integer DEFAULT 0,
	"grand_total" numeric(10, 2) DEFAULT '0',
	"currency" varchar(10) DEFAULT 'PLN',
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "allegro_fees" (
	"id" serial PRIMARY KEY NOT NULL,
	"entry_id" text,
	"type_id" varchar(50) NOT NULL,
	"type_name" text NOT NULL,
	"amount" numeric(10, 2) NOT NULL,
	"currency" varchar(10) DEFAULT 'PLN',
	"occurred_at" timestamp NOT NULL,
	"order_id" text,
	"offer_id" text,
	"raw_data" jsonb,
	"category" varchar(50),
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "allegro_fees_entry_id_unique" UNIQUE("entry_id")
);
--> statement-breakpoint
CREATE TABLE "allegro_orders" (
	"id" varchar PRIMARY KEY NOT NULL,
	"allegro_order_id" text NOT NULL,
	"buyer_login" text NOT NULL,
	"buyer_email" text,
	"total_amount" numeric(10, 2) NOT NULL,
	"currency" text DEFAULT 'PLN',
	"payment_status" text NOT NULL,
	"fulfillment_status" text,
	"items_count" text NOT NULL,
	"order_date" timestamp NOT NULL,
	"payment_date" timestamp,
	"raw_data" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "allegro_orders_allegro_order_id_unique" UNIQUE("allegro_order_id")
);
--> statement-breakpoint
CREATE TABLE "api_request_logs" (
	"id" serial PRIMARY KEY NOT NULL,
	"token_id" integer,
	"method" varchar(10) NOT NULL,
	"path" text NOT NULL,
	"status_code" integer,
	"response_time" integer,
	"ip_address" varchar(45),
	"user_agent" text,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "api_tokens" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"token" text NOT NULL,
	"token_prefix" varchar(16),
	"permissions" jsonb DEFAULT '[]'::jsonb,
	"is_active" boolean DEFAULT true,
	"last_used_at" timestamp,
	"expires_at" timestamp,
	"created_by_user_id" integer,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "api_tokens_token_unique" UNIQUE("token")
);
--> statement-breakpoint
CREATE TABLE "bom"."bom_operations" (
	"id" serial PRIMARY KEY NOT NULL,
	"bom_id" integer NOT NULL,
	"operation_type" varchar(50) NOT NULL,
	"operation_name" varchar(255) NOT NULL,
	"sequence" integer DEFAULT 0 NOT NULL,
	"workstation" varchar(100),
	"estimated_time_minutes" integer,
	"instructions" text,
	"odoo_operation_id" integer,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "bom"."component_material_breakdown" (
	"id" serial PRIMARY KEY NOT NULL,
	"component_id" integer NOT NULL,
	"board_area_m2" numeric(10, 4),
	"board_waste_percentage" numeric(5, 2),
	"board_total_m2" numeric(10, 4),
	"edging_length_mb" numeric(10, 2),
	"edging_overage_cm" numeric(5, 2),
	"edging_total_mb" numeric(10, 2),
	"adhesive_grams_per_mb" numeric(10, 3),
	"adhesive_total_g" numeric(10, 2),
	"board_unit_price" numeric(10, 2),
	"edging_unit_price" numeric(10, 2),
	"adhesive_unit_price" numeric(10, 2),
	"board_cost" numeric(10, 2),
	"edging_cost" numeric(10, 2),
	"adhesive_cost" numeric(10, 2),
	"total_cost" numeric(10, 2),
	"calculated_at" timestamp DEFAULT now(),
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "bom"."component_templates" (
	"id" serial PRIMARY KEY NOT NULL,
	"cz1" varchar(100) NOT NULL,
	"cz2" varchar(100),
	"furniture_type" varchar(100) NOT NULL,
	"base_length" numeric(10, 2),
	"base_width" numeric(10, 2),
	"thickness" numeric(10, 2),
	"furniture_length_condition" integer,
	"furniture_width_condition" integer,
	"alternative_lengths" jsonb DEFAULT '[]'::jsonb,
	"alternative_widths" jsonb DEFAULT '[]'::jsonb,
	"plate_type" varchar(100) NOT NULL,
	"color" varchar(100) NOT NULL,
	"edge1" boolean DEFAULT false,
	"edge2" boolean DEFAULT false,
	"edge3" boolean DEFAULT false,
	"edge4" boolean DEFAULT false,
	"edging_material" varchar(100),
	"edging_pattern" varchar(10),
	"drilling_required" boolean DEFAULT false,
	"no_color_change" boolean DEFAULT false,
	"exclude_from_cutting" boolean DEFAULT false,
	"apply_by_length" boolean DEFAULT false,
	"apply_by_width" boolean DEFAULT false,
	"half_plate" boolean DEFAULT false,
	"production_category" varchar(200),
	"unit_price" numeric(10, 2),
	"warehouse_material_id" integer,
	"door" varchar(50),
	"leg" varchar(50),
	"parent_id" integer,
	"airtable_record_id" varchar(100),
	"display_order" integer DEFAULT 0,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."cut_pattern_items" (
	"id" serial PRIMARY KEY NOT NULL,
	"pattern_id" integer NOT NULL,
	"source_plan_line_id" integer,
	"component_template_id" integer,
	"item_name" varchar(255),
	"length" numeric(10, 2) NOT NULL,
	"width" numeric(10, 2) NOT NULL,
	"thickness" numeric(10, 2) DEFAULT '18',
	"board_material_id" integer,
	"edging_material_id" integer,
	"board_code" varchar(50),
	"edging_code" varchar(50),
	"color_code" varchar(50),
	"edge1" boolean DEFAULT false,
	"edge2" boolean DEFAULT false,
	"edge3" boolean DEFAULT false,
	"edge4" boolean DEFAULT false,
	"quantity_requested" integer DEFAULT 1 NOT NULL,
	"quantity_completed" integer DEFAULT 0,
	"position_metadata" jsonb,
	"status" varchar(20) DEFAULT 'zaplanowana' NOT NULL,
	"notes" text,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."cut_pattern_run_items" (
	"id" serial PRIMARY KEY NOT NULL,
	"run_id" integer NOT NULL,
	"template_item_id" integer,
	"item_name" varchar(255),
	"length" numeric(10, 2) NOT NULL,
	"width" numeric(10, 2) NOT NULL,
	"thickness" numeric(10, 2) DEFAULT '18',
	"board_material_id" integer,
	"edging_material_id" integer,
	"board_code" varchar(50),
	"edging_code" varchar(50),
	"color_code" varchar(50),
	"edge1" boolean DEFAULT false,
	"edge2" boolean DEFAULT false,
	"edge3" boolean DEFAULT false,
	"edge4" boolean DEFAULT false,
	"quantity_requested" integer DEFAULT 1 NOT NULL,
	"quantity_completed" integer DEFAULT 0,
	"position_metadata" jsonb,
	"status" varchar(20) DEFAULT 'zaplanowana' NOT NULL,
	"notes" text,
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."cut_pattern_runs" (
	"id" serial PRIMARY KEY NOT NULL,
	"run_number" varchar(50) NOT NULL,
	"template_id" integer,
	"template_code" varchar(50),
	"template_name" varchar(255),
	"plan_line_id" integer,
	"status" varchar(20) DEFAULT 'planowany' NOT NULL,
	"scheduled_at" timestamp,
	"started_at" timestamp,
	"completed_at" timestamp,
	"quantity_multiplier" numeric(10, 2) DEFAULT '1',
	"created_by" integer,
	"notes" text,
	"metadata" jsonb,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "cut_pattern_runs_run_number_unique" UNIQUE("run_number")
);
--> statement-breakpoint
CREATE TABLE "production"."cut_pattern_template_items" (
	"id" serial PRIMARY KEY NOT NULL,
	"template_id" integer NOT NULL,
	"item_name" varchar(255),
	"length" numeric(10, 2) NOT NULL,
	"width" numeric(10, 2) NOT NULL,
	"thickness" numeric(10, 2) DEFAULT '18',
	"board_material_id" integer,
	"edging_material_id" integer,
	"board_code" varchar(50),
	"edging_code" varchar(50),
	"color_code" varchar(50),
	"edge1" boolean DEFAULT false,
	"edge2" boolean DEFAULT false,
	"edge3" boolean DEFAULT false,
	"edge4" boolean DEFAULT false,
	"quantity_default" integer DEFAULT 1 NOT NULL,
	"position_metadata" jsonb,
	"notes" text,
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."cut_pattern_templates" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(50) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"board_type_code" varchar(50),
	"board_length" numeric(10, 2) NOT NULL,
	"board_width" numeric(10, 2) NOT NULL,
	"board_thickness" numeric(10, 2) DEFAULT '18',
	"kerf" numeric(10, 2) DEFAULT '4',
	"image_url" text,
	"opis" text,
	"usage_count" integer DEFAULT 0,
	"last_used_at" timestamp,
	"created_by" integer,
	"notes" text,
	"metadata" jsonb,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "cut_pattern_templates_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."cut_patterns" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(50) NOT NULL,
	"board_type_code" varchar(50),
	"board_length" numeric(10, 2) NOT NULL,
	"board_width" numeric(10, 2) NOT NULL,
	"board_thickness" numeric(10, 2) DEFAULT '18',
	"kerf" numeric(10, 2) DEFAULT '4',
	"image_url" text,
	"opis" text,
	"status" varchar(20) DEFAULT 'planowany' NOT NULL,
	"scheduled_at" timestamp,
	"started_at" timestamp,
	"completed_at" timestamp,
	"created_by" integer,
	"notes" text,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "cut_patterns_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "catalog"."description_template_categories" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"description" text,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "catalog"."description_templates" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"category_id" integer,
	"template_type" varchar(50) NOT NULL,
	"content_doc" jsonb,
	"html_content" text NOT NULL,
	"variables" jsonb,
	"created_by" integer,
	"is_global" boolean DEFAULT false,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "error_logs" (
	"id" serial PRIMARY KEY NOT NULL,
	"type" varchar(50) NOT NULL,
	"message" text NOT NULL,
	"stack_trace" text,
	"context" jsonb,
	"severity" varchar(20) DEFAULT 'error' NOT NULL,
	"timestamp" timestamp DEFAULT now() NOT NULL,
	"resolved_at" timestamp,
	"resolved_by" integer,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "file_storage_settings" (
	"id" serial PRIMARY KEY NOT NULL,
	"provider" varchar(20) DEFAULT 'local' NOT NULL,
	"host" text,
	"port" integer DEFAULT 22,
	"username" text,
	"base_url" text,
	"path_prefix" text DEFAULT '/OMS',
	"is_active" boolean DEFAULT false,
	"last_connection_test" timestamp,
	"connection_status" varchar(20) DEFAULT 'unknown',
	"last_error" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "product_creator"."formula_presets" (
	"id" serial PRIMARY KEY NOT NULL,
	"formula" text NOT NULL,
	"label" text,
	"type" varchar(10) NOT NULL,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "warehouse"."material_accessory_links" (
	"id" serial PRIMARY KEY NOT NULL,
	"material_id" integer NOT NULL,
	"accessory_id" integer NOT NULL,
	"quantity" integer DEFAULT 1,
	"notes" text,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "warehouse"."material_groups" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"code" text NOT NULL,
	"category" text,
	"description" text,
	"gallery" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"primary_image" text,
	"display_order" integer DEFAULT 0 NOT NULL,
	"is_active" boolean DEFAULT true NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "material_groups_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "warehouse"."material_media" (
	"id" serial PRIMARY KEY NOT NULL,
	"material_id" integer NOT NULL,
	"url" text NOT NULL,
	"filename" text NOT NULL,
	"alt_text" text,
	"caption" text,
	"display_order" integer DEFAULT 0 NOT NULL,
	"is_primary" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "warehouse"."materials" (
	"id" serial PRIMARY KEY NOT NULL,
	"group_id" integer,
	"name" text NOT NULL,
	"internal_code" text NOT NULL,
	"supplier_code" text,
	"description" text,
	"specifications" jsonb,
	"unit_of_measure" varchar(20) DEFAULT 'szt',
	"price" numeric(10, 2),
	"gallery" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"primary_image_url" text,
	"display_order" integer DEFAULT 0 NOT NULL,
	"is_active" boolean DEFAULT true NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "materials_internal_code_unique" UNIQUE("internal_code")
);
--> statement-breakpoint
CREATE TABLE "catalog"."matrix_accessories" (
	"id" serial PRIMARY KEY NOT NULL,
	"matrix_id" integer NOT NULL,
	"group_id" integer NOT NULL,
	"display_order" integer DEFAULT 0 NOT NULL,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "odoo_config" (
	"id" serial PRIMARY KEY NOT NULL,
	"url" text NOT NULL,
	"user_url" text,
	"oms_domain" text DEFAULT 'alp-oms.replit.app',
	"database" varchar(255) NOT NULL,
	"username" varchar(255) NOT NULL,
	"is_active" boolean DEFAULT true,
	"auto_confirm_orders" boolean DEFAULT false,
	"sync_interval_minutes" integer DEFAULT 3,
	"last_sync_at" timestamp,
	"last_sync_status" varchar(50),
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "odoo_sync_logs" (
	"id" serial PRIMARY KEY NOT NULL,
	"queue_id" integer,
	"order_number" integer,
	"operation" varchar(20) NOT NULL,
	"status" varchar(50) NOT NULL,
	"message" text,
	"error_details" jsonb,
	"request_payload" jsonb,
	"response_data" jsonb,
	"duration" integer,
	"odoo_order_id" integer,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "odoo_sync_queue" (
	"id" serial PRIMARY KEY NOT NULL,
	"order_number" integer NOT NULL,
	"source" varchar(20) NOT NULL,
	"operation" varchar(20) DEFAULT 'create' NOT NULL,
	"status" varchar(50) DEFAULT 'pending' NOT NULL,
	"attempts" integer DEFAULT 0,
	"max_attempts" integer DEFAULT 3,
	"last_error" text,
	"odoo_order_id" integer,
	"scheduled_at" timestamp DEFAULT now(),
	"processed_at" timestamp,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "order_changes" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"order_id" varchar NOT NULL,
	"order_number" text,
	"source" text NOT NULL,
	"change_type" text NOT NULL,
	"field_changed" text,
	"old_value" text,
	"new_value" text,
	"detected_at" timestamp DEFAULT now(),
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "password_reset_tokens" (
	"id" serial PRIMARY KEY NOT NULL,
	"user_id" integer NOT NULL,
	"token" varchar(255) NOT NULL,
	"expires_at" timestamp NOT NULL,
	"used" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now(),
	CONSTRAINT "password_reset_tokens_token_unique" UNIQUE("token")
);
--> statement-breakpoint
CREATE TABLE "catalog"."product_addon_assignments" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"addon_id" integer NOT NULL,
	"sort_order" integer DEFAULT 0,
	"custom_attributes" jsonb,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "catalog"."product_addons" (
	"id" serial PRIMARY KEY NOT NULL,
	"addon_type" varchar(50) NOT NULL,
	"name" text NOT NULL,
	"code" varchar(100),
	"description" text,
	"html_template" text,
	"attributes" jsonb,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "bom"."product_boms" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"name" varchar(255) NOT NULL,
	"version" varchar(50) DEFAULT '1.0',
	"bom_type" varchar(50) DEFAULT 'final_product',
	"production_location" varchar(100) DEFAULT 'internal',
	"estimated_production_time_minutes" integer,
	"notes" text,
	"is_active" boolean DEFAULT true,
	"is_approved" boolean DEFAULT false,
	"approved_by" integer,
	"approved_at" timestamp,
	"odoo_bom_id" integer,
	"odoo_synced_at" timestamp,
	"odoo_sync_status" varchar(50),
	"odoo_sync_error" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "product_boms_product_id_unique" UNIQUE("product_id")
);
--> statement-breakpoint
CREATE TABLE "bom"."product_component_metrics" (
	"id" serial PRIMARY KEY NOT NULL,
	"component_id" integer NOT NULL,
	"board_area_m2" numeric(10, 6),
	"edging_length_m" numeric(10, 3),
	"glue_amount_g" numeric(10, 2),
	"board_material_id" integer,
	"edging_material_id" integer,
	"glue_material_id" integer,
	"board_cost" numeric(10, 2),
	"edging_cost" numeric(10, 2),
	"glue_cost" numeric(10, 2),
	"total_material_cost" numeric(10, 2),
	"calculated_at" timestamp DEFAULT now(),
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "product_component_metrics_component_id_unique" UNIQUE("component_id")
);
--> statement-breakpoint
CREATE TABLE "bom"."product_components" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"template_id" integer,
	"generated_name" varchar(255) NOT NULL,
	"component_type" varchar(50) NOT NULL,
	"calculated_length" numeric(10, 2),
	"calculated_width" numeric(10, 2),
	"thickness" numeric(10, 2),
	"color" varchar(50),
	"board_type" varchar(50),
	"drilling_pattern" varchar(50),
	"edging_pattern" varchar(10),
	"edging_material" varchar(100),
	"edge1" boolean DEFAULT false,
	"edge2" boolean DEFAULT false,
	"edge3" boolean DEFAULT false,
	"edge4" boolean DEFAULT false,
	"warehouse_material_id" integer,
	"quantity" numeric(10, 3) DEFAULT '1' NOT NULL,
	"unit_of_measure" varchar(20) DEFAULT 'pcs',
	"production_notes" text,
	"supplier_notes" text,
	"position_in_bom" integer DEFAULT 0,
	"is_mandatory" boolean DEFAULT true,
	"visualization_url" text,
	"is_damaged" boolean DEFAULT false,
	"damage_notes" text,
	"damaged_at" timestamp,
	"damaged_by" integer,
	"odoo_product_id" integer,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "product_creator"."dictionaries" (
	"id" serial PRIMARY KEY NOT NULL,
	"dictionary_type" varchar(50) NOT NULL,
	"code" varchar(100) NOT NULL,
	"name" text NOT NULL,
	"readable_name" text,
	"short_name" text,
	"description" text,
	"sort_order" integer DEFAULT 0,
	"category" text,
	"image_url" text,
	"color" varchar(7),
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "catalog"."product_description_templates" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"template_id" integer NOT NULL,
	"render_config" jsonb,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "catalog"."product_images" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"url" text NOT NULL,
	"filename" text NOT NULL,
	"image_type" varchar(30) NOT NULL,
	"alt_text" text,
	"title" text,
	"tags" text[] DEFAULT ARRAY[]::text[],
	"sort_order" integer DEFAULT 0,
	"is_primary" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "product_creator"."product_matrices" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"name_prefix" text,
	"name_suffix" text,
	"product_type" text,
	"doors" text,
	"legs" text,
	"material" text,
	"lengths" numeric(10, 2)[] DEFAULT ARRAY[]::numeric[] NOT NULL,
	"widths" numeric(10, 2)[] DEFAULT ARRAY[]::numeric[] NOT NULL,
	"heights" numeric(10, 2)[] DEFAULT ARRAY[]::numeric[] NOT NULL,
	"product_groups" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"price_modifiers" numeric(10, 2)[] DEFAULT ARRAY[]::numeric[] NOT NULL,
	"price_modifier_types" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"colors" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"color_images" jsonb DEFAULT '{}'::jsonb NOT NULL,
	"selected_colors" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"color_last_generated" jsonb DEFAULT '{}'::jsonb NOT NULL,
	"color_options" jsonb DEFAULT '{}'::jsonb NOT NULL,
	"description_doc" jsonb,
	"description_html" text,
	"ai_prompt" text,
	"use_ai_generation" boolean DEFAULT false,
	"template_id" integer,
	"ai_config" jsonb DEFAULT '{}'::jsonb,
	"has_warranty" boolean DEFAULT true,
	"default_price" numeric(10, 2),
	"created_by" integer,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "catalog"."product_platform_data" (
	"id" serial PRIMARY KEY NOT NULL,
	"product_id" integer NOT NULL,
	"platform" varchar(20) NOT NULL,
	"custom_title" text,
	"category_id" text,
	"category_name" text,
	"description" text,
	"inherits_shared_description" boolean DEFAULT true,
	"custom_price" numeric(10, 2),
	"custom_attributes" jsonb,
	"is_published" boolean DEFAULT false,
	"published_at" timestamp,
	"external_id" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "product_creator"."product_sets" (
	"id" serial PRIMARY KEY NOT NULL,
	"set_matrix_id" integer,
	"sku" text NOT NULL,
	"title" text NOT NULL,
	"short_description" text,
	"full_description" text,
	"color" text,
	"depth" numeric(10, 2),
	"panel_count" integer,
	"hook_length" numeric(10, 2),
	"base_price" numeric(10, 2),
	"calculated_price" numeric(10, 2),
	"images" text[] DEFAULT ARRAY[]::text[],
	"generated_from_matrix" boolean DEFAULT false,
	"combination_key" text,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "product_sets_sku_unique" UNIQUE("sku")
);
--> statement-breakpoint
CREATE TABLE "production"."production_carrier_groups" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(50) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"default_capacity" numeric(10, 2),
	"capacity_unit" varchar(50),
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_carrier_groups_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."production_carriers" (
	"id" serial PRIMARY KEY NOT NULL,
	"carrier_group_id" integer NOT NULL,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"barcode" varchar(100),
	"status" varchar(20) DEFAULT 'available' NOT NULL,
	"capacity" numeric(10, 2),
	"capacity_unit" varchar(50),
	"current_load" numeric(10, 2) DEFAULT '0',
	"dimensions" jsonb,
	"weight" numeric(10, 2),
	"current_location_id" integer,
	"default_location_id" integer,
	"last_maintenance_date" timestamp,
	"next_maintenance_date" timestamp,
	"notes" text,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_component_batches" (
	"id" serial PRIMARY KEY NOT NULL,
	"batch_number" varchar(100) NOT NULL,
	"plan_line_id" integer NOT NULL,
	"production_order_id" integer,
	"work_order_id" integer,
	"color" varchar(100),
	"edging_pattern" varchar(100),
	"drilling_pattern" varchar(100),
	"board_type" varchar(50),
	"component_type" varchar(100),
	"quantity" integer NOT NULL,
	"quantity_completed" integer DEFAULT 0,
	"quantity_rejected" integer DEFAULT 0,
	"current_station_id" integer,
	"status" varchar(30) DEFAULT 'waiting' NOT NULL,
	"routing_id" integer,
	"current_operation_sequence" integer,
	"material_consumption" jsonb,
	"notes" text,
	"metadata" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_component_batches_batch_number_unique" UNIQUE("batch_number")
);
--> statement-breakpoint
CREATE TABLE "production"."production_location_groups" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(50) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"location_type" varchar(50) NOT NULL,
	"allows_sublocations" boolean DEFAULT true,
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_location_groups_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."production_locations" (
	"id" serial PRIMARY KEY NOT NULL,
	"location_group_id" integer NOT NULL,
	"parent_id" integer,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"path" text,
	"level" integer DEFAULT 0,
	"barcode" varchar(100),
	"capacity" numeric(10, 2),
	"capacity_unit" varchar(50),
	"current_load" numeric(10, 2) DEFAULT '0',
	"dimensions" jsonb,
	"status" varchar(20) DEFAULT 'active' NOT NULL,
	"allows_storage" boolean DEFAULT true,
	"is_active" boolean DEFAULT true,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_locations_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."production_material_consumption_norms" (
	"id" serial PRIMARY KEY NOT NULL,
	"material_type" varchar(50) NOT NULL,
	"material_category" varchar(50),
	"waste_percentage" numeric(5, 2),
	"edge_overage_cm" numeric(5, 2),
	"consumption_per_unit" numeric(10, 3),
	"input_unit" varchar(20) NOT NULL,
	"output_unit" varchar(20) NOT NULL,
	"is_active" boolean DEFAULT true,
	"description" text,
	"notes" text,
	"metadata" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_material_movements" (
	"id" serial PRIMARY KEY NOT NULL,
	"movement_date" timestamp DEFAULT now() NOT NULL,
	"movement_batch_id" varchar(100),
	"material_type" varchar(30) NOT NULL,
	"material_code" varchar(100) NOT NULL,
	"material_name" varchar(255),
	"quantity" numeric(10, 2) NOT NULL,
	"quantity_rejected" numeric(10, 2) DEFAULT '0',
	"unit" varchar(50) DEFAULT 'szt' NOT NULL,
	"source_location_id" integer,
	"target_location_id" integer,
	"carrier_id" integer,
	"production_order_id" integer,
	"work_order_id" integer,
	"work_center_id" integer,
	"routing_operation_id" integer,
	"operator_id" integer,
	"scanned_barcode" varchar(255),
	"scan_method" varchar(20),
	"status" varchar(20) DEFAULT 'planned' NOT NULL,
	"movement_type" varchar(30),
	"notes" text,
	"metadata" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_norm_groups" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(50) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"unit_of_measure" varchar(50),
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_norm_groups_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."production_norms" (
	"id" serial PRIMARY KEY NOT NULL,
	"norm_group_id" integer NOT NULL,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"default_value" numeric(10, 2) NOT NULL,
	"min_value" numeric(10, 2),
	"max_value" numeric(10, 2),
	"tolerance" numeric(5, 2),
	"unit_of_measure" varchar(50),
	"applicable_to" jsonb,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_order_logs" (
	"id" serial PRIMARY KEY NOT NULL,
	"production_order_id" integer,
	"work_order_id" integer,
	"event_type" varchar(50) NOT NULL,
	"event_data" jsonb,
	"message" text,
	"user_id" integer,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_order_materials" (
	"id" serial PRIMARY KEY NOT NULL,
	"production_order_id" integer NOT NULL,
	"material_id" integer,
	"product_id" integer,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"quantity_planned" numeric(10, 2) NOT NULL,
	"quantity_reserved" numeric(10, 2) DEFAULT '0',
	"quantity_issued" numeric(10, 2) DEFAULT '0',
	"quantity_consumed" numeric(10, 2) DEFAULT '0',
	"quantity_returned" numeric(10, 2) DEFAULT '0',
	"unit_of_measure" varchar(50) NOT NULL,
	"work_order_id" integer,
	"location_id" integer,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_orders" (
	"id" serial PRIMARY KEY NOT NULL,
	"order_number" varchar(100) NOT NULL,
	"product_id" integer NOT NULL,
	"bom_id" integer,
	"routing_id" integer,
	"status" varchar(20) DEFAULT 'draft' NOT NULL,
	"workflow_stage" varchar(30),
	"priority" varchar(20) DEFAULT 'normal' NOT NULL,
	"quantity_planned" numeric(10, 2) NOT NULL,
	"quantity_produced" numeric(10, 2) DEFAULT '0',
	"quantity_scrap" numeric(10, 2) DEFAULT '0',
	"unit_of_measure" varchar(50) DEFAULT 'szt' NOT NULL,
	"planned_start_date" timestamp,
	"planned_end_date" timestamp,
	"actual_start_date" timestamp,
	"actual_end_date" timestamp,
	"workflow_stage_updated_at" timestamp,
	"workflow_stage_updated_by" integer,
	"responsible_user_id" integer,
	"source_order_number" varchar(100),
	"carrier_requirements" jsonb,
	"location_id" integer,
	"parameters" jsonb,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_orders_order_number_unique" UNIQUE("order_number")
);
--> statement-breakpoint
CREATE TABLE "production"."production_plan_lines" (
	"id" serial PRIMARY KEY NOT NULL,
	"plan_id" integer NOT NULL,
	"product_id" integer NOT NULL,
	"quantity" integer NOT NULL,
	"source_type" varchar(30),
	"source_id" integer,
	"source_reference" varchar(255),
	"production_order_id" integer,
	"routing_id" integer,
	"routing_override" jsonb,
	"bom_id" integer,
	"planned_start_date" timestamp,
	"planned_end_date" timestamp,
	"status" varchar(30) DEFAULT 'pending' NOT NULL,
	"sequence" integer,
	"notes" text,
	"metadata" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."plan_name_counters" (
	"id" serial PRIMARY KEY NOT NULL,
	"template_id" integer NOT NULL,
	"counter_date" varchar(10) NOT NULL,
	"next_value" integer DEFAULT 1 NOT NULL,
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."plan_name_templates" (
	"id" serial PRIMARY KEY NOT NULL,
	"template_name" varchar(255) NOT NULL,
	"pattern" varchar(500) NOT NULL,
	"description" text,
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "plan_name_templates_template_name_unique" UNIQUE("template_name")
);
--> statement-breakpoint
CREATE TABLE "production"."production_plans" (
	"id" serial PRIMARY KEY NOT NULL,
	"plan_number" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"name_template_id" integer,
	"name_sequence" integer,
	"name_generated_at" timestamp,
	"name_generation_meta" jsonb,
	"planned_start_date" timestamp,
	"planned_end_date" timestamp,
	"actual_start_date" timestamp,
	"actual_end_date" timestamp,
	"status" varchar(30) DEFAULT 'draft' NOT NULL,
	"priority" varchar(20) DEFAULT 'normal',
	"notes" text,
	"metadata" jsonb,
	"created_by" integer,
	"approved_by" integer,
	"approved_at" timestamp,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_plans_plan_number_unique" UNIQUE("plan_number")
);
--> statement-breakpoint
CREATE TABLE "production"."production_product_group_items" (
	"id" serial PRIMARY KEY NOT NULL,
	"group_id" integer NOT NULL,
	"product_id" integer NOT NULL,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_product_groups" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" varchar(255) NOT NULL,
	"color_hex" varchar(7),
	"description" text,
	"is_active" boolean DEFAULT true,
	"sort_order" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_routing_branches" (
	"id" serial PRIMARY KEY NOT NULL,
	"routing_operation_id" integer NOT NULL,
	"branch_name" varchar(100) NOT NULL,
	"branch_code" varchar(50) NOT NULL,
	"allocation_percentage" numeric(5, 2) NOT NULL,
	"next_operation_id" integer,
	"conditions" jsonb,
	"sequence" integer,
	"is_active" boolean DEFAULT true,
	"notes" text,
	"metadata" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_routing_operations" (
	"id" serial PRIMARY KEY NOT NULL,
	"routing_id" integer NOT NULL,
	"sequence" integer NOT NULL,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"work_center_id" integer,
	"norm_id" integer,
	"estimated_time" numeric(10, 2),
	"setup_time" numeric(10, 2),
	"allow_parallel" boolean DEFAULT false,
	"prerequisite_operation_ids" jsonb,
	"instructions" text,
	"quality_check_required" boolean DEFAULT false,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_routings" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"product_id" integer,
	"product_type" varchar(100),
	"default_work_center_id" integer,
	"total_estimated_time" numeric(10, 2),
	"is_active" boolean DEFAULT true,
	"version" integer DEFAULT 1,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_routings_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."production_settings" (
	"id" serial PRIMARY KEY NOT NULL,
	"key" varchar(100) NOT NULL,
	"value" text NOT NULL,
	"value_type" varchar(20) DEFAULT 'string' NOT NULL,
	"description" text,
	"category" varchar(50) DEFAULT 'general' NOT NULL,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_settings_key_unique" UNIQUE("key")
);
--> statement-breakpoint
CREATE TABLE "production"."production_tasks" (
	"id" serial PRIMARY KEY NOT NULL,
	"formatka_reference" varchar(255) NOT NULL,
	"length" numeric(10, 2) NOT NULL,
	"width" numeric(10, 2) NOT NULL,
	"thickness" numeric(10, 2) DEFAULT '18',
	"board_code" varchar(50),
	"color_code" varchar(50),
	"quantity" integer DEFAULT 1 NOT NULL,
	"priority" integer DEFAULT 0,
	"required_by" timestamp,
	"source_type" varchar(50),
	"source_reference" varchar(255),
	"status" varchar(20) DEFAULT 'oczekuje' NOT NULL,
	"assigned_pattern_id" integer,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "production"."production_work_centers" (
	"id" serial PRIMARY KEY NOT NULL,
	"code" varchar(100) NOT NULL,
	"name" varchar(255) NOT NULL,
	"description" text,
	"location_id" integer,
	"capabilities" text[] DEFAULT ARRAY[]::text[],
	"status" varchar(20) DEFAULT 'available' NOT NULL,
	"throughput_per_hour" numeric(10, 2),
	"throughput_unit" varchar(50),
	"operating_cost_per_hour" numeric(10, 2),
	"shift_calendar" jsonb,
	"oee_target" numeric(5, 2),
	"current_oee" numeric(5, 2),
	"is_active" boolean DEFAULT true,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_work_centers_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "production"."production_work_orders" (
	"id" serial PRIMARY KEY NOT NULL,
	"work_order_number" varchar(100) NOT NULL,
	"production_order_id" integer NOT NULL,
	"routing_operation_id" integer,
	"work_center_id" integer,
	"sequence" integer NOT NULL,
	"status" varchar(20) DEFAULT 'pending' NOT NULL,
	"operator_user_id" integer,
	"quantity_planned" numeric(10, 2) NOT NULL,
	"quantity_produced" numeric(10, 2) DEFAULT '0',
	"quantity_scrap" numeric(10, 2) DEFAULT '0',
	"estimated_duration" numeric(10, 2),
	"actual_duration" numeric(10, 2),
	"scheduled_start_time" timestamp,
	"scheduled_end_time" timestamp,
	"actual_start_time" timestamp,
	"actual_end_time" timestamp,
	"carrier_id" integer,
	"location_id" integer,
	"quality_check_passed" boolean,
	"quality_check_notes" text,
	"notes" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "production_work_orders_work_order_number_unique" UNIQUE("work_order_number")
);
--> statement-breakpoint
CREATE TABLE "catalog"."products" (
	"id" serial PRIMARY KEY NOT NULL,
	"sku" varchar(100) NOT NULL,
	"sku_airtable" varchar(50),
	"title" text NOT NULL,
	"short_description" text,
	"long_description_html" text,
	"long_description_doc" jsonb,
	"gallery" jsonb,
	"length" numeric(10, 2),
	"width" numeric(10, 2),
	"height" numeric(10, 2),
	"weight" numeric(10, 2),
	"color" text,
	"color_options" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"material" text,
	"product_type" text,
	"product_group" text,
	"doors" text,
	"legs" text,
	"base_price" numeric(10, 2),
	"currency" varchar(3) DEFAULT 'PLN',
	"is_active" boolean DEFAULT true,
	"matrix_id" integer,
	"combination_key" text,
	"generated_from_matrix" boolean DEFAULT false,
	"odoo_product_id" integer,
	"odoo_exported_at" timestamp,
	"odoo_export_error" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "products_sku_unique" UNIQUE("sku")
);
--> statement-breakpoint
CREATE TABLE "sessions" (
	"sid" varchar PRIMARY KEY NOT NULL,
	"sess" jsonb NOT NULL,
	"expire" timestamp NOT NULL
);
--> statement-breakpoint
CREATE TABLE "product_creator"."set_matrices" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"name_prefix" text,
	"name_suffix" text,
	"product_group" text,
	"length" text,
	"width" text,
	"height" text,
	"doors" text,
	"legs" text,
	"image_url" text,
	"default_depth" numeric(10, 2),
	"hook_length" numeric(10, 2),
	"components" jsonb DEFAULT '[]'::jsonb NOT NULL,
	"base_price_modifier" numeric(10, 2) DEFAULT '0',
	"price_modifier_type" text DEFAULT 'percent',
	"colors" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"color_images" jsonb DEFAULT '{}'::jsonb NOT NULL,
	"selected_colors" text[] DEFAULT ARRAY[]::text[] NOT NULL,
	"color_options" jsonb DEFAULT '{}'::jsonb NOT NULL,
	"component_product_overrides" jsonb DEFAULT '{}'::jsonb NOT NULL,
	"use_ai_generation" boolean DEFAULT false,
	"ai_prompt" text,
	"description_template_id" integer,
	"use_enhanced_description" boolean DEFAULT false,
	"is_active" boolean DEFAULT true,
	"last_generation_status" varchar(20),
	"last_generation_at" timestamp,
	"last_missing_components" jsonb,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "product_creator"."set_product_links" (
	"id" serial PRIMARY KEY NOT NULL,
	"set_id" integer NOT NULL,
	"product_id" integer,
	"component_type" text NOT NULL,
	"quantity" integer DEFAULT 1,
	"position" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "shoper_config" (
	"id" serial PRIMARY KEY NOT NULL,
	"orders_url" text DEFAULT 'https://alpmeb.pl/admin/orders/' NOT NULL,
	"products_url" text DEFAULT 'https://sklep378098.shoparena.pl/admin/products/edit/id/' NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "warehouse"."stock_panel_events" (
	"id" serial PRIMARY KEY NOT NULL,
	"stock_panel_id" integer,
	"source_type" varchar(50) NOT NULL,
	"source_reference" varchar(255),
	"delta_quantity" integer NOT NULL,
	"notes" text,
	"created_by" integer,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "warehouse"."stock_panels" (
	"id" serial PRIMARY KEY NOT NULL,
	"generated_name" varchar(255) NOT NULL,
	"cz1" varchar(100),
	"cz2" varchar(100),
	"furniture_type" varchar(100),
	"length" numeric(10, 2) NOT NULL,
	"width" numeric(10, 2) NOT NULL,
	"thickness" numeric(10, 2) DEFAULT '18' NOT NULL,
	"board_code" varchar(50),
	"edging_code" varchar(50),
	"color_code" varchar(50),
	"edge1" boolean DEFAULT false,
	"edge2" boolean DEFAULT false,
	"edge3" boolean DEFAULT false,
	"edge4" boolean DEFAULT false,
	"is_drilled" boolean DEFAULT false NOT NULL,
	"is_edged" boolean DEFAULT false NOT NULL,
	"source" varchar(50) DEFAULT 'stock' NOT NULL,
	"source_reference" varchar(255),
	"quantity" integer DEFAULT 0 NOT NULL,
	"location" varchar(100),
	"notes" text,
	"image_url" text,
	"is_active" boolean DEFAULT true NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "sync_health_stats" (
	"id" serial PRIMARY KEY NOT NULL,
	"sync_type" varchar(50) NOT NULL,
	"last_sync_at" timestamp,
	"last_success_at" timestamp,
	"last_failure_at" timestamp,
	"success_count_24h" integer DEFAULT 0,
	"failure_count_24h" integer DEFAULT 0,
	"total_synced_24h" integer DEFAULT 0,
	"health_status" varchar(20) DEFAULT 'unknown' NOT NULL,
	"consecutive_failures" integer DEFAULT 0,
	"last_error" text,
	"last_error_context" jsonb,
	"queue_pending" integer DEFAULT 0,
	"queue_failed" integer DEFAULT 0,
	"last_auto_heal_at" timestamp,
	"auto_heal_count" integer DEFAULT 0,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "sync_settings" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"auto_refresh_enabled" boolean DEFAULT true,
	"refresh_interval_minutes" text DEFAULT '3',
	"last_sync_at" timestamp,
	"full_sync_enabled" boolean DEFAULT true,
	"full_sync_window_hours" text DEFAULT '2',
	"shoper_auto_refresh_enabled" boolean DEFAULT true,
	"shoper_refresh_interval_minutes" text DEFAULT '5',
	"last_shoper_sync_at" timestamp,
	"shoper_full_sync_enabled" boolean DEFAULT true,
	"shoper_full_sync_window_hours" text DEFAULT '2',
	"nightly_sync_enabled" boolean DEFAULT true,
	"nightly_sync_hour" integer DEFAULT 2,
	"nightly_sync_window_days" integer DEFAULT 7,
	"last_nightly_sync_at" timestamp,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "user_saved_filters" (
	"id" serial PRIMARY KEY NOT NULL,
	"user_id" integer NOT NULL,
	"context" varchar(50) NOT NULL,
	"name" varchar(255) NOT NULL,
	"filter_data" jsonb NOT NULL,
	"is_last_used" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "users" (
	"id" serial PRIMARY KEY NOT NULL,
	"username" varchar(255) NOT NULL,
	"email" varchar(255) NOT NULL,
	"password" text NOT NULL,
	"first_name" varchar(255),
	"last_name" varchar(255),
	"role" varchar(50) DEFAULT 'user' NOT NULL,
	"permissions" jsonb DEFAULT '[]'::jsonb,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "users_username_unique" UNIQUE("username"),
	CONSTRAINT "users_email_unique" UNIQUE("email")
);
--> statement-breakpoint
CREATE TABLE "warehouse"."categories" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" text NOT NULL,
	"code" text NOT NULL,
	"icon" text DEFAULT 'Box',
	"icon_color" text DEFAULT 'text-gray-600/70',
	"description" text,
	"display_order" integer DEFAULT 0 NOT NULL,
	"is_active" boolean DEFAULT true NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "categories_code_unique" UNIQUE("code")
);
--> statement-breakpoint
CREATE TABLE "webhook_configs" (
	"id" serial PRIMARY KEY NOT NULL,
	"name" varchar(255) NOT NULL,
	"url" text NOT NULL,
	"secret" text,
	"events" jsonb DEFAULT '[]'::jsonb,
	"is_active" boolean DEFAULT true,
	"retry_attempts" integer DEFAULT 3,
	"last_triggered_at" timestamp,
	"created_by" integer,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "webhook_logs" (
	"id" serial PRIMARY KEY NOT NULL,
	"webhook_id" integer,
	"event" varchar(100) NOT NULL,
	"payload" jsonb,
	"status_code" integer,
	"response_body" text,
	"attempt_number" integer DEFAULT 1,
	"success" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
ALTER TABLE "catalog"."accessories" ADD CONSTRAINT "accessories_group_id_accessory_groups_id_fk" FOREIGN KEY ("group_id") REFERENCES "catalog"."accessory_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."addon_images" ADD CONSTRAINT "addon_images_addon_id_product_addons_id_fk" FOREIGN KEY ("addon_id") REFERENCES "catalog"."product_addons"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."ai_generation_requests" ADD CONSTRAINT "ai_generation_requests_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."ai_generation_requests" ADD CONSTRAINT "ai_generation_requests_template_id_description_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "catalog"."description_templates"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."ai_generation_requests" ADD CONSTRAINT "ai_generation_requests_created_by_users_id_fk" FOREIGN KEY ("created_by") REFERENCES "public"."users"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "api_request_logs" ADD CONSTRAINT "api_request_logs_token_id_api_tokens_id_fk" FOREIGN KEY ("token_id") REFERENCES "public"."api_tokens"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "api_tokens" ADD CONSTRAINT "api_tokens_created_by_user_id_users_id_fk" FOREIGN KEY ("created_by_user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "bom"."bom_operations" ADD CONSTRAINT "bom_operations_bom_id_product_boms_id_fk" FOREIGN KEY ("bom_id") REFERENCES "bom"."product_boms"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "bom"."component_material_breakdown" ADD CONSTRAINT "component_material_breakdown_component_id_product_components_id_fk" FOREIGN KEY ("component_id") REFERENCES "bom"."product_components"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "bom"."component_templates" ADD CONSTRAINT "component_templates_parent_id_component_templates_id_fk" FOREIGN KEY ("parent_id") REFERENCES "bom"."component_templates"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_items" ADD CONSTRAINT "cut_pattern_items_pattern_id_cut_patterns_id_fk" FOREIGN KEY ("pattern_id") REFERENCES "production"."cut_patterns"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_items" ADD CONSTRAINT "cut_pattern_items_source_plan_line_id_production_plan_lines_id_fk" FOREIGN KEY ("source_plan_line_id") REFERENCES "production"."production_plan_lines"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_items" ADD CONSTRAINT "cut_pattern_items_board_material_id_materials_id_fk" FOREIGN KEY ("board_material_id") REFERENCES "warehouse"."materials"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_items" ADD CONSTRAINT "cut_pattern_items_edging_material_id_materials_id_fk" FOREIGN KEY ("edging_material_id") REFERENCES "warehouse"."materials"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_run_items" ADD CONSTRAINT "cut_pattern_run_items_run_id_cut_pattern_runs_id_fk" FOREIGN KEY ("run_id") REFERENCES "production"."cut_pattern_runs"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_run_items" ADD CONSTRAINT "cut_pattern_run_items_board_material_id_materials_id_fk" FOREIGN KEY ("board_material_id") REFERENCES "warehouse"."materials"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_run_items" ADD CONSTRAINT "cut_pattern_run_items_edging_material_id_materials_id_fk" FOREIGN KEY ("edging_material_id") REFERENCES "warehouse"."materials"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_runs" ADD CONSTRAINT "cut_pattern_runs_template_id_cut_pattern_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "production"."cut_pattern_templates"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_runs" ADD CONSTRAINT "cut_pattern_runs_plan_line_id_production_plan_lines_id_fk" FOREIGN KEY ("plan_line_id") REFERENCES "production"."production_plan_lines"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_template_items" ADD CONSTRAINT "cut_pattern_template_items_template_id_cut_pattern_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "production"."cut_pattern_templates"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_template_items" ADD CONSTRAINT "cut_pattern_template_items_board_material_id_materials_id_fk" FOREIGN KEY ("board_material_id") REFERENCES "warehouse"."materials"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."cut_pattern_template_items" ADD CONSTRAINT "cut_pattern_template_items_edging_material_id_materials_id_fk" FOREIGN KEY ("edging_material_id") REFERENCES "warehouse"."materials"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."description_templates" ADD CONSTRAINT "description_templates_category_id_description_template_categories_id_fk" FOREIGN KEY ("category_id") REFERENCES "catalog"."description_template_categories"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."description_templates" ADD CONSTRAINT "description_templates_created_by_users_id_fk" FOREIGN KEY ("created_by") REFERENCES "public"."users"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "warehouse"."material_accessory_links" ADD CONSTRAINT "material_accessory_links_material_id_materials_id_fk" FOREIGN KEY ("material_id") REFERENCES "warehouse"."materials"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "warehouse"."material_media" ADD CONSTRAINT "material_media_material_id_materials_id_fk" FOREIGN KEY ("material_id") REFERENCES "warehouse"."materials"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "warehouse"."materials" ADD CONSTRAINT "materials_group_id_material_groups_id_fk" FOREIGN KEY ("group_id") REFERENCES "warehouse"."material_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."matrix_accessories" ADD CONSTRAINT "matrix_accessories_matrix_id_product_matrices_id_fk" FOREIGN KEY ("matrix_id") REFERENCES "product_creator"."product_matrices"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."matrix_accessories" ADD CONSTRAINT "matrix_accessories_group_id_accessory_groups_id_fk" FOREIGN KEY ("group_id") REFERENCES "catalog"."accessory_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "odoo_sync_logs" ADD CONSTRAINT "odoo_sync_logs_queue_id_odoo_sync_queue_id_fk" FOREIGN KEY ("queue_id") REFERENCES "public"."odoo_sync_queue"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "password_reset_tokens" ADD CONSTRAINT "password_reset_tokens_user_id_users_id_fk" FOREIGN KEY ("user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."product_addon_assignments" ADD CONSTRAINT "product_addon_assignments_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."product_addon_assignments" ADD CONSTRAINT "product_addon_assignments_addon_id_product_addons_id_fk" FOREIGN KEY ("addon_id") REFERENCES "catalog"."product_addons"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "bom"."product_component_metrics" ADD CONSTRAINT "product_component_metrics_component_id_product_components_id_fk" FOREIGN KEY ("component_id") REFERENCES "bom"."product_components"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "bom"."product_components" ADD CONSTRAINT "product_components_template_id_component_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "bom"."component_templates"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."product_description_templates" ADD CONSTRAINT "product_description_templates_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."product_description_templates" ADD CONSTRAINT "product_description_templates_template_id_description_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "catalog"."description_templates"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."product_images" ADD CONSTRAINT "product_images_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "product_creator"."product_matrices" ADD CONSTRAINT "product_matrices_template_id_description_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "catalog"."description_templates"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "product_creator"."product_matrices" ADD CONSTRAINT "product_matrices_created_by_users_id_fk" FOREIGN KEY ("created_by") REFERENCES "public"."users"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."product_platform_data" ADD CONSTRAINT "product_platform_data_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "product_creator"."product_sets" ADD CONSTRAINT "product_sets_set_matrix_id_set_matrices_id_fk" FOREIGN KEY ("set_matrix_id") REFERENCES "product_creator"."set_matrices"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_carriers" ADD CONSTRAINT "production_carriers_carrier_group_id_production_carrier_groups_id_fk" FOREIGN KEY ("carrier_group_id") REFERENCES "production"."production_carrier_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_component_batches" ADD CONSTRAINT "production_component_batches_plan_line_id_production_plan_lines_id_fk" FOREIGN KEY ("plan_line_id") REFERENCES "production"."production_plan_lines"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_component_batches" ADD CONSTRAINT "production_component_batches_production_order_id_production_orders_id_fk" FOREIGN KEY ("production_order_id") REFERENCES "production"."production_orders"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_component_batches" ADD CONSTRAINT "production_component_batches_work_order_id_production_work_orders_id_fk" FOREIGN KEY ("work_order_id") REFERENCES "production"."production_work_orders"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_component_batches" ADD CONSTRAINT "production_component_batches_current_station_id_production_work_centers_id_fk" FOREIGN KEY ("current_station_id") REFERENCES "production"."production_work_centers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_component_batches" ADD CONSTRAINT "production_component_batches_routing_id_production_routings_id_fk" FOREIGN KEY ("routing_id") REFERENCES "production"."production_routings"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_locations" ADD CONSTRAINT "production_locations_location_group_id_production_location_groups_id_fk" FOREIGN KEY ("location_group_id") REFERENCES "production"."production_location_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_locations" ADD CONSTRAINT "production_locations_parent_id_production_locations_id_fk" FOREIGN KEY ("parent_id") REFERENCES "production"."production_locations"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_source_location_id_production_locations_id_fk" FOREIGN KEY ("source_location_id") REFERENCES "production"."production_locations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_target_location_id_production_locations_id_fk" FOREIGN KEY ("target_location_id") REFERENCES "production"."production_locations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_carrier_id_production_carriers_id_fk" FOREIGN KEY ("carrier_id") REFERENCES "production"."production_carriers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_production_order_id_production_orders_id_fk" FOREIGN KEY ("production_order_id") REFERENCES "production"."production_orders"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_work_order_id_production_work_orders_id_fk" FOREIGN KEY ("work_order_id") REFERENCES "production"."production_work_orders"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_work_center_id_production_work_centers_id_fk" FOREIGN KEY ("work_center_id") REFERENCES "production"."production_work_centers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_material_movements" ADD CONSTRAINT "production_material_movements_routing_operation_id_production_routing_operations_id_fk" FOREIGN KEY ("routing_operation_id") REFERENCES "production"."production_routing_operations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_norms" ADD CONSTRAINT "production_norms_norm_group_id_production_norm_groups_id_fk" FOREIGN KEY ("norm_group_id") REFERENCES "production"."production_norm_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_order_logs" ADD CONSTRAINT "production_order_logs_production_order_id_production_orders_id_fk" FOREIGN KEY ("production_order_id") REFERENCES "production"."production_orders"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_order_logs" ADD CONSTRAINT "production_order_logs_work_order_id_production_work_orders_id_fk" FOREIGN KEY ("work_order_id") REFERENCES "production"."production_work_orders"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_order_materials" ADD CONSTRAINT "production_order_materials_production_order_id_production_orders_id_fk" FOREIGN KEY ("production_order_id") REFERENCES "production"."production_orders"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_order_materials" ADD CONSTRAINT "production_order_materials_work_order_id_production_work_orders_id_fk" FOREIGN KEY ("work_order_id") REFERENCES "production"."production_work_orders"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_order_materials" ADD CONSTRAINT "production_order_materials_location_id_production_locations_id_fk" FOREIGN KEY ("location_id") REFERENCES "production"."production_locations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_orders" ADD CONSTRAINT "production_orders_routing_id_production_routings_id_fk" FOREIGN KEY ("routing_id") REFERENCES "production"."production_routings"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_orders" ADD CONSTRAINT "production_orders_location_id_production_locations_id_fk" FOREIGN KEY ("location_id") REFERENCES "production"."production_locations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_plan_lines" ADD CONSTRAINT "production_plan_lines_plan_id_production_plans_id_fk" FOREIGN KEY ("plan_id") REFERENCES "production"."production_plans"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_plan_lines" ADD CONSTRAINT "production_plan_lines_production_order_id_production_orders_id_fk" FOREIGN KEY ("production_order_id") REFERENCES "production"."production_orders"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_plan_lines" ADD CONSTRAINT "production_plan_lines_routing_id_production_routings_id_fk" FOREIGN KEY ("routing_id") REFERENCES "production"."production_routings"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."plan_name_counters" ADD CONSTRAINT "plan_name_counters_template_id_plan_name_templates_id_fk" FOREIGN KEY ("template_id") REFERENCES "production"."plan_name_templates"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_plans" ADD CONSTRAINT "production_plans_name_template_id_plan_name_templates_id_fk" FOREIGN KEY ("name_template_id") REFERENCES "production"."plan_name_templates"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_product_group_items" ADD CONSTRAINT "production_product_group_items_group_id_production_product_groups_id_fk" FOREIGN KEY ("group_id") REFERENCES "production"."production_product_groups"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_product_group_items" ADD CONSTRAINT "production_product_group_items_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE restrict ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_routing_branches" ADD CONSTRAINT "production_routing_branches_routing_operation_id_production_routing_operations_id_fk" FOREIGN KEY ("routing_operation_id") REFERENCES "production"."production_routing_operations"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_routing_branches" ADD CONSTRAINT "production_routing_branches_next_operation_id_production_routing_operations_id_fk" FOREIGN KEY ("next_operation_id") REFERENCES "production"."production_routing_operations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_routing_operations" ADD CONSTRAINT "production_routing_operations_routing_id_production_routings_id_fk" FOREIGN KEY ("routing_id") REFERENCES "production"."production_routings"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_routing_operations" ADD CONSTRAINT "production_routing_operations_work_center_id_production_work_centers_id_fk" FOREIGN KEY ("work_center_id") REFERENCES "production"."production_work_centers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_routing_operations" ADD CONSTRAINT "production_routing_operations_norm_id_production_norms_id_fk" FOREIGN KEY ("norm_id") REFERENCES "production"."production_norms"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_routings" ADD CONSTRAINT "production_routings_default_work_center_id_production_work_centers_id_fk" FOREIGN KEY ("default_work_center_id") REFERENCES "production"."production_work_centers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_tasks" ADD CONSTRAINT "production_tasks_assigned_pattern_id_cut_patterns_id_fk" FOREIGN KEY ("assigned_pattern_id") REFERENCES "production"."cut_patterns"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_work_centers" ADD CONSTRAINT "production_work_centers_location_id_production_locations_id_fk" FOREIGN KEY ("location_id") REFERENCES "production"."production_locations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_work_orders" ADD CONSTRAINT "production_work_orders_production_order_id_production_orders_id_fk" FOREIGN KEY ("production_order_id") REFERENCES "production"."production_orders"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_work_orders" ADD CONSTRAINT "production_work_orders_routing_operation_id_production_routing_operations_id_fk" FOREIGN KEY ("routing_operation_id") REFERENCES "production"."production_routing_operations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_work_orders" ADD CONSTRAINT "production_work_orders_work_center_id_production_work_centers_id_fk" FOREIGN KEY ("work_center_id") REFERENCES "production"."production_work_centers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_work_orders" ADD CONSTRAINT "production_work_orders_carrier_id_production_carriers_id_fk" FOREIGN KEY ("carrier_id") REFERENCES "production"."production_carriers"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "production"."production_work_orders" ADD CONSTRAINT "production_work_orders_location_id_production_locations_id_fk" FOREIGN KEY ("location_id") REFERENCES "production"."production_locations"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "catalog"."products" ADD CONSTRAINT "products_matrix_id_product_matrices_id_fk" FOREIGN KEY ("matrix_id") REFERENCES "product_creator"."product_matrices"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "product_creator"."set_matrices" ADD CONSTRAINT "set_matrices_description_template_id_description_templates_id_fk" FOREIGN KEY ("description_template_id") REFERENCES "catalog"."description_templates"("id") ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "product_creator"."set_product_links" ADD CONSTRAINT "set_product_links_set_id_product_sets_id_fk" FOREIGN KEY ("set_id") REFERENCES "product_creator"."product_sets"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "product_creator"."set_product_links" ADD CONSTRAINT "set_product_links_product_id_products_id_fk" FOREIGN KEY ("product_id") REFERENCES "catalog"."products"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "warehouse"."stock_panel_events" ADD CONSTRAINT "stock_panel_events_stock_panel_id_stock_panels_id_fk" FOREIGN KEY ("stock_panel_id") REFERENCES "warehouse"."stock_panels"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "user_saved_filters" ADD CONSTRAINT "user_saved_filters_user_id_users_id_fk" FOREIGN KEY ("user_id") REFERENCES "public"."users"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "webhook_configs" ADD CONSTRAINT "webhook_configs_created_by_users_id_fk" FOREIGN KEY ("created_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "webhook_logs" ADD CONSTRAINT "webhook_logs_webhook_id_webhook_configs_id_fk" FOREIGN KEY ("webhook_id") REFERENCES "public"."webhook_configs"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
CREATE INDEX "idx_accessories_group" ON "catalog"."accessories" USING btree ("group_id");--> statement-breakpoint
CREATE INDEX "idx_accessories_code" ON "catalog"."accessories" USING btree ("code");--> statement-breakpoint
CREATE INDEX "idx_accessories_active" ON "catalog"."accessories" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_accessories_warehouse_material" ON "catalog"."accessories" USING btree ("warehouse_material_id");--> statement-breakpoint
CREATE INDEX "idx_accessory_groups_code" ON "catalog"."accessory_groups" USING btree ("code");--> statement-breakpoint
CREATE INDEX "idx_accessory_groups_active" ON "catalog"."accessory_groups" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_accessory_groups_category" ON "catalog"."accessory_groups" USING btree ("category");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_allegro_fee_summaries_date" ON "allegro_fee_summaries" USING btree ("summary_date");--> statement-breakpoint
CREATE INDEX "idx_allegro_fees_occurred_at" ON "allegro_fees" USING btree ("occurred_at");--> statement-breakpoint
CREATE INDEX "idx_allegro_fees_type_id" ON "allegro_fees" USING btree ("type_id");--> statement-breakpoint
CREATE INDEX "idx_allegro_fees_category" ON "allegro_fees" USING btree ("category");--> statement-breakpoint
CREATE INDEX "idx_bom_operations_bom" ON "bom"."bom_operations" USING btree ("bom_id");--> statement-breakpoint
CREATE INDEX "idx_bom_operations_type" ON "bom"."bom_operations" USING btree ("operation_type");--> statement-breakpoint
CREATE INDEX "idx_bom_operations_sequence" ON "bom"."bom_operations" USING btree ("sequence");--> statement-breakpoint
CREATE INDEX "idx_component_material_breakdown_component" ON "bom"."component_material_breakdown" USING btree ("component_id");--> statement-breakpoint
CREATE INDEX "idx_component_material_breakdown_calculated" ON "bom"."component_material_breakdown" USING btree ("calculated_at");--> statement-breakpoint
CREATE INDEX "idx_component_templates_furniture_type" ON "bom"."component_templates" USING btree ("furniture_type");--> statement-breakpoint
CREATE INDEX "idx_component_templates_cz1" ON "bom"."component_templates" USING btree ("cz1");--> statement-breakpoint
CREATE INDEX "idx_component_templates_active" ON "bom"."component_templates" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_component_templates_warehouse" ON "bom"."component_templates" USING btree ("warehouse_material_id");--> statement-breakpoint
CREATE INDEX "idx_component_templates_parent" ON "bom"."component_templates" USING btree ("parent_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_items_pattern" ON "production"."cut_pattern_items" USING btree ("pattern_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_items_status" ON "production"."cut_pattern_items" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_items_board_material" ON "production"."cut_pattern_items" USING btree ("board_material_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_items_edging_material" ON "production"."cut_pattern_items" USING btree ("edging_material_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_run_items_run" ON "production"."cut_pattern_run_items" USING btree ("run_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_run_items_template_item" ON "production"."cut_pattern_run_items" USING btree ("template_item_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_run_items_status" ON "production"."cut_pattern_run_items" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_run_items_board_material" ON "production"."cut_pattern_run_items" USING btree ("board_material_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_run_items_edging_material" ON "production"."cut_pattern_run_items" USING btree ("edging_material_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_runs_template" ON "production"."cut_pattern_runs" USING btree ("template_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_runs_status" ON "production"."cut_pattern_runs" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_runs_plan" ON "production"."cut_pattern_runs" USING btree ("plan_line_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_runs_scheduled" ON "production"."cut_pattern_runs" USING btree ("scheduled_at");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_template_items_template" ON "production"."cut_pattern_template_items" USING btree ("template_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_template_items_board_material" ON "production"."cut_pattern_template_items" USING btree ("board_material_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_template_items_edging_material" ON "production"."cut_pattern_template_items" USING btree ("edging_material_id");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_templates_code" ON "production"."cut_pattern_templates" USING btree ("code");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_templates_active" ON "production"."cut_pattern_templates" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_cut_pattern_templates_usage" ON "production"."cut_pattern_templates" USING btree ("usage_count");--> statement-breakpoint
CREATE INDEX "idx_cut_patterns_status" ON "production"."cut_patterns" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_cut_patterns_code" ON "production"."cut_patterns" USING btree ("code");--> statement-breakpoint
CREATE INDEX "idx_error_logs_type" ON "error_logs" USING btree ("type");--> statement-breakpoint
CREATE INDEX "idx_error_logs_severity" ON "error_logs" USING btree ("severity");--> statement-breakpoint
CREATE INDEX "idx_error_logs_timestamp" ON "error_logs" USING btree ("timestamp");--> statement-breakpoint
CREATE INDEX "idx_error_logs_resolved" ON "error_logs" USING btree ("resolved_at");--> statement-breakpoint
CREATE INDEX "idx_material_accessory_material" ON "warehouse"."material_accessory_links" USING btree ("material_id");--> statement-breakpoint
CREATE INDEX "idx_material_accessory_accessory" ON "warehouse"."material_accessory_links" USING btree ("accessory_id");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_material_accessory_unique" ON "warehouse"."material_accessory_links" USING btree ("material_id","accessory_id");--> statement-breakpoint
CREATE INDEX "idx_material_groups_code" ON "warehouse"."material_groups" USING btree ("code");--> statement-breakpoint
CREATE INDEX "idx_material_groups_category" ON "warehouse"."material_groups" USING btree ("category");--> statement-breakpoint
CREATE INDEX "idx_material_groups_active" ON "warehouse"."material_groups" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_material_media_material" ON "warehouse"."material_media" USING btree ("material_id");--> statement-breakpoint
CREATE INDEX "idx_material_media_order" ON "warehouse"."material_media" USING btree ("display_order");--> statement-breakpoint
CREATE INDEX "idx_materials_group" ON "warehouse"."materials" USING btree ("group_id");--> statement-breakpoint
CREATE INDEX "idx_materials_internal_code" ON "warehouse"."materials" USING btree ("internal_code");--> statement-breakpoint
CREATE INDEX "idx_materials_supplier_code" ON "warehouse"."materials" USING btree ("supplier_code");--> statement-breakpoint
CREATE INDEX "idx_materials_active" ON "warehouse"."materials" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_matrix_accessories_matrix" ON "catalog"."matrix_accessories" USING btree ("matrix_id");--> statement-breakpoint
CREATE INDEX "idx_matrix_accessories_group" ON "catalog"."matrix_accessories" USING btree ("group_id");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_matrix_accessories_unique" ON "catalog"."matrix_accessories" USING btree ("matrix_id","group_id");--> statement-breakpoint
CREATE INDEX "idx_product_boms_product" ON "bom"."product_boms" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_product_boms_active" ON "bom"."product_boms" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_product_boms_approved" ON "bom"."product_boms" USING btree ("is_approved");--> statement-breakpoint
CREATE INDEX "idx_product_boms_odoo_id" ON "bom"."product_boms" USING btree ("odoo_bom_id");--> statement-breakpoint
CREATE INDEX "idx_product_boms_odoo_status" ON "bom"."product_boms" USING btree ("odoo_sync_status");--> statement-breakpoint
CREATE INDEX "idx_component_metrics_component" ON "bom"."product_component_metrics" USING btree ("component_id");--> statement-breakpoint
CREATE INDEX "idx_component_metrics_board_material" ON "bom"."product_component_metrics" USING btree ("board_material_id");--> statement-breakpoint
CREATE INDEX "idx_component_metrics_edging_material" ON "bom"."product_component_metrics" USING btree ("edging_material_id");--> statement-breakpoint
CREATE INDEX "idx_component_metrics_calculated_at" ON "bom"."product_component_metrics" USING btree ("calculated_at");--> statement-breakpoint
CREATE INDEX "idx_product_components_product" ON "bom"."product_components" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_product_components_template" ON "bom"."product_components" USING btree ("template_id");--> statement-breakpoint
CREATE INDEX "idx_product_components_warehouse" ON "bom"."product_components" USING btree ("warehouse_material_id");--> statement-breakpoint
CREATE INDEX "idx_product_components_type" ON "bom"."product_components" USING btree ("component_type");--> statement-breakpoint
CREATE UNIQUE INDEX "unique_set_matrix_combination" ON "product_creator"."product_sets" USING btree ("set_matrix_id","combination_key");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_production_carriers_group_code" ON "production"."production_carriers" USING btree ("carrier_group_id","code");--> statement-breakpoint
CREATE INDEX "idx_production_carriers_status_group" ON "production"."production_carriers" USING btree ("status","carrier_group_id");--> statement-breakpoint
CREATE INDEX "idx_production_carriers_barcode" ON "production"."production_carriers" USING btree ("barcode");--> statement-breakpoint
CREATE INDEX "idx_production_carriers_location" ON "production"."production_carriers" USING btree ("current_location_id");--> statement-breakpoint
CREATE INDEX "idx_batches_plan_line" ON "production"."production_component_batches" USING btree ("plan_line_id");--> statement-breakpoint
CREATE INDEX "idx_batches_po" ON "production"."production_component_batches" USING btree ("production_order_id");--> statement-breakpoint
CREATE INDEX "idx_batches_attributes" ON "production"."production_component_batches" USING btree ("color","edging_pattern","drilling_pattern");--> statement-breakpoint
CREATE INDEX "idx_batches_station" ON "production"."production_component_batches" USING btree ("current_station_id");--> statement-breakpoint
CREATE INDEX "idx_batches_status" ON "production"."production_component_batches" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_production_locations_parent" ON "production"."production_locations" USING btree ("parent_id");--> statement-breakpoint
CREATE INDEX "idx_production_locations_group_level" ON "production"."production_locations" USING btree ("location_group_id","level");--> statement-breakpoint
CREATE INDEX "idx_production_locations_path" ON "production"."production_locations" USING btree ("path");--> statement-breakpoint
CREATE INDEX "idx_production_locations_status" ON "production"."production_locations" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_production_locations_barcode" ON "production"."production_locations" USING btree ("barcode");--> statement-breakpoint
CREATE INDEX "idx_norms_material_type" ON "production"."production_material_consumption_norms" USING btree ("material_type");--> statement-breakpoint
CREATE INDEX "idx_norms_category" ON "production"."production_material_consumption_norms" USING btree ("material_category");--> statement-breakpoint
CREATE INDEX "idx_norms_active" ON "production"."production_material_consumption_norms" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_material_movements_date" ON "production"."production_material_movements" USING btree ("movement_date");--> statement-breakpoint
CREATE INDEX "idx_material_movements_po" ON "production"."production_material_movements" USING btree ("production_order_id");--> statement-breakpoint
CREATE INDEX "idx_material_movements_wo" ON "production"."production_material_movements" USING btree ("work_order_id");--> statement-breakpoint
CREATE INDEX "idx_material_movements_carrier" ON "production"."production_material_movements" USING btree ("carrier_id");--> statement-breakpoint
CREATE INDEX "idx_material_movements_source_target" ON "production"."production_material_movements" USING btree ("source_location_id","target_location_id");--> statement-breakpoint
CREATE INDEX "idx_material_movements_type_status" ON "production"."production_material_movements" USING btree ("material_type","status");--> statement-breakpoint
CREATE INDEX "idx_material_movements_operator" ON "production"."production_material_movements" USING btree ("operator_id");--> statement-breakpoint
CREATE INDEX "idx_material_movements_batch" ON "production"."production_material_movements" USING btree ("movement_batch_id");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_production_norms_group_code" ON "production"."production_norms" USING btree ("norm_group_id","code");--> statement-breakpoint
CREATE INDEX "idx_production_norms_group" ON "production"."production_norms" USING btree ("norm_group_id");--> statement-breakpoint
CREATE INDEX "idx_production_norms_active" ON "production"."production_norms" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_production_order_logs_po" ON "production"."production_order_logs" USING btree ("production_order_id");--> statement-breakpoint
CREATE INDEX "idx_production_order_logs_wo" ON "production"."production_order_logs" USING btree ("work_order_id");--> statement-breakpoint
CREATE INDEX "idx_production_order_logs_type" ON "production"."production_order_logs" USING btree ("event_type");--> statement-breakpoint
CREATE INDEX "idx_production_order_logs_created" ON "production"."production_order_logs" USING btree ("created_at");--> statement-breakpoint
CREATE INDEX "idx_production_order_materials_po" ON "production"."production_order_materials" USING btree ("production_order_id");--> statement-breakpoint
CREATE INDEX "idx_production_order_materials_wo" ON "production"."production_order_materials" USING btree ("work_order_id");--> statement-breakpoint
CREATE INDEX "idx_production_order_materials_material" ON "production"."production_order_materials" USING btree ("material_id");--> statement-breakpoint
CREATE INDEX "idx_production_orders_status_date" ON "production"."production_orders" USING btree ("status","planned_start_date");--> statement-breakpoint
CREATE INDEX "idx_production_orders_workflow_stage" ON "production"."production_orders" USING btree ("workflow_stage");--> statement-breakpoint
CREATE INDEX "idx_production_orders_product" ON "production"."production_orders" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_production_orders_bom" ON "production"."production_orders" USING btree ("bom_id");--> statement-breakpoint
CREATE INDEX "idx_production_orders_routing" ON "production"."production_orders" USING btree ("routing_id");--> statement-breakpoint
CREATE INDEX "idx_production_orders_priority" ON "production"."production_orders" USING btree ("priority");--> statement-breakpoint
CREATE INDEX "idx_production_orders_location" ON "production"."production_orders" USING btree ("location_id");--> statement-breakpoint
CREATE INDEX "idx_plan_lines_plan" ON "production"."production_plan_lines" USING btree ("plan_id");--> statement-breakpoint
CREATE INDEX "idx_plan_lines_product" ON "production"."production_plan_lines" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_plan_lines_po" ON "production"."production_plan_lines" USING btree ("production_order_id");--> statement-breakpoint
CREATE INDEX "idx_plan_lines_source" ON "production"."production_plan_lines" USING btree ("source_type","source_id");--> statement-breakpoint
CREATE INDEX "idx_plan_lines_status" ON "production"."production_plan_lines" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_plan_name_counters_template_date" ON "production"."plan_name_counters" USING btree ("template_id","counter_date");--> statement-breakpoint
CREATE INDEX "idx_plan_name_templates_active" ON "production"."plan_name_templates" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_production_plans_status" ON "production"."production_plans" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_production_plans_dates" ON "production"."production_plans" USING btree ("planned_start_date","planned_end_date");--> statement-breakpoint
CREATE INDEX "idx_production_plans_created" ON "production"."production_plans" USING btree ("created_at");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_product_group_items_unique" ON "production"."production_product_group_items" USING btree ("group_id","product_id");--> statement-breakpoint
CREATE INDEX "idx_product_group_items_group" ON "production"."production_product_group_items" USING btree ("group_id");--> statement-breakpoint
CREATE INDEX "idx_product_group_items_product" ON "production"."production_product_group_items" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_product_groups_active" ON "production"."production_product_groups" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_product_groups_sort" ON "production"."production_product_groups" USING btree ("sort_order");--> statement-breakpoint
CREATE INDEX "idx_routing_branches_operation" ON "production"."production_routing_branches" USING btree ("routing_operation_id");--> statement-breakpoint
CREATE INDEX "idx_routing_branches_next" ON "production"."production_routing_branches" USING btree ("next_operation_id");--> statement-breakpoint
CREATE INDEX "idx_routing_branches_active" ON "production"."production_routing_branches" USING btree ("is_active");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_production_routing_ops_routing_seq" ON "production"."production_routing_operations" USING btree ("routing_id","sequence");--> statement-breakpoint
CREATE INDEX "idx_production_routing_ops_routing" ON "production"."production_routing_operations" USING btree ("routing_id");--> statement-breakpoint
CREATE INDEX "idx_production_routing_ops_workcenter" ON "production"."production_routing_operations" USING btree ("work_center_id");--> statement-breakpoint
CREATE INDEX "idx_production_routings_product" ON "production"."production_routings" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_production_routings_type" ON "production"."production_routings" USING btree ("product_type");--> statement-breakpoint
CREATE INDEX "idx_production_routings_active" ON "production"."production_routings" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_production_settings_category" ON "production"."production_settings" USING btree ("category");--> statement-breakpoint
CREATE INDEX "idx_production_settings_key" ON "production"."production_settings" USING btree ("key");--> statement-breakpoint
CREATE INDEX "idx_production_tasks_status" ON "production"."production_tasks" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_production_work_centers_status" ON "production"."production_work_centers" USING btree ("status");--> statement-breakpoint
CREATE INDEX "idx_production_work_centers_location" ON "production"."production_work_centers" USING btree ("location_id");--> statement-breakpoint
CREATE INDEX "idx_production_work_centers_active" ON "production"."production_work_centers" USING btree ("is_active");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_production_work_orders_po_seq" ON "production"."production_work_orders" USING btree ("production_order_id","sequence");--> statement-breakpoint
CREATE INDEX "idx_production_work_orders_po_status" ON "production"."production_work_orders" USING btree ("production_order_id","status");--> statement-breakpoint
CREATE INDEX "idx_production_work_orders_workcenter" ON "production"."production_work_orders" USING btree ("work_center_id");--> statement-breakpoint
CREATE INDEX "idx_production_work_orders_operator" ON "production"."production_work_orders" USING btree ("operator_user_id");--> statement-breakpoint
CREATE INDEX "idx_production_work_orders_status" ON "production"."production_work_orders" USING btree ("status");--> statement-breakpoint
CREATE UNIQUE INDEX "unique_matrix_combination" ON "catalog"."products" USING btree ("matrix_id","combination_key");--> statement-breakpoint
CREATE INDEX "IDX_session_expire" ON "sessions" USING btree ("expire");--> statement-breakpoint
CREATE INDEX "idx_set_product_links_set" ON "product_creator"."set_product_links" USING btree ("set_id");--> statement-breakpoint
CREATE INDEX "idx_set_product_links_product" ON "product_creator"."set_product_links" USING btree ("product_id");--> statement-breakpoint
CREATE INDEX "idx_stock_panel_events_panel" ON "warehouse"."stock_panel_events" USING btree ("stock_panel_id");--> statement-breakpoint
CREATE INDEX "idx_stock_panel_events_source" ON "warehouse"."stock_panel_events" USING btree ("source_type","source_reference");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_board" ON "warehouse"."stock_panels" USING btree ("board_code");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_edging" ON "warehouse"."stock_panels" USING btree ("edging_code");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_color" ON "warehouse"."stock_panels" USING btree ("color_code");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_source" ON "warehouse"."stock_panels" USING btree ("source");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_drilled" ON "warehouse"."stock_panels" USING btree ("is_drilled");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_edged" ON "warehouse"."stock_panels" USING btree ("is_edged");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_active" ON "warehouse"."stock_panels" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_stock_panels_dimensions" ON "warehouse"."stock_panels" USING btree ("length","width");--> statement-breakpoint
CREATE INDEX "idx_sync_health_type" ON "sync_health_stats" USING btree ("sync_type");--> statement-breakpoint
CREATE INDEX "idx_sync_health_status" ON "sync_health_stats" USING btree ("health_status");--> statement-breakpoint
CREATE UNIQUE INDEX "idx_sync_health_unique_type" ON "sync_health_stats" USING btree ("sync_type");--> statement-breakpoint
CREATE INDEX "idx_user_saved_filters_user" ON "user_saved_filters" USING btree ("user_id");--> statement-breakpoint
CREATE INDEX "idx_user_saved_filters_context" ON "user_saved_filters" USING btree ("context");--> statement-breakpoint
CREATE INDEX "idx_user_saved_filters_last_used" ON "user_saved_filters" USING btree ("user_id","context","is_last_used");--> statement-breakpoint
CREATE INDEX "idx_warehouse_categories_code" ON "warehouse"."categories" USING btree ("code");--> statement-breakpoint
CREATE INDEX "idx_warehouse_categories_active" ON "warehouse"."categories" USING btree ("is_active");--> statement-breakpoint
CREATE INDEX "idx_warehouse_categories_order" ON "warehouse"."categories" USING btree ("display_order");