import { useState } from "react";
import { WarehouseSubmenu } from "./warehouse-submenu";
import { Button } from "@/components/ui/button";
import { Sheet, SheetContent, SheetTrigger } from "@/components/ui/sheet";
import { Menu } from "lucide-react";

interface MaterialGroup {
  id: number;
  name: string;
  code: string;
  category: string | null;
  description: string | null;
  displayOrder: number;
  isActive: boolean;
}

interface WarehouseLayoutProps {
  category: string;
  children: React.ReactNode;
  onEditGroup?: (group: MaterialGroup) => void;
  onAddGroup?: () => void;
  rightSidebar?: React.ReactNode;
  hideSubmenu?: boolean;
}

export function WarehouseLayout({ category, children, onEditGroup, onAddGroup, rightSidebar, hideSubmenu = true }: WarehouseLayoutProps) {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  return (
    <div className="flex h-full w-full overflow-hidden">
      {/* Left submenu - hidden on mobile, visible on md+ */}
      {!hideSubmenu && (
        <div className="hidden md:flex w-64 border-r bg-card flex-shrink-0 overflow-y-auto">
          <WarehouseSubmenu category={category} onEditGroup={onEditGroup} onAddGroup={onAddGroup} />
        </div>
      )}

      {/* Main content area */}
      <div className="flex-1 overflow-auto bg-background">
        {/* Mobile menu button */}
        {!hideSubmenu && (
          <div className="md:hidden sticky top-0 z-10 bg-background border-b p-2">
            <Sheet open={mobileMenuOpen} onOpenChange={setMobileMenuOpen}>
              <SheetTrigger asChild>
                <Button variant="outline" size="sm" data-testid="button-mobile-menu">
                  <Menu className="w-4 h-4 mr-2" />
                  Grupy materiałów
                </Button>
              </SheetTrigger>
              <SheetContent side="left" className="w-64 p-0">
                <WarehouseSubmenu category={category} onEditGroup={onEditGroup} onAddGroup={onAddGroup} />
              </SheetContent>
            </Sheet>
          </div>
        )}

        {children}
      </div>

      {/* Right sidebar - optional */}
      {rightSidebar}
    </div>
  );
}
