import { useState } from "react";
import { MatrixSubmenu } from "./matrix-submenu";
import { Button } from "@/components/ui/button";
import { Sheet, SheetContent, SheetTrigger } from "@/components/ui/sheet";
import { Menu } from "lucide-react";

interface MatrixLayoutProps {
  furnitureType: string | null;
  children: React.ReactNode;
}

export function MatrixLayout({ furnitureType, children }: MatrixLayoutProps) {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  return (
    <div className="flex h-full w-full overflow-hidden">
      {/* Left submenu - hidden on mobile, visible on md+ */}
      <div className="hidden md:flex w-64 border-r bg-card flex-shrink-0 overflow-y-auto">
        <MatrixSubmenu furnitureType={furnitureType} />
      </div>

      {/* Main content area */}
      <div className="flex-1 overflow-auto bg-background">
        {/* Mobile menu button */}
        <div className="md:hidden sticky top-0 z-10 bg-background border-b p-2">
          <Sheet open={mobileMenuOpen} onOpenChange={setMobileMenuOpen}>
            <SheetTrigger asChild>
              <Button variant="outline" size="sm" data-testid="button-mobile-menu">
                <Menu className="w-4 h-4 mr-2" />
                Rodzaje mebli
              </Button>
            </SheetTrigger>
            <SheetContent side="left" className="w-64 p-0">
              <MatrixSubmenu furnitureType={furnitureType} />
            </SheetContent>
          </Sheet>
        </div>

        {children}
      </div>
    </div>
  );
}
