import { ColumnDefinition, FilterGroupDefinition } from '@/hooks/useWarehouseTableState';

export const srubyColumns: ColumnDefinition[] = [
  { key: 'rowNumber', label: '#', defaultWidth: 40, defaultVisible: true },
  { key: 'image', label: '', defaultWidth: 40, defaultVisible: true },
  { key: 'name', label: 'Nazwa', defaultWidth: 200, defaultVisible: true, sortKey: 'name' },
  { key: 'internalCode', label: 'Kod wew.', defaultWidth: 100, defaultVisible: true, sortKey: 'internalCode' },
  { key: 'supplierCode', label: 'Kod dost.', defaultWidth: 100, defaultVisible: true, sortKey: 'supplierCode' },
  { key: 'quantity', label: 'Stan', defaultWidth: 70, defaultVisible: true, sortKey: 'quantity' },
  { key: 'reserved', label: 'Zarezerwow.', defaultWidth: 80, defaultVisible: true },
  { key: 'available', label: 'Dostępne', defaultWidth: 70, defaultVisible: true },
  { key: 'group', label: 'Grupa', defaultWidth: 120, defaultVisible: true },
  { key: 'unitOfMeasure', label: 'J.m.', defaultWidth: 60, defaultVisible: true },
  { key: 'price', label: 'Cena', defaultWidth: 80, defaultVisible: true, sortKey: 'price' },
  { key: 'location', label: 'Lokalizacja', defaultWidth: 100, defaultVisible: true },
  { key: 'carrier', label: 'Nośnik', defaultWidth: 80, defaultVisible: true },
  { key: 'description', label: 'Opis', defaultWidth: 150, defaultVisible: false },
];

export const srubyFilterGroups: FilterGroupDefinition[] = [
  { 
    key: 'stock', 
    label: 'Stan magazynowy', 
    type: 'stock' 
  },
  { 
    key: 'group', 
    label: 'Grupa', 
    type: 'triState',
    paramName: 'groupCodes',
    excludeParamName: 'excludeGroupCodes'
  },
  { 
    key: 'location', 
    label: 'Lokalizacja', 
    type: 'triState',
    paramName: 'locationIds',
    excludeParamName: 'excludeLocationIds'
  },
  { 
    key: 'carrier', 
    label: 'Nośnik', 
    type: 'triState',
    paramName: 'carrierIds',
    excludeParamName: 'excludeCarrierIds'
  },
];

export const srubySortableColumns: Record<string, string> = {
  name: 'name',
  internalCode: 'internalCode',
  supplierCode: 'supplierCode',
  quantity: 'quantity',
  price: 'price',
};
