--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9 (165f042)
-- Dumped by pg_dump version 16.9

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: allegro; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA allegro;


ALTER SCHEMA allegro OWNER TO neondb_owner;

--
-- Name: catalog; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA catalog;


ALTER SCHEMA catalog OWNER TO neondb_owner;

--
-- Name: commerce; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA commerce;


ALTER SCHEMA commerce OWNER TO neondb_owner;

--
-- Name: shoper; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA shoper;


ALTER SCHEMA shoper OWNER TO neondb_owner;

--
-- Name: order_source; Type: TYPE; Schema: commerce; Owner: neondb_owner
--

CREATE TYPE commerce.order_source AS ENUM (
    'ALLEGRO',
    'SHOPER'
);


ALTER TYPE commerce.order_source OWNER TO neondb_owner;

--
-- Name: generate_order_code(); Type: FUNCTION; Schema: commerce; Owner: neondb_owner
--

CREATE FUNCTION commerce.generate_order_code() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  -- Generuj order_code na podstawie source i order_number
  NEW.order_code := CASE 
    WHEN NEW.source = 'ALLEGRO' THEN 'AL-' || NEW.order_number::text
    WHEN NEW.source = 'SHOPER' THEN 'SH-' || NEW.order_number::text
    ELSE COALESCE(NEW.source, 'UNK') || '-' || NEW.order_number::text
  END;
  RETURN NEW;
END;
$$;


ALTER FUNCTION commerce.generate_order_code() OWNER TO neondb_owner;

--
-- Name: sync_allegro_to_commerce(); Type: FUNCTION; Schema: public; Owner: neondb_owner
--

CREATE FUNCTION public.sync_allegro_to_commerce() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    v_first_name VARCHAR;
    v_last_name VARCHAR;
    name_parts TEXT[];
BEGIN
    -- Rozdziel imię i nazwisko (jeśli istnieje)
    IF NEW.buyer_name IS NOT NULL THEN
        name_parts := string_to_array(TRIM(NEW.buyer_name), ' ');
        v_first_name := name_parts[1];
        IF array_length(name_parts, 1) > 1 THEN
            v_last_name := array_to_string(name_parts[2:array_length(name_parts, 1)], ' ');
        END IF;
    END IF;
    
    -- Wstaw lub zaktualizuj w commerce.orders
    INSERT INTO commerce.orders (
        id,
        source,
        source_order_id,
        order_date,
        status,
        buyer_login,
        buyer_email,
        buyer_company,
        buyer_first_name,
        buyer_last_name,
        buyer_phone,
        buyer_address,
        buyer_zip,
        buyer_city,
        buyer_country_code,
        payment_id,
        payment_status,
        payment_type,
        payment_provider,
        payment_amount,
        payment_currency,
        delivery_method,
        delivery_amount,
        delivery_currency,
        total_to_pay_amount,
        total_to_pay_currency,
        buyer_notes,
        invoice_required,
        tracking_numbers,
        raw_payload,
        created_at,
        updated_at
    ) VALUES (
        gen_random_uuid(),
        'ALLEGRO',
        NEW.order_id,
        NEW.order_date,
        NEW.seller_status,
        NEW.buyer_login,
        NEW.buyer_email,
        NEW.buyer_company,
        v_first_name,
        v_last_name,
        NEW.buyer_phone,
        NEW.buyer_address,
        NEW.buyer_zip,
        NEW.buyer_city,
        NEW.buyer_country_code,
        NEW.payment_id,
        NEW.payment_status,
        NEW.payment_type,
        NEW.payment_provider,
        NEW.payment_amount,
        NEW.payment_currency,
        NEW.delivery_method,
        NEW.delivery_amount,
        NEW.delivery_currency,
        NEW.total_to_pay_amount,
        NEW.total_to_pay_currency,
        NEW.buyer_notes,
        NEW.invoice_required,
        NEW.tracking_numbers,
        jsonb_build_object(
            'order_id', NEW.order_id,
            'marketplace', NEW.marketplace,
            'smart', NEW.smart,
            'allegro_pay', NEW.allegro_pay
        ),
        NOW(),
        NOW()
    )
    ON CONFLICT (source_order_id, source) DO UPDATE SET
        order_date = EXCLUDED.order_date,
        status = EXCLUDED.status,
        buyer_login = EXCLUDED.buyer_login,
        buyer_email = EXCLUDED.buyer_email,
        buyer_company = EXCLUDED.buyer_company,
        buyer_first_name = EXCLUDED.buyer_first_name,
        buyer_last_name = EXCLUDED.buyer_last_name,
        buyer_phone = EXCLUDED.buyer_phone,
        buyer_address = EXCLUDED.buyer_address,
        buyer_zip = EXCLUDED.buyer_zip,
        buyer_city = EXCLUDED.buyer_city,
        buyer_country_code = EXCLUDED.buyer_country_code,
        payment_id = EXCLUDED.payment_id,
        payment_status = EXCLUDED.payment_status,
        payment_type = EXCLUDED.payment_type,
        payment_provider = EXCLUDED.payment_provider,
        payment_amount = EXCLUDED.payment_amount,
        payment_currency = EXCLUDED.payment_currency,
        delivery_method = EXCLUDED.delivery_method,
        delivery_amount = EXCLUDED.delivery_amount,
        delivery_currency = EXCLUDED.delivery_currency,
        total_to_pay_amount = EXCLUDED.total_to_pay_amount,
        total_to_pay_currency = EXCLUDED.total_to_pay_currency,
        buyer_notes = EXCLUDED.buyer_notes,
        invoice_required = EXCLUDED.invoice_required,
        tracking_numbers = EXCLUDED.tracking_numbers,
        updated_at = NOW();
    
    RETURN NEW;
END;
$$;


ALTER FUNCTION public.sync_allegro_to_commerce() OWNER TO neondb_owner;

--
-- Name: sync_shoper_to_commerce(); Type: FUNCTION; Schema: public; Owner: neondb_owner
--

CREATE FUNCTION public.sync_shoper_to_commerce() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    v_raw jsonb;
    v_billing_address jsonb;
    v_delivery_address jsonb;
    v_first_name VARCHAR;
    v_last_name VARCHAR;
    v_phone VARCHAR;
    v_company VARCHAR;
    v_street VARCHAR;
    v_zip VARCHAR;
    v_city VARCHAR;
    v_country_code VARCHAR;
    v_delivery_cost NUMERIC;
BEGIN
    v_raw := NEW.raw_data;
    
    -- Wyciągnij dane z billing_address
    IF v_raw->>'billing_address' IS NOT NULL THEN
        v_billing_address := (v_raw->>'billing_address')::jsonb;
        v_first_name := v_billing_address->>'firstname';
        v_last_name := v_billing_address->>'lastname';
        v_phone := v_billing_address->>'phone';
        v_company := v_billing_address->>'company';
    END IF;
    
    -- Wyciągnij dane z delivery_address
    IF v_raw->>'delivery_address' IS NOT NULL THEN
        v_delivery_address := (v_raw->>'delivery_address')::jsonb;
        v_street := v_delivery_address->>'street1';
        v_zip := v_delivery_address->>'postcode';
        v_city := v_delivery_address->>'city';
        v_country_code := v_delivery_address->>'country_code';
    END IF;
    
    v_delivery_cost := (v_raw->>'shipping_cost')::numeric;
    
    -- Wstaw lub zaktualizuj w commerce.orders
    INSERT INTO commerce.orders (
        id,
        source,
        source_order_id,
        order_date,
        status,
        buyer_login,
        buyer_email,
        buyer_company,
        buyer_first_name,
        buyer_last_name,
        buyer_phone,
        buyer_address,
        buyer_zip,
        buyer_city,
        buyer_country_code,
        payment_status,
        payment_type,
        payment_amount,
        payment_currency,
        delivery_amount,
        delivery_currency,
        total_to_pay_amount,
        total_to_pay_currency,
        buyer_notes,
        invoice_required,
        raw_payload,
        created_at,
        updated_at
    ) VALUES (
        gen_random_uuid(),
        'SHOPER',
        NEW.shoper_order_id,
        NEW.order_date,
        NEW.fulfillment_status,
        NEW.buyer_login,
        NEW.buyer_email,
        v_company,
        v_first_name,
        v_last_name,
        v_phone,
        v_street,
        v_zip,
        v_city,
        v_country_code,
        NEW.payment_status,
        CASE 
            WHEN (v_raw->>'payment_id')::int = 2 THEN 'ONLINE'
            ELSE 'CASH_ON_DELIVERY'
        END,
        NEW.total_amount,
        NEW.currency,
        v_delivery_cost,
        NEW.currency,
        NEW.total_amount,
        NEW.currency,
        v_raw->>'notes',
        false,
        v_raw,
        NOW(),
        NOW()
    )
    ON CONFLICT (source_order_id, source) DO UPDATE SET
        order_date = EXCLUDED.order_date,
        status = EXCLUDED.status,
        buyer_login = EXCLUDED.buyer_login,
        buyer_email = EXCLUDED.buyer_email,
        buyer_company = EXCLUDED.buyer_company,
        buyer_first_name = EXCLUDED.buyer_first_name,
        buyer_last_name = EXCLUDED.buyer_last_name,
        buyer_phone = EXCLUDED.buyer_phone,
        buyer_address = EXCLUDED.buyer_address,
        buyer_zip = EXCLUDED.buyer_zip,
        buyer_city = EXCLUDED.buyer_city,
        buyer_country_code = EXCLUDED.buyer_country_code,
        payment_status = EXCLUDED.payment_status,
        payment_type = EXCLUDED.payment_type,
        payment_amount = EXCLUDED.payment_amount,
        delivery_amount = EXCLUDED.delivery_amount,
        total_to_pay_amount = EXCLUDED.total_to_pay_amount,
        buyer_notes = EXCLUDED.buyer_notes,
        raw_payload = EXCLUDED.raw_payload,
        updated_at = NOW();
    
    RETURN NEW;
END;
$$;


ALTER FUNCTION public.sync_shoper_to_commerce() OWNER TO neondb_owner;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: order_items; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.order_items (
    id integer NOT NULL,
    order_id character varying(255) NOT NULL,
    line_item_id character varying(255) NOT NULL,
    offer_id character varying(100),
    offer_external_id character varying(100),
    name text,
    quantity integer,
    price numeric(10,2),
    currency character varying(10),
    tax_rate numeric(5,2),
    tax_subject character varying(50),
    tax_exemption character varying(50),
    fundraising_campaign character varying(255),
    sending_country character varying(10),
    returns_quantity integer DEFAULT 0,
    imported_at timestamp without time zone DEFAULT now(),
    image_url text,
    product_id integer
);


ALTER TABLE allegro.order_items OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.order_items_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.order_items_id_seq OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.order_items_id_seq OWNED BY allegro.order_items.id;


--
-- Name: orders; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.orders (
    id integer NOT NULL,
    order_id character varying(255) NOT NULL,
    seller_id character varying(100),
    seller_login character varying(100),
    order_date timestamp without time zone,
    seller_status character varying(50),
    marketplace character varying(50),
    buyer_id character varying(100),
    buyer_login character varying(100),
    buyer_email character varying(255),
    buyer_company character varying(255),
    buyer_name character varying(255),
    buyer_phone character varying(50),
    buyer_address text,
    buyer_zip character varying(20),
    buyer_city character varying(100),
    buyer_country_code character varying(10),
    payment_id character varying(255),
    payment_status character varying(50),
    payment_provider character varying(50),
    allegro_pay boolean,
    payment_amount numeric(10,2),
    payment_currency character varying(10),
    delivery_method character varying(255),
    delivery_amount numeric(10,2),
    delivery_currency character varying(10),
    total_to_pay_amount numeric(10,2),
    total_to_pay_currency character varying(10),
    buyer_notes text,
    smart boolean,
    tracking_numbers text,
    payment_last_date timestamp without time zone,
    buyer_account_type character varying(50),
    imported_at timestamp without time zone DEFAULT now(),
    payment_type character varying(50),
    invoice_required boolean DEFAULT false,
    shipments jsonb,
    billing_address text,
    refund_amount numeric(10,2) DEFAULT 0,
    refund_date timestamp without time zone,
    refund_reconciliation jsonb,
    has_returns boolean DEFAULT false
);


ALTER TABLE allegro.orders OWNER TO neondb_owner;

--
-- Name: orders_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.orders_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.orders_id_seq OWNER TO neondb_owner;

--
-- Name: orders_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.orders_id_seq OWNED BY allegro.orders.id;


--
-- Name: products; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.products (
    id integer NOT NULL,
    product_id character varying(255),
    external_id character varying(255) NOT NULL,
    name text NOT NULL,
    description text,
    image_url text,
    category text,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE allegro.products OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.products_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.products_id_seq OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.products_id_seq OWNED BY allegro.products.id;


--
-- Name: sync_logs; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.sync_logs (
    id integer NOT NULL,
    sync_started_at timestamp without time zone NOT NULL,
    sync_completed_at timestamp without time zone,
    status character varying(50) NOT NULL,
    orders_fetched integer DEFAULT 0,
    orders_new integer DEFAULT 0,
    orders_updated integer DEFAULT 0,
    error_message text,
    sync_duration_ms integer
);


ALTER TABLE allegro.sync_logs OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.sync_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.sync_logs_id_seq OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.sync_logs_id_seq OWNED BY allegro.sync_logs.id;


--
-- Name: products; Type: TABLE; Schema: catalog; Owner: neondb_owner
--

CREATE TABLE catalog.products (
    id integer NOT NULL,
    source commerce.order_source NOT NULL,
    product_id character varying,
    external_id character varying NOT NULL,
    name text NOT NULL,
    description text,
    image_url text,
    category text,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    raw_data jsonb
);


ALTER TABLE catalog.products OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE; Schema: catalog; Owner: neondb_owner
--

CREATE SEQUENCE catalog.products_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE catalog.products_id_seq OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: catalog; Owner: neondb_owner
--

ALTER SEQUENCE catalog.products_id_seq OWNED BY catalog.products.id;


--
-- Name: order_items; Type: TABLE; Schema: commerce; Owner: neondb_owner
--

CREATE TABLE commerce.order_items (
    id integer NOT NULL,
    order_id character varying NOT NULL,
    source commerce.order_source NOT NULL,
    source_item_id character varying,
    product_id integer,
    offer_id character varying,
    offer_external_id character varying,
    name text,
    quantity integer,
    price numeric,
    currency character varying,
    tax_rate numeric,
    tax_subject character varying,
    image_url text,
    created_at timestamp without time zone DEFAULT now(),
    offer_name text,
    unit_price numeric(10,2),
    total_price numeric(10,2),
    country_code character varying(10),
    payment_type character varying(50),
    invoice_required boolean DEFAULT false,
    raw_data jsonb,
    returns_quantity integer DEFAULT 0
);


ALTER TABLE commerce.order_items OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE; Schema: commerce; Owner: neondb_owner
--

CREATE SEQUENCE commerce.order_items_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE commerce.order_items_id_seq OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE OWNED BY; Schema: commerce; Owner: neondb_owner
--

ALTER SEQUENCE commerce.order_items_id_seq OWNED BY commerce.order_items.id;


--
-- Name: order_number_seq; Type: SEQUENCE; Schema: commerce; Owner: neondb_owner
--

CREATE SEQUENCE commerce.order_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE commerce.order_number_seq OWNER TO neondb_owner;

--
-- Name: orders; Type: TABLE; Schema: commerce; Owner: neondb_owner
--

CREATE TABLE commerce.orders (
    id character varying DEFAULT (gen_random_uuid())::text NOT NULL,
    order_number bigint DEFAULT nextval('commerce.order_number_seq'::regclass),
    order_code character varying(20),
    source commerce.order_source NOT NULL,
    source_order_id character varying NOT NULL,
    order_date timestamp without time zone,
    status character varying,
    buyer_login character varying,
    buyer_email character varying,
    buyer_company character varying,
    buyer_first_name character varying,
    buyer_last_name character varying,
    buyer_phone character varying,
    buyer_address text,
    buyer_zip character varying,
    buyer_city character varying,
    buyer_country_code character varying,
    payment_id character varying,
    payment_status character varying,
    payment_type character varying,
    payment_provider character varying,
    payment_amount numeric,
    payment_currency character varying,
    delivery_method character varying,
    delivery_amount numeric,
    delivery_currency character varying,
    total_to_pay_amount numeric,
    total_to_pay_currency character varying,
    buyer_notes text,
    invoice_required boolean DEFAULT false,
    tracking_numbers text,
    raw_payload jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    buyer_company_name text,
    delivery_address jsonb,
    refund_amount numeric(10,2) DEFAULT 0,
    has_returns boolean DEFAULT false,
    billing_address text,
    shipments jsonb,
    refund_date timestamp without time zone,
    refund_reconciliation jsonb DEFAULT '[]'::jsonb,
    payment_last_date timestamp without time zone,
    billing_zip character varying(50),
    billing_city character varying(255),
    billing_country_code character varying(10),
    tax_id character varying(50),
    smart text,
    allegro_pay text,
    odoo_order_id integer
);


ALTER TABLE commerce.orders OWNER TO neondb_owner;

--
-- Name: orders_order_number_seq; Type: SEQUENCE; Schema: commerce; Owner: neondb_owner
--

CREATE SEQUENCE commerce.orders_order_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE commerce.orders_order_number_seq OWNER TO neondb_owner;

--
-- Name: allegro_connections; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.allegro_connections (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    client_id text NOT NULL,
    client_secret text NOT NULL,
    access_token text,
    refresh_token text,
    token_expires_at timestamp without time zone,
    is_active boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.allegro_connections OWNER TO neondb_owner;

--
-- Name: allegro_orders; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.allegro_orders (
    id character varying NOT NULL,
    allegro_order_id text NOT NULL,
    buyer_login text NOT NULL,
    buyer_email text,
    total_amount numeric(10,2) NOT NULL,
    currency text DEFAULT 'PLN'::text,
    payment_status text NOT NULL,
    fulfillment_status text,
    items_count text NOT NULL,
    order_date timestamp without time zone NOT NULL,
    payment_date timestamp without time zone,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.allegro_orders OWNER TO neondb_owner;

--
-- Name: api_request_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.api_request_logs (
    id integer NOT NULL,
    token_id integer,
    method character varying(10) NOT NULL,
    path text NOT NULL,
    status_code integer,
    response_time integer,
    ip_address character varying(45),
    user_agent text,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.api_request_logs OWNER TO neondb_owner;

--
-- Name: api_request_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.api_request_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_request_logs_id_seq OWNER TO neondb_owner;

--
-- Name: api_request_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.api_request_logs_id_seq OWNED BY public.api_request_logs.id;


--
-- Name: api_tokens; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.api_tokens (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    token text NOT NULL,
    token_prefix character varying(16),
    permissions jsonb DEFAULT '[]'::jsonb,
    is_active boolean DEFAULT true,
    last_used_at timestamp without time zone,
    expires_at timestamp without time zone,
    created_by_user_id integer,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.api_tokens OWNER TO neondb_owner;

--
-- Name: api_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.api_tokens_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_tokens_id_seq OWNER TO neondb_owner;

--
-- Name: api_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.api_tokens_id_seq OWNED BY public.api_tokens.id;


--
-- Name: odoo_config; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.odoo_config (
    id integer NOT NULL,
    url text NOT NULL,
    database character varying(255) NOT NULL,
    username character varying(255) NOT NULL,
    is_active boolean DEFAULT true,
    auto_confirm_orders boolean DEFAULT false,
    sync_interval_minutes integer DEFAULT 3,
    last_sync_at timestamp without time zone,
    last_sync_status character varying(50),
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.odoo_config OWNER TO neondb_owner;

--
-- Name: odoo_config_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.odoo_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.odoo_config_id_seq OWNER TO neondb_owner;

--
-- Name: odoo_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.odoo_config_id_seq OWNED BY public.odoo_config.id;


--
-- Name: odoo_sync_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.odoo_sync_logs (
    id integer NOT NULL,
    queue_id integer,
    order_code character varying(50),
    operation character varying(20) NOT NULL,
    status character varying(50) NOT NULL,
    message text,
    error_details jsonb,
    request_payload jsonb,
    response_data jsonb,
    duration integer,
    odoo_order_id integer,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.odoo_sync_logs OWNER TO neondb_owner;

--
-- Name: odoo_sync_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.odoo_sync_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.odoo_sync_logs_id_seq OWNER TO neondb_owner;

--
-- Name: odoo_sync_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.odoo_sync_logs_id_seq OWNED BY public.odoo_sync_logs.id;


--
-- Name: odoo_sync_queue; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.odoo_sync_queue (
    id integer NOT NULL,
    order_code character varying(50) NOT NULL,
    order_id integer NOT NULL,
    source character varying(20) NOT NULL,
    operation character varying(20) DEFAULT 'create'::character varying NOT NULL,
    status character varying(50) DEFAULT 'pending'::character varying NOT NULL,
    attempts integer DEFAULT 0,
    max_attempts integer DEFAULT 3,
    last_error text,
    odoo_order_id integer,
    scheduled_at timestamp without time zone DEFAULT now(),
    processed_at timestamp without time zone,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.odoo_sync_queue OWNER TO neondb_owner;

--
-- Name: odoo_sync_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.odoo_sync_queue_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.odoo_sync_queue_id_seq OWNER TO neondb_owner;

--
-- Name: odoo_sync_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.odoo_sync_queue_id_seq OWNED BY public.odoo_sync_queue.id;


--
-- Name: order_changes; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.order_changes (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    order_id character varying NOT NULL,
    order_number text,
    order_code text,
    source text NOT NULL,
    change_type text NOT NULL,
    field_changed text,
    old_value text,
    new_value text,
    detected_at timestamp without time zone DEFAULT now(),
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.order_changes OWNER TO neondb_owner;

--
-- Name: password_reset_tokens; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.password_reset_tokens (
    id integer NOT NULL,
    user_id integer NOT NULL,
    token character varying(255) NOT NULL,
    expires_at timestamp without time zone NOT NULL,
    used boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.password_reset_tokens OWNER TO neondb_owner;

--
-- Name: password_reset_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.password_reset_tokens_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.password_reset_tokens_id_seq OWNER TO neondb_owner;

--
-- Name: password_reset_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.password_reset_tokens_id_seq OWNED BY public.password_reset_tokens.id;


--
-- Name: sessions; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.sessions (
    sid character varying NOT NULL,
    sess jsonb NOT NULL,
    expire timestamp without time zone NOT NULL
);


ALTER TABLE public.sessions OWNER TO neondb_owner;

--
-- Name: sync_settings; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.sync_settings (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    auto_refresh_enabled boolean DEFAULT true,
    refresh_interval_minutes text DEFAULT '3'::text,
    last_sync_at timestamp without time zone,
    shoper_auto_refresh_enabled boolean DEFAULT true,
    shoper_refresh_interval_minutes text DEFAULT '5'::text,
    last_shoper_sync_at timestamp without time zone,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.sync_settings OWNER TO neondb_owner;

--
-- Name: users; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.users (
    id integer NOT NULL,
    username character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    password text NOT NULL,
    first_name character varying(255),
    last_name character varying(255),
    role character varying(50) DEFAULT 'user'::character varying NOT NULL,
    permissions jsonb DEFAULT '[]'::jsonb,
    is_active boolean DEFAULT true,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.users OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.users_id_seq OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: webhook_configs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.webhook_configs (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    url text NOT NULL,
    secret text,
    events jsonb DEFAULT '[]'::jsonb,
    is_active boolean DEFAULT true,
    retry_attempts integer DEFAULT 3,
    last_triggered_at timestamp without time zone,
    created_by integer,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.webhook_configs OWNER TO neondb_owner;

--
-- Name: webhook_configs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.webhook_configs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.webhook_configs_id_seq OWNER TO neondb_owner;

--
-- Name: webhook_configs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.webhook_configs_id_seq OWNED BY public.webhook_configs.id;


--
-- Name: webhook_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.webhook_logs (
    id integer NOT NULL,
    webhook_id integer,
    event character varying(100) NOT NULL,
    payload jsonb,
    status_code integer,
    response_body text,
    attempt_number integer DEFAULT 1,
    success boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.webhook_logs OWNER TO neondb_owner;

--
-- Name: webhook_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.webhook_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.webhook_logs_id_seq OWNER TO neondb_owner;

--
-- Name: webhook_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.webhook_logs_id_seq OWNED BY public.webhook_logs.id;


--
-- Name: connections; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.connections (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    shop_url text NOT NULL,
    access_token text,
    refresh_token text,
    token_expires_at timestamp without time zone,
    is_active boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.connections OWNER TO neondb_owner;

--
-- Name: order_items; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.order_items (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    order_id character varying NOT NULL,
    shoper_product_id text,
    product_name text NOT NULL,
    quantity integer NOT NULL,
    unit_price numeric(10,2) NOT NULL,
    total_price numeric(10,2) NOT NULL,
    image_url text,
    payment_type text,
    invoice_required boolean DEFAULT false,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.order_items OWNER TO neondb_owner;

--
-- Name: orders; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.orders (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    shoper_order_id text NOT NULL,
    buyer_login text NOT NULL,
    buyer_email text,
    total_amount numeric(10,2) NOT NULL,
    currency text DEFAULT 'PLN'::text,
    payment_status text NOT NULL,
    fulfillment_status text,
    items_count text NOT NULL,
    order_date timestamp without time zone NOT NULL,
    payment_date timestamp without time zone,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    shipments jsonb
);


ALTER TABLE shoper.orders OWNER TO neondb_owner;

--
-- Name: products; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.products (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    shoper_product_id text NOT NULL,
    name text NOT NULL,
    sku text,
    price numeric(10,2),
    stock_quantity integer,
    image_url text,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.products OWNER TO neondb_owner;

--
-- Name: sync_logs; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.sync_logs (
    id integer NOT NULL,
    sync_started_at timestamp without time zone NOT NULL,
    sync_finished_at timestamp without time zone,
    orders_count integer DEFAULT 0,
    success boolean DEFAULT false,
    error_message text,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.sync_logs OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE; Schema: shoper; Owner: neondb_owner
--

CREATE SEQUENCE shoper.sync_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE shoper.sync_logs_id_seq OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: shoper; Owner: neondb_owner
--

ALTER SEQUENCE shoper.sync_logs_id_seq OWNED BY shoper.sync_logs.id;


--
-- Name: order_items id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.order_items ALTER COLUMN id SET DEFAULT nextval('allegro.order_items_id_seq'::regclass);


--
-- Name: orders id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.orders ALTER COLUMN id SET DEFAULT nextval('allegro.orders_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.products ALTER COLUMN id SET DEFAULT nextval('allegro.products_id_seq'::regclass);


--
-- Name: sync_logs id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.sync_logs ALTER COLUMN id SET DEFAULT nextval('allegro.sync_logs_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: catalog; Owner: neondb_owner
--

ALTER TABLE ONLY catalog.products ALTER COLUMN id SET DEFAULT nextval('catalog.products_id_seq'::regclass);


--
-- Name: order_items id; Type: DEFAULT; Schema: commerce; Owner: neondb_owner
--

ALTER TABLE ONLY commerce.order_items ALTER COLUMN id SET DEFAULT nextval('commerce.order_items_id_seq'::regclass);


--
-- Name: api_request_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_request_logs ALTER COLUMN id SET DEFAULT nextval('public.api_request_logs_id_seq'::regclass);


--
-- Name: api_tokens id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_tokens ALTER COLUMN id SET DEFAULT nextval('public.api_tokens_id_seq'::regclass);


--
-- Name: odoo_config id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.odoo_config ALTER COLUMN id SET DEFAULT nextval('public.odoo_config_id_seq'::regclass);


--
-- Name: odoo_sync_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.odoo_sync_logs ALTER COLUMN id SET DEFAULT nextval('public.odoo_sync_logs_id_seq'::regclass);


--
-- Name: odoo_sync_queue id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.odoo_sync_queue ALTER COLUMN id SET DEFAULT nextval('public.odoo_sync_queue_id_seq'::regclass);


--
-- Name: password_reset_tokens id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.password_reset_tokens ALTER COLUMN id SET DEFAULT nextval('public.password_reset_tokens_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Name: webhook_configs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.webhook_configs ALTER COLUMN id SET DEFAULT nextval('public.webhook_configs_id_seq'::regclass);


--
-- Name: webhook_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.webhook_logs ALTER COLUMN id SET DEFAULT nextval('public.webhook_logs_id_seq'::regclass);


--
-- Name: sync_logs id; Type: DEFAULT; Schema: shoper; Owner: neondb_owner
--

ALTER TABLE ONLY shoper.sync_logs ALTER COLUMN id SET DEFAULT nextval('shoper.sync_logs_id_seq'::regclass);


--
-- Data for Name: order_items; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.order_items (id, order_id, line_item_id, offer_id, offer_external_id, name, quantity, price, currency, tax_rate, tax_subject, tax_exemption, fundraising_campaign, sending_country, returns_quantity, imported_at, image_url, product_id) FROM stdin;
799	2472fa10-a2c4-11f0-8e98-fdfd51e10ba4	246b58f0-a2c4-11f0-8e98-fdfd51e10ba4	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:46.315283	\N	7
39	a997f0e0-a217-11f0-83df-53954cf6c551	a9904fc0-a217-11f0-83df-53954cf6c551	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:05.138351	\N	16
54	bce3c350-a1f8-11f0-a6cc-b3145592fdde	bcdce582-a1f8-11f0-a6cc-b3145592fdde	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:20.304219	\N	61
79	95595a70-a1bc-11f0-a6cc-b3145592fdde	95525590-a1bc-11f0-a6cc-b3145592fdde	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	1	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:52.977557	\N	84
7303	c8e0d140-a2e6-11f0-a638-c7e352f2113f	c8d78271-a2e6-11f0-a638-c7e352f2113f	15250482464	5905806215212	Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN	1	1832.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.878245	\N	2464
5039	25f49990-a2db-11f0-bfbd-d3aacc6a2e00	25f005b0-a2db-11f0-bfbd-d3aacc6a2e00	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:41.64475	\N	49
5040	35868030-a2db-11f0-8b51-87d1833631ec	35817720-a2db-11f0-8b51-87d1833631ec	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:42.05297	\N	347
5041	13300610-a2da-11f0-96ea-bf4f56b08af2	132bc050-a2da-11f0-96ea-bf4f56b08af2	16859417789	5905806210613	Półka ścienna 80x18x20cm CZARNY	1	98.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:42.462722	\N	348
10	74ee70b0-a28c-11f0-9d66-3d00eb1ccfed	74e6a880-a28c-11f0-9d66-3d00eb1ccfed	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	1	725.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:50.851745	\N	17
6515	7a343390-a2e4-11f0-bee6-2fee815ffc9f	7a2d07a0-a2e4-11f0-bee6-2fee815ffc9f	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:40.833471	\N	49
5654	b2342af0-a2e1-11f0-aba2-b3553c261cc2	b22cb0e0-a2e1-11f0-aba2-b3553c261cc2	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:41.2389	\N	921
5043	61869be0-a2d9-11f0-a638-c7e352f2113f	617f48e0-a2d9-11f0-a638-c7e352f2113f	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:43.348278	\N	350
1	989a5e50-a2b1-11f0-96ea-bf4f56b08af2	989491f0-a2b1-11f0-96ea-bf4f56b08af2	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:47.538854	\N	4
4424	898146d0-a2d5-11f0-9468-2bd22967b382	8979ccc0-a2d5-11f0-9468-2bd22967b382	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	457.80	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:43.753422	\N	1
3	05ff2210-a2a7-11f0-a638-c7e352f2113f	05f81d30-a2a7-11f0-a638-c7e352f2113f	17567410245	\N	Poduszka ozdobna, dekoracyjna 50x30cm	1	37.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:48.36032	\N	\N
12	092d0510-a289-11f0-b024-2112831760cb	0927d4f0-a289-11f0-b024-2112831760cb	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	1	341.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:51.668214	\N	19
8302	0b61c0f0-a2ed-11f0-8e98-fdfd51e10ba4	0b5a9500-a2ed-11f0-8e98-fdfd51e10ba4	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.001216	\N	71
7800	c0249260-a2e8-11f0-8144-0ba8ff5b8d19	c01fd770-a2e8-11f0-8144-0ba8ff5b8d19	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.460395	\N	23
3556	0861c630-a2d3-11f0-bfbd-d3aacc6a2e00	085ce430-a2d3-11f0-bfbd-d3aacc6a2e00	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	1	1136.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:44.62111	\N	3
2	3f589880-a2b0-11f0-9468-2bd22967b382	3f514580-a2b0-11f0-9468-2bd22967b382	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:47.944898	\N	11
11	b5925ca0-a28a-11f0-abd8-f5344f24907b	b58b30b0-a28a-11f0-abd8-f5344f24907b	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:51.264554	\N	18
110	68bf4590-a0f6-11f0-8323-6df02f435f6c	68bad8c0-a0f6-11f0-8323-6df02f435f6c	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 17:22:43.295573	\N	41
38	ebc198d0-a21d-11f0-a6cc-b3145592fdde	ebb87110-a21d-11f0-a6cc-b3145592fdde	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	1	550.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:03.351154	\N	45
4	38d3bef0-a2a5-11f0-a6c9-036cfc044caf	38cc44e0-a2a5-11f0-a6c9-036cfc044caf	17736445207	\N	Szafka na buty VB60x30D1N1 KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:48.732294	\N	\N
7304	c8e0d140-a2e6-11f0-a638-c7e352f2113f	c8d78270-a2e6-11f0-a638-c7e352f2113f	15463830012	5905806220605	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	1	1052.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.878245	\N	2465
5042	b0967a20-a2d9-11f0-abd8-f5344f24907b	b08f0010-a2d9-11f0-abd8-f5344f24907b	12487594410	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:42.937473	\N	349
1171	b5ec64e0-a2c9-11f0-abd8-f5344f24907b	b5e56000-a2c9-11f0-abd8-f5344f24907b	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:45.860476	\N	6
800	e783f970-a2bd-11f0-b024-2112831760cb	e77ea240-a2bd-11f0-b024-2112831760cb	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:46.71877	\N	8
9217	274751f0-a544-11f0-bb74-8b6fbb6f100b	27407420-a544-11f0-bb74-8b6fbb6f100b	13855292522	5905806200010	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:32:59.478629	\N	4261
9218	9b0d65e0-a53d-11f0-a008-2360f331b758	9b096e40-a53d-11f0-a008-2360f331b758	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:01.106023	\N	49
9219	b54142b0-a538-11f0-9da2-81c6f7d897d8	b53a64e0-a538-11f0-9da2-81c6f7d897d8	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:02.474009	\N	98
25	293909b0-a22c-11f0-809f-f9f6de958f67	2931ddc0-a22c-11f0-809f-f9f6de958f67	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	1	447.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:51.969786	\N	32
32	568e1d20-a221-11f0-83df-53954cf6c551	56867c00-a221-11f0-83df-53954cf6c551	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	1	1352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:58.724698	\N	39
34	c5ae0f50-a21f-11f0-96ea-bf4f56b08af2	c5a90640-a21f-11f0-96ea-bf4f56b08af2	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:00.385471	\N	41
35	1ece4030-a21d-11f0-8c5e-eb0a288ebc91	1ec95e30-a21d-11f0-8c5e-eb0a288ebc91	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:01.827597	\N	42
19	ed908310-a236-11f0-b1e3-b7ce882fc700	ed8c3d50-a236-11f0-b1e3-b7ce882fc700	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	1	564.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:47.255143	\N	26
15	952bb881-a271-11f0-9468-2bd22967b382	95248c91-a271-11f0-9468-2bd22967b382	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:52.886558	\N	7
22	68cb3021-a22d-11f0-954f-f9092bddbf0d	68c5d8f1-a22d-11f0-954f-f9092bddbf0d	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:50.461152	\N	29
20	93c15c40-a233-11f0-a6cc-b3145592fdde	93baa581-a233-11f0-a6cc-b3145592fdde	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:48.761018	\N	27
45	e4f4e930-a204-11f0-9d66-3d00eb1ccfed	e4edbd40-a204-11f0-9d66-3d00eb1ccfed	17946229799	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:11.385311	\N	12
48	c68fea00-a202-11f0-9468-2bd22967b382	c688be10-a202-11f0-9468-2bd22967b382	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	1	344.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:15.890965	\N	55
50	0dc59e40-a200-11f0-a6cc-b3145592fdde	0dbe4b40-a200-11f0-a6cc-b3145592fdde	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:17.518733	\N	57
55	8900fcb0-a1f8-11f0-8865-a987ea6c1e01	88f95b90-a1f8-11f0-8865-a987ea6c1e01	17532811873	\N	Szafka na buty, słupek SUPRA-TRES 30x30 Biały	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:22.039809	\N	\N
17	969f5ca0-a238-11f0-b1e3-b7ce882fc700	963f6250-a238-11f0-b1e3-b7ce882fc700	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	1	595.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:45.567104	\N	24
8550	24befdc0-a2f1-11f0-8144-0ba8ff5b8d19	24b42850-a2f1-11f0-8144-0ba8ff5b8d19	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1	1807.60	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:38.433125	\N	14
6884	907c6f90-a2e5-11f0-bfbd-d3aacc6a2e00	90776680-a2e5-11f0-bfbd-d3aacc6a2e00	14384920401	5905806201840	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:40.421628	\N	2071
9	d840e830-a293-11f0-997b-19b8e7655382	d8377250-a293-11f0-997b-19b8e7655382	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:50.440623	\N	16
23	293909b0-a22c-11f0-809f-f9f6de958f67	2931ddc2-a22c-11f0-809f-f9f6de958f67	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:51.969786	\N	30
24	293909b0-a22c-11f0-809f-f9f6de958f67	2931ddc1-a22c-11f0-809f-f9f6de958f67	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	1	594.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:51.969786	\N	31
26	52cd4060-a228-11f0-a6cc-b3145592fdde	52c3f190-a228-11f0-a6cc-b3145592fdde	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	1	564.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:53.773874	\N	33
27	56379be0-a225-11f0-a82d-fde841cbe8d5	56326bc1-a225-11f0-a82d-fde841cbe8d5	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:55.275374	\N	34
28	56379be0-a225-11f0-a82d-fde841cbe8d5	56326bc2-a225-11f0-a82d-fde841cbe8d5	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:55.275374	\N	35
30	26221bd0-a223-11f0-bddc-ebae77b3e555	261aefe0-a223-11f0-bddc-ebae77b3e555	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	1	508.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:57.070851	\N	37
33	568e1d20-a221-11f0-83df-53954cf6c551	56867c01-a221-11f0-83df-53954cf6c551	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	1	857.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:58.724698	\N	40
36	ebc198d0-a21d-11f0-a6cc-b3145592fdde	ebb87112-a21d-11f0-a6cc-b3145592fdde	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:03.351154	\N	43
37	ebc198d0-a21d-11f0-a6cc-b3145592fdde	ebb87111-a21d-11f0-a6cc-b3145592fdde	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:03.351154	\N	44
46	9f49fb00-a204-11f0-b1e3-b7ce882fc700	9f451900-a204-11f0-b1e3-b7ce882fc700	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:12.904683	\N	53
16	363671e0-a270-11f0-8e98-fdfd51e10ba4	36303050-a270-11f0-8e98-fdfd51e10ba4	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:53.299783	\N	23
47	2dddfd50-a203-11f0-bdc8-e34a18959311	2dd9b790-a203-11f0-bdc8-e34a18959311	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	1	963.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:14.39478	\N	54
9224	201f4571-a537-11f0-b89d-d9b346103272	200fb511-a537-11f0-b89d-d9b346103272	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:02.352246	\N	7
31	26221bd0-a223-11f0-bddc-ebae77b3e555	261aefe1-a223-11f0-bddc-ebae77b3e555	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:57.070851	\N	38
9225	137c4160-a537-11f0-9cb2-b90a5baab897	13758aa0-a537-11f0-9cb2-b90a5baab897	16859415981	5905806210293	Półka ścienna 50x18x20cm WOTAN	1	76.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:05.168128	\N	4269
9226	69c2c560-a534-11f0-a008-2360f331b758	69bea6b0-a534-11f0-a008-2360f331b758	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:06.492133	\N	4270
9227	84ca8da0-a527-11f0-a444-6d64b3cc877f	84c5aba0-a527-11f0-a444-6d64b3cc877f	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	2	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:07.807719	\N	350
64	394fc140-a1eb-11f0-b1e3-b7ce882fc700	394b5470-a1eb-11f0-b1e3-b7ce882fc700	17736463271	\N	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm KASZMIR	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:27.436274	\N	\N
72	33875f10-a1ce-11f0-954f-f9092bddbf0d	337c3b80-a1ce-11f0-954f-f9092bddbf0d	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:43.902051	\N	77
76	ed350e50-a1c2-11f0-9468-2bd22967b382	ed2dbb50-a1c2-11f0-9468-2bd22967b382	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	2	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:49.965101	\N	81
102	66a16aa0-a122-11f0-baf0-af7ea74e3d0e	6699c980-a122-11f0-baf0-af7ea74e3d0e	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:22.997025	\N	\N
52	bce3c350-a1f8-11f0-a6cc-b3145592fdde	bcdce581-a1f8-11f0-a6cc-b3145592fdde	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	1	54.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:20.304219	\N	59
56	caf7ce70-a1f6-11f0-9468-2bd22967b382	caf0a280-a1f6-11f0-9468-2bd22967b382	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	3	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:23.4191	\N	62
57	463f6510-a1f3-11f0-9468-2bd22967b382	46381210-a1f3-11f0-9468-2bd22967b382	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:24.949312	\N	63
60	698624e0-a1ef-11f0-84a0-0fb86e0c96e9	6981df20-a1ef-11f0-84a0-0fb86e0c96e9	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:29.418346	\N	66
67	c9711b50-a1de-11f0-954f-f9092bddbf0d	c96cfca0-a1de-11f0-954f-f9092bddbf0d	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:35.667074	\N	72
61	6c211080-a1ee-11f0-ac86-5dc583ff1e95	6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:30.915188	\N	4
62	9a2d1e40-a1eb-11f0-9d66-3d00eb1ccfed	9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:32.414177	\N	1
68	a209e250-a1d8-11f0-aa33-a79405b55c6d	a2030480-a1d8-11f0-aa33-a79405b55c6d	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:37.130684	\N	73
69	d47b0d00-a1d7-11f0-9d66-3d00eb1ccfed	d4736be0-a1d7-11f0-9d66-3d00eb1ccfed	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	1	977.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:38.630984	\N	74
77	7eb9b2d0-a1bf-11f0-bfbd-d3aacc6a2e00	7eb56d10-a1bf-11f0-bfbd-d3aacc6a2e00	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:51.486052	\N	82
84	8eab3fe0-a162-11f0-a6cc-b3145592fdde	8ea377b0-a162-11f0-a6cc-b3145592fdde	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:59.247977	\N	\N
58	3bdeafe0-a1f3-11f0-a6cc-b3145592fdde	3bd7f920-a1f3-11f0-a6cc-b3145592fdde	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	1	954.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:26.431286	\N	64
65	c50f7971-a1df-11f0-ac86-5dc583ff1e95	c507ff61-a1df-11f0-ac86-5dc583ff1e95	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:34.036455	\N	70
9228	78eca3c0-a526-11f0-8895-094b8cada9e7	78e66230-a526-11f0-8895-094b8cada9e7	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:09.134561	\N	75
51	935f63c0-a1ff-11f0-8e98-fdfd51e10ba4	9357c2a0-a1ff-11f0-8e98-fdfd51e10ba4	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:18.981615	\N	57
59	d63f36f0-a1f2-11f0-b871-03a75625f948	d63af130-a1f2-11f0-b871-03a75625f948	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:27.941967	\N	65
63	9a2d1e40-a1eb-11f0-9d66-3d00eb1ccfed	9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed	17946230281	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:32.414177	\N	13
66	c50f7971-a1df-11f0-ac86-5dc583ff1e95	c507ff62-a1df-11f0-ac86-5dc583ff1e95	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:34.036455	\N	71
71	da174e91-a1d2-11f0-9d66-3d00eb1ccfed	da1070c0-a1d2-11f0-9d66-3d00eb1ccfed	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:41.82403	\N	76
86	db63fdd0-a159-11f0-9468-2bd22967b382	db5d2000-a159-11f0-9468-2bd22967b382	17739061173	\N	Wieszak ścienny WP60 na ubrania 60cm SONOMA CZARNY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:02.125041	\N	\N
88	f041b5b0-a14c-11f0-a6cc-b3145592fdde	f03afef0-a14c-11f0-a6cc-b3145592fdde	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	1	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:03.693467	\N	\N
70	e23a1a50-a1d5-11f0-8865-a987ea6c1e01	e2333c80-a1d5-11f0-8865-a987ea6c1e01	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:40:40.095051	\N	75
9229	6a9651c0-a523-11f0-a204-f12f4b71e7fe	6a923310-a523-11f0-a204-f12f4b71e7fe	16271341145	5905806233391	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:10.435375	\N	4273
9230	e9aba750-a521-11f0-b989-75c7faccd1ca	e9a4c980-a521-11f0-b989-75c7faccd1ca	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:11.777365	\N	4274
9231	6d4cfc60-a51a-11f0-a588-b391296a673a	6d481a60-a51a-11f0-a588-b391296a673a	16602435285	5905806234589	Komoda Bini 50x36 D1N1 WOTAN	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:13.158206	\N	4275
9232	5448b830-a51a-11f0-9bfc-3dd64ee50ad6	5441b350-a51a-11f0-9bfc-3dd64ee50ad6	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:14.468451	\N	82
9233	b3f8dca0-a516-11f0-a5d7-371746f07634	b3ee0730-a516-11f0-a5d7-371746f07634	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:15.780528	\N	2
9234	8922fc00-a50b-11f0-9b0c-e511fc7361fa	891abea0-a50b-11f0-9b0c-e511fc7361fa	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	1	1430.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:17.087355	\N	4278
18	969f5ca0-a238-11f0-b1e3-b7ce882fc700	963f6251-a238-11f0-b1e3-b7ce882fc700	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	1	545.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:45.567104	\N	25
9235	268f0bd1-a4ff-11f0-b9bf-2795de008363	2688a332-a4ff-11f0-b9bf-2795de008363	14387672711	5905806202335	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:18.40805	\N	4279
6	8d77a490-a2a4-11f0-8d49-a16d7ed74f8d	8d6be4c0-a2a4-11f0-8d49-a16d7ed74f8d	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:49.071642	\N	13
40	a997f0e0-a217-11f0-83df-53954cf6c551	a9904fc1-a217-11f0-83df-53954cf6c551	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:05.138351	\N	47
75	65d8f0a0-a1c9-11f0-9d66-3d00eb1ccfed	65d12870-a1c9-11f0-9d66-3d00eb1ccfed	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	1	715.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:48.482457	\N	80
83	0f4702d1-a16b-11f0-8e98-fdfd51e10ba4	0f3d3ed1-a16b-11f0-8e98-fdfd51e10ba4	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:57.767472	\N	88
85	6a9bb600-a15f-11f0-8e98-fdfd51e10ba4	6a952650-a15f-11f0-8e98-fdfd51e10ba4	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:00.64849	\N	30
78	95595a70-a1bc-11f0-a6cc-b3145592fdde	95525592-a1bc-11f0-a6cc-b3145592fdde	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:52.977557	\N	83
81	61bbd700-a1b8-11f0-96ea-bf4f56b08af2	61b176c0-a1b8-11f0-96ea-bf4f56b08af2	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:54.766485	\N	2
82	00cde260-a16f-11f0-a6cc-b3145592fdde	00c72ba0-a16f-11f0-a6cc-b3145592fdde	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	434.90	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:56.295878	\N	87
90	28710f90-a14c-11f0-9468-2bd22967b382	286a31c0-a14c-11f0-9468-2bd22967b382	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:05.266723	\N	92
91	80593270-a145-11f0-96ea-bf4f56b08af2	8054c5a0-a145-11f0-96ea-bf4f56b08af2	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:06.740201	\N	93
92	2fb0e140-a142-11f0-9d66-3d00eb1ccfed	2faa5190-a142-11f0-9d66-3d00eb1ccfed	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:08.213471	\N	94
94	2413b570-a137-11f0-8323-6df02f435f6c	240ed370-a137-11f0-8323-6df02f435f6c	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:11.166047	\N	7
95	893ee8c2-a137-11f0-9d66-3d00eb1ccfed	89365d47-a137-11f0-9d66-3d00eb1ccfed	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:12.644539	\N	97
96	dc074280-a134-11f0-96ea-bf4f56b08af2	dc02d5b0-a134-11f0-96ea-bf4f56b08af2	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:14.126933	\N	98
98	cee26871-a12d-11f0-b1e3-b7ce882fc700	cedcea31-a12d-11f0-b1e3-b7ce882fc700	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:17.079634	\N	41
99	985df1b0-a129-11f0-bfbd-d3aacc6a2e00	985984e0-a129-11f0-bfbd-d3aacc6a2e00	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:18.581203	\N	101
9240	f621b350-a4f2-11f0-9b0c-e511fc7361fa	f61927d0-a4f2-11f0-9b0c-e511fc7361fa	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 20:15:49.82405	\N	4282
13	ea829fd0-a283-11f0-aba2-b3553c261cc2	ea7b73e0-a283-11f0-aba2-b3553c261cc2	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:52.071739	\N	12
100	962c7da0-a127-11f0-b1e3-b7ce882fc700	96277490-a127-11f0-b1e3-b7ce882fc700	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:20.077393	\N	102
101	4a9b1490-a123-11f0-a6cc-b3145592fdde	4a945dd0-a123-11f0-a6cc-b3145592fdde	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:21.538709	\N	65
14	fe9dd160-a27e-11f0-a6cc-b3145592fdde	fe967e60-a27e-11f0-a6cc-b3145592fdde	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:52.478694	\N	21
42	68ef7970-a20b-11f0-b1e3-b7ce882fc700	68eb0ca0-a20b-11f0-b1e3-b7ce882fc700	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:08.266022	\N	49
73	4e91fa90-a1ce-11f0-954f-f9092bddbf0d	4e8d66b0-a1ce-11f0-954f-f9092bddbf0d	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	1	692.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:45.426522	\N	78
74	4289c930-a1c9-11f0-b871-03a75625f948	4284e730-a1c9-11f0-b871-03a75625f948	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	2	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:46.948068	\N	49
87	db63fdd0-a159-11f0-9468-2bd22967b382	db5d2001-a159-11f0-9468-2bd22967b382	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:02.125041	\N	90
93	20dbfe80-a141-11f0-8e98-fdfd51e10ba4	20d547c0-a141-11f0-8e98-fdfd51e10ba4	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:09.706651	\N	75
89	f041b5b0-a14c-11f0-a6cc-b3145592fdde	f03afef1-a14c-11f0-a6cc-b3145592fdde	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	1	64.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:03.693467	\N	91
97	b661cf00-a134-11f0-8323-6df02f435f6c	b6576ec0-a134-11f0-8323-6df02f435f6c	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	1	1286.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:15.60664	\N	99
9237	ce8de6e0-a4fe-11f0-961e-6d069f850ff8	ce875730-a4fe-11f0-961e-6d069f850ff8	17731209472	\N	Szafka na buty VB60x30D1N2 BIAŁY	1	370.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:19.876483	\N	\N
9238	8c2ca9a0-a4f7-11f0-a444-6d64b3cc877f	8c283cd0-a4f7-11f0-a444-6d64b3cc877f	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:21.116625	\N	4281
9239	243cd4e0-a4f3-11f0-a588-b391296a673a	24386810-a4f3-11f0-a588-b391296a673a	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:22.970421	\N	4282
29	56379be0-a225-11f0-a82d-fde841cbe8d5	56326bc0-a225-11f0-a82d-fde841cbe8d5	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:55.275374	\N	36
5	8d77a490-a2a4-11f0-8d49-a16d7ed74f8d	8d6be4c1-a2a4-11f0-8d49-a16d7ed74f8d	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:49.071642	\N	12
7	5bd33960-a29d-11f0-a638-c7e352f2113f	5bcb2310-a29d-11f0-a638-c7e352f2113f	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1	1807.60	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:49.624446	\N	14
8	59852450-a295-11f0-bee6-2fee815ffc9f	597b6050-a295-11f0-bee6-2fee815ffc9f	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:50.028838	\N	15
9241	2cec7420-a4f2-11f0-9da2-81c6f7d897d8	2ce52120-a4f2-11f0-9da2-81c6f7d897d8	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:25.766553	\N	57
9242	a9729de0-a4f1-11f0-a402-d9289fd02c21	a96e3110-a4f1-11f0-a402-d9289fd02c21	17533930958	\N	Szafka na buty Supra 30 słupek 30x36 Kaszmir	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:27.218214	\N	\N
9243	3df7e2c0-a4ef-11f0-b9bf-2795de008363	3ded5b70-a4ef-11f0-b9bf-2795de008363	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:28.564613	\N	34
9244	b8cfe420-a4ea-11f0-b89d-d9b346103272	b8c50eb0-a4ea-11f0-b89d-d9b346103272	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:29.989278	\N	12
9245	5ce2e000-a4df-11f0-961e-6d069f850ff8	5cdbdb20-a4df-11f0-961e-6d069f850ff8	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	1	884.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:31.441819	\N	4287
9246	6d4c85d0-a4db-11f0-a444-6d64b3cc877f	6d47a3d0-a4db-11f0-a444-6d64b3cc877f	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:32.852629	\N	71
9305	cad06af0-a454-11f0-a471-6bb0586de370	cac93f00-a454-11f0-a471-6bb0586de370	10862932479	5905806209532	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	1	532.60	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:55.297684	\N	4345
9306	71cfc9a0-a44f-11f0-a4f0-7ba876f09f6f	71c4a610-a44f-11f0-a4f0-7ba876f09f6f	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:56.822981	\N	41
9307	3b69b380-a44f-11f0-88a6-1f93f938b7b3	3b62aea0-a44f-11f0-88a6-1f93f938b7b3	15178440255	5905806210118	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	1	636.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:58.363732	\N	4347
9308	25b7bdb0-a446-11f0-9322-81ad33e97c6b	25b23f70-a446-11f0-9322-81ad33e97c6b	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:59.964151	\N	23
9309	8eddd0e0-a43c-11f0-96d3-f7121b08a32c	8ed915f0-a43c-11f0-96d3-f7121b08a32c	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:01.533573	\N	4349
9310	c0ad0550-a432-11f0-a6cc-b3145592fdde	c0a51610-a432-11f0-a6cc-b3145592fdde	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:03.124553	\N	4350
9311	bce878b1-a431-11f0-af7e-5f793825db67	bce19ae0-a431-11f0-af7e-5f793825db67	15919730348	5905806228830	Komoda Bones 60x30D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:04.745058	\N	4351
41	6fcc9b40-a20d-11f0-bdc8-e34a18959311	6fc7b940-a20d-11f0-bdc8-e34a18959311	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:06.790098	\N	48
43	68ef7970-a20b-11f0-b1e3-b7ce882fc700	68eb0ca1-a20b-11f0-b1e3-b7ce882fc700	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	1	169.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:08.266022	\N	50
44	2aff7c30-a208-11f0-a6cc-b3145592fdde	2af87750-a208-11f0-a6cc-b3145592fdde	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:09.875236	\N	51
49	c68fea00-a202-11f0-9468-2bd22967b382	c688be11-a202-11f0-9468-2bd22967b382	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	1	531.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:15.890965	\N	56
9247	550c2350-a4da-11f0-9b0c-e511fc7361fa	55056c90-a4da-11f0-9b0c-e511fc7361fa	15876902214	5905806215175	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:34.232752	\N	4289
9248	6af85971-a4d7-11f0-8311-bd038e33f1de	6af0df61-a4d7-11f0-8311-bd038e33f1de	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:35.64642	\N	9
9249	a9d70f60-a4cd-11f0-a588-b391296a673a	a9d22d60-a4cd-11f0-a588-b391296a673a	15225620833	5905806213386	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:37.044975	\N	4291
9256	05ac2481-a472-11f0-a685-3b2ebe8a80a1	05a100f2-a472-11f0-a685-3b2ebe8a80a1	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	1	196.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:46.842809	\N	28
9257	05ac2481-a472-11f0-a685-3b2ebe8a80a1	05a100f1-a472-11f0-a685-3b2ebe8a80a1	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	747.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:46.842809	\N	51
9258	d754ab50-a473-11f0-b12e-53a023ce25d9	d74d5850-a473-11f0-b12e-53a023ce25d9	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:48.41784	\N	49
9259	a8a50430-a46e-11f0-b989-75c7faccd1ca	a89e4d70-a46e-11f0-b989-75c7faccd1ca	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:49.816947	\N	34
9260	95930970-a46c-11f0-a685-3b2ebe8a80a1	958e7590-a46c-11f0-a685-3b2ebe8a80a1	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:51.19413	\N	92
9312	36778280-a431-11f0-8f13-933da22fca3d	36702f81-a431-11f0-8f13-933da22fca3d	16521833793	5905806227130	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:06.275499	\N	4352
9313	36778280-a431-11f0-8f13-933da22fca3d	36702f80-a431-11f0-8f13-933da22fca3d	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:06.275499	\N	4353
9253	dfc1f3f0-a47e-11f0-a4f0-7ba876f09f6f	dfb68240-a47e-11f0-a4f0-7ba876f09f6f	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:42.627656	\N	2
9254	88fcb1c0-a47b-11f0-a471-6bb0586de370	88f62210-a47b-11f0-a471-6bb0586de370	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:44.093976	\N	34
9255	a86e7f50-a478-11f0-8895-094b8cada9e7	a867c890-a478-11f0-8895-094b8cada9e7	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:45.474263	\N	49
9261	2756b3c0-a45e-11f0-9583-47424f8c2810	274f87d0-a45e-11f0-9583-47424f8c2810	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:52.568984	\N	94
118	db0dc990-a07f-11f0-9a42-bb8e9ffafe52	db036950-a07f-11f0-9a42-bb8e9ffafe52	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:28.20184	\N	4281
9262	5da97f10-a455-11f0-b989-75c7faccd1ca	5da1b6e0-a455-11f0-b989-75c7faccd1ca	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	1	368.80	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:53.953576	\N	4304
9314	97ae46f0-a42d-11f0-a6cc-b3145592fdde	97a6a5d0-a42d-11f0-a6cc-b3145592fdde	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:08.004649	\N	41
122	b85b60b0-a066-11f0-96ea-bf4f56b08af2	b856a5c0-a066-11f0-96ea-bf4f56b08af2	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:34.156421	\N	92
9315	83027ce0-a42c-11f0-96ea-bf4f56b08af2	82f7f590-a42c-11f0-96ea-bf4f56b08af2	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:09.582562	\N	12
9324	7ed27320-a3fd-11f0-b1e3-b7ce882fc700	7ecddf40-a3fd-11f0-b1e3-b7ce882fc700	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:23.811542	\N	30
9325	3bc5ddb0-a3d5-11f0-a6cc-b3145592fdde	3bbe63a0-a3d5-11f0-a6cc-b3145592fdde	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:25.56247	\N	71
2688	6189e650-a2d0-11f0-abc1-17dd0035cfdf	61829350-a2d0-11f0-abc1-17dd0035cfdf	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:45.03508	\N	4
1448	aa7dfe50-a2cb-11f0-8144-0ba8ff5b8d19	aa78ce30-a2cb-11f0-8144-0ba8ff5b8d19	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:45.449282	\N	5
689	c301a2d0-a2b5-11f0-abc1-17dd0035cfdf	c2fa28c0-a2b5-11f0-abc1-17dd0035cfdf	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:47.126296	\N	9
9326	bd085b30-a3cd-11f0-bfbd-d3aacc6a2e00	bd041570-a3cd-11f0-bfbd-d3aacc6a2e00	14910130346	5905806204049	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	1	811.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:27.019116	\N	4366
9327	3ccf7490-a3cc-11f0-a6cc-b3145592fdde	3cc896c0-a3cc-11f0-a6cc-b3145592fdde	14910130495	5905806204056	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	1	811.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:28.488246	\N	4367
9328	bb165360-a3c6-11f0-9d66-3d00eb1ccfed	bb0feac0-a3c6-11f0-9d66-3d00eb1ccfed	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:29.944915	\N	4368
9250	e64fe9b0-a493-11f0-a471-6bb0586de370	e64932f0-a493-11f0-a471-6bb0586de370	14388158414	5905806202694	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	1	643.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:38.4484	\N	4292
9251	63e21820-a486-11f0-b989-75c7faccd1ca	63dbd690-a486-11f0-b989-75c7faccd1ca	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	1	1750.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:39.841229	\N	4293
9252	04361df1-a480-11f0-bfb1-c5232bd647f2	04305191-a480-11f0-bfb1-c5232bd647f2	17358967427	5905806237825	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	1	835.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:41.242995	\N	4294
9329	877577c0-a3c6-11f0-9a42-bb8e9ffafe52	876a7b41-a3c6-11f0-9a42-bb8e9ffafe52	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	4	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:31.511017	\N	\N
9330	877577c0-a3c6-11f0-9a42-bb8e9ffafe52	876a7b40-a3c6-11f0-9a42-bb8e9ffafe52	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	1	87.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:31.511017	\N	4369
9332	3f06f230-a3c5-11f0-96ea-bf4f56b08af2	3f028560-a3c5-11f0-96ea-bf4f56b08af2	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:34:33.083616	\N	4368
9331	3f06f230-a3c5-11f0-96ea-bf4f56b08af2	3f028561-a3c5-11f0-96ea-bf4f56b08af2	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	1	87.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:34:33.083616	\N	4369
9333	6fe2d080-a3bc-11f0-bfbd-d3aacc6a2e00	6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	1	1263.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:35.013449	\N	4372
9334	0a1d8ba0-a3b2-11f0-b871-03a75625f948	0a12b630-a3b2-11f0-b871-03a75625f948	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:36.502939	\N	77
9335	8f91a0b0-a3b1-11f0-b1e3-b7ce882fc700	8f862f00-a3b1-11f0-b1e3-b7ce882fc700	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	1	674.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:37.971936	\N	4361
9336	a1d33ad0-a3ad-11f0-a3bc-ef5c37833579	a1cdbc90-a3ad-11f0-a3bc-ef5c37833579	15319542575	5905806213973	Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN	1	1645.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:39.487081	\N	4375
9337	a1d33ad0-a3ad-11f0-a3bc-ef5c37833579	a1cdbc91-a3ad-11f0-a3bc-ef5c37833579	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	8	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:39.487081	\N	\N
117	931ad870-a085-11f0-ba82-ed153ccc4447	9315a850-a085-11f0-ba82-ed153ccc4447	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:26.741725	\N	4380
119	1161a220-a07e-11f0-a6cc-b3145592fdde	115a0100-a07e-11f0-a6cc-b3145592fdde	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:29.679006	\N	94
123	49190450-a066-11f0-b871-03a75625f948	49144960-a066-11f0-b871-03a75625f948	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:35.935596	\N	4349
103	66a16aa0-a122-11f0-baf0-af7ea74e3d0e	6699c981-a122-11f0-baf0-af7ea74e3d0e	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	1	58.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:22.997025	\N	104
104	015ac010-a122-11f0-9d66-3d00eb1ccfed	01540950-a122-11f0-9d66-3d00eb1ccfed	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:24.543023	\N	105
105	a1606580-a120-11f0-9d66-3d00eb1ccfed	a1584f30-a120-11f0-9d66-3d00eb1ccfed	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	1	523.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 19:16:53.328786	\N	106
113	45695940-a0a7-11f0-a6cc-b3145592fdde	45619110-a0a7-11f0-a6cc-b3145592fdde	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:21.909094	\N	114
3680	9a4e25d0-a2d2-11f0-a6cc-b3145592fdde	9a46abc0-a2d2-11f0-a6cc-b3145592fdde	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:44.213626	\N	2
9236	268f0bd1-a4ff-11f0-b9bf-2795de008363	2688a331-a4ff-11f0-b9bf-2795de008363	16901480273	5905806234022	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:18.40805	\N	4280
9316	a92e4620-a426-11f0-96d3-f7121b08a32c	a9221120-a426-11f0-96d3-f7121b08a32c	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:11.119521	\N	34
9317	c32a2630-a425-11f0-b1f1-69448e84eb62	c322ac20-a425-11f0-b1f1-69448e84eb62	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:12.650332	\N	92
107	90c6f9c0-a0fb-11f0-bfbd-d3aacc6a2e00	90c2b400-a0fb-11f0-bfbd-d3aacc6a2e00	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 18:52:54.929446	\N	97
109	42cb5c90-a0f9-11f0-baf0-af7ea74e3d0e	42c47ec0-a0f9-11f0-baf0-af7ea74e3d0e	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 18:16:40.471163	\N	77
106	37e72b40-a114-11f0-9e86-bf15ec8cf3e6	37e02660-a114-11f0-9e86-bf15ec8cf3e6	14563824746	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 19:00:55.116661	\N	53
9318	c35e0ed0-a422-11f0-af7e-5f793825db67	c35646a0-a422-11f0-af7e-5f793825db67	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:14.18697	\N	4
124	03bcd260-a066-11f0-aafc-c30e0e10a738	03b81770-a066-11f0-aafc-c30e0e10a738	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 13:12:02.680534	5905806201871_1.jpg	\N
108	d0b6e280-a0fa-11f0-b1e3-b7ce882fc700	d0b22790-a0fa-11f0-b1e3-b7ce882fc700	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 18:44:05.727554	\N	109
114	04ed7ed0-a095-11f0-9468-2bd22967b382	04e679f0-a095-11f0-9468-2bd22967b382	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	1	682.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:23.59694	\N	115
9319	ae6b5810-a41e-11f0-8e98-fdfd51e10ba4	ae640510-a41e-11f0-8e98-fdfd51e10ba4	15321911032	5905806216912	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	1	1750.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:15.671607	\N	4359
9320	76ac5390-a41c-11f0-a40a-ffbafd460211	76a77190-a41c-11f0-a40a-ffbafd460211	17453875719	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:17.210194	\N	57
9321	2b10c010-a412-11f0-b871-03a75625f948	2b052750-a412-11f0-b871-03a75625f948	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	1	674.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:18.70771	\N	4361
111	e0e984b0-a0f4-11f0-8323-6df02f435f6c	e0e56600-a0f4-11f0-8323-6df02f435f6c	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	1	521.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 17:22:43.502874	\N	112
112	2fefe050-a0e5-11f0-96ea-bf4f56b08af2	2febe8b0-a0e5-11f0-96ea-bf4f56b08af2	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	1	443.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 17:22:43.709715	\N	113
120	6d6894b0-a07a-11f0-a6cc-b3145592fdde	6d5d7120-a07a-11f0-a6cc-b3145592fdde	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:31.15798	\N	72
115	ce2b1f40-a091-11f0-bfbd-d3aacc6a2e00	ce26b270-a091-11f0-bfbd-d3aacc6a2e00	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:25.112887	\N	13
116	ce2b1f40-a091-11f0-bfbd-d3aacc6a2e00	ce26b271-a091-11f0-bfbd-d3aacc6a2e00	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:25.112887	\N	57
121	2f557250-a067-11f0-9d66-3d00eb1ccfed	2f4df840-a067-11f0-9d66-3d00eb1ccfed	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:32.634675	\N	4503
9322	8fee01d0-a40f-11f0-b871-03a75625f948	8fe8aaa0-a40f-11f0-b871-03a75625f948	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:20.228418	\N	4362
9323	4b642d51-a40a-11f0-a6cc-b3145592fdde	4b5cda51-a40a-11f0-a6cc-b3145592fdde	17453875719	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:22.334641	\N	57
9338	7c71b580-a3aa-11f0-a15e-754093089519	7c6a6280-a3aa-11f0-a15e-754093089519	16625971969	5905806222524	Siedzisko tapicerowane 80x29cm do szafki 80x30	1	75.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:41.063664	\N	4376
9339	b1c3ae70-a3a8-11f0-995e-7bc10d9eb16f	b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	1	1263.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:42.565499	\N	4372
9340	d30c2a10-a3a0-11f0-8e98-fdfd51e10ba4	d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4	17636751422	5905806205121	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	1	1263.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:44.063468	\N	4378
9341	470fa2e0-a39f-11f0-9468-2bd22967b382	47073e71-a39f-11f0-9468-2bd22967b382	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:45.591752	\N	2
9342	470fa2e0-a39f-11f0-9468-2bd22967b382	47073e70-a39f-11f0-9468-2bd22967b382	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:45.591752	\N	4380
9343	14e058a0-a39f-11f0-b56d-0ba559d87e46	14d905a1-a39f-11f0-b56d-0ba559d87e46	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:47.220975	\N	4381
9344	14e058a0-a39f-11f0-b56d-0ba559d87e46	14d905a0-a39f-11f0-b56d-0ba559d87e46	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:47.220975	\N	49
9345	5b9f1d40-a39e-11f0-9468-2bd22967b382	5b983f70-a39e-11f0-9468-2bd22967b382	12196226645	5905806203615	Wieszak ścienny WP80 na ubrania 80cm Lancelot	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:48.866238	\N	4383
9346	f1c974b0-a39d-11f0-8d43-e5c6c6646cd8	f1c1d391-a39d-11f0-8d43-e5c6c6646cd8	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:50.349499	\N	4384
9347	f1c974b0-a39d-11f0-8d43-e5c6c6646cd8	f1c1d390-a39d-11f0-8d43-e5c6c6646cd8	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:50.349499	\N	4368
9348	1e0e9330-a39d-11f0-9a42-bb8e9ffafe52	1e0396b1-a39d-11f0-9a42-bb8e9ffafe52	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:51.982135	\N	4384
9349	1e0e9330-a39d-11f0-9a42-bb8e9ffafe52	1e0396b0-a39d-11f0-9a42-bb8e9ffafe52	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:51.982135	\N	4368
9350	0a3ff4a0-a39a-11f0-bfbd-d3aacc6a2e00	0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:53.415426	\N	83
9351	d274a930-a399-11f0-a3bc-ef5c37833579	d2701550-a399-11f0-a3bc-ef5c37833579	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	1	1557.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:54.833203	\N	4389
9352	aa425b30-a397-11f0-8e98-fdfd51e10ba4	aa3a44e0-a397-11f0-8e98-fdfd51e10ba4	15221332021	5905806214130	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	1	447.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:56.309954	\N	4390
9353	8173bb40-a397-11f0-9288-ef897151e2e1	816e3d00-a397-11f0-9288-ef897151e2e1	16276325492	5905806233957	Komoda Bini 60x36D1N1 BIAŁY	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:57.866778	\N	4391
9354	8a869080-a393-11f0-bc71-87ddccc94446	8a81ae80-a393-11f0-bc71-87ddccc94446	16415944014	5905806231885	Szafka na buty VB100x30D2N1 ARTISAN	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:59.370898	\N	4392
9355	e7b9ffb0-a390-11f0-8d43-e5c6c6646cd8	e7b2d3c0-a390-11f0-8d43-e5c6c6646cd8	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:00.89155	\N	92
9356	eec49e50-a38b-11f0-a6cc-b3145592fdde	eebcaf10-a38b-11f0-a6cc-b3145592fdde	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	1	674.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:02.367047	\N	4361
9357	e173d570-a388-11f0-8e98-fdfd51e10ba4	e16d1eb0-a388-11f0-8e98-fdfd51e10ba4	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:03.842614	\N	4281
9358	523a61d0-a37e-11f0-8d43-e5c6c6646cd8	5233d220-a37e-11f0-8d43-e5c6c6646cd8	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:05.323924	\N	9
9359	8af73a30-a373-11f0-a6cc-b3145592fdde	8aed7630-a373-11f0-a6cc-b3145592fdde	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:35:06.788188	\N	82
9360	d16fb191-a373-11f0-9468-2bd22967b382	d16885a0-a373-11f0-9468-2bd22967b382	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:08.524972	\N	70
9361	04b51c30-a373-11f0-9468-2bd22967b382	04ad5400-a373-11f0-9468-2bd22967b382	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:10.006375	\N	7
9362	79d896e0-a364-11f0-a3bc-ef5c37833579	79d42a10-a364-11f0-a3bc-ef5c37833579	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:11.487078	\N	97
9363	88b45fd1-a357-11f0-bc71-87ddccc94446	88af56c1-a357-11f0-bc71-87ddccc94446	12263585961	5905204699218	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	1	1052.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:12.962774	\N	4401
9364	6b11b120-a353-11f0-a15e-754093089519	6b0a8530-a353-11f0-a15e-754093089519	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:14.481877	\N	65
9365	628c6f80-a34f-11f0-b861-bd1e9af656a8	6287b490-a34f-11f0-b861-bd1e9af656a8	14024671782	5905806201307	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:15.94631	\N	4403
9366	b4dad3c0-a34b-11f0-87ab-43c4d16d6a38	b4d359b0-a34b-11f0-87ab-43c4d16d6a38	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:17.471156	\N	4404
9367	a6aa15b2-a349-11f0-9d2c-bd0fd501dc68	a6a3fb32-a349-11f0-9d2c-bd0fd501dc68	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:18.983524	\N	4405
9368	865e98b0-a346-11f0-9fcc-bf32f2dae555	865793d0-a346-11f0-9fcc-bf32f2dae555	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:20.522399	\N	4404
9369	a6fb8ab0-a341-11f0-9a42-bb8e9ffafe52	a6f1c6b0-a341-11f0-9a42-bb8e9ffafe52	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:22.641558	\N	4407
9370	dcd790a2-a33e-11f0-b871-03a75625f948	dcd26082-a33e-11f0-b871-03a75625f948	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:24.240742	\N	83
9371	3a93dcb0-a32d-11f0-9d66-3d00eb1ccfed	3a8cd7d0-a32d-11f0-9d66-3d00eb1ccfed	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:25.830315	\N	12
9373	ef3fe2b0-9e02-11f0-96ea-bf4f56b08af2	ef3b4ed0-9e02-11f0-96ea-bf4f56b08af2	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:28.936689	\N	4362
9374	30520490-9d63-11f0-a677-a5b8c1586284	304affb0-9d63-11f0-a677-a5b8c1586284	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:30.351716	\N	4411
9375	0e64f410-9d35-11f0-8058-6bb39f24a57a	0e603920-9d35-11f0-8058-6bb39f24a57a	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:31.762006	\N	4411
21	93c15c40-a233-11f0-a6cc-b3145592fdde	93baa580-a233-11f0-a6cc-b3145592fdde	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	1	205.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:48.761018	\N	28
53	bce3c350-a1f8-11f0-a6cc-b3145592fdde	bcdce580-a1f8-11f0-a6cc-b3145592fdde	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	1	205.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:20.304219	\N	60
80	95595a70-a1bc-11f0-a6cc-b3145592fdde	95525591-a1bc-11f0-a6cc-b3145592fdde	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:52.977557	\N	85
9474	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e82-a05b-11f0-819e-1344c439828f	12258788829	5905806216936	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	1	1827.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4506
9475	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e83-a05b-11f0-819e-1344c439828f	11742813479	5905806204025	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	1	776.80	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4507
9476	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e81-a05b-11f0-819e-1344c439828f	15446678390	5905806219623	Szafka na buty 60x30D2N1Supra SONOMA	1	1105.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4508
9477	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e80-a05b-11f0-819e-1344c439828f	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4509
9478	89083cb0-a058-11f0-9468-2bd22967b382	89015ee0-a058-11f0-9468-2bd22967b382	15225574066	5905806213461	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:39.753389	\N	4510
9479	f6464f80-a056-11f0-bc87-8159fe565898	f63e1220-a056-11f0-bc87-8159fe565898	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	1	1827.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:41.570887	\N	4293
9480	a7a598b0-a054-11f0-8e98-fdfd51e10ba4	a79e45b0-a054-11f0-8e98-fdfd51e10ba4	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:43.152649	\N	41
9481	19d100b0-a054-11f0-b871-03a75625f948	19cc45c1-a054-11f0-b871-03a75625f948	16383693560	5905806234046	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:44.773914	\N	4513
9482	19d100b0-a054-11f0-b871-03a75625f948	19cc45c0-a054-11f0-b871-03a75625f948	17567410245	\N	Poduszka ozdobna, dekoracyjna 50x30cm	1	37.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:44.773914	\N	\N
9483	c1c0f760-a042-11f0-8c4d-9bd96e1ccd86	c1bba030-a042-11f0-8c4d-9bd96e1ccd86	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:46.497018	\N	57
9484	029c0ad0-a03f-11f0-bc5e-258a5e1e619a	029505f0-a03f-11f0-bc5e-258a5e1e619a	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:48.104858	\N	4515
9485	b3746960-a03f-11f0-8737-b36df7580750	b369bb00-a03f-11f0-8737-b36df7580750	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	1	1123.60	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:49.691873	\N	4516
9486	933c1fe0-a034-11f0-ba82-ed153ccc4447	93373de0-a034-11f0-ba82-ed153ccc4447	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:51.327492	\N	98
9487	c96f6d90-a031-11f0-8e98-fdfd51e10ba4	c967f380-a031-11f0-8e98-fdfd51e10ba4	16644957145	5905806204179	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:52.87265	\N	4518
9488	0b578860-a027-11f0-93a2-8fc85806f760	0b50d1a0-a027-11f0-93a2-8fc85806f760	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:54.443322	\N	7
9489	6a50f510-a025-11f0-bc5e-258a5e1e619a	6a4a1740-a025-11f0-bc5e-258a5e1e619a	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	1	564.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:56.006326	\N	33
9490	a9ba08f0-9fd4-11f0-9468-2bd22967b382	a9b37940-9fd4-11f0-9468-2bd22967b382	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:57.528802	\N	66
9491	839dfc50-9fc8-11f0-9d66-3d00eb1ccfed	8396a950-9fc8-11f0-9d66-3d00eb1ccfed	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	1	1023.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:59.035883	\N	4522
9492	70857c70-9fc7-11f0-9d66-3d00eb1ccfed	707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed	15315961595	5905806214673	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	1	587.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:00.995018	\N	4523
9494	a248daf0-9fc6-11f0-8c53-b9e6d89e658e	a241d610-9fc6-11f0-8c53-b9e6d89e658e	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	1	332.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:02.566909	\N	4525
9495	91d17a80-9fbf-11f0-8234-ff8a51029ee2	91cc9880-9fbf-11f0-8234-ff8a51029ee2	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:04.368113	\N	4362
9496	42529150-9fc0-11f0-8509-57e61af36c1f	424b1740-9fc0-11f0-8509-57e61af36c1f	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:05.921164	\N	4527
9497	4c292230-9fb0-11f0-b42c-9325c9d7bd4d	4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:07.494846	\N	4270
9498	7862c470-9fae-11f0-8d27-959e7a05a75b	785dbb60-9fae-11f0-8d27-959e7a05a75b	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:08.982673	\N	4274
9499	c8cc0a70-9fa9-11f0-9a42-bb8e9ffafe52	c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52	12476571893	5905204699492	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:10.465002	\N	4530
9500	035de560-9fa9-11f0-9d66-3d00eb1ccfed	0356e080-9fa9-11f0-9d66-3d00eb1ccfed	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:11.994259	\N	83
9501	e451b440-9fa7-11f0-8e98-fdfd51e10ba4	e44aaf60-9fa7-11f0-8e98-fdfd51e10ba4	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:13.524776	\N	4349
9502	e194c910-9fa5-11f0-ad8a-5d9c081a41b2	e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2	16602441323	5905806234770	Komoda Bini 100x36 D1N1 WOTAN	1	682.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:15.032791	\N	4533
9503	87ed6070-9fa0-11f0-89e4-21adac12f2a9	87e8a580-9fa0-11f0-89e4-21adac12f2a9	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:16.741965	\N	92
9504	65161d90-9f9f-11f0-8234-ff8a51029ee2	651189b0-9f9f-11f0-8234-ff8a51029ee2	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:18.25358	\N	1
9505	ed2acaf0-9f9a-11f0-9d66-3d00eb1ccfed	ed23c610-9f9a-11f0-9d66-3d00eb1ccfed	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:19.823755	\N	4536
9506	c0eec9a0-9f9a-11f0-8509-57e61af36c1f	c0e5a1e1-9f9a-11f0-8509-57e61af36c1f	15251019919	5905806204162	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:21.391471	\N	4537
9507	c0eec9a0-9f9a-11f0-8509-57e61af36c1f	c0e5a1e0-9f9a-11f0-8509-57e61af36c1f	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:21.391471	\N	70
9508	2f4e0e71-9f9a-11f0-96ea-bf4f56b08af2	2f47cce2-9f9a-11f0-96ea-bf4f56b08af2	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:23.050134	\N	13
9509	2f4e0e71-9f9a-11f0-96ea-bf4f56b08af2	2f47cce1-9f9a-11f0-96ea-bf4f56b08af2	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:23.050134	\N	4404
9510	ec7230b0-9f97-11f0-86d6-599d2223cd68	ec69f350-9f97-11f0-86d6-599d2223cd68	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:24.66678	\N	49
9511	2204e780-9f67-11f0-a6ba-19e7472c74e3	2200c8d0-9f67-11f0-a6ba-19e7472c74e3	16383698094	5905806234084	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:26.173347	\N	4542
9512	b004e730-9f65-11f0-8234-ff8a51029ee2	affef3c0-9f65-11f0-8234-ff8a51029ee2	15134391509	5905806209372	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	1	1016.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:27.696527	\N	4543
9513	2bf328a0-9f63-11f0-8509-57e61af36c1f	2beb8780-9f63-11f0-8509-57e61af36c1f	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	1	523.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:29.220197	\N	106
9514	8a61c600-9f57-11f0-8509-57e61af36c1f	8a5ac120-9f57-11f0-8509-57e61af36c1f	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:30.70906	\N	93
9516	e8756a60-9f04-11f0-bfbd-d3aacc6a2e00	e870d680-9f04-11f0-bfbd-d3aacc6a2e00	12266500239	5905204699126	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:32.292077	\N	4547
9517	a1e0a350-9f02-11f0-b871-03a75625f948	a1dbe860-9f02-11f0-b871-03a75625f948	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:33.686565	\N	7
9518	c68f7410-9efd-11f0-88a7-41bf7e4bf551	c686e890-9efd-11f0-88a7-41bf7e4bf551	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:35.082567	\N	4380
9519	7cab93f0-9ef9-11f0-a910-6fc8854d80a9	7ca46800-9ef9-11f0-a910-6fc8854d80a9	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	454.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:36.504283	\N	87
9520	53444b90-9efb-11f0-9e10-59ae2eaec9de	533d46b0-9efb-11f0-9e10-59ae2eaec9de	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:37.890424	\N	4551
9522	506a6d11-9efa-11f0-a6cc-b3145592fdde	5062f301-9efa-11f0-a6cc-b3145592fdde	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:40.880156	\N	\N
9523	506a6d11-9efa-11f0-a6cc-b3145592fdde	5062f300-9efa-11f0-a6cc-b3145592fdde	17358870548	5905806237849	Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir	1	363.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:40.880156	\N	4553
9524	9c74d050-9ef6-11f0-b1e3-b7ce882fc700	9c695ea0-9ef6-11f0-b1e3-b7ce882fc700	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:42.365344	\N	2
9525	a6a4ce00-9ef5-11f0-817a-fb3753e68c2d	a69df030-9ef5-11f0-817a-fb3753e68c2d	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:43.629286	\N	7
9526	a07eb210-9ef1-11f0-9dc3-f9a3debc1314	a0795ae0-9ef1-11f0-9dc3-f9a3debc1314	17475498034	\N	Szafka na buty z siedziskiem i schowkiem VB80x30D1N1 Dąb Estana	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:45.005664	\N	\N
9527	9eabe350-9ef0-11f0-88a7-41bf7e4bf551	9ea46940-9ef0-11f0-88a7-41bf7e4bf551	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:46.384312	\N	93
9528	ebf4b2a0-9eef-11f0-9efe-27a29450b6fd	ebefa990-9eef-11f0-9efe-27a29450b6fd	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:47.728981	\N	41
9529	302ccc60-9eef-11f0-9dc3-f9a3debc1314	30285f90-9eef-11f0-9dc3-f9a3debc1314	12405971238	5905204699140	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	1	1136.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:49.168469	\N	4558
9530	0999c490-9eef-11f0-96ea-bf4f56b08af2	099509a0-9eef-11f0-96ea-bf4f56b08af2	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:50.506069	\N	4404
9532	d9e76130-9eee-11f0-b465-492415e4339b	d9e03540-9eee-11f0-b465-492415e4339b	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	1	75.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:51.957313	\N	4561
9533	1fad91d0-9eea-11f0-96ea-bf4f56b08af2	1fa29550-9eea-11f0-96ea-bf4f56b08af2	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	382.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:53.308922	\N	9
9534	304bca40-9ee8-11f0-a30a-89acbba18695	3046e840-9ee8-11f0-a30a-89acbba18695	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:54.685248	\N	62
9535	1c67b9d0-9ee3-11f0-9dc3-f9a3debc1314	1c637410-9ee3-11f0-9dc3-f9a3debc1314	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:56.000052	\N	23
9536	7421cf30-9ed9-11f0-b465-492415e4339b	741a7c31-9ed9-11f0-b465-492415e4339b	17477972814	5905806238716 	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	1	1373.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:57.338125	\N	4565
9537	7421cf30-9ed9-11f0-b465-492415e4339b	741a7c30-9ed9-11f0-b465-492415e4339b	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	1	857.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:57.338125	\N	4566
9538	a8520470-9ed7-11f0-bfbd-d3aacc6a2e00	a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:58.835539	\N	4404
9539	38ccaba0-9ed7-11f0-a7f2-a59be15353c3	38c53190-9ed7-11f0-a7f2-a59be15353c3	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:00.131947	\N	83
9540	10ac49e0-9ed3-11f0-a0f2-ad990a13a62d	10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	1	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:01.41938	\N	4569
9541	d60883b0-9eca-11f0-b1e3-b7ce882fc700	d603c8c0-9eca-11f0-b1e3-b7ce882fc700	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:02.766441	\N	27
9560	9162c891-997c-11f0-b7ad-bf8cbe88f0cf	915b4e80-997c-11f0-b7ad-bf8cbe88f0cf	15193798429	5905806213133	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	1	1704.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:54:36.654006	\N	4589
9515	1b962310-9f11-11f0-9d66-3d00eb1ccfed	1b8f9360-9f11-11f0-9d66-3d00eb1ccfed	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:30.606999	\N	71
9521	19377490-9efb-11f0-96ea-bf4f56b08af2	19329290-9efb-11f0-96ea-bf4f56b08af2	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:39.284741	\N	4509
9531	0999c490-9eef-11f0-96ea-bf4f56b08af2	099509a1-9eef-11f0-96ea-bf4f56b08af2	15258837181	5905806211023	Wieszak ścienny W60 na ubrania 60cm LANCELOT	1	193.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:50.506069	\N	4560
9542	e55fb2a0-9ec7-11f0-a30a-89acbba18695	e55ad0a0-9ec7-11f0-a30a-89acbba18695	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:04.087597	\N	4368
9543	cf3fa2a0-9ec7-11f0-9d66-3d00eb1ccfed	cf384fa0-9ec7-11f0-9d66-3d00eb1ccfed	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:05.397666	\N	12
9544	4dc92860-9ec5-11f0-9e10-59ae2eaec9de	4dc1d560-9ec5-11f0-9e10-59ae2eaec9de	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:06.705213	\N	4551
9545	ab770670-9ebc-11f0-96ea-bf4f56b08af2	ab724b80-9ebc-11f0-96ea-bf4f56b08af2	16271343737	5905806233476	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:08.02041	\N	4574
9546	3099f270-9eb5-11f0-8bdf-5dc6c72e14d7	30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	2	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:09.349826	\N	4381
9547	40166730-9eb3-11f0-908e-ff3baa2fe7b0	400f1430-9eb3-11f0-908e-ff3baa2fe7b0	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:10.639494	\N	7
9548	2e56f660-9eac-11f0-9468-2bd22967b382	2e4f7c50-9eac-11f0-9468-2bd22967b382	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	488.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:12.194263	\N	72
9549	dc70e320-9eaa-11f0-8ace-e54796c9c1e2	dc660db0-9eaa-11f0-8ace-e54796c9c1e2	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:13.518163	\N	75
9550	81c7cfb0-9eaa-11f0-bc92-992b6815467a	81c1b530-9eaa-11f0-bc92-992b6815467a	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:14.883124	\N	12
9551	5f2c19c0-9eaa-11f0-817a-fb3753e68c2d	5f2514e0-9eaa-11f0-817a-fb3753e68c2d	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:16.230465	\N	75
9552	f1a501f0-9ea9-11f0-908e-ff3baa2fe7b0	f19d39c0-9ea9-11f0-908e-ff3baa2fe7b0	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	488.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:17.494417	\N	72
9553	779405a0-9ea4-11f0-8996-07b46275101a	778e3940-9ea4-11f0-8996-07b46275101a	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:18.846639	\N	4582
9554	2a06f6d0-9ea4-11f0-9dc3-f9a3debc1314	29fbd340-9ea4-11f0-9dc3-f9a3debc1314	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:20.184865	\N	75
9555	52261250-9ea3-11f0-bc92-992b6815467a	52209410-9ea3-11f0-bc92-992b6815467a	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:21.523599	\N	9
9556	d41ce880-9e97-11f0-8996-07b46275101a	d41854a0-9e97-11f0-8996-07b46275101a	16760747405	5905806236156	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	1	1045.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:22.849985	\N	4585
9557	f6358130-9e96-11f0-817a-fb3753e68c2d	f62ea360-9e96-11f0-817a-fb3753e68c2d	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	488.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:24.177602	\N	72
9558	62229f70-9e94-11f0-8fc5-3736e68905c7	62172dc0-9e94-11f0-8fc5-3736e68905c7	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:25.539499	\N	94
9605	dfc2f4f0-9e55-11f0-b871-03a75625f948	dfbeaf30-9e55-11f0-b871-03a75625f948	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:26.879438	\N	49
9606	93cb0710-9e3f-11f0-9325-2757f66ce3c4	93c67330-9e3f-11f0-9325-2757f66ce3c4	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:28.363695	\N	\N
9607	0dc8aad0-9e37-11f0-8fb0-7b363fae20c7	0dc416f0-9e37-11f0-8fb0-7b363fae20c7	15919629053	5905806228588	Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA	1	1540.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:29.728304	\N	4633
9559	40649dc0-9e30-11f0-b286-41f712537da1	405d98e0-9e30-11f0-b286-41f712537da1	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:32.670068	\N	114
9608	8f544d00-9e34-11f0-8cf9-590a844f62e8	8f495080-9e34-11f0-8cf9-590a844f62e8	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:31.206095	\N	2
9610	6bba81a0-9e2c-11f0-a459-a9c1a10b0527	6bb1a800-9e2c-11f0-a459-a9c1a10b0527	12266500390	5905204699133	Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:34.124208	\N	4636
9611	9687df20-9e29-11f0-a07b-27f19dcfd61a	9682fd20-9e29-11f0-a07b-27f19dcfd61a	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:35.69216	\N	4304
9612	d2623fa0-9e28-11f0-a6cc-b3145592fdde	d25ac590-9e28-11f0-a6cc-b3145592fdde	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	1	332.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:37.239716	\N	4525
9613	f42c0090-9e1d-11f0-820b-7b684c0899aa	f42522c0-9e1d-11f0-820b-7b684c0899aa	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:38.745835	\N	57
9614	221d3350-9e1b-11f0-8e98-fdfd51e10ba4	22156b20-9e1b-11f0-8e98-fdfd51e10ba4	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:40.882458	\N	4640
9615	881920f1-9e17-11f0-b871-03a75625f948	880cc4e1-9e17-11f0-b871-03a75625f948	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:42.387318	\N	4551
9616	0305dfa0-9e0f-11f0-9fa0-ab34abe0805b	02fe8ca0-9e0f-11f0-9fa0-ab34abe0805b	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:43.912526	\N	41
9617	dc71b140-9e0c-11f0-a758-8bcc0e9ae972	dc6afa80-9e0c-11f0-a758-8bcc0e9ae972	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:45.32572	\N	4527
9618	b291b770-9e03-11f0-9a42-bb8e9ffafe52	b2861eb0-9e03-11f0-9a42-bb8e9ffafe52	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	2	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:46.731225	\N	94
9619	a5d6df40-9dfb-11f0-b871-03a75625f948	a5d22450-9dfb-11f0-b871-03a75625f948	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:48.157165	\N	41
9620	7d54c060-9df5-11f0-8cf9-590a844f62e8	7d4fde60-9df5-11f0-8cf9-590a844f62e8	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:49.555196	\N	4270
9621	42171941-9def-11f0-8498-f546d68c9b4c	420f5111-9def-11f0-8498-f546d68c9b4c	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:50.952607	\N	12
9622	d24b4190-9dee-11f0-8dfb-8df075740e6d	d243ee91-9dee-11f0-8dfb-8df075740e6d	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:52.411291	\N	4380
9623	d24b4190-9dee-11f0-8dfb-8df075740e6d	d243ee90-9dee-11f0-8dfb-8df075740e6d	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:52.411291	\N	7
9624	ae763330-9dec-11f0-b286-41f712537da1	ae6eb920-9dec-11f0-b286-41f712537da1	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:53.994553	\N	4650
9625	0cb72551-9deb-11f0-8cf9-590a844f62e8	0cb131e1-9deb-11f0-8cf9-590a844f62e8	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:55.455939	\N	4651
9626	7379e230-9de3-11f0-9fa0-ab34abe0805b	7372dd50-9de3-11f0-9fa0-ab34abe0805b	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:56.94902	\N	66
9627	0c5badf0-9de2-11f0-a07b-27f19dcfd61a	0c56a4e0-9de2-11f0-a07b-27f19dcfd61a	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:58.390649	\N	41
9628	3eb44790-9de1-11f0-86f1-176f8757ee95	3eafb3b0-9de1-11f0-86f1-176f8757ee95	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:58:00.080525	\N	4411
9629	85dfad80-9ddc-11f0-bfbd-d3aacc6a2e00	85db67c0-9ddc-11f0-bfbd-d3aacc6a2e00	15258837630	5905806211030	Wieszak ścienny W60 na ubrania 60cm ARISTAN	1	193.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:58:01.535305	\N	4655
9630	b5d243a0-9ddb-11f0-956d-ab7d0b07bcfc	b5cd61a0-9ddb-11f0-956d-ab7d0b07bcfc	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	454.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:58:03.011366	\N	87
9631	093fd080-a54c-11f0-b989-75c7faccd1ca	0938cba0-a54c-11f0-b989-75c7faccd1ca	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 20:20:44.305026	\N	4551
\.


--
-- Data for Name: orders; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.orders (id, order_id, seller_id, seller_login, order_date, seller_status, marketplace, buyer_id, buyer_login, buyer_email, buyer_company, buyer_name, buyer_phone, buyer_address, buyer_zip, buyer_city, buyer_country_code, payment_id, payment_status, payment_provider, allegro_pay, payment_amount, payment_currency, delivery_method, delivery_amount, delivery_currency, total_to_pay_amount, total_to_pay_currency, buyer_notes, smart, tracking_numbers, payment_last_date, buyer_account_type, imported_at, payment_type, invoice_required, shipments, billing_address, refund_amount, refund_date, refund_reconciliation, has_returns) FROM stdin;
11	092d0510-a289-11f0-b024-2112831760cb	\N	\N	2025-10-06 07:50:25.839	READY_FOR_PROCESSING	allegro-pl	12160923	verbum33	2qm541yucu+41ba7bc8@allegromail.pl	\N	Mariola Lewicka	+48 512 461 068	Zagruszany 35	16-060	Zabłudów	PL	13654ae9-a289-11f0-91d4-7961b40d7b05	PAID	PAYU	t	341.00	PLN	Allegro Kurier DPD	0.00	PLN	341.00	PLN	\N	t	\N	2025-10-06 07:50:25.839	\N	2025-10-06 20:34:51.668214	ONLINE	f	\N	\N	0.00	\N	\N	f
3562	898146d0-a2d5-11f0-9468-2bd22967b382	\N	\N	2025-10-06 17:01:25.786	READY_FOR_PROCESSING	allegro-pl	24156578	Client:24156578	hygu52ql8t+29e473597@allegromail.pl	\N	Magdalena Zakrzewska	+48 603 059 844	ul.Pszczyńska 6 C	60-102	Poznań	PL	949f8048-a2d5-11f0-96eb-67f4404dbe40	PAID	P24	t	457.80	PLN	Allegro Kurier DPD	0.00	PLN	457.80	PLN	\N	t	\N	2025-10-06 17:01:25.786	\N	2025-10-06 20:34:43.753422	ONLINE	f	\N	\N	0.00	\N	\N	f
5562	907c6f90-a2e5-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-06 18:52:40.693	READY_FOR_PROCESSING	allegro-pl	5063455	violwicz321	l715sn3opm+6e5eda634@allegromail.pl	\N	Violetta Ziubroniewicz	+48 600 223 482	Namysłowska, 28, 1	46-250	Wołczyn	\N	90a358fb-a2e5-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	326.00	\N	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-06 18:57:01.368	\N	2025-10-06 20:34:40.421628	ONLINE	f	\N	\N	0.00	\N	\N	f
4063	35868030-a2db-11f0-8b51-87d1833631ec	\N	\N	2025-10-06 17:38:35.774	READY_FOR_PROCESSING	allegro-pl	4935621	kasiaarndt	u22ba6fw6r+190dbcd37@allegromail.pl	\N	Katarzyna Smoleń	+48 888 762 267	ul. Główna 33	95-040	Kaletnik	PL	35a7ebc4-a2db-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-06 17:38:35.774	\N	2025-10-06 20:34:42.05297	ONLINE	f	\N	\N	0.00	\N	\N	f
5262	7a343390-a2e4-11f0-bee6-2fee815ffc9f	\N	\N	2025-10-06 18:45:13.182	READY_FOR_PROCESSING	allegro-pl	101628696	Client:101628696	gih9oss5je+71f89c3d9@allegromail.pl	\N	Szymon Gapinski	+48 661 532 273	Kujawska 6/9	88-153	Kruszwica	PL	8b0e03d4-a2e4-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	336.00	PLN	EP2	f	\N	2025-10-06 18:45:13.182	\N	2025-10-06 20:34:40.833471	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
4562	b2342af0-a2e1-11f0-aba2-b3553c261cc2	\N	\N	2025-10-06 18:26:20.805	READY_FOR_PROCESSING	allegro-pl	100240883	Client:100240883	vvrncuiwki+229787922@allegromail.pl	\N	Aleksandra Saracka	+48 517 500 946	Dziekanowice 85a	28-440	Dziekanowice	PL	b27b6d4c-a2e1-11f0-96eb-67f4404dbe40	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Wieszak dąb wotan\nKolor haków h1 czarny	t	\N	2025-10-06 18:26:20.805	\N	2025-10-06 20:34:41.2389	ONLINE	f	\N	\N	0.00	\N	\N	f
4062	25f49990-a2db-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-06 17:38:50.551	READY_FOR_PROCESSING	allegro-pl	19743339	patka12348	e6f4d6oa4y+72cbefad6@allegromail.pl	\N	Patrycja Dąbrowska	+48 517 479 298	Swoboda 16E	95-001	Biała	PL	26167a46-a2db-11f0-baf9-a33944a1116d	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Hugo Grafit (TH3)	t	\N	2025-10-06 17:38:50.551	\N	2025-10-06 20:34:41.64475	ONLINE	f	\N	\N	0.00	\N	\N	f
4064	13300610-a2da-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-06 17:30:46.038	READY_FOR_PROCESSING	allegro-pl	651669	dodziu	3nimpglpbm+1d0c107c4@allegromail.pl	\N	Tomasz Dotka	+48 796 727 517	Łąkowa 7/2	62-090	Rokietnica	PL	1365e37c-a2da-11f0-b9a1-9fd75769370f	PAID	AF	t	98.00	PLN	Allegro Kurier DPD	0.00	PLN	98.00	PLN	\N	t	\N	2025-10-06 17:30:46.038	\N	2025-10-06 20:34:42.462722	ONLINE	f	\N	\N	0.00	\N	\N	f
4065	b0967a20-a2d9-11f0-abd8-f5344f24907b	\N	\N	2025-10-06 17:29:42.598	READY_FOR_PROCESSING	allegro-pl	45057119	Client:45057119	ack4u59ivr+17c1e4550@allegromail.pl	\N	Aneta Suchoń	+48 698 483 124	Darwina 4 / 59	43-100	Tychy	PL	f00508d6-a2d9-11f0-a417-fd831f6ae8ec	PAID	P24	t	1283.00	PLN	Allegro Kurier DPD	0.00	PLN	1283.00	PLN	Poproszę białą garderobę, czarne haczyki a na siedzisko i oparcie materiał welur grafit. 	t	\N	2025-10-06 17:29:42.598	\N	2025-10-06 20:34:42.937473	ONLINE	f	\N	\N	0.00	\N	\N	f
2862	0861c630-a2d3-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-06 16:43:00.06	READY_FOR_PROCESSING	allegro-pl	3270348	marcin2123	h4umw7ofsw+f9f68f93@allegromail.pl	\N	Marcin Janiec	+48 605 440 507	Wydrza 254	39-410	Wydrza	PL	0f1a5b0a-a2d3-11f0-baf9-a33944a1116d	PAID	AF	t	1136.00	PLN	Allegro Kurier DPD	0.00	PLN	1136.00	PLN	\N	t	\N	2025-10-06 16:43:00.06	\N	2025-10-06 20:34:44.62111	ONLINE	f	\N	\N	0.00	\N	\N	f
7517	274751f0-a544-11f0-bb74-8b6fbb6f100b	\N	\N	2025-10-09 19:15:39.15	READY_FOR_PROCESSING	allegro-pl	9633306	louisstevens	9nyldwsjgo+c7741a50@allegromail.pl	\N	Błażej Chalecki	+48 609 752 603	Diamentowa 55	21-500	Rakowiska	PL	36d2343a-a544-11f0-91d4-7961b40d7b05	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-10-09 19:15:39.15	\N	2025-10-09 19:32:59.478629	ONLINE	f	[]	\N	0.00	\N	[]	f
4066	61869be0-a2d9-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 17:27:03.108	READY_FOR_PROCESSING	allegro-pl	25730455	wojtec9	eyaoc54pmh+4984d3586@allegromail.pl	\N	WOJCIECH ZIELIŃSKI	+48 726 452 827	Chełmińska 29 / 12	78-600	Walcz	PL	74e5b7ae-a2d9-11f0-baf9-a33944a1116d	PAID	P24	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-10-06 17:27:03.108	\N	2025-10-06 20:34:43.348278	ONLINE	f	\N	\N	0.00	\N	\N	f
2162	6189e650-a2d0-11f0-abc1-17dd0035cfdf	\N	\N	2025-10-06 16:22:56.545	READY_FOR_PROCESSING	allegro-pl	39428833	bru_69	2qo6jx0op3+34a54f762@allegromail.pl	\N	Arleta Karpińska	+48 535 991 409	Słowiańska 10b / 15	78-400	Szczecinek	PL	6a8fc682-a2d0-11f0-ae11-e76c74c7cf77	PAID	AF	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	Dzień dobry. Tkanina WE1 czarny welur a wieszak H3 złoto szczotkowane. Pozdrawiam	t	\N	2025-10-06 16:22:56.545	\N	2025-10-06 20:34:45.03508	ONLINE	f	\N	\N	0.00	\N	\N	f
1162	aa7dfe50-a2cb-11f0-8144-0ba8ff5b8d19	\N	\N	2025-10-06 15:48:52.111	READY_FOR_PROCESSING	allegro-pl	100961463	Client:100961463	94ueufhuma+10591b4b7@allegromail.pl	\N	Teresa Kondecka	+48 511 630 099	Gotartowicka 37F	44-251	Rybnik	PL	e64b9877-a2cb-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	345.99	PLN	Kolor siedziska eko skóra grafit ES3 .	f	\N	2025-10-06 15:48:52.111	\N	2025-10-06 20:34:45.449282	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
6773	0b61c0f0-a2ed-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-06 19:47:14.328	READY_FOR_PROCESSING	allegro-pl	3234709	szumi00_2005	osv4cggk00+52a99a7e1@allegromail.pl	\N	Krzysztof Szubert	+48 502 235 145	Jeziorańska 28	60-461	Poznań	PL	0ee346fa-a2ed-11f0-ae11-e76c74c7cf77	PAID	P24	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Kolor siedziska: TH3 - Tkanina Hugo Grafitowy	t	\N	2025-10-06 19:47:14.328	\N	2025-10-06 20:34:39.001216	ONLINE	t	\N	\N	0.00	\N	\N	f
6304	c0249260-a2e8-11f0-8144-0ba8ff5b8d19	\N	\N	2025-10-06 19:20:03.259	READY_FOR_PROCESSING	allegro-pl	25737342	Jagus100234	tewvow7o0h+3de764dc4@allegromail.pl	\N	Jagoda Gniazdowska	+48 782 039 386	Starogrodzka 7	63-700	Lutogniew	PL	20dc18aa-a2e9-11f0-a417-fd831f6ae8ec	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	TH3	t	\N	2025-10-06 19:20:03.259	\N	2025-10-06 20:34:39.460395	ONLINE	f	\N	\N	0.00	\N	\N	f
7518	9b0d65e0-a53d-11f0-a008-2360f331b758	\N	\N	2025-10-09 18:30:09.212	READY_FOR_PROCESSING	allegro-pl	109512317	Client:109512317	9xf199x5rf+750872565@allegromail.pl	\N	Aleksandra Fionik	+48 607 791 187	Konwaliowa 4/21 4 / 21	15-674	Białystok	PL	ca7e05c6-a53d-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	EP2 pik czarny	f	\N	2025-10-09 18:30:09.212	\N	2025-10-09 19:33:01.106023	ONLINE	f	[]	\N	0.00	\N	[]	f
7519	b54142b0-a538-11f0-9da2-81c6f7d897d8	\N	\N	2025-10-09 17:54:29.16	READY_FOR_PROCESSING	allegro-pl	51433172	kupidynsklep24	owdmy4gftg+5bac3d897@allegromail.pl	KUPIDYN RAFAŁ KWIATKOWSKI	Rafał Kwiatkowski	+48 531 847 695	Jarzębinowa 69A / 2	21-007	Krępiec	PL	b57bdb0f-a538-11f0-a284-071dd65bf45d	PAID	P24	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	TH1 - Tkanina Hugo Czarny , proszę o nieuszkodzony, nowy mebel.\nPozdrawiam	t	\N	2025-10-09 17:54:29.16	\N	2025-10-09 19:33:02.474009	ONLINE	f	[]	\N	0.00	\N	[]	f
7640	aa425b30-a397-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-07 16:08:14.471	READY_FOR_PROCESSING	allegro-pl	7812128	ptyska11	p67r4ra55e+6754a49e6@allegromail.pl	\N	Anna Dylińska	+48 509 773 260	Malczewskiego 17b/3	71-612	Szczecin	PL	bbe79181-a397-11f0-a284-071dd65bf45d	PAID	P24	t	447.00	PLN	Allegro Kurier DPD	0.00	PLN	447.00	PLN	\N	t	\N	2025-10-07 16:08:14.471	\N	2025-10-09 19:34:56.309954	ONLINE	f	[]	\N	0.00	\N	[]	f
37	935f63c0-a1ff-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-05 15:28:56.284	CANCELLED	allegro-pl	12734940	csae	7g2ohrayar+67f56c8f1@allegromail.pl	\N	Anna Wistuba	+49 171 9078018	\N	\N	\N	\N	e1107582-a1ff-11f0-ae11-e76c74c7cf77	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	14.99	PLN	842.99	PLN	\N	f	\N	\N	\N	2025-10-09 19:40:18.981615	ONLINE	f	[]	\N	0.00	\N	[]	f
6973	24befdc0-a2f1-11f0-8144-0ba8ff5b8d19	\N	\N	2025-10-06 20:15:47.012	READY_FOR_PROCESSING	allegro-pl	18918579	Kzrychu-K1	y8owiikt69+295ecb0e8@allegromail.pl	\N	Krzysztof Dwornik	+48 519 125 219	Jana Kantego 29 G	32-650	Kęty	PL	24e4af16-a2f1-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	1807.60	PLN	Allegro Kurier DPD	0.00	PLN	1807.60	PLN	\N	t	\N	2025-10-06 20:15:47.012	\N	2025-10-06 20:34:38.433125	ONLINE	f	\N	\N	0.00	\N	\N	f
5903	c8e0d140-a2e6-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 19:02:13.869	READY_FOR_PROCESSING	allegro-pl	4206245	mmmagdaa	jr2x52eptl+453d60b82@allegromail.pl	\N	Magda Wróbel	+48 606 352 891	ul. Rokicka 4	42-450	Rokitno Szlacheckie	PL	d3005f15-a2e6-11f0-96eb-67f4404dbe40	PAID	AF	t	2884.00	PLN	Allegro Kurier DPD	0.00	PLN	2884.00	PLN	\N	t	\N	2025-10-06 19:02:13.869	\N	2025-10-06 20:34:39.878245	ONLINE	t	\N	\N	0.00	\N	\N	f
7525	137c4160-a537-11f0-9cb2-b90a5baab897	\N	\N	2025-10-09 17:41:49.788	READY_FOR_PROCESSING	allegro-pl	23355766	antonina1859	mumxb1xw1x+637e44d70@allegromail.pl	\N	Sebastian Łaszczewski	+48 696 524 012	Kolejowa 3 / 1	56-320	Krośnice	PL	13cef549-a537-11f0-96eb-67f4404dbe40	PAID	AF	t	76.00	PLN	Allegro Kurier DPD	0.00	PLN	76.00	PLN	\N	t	\N	2025-10-09 17:41:49.788	\N	2025-10-09 19:33:05.168128	ONLINE	f	[]	\N	0.00	\N	[]	f
2962	9a4e25d0-a2d2-11f0-a6cc-b3145592fdde	\N	\N	2025-10-06 16:43:55.09	READY_FOR_PROCESSING	allegro-pl	24840609	PaulinaStecyk	7ah7rhlx9d+11a405ed3@allegromail.pl	\N	Paulina Stecyk	+48 665 928 245	Elizy Orzeszkowej 4e / 7	73-150	Łobez	PL	336c4cd1-a2d3-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	1354.40	PLN	Haki H2 - Chrom\nSiedzisko i panel WE3 - Welur grafitowy\nPłatność kartą u kuriera	f	\N	2025-10-06 16:43:55.09	\N	2025-10-06 20:34:44.213626	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
7526	69c2c560-a534-11f0-a008-2360f331b758	\N	\N	2025-10-09 17:24:16.631	READY_FOR_PROCESSING	allegro-pl	10333698	maryska_b	890b9n5d6e+5d9352431@allegromail.pl	\N	martyna borkowska	+48 504 753 369	Witosa 1f / 1	10-900	olsztyn	PL	8a5da33c-a534-11f0-a284-071dd65bf45d	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	ES2 eko skóra jasnoszary 	t	\N	2025-10-09 17:24:16.631	\N	2025-10-09 19:33:06.492133	ONLINE	f	[]	\N	0.00	\N	[]	f
7527	84ca8da0-a527-11f0-a444-6d64b3cc877f	\N	\N	2025-10-09 16:05:40.152	READY_FOR_PROCESSING	allegro-pl	40456283	Secinst	4vd0nmwkj4+6e572c818@allegromail.pl	SECURITAS - INSTALACJE ZENON PACUKIEWICZ	Zenon Pacukiewicz	+48 606 278 448	Klonowica 24 / 5	71-247	Szczecin	PL	383297f6-a528-11f0-91d4-7961b40d7b05	PAID	PAYU	t	1605.98	PLN	Allegro Kurier DPD	29.98	PLN	1605.98	PLN	\N	f	\N	2025-10-09 16:05:40.152	\N	2025-10-09 19:33:07.807719	ONLINE	t	[]	ul. Jesienny Sad 15	0.00	\N	[]	f
7528	78eca3c0-a526-11f0-8895-094b8cada9e7	\N	\N	2025-10-09 16:01:55.31	READY_FOR_PROCESSING	allegro-pl	78381676	izabela_giezek	45fsywqup8+259aba468@allegromail.pl	\N	Anna Michalska	+48 784 377 522	Lipowa 50E / 3	59-180	Gaworzyce	PL	3d212624-a529-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	832.99	PLN	Dzień dobry,\nProszę o wysłanie koloru siedziska takie jak jest na zdjęciu (czarne).\n\nDziękuję 	t	\N	2025-10-09 16:01:55.31	\N	2025-10-09 19:33:09.134561	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7529	6a9651c0-a523-11f0-a204-f12f4b71e7fe	\N	\N	2025-10-09 15:22:17.093	READY_FOR_PROCESSING	allegro-pl	82941713	Client:82941713	fzzkamasdt+7732eaec6@allegromail.pl	\N	Eliza Gałczyńska	+48 505 164 024	Upałty Małe 4/2	11-500	Giżycko	PL	a195e925-a523-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	389.99	PLN	\N	t	\N	2025-10-09 15:22:17.093	\N	2025-10-09 19:33:10.435375	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7530	e9aba750-a521-11f0-b989-75c7faccd1ca	\N	\N	2025-10-09 15:14:49.748	READY_FOR_PROCESSING	allegro-pl	29199083	serpent90	19ubcvl8le+1db7bd209@allegromail.pl	\N	Adam Kośnikowski	+48 880 256 389	10, 3-go Maja	68-120	Iłowa	PL	e9e86299-a521-11f0-96eb-67f4404dbe40	PAID	PAYU	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	Kolor: F03 Fjord Grafit	t	\N	2025-10-09 15:14:49.748	\N	2025-10-09 19:33:11.777365	ONLINE	f	[]	\N	0.00	\N	[]	f
7531	6d4cfc60-a51a-11f0-a588-b391296a673a	\N	\N	2025-10-09 14:18:24.449	READY_FOR_PROCESSING	allegro-pl	21834983	mruczka240	zmj56e18dq+6fac5ded9@allegromail.pl	\N	Alicja Drozd	+48 724 522 142	Gnojnica 214	39-105	Gnojnica	PL	70814cf1-a51a-11f0-b9a1-9fd75769370f	PAID	P24	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-10-09 14:18:24.449	\N	2025-10-09 19:33:13.158206	ONLINE	f	[]	\N	0.00	\N	[]	f
7532	5448b830-a51a-11f0-9bfc-3dd64ee50ad6	\N	\N	2025-10-09 14:18:17.364	READY_FOR_PROCESSING	allegro-pl	86161412	Client:86161412	kuzf2ibpbe+fce55208@allegromail.pl	\N	Magdalena Ratajczak	+48 666 673 307	Romanów 28	98-235	Błaszki	PL	5486d325-a51a-11f0-ae11-e76c74c7cf77	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-09 14:18:17.364	\N	2025-10-09 19:33:14.468451	ONLINE	f	[]	\N	0.00	\N	[]	f
7533	b3f8dca0-a516-11f0-a5d7-371746f07634	\N	\N	2025-10-09 13:51:11.355	READY_FOR_PROCESSING	allegro-pl	3894840	Arro77	qudw7466dh+110840545@allegromail.pl	\N	Artur Kaczmarczyk	+48 691 795 430	Socjalna 11 m.10	93-324	Łódź	PL	dbd072f9-a516-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1337.39	PLN	TH3 - Tkanina Hugo Grafitowy\nH1 - Czarny Wieszki\n\nDostawę poproszę po godzinie 14	t	\N	2025-10-09 13:51:11.355	\N	2025-10-09 19:33:15.780528	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7534	8922fc00-a50b-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-09 12:31:56.06	READY_FOR_PROCESSING	allegro-pl	78894080	Client:78894080	o0jutxr2o8+1418a6b80@allegromail.pl	\N	Andrii Fomenko	+48 727 874 071	Przemysłowa 23 / 13	67-200	Głogów	PL	895de2f8-a50b-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	1430.10	PLN	Allegro Kurier DPD	0.00	PLN	1430.10	PLN	Kolor haków :H1 - Czarny\nKolor siedzisk: ES1 - Eko skóra Czarny	t	\N	2025-10-09 12:31:56.06	\N	2025-10-09 19:33:17.087355	ONLINE	f	[]	\N	0.00	\N	[]	f
7535	268f0bd1-a4ff-11f0-b9bf-2795de008363	\N	\N	2025-10-09 11:07:03.89	READY_FOR_PROCESSING	allegro-pl	13241999	5y1a	il4f3vmzoe+585461f62@allegromail.pl	\N	Sylwia Sewastianowicz	+48 691 303 397	Kapitańska 35/37	81-249	Gdynia	PL	2dc4e7a1-a4ff-11f0-b9a1-9fd75769370f	PAID	AF	t	628.00	PLN	Allegro Kurier DPD	0.00	PLN	628.00	PLN	Dzien dobry. Material wierzchni na siedzisko: czarny welur WE1.	t	\N	2025-10-09 11:07:03.89	\N	2025-10-09 19:33:18.40805	ONLINE	f	[]	\N	0.00	\N	[]	f
7536	ce8de6e0-a4fe-11f0-961e-6d069f850ff8	\N	\N	2025-10-09 10:58:16.663	READY_FOR_PROCESSING	allegro-pl	9532379	ania_szablowska	ukfjpgzlk5+74b354060@allegromail.pl	\N	Anna Dzikuć	+48 510 052 065	Ul.Pułaskiego 37a/40	66-620	Gubin	PL	cec54b3b-a4fe-11f0-ae11-e76c74c7cf77	PAID	AF	t	370.00	PLN	Allegro Kurier DPD	0.00	PLN	370.00	PLN	We3 welur grafit	t	\N	2025-10-09 10:58:16.663	\N	2025-10-09 19:33:19.876483	ONLINE	f	[]	\N	0.00	\N	[]	f
7537	8c2ca9a0-a4f7-11f0-a444-6d64b3cc877f	\N	\N	2025-10-09 10:07:54.831	READY_FOR_PROCESSING	allegro-pl	570847	altair1	gth1328whn+dc114dc0@allegromail.pl	\N	Krzysztof Setnik	+48 500 235 485	Stefana Kisielewskiego 7/122	41-219	Sosnowiec	PL	c72233bd-a4f7-11f0-baf9-a33944a1116d	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-09 10:07:54.831	\N	2025-10-09 19:33:21.116625	ONLINE	f	[]	\N	0.00	\N	[]	f
32	e4f4e930-a204-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 16:05:39.967	READY_FOR_PROCESSING	allegro-pl	15637789	husky091	dcyqf6aglr+481907e30@allegromail.pl	\N	Adam Jankowski	+48 601 572 895	hallera 8/5	88-300	mogilno	PL	f4ae2ea9-a204-11f0-a284-071dd65bf45d	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	tkanina   TH3	t	\N	2025-10-05 16:05:39.967	\N	2025-10-09 19:40:11.385311	ONLINE	f	[{"id": "RFBEOjEwMjY4NDUwOTEwMThV", "waybill": "1026845091018U", "carrierId": "DPD", "createdAt": "2025-10-06T05:04:01.043Z", "lineItems": [{"id": "e4edbd40-a204-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7538	243cd4e0-a4f3-11f0-a588-b391296a673a	\N	\N	2025-10-09 09:35:57.424	READY_FOR_PROCESSING	allegro-pl	44621517	Client:44621517	la2neq8wyx+14c282704@allegromail.pl	\N	Dariusz Wiśniewski	+48 695 634 289	ciechocinska 38 B	87-730	Nieszawa	PL	28c93b32-a4f3-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-09 09:35:57.424	\N	2025-10-09 19:33:22.970421	ONLINE	f	[]	\N	0.00	\N	[]	f
7546	550c2350-a4da-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-09 06:38:57.931	READY_FOR_PROCESSING	allegro-pl	4312052	Y_timer	vg9bfka3j8+67da51d12@allegromail.pl	\N	Dawid Dobecki	+48 600 470 581	Małe Błonia 3	64-920	Piła	PL	5544241b-a4da-11f0-a417-fd831f6ae8ec	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	Uchwyty CZARNE	t	\N	2025-10-09 06:38:57.931	\N	2025-10-09 19:33:34.232752	ONLINE	f	[]	\N	0.00	\N	[]	f
7547	6af85971-a4d7-11f0-8311-bd038e33f1de	\N	\N	2025-10-09 06:23:12.861	READY_FOR_PROCESSING	allegro-pl	107562636	Client:107562636	u1rwvxfsin+4ab2801b7@allegromail.pl	\N	Andrzej Lelito	+48 882 593 788	29 Listopada 18C / 24	33-300	Nowy Sącz	PL	2b5d2136-a4d8-11f0-96eb-67f4404dbe40	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Kolor siedziska THP2  ( Pikowany materiał jasno- szary).  Bardzo Proszę o towar dokładnie zgodny z opisem i jakością wykonania przedstawioną w ofercie sprzedaży oraz solidne zabezpieczenie towaru przed jakimkolwiek innym zniszczeniem w czasie transportu drogowego. Bardzo Proszę o Zrozumienie i pozdrawiam serdecznie.	t	\N	2025-10-09 06:23:12.861	\N	2025-10-09 19:33:35.64642	ONLINE	f	[]	\N	0.00	\N	[]	f
7548	a9d70f60-a4cd-11f0-a588-b391296a673a	\N	\N	2025-10-09 05:09:23.521	READY_FOR_PROCESSING	allegro-pl	10284449	WOLKA8	u7xhxqxpk9+69feec162@allegromail.pl	\N	Kamil Wolski	+48 502 231 760	Hodowców 88b	43-243	Wisła wielka	PL	cb2adcf4-a4cd-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1709.99	PLN	Kolor obicia welur głodki WE3\nKolor wieszaków czarny H1	t	\N	2025-10-09 05:09:23.521	\N	2025-10-09 19:33:37.044975	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7555	05ac2481-a472-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-08 18:32:38.805	READY_FOR_PROCESSING	allegro-pl	35407805	Client:35407805	o0u3e37351+634b37453@allegromail.pl	\N	Katarzyna Hoska	+48 667 264 939	Jeżewo 22/6	63-810	Borek Wielkopolski	PL	ca4c242d-a472-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	977.40	PLN	Kurier DPD	34.00	PLN	977.40	PLN	Siedzisko- eko skóra czarny 	f	\N	2025-10-08 18:32:38.805	\N	2025-10-09 19:33:46.842809	ONLINE	f	[{"id": "RFBEOjEwMjcxODAxNzgyODlV", "waybill": "1027180178289U", "carrierId": "DPD", "createdAt": "2025-10-09T11:59:18.537Z", "lineItems": [{"id": "05a100f2-a472-11f0-a685-3b2ebe8a80a1"}, {"id": "05a100f1-a472-11f0-a685-3b2ebe8a80a1"}]}, {"id": "RFBEOjEwMjcxODAxNzgzNzJV", "waybill": "1027180178372U", "carrierId": "DPD", "createdAt": "2025-10-09T11:59:18.758Z", "lineItems": [{"id": "05a100f2-a472-11f0-a685-3b2ebe8a80a1"}, {"id": "05a100f1-a472-11f0-a685-3b2ebe8a80a1"}]}]	\N	0.00	\N	[]	f
7556	d754ab50-a473-11f0-b12e-53a023ce25d9	\N	\N	2025-10-08 18:24:57.541	READY_FOR_PROCESSING	allegro-pl	41571664	Lin86	fx0un4lw45+426e7526@allegromail.pl	\N	Piotr Linkiewicz	+48 693 455 787	Wiszesława 14/9	71-721	Szczecin	PL	fb39f93d-a473-11f0-91d4-7961b40d7b05	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Witam siedzisko welur grafit 	t	\N	2025-10-08 18:24:57.541	\N	2025-10-09 19:33:48.41784	ONLINE	f	[{"id": "RFBEOjEwMjcxMzEwMjY4NjhV", "waybill": "1027131026868U", "carrierId": "DPD", "createdAt": "2025-10-09T05:03:33.893Z", "lineItems": [{"id": "d74d5850-a473-11f0-b12e-53a023ce25d9"}]}]	\N	0.00	\N	[]	f
7539	f621b350-a4f2-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-09 09:33:27.735	FILLED_IN	allegro-pl	44621517	Client:44621517	la2neq8wyx+4f88e2345@allegromail.pl	\N	Dariusz Wiśniewski	+48 695 634 289	\N	\N	\N	\N	f64bd174-a4f2-11f0-a417-fd831f6ae8ec	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	\N	\N	2025-10-09 20:15:49.82405	ONLINE	f	[]	\N	0.00	\N	[]	f
7557	a8a50430-a46e-11f0-b989-75c7faccd1ca	\N	\N	2025-10-08 17:48:08.828	READY_FOR_PROCESSING	allegro-pl	6622301	maciej526	u7v3ifaeyr+4cd828370@allegromail.pl	\N	Maciej Pawlak	+48 505 084 620	Kościuszki 12 / 3	67-400	Wschowa	PL	a8e2a9f0-a46e-11f0-a284-071dd65bf45d	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	Tkanina F04	t	\N	2025-10-08 17:48:08.828	\N	2025-10-09 19:33:49.816947	ONLINE	f	[]	\N	0.00	\N	[]	f
7558	95930970-a46c-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-08 17:45:03.705	CANCELLED	allegro-pl	6622301	maciej526	u7v3ifaeyr+242c16573@allegromail.pl	\N	Maciej Pawlak	+48 505 084 620	Kościuszki 12 / 3	67-400	Wschowa	PL	95b6bef4-a46c-11f0-91d4-7961b40d7b05	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Tkanina F04	t	\N	2025-10-08 17:32:09.367	\N	2025-10-09 19:33:51.19413	ONLINE	f	[]	\N	326.00	2025-10-08 17:45:59.227	[{"id": "a63822e6-a46e-11f0-9a6c-5b23ef27fcef", "order": {"id": "95930970-a46c-11f0-a685-3b2ebe8a80a1"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "95b6bef4-a46c-11f0-91d4-7961b40d7b05"}, "deposits": [], "createdAt": "2025-10-08T17:45:59.227Z", "lineItems": [{"id": "958e7590-a46c-11f0-a685-3b2ebe8a80a1", "type": "AMOUNT", "value": {"amount": "326.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "326.00", "currency": "PLN"}}]	f
7606	c0ad0550-a432-11f0-a6cc-b3145592fdde	\N	\N	2025-10-08 10:41:00.893	READY_FOR_PROCESSING	allegro-pl	49535681	Client:49535681	483xs97xtk+43a7031e3@allegromail.pl	\N	LIUDMYLA Śmiałek	+48 722 702 320	Królewicza 3 / 2	66-200	Świebodzin	PL	c0eb6de2-a432-11f0-a284-071dd65bf45d	PAID	AF	t	1283.00	PLN	Allegro Kurier DPD	0.00	PLN	1283.00	PLN	Dzień dobry. Wieszaki złoto szcotkowane . Welur grafitowy ( WE3) dziękuję . Pozdrawiam 	t	\N	2025-10-08 10:41:00.893	\N	2025-10-09 19:34:03.124553	ONLINE	f	[{"id": "RFBEOjEwMjcwOTQ4MTEyNTZV", "waybill": "1027094811256U", "carrierId": "DPD", "createdAt": "2025-10-08T11:43:05.038Z", "lineItems": [{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjcwOTQ4MTEzNDFV", "waybill": "1027094811341U", "carrierId": "DPD", "createdAt": "2025-10-08T11:43:05.263Z", "lineItems": [{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjcwOTQ4MTE0NDBV", "waybill": "1027094811440U", "carrierId": "DPD", "createdAt": "2025-10-08T11:43:05.453Z", "lineItems": [{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7607	bce878b1-a431-11f0-af7e-5f793825db67	\N	\N	2025-10-08 10:31:20.681	READY_FOR_PROCESSING	allegro-pl	18355524	kasia_galecka	5qniq3hq50+2da9b1f93@allegromail.pl	\N	Katarzyna Gałecka	+48 510 239 621	Szkolna 1 / 3	55-320	Malczyce	PL	bd26940c-a431-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-08 10:31:20.681	\N	2025-10-09 19:34:04.745058	ONLINE	f	[]	\N	0.00	\N	[]	f
7608	36778280-a431-11f0-8f13-933da22fca3d	\N	\N	2025-10-08 10:30:15.503	READY_FOR_PROCESSING	allegro-pl	24622440	Elizz94	lruia3wras+5f27e1801@allegromail.pl	\N	Irmina Kundys	+48 504 989 662	Małęczyńska 21	26-603	Radom	PL	36b9bbc4-a431-11f0-a284-071dd65bf45d	PAID	AF	t	2334.00	PLN	Allegro Kurier DPD	0.00	PLN	2334.00	PLN	Dąb wotan + białe fronty, obicie materiałowe w kolorze niebieskiego weluru 	t	\N	2025-10-08 10:30:15.503	\N	2025-10-09 19:34:06.275499	ONLINE	f	[]	\N	0.00	\N	[]	f
7657	a6fb8ab0-a341-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-07 05:52:10.974	READY_FOR_PROCESSING	allegro-pl	3274168	rekinek77	dfm9l26k6g+38e8e0711@allegromail.pl	\N	Magdalena Lewandowska	+48 796 603 313	Mała Wieś 2	05-622	Belsk Duży	PL	a726926f-a341-11f0-bb32-51209e96d6bb	PAID	P24	t	432.99	PLN	Allegro Kurier DPD	14.99	PLN	432.99	PLN	\N	f	\N	2025-10-07 05:52:10.974	\N	2025-10-09 19:35:22.641558	ONLINE	f	[]	\N	0.00	\N	[]	f
7540	2cec7420-a4f2-11f0-9da2-81c6f7d897d8	\N	\N	2025-10-09 09:29:25.061	READY_FOR_PROCESSING	allegro-pl	111337136	Client:111337136	2hfupk91w0+235235616@allegromail.pl	\N	Waldemar  Rakowski 	+48 502 930 494	Klonowo 78	89-526	Klonowo	PL	2d29f251-a4f2-11f0-a417-fd831f6ae8ec	PAID	P24	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	\N	t	\N	2025-10-09 09:29:25.061	\N	2025-10-09 19:33:25.766553	ONLINE	f	[]	\N	0.00	\N	[]	f
7541	a9729de0-a4f1-11f0-a402-d9289fd02c21	\N	\N	2025-10-09 09:24:37.524	READY_FOR_PROCESSING	allegro-pl	17620245	macwinnicki	bbpcgmvkek+7a78e4194@allegromail.pl	\N	Martyna Winnicka	+48 515 542 518	Jagiełły 8C / 43	41-219	Sosnowiec	PL	a995dded-a4f1-11f0-baf9-a33944a1116d	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-09 09:24:37.524	\N	2025-10-09 19:33:27.218214	ONLINE	f	[]	\N	0.00	\N	[]	f
7542	3df7e2c0-a4ef-11f0-b9bf-2795de008363	\N	\N	2025-10-09 09:06:41.301	READY_FOR_PROCESSING	allegro-pl	2556474	aniamuzyk	x39lntlejm+3492962c6@allegromail.pl	\N	Anna Smolarek-Łągiewczyk	+48 792 015 508	Mickiewicza 3	98-170	Widawa	PL	3e253520-a4ef-11f0-91d4-7961b40d7b05	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	\N	t	\N	2025-10-09 09:06:41.301	\N	2025-10-09 19:33:28.564613	ONLINE	f	[]	\N	0.00	\N	[]	f
7543	b8cfe420-a4ea-11f0-b89d-d9b346103272	\N	\N	2025-10-09 08:36:01.604	READY_FOR_PROCESSING	allegro-pl	23935684	Client:23935684	1uevcwon3v+5ef0f87c9@allegromail.pl	\N	Iwona Łoś	+48 602 116 466	Cisowa 27 / 8	21-040	Świdnik	PL	d7d37f5f-a4ea-11f0-b9a1-9fd75769370f	PAID	AF	t	327.19	PLN	Allegro Kurier DPD	14.99	PLN	327.19	PLN	ES1	f	\N	2025-10-09 08:36:01.604	\N	2025-10-09 19:33:29.989278	ONLINE	f	[]	\N	0.00	\N	[]	f
7544	5ce2e000-a4df-11f0-961e-6d069f850ff8	\N	\N	2025-10-09 07:13:54.111	READY_FOR_PROCESSING	allegro-pl	9488096	pablosz5	sjb4lu8o2g+55e81a2d5@allegromail.pl	\N	Paweł Szczęch	+48 668 623 764	Szynwałd 191A	33-158	Szynwałd	PL	5d1a6bb3-a4df-11f0-a417-fd831f6ae8ec	PAID	AF	t	884.10	PLN	Allegro Kurier DPD	0.00	PLN	884.10	PLN	\N	t	\N	2025-10-09 07:13:54.111	\N	2025-10-09 19:33:31.441819	ONLINE	f	[]	\N	0.00	\N	[]	f
7545	6d4c85d0-a4db-11f0-a444-6d64b3cc877f	\N	\N	2025-10-09 06:45:37.635	READY_FOR_PROCESSING	allegro-pl	24105007	pabl4	wfzmsnt2f7+2045ce863@allegromail.pl	\N	Paulina Blat	+48 661 089 421	Lasowiacka 15	36-105	Cmolas	PL	6d6dc978-a4db-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-09 06:45:37.635	\N	2025-10-09 19:33:32.852629	ONLINE	f	[]	\N	0.00	\N	[]	f
7609	97ae46f0-a42d-11f0-a6cc-b3145592fdde	\N	\N	2025-10-08 10:01:04.518	READY_FOR_PROCESSING	allegro-pl	1261425	tommiboss	cab50f9f1y+5bef048d6@allegromail.pl	\N	Tomasz Graniczny	+48 726 150 482	Lazarówka 3	41-935	Bytom	PL	ab735035-a42d-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	317.19	PLN	Tkanina: TH1 HUGO CZARNY	t	\N	2025-10-08 10:01:04.518	\N	2025-10-09 19:34:08.004649	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwOTQ5OTM5MzJV", "waybill": "1027094993932U", "carrierId": "DPD", "createdAt": "2025-10-08T11:44:49.580Z", "lineItems": [{"id": "97a6a5d0-a42d-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7610	83027ce0-a42c-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-08 09:54:11.5	READY_FOR_PROCESSING	allegro-pl	40482476	Kamilcia1305	fp8vn0chtv+2540dfde9@allegromail.pl	\N	Kamila Nonckiewicz	+48 695 821 522	Piekary 50C	98-338	Sulmierzyce	PL	a600020d-a42c-11f0-b9a1-9fd75769370f	PAID	AF	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	WE welur niebieski 	t	\N	2025-10-08 09:54:11.5	\N	2025-10-09 19:34:09.582562	ONLINE	f	[{"id": "RFBEOjEwMjcwOTUwOTYwMDlV", "waybill": "1027095096009U", "carrierId": "DPD", "createdAt": "2025-10-08T11:45:39.289Z", "lineItems": [{"id": "82f7f590-a42c-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7625	3f06f230-a3c5-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-07 21:34:53.943	READY_FOR_PROCESSING	allegro-pl	4814806	mmax88	cqyhifo1t4+39bc6c0@allegromail.pl	\N	Michał Wańczyk	+48 796 208 795	Buchowieckiego 30	32-300	Olkusz	PL	3f250185-a3c5-11f0-b9a1-9fd75769370f	PAID	AF	t	437.00	PLN	Allegro Kurier DPD	0.00	PLN	437.00	PLN	proszę o szafkę z tkaniną Hugo THP1 - tkanina hugo pik grafitowy	t	\N	2025-10-07 21:34:53.943	\N	2025-10-09 19:34:33.083616	ONLINE	f	[]	\N	437.00	2025-10-08 07:06:38.348	[{"id": "556a17d7-a415-11f0-adca-df1f4c83d3c5", "order": {"id": "3f06f230-a3c5-11f0-96ea-bf4f56b08af2"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "3f250185-a3c5-11f0-b9a1-9fd75769370f"}, "deposits": [], "createdAt": "2025-10-08T07:06:38.348Z", "lineItems": [{"id": "3f028560-a3c5-11f0-96ea-bf4f56b08af2", "type": "QUANTITY", "quantity": 1}, {"id": "3f028561-a3c5-11f0-96ea-bf4f56b08af2", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "437.00", "currency": "PLN"}}]	t
7626	6fe2d080-a3bc-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-07 21:11:17.346	READY_FOR_PROCESSING	allegro-pl	125672665	Client:125672665	b78hv0518y+48dd74425@allegromail.pl	\N	Klaudia Pobudkiewicz	+48 792 928 407	Kościuszki 25 / 2	87-140	Chełmża	PL	7005742e-a3bc-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1263.50	PLN	Allegro Kurier DPD	0.00	PLN	1263.50	PLN	wieszak czarny tkanina welur czarny	t	\N	2025-10-07 21:11:17.346	\N	2025-10-09 19:34:35.013449	ONLINE	f	[{"id": "RFBEOjEwMjcwNjAyMjA5NTBV", "waybill": "1027060220950U", "carrierId": "DPD", "createdAt": "2025-10-08T07:16:44.091Z", "lineItems": [{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjcwNjAyMjEwMTFV", "waybill": "1027060221011U", "carrierId": "DPD", "createdAt": "2025-10-08T07:16:44.314Z", "lineItems": [{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjcwNjAyMjExNTBV", "waybill": "1027060221150U", "carrierId": "DPD", "createdAt": "2025-10-08T07:16:44.512Z", "lineItems": [{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7627	0a1d8ba0-a3b2-11f0-b871-03a75625f948	\N	\N	2025-10-07 19:17:35.232	READY_FOR_PROCESSING	allegro-pl	45986631	falatag	v8nw8r20dg+2c93c12c8@allegromail.pl	\N	Agnieszka Kęsik	+48 506 343 687	Maciejkowa 11/10	71-784	Szczecin	PL	0feb9955-a3b2-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Siedzisko F03	t	\N	2025-10-07 19:17:35.232	\N	2025-10-09 19:34:36.502939	ONLINE	f	[]	\N	0.00	\N	[]	f
7628	8f91a0b0-a3b1-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-07 19:16:10.607	READY_FOR_PROCESSING	allegro-pl	3837601	magdzia29	xy6kx1v1ux+24452ab16@allegromail.pl	\N	Magdalena Karaś	+48 600 053 649	Nickla 82/10	41-923	Bytom	PL	9d817071-a3b1-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	679.29	PLN	Dzień dobry,\nCzy byłaby możliwość dostawy na sobotę 11.10.2025?	t	\N	2025-10-07 19:16:10.607	\N	2025-10-09 19:34:37.971936	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcxNjUwOTIxMDZV", "waybill": "1027165092106U", "carrierId": "DPD", "createdAt": "2025-10-09T09:49:09Z", "lineItems": [{"id": "8f862f00-a3b1-11f0-b1e3-b7ce882fc700"}]}, {"id": "RFBEOjEwMjcxNjUwOTIyOThV", "waybill": "1027165092298U", "carrierId": "DPD", "createdAt": "2025-10-09T09:49:09Z", "lineItems": [{"id": "8f862f00-a3b1-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
74	dc074280-a134-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-04 15:15:30.453	READY_FOR_PROCESSING	allegro-pl	47903547	ZuzannaKula99	6qktvembj0+1d0698a76@allegromail.pl	\N	Zuzanna Kula	+48 669 525 505	Niklowa 4	85-453	Bydgoszcz	PL	dc2244c4-a134-11f0-91d4-7961b40d7b05	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-10-04 15:15:30.453	\N	2025-10-09 19:41:14.126933	ONLINE	f	[{"id": "RFBEOjEwMjY5NjY4NDk2MTVV", "waybill": "1026966849615U", "carrierId": "DPD", "createdAt": "2025-10-07T06:44:19.968Z", "lineItems": [{"id": "dc02d5b0-a134-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7549	e64fe9b0-a493-11f0-a471-6bb0586de370	\N	\N	2025-10-08 22:17:02.482	READY_FOR_PROCESSING	allegro-pl	70223087	Black95955	fzvh83qudq+4521d8169@allegromail.pl	\N	Konrad Żak	+48 534 947 293	Uniwersytecka 5	25-351	Kielce	PL	e6848f03-a493-11f0-a284-071dd65bf45d	PAID	AF	t	657.99	PLN	Allegro Kurier DPD	14.99	PLN	657.99	PLN	H1\nTH1	f	\N	2025-10-08 22:17:02.482	\N	2025-10-09 19:33:38.4484	ONLINE	f	[]	\N	0.00	\N	[]	f
7551	04361df1-a480-11f0-bfb1-c5232bd647f2	\N	\N	2025-10-08 19:51:34.836	READY_FOR_PROCESSING	allegro-pl	46745275	kubarantArenam	dufxfoazqp+7f5035587@allegromail.pl	\N	Jakub Wiercioch	+48 500 141 806	Marynin 33A / 81	01-469	Warszawa	PL	196d5574-a480-11f0-baf9-a33944a1116d	PAID	P24	t	835.00	PLN	Allegro Kurier DPD	0.00	PLN	835.00	PLN	\N	t	\N	2025-10-08 19:51:34.836	\N	2025-10-09 19:33:41.242995	ONLINE	f	[]	\N	0.00	\N	[]	f
7552	dfc1f3f0-a47e-11f0-a4f0-7ba876f09f6f	\N	\N	2025-10-08 19:49:10.098	READY_FOR_PROCESSING	allegro-pl	42049166	Kamilu9825	pwu3lxk9ef+c891d3e7@allegromail.pl	\N	Kamil Urbanek	+48 693 923 901	Tuwima 49/1	59-900	Zgorzelec	PL	dfe5a8fe-a47e-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	\N	t	\N	2025-10-08 19:49:10.098	\N	2025-10-09 19:33:42.627656	ONLINE	f	[{"id": "RFBEOjEwMjcxMzA0NTI0NzlV", "waybill": "1027130452479U", "carrierId": "DPD", "createdAt": "2025-10-09T04:53:39.682Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA0NTI1NjZV", "waybill": "1027130452566U", "carrierId": "DPD", "createdAt": "2025-10-09T04:53:39.859Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA0NTI2NDZV", "waybill": "1027130452646U", "carrierId": "DPD", "createdAt": "2025-10-09T04:53:40.052Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA2MDE4NzRV", "waybill": "1027130601874U", "carrierId": "DPD", "createdAt": "2025-10-09T04:56:29.303Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA2MDE5OTVV", "waybill": "1027130601995U", "carrierId": "DPD", "createdAt": "2025-10-09T04:56:29.484Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA2MDIwMDdV", "waybill": "1027130602007U", "carrierId": "DPD", "createdAt": "2025-10-09T04:56:29.685Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}]	\N	0.00	\N	[]	f
7553	88fcb1c0-a47b-11f0-a471-6bb0586de370	\N	\N	2025-10-08 19:23:45.81	READY_FOR_PROCESSING	allegro-pl	133864326	Wojtastralis2	7ay0m0qozm+cce3eed5@allegromail.pl	\N	Wojciech Kaczmarek	+48 608 350 301	Dąbrowskiego 153 / 20	60-588	Poznań	PL	04bf96c8-a47c-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	EKO SKÓRA JASNY SZARY ES2	t	\N	2025-10-08 19:23:45.81	\N	2025-10-09 19:33:44.093976	ONLINE	f	[{"id": "RFBEOjEwMjcxNzQzOTg0MjRV", "waybill": "1027174398424U", "carrierId": "DPD", "createdAt": "2025-10-09T11:04:42.326Z", "lineItems": [{"id": "88f62210-a47b-11f0-a471-6bb0586de370"}]}]	\N	0.00	\N	[]	f
7554	a86e7f50-a478-11f0-8895-094b8cada9e7	\N	\N	2025-10-08 18:58:51.018	READY_FOR_PROCESSING	allegro-pl	69688753	Client:69688753	iam58kdsgq+56ce521c6@allegromail.pl	\N	Kamila Zapalska	+48 794 203 096	Rynek 8/6	26-110	Skarżysko - Kamienna	PL	a8a63140-a478-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Ekoskóra Grafit 	t	\N	2025-10-08 18:58:51.018	\N	2025-10-09 19:33:45.474263	ONLINE	f	[{"id": "RFBEOjEwMjcxNzQ0OTI5MTBV", "waybill": "1027174492910U", "carrierId": "DPD", "createdAt": "2025-10-09T11:05:33Z", "lineItems": [{"id": "a867c890-a478-11f0-8895-094b8cada9e7"}]}]	\N	0.00	\N	[]	f
7559	2756b3c0-a45e-11f0-9583-47424f8c2810	\N	\N	2025-10-08 15:50:40.268	READY_FOR_PROCESSING	allegro-pl	48634058	Niki1203	9q8k1nonqm+766803267@allegromail.pl	\N	Nikola Sawka	+48 570 788 321	Szybowcowa 67H / 4	70-843	Szczecin	PL	2b00f7b8-a45e-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Poproszę tkaninę welur jasno szary (WE2) 	t	\N	2025-10-08 15:50:40.268	\N	2025-10-09 19:33:52.568984	ONLINE	f	[]	\N	0.00	\N	[]	f
7560	5da97f10-a455-11f0-b989-75c7faccd1ca	\N	\N	2025-10-08 14:46:13.498	CANCELLED	allegro-pl	66165003	Client:66165003	jat3os9v4h+2c7084cf8@allegromail.pl	\N	Violetta Januszewska	+48 665 128 162	Kaszubska 10	78-400	Szczecinek	PL	5df09aa6-a455-11f0-ae11-e76c74c7cf77	PAID	AF	t	383.79	PLN	Allegro Kurier DPD	14.99	PLN	383.79	PLN	\N	f	\N	2025-10-08 14:45:08.393	\N	2025-10-09 19:33:53.953576	ONLINE	f	[]	\N	383.79	2025-10-08 14:47:11.038	[{"id": "abc90a94-a455-11f0-adca-0d13b73a234b", "order": {"id": "5da97f10-a455-11f0-b989-75c7faccd1ca"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "5df09aa6-a455-11f0-ae11-e76c74c7cf77"}, "delivery": {"value": {"amount": "14.99", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-08T14:47:11.038Z", "lineItems": [{"id": "5da1b6e0-a455-11f0-b989-75c7faccd1ca", "type": "AMOUNT", "value": {"amount": "368.80", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "383.79", "currency": "PLN"}}]	f
7611	a92e4620-a426-11f0-96d3-f7121b08a32c	\N	\N	2025-10-08 09:12:49.867	READY_FOR_PROCESSING	allegro-pl	58434299	Client:58434299	451fu3zshz+2627cca32@allegromail.pl	\N	Lucyna Szaraniec	+48 661 378 906	Ul.Leśny Stok 4/52	80-260	Gdańsk	PL	b75cccfe-a426-11f0-baf9-a33944a1116d	PAID	P24	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	Proszę o kolor siedziska welur brązowy WE 4	t	\N	2025-10-08 09:12:49.867	\N	2025-10-09 19:34:11.119521	ONLINE	f	[]	\N	0.00	\N	[]	f
7612	c32a2630-a425-11f0-b1f1-69448e84eb62	\N	\N	2025-10-08 09:07:37.644	READY_FOR_PROCESSING	allegro-pl	44921906	gorznat	ya566vw3ea+7f2bf4426@allegromail.pl	\N	Natalia Gorzałka	+48 510 144 879	okopowa 31 / 21	01-059	warszawa	PL	edd37a88-a425-11f0-baf9-a33944a1116d	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	bardzo prosze o kolor SIEDZISKA ES3 - EKO SKORA GRAFITOWY	t	\N	2025-10-08 09:07:37.644	\N	2025-10-09 19:34:12.650332	ONLINE	f	[{"id": "RFBEOjEwMjcwOTUzMjg2NDBV", "waybill": "1027095328640U", "carrierId": "DPD", "createdAt": "2025-10-08T11:47:55.769Z", "lineItems": [{"id": "c322ac20-a425-11f0-b1f1-69448e84eb62"}]}]	\N	0.00	\N	[]	f
7613	c35e0ed0-a422-11f0-af7e-5f793825db67	\N	\N	2025-10-08 08:46:35.061	READY_FOR_PROCESSING	allegro-pl	122376187	Client:122376187	qb1px6syzp+37e0ec21@allegromail.pl	\N	Ewa Wieckowska	+48 507 409 364	dabrowa19	06-445	strzegowo	PL	3c066d67-a423-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1347.99	PLN	Siedzisko i panel ścienny WE2 (welur jasno szary)\nhaki H3 (złoto szczotkowanie)	t	\N	2025-10-08 08:46:35.061	\N	2025-10-09 19:34:14.18697	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7614	ae6b5810-a41e-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-08 08:16:36.738	READY_FOR_PROCESSING	allegro-pl	41230971	Client:41230971	f9ow5lznvi+2202d8ab4@allegromail.pl	\N	Bartosz Mikulski	+48 530 318 472	os. Pod Lipami 2e / 60	61-628	Poznań	PL	c34469ff-a41e-11f0-a417-fd831f6ae8ec	PAID	AF	t	1750.10	PLN	Allegro Kurier DPD	0.00	PLN	1750.10	PLN	\N	t	\N	2025-10-08 08:16:36.738	\N	2025-10-09 19:34:15.671607	ONLINE	f	[]	\N	0.00	\N	[]	f
84	90c6f9c0-a0fb-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-04 08:25:06.902	READY_FOR_PROCESSING	allegro-pl	38872915	Adrianx1995	wx47gm85wf+2dc50c4d9@allegromail.pl	\N	Adrian Wasiluk	+48 796 138 732	Porzeczkowa 4	21-300	Radzyń Podlaski	PL	93799703-a0fb-11f0-b9a1-9fd75769370f	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-04 08:25:06.902	\N	2025-10-06 18:52:54.929446	ONLINE	f	\N	\N	0.00	\N	\N	f
18	93c15c40-a233-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 21:49:02.494	READY_FOR_PROCESSING	allegro-pl	81432587	Client:81432587	khz3pnbc46+2e835c1b6@allegromail.pl	\N	Lucjan Szewczyk	+48 668 776 645	Osiedle 700-lecia 6 / 36	32-650	Kęty	PL	9894b6f3-a233-11f0-96eb-67f4404dbe40	PAID	PAYU	t	676.00	PLN	Allegro Kurier DPD	0.00	PLN	676.00	PLN	\N	t	\N	2025-10-05 21:49:02.494	\N	2025-10-09 19:39:48.761018	ONLINE	f	[{"id": "RFBEOjEwMjY5Njc0MDc1NTZV", "waybill": "1026967407556U", "carrierId": "DPD", "createdAt": "2025-10-07T06:48:25.090Z", "lineItems": [{"id": "93baa581-a233-11f0-a6cc-b3145592fdde"}, {"id": "93baa580-a233-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
551	c301a2d0-a2b5-11f0-abc1-17dd0035cfdf	\N	\N	2025-10-06 13:12:17.977	READY_FOR_PROCESSING	allegro-pl	49717061	Client:49717061	lrd4l7ftbx+4a54f4f56@allegromail.pl	\N	Katarzyna Bąk	+48 608 422 616	Zacisze 3	62-800	Kalisz	PL	c34403db-a2b5-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	kolor siedziska czarny welur	t	\N	2025-10-06 13:12:17.977	\N	2025-10-06 20:34:47.126296	ONLINE	f	\N	\N	0.00	\N	\N	f
19	68cb3021-a22d-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 20:55:55.393	READY_FOR_PROCESSING	allegro-pl	5919292	magdat8	kyqw9kab2w+3aa90e3d0@allegromail.pl	\N	Magdalena Lupzik	+48 883 602 203	E. PLATER 2a /9 	75-348	KOSZALIN	PL	6dd307da-a22d-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-05 20:55:55.393	\N	2025-10-09 19:39:50.461152	ONLINE	t	[{"id": "RFBEOjEwMjY5NjQyNTA0ODNV", "waybill": "1026964250483U", "carrierId": "DPD", "createdAt": "2025-10-07T06:25:25.095Z", "lineItems": [{"id": "68c5d8f1-a22d-11f0-954f-f9092bddbf0d"}]}]	E. PLATER 2a /9	0.00	\N	[]	f
21	52cd4060-a228-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 20:23:28.505	READY_FOR_PROCESSING	allegro-pl	46996151	aleksandra19969	p1ejmaixha+46ec67a11@allegromail.pl	\N	Aleksandra Ambroziak	+48 502 893 283	Justynów 52a	08-300	Sokołów Podlaski	PL	f2d96410-a228-11f0-a417-fd831f6ae8ec	PAID	P24	t	564.00	PLN	Allegro Kurier DPD	0.00	PLN	564.00	PLN	\N	t	\N	2025-10-05 20:23:28.505	\N	2025-10-09 19:39:53.773874	ONLINE	f	[{"id": "RFBEOjEwMjY5Njc1NTQ5ODlV", "waybill": "1026967554989U", "carrierId": "DPD", "createdAt": "2025-10-07T06:49:35.789Z", "lineItems": [{"id": "52c3f190-a228-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njc1NTUwODRV", "waybill": "1026967555084U", "carrierId": "DPD", "createdAt": "2025-10-07T06:49:35.959Z", "lineItems": [{"id": "52c3f190-a228-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7524	201f4571-a537-11f0-b89d-d9b346103272	\N	\N	2025-10-09 17:43:26.635	READY_FOR_PROCESSING	allegro-pl	87562472	Client:87562472	v1ioqro9xp+9eb63636@allegromail.pl	\N	Kaja Makuszewska	+48 667 426 587	Modrakowa 48 / 9	85-864	Bydgoszcz	PL	20ad0713-a537-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	\N	f	\N	2025-10-09 17:43:26.635	\N	2025-10-09 19:53:02.352246	ONLINE	f	[]	\N	0.00	\N	[]	f
7615	76ac5390-a41c-11f0-a40a-ffbafd460211	\N	\N	2025-10-08 08:02:09.335	READY_FOR_PROCESSING	allegro-pl	7120457	michacz4	eez79sg6ql+a5e0f5b1@allegromail.pl	\N	Michał Kupiński	+48 508 163 809	Kasztanowa 3	59-140	Chocianów	PL	d38629d8-a41c-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	832.99	PLN	siedzisko : fjord gafit	t	\N	2025-10-08 08:02:09.335	\N	2025-10-09 19:34:17.210194	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwOTU2MDc4NjVV", "waybill": "1027095607865U", "carrierId": "DPD", "createdAt": "2025-10-08T11:50:09Z", "lineItems": [{"id": "76a77190-a41c-11f0-a40a-ffbafd460211"}]}, {"id": "RFBEOjEwMjcwOTU2MDc5NDRV", "waybill": "1027095607944U", "carrierId": "DPD", "createdAt": "2025-10-08T11:50:09Z", "lineItems": [{"id": "76a77190-a41c-11f0-a40a-ffbafd460211"}]}]	\N	0.00	\N	[]	f
7616	2b10c010-a412-11f0-b871-03a75625f948	\N	\N	2025-10-08 06:44:07.079	READY_FOR_PROCESSING	allegro-pl	7935998	monikatn	4vwx90fz41+3e4dec582@allegromail.pl	\N	monika nowak	+48 667 168 344	ul.jana matejki 21	36-100	kolbuszowa	PL	2b2f1e31-a412-11f0-b9a1-9fd75769370f	PAID	AF	t	674.30	PLN	Allegro Kurier DPD	0.00	PLN	674.30	PLN	\N	t	\N	2025-10-08 06:44:07.079	\N	2025-10-09 19:34:18.70771	ONLINE	f	[{"id": "RFBEOjEwMjcxNDg0MDUzNTJV", "waybill": "1027148405352U", "carrierId": "DPD", "createdAt": "2025-10-09T07:37:21.098Z", "lineItems": [{"id": "2b052750-a412-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNDg0MDU0NDVV", "waybill": "1027148405445U", "carrierId": "DPD", "createdAt": "2025-10-09T07:37:21.289Z", "lineItems": [{"id": "2b052750-a412-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
12	ea829fd0-a283-11f0-aba2-b3553c261cc2	\N	\N	2025-10-06 07:13:42.085	READY_FOR_PROCESSING	allegro-pl	11107959	koloop	ml62fin7qr+15e1fac42@allegromail.pl	\N	Marta Kołakowska	+48 516 072 084	Jana Pawła II 23lok c2	05-077	Warszawa	PL	f307b823-a283-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	330.99	PLN	\N	t	\N	2025-10-06 07:13:42.085	\N	2025-10-06 20:34:52.071739	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
13	fe9dd160-a27e-11f0-a6cc-b3145592fdde	\N	\N	2025-10-06 06:41:34.2	READY_FOR_PROCESSING	allegro-pl	24131428	sylkle	1fh44rcylq+2561b7368@allegromail.pl	\N	Sylwia Kleniuk	+48 535 888 349	Robotnicza 20	45-052	Opole	PL	feda3eea-a27e-11f0-a417-fd831f6ae8ec	PAID	AF	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-06 06:41:34.2	\N	2025-10-06 20:34:52.478694	ONLINE	f	\N	\N	0.00	\N	\N	f
14	952bb881-a271-11f0-9468-2bd22967b382	\N	\N	2025-10-06 05:03:11.243	READY_FOR_PROCESSING	allegro-pl	21734126	bassmonster1	6ruy4zz282+682d82112@allegromail.pl	\N	Izabela Śliwińska	+48 722 176 142	Brzostków 43	37-500	Jarosław	PL	956b5a6c-a271-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Ekoskora pikowana czarna 	t	\N	2025-10-06 05:03:11.243	\N	2025-10-06 20:34:52.886558	ONLINE	f	\N	\N	0.00	\N	\N	f
7619	7ed27320-a3fd-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-08 04:16:19.786	READY_FOR_PROCESSING	allegro-pl	14105915	Maniazegar	vdzq002zam+36692e6b6@allegromail.pl	\N	Marzena Kuran	+48 697 202 044	Warynskiego 44 / 10	96-300	Żyrardów	PL	88fb01ee-a3fd-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	404.99	PLN	\N	f	\N	2025-10-08 04:16:19.786	\N	2025-10-09 19:34:23.811542	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7620	3bc5ddb0-a3d5-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 23:28:25.694	READY_FOR_PROCESSING	allegro-pl	71914437	Client:71914437	brjuba1p42+22e019d06@allegromail.pl	\N	Mateusz Grzyb	+48 601 903 199	Św. Wincentego 19 / 7	50-252	Wrocław	PL	3bff8bd3-a3d5-11f0-96eb-67f4404dbe40	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Th1 hugo czarny	t	\N	2025-10-07 23:28:25.694	\N	2025-10-09 19:34:25.56247	ONLINE	f	[]	\N	0.00	\N	[]	f
15	363671e0-a270-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-06 04:53:43.949	READY_FOR_PROCESSING	allegro-pl	35047482	Seki21695	8gigwp1ekg+7d3cf2551@allegromail.pl	\N	Łukasz Szkaradek	+48 570 457 313	Czecha 3 / 20	33-300	Nowy Sącz	PL	366fd1aa-a270-11f0-a284-071dd65bf45d	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	kolor siedziska- welur grafitowy WE3	t	\N	2025-10-06 04:53:43.949	\N	2025-10-06 20:34:53.299783	ONLINE	f	\N	\N	0.00	\N	\N	f
9	74ee70b0-a28c-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-06 08:15:15.723	READY_FOR_PROCESSING	allegro-pl	11928754	Just810	dk0m11lgy2+304bf82c0@allegromail.pl	\N	Justyna Łyczewska	+48 504 122 495	ul. Kasjopei 15/3	71-771	Szczecin	PL	77f150e0-a28c-11f0-ae11-e76c74c7cf77	PAID	AF	t	725.00	PLN	Allegro Kurier DPD	0.00	PLN	725.00	PLN	\N	t	\N	2025-10-06 08:15:15.723	\N	2025-10-06 20:34:50.851745	ONLINE	t	\N	\N	0.00	\N	\N	f
10	b5925ca0-a28a-11f0-abd8-f5344f24907b	\N	\N	2025-10-06 08:07:19.936	READY_FOR_PROCESSING	allegro-pl	87353891	Client:87353891	tbkovjlrgh+5e8bfc730@allegromail.pl	\N	Agnieszka Krysiak	+48 608 295 559	Armii Krajowej 56\\23	09-410	Płock	PL	b5d11396-a28a-11f0-a284-071dd65bf45d	PAID	AF	t	471.00	PLN	Allegro Kurier DPD	0.00	PLN	471.00	PLN	uchwyty czarne U1	t	\N	2025-10-06 08:07:19.936	\N	2025-10-06 20:34:51.264554	ONLINE	f	\N	\N	0.00	\N	\N	f
33	9f49fb00-a204-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 16:03:08.905	READY_FOR_PROCESSING	allegro-pl	41335273	Client:41335273	hp8kfi5mca+79a394f81@allegromail.pl	\N	Małgorzata Pietrzal	+48 695 145 653	Walecznych 8 / 19	09-410	Płock	PL	bd190df4-a204-11f0-91d4-7961b40d7b05	PAID	PAYU	t	278.00	PLN	Allegro Kurier DPD	0.00	PLN	278.00	PLN	\N	t	\N	2025-10-05 16:03:08.905	\N	2025-10-09 19:40:12.904683	ONLINE	f	[{"id": "RFBEOjEwMjY5NjkzNzE0MzFV", "waybill": "1026969371431U", "carrierId": "DPD", "createdAt": "2025-10-07T07:02:43.343Z", "lineItems": [{"id": "9f451900-a204-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
36	0dc59e40-a200-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 15:30:54.015	READY_FOR_PROCESSING	allegro-pl	12734940	csae	7g2ohrayar+2c6f9e18@allegromail.pl	\N	Anna Wistuba	+49 171 9078018	Zachodnia 7	55-010	Radwanice	PL	17ea0e2b-a200-11f0-96eb-67f4404dbe40	PAID	PAYU	t	842.99	PLN	Allegro Kurier DPD	14.99	PLN	842.99	PLN	\N	f	\N	2025-10-05 15:30:54.015	\N	2025-10-09 19:40:17.518733	ONLINE	f	[{"id": "RFBEOjEwMjY4NzM3MTAwMzlV", "waybill": "1026873710039U", "carrierId": "DPD", "createdAt": "2025-10-06T07:50:34.116Z", "lineItems": [{"id": "0dbe4b40-a200-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY4NzM3MTAyMzhV", "waybill": "1026873710238U", "carrierId": "DPD", "createdAt": "2025-10-06T07:50:34.336Z", "lineItems": [{"id": "0dbe4b40-a200-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
39	8900fcb0-a1f8-11f0-8865-a987ea6c1e01	\N	\N	2025-10-05 14:35:55.709	READY_FOR_PROCESSING	allegro-pl	5325388	BaRtEzZ16LK	sfll8qz28u+69fd1a8d2@allegromail.pl	\N	Krystian Kopiński	+48 83 356 03 13	Szafirowa 19 / 20	20-573	Lublin	PL	97fae9b6-a1f8-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	551.99	PLN	\N	f	\N	2025-10-05 14:35:55.709	\N	2025-10-09 19:40:22.039809	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY4NDI2NDUxMTNV", "waybill": "1026842645113U", "carrierId": "DPD", "createdAt": "2025-10-06T04:31:53Z", "lineItems": [{"id": "88f95b90-a1f8-11f0-8865-a987ea6c1e01"}]}, {"id": "RFBEOjEwMjY4NDI2NDUyMjFV", "waybill": "1026842645221U", "carrierId": "DPD", "createdAt": "2025-10-06T04:31:53Z", "lineItems": [{"id": "88f95b90-a1f8-11f0-8865-a987ea6c1e01"}]}]	\N	0.00	\N	[]	f
5	8d77a490-a2a4-11f0-8d49-a16d7ed74f8d	\N	\N	2025-10-06 11:09:26.075	READY_FOR_PROCESSING	allegro-pl	75893655	Client:75893655	fdj4i81w9p+4195ef356@allegromail.pl	\N	Marta Barys	+48 690 433 089	Mochnackiego 9/13 / 16	93-160	Łódź	PL	9d8dafa1-a2a4-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	541.20	PLN	Allegro Kurier DPD	0.00	PLN	541.20	PLN	TH3 - Tkanina Hugo Grafitowy\n\n	t	\N	2025-10-06 11:09:26.075	\N	2025-10-06 20:34:49.071642	ONLINE	f	\N	\N	0.00	\N	\N	f
40	caf7ce70-a1f6-11f0-9468-2bd22967b382	\N	\N	2025-10-05 14:29:01.752	READY_FOR_PROCESSING	allegro-pl	46424598	MarcjannaK	arkvlb82z8+7445400b4@allegromail.pl	\N	Marcjanna Kozicka	+48 798 292 906	Żarska Wieś 91	59-900	Zgorzelec	PL	9269177c-a1f7-11f0-a417-fd831f6ae8ec	PAID	P24	t	1668.00	PLN	Allegro Kurier DPD	0.00	PLN	1668.00	PLN	\N	t	\N	2025-10-05 14:29:01.752	\N	2025-10-09 19:40:23.4191	ONLINE	f	[{"id": "RFBEOjEwMjY5NzIzNTU0MjBV", "waybill": "1026972355420U", "carrierId": "DPD", "createdAt": "2025-10-07T07:23:12.775Z", "lineItems": [{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzIzNTU1MDlV", "waybill": "1026972355509U", "carrierId": "DPD", "createdAt": "2025-10-07T07:23:12.964Z", "lineItems": [{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzIzNTU2ODlV", "waybill": "1026972355689U", "carrierId": "DPD", "createdAt": "2025-10-07T07:23:13.165Z", "lineItems": [{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7621	bd085b30-a3cd-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-07 22:37:03.799	READY_FOR_PROCESSING	allegro-pl	19852095	calineczka_ania	t005n3nk91+214566759@allegromail.pl	\N	Anna Mitoraj-Broda	+48 504 980 955	Wieniawskiego 18	27-400	Ostrowiec Świętokrzyski	PL	c60bf166-a3cd-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	830.99	PLN	Proszę kolor wieszaków czarny H1 , kolor obicia czarny pikiowany EP2 . (ZAMOWILEM ROWNIEŻ TAKA SAMA SZAFKE W KOLORZE BIAŁYM, PROSZĘ O nierealizowanie tamtego zamówienia ponieważ była to pomyłka) pozdrawiam .	f	\N	2025-10-07 22:37:03.799	\N	2025-10-09 19:34:27.019116	CASH_ON_DELIVERY	t	[{"id": "RFBEOjEwMjcwNDYyNTczMzZV", "waybill": "1027046257336U", "carrierId": "DPD", "createdAt": "2025-10-08T05:21:20.568Z", "lineItems": [{"id": "bd041570-a3cd-11f0-bfbd-d3aacc6a2e00"}]}]	H. Wieniawskiego 18	0.00	\N	[]	f
3	05ff2210-a2a7-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 11:27:11.398	READY_FOR_PROCESSING	allegro-pl	9970384	Przemekpp5555	it5ppicacs+218fe3f24@allegromail.pl	\N	Przemysław Karpiński	+48 667 253 776	Pl. Konstytucji 12	78-500	Drawsko Pom.	PL	37916962-a2a7-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	56.99	PLN	Ekoskóra gładka:\nES1 - Eko skóra Czarny	f	\N	2025-10-06 11:27:11.398	\N	2025-10-06 20:34:48.36032	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
4	38d3bef0-a2a5-11f0-a6c9-036cfc044caf	\N	\N	2025-10-06 11:13:10.852	READY_FOR_PROCESSING	allegro-pl	5544044	bratka52	h1ant1z1sm+2c9e6030@allegromail.pl	\N	Beata Górska	+48 665 180 908	Kraszewskiego 45a / 199	15-025	Białystok	PL	3913392a-a2a5-11f0-a417-fd831f6ae8ec	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	F04	t	\N	2025-10-06 11:13:10.852	\N	2025-10-06 20:34:48.732294	ONLINE	f	\N	\N	0.00	\N	\N	f
7	59852450-a295-11f0-bee6-2fee815ffc9f	\N	\N	2025-10-06 09:18:28.596	READY_FOR_PROCESSING	allegro-pl	50539956	Client:50539956	xzdek9aiyu+52e09dae4@allegromail.pl	\N	Karolina Wałęga	+48 693 642 654	Iwanowice Dworskie, ul. Jurajska 27	32-095	Iwanowice	PL	5bfe3b37-a295-11f0-a417-fd831f6ae8ec	PAID	AF	t	229.00	PLN	Allegro Kurier DPD	0.00	PLN	229.00	PLN	\N	t	\N	2025-10-06 09:18:28.596	\N	2025-10-06 20:34:50.028838	ONLINE	t	\N	\N	0.00	\N	\N	f
8	d840e830-a293-11f0-997b-19b8e7655382	\N	\N	2025-10-06 09:10:41.791	READY_FOR_PROCESSING	allegro-pl	5082501	kroll77777	fxsxm0va3c+73e4c9c23@allegromail.pl	\N	Piotr Knop	+48 693 922 766	Łazowskiego 40 / 39	93-379	łódź	PL	f08474b0-a293-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-06 09:10:41.791	\N	2025-10-06 20:34:50.440623	ONLINE	t	\N	\N	0.00	\N	\N	f
6	5bd33960-a29d-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 10:17:07.15	READY_FOR_PROCESSING	allegro-pl	17040546	pawelbisewski	42vcsw41xu+769f258f0@allegromail.pl	\N	Paweł Bisewski	+48 502 604 416	Sikorskiego 4 m 22	95-070	Aleksandrów Łódzki	PL	5c174753-a29d-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	1807.60	PLN	Allegro Kurier DPD	0.00	PLN	1807.60	PLN	haki czarne, tkanina hugo czarna th1	t	\N	2025-10-06 10:17:07.15	\N	2025-10-06 20:34:49.624446	ONLINE	f	\N	\N	0.00	\N	\N	f
30	68ef7970-a20b-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 16:51:49.713	READY_FOR_PROCESSING	allegro-pl	9351032	Marti2808	xxa4uxxi68+23935c165@allegromail.pl	\N	Ewelina Martinowska	+48 667 202 822	Nowogrodzka 38	59-730	Nowogrodziec	PL	6912b99a-a20b-11f0-91d4-7961b40d7b05	PAID	P24	t	483.00	PLN	Allegro Kurier DPD	0.00	PLN	483.00	PLN	Kolor siedziska - ES1 - Eko skóra Czarny	t	\N	2025-10-05 16:51:49.713	\N	2025-10-09 19:40:08.266022	ONLINE	f	[{"id": "RFBEOjEwMjY5NjkyMDA1NzFV", "waybill": "1026969200571U", "carrierId": "DPD", "createdAt": "2025-10-07T07:01:40.004Z", "lineItems": [{"id": "68eb0ca0-a20b-11f0-b1e3-b7ce882fc700"}, {"id": "68eb0ca1-a20b-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
31	2aff7c30-a208-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 16:32:55.307	READY_FOR_PROCESSING	allegro-pl	108778565	Client:108778565	sbeo45d60s+58a5917d7@allegromail.pl	\N	Patrycja Olek	+48 791 510 689	Wajdy 10 / 13	40-175	Katowice	PL	c707f226-a208-11f0-ae11-e76c74c7cf77	PAID	P24	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	ES1- Eko skóra Czarny	t	\N	2025-10-05 16:32:55.307	\N	2025-10-09 19:40:09.875236	ONLINE	f	[{"id": "RFBEOjEwMjY4NjE3NjQ2NzJV", "waybill": "1026861764672U", "carrierId": "DPD", "createdAt": "2025-10-06T06:49:24.448Z", "lineItems": [{"id": "2af87750-a208-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY4NjE3NjQ3OTNV", "waybill": "1026861764793U", "carrierId": "DPD", "createdAt": "2025-10-06T06:49:24.640Z", "lineItems": [{"id": "2af87750-a208-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
43	d63f36f0-a1f2-11f0-b871-03a75625f948	\N	\N	2025-10-05 13:55:18.2	READY_FOR_PROCESSING	allegro-pl	60832280	Client:60832280	p4w41eeb35+343b49e75@allegromail.pl	\N	katarzyna Nowak	+48 730 896 213	Jabłoniowa 32a	62-090	ROGIEROWKO	PL	d6607aaf-a1f2-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-05 13:55:18.2	\N	2025-10-09 19:40:27.941967	ONLINE	f	[{"id": "RFBEOjEwMjY4NjIxMzkwMjRV", "waybill": "1026862139024U", "carrierId": "DPD", "createdAt": "2025-10-06T06:51:16.944Z", "lineItems": [{"id": "d63af130-a1f2-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
50	a209e250-a1d8-11f0-aa33-a79405b55c6d	\N	\N	2025-10-05 10:49:18.387	READY_FOR_PROCESSING	allegro-pl	10695381	Master1514	6up6oqwmo7+2eacaf502@allegromail.pl	\N	Wojciech Wojewódka	+48 781 448 945	Jawornik, 35	38-114	Niebylec	PL	efdad86e-a1d8-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	642.99	PLN	\N	t	\N	2025-10-05 10:49:18.387	\N	2025-10-09 19:40:37.130684	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzU3OTYyODhV", "waybill": "1026975796288U", "carrierId": "DPD", "createdAt": "2025-10-07T07:47:19Z", "lineItems": [{"id": "a2030480-a1d8-11f0-aa33-a79405b55c6d"}]}, {"id": "RFBEOjEwMjY5NzU3OTYzMDVV", "waybill": "1026975796305U", "carrierId": "DPD", "createdAt": "2025-10-07T07:47:19Z", "lineItems": [{"id": "a2030480-a1d8-11f0-aa33-a79405b55c6d"}]}]	\N	0.00	\N	[]	f
54	33875f10-a1ce-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 09:36:51.369	READY_FOR_PROCESSING	allegro-pl	12392705	cezaryoo7	o8mqtphsix+599812807@allegromail.pl	\N	cezary pyra	+48 608 795 880	Karszew 35	98-100	Łask	PL	be07c340-a1ce-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	425.19	PLN	\N	f	\N	2025-10-05 09:36:51.369	\N	2025-10-09 19:40:43.902051	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzY1Nzk4ODlV", "waybill": "1026976579889U", "carrierId": "DPD", "createdAt": "2025-10-07T07:53:12.962Z", "lineItems": [{"id": "337c3b80-a1ce-11f0-954f-f9092bddbf0d"}]}]	\N	0.00	\N	[]	f
55	4e91fa90-a1ce-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 09:34:01.576	READY_FOR_PROCESSING	allegro-pl	94463102	Client:94463102	bpxc0ab8qf+1c3c950c8@allegromail.pl	\N	Marta Olszewska	+48 518 494 007	Piotra Wysockiego 16A / 9	96-300	Żyrardów	PL	5f98ce13-a1ce-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	696.99	PLN	\N	t	\N	2025-10-05 09:34:01.576	\N	2025-10-09 19:40:45.426522	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NjU5MDEwMjBV", "waybill": "1026965901020U", "carrierId": "DPD", "createdAt": "2025-10-07T06:37:21.828Z", "lineItems": [{"id": "4e8d66b0-a1ce-11f0-954f-f9092bddbf0d"}]}, {"id": "RFBEOjEwMjY5NjU5MDExNjFV", "waybill": "1026965901161U", "carrierId": "DPD", "createdAt": "2025-10-07T06:37:22.035Z", "lineItems": [{"id": "4e8d66b0-a1ce-11f0-954f-f9092bddbf0d"}]}]	\N	0.00	\N	[]	f
57	65d8f0a0-a1c9-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 08:59:31.756	READY_FOR_PROCESSING	allegro-pl	105223917	wiktoria_1410	66izfjo1we+6d12298a6@allegromail.pl	\N	Wiktoria  Dominikowska	+48 722 059 645	Al. Chopina 16/38	87-800	Włocławek	PL	7936ac74-a1c9-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	734.99	PLN	\N	f	\N	2025-10-05 08:59:31.756	\N	2025-10-09 19:40:48.482457	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzY3NDQzMTNV", "waybill": "1026976744313U", "carrierId": "DPD", "createdAt": "2025-10-07T07:54:31.312Z", "lineItems": [{"id": "65d12870-a1c9-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY5NzY3NDQ0MjBV", "waybill": "1026976744420U", "carrierId": "DPD", "createdAt": "2025-10-07T07:54:31.559Z", "lineItems": [{"id": "65d12870-a1c9-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
59	7eb9b2d0-a1bf-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-05 07:47:22.551	READY_FOR_PROCESSING	allegro-pl	26164791	JANKO3103	nbhtkvfefk+175ca7414@allegromail.pl	\N	JANUSZ SZCZYGLAK	+48 660 669 616	Wygoda 5a	06-300	Przasnysz	PL	7ece2554-a1bf-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-05 07:47:22.551	\N	2025-10-09 19:40:51.486052	ONLINE	f	[{"id": "RFBEOjEwMjY4NjA0MTUyNjRV", "waybill": "1026860415264U", "carrierId": "DPD", "createdAt": "2025-10-06T06:42:27.804Z", "lineItems": [{"id": "7eb56d10-a1bf-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
62	00cde260-a16f-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 22:11:46.229	READY_FOR_PROCESSING	allegro-pl	22912167	wiewiora167	a3a0s7noco+3143deac4@allegromail.pl	\N	Sylwia Ferenz	+48 668 667 749	Ul. Anny Walentynowicz  5 /6	58-370	Boguszow-Gorce	PL	0106307b-a16f-11f0-ae11-e76c74c7cf77	PAID	AF	t	434.90	PLN	Allegro Kurier DPD	0.00	PLN	434.90	PLN	\N	t	\N	2025-10-04 22:11:46.229	\N	2025-10-09 19:40:56.295878	ONLINE	f	[{"id": "RFBEOjEwMjY4NDMzMDI4ODNV", "waybill": "1026843302883U", "carrierId": "DPD", "createdAt": "2025-10-06T04:40:26.428Z", "lineItems": [{"id": "00c72ba0-a16f-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7622	3ccf7490-a3cc-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 22:27:10.887	READY_FOR_PROCESSING	allegro-pl	19852095	calineczka_ania	t005n3nk91+6ac2a7e77@allegromail.pl	\N	Anna Mitoraj-Broda	+48 504 980 955	Wieniawskiego 18	27-400	Ostrowiec Świętokrzyski	PL	6d9173cb-a3cc-11f0-bb32-51209e96d6bb	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	830.99	PLN	Kolor wieszaków czarny h1 , kolor obicia czarna pikowana skórą EP2	f	\N	2025-10-07 22:27:10.887	\N	2025-10-09 19:34:28.488246	CASH_ON_DELIVERY	t	[]	H. Wieniawskiego 18	0.00	\N	[]	f
65	6a9bb600-a15f-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-04 20:21:06.77	READY_FOR_PROCESSING	allegro-pl	94463102	Client:94463102	bpxc0ab8qf+1d648aaf0@allegromail.pl	\N	Marta Olszewska	+48 518 494 007	Piotra Wysockiego 16A / 9	96-300	Żyrardów	PL	a4df2e59-a15f-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	389.99	PLN	\N	t	\N	2025-10-04 20:21:06.77	\N	2025-10-09 19:41:00.64849	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
67	f041b5b0-a14c-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 18:10:02.239	READY_FOR_PROCESSING	allegro-pl	17900738	Aneta87-Sylwek	e9ydxg9tng+69d3dd938@allegromail.pl	\N	Aneta Bledziewska	+48 727 925 447	Północna 39	87-300	Brodnica	PL	f07fd100-a14c-11f0-ae11-e76c74c7cf77	PAID	AF	t	67.00	PLN	Allegro Kurier DPD	0.00	PLN	67.00	PLN	czarny welur 	t	\N	2025-10-04 18:10:02.239	\N	2025-10-09 19:41:03.693467	ONLINE	f	[{"id": "RFBEOjEwMjY4NDU5ODQ1NzVV", "waybill": "1026845984575U", "carrierId": "DPD", "createdAt": "2025-10-06T05:11:36.439Z", "lineItems": [{"id": "f03afef0-a14c-11f0-a6cc-b3145592fdde"}, {"id": "f03afef1-a14c-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
68	28710f90-a14c-11f0-9468-2bd22967b382	\N	\N	2025-10-04 18:07:14.254	READY_FOR_PROCESSING	allegro-pl	41757376	MarGaj998	cb4zprzp20+6f270e4f3@allegromail.pl	\N	Marcin Gajewski	+48 733 800 965	Mokruska 23	42-440	Giebło	PL	bbba2465-a14c-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Sonoma szerokość 60cm \nKolor obicia Hugo czarny TH1	t	\N	2025-10-04 18:07:14.254	\N	2025-10-09 19:41:05.266723	ONLINE	f	[{"id": "RFBEOjEwMjY4NDYwODgzODlV", "waybill": "1026846088389U", "carrierId": "DPD", "createdAt": "2025-10-06T05:12:38.173Z", "lineItems": [{"id": "286a31c0-a14c-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
75	b661cf00-a134-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 15:19:37.217	READY_FOR_PROCESSING	allegro-pl	88024175	Client:88024175	9n8zyvpofi+168aba7b8@allegromail.pl	\N	Grażyna Słotwińska	+48 605 259 325	Jelenica, 75	43-450	Ustroń	PL	b68201df-a134-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1286.40	PLN	Allegro Kurier DPD	0.00	PLN	1286.40	PLN	SIEDZISKO: F02\nWIESZAK:CHROM H2	t	\N	2025-10-04 15:19:37.217	\N	2025-10-09 19:41:15.60664	ONLINE	f	[{"id": "RFBEOjEwMjY5ODQ4ODU2NTBV", "waybill": "1026984885650U", "carrierId": "DPD", "createdAt": "2025-10-07T08:54:01.180Z", "lineItems": [{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c"}]}, {"id": "RFBEOjEwMjY5ODQ4ODU3OTFV", "waybill": "1026984885791U", "carrierId": "DPD", "createdAt": "2025-10-07T08:54:01.460Z", "lineItems": [{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c"}]}, {"id": "RFBEOjEwMjY5ODQ4ODU4NTFV", "waybill": "1026984885851U", "carrierId": "DPD", "createdAt": "2025-10-07T08:54:01.735Z", "lineItems": [{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c"}]}]	\N	0.00	\N	[]	f
77	985df1b0-a129-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-04 13:55:18.781	READY_FOR_PROCESSING	allegro-pl	16524194	anecia19915	nhwmrfuouo+6f52ec5c5@allegromail.pl	\N	Aneta Bogucka	+48 504 717 308	Piotra Skargi 5BA	05-420	Józefów	PL	987f83f8-a129-11f0-b9a1-9fd75769370f	PAID	P24	t	570.99	PLN	Allegro Kurier DPD	14.99	PLN	570.99	PLN	\N	f	\N	2025-10-04 13:55:18.781	\N	2025-10-09 19:41:18.581203	ONLINE	f	[{"id": "RFBEOjEwMjY5NjY5Nzk0OTlV", "waybill": "1026966979499U", "carrierId": "DPD", "createdAt": "2025-10-07T06:45:16.653Z", "lineItems": [{"id": "985984e0-a129-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
78	962c7da0-a127-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-04 13:41:20.432	READY_FOR_PROCESSING	allegro-pl	44131948	Client:44131948	wci58v6808+29698b440@allegromail.pl	\N	Anna Andrzejewska	+48 791 934 305	Kolonia Leśna 6	66-235	Torzym	PL	a17e9830-a127-11f0-91d4-7961b40d7b05	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-04 13:41:20.432	\N	2025-10-09 19:41:20.077393	ONLINE	f	[{"id": "RFBEOjEwMjY5ODUwODgyMTJV", "waybill": "1026985088212U", "carrierId": "DPD", "createdAt": "2025-10-07T08:55:36.230Z", "lineItems": [{"id": "96277490-a127-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
82	a1606580-a120-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 12:51:51.066	READY_FOR_PROCESSING	allegro-pl	100955580	Client:100955580	2inxpnp9b5+7c6f6a699@allegromail.pl	\N	Daniel Stelmaszek	+48 730 869 099	Jana Pawła II 4B / 20	59-700	Bolesławiec	PL	b41bee46-a120-11f0-96eb-67f4404dbe40	PAID	AF	t	523.00	PLN	Allegro Kurier DPD	0.00	PLN	523.00	PLN	\N	t	\N	2025-10-04 12:51:51.066	\N	2025-10-06 19:16:53.328786	ONLINE	f	\N	\N	0.00	\N	\N	f
80	66a16aa0-a122-11f0-baf0-af7ea74e3d0e	\N	\N	2025-10-04 13:03:06.946	READY_FOR_PROCESSING	allegro-pl	16509717	rzanetka88	9f35o43p1l+7ab5c19e5@allegromail.pl	\N	Żaneta Luber - Kleta	+48 794 247 180	Osiedle Paderewskiego 8/2/16	32-626	Jawiszowice	PL	66dd3c0d-a122-11f0-a284-071dd65bf45d	PAID	AF	t	67.00	PLN	Allegro Kurier DPD	0.00	PLN	67.00	PLN	kolor CZARNY WELUR 	t	\N	2025-10-04 13:03:06.946	\N	2025-10-09 19:41:22.997025	ONLINE	f	[{"id": "RFBEOjEwMjY4NDY3OTUyNzJV", "waybill": "1026846795272U", "carrierId": "DPD", "createdAt": "2025-10-06T05:18:17.213Z", "lineItems": [{"id": "6699c980-a122-11f0-baf0-af7ea74e3d0e"}, {"id": "6699c981-a122-11f0-baf0-af7ea74e3d0e"}]}]	\N	0.00	\N	[]	f
83	37e72b40-a114-11f0-9e86-bf15ec8cf3e6	\N	\N	2025-10-04 11:24:00.243	READY_FOR_PROCESSING	allegro-pl	75742473	Client:75742473	46wnp65uxq+6b87203f8@allegromail.pl	\N	Joanna Cyrańska	+48 662 983 607	Ruszelczyce 21	37-755	Krzywcza	PL	6d4c9ab8-a114-11f0-bb32-51209e96d6bb	PAID	P24	t	292.99	PLN	Allegro Kurier DPD	14.99	PLN	292.99	PLN	\N	f	\N	2025-10-04 11:24:00.243	\N	2025-10-06 19:00:55.116661	ONLINE	f	\N	\N	0.00	\N	\N	f
7623	bb165360-a3c6-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-07 21:44:17.179	READY_FOR_PROCESSING	allegro-pl	4814806	mmax88	cqyhifo1t4+67e98d1c3@allegromail.pl	\N	Michał Wańczyk	+48 796 208 795	Buchowieckiego 30	32-300	Olkusz	PL	bb4c7f75-a3c6-11f0-ae11-e76c74c7cf77	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-07 21:44:17.179	\N	2025-10-09 19:34:29.944915	ONLINE	f	[]	\N	0.00	\N	[]	f
49	c9711b50-a1de-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 11:35:34.857	READY_FOR_PROCESSING	allegro-pl	1995009	gadzeta8	od4cqij8os+601b41d28@allegromail.pl	\N	Monika Szczepańska	+48 792 173 334	21 Stycznia 27/1	14-100	Ostróda	PL	c98feeee-a1de-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-10-05 11:35:34.857	\N	2025-10-09 19:40:35.667074	ONLINE	f	[{"id": "RFBEOjEwMjY5NjU3MDc1MjVV", "waybill": "1026965707525U", "carrierId": "DPD", "createdAt": "2025-10-07T06:35:54.679Z", "lineItems": [{"id": "c96cfca0-a1de-11f0-954f-f9092bddbf0d"}]}]	\N	0.00	\N	[]	f
64	8eab3fe0-a162-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 20:42:54.955	READY_FOR_PROCESSING	allegro-pl	5179759	kris1126	bug8hcuum9+2843a91c8@allegromail.pl	\N	Krzysztof Gogolewski	+48 504 247 880	Paryska 10	06-400	Ciechanów	PL	8efe69ee-a162-11f0-ae11-e76c74c7cf77	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	kolor grafit 	t	\N	2025-10-04 20:42:54.955	\N	2025-10-09 19:40:59.247977	ONLINE	f	[{"id": "RFBEOjEwMjY5ODA2MzI5NzRV", "waybill": "1026980632974U", "carrierId": "DPD", "createdAt": "2025-10-07T08:23:17.656Z", "lineItems": [{"id": "8ea377b0-a162-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
86	42cb5c90-a0f9-11f0-baf0-af7ea74e3d0e	\N	\N	2025-10-04 08:09:56.345	READY_FOR_PROCESSING	allegro-pl	44735813	Client:44735813	qz6u7426gc+3909bdc41@allegromail.pl	\N	Karolina Majewska	+48 601 094 628	Rogówko 10 B	87-162	Lubicz Górny	PL	5cadcbfc-a0f9-11f0-baf9-a33944a1116d	PAID	P24	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	tkanina F04	t	\N	2025-10-04 08:09:56.345	\N	2025-10-06 18:16:40.471163	ONLINE	f	\N	\N	0.00	\N	\N	f
100	03bcd260-a066-11f0-aafc-c30e0e10a738	\N	\N	2025-10-04 11:48:41.835	FILLED_IN	allegro-pl	17842068	malarz141	i254majzoh+51a59e9f8@allegromail.pl	\N	Maciej Lewandowski	+48 695 469 309	\N	\N	\N	\N	080970df-a066-11f0-b9a1-9fd75769370f	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Dzień dobry jako wykończenie poproszę welur jasno szary WE2	t	\N	2025-10-04 11:48:41.835	\N	2025-10-06 13:12:02.680534	ONLINE	f	\N	\N	0.00	\N	\N	f
70	2fb0e140-a142-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 16:50:53.739	READY_FOR_PROCESSING	allegro-pl	14645126	liponoga_anna	yf9yhaxe96+490c28608@allegromail.pl	\N	Anna Liponoga	+48 535 669 933	ul. gen. Ludomiła Rayskiego 7 m 70	01-307	Warszawa	PL	40d6ae91-a142-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	410.19	PLN	\N	t	\N	2025-10-04 16:50:53.739	\N	2025-10-09 19:41:08.213471	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5ODIwMjk1OTdV", "waybill": "1026982029597U", "carrierId": "DPD", "createdAt": "2025-10-07T08:33:43.390Z", "lineItems": [{"id": "2faa5190-a142-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
90	45695940-a0a7-11f0-a6cc-b3145592fdde	\N	\N	2025-10-03 22:22:18.322	READY_FOR_PROCESSING	allegro-pl	4133275	mardc	94yhz94xt2+5938469d1@allegromail.pl	\N	Mariusz Żelezik	+48 511 123 067	Ogrodowa 19	08-130	Kotuń	PL	45b52ffa-a0a7-11f0-a417-fd831f6ae8ec	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	TH3	t	\N	2025-10-03 22:22:18.322	\N	2025-10-09 19:52:21.909094	ONLINE	f	[{"id": "RFBEOjEwMjY5ODYyMDI5NjdV", "waybill": "1026986202967U", "carrierId": "DPD", "createdAt": "2025-10-07T09:03:44.388Z", "lineItems": [{"id": "45619110-a0a7-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
94	db0dc990-a07f-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-03 17:40:35.438	READY_FOR_PROCESSING	allegro-pl	38831160	Client:38831160	xkpua6wm6c+c7953d90@allegromail.pl	\N	Sławomir Nowakowski	+48 600 925 902	Rębkowska 14 m 4	04-375	Warszawa	PL	db38ab1b-a07f-11f0-bb32-51209e96d6bb	PAID	P24	t	366.99	PLN	Allegro Kurier DPD	14.99	PLN	366.99	PLN	\N	f	\N	2025-10-03 17:40:35.438	\N	2025-10-09 19:52:28.20184	ONLINE	f	[{"id": "RFBEOjEwMjY4OTczODcwMzJV", "waybill": "1026897387032U", "carrierId": "DPD", "createdAt": "2025-10-06T10:03:33.844Z", "lineItems": [{"id": "db036950-a07f-11f0-9a42-bb8e9ffafe52"}]}]	\N	0.00	\N	[]	f
97	2f557250-a067-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-03 14:45:57.784	READY_FOR_PROCESSING	allegro-pl	101281265	Client:101281265	9boi2d22hu+718d767e7@allegromail.pl	\N	JADWIGA WOŹNY	+48 608 359 150	Pogwizdowska 170	35-212	RZESZÓW	PL	34d141fe-a067-11f0-96eb-67f4404dbe40	PAID	P24	t	793.10	PLN	Allegro Kurier DPD	0.00	PLN	793.10	PLN	Welur Grafitowy ( WE3)	t	\N	2025-10-03 14:45:57.784	\N	2025-10-09 19:52:32.634675	ONLINE	f	[{"id": "RFBEOjEwMjY4OTA3OTI0NjNV", "waybill": "1026890792463U", "carrierId": "DPD", "createdAt": "2025-10-06T09:24:21.489Z", "lineItems": [{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4OTA3OTI1MDZV", "waybill": "1026890792506U", "carrierId": "DPD", "createdAt": "2025-10-06T09:24:21.776Z", "lineItems": [{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7624	877577c0-a3c6-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-07 21:42:54.697	READY_FOR_PROCESSING	allegro-pl	4814806	mmax88	cqyhifo1t4+7f6ce6bd5@allegromail.pl	\N	Michał Wańczyk	+48 796 208 795	Buchowieckiego 30	32-300	Olkusz	PL	87b344c6-a3c6-11f0-bb32-51209e96d6bb	PAID	AF	t	99.00	PLN	Allegro Kurier DPD	0.00	PLN	99.00	PLN	\N	t	\N	2025-10-07 21:42:54.697	\N	2025-10-09 19:34:31.511017	ONLINE	f	[]	\N	0.00	\N	[]	f
63	0f4702d1-a16b-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-04 21:43:15.138	READY_FOR_PROCESSING	allegro-pl	24395723	marcindab13	r9zahk4pdo+7a5ce3963@allegromail.pl	\N	Marcin Dąbrowski	+48 511 723 992	Dobropole Gryfińskie 10	74-106	Dobropole Gryfinskie gm. Stare Czarnowo	PL	0fb64015-a16b-11f0-ae11-e76c74c7cf77	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-04 21:43:15.138	\N	2025-10-09 19:40:57.767472	ONLINE	f	[{"id": "RFBEOjEwMjY5ODAzMjAwNDJV", "waybill": "1026980320042U", "carrierId": "DPD", "createdAt": "2025-10-07T08:20:59.860Z", "lineItems": [{"id": "0f3d3ed1-a16b-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
87	68bf4590-a0f6-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 07:49:27.948	READY_FOR_PROCESSING	allegro-pl	34512889	Client:34512889	c5kbmeetq1+3e00f0471@allegromail.pl	\N	Monika Hirsz	+48 731 915 193	Rumska 18	81-198	Dębogórze	PL	68e2facc-a0f6-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Dzień dobry, proszę o obicie w kolorze welur jasno szary (we2). Pozdrawiam Monika Hirsz	t	\N	2025-10-04 07:49:27.948	\N	2025-10-06 17:22:43.295573	ONLINE	f	\N	\N	0.00	\N	\N	f
88	e0e984b0-a0f4-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 07:38:53.772	READY_FOR_PROCESSING	allegro-pl	13508479	squeezee	8bag2081xt+71c1edfa5@allegromail.pl	\N	Klaudia Kamińska	+48 510 234 632	JÓZEFA KONRADA KORZENIOWSKIEGO 52	83-000	Pruszcz Gdański	PL	e1087ed4-a0f4-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	521.00	PLN	Allegro Kurier DPD	0.00	PLN	521.00	PLN	\N	t	\N	2025-10-04 07:38:53.772	\N	2025-10-06 17:22:43.502874	ONLINE	f	\N	\N	0.00	\N	\N	f
89	2fefe050-a0e5-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-04 05:45:23.525	READY_FOR_PROCESSING	allegro-pl	33957378	Client:33957378	x6swvad8in+70620eaa4@allegromail.pl	\N	iwona komarnicka	+48 660 382 483	Podwale 14 / 2	47-400	Racibórz	PL	48a47e2b-a0e5-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	447.99	PLN	TKANINA F04	t	\N	2025-10-04 05:45:23.525	\N	2025-10-06 17:22:43.709715	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
95	1161a220-a07e-11f0-a6cc-b3145592fdde	\N	\N	2025-10-03 17:27:48.186	READY_FOR_PROCESSING	allegro-pl	4159023	juniorek50	m7s6lbrziw+14a6270f6@allegromail.pl	\N	Wojtek Klawitter	+48 661 950 674	Mozarta 3 / 418	02-736	Warszawa	PL	119cd74d-a07e-11f0-a417-fd831f6ae8ec	PAID	P24	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Materiał f04	t	\N	2025-10-03 17:27:48.186	\N	2025-10-09 19:52:29.679006	ONLINE	f	[{"id": "RFBEOjEwMjY4OTc2NDk5NDhV", "waybill": "1026897649948U", "carrierId": "DPD", "createdAt": "2025-10-06T10:05:11.444Z", "lineItems": [{"id": "115a0100-a07e-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
99	49190450-a066-11f0-b871-03a75625f948	\N	\N	2025-10-03 14:37:12.503	READY_FOR_PROCESSING	allegro-pl	17842068	malarz141	i254majzoh+39cc9c322@allegromail.pl	\N	Maciej Lewandowski	+48 695 469 309	14-200 Iława ul. Grunwaldzka 3a / 8	14-200	Iława	PL	4c26e118-a066-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	poproszę wykończenie welur  jasnoszary WE 2	t	\N	2025-10-03 14:37:12.503	\N	2025-10-09 19:52:35.935596	ONLINE	t	[{"id": "RFBEOjEwMjY4NDc1NDgxMTdV", "waybill": "1026847548117U", "carrierId": "DPD", "createdAt": "2025-10-06T05:24:22.124Z", "lineItems": [{"id": "49144960-a066-11f0-b871-03a75625f948"}]}]	grunwaldzka 3a	0.00	\N	[]	f
85	d0b6e280-a0fa-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-04 08:21:50.98	READY_FOR_PROCESSING	allegro-pl	74675843	Client:74675843	ax4pd47iq2+5d420f6a2@allegromail.pl	\N	Agnieszka Thakkar	+48 695 855 675	NOWODWORSKA 27 / 8	16-315	Lipsk	PL	f76f2677-a0fa-11f0-b9a1-9fd75769370f	PAID	AF	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	kolor siedziska Hugo Brązowy 	t	\N	2025-10-04 08:21:50.98	\N	2025-10-06 18:44:05.727554	ONLINE	f	\N	\N	0.00	\N	\N	f
7605	8eddd0e0-a43c-11f0-96d3-f7121b08a32c	\N	\N	2025-10-08 11:47:39.158	READY_FOR_PROCESSING	allegro-pl	47096767	Client:47096767	tqqn3cbzsd+6f4d18905@allegromail.pl	\N	Marcin Kleibert	+48 661 733 999	Ryżowa 66 / 32	02-495	Warszawa	PL	8efe519c-a43c-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-08 11:47:39.158	\N	2025-10-09 19:34:01.533573	ONLINE	f	[{"id": "RFBEOjEwMjcxMzExNjY4NTZV", "waybill": "1027131166856U", "carrierId": "DPD", "createdAt": "2025-10-09T05:05:54.663Z", "lineItems": [{"id": "8ed915f0-a43c-11f0-96d3-f7121b08a32c"}]}]	\N	0.00	\N	[]	f
7629	a1d33ad0-a3ad-11f0-a3bc-ef5c37833579	\N	\N	2025-10-07 18:49:42.091	READY_FOR_PROCESSING	allegro-pl	4507545	marcus5606	zlybo7xk7y+7f7e1d309@allegromail.pl	\N	Sławomir Telepski	+48 504 616 017	Grażyny 17/8	20-605	Lublin	PL	c19b113f-a3ad-11f0-ae11-e76c74c7cf77	PAID	P24	t	1669.00	PLN	Allegro Kurier DPD	0.00	PLN	1669.00	PLN	Tkanina na obicia F03 Fjord Grafit	t	\N	2025-10-07 18:49:42.091	\N	2025-10-09 19:34:39.487081	ONLINE	f	[]	\N	0.00	\N	[]	f
938	b5ec64e0-a2c9-11f0-abd8-f5344f24907b	\N	\N	2025-10-06 15:37:33.084	READY_FOR_PROCESSING	allegro-pl	55411729	Client:55411729	70kav6edsc+1a43852f4@allegromail.pl	\N	Michał Dubowski	+48 515 000 143	Włodarzewska 57D / 23	02-384	Warszawa	PL	b62c2d05-a2c9-11f0-a284-071dd65bf45d	PAID	P24	t	1705.00	PLN	Allegro Kurier DPD	0.00	PLN	1705.00	PLN	Zestaw x30x202, dąb wotan, hak H1 (czarny), kolor siedziska WE1 (welur czarny)	t	\N	2025-10-06 15:37:33.084	\N	2025-10-06 20:34:45.860476	ONLINE	f	\N	\N	0.00	\N	\N	f
7550	63e21820-a486-11f0-b989-75c7faccd1ca	\N	\N	2025-10-08 20:37:47.278	READY_FOR_PROCESSING	allegro-pl	50460369	Client:50460369	b31vmrvifd+9d252b55@allegromail.pl	\N	Boena Lipka	+48 696 070 443	Bolesawice 55/6	58-140	Jaworzyna l	PL	640cab39-a486-11f0-a284-071dd65bf45d	PAID	P24	t	1750.10	PLN	Allegro Kurier DPD	0.00	PLN	1750.10	PLN	\N	t	\N	2025-10-08 20:37:47.278	\N	2025-10-09 19:33:39.841229	ONLINE	f	[{"id": "RFBEOjEwMjcxNzM4ODQ0OTlV", "waybill": "1027173884499U", "carrierId": "DPD", "createdAt": "2025-10-09T11:00:13Z", "lineItems": [{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca"}]}, {"id": "RFBEOjEwMjcxNzM4ODQ1NzhV", "waybill": "1027173884578U", "carrierId": "DPD", "createdAt": "2025-10-09T11:00:13Z", "lineItems": [{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca"}]}, {"id": "RFBEOjEwMjcxNzM4ODQ2OThV", "waybill": "1027173884698U", "carrierId": "DPD", "createdAt": "2025-10-09T11:00:13.195Z", "lineItems": [{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca"}]}]	\N	0.00	\N	[]	f
7601	cad06af0-a454-11f0-a471-6bb0586de370	\N	\N	2025-10-08 14:41:41.045	READY_FOR_PROCESSING	allegro-pl	7630309	elizaj3	wphnxh2fdn+dc2027f5@allegromail.pl	\N	Eliza Jaworska	+48 728 823 629	Kowali 73	43-430	Skoczów	PL	cb0620fb-a454-11f0-96eb-67f4404dbe40	PAID	AF	t	532.60	PLN	Allegro Kurier DPD	0.00	PLN	532.60	PLN	uchwyty U1 czarne poproszę 	t	\N	2025-10-08 14:41:41.045	\N	2025-10-09 19:33:55.297684	ONLINE	f	[]	\N	0.00	\N	[]	f
7602	71cfc9a0-a44f-11f0-a4f0-7ba876f09f6f	\N	\N	2025-10-08 14:03:12.954	READY_FOR_PROCESSING	allegro-pl	4505799	smolki_	ys90wdkqs4+12c87bb55@allegromail.pl	Debal Development Smoła Paweł	Paweł Smoła	+48 792 801 756	29 Listopada 56j	32-500	Chrzanów	PL	71f182c6-a44f-11f0-b9a1-9fd75769370f	PAID	PAYU	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	Kolor siedziska WE3 - Welur Grafitowy	t	\N	2025-10-08 14:03:12.954	\N	2025-10-09 19:33:56.822981	ONLINE	f	[{"id": "RFBEOjEwMjcxMzEwODUyNDhV", "waybill": "1027131085248U", "carrierId": "DPD", "createdAt": "2025-10-09T05:04:33Z", "lineItems": [{"id": "71c4a610-a44f-11f0-a4f0-7ba876f09f6f"}]}]	\N	0.00	\N	[]	f
7603	3b69b380-a44f-11f0-88a6-1f93f938b7b3	\N	\N	2025-10-08 14:01:43.386	READY_FOR_PROCESSING	allegro-pl	15508170	stenek30	qf6fuuxgn1+38b719256@allegromail.pl	\N	KRZYSZTOFA STENKA	+48 694 407 206	Miejscowość Nowotna 8m2	82-103	Stegna	PL	3ba499c8-a44f-11f0-ae11-e76c74c7cf77	PAID	P24	t	636.00	PLN	Allegro Kurier DPD	0.00	PLN	636.00	PLN	Uchwyty poproszę chrom	t	\N	2025-10-08 14:01:43.386	\N	2025-10-09 19:33:58.363732	ONLINE	f	[]	\N	0.00	\N	[]	f
638	2472fa10-a2c4-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-06 14:54:48.151	READY_FOR_PROCESSING	allegro-pl	40906215	Wielki_Masta	qnldsuh9it+388a22bf5@allegromail.pl	\N	jacek szarach	+48 790 293 648	Witosa 1c / 10	67-100	Nowa Sól	PL	26ee8245-a2c4-11f0-ae11-e76c74c7cf77	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Poproszę o obicie w kolorze czarny welur. 	t	\N	2025-10-06 14:54:48.151	\N	2025-10-06 20:34:46.315283	ONLINE	f	\N	\N	0.00	\N	\N	f
639	e783f970-a2bd-11f0-b024-2112831760cb	\N	\N	2025-10-06 14:09:52.917	READY_FOR_PROCESSING	allegro-pl	27213466	loginzuberek	hgy8wl4255+3750bfe38@allegromail.pl	\N	Katarzyna  Szymańska	+48 506 344 729	Ul. Wschodnia 80	21-302	Kąkolewnica	PL	f6aae9f1-a2bd-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1283.00	PLN	Allegro Kurier DPD	0.00	PLN	1283.00	PLN	witam. poproszę welur grafitowy we3 oraz haki czarne 	t	\N	2025-10-06 14:09:52.917	\N	2025-10-06 20:34:46.71877	ONLINE	t	\N	\N	0.00	\N	\N	f
1	989a5e50-a2b1-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-06 12:42:07.787	READY_FOR_PROCESSING	allegro-pl	11698857	rafol91_HKS	6uohpxirqu+5a619d205@allegromail.pl	\N	Rafał Flak	+48 607 970 259	Kędzierzyńska 17c/Budynek G2	41-902	Bytom	PL	98bd4fef-a2b1-11f0-baf9-a33944a1116d	PAID	PAYU	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-10-06 12:42:07.787	\N	2025-10-06 20:34:47.538854	ONLINE	f	\N	\N	0.00	\N	\N	f
2	3f589880-a2b0-11f0-9468-2bd22967b382	\N	\N	2025-10-06 12:33:25.259	READY_FOR_PROCESSING	allegro-pl	67724201	Client:67724201	eozfvqkpi4+2050d18f9@allegromail.pl	\N	Jan Panek	+48 669 421 089	Drzonków-świerkowa 4	66-004	Zielona Góra	PL	4ec9632f-a2b0-11f0-a417-fd831f6ae8ec	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	tapicerka welurowa WE4	t	\N	2025-10-06 12:33:25.259	\N	2025-10-06 20:34:47.944898	ONLINE	t	\N	\N	0.00	\N	\N	f
7604	25b7bdb0-a446-11f0-9322-81ad33e97c6b	\N	\N	2025-10-08 12:56:49.483	READY_FOR_PROCESSING	allegro-pl	47342434	Client:47342434	nee8s98jgc+6887576e8@allegromail.pl	\N	Aleksandra Graca	+48 512 319 918	Pańków 3	22-604	Tarnawatka	PL	25d02822-a446-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-08 12:56:49.483	\N	2025-10-09 19:33:59.964151	ONLINE	f	[{"id": "RFBEOjEwMjcxMzExMjY5NDBV", "waybill": "1027131126940U", "carrierId": "DPD", "createdAt": "2025-10-09T05:05:10.858Z", "lineItems": [{"id": "25b23f70-a446-11f0-9322-81ad33e97c6b"}]}]	\N	0.00	\N	[]	f
26	1ece4030-a21d-11f0-8c5e-eb0a288ebc91	\N	\N	2025-10-05 19:06:53.012	READY_FOR_PROCESSING	allegro-pl	6011973	Kamil-gr	apfqwr32jc+37c66574@allegromail.pl	\N	Kamil Grygierzec	+48 667 089 713	Racula-St.Wyspiańskiego 3/2	66-004	Zielona Góra	PL	1ef8850c-a21d-11f0-baf9-a33944a1116d	PAID	P24	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	kolor: dąb sonoma	t	\N	2025-10-05 19:06:53.012	\N	2025-10-09 19:40:01.827597	ONLINE	f	[{"id": "RFBEOjEwMjY5Njg3MDMwNjZV", "waybill": "1026968703066U", "carrierId": "DPD", "createdAt": "2025-10-07T06:58:03.841Z", "lineItems": [{"id": "1ec95e30-a21d-11f0-8c5e-eb0a288ebc91"}]}]	\N	0.00	\N	[]	f
7617	8fee01d0-a40f-11f0-b871-03a75625f948	\N	\N	2025-10-08 06:26:37.855	READY_FOR_PROCESSING	allegro-pl	21868358	sylwia4258	aqxzyoslha+558841238@allegromail.pl	\N	Sylwia Rejman	+48 607 676 799	T. Kościuszki107	66-016	Nietków	PL	9010a585-a40f-11f0-91d4-7961b40d7b05	PAID	AF	t	1887.00	PLN	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	wieszaki Czernej a kolor obicia welur jasno szart	t	\N	2025-10-08 06:26:37.855	\N	2025-10-09 19:34:20.228418	ONLINE	f	[{"id": "RFBEOjEwMjcxNjM1MjMzMzFV", "waybill": "1027163523331U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:45.530Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNjM1MjM0MzRV", "waybill": "1027163523434U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:45.784Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNjM1MjM1NDdV", "waybill": "1027163523547U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:46.054Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNjM1MjM2NTVV", "waybill": "1027163523655U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:46.270Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7618	4b642d51-a40a-11f0-a6cc-b3145592fdde	\N	\N	2025-10-08 05:51:28.272	READY_FOR_PROCESSING	allegro-pl	102185335	Client:102185335	2sdgnq87yd+3a6a03da8@allegromail.pl	\N	Paulina Jędruś	+48 506 125 614	Gen. Andersa 34A / 5	42-600	Tarnowskie Góry	PL	4bbb006f-a40a-11f0-a417-fd831f6ae8ec	PAID	AF	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	\N	t	\N	2025-10-08 05:51:28.272	\N	2025-10-09 19:34:22.334641	ONLINE	f	[{"id": "RFBEOjEwMjcwOTU4MjI5MTJV", "waybill": "1027095822912U", "carrierId": "DPD", "createdAt": "2025-10-08T11:51:59.732Z", "lineItems": [{"id": "4b5cda51-a40a-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjcwOTU4MjMwODFV", "waybill": "1027095823081U", "carrierId": "DPD", "createdAt": "2025-10-08T11:51:59.948Z", "lineItems": [{"id": "4b5cda51-a40a-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7630	7c71b580-a3aa-11f0-a15e-754093089519	\N	\N	2025-10-07 18:33:23.101	READY_FOR_PROCESSING	allegro-pl	2918456	ewakry1	3fr96v7t9j+59e1b4545@allegromail.pl	\N	Grzegorz Krystkowicz	+48 507 117 876	Skryta 15	07-410	Ostrołęka	PL	ef6c1ba6-a3ab-11f0-b9a1-9fd75769370f	PAID	P24	t	75.00	PLN	Allegro Kurier DPD	0.00	PLN	75.00	PLN	zamawiam obicie -  Hugo Pik szary - THP2	t	\N	2025-10-07 18:33:23.101	\N	2025-10-09 19:34:41.063664	ONLINE	f	[{"id": "RFBEOjEwMjcwNDYzOTAzMjdV", "waybill": "1027046390327U", "carrierId": "DPD", "createdAt": "2025-10-08T05:22:57.575Z", "lineItems": [{"id": "7c6a6280-a3aa-11f0-a15e-754093089519"}]}]	\N	0.00	\N	[]	f
7631	b1c3ae70-a3a8-11f0-995e-7bc10d9eb16f	\N	\N	2025-10-07 18:22:28.958	READY_FOR_PROCESSING	allegro-pl	7419905	bartek_1503	l0qza6qbzd+693deb888@allegromail.pl	\N	Bartosz Brojecki	+48 665 165 482	Ogińskiego 25/9	66-400	Gorzów Wielkopolski	PL	b1e986d5-a3a8-11f0-91d4-7961b40d7b05	PAID	PAYU	t	1263.50	PLN	Allegro Kurier DPD	0.00	PLN	1263.50	PLN	Proszę o obicia w kolorze TH1 - Tkanina Hugo Czarny	t	\N	2025-10-07 18:22:28.958	\N	2025-10-09 19:34:42.565499	ONLINE	f	[{"id": "RFBEOjEwMjcwNjA1NDQzMzdV", "waybill": "1027060544337U", "carrierId": "DPD", "createdAt": "2025-10-08T07:18:48.780Z", "lineItems": [{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f"}]}, {"id": "RFBEOjEwMjcwNjA1NDQ0MzZV", "waybill": "1027060544436U", "carrierId": "DPD", "createdAt": "2025-10-08T07:18:48.994Z", "lineItems": [{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f"}]}, {"id": "RFBEOjEwMjcwNjA1NDQ1OTdV", "waybill": "1027060544597U", "carrierId": "DPD", "createdAt": "2025-10-08T07:18:49.164Z", "lineItems": [{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f"}]}]	\N	0.00	\N	[]	f
7632	d30c2a10-a3a0-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-07 17:14:42.206	READY_FOR_PROCESSING	allegro-pl	6267146	sasorki	xi99vdxqdg+4ae32d471@allegromail.pl	\N	SYLWIA SASORSKA	+48 573 480 443	Bałtycka 22/6	75-331	Koszalin	PL	d34c4132-a3a0-11f0-a284-071dd65bf45d	PAID	PAYU	t	1263.50	PLN	Allegro Kurier DPD	0.00	PLN	1263.50	PLN	Witam serdecznie, proszę kolor obicia welur czarny, haki w kolorze czarnym. Pozdrawiam 	t	\N	2025-10-07 17:14:42.206	\N	2025-10-09 19:34:44.063468	ONLINE	f	[{"id": "RFBEOjEwMjcxNjYzODgwNjhV", "waybill": "1027166388068U", "carrierId": "DPD", "createdAt": "2025-10-09T09:59:48.856Z", "lineItems": [{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjcxNjYzODgxMjFV", "waybill": "1027166388121U", "carrierId": "DPD", "createdAt": "2025-10-09T09:59:49.104Z", "lineItems": [{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjcxNjYzODgyMTNV", "waybill": "1027166388213U", "carrierId": "DPD", "createdAt": "2025-10-09T09:59:49.308Z", "lineItems": [{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7633	470fa2e0-a39f-11f0-9468-2bd22967b382	\N	\N	2025-10-07 17:07:13.505	READY_FOR_PROCESSING	allegro-pl	1796966	latynistka	suwf90g6ts+3365b3a98@allegromail.pl	\N	Adriana Grzelak-Krzymianowska	+48 609 022 105	Piłsudskiego 30 m.44	95-050	Konstantynów Łódzki	PL	7883b464-a39f-11f0-a284-071dd65bf45d	PAID	P24	t	2120.40	PLN	Allegro Kurier DPD	0.00	PLN	2120.40	PLN	Kolor paneli: ES4 (ekoskóra brązowa)	t	\N	2025-10-07 17:07:13.505	\N	2025-10-09 19:34:45.591752	ONLINE	f	[{"id": "RFBEOjEwMjcwOTIzNzQ1ODhV", "waybill": "1027092374588U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:48.629Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ2OTZV", "waybill": "1027092374696U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:48.919Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ3ODlV", "waybill": "1027092374789U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:49.140Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ4NzdV", "waybill": "1027092374877U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:49.341Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ5NTZV", "waybill": "1027092374956U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:49.536Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7634	14e058a0-a39f-11f0-b56d-0ba559d87e46	\N	\N	2025-10-07 17:02:01.628	READY_FOR_PROCESSING	allegro-pl	54314693	Client:54314693	plwzsdlteo+ebcc5e56@allegromail.pl	\N	Anita Dolecka	+48 782 795 346	Inwestorska 10	23-300	Borownica	PL	3eacba59-a39f-11f0-a284-071dd65bf45d	PAID	P24	t	666.00	PLN	Allegro Kurier DPD	0.00	PLN	666.00	PLN	Tkanina obicia TH1 tkanina Hugo czarny	t	\N	2025-10-07 17:02:01.628	\N	2025-10-09 19:34:47.220975	ONLINE	f	[]	\N	0.00	\N	[]	f
7635	5b9f1d40-a39e-11f0-9468-2bd22967b382	\N	\N	2025-10-07 16:55:34.498	READY_FOR_PROCESSING	allegro-pl	114103324	Client:114103324	x9931rckoc+63912f744@allegromail.pl	\N	Marcin Ziomek	+48 533 677 800	Podgrzybkowa 13 13 / 11	66-446	Glinik	PL	5bdc74db-a39e-11f0-a284-071dd65bf45d	PAID	PAYU	t	292.99	PLN	Allegro Kurier DPD	14.99	PLN	292.99	PLN	\N	f	\N	2025-10-07 16:55:34.498	\N	2025-10-09 19:34:48.866238	ONLINE	f	[]	\N	0.00	\N	[]	f
7636	f1c974b0-a39d-11f0-8d43-e5c6c6646cd8	\N	\N	2025-10-07 16:54:54.013	READY_FOR_PROCESSING	allegro-pl	51088242	Aga_Agness	3oufx0wqrp+463f63a62@allegromail.pl	\N	Agnieszka Adamczyk	+48 501 385 812	Laurowa 10 m. 25	20-153	Lublin	PL	f92faeb1-a39d-11f0-a417-fd831f6ae8ec	PAID	P24	t	1021.00	PLN	Allegro Kurier DPD	0.00	PLN	1021.00	PLN	THP2 Tkanina Hugo Pik Jasno Szary	t	\N	2025-10-07 16:54:54.013	\N	2025-10-09 19:34:50.349499	ONLINE	f	[]	\N	0.00	\N	[]	f
7637	1e0e9330-a39d-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-07 16:50:26.898	CANCELLED	allegro-pl	51088242	Aga_Agness	3oufx0wqrp+60d0d77b5@allegromail.pl	\N	Agnieszka Adamczyk	+48 501 385 812	\N	\N	\N	\N	278a4008-a39d-11f0-a284-071dd65bf45d	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1021.00	PLN	obicie THP2 Tkanina Hugo Pik Jasno Szary 	t	\N	\N	\N	2025-10-09 19:34:51.982135	ONLINE	f	[]	\N	0.00	\N	[]	f
7638	0a3ff4a0-a39a-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-07 16:24:36.882	READY_FOR_PROCESSING	allegro-pl	22511619	monikascena	w1fxoslx38+22010a852@allegromail.pl	\N	Monika Pastuszka	+48 508 352 578	Ul. Kośna 20/2	26-600	Radom	PL	1b526148-a39a-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	560.99	PLN	\N	t	\N	2025-10-07 16:24:36.882	\N	2025-10-09 19:34:53.415426	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwNDUzOTIzODZV", "waybill": "1027045392386U", "carrierId": "DPD", "createdAt": "2025-10-08T05:10:37.493Z", "lineItems": [{"id": "0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjcwNDUzOTI0NTlV", "waybill": "1027045392459U", "carrierId": "DPD", "createdAt": "2025-10-08T05:10:37.724Z", "lineItems": [{"id": "0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7639	d274a930-a399-11f0-a3bc-ef5c37833579	\N	\N	2025-10-07 16:23:07.307	READY_FOR_PROCESSING	allegro-pl	2388947	palladyn27	e5fy9qrd0m+548e53066@allegromail.pl	\N	sylwester wieloch	+48 791 428 301	Reja 2 / 55	32-300	Olkusz	PL	e183cc1a-a399-11f0-baf9-a33944a1116d	PAID	AF	t	1557.00	PLN	Allegro Kurier DPD	0.00	PLN	1557.00	PLN	\N	t	\N	2025-10-07 16:23:07.307	\N	2025-10-09 19:34:54.833203	ONLINE	f	[{"id": "RFBEOjEwMjcwNjA4NzM4MzZV", "waybill": "1027060873836U", "carrierId": "DPD", "createdAt": "2025-10-08T07:21:18.052Z", "lineItems": [{"id": "d2701550-a399-11f0-a3bc-ef5c37833579"}]}, {"id": "RFBEOjEwMjcwNjA4NzM5NDVV", "waybill": "1027060873945U", "carrierId": "DPD", "createdAt": "2025-10-08T07:21:18.283Z", "lineItems": [{"id": "d2701550-a399-11f0-a3bc-ef5c37833579"}]}, {"id": "RFBEOjEwMjcwNjA4NzQwMzFV", "waybill": "1027060874031U", "carrierId": "DPD", "createdAt": "2025-10-08T07:21:18.483Z", "lineItems": [{"id": "d2701550-a399-11f0-a3bc-ef5c37833579"}]}]	\N	0.00	\N	[]	f
7641	8173bb40-a397-11f0-9288-ef897151e2e1	\N	\N	2025-10-07 16:07:22.286	READY_FOR_PROCESSING	allegro-pl	6728704	niuniaxxl	ebpf4r1q0j+e406cc62@allegromail.pl	\N	Katarzyna Łada	+48 663 773 903	Młodzieżowa 3/26	89-600	Chojnice	PL	95f49ab6-a397-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	462.00	PLN	Allegro Kurier DPD	0.00	PLN	462.00	PLN	\N	t	\N	2025-10-07 16:07:22.286	\N	2025-10-09 19:34:57.866778	ONLINE	f	[{"id": "RFBEOjEwMjcwOTYxNDk2NDBV", "waybill": "1027096149640U", "carrierId": "DPD", "createdAt": "2025-10-08T11:55:25.438Z", "lineItems": [{"id": "816e3d00-a397-11f0-9288-ef897151e2e1"}]}]	\N	0.00	\N	[]	f
7642	8a869080-a393-11f0-bc71-87ddccc94446	\N	\N	2025-10-07 15:43:40.281	READY_FOR_PROCESSING	allegro-pl	1853612	Margos7	cd4556er8i+2d781ed8@allegromail.pl	TSC POLSKA MICHAŁ CEGLAREK 	Małgorzata Śliwa	+48 502 090 482	Znojów 3A	26-021	Daleszyce	PL	58259370-a394-11f0-a284-071dd65bf45d	PAID	PAYU	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-07 15:43:40.281	\N	2025-10-09 19:34:59.370898	ONLINE	f	[]	\N	0.00	\N	[]	f
7643	e7b9ffb0-a390-11f0-8d43-e5c6c6646cd8	\N	\N	2025-10-07 15:24:45.525	READY_FOR_PROCESSING	allegro-pl	42112779	Client:42112779	eh8bivks34+536f5b453@allegromail.pl	\N	halina Lewandowska	+48 601 794 594	Partyzantów 16/8	07-401	Ostrołęka	PL	f8ce682a-a390-11f0-a284-071dd65bf45d	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	obicie siedziska ES4	t	\N	2025-10-07 15:24:45.525	\N	2025-10-09 19:35:00.89155	ONLINE	f	[{"id": "RFBEOjEwMjcwNDYxNDQyODRV", "waybill": "1027046144284U", "carrierId": "DPD", "createdAt": "2025-10-08T05:20:09Z", "lineItems": [{"id": "e7b2d3c0-a390-11f0-8d43-e5c6c6646cd8"}]}]	\N	0.00	\N	[]	f
7644	eec49e50-a38b-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 14:47:25.424	READY_FOR_PROCESSING	allegro-pl	60606266	Client:60606266	memryxz7pu+75ac83e00@allegromail.pl	\N	Robert Piątek	+48 508 348 363	Leśna 16	47-113	Staniszcze Wielkie	PL	ef043f65-a38b-11f0-a284-071dd65bf45d	PAID	P24	t	674.30	PLN	Allegro Kurier DPD	0.00	PLN	674.30	PLN	Kolor  Dąb Estana :)	t	\N	2025-10-07 14:47:25.424	\N	2025-10-09 19:35:02.367047	ONLINE	f	[]	\N	0.00	\N	[]	f
7645	e173d570-a388-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-07 14:22:05.215	READY_FOR_PROCESSING	allegro-pl	1046242	anielka.1	cocgw4f2bp+3546c5ea5@allegromail.pl	\N	Grażyna Michalska	+48 604 469 818	Zielonogórska 11	62-300	Września	PL	e1b39e04-a388-11f0-96eb-67f4404dbe40	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-07 14:22:05.215	\N	2025-10-09 19:35:03.842614	ONLINE	f	[{"id": "RFBEOjEwMjcxNjY4NDkwNzlV", "waybill": "1027166849079U", "carrierId": "DPD", "createdAt": "2025-10-09T10:03:31.468Z", "lineItems": [{"id": "e16d1eb0-a388-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7646	523a61d0-a37e-11f0-8d43-e5c6c6646cd8	\N	\N	2025-10-07 13:12:18.686	READY_FOR_PROCESSING	allegro-pl	11434945	krawiec177	4710of7hgs+17f4a5b75@allegromail.pl	\N	Tadeusz Zawiejski	+48 604 939 670	Grunwaldzka 49 / 35	76-270	Ustka	PL	dac389ac-a37e-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	421.00	PLN	\N	f	\N	2025-10-07 13:12:18.686	\N	2025-10-09 19:35:05.323924	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwNDY0NzEyNjNV", "waybill": "1027046471263U", "carrierId": "DPD", "createdAt": "2025-10-08T05:23:57.590Z", "lineItems": [{"id": "5233d220-a37e-11f0-8d43-e5c6c6646cd8"}]}]	\N	0.00	\N	[]	f
7647	8af73a30-a373-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 12:00:37.256	READY_FOR_PROCESSING	allegro-pl	111875511	Client:111875511	m8tv8cezo9+69e5c5a52@allegromail.pl	\N	Krzysztof Czmoch	+48 602 252 693	Puławska 11 / 65	02-515	Warszawa	PL	41156407-a374-11f0-ae11-e76c74c7cf77	PAID	P24	t	364.99	PLN	Allegro Kurier DPD	14.99	PLN	364.99	PLN	\N	f	\N	2025-10-07 12:00:37.256	\N	2025-10-09 19:35:06.788188	ONLINE	f	[]	\N	364.99	2025-10-08 06:56:26.126	[{"id": "e86d5b7a-a413-11f0-9a6c-8548593624b4", "order": {"id": "8af73a30-a373-11f0-a6cc-b3145592fdde"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "41156407-a374-11f0-ae11-e76c74c7cf77"}, "delivery": {"value": {"amount": "14.99", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-08T06:56:26.126Z", "lineItems": [{"id": "8aed7630-a373-11f0-a6cc-b3145592fdde", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "364.99", "currency": "PLN"}}]	t
7648	d16fb191-a373-11f0-9468-2bd22967b382	\N	\N	2025-10-07 11:51:09.415	READY_FOR_PROCESSING	allegro-pl	118614023	Client:118614023	lb5asctpdu+1563d3492@allegromail.pl	\N	Karolina Paszczakowska	+48 725 330 793	Cicha 1	63-421	Dębnica	PL	d1afc833-a373-11f0-a417-fd831f6ae8ec	PAID	AF	t	592.00	PLN	Allegro Kurier DPD	0.00	PLN	592.00	PLN	\N	t	\N	2025-10-07 11:51:09.415	\N	2025-10-09 19:35:08.524972	ONLINE	f	[]	\N	0.00	\N	[]	f
7649	04b51c30-a373-11f0-9468-2bd22967b382	\N	\N	2025-10-07 11:49:27.491	READY_FOR_PROCESSING	allegro-pl	2181731	peterkuska	cu1w5h6yzg+4730ba198@allegromail.pl	\N	Piotr Kuśka	+48 606 321 003	os. Orłowiec 55D/3	44-280	Rydułtowy	PL	04f225f5-a373-11f0-a417-fd831f6ae8ec	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Zamawiam kolor siedziska: TH4 - Tkanina Hugo Brązowy	t	\N	2025-10-07 11:49:27.491	\N	2025-10-09 19:35:10.006375	ONLINE	f	[{"id": "RFBEOjEwMjcwNDY4Mjk0NTFV", "waybill": "1027046829451U", "carrierId": "DPD", "createdAt": "2025-10-08T05:28:07.982Z", "lineItems": [{"id": "04ad5400-a373-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7650	79d896e0-a364-11f0-a3bc-ef5c37833579	\N	\N	2025-10-07 10:01:02.157	READY_FOR_PROCESSING	allegro-pl	9950759	michalkiewicz86	3ao4zllb89+1bfa41a4@allegromail.pl	\N	Michał Michałkiewicz	+48 533 229 794	Łyskowskiego 4a / 35	87-300	Brodnica	PL	85826e12-a364-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	675.99	PLN	\N	t	\N	2025-10-07 10:01:02.157	\N	2025-10-09 19:35:11.487078	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7651	88b45fd1-a357-11f0-bc71-87ddccc94446	\N	\N	2025-10-07 08:28:40.427	READY_FOR_PROCESSING	allegro-pl	123671648	syn-mar	z8jngugyz2+524cc2458@allegromail.pl	\N	marek synowiec	+48 535 573 838	orzechowa 29 / 29	50-540	wrocław	PL	88d70327-a357-11f0-baf9-a33944a1116d	PAID	P24	t	1052.00	PLN	Allegro Kurier DPD	0.00	PLN	1052.00	PLN	\N	t	\N	2025-10-07 08:28:40.427	\N	2025-10-09 19:35:12.962774	ONLINE	f	[{"id": "RFBEOjEwMjcxNjY5NTg5MzhV", "waybill": "1027166958938U", "carrierId": "DPD", "createdAt": "2025-10-09T10:04:24.609Z", "lineItems": [{"id": "88af56c1-a357-11f0-bc71-87ddccc94446"}]}, {"id": "RFBEOjEwMjcxNjY5NTkwMTFV", "waybill": "1027166959011U", "carrierId": "DPD", "createdAt": "2025-10-09T10:04:24.781Z", "lineItems": [{"id": "88af56c1-a357-11f0-bc71-87ddccc94446"}]}, {"id": "RFBEOjEwMjcxNjY5NTkxNTRV", "waybill": "1027166959154U", "carrierId": "DPD", "createdAt": "2025-10-09T10:04:24.945Z", "lineItems": [{"id": "88af56c1-a357-11f0-bc71-87ddccc94446"}]}]	\N	0.00	\N	[]	f
7652	6b11b120-a353-11f0-a15e-754093089519	\N	\N	2025-10-07 08:04:42.843	READY_FOR_PROCESSING	allegro-pl	19616942	annastefan20	puinwti7od+202c49563@allegromail.pl	\N	Anna Stefan	+48 600 910 291	ul. Ks. Kard. Wyszyńskiego 11/35	86-100	Świecie	PL	6b523d7e-a353-11f0-a284-071dd65bf45d	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-07 08:04:42.843	\N	2025-10-09 19:35:14.481877	ONLINE	f	[{"id": "RFBEOjEwMjY5OTc4Mzk0ODZV", "waybill": "1026997839486U", "carrierId": "DPD", "createdAt": "2025-10-07T10:29:46.540Z", "lineItems": [{"id": "6b0a8530-a353-11f0-a15e-754093089519"}]}, {"id": "RFBEOjEwMjcwODkzMDY1OTJV", "waybill": "1027089306592U", "carrierId": "DPD", "createdAt": "2025-10-08T10:54:18.129Z", "lineItems": [{"id": "6b0a8530-a353-11f0-a15e-754093089519"}]}]	\N	0.00	\N	[]	f
81	015ac010-a122-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 13:02:15.515	READY_FOR_PROCESSING	allegro-pl	33192489	Client:33192489	d2zb9jl933+4e4234b37@allegromail.pl	\N	kamil cybulski	+48 508 975 603	Trzcinowa 22/27	87-100	Toruń	PL	2a3a508d-a122-11f0-ae11-e76c74c7cf77	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Hugo czarny TH1	t	\N	2025-10-04 13:02:15.515	\N	2025-10-09 19:41:24.543023	ONLINE	f	[{"id": "RFBEOjEwMjY5ODUxOTc0NDFV", "waybill": "1026985197441U", "carrierId": "DPD", "createdAt": "2025-10-07T08:56:22.320Z", "lineItems": [{"id": "01540950-a122-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7653	628c6f80-a34f-11f0-b861-bd1e9af656a8	\N	\N	2025-10-07 07:33:53.346	READY_FOR_PROCESSING	allegro-pl	10348784	adamrak77	b3mcamissn+285837b38@allegromail.pl	\N	Adam Rak	+48 606 629 466	Wojska Polskiego 16/3	78-460	Barwice	PL	69a01ceb-a34f-11f0-b9a1-9fd75769370f	PAID	P24	t	532.00	PLN	Allegro Kurier DPD	0.00	PLN	532.00	PLN	\N	t	\N	2025-10-07 07:33:53.346	\N	2025-10-09 19:35:15.94631	ONLINE	f	[{"id": "RFBEOjEwMjcwNjEzMDU2NjBV", "waybill": "1027061305660U", "carrierId": "DPD", "createdAt": "2025-10-08T07:24:22.582Z", "lineItems": [{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8"}]}, {"id": "RFBEOjEwMjcwNjEzMDU3MDFV", "waybill": "1027061305701U", "carrierId": "DPD", "createdAt": "2025-10-08T07:24:22.804Z", "lineItems": [{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8"}]}]	\N	0.00	\N	[]	f
7654	b4dad3c0-a34b-11f0-87ab-43c4d16d6a38	\N	\N	2025-10-07 07:05:08.702	READY_FOR_PROCESSING	allegro-pl	90492441	Client:90492441	np29ltdy0p+15a87cad0@allegromail.pl	\N	Bogumiła Świrszcz	+48 601 904 095	Siennica Nadolna194A	22-302	Siennica Nadolna	PL	b51bfc41-a34b-11f0-ae11-e76c74c7cf77	PAID	AF	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	Siedzisko ES1	t	\N	2025-10-07 07:05:08.702	\N	2025-10-09 19:35:17.471156	ONLINE	f	[{"id": "RFBEOjEwMjY5OTY5NzQ0MTVV", "waybill": "1026996974415U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:49.202Z", "lineItems": [{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38"}]}, {"id": "RFBEOjEwMjY5OTY5NzQ1MDZV", "waybill": "1026996974506U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:49.371Z", "lineItems": [{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38"}]}]	\N	0.00	\N	[]	f
7655	a6aa15b2-a349-11f0-9d2c-bd0fd501dc68	\N	\N	2025-10-07 12:04:58.09	READY_FOR_PROCESSING	allegro-pl	96105871	mk_termoinstal	diipxwoujq+5535528e8@allegromail.pl	MK TERMO-INSTAL KRZYSZTOF GRĘZAK	Krzysztof Gręzak	+48 517 517 770	Lekarska 4-6	51-147	Wrocław	PL	a9bdbf05-a349-11f0-baf9-a33944a1116d	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-10-07 12:04:58.09	\N	2025-10-09 19:35:18.983524	ONLINE	t	[{"id": "RFBEOjEwMjcwNDY3NDkyMzJV", "waybill": "1027046749232U", "carrierId": "DPD", "createdAt": "2025-10-08T05:27:13.178Z", "lineItems": [{"id": "a6a3fb32-a349-11f0-9d2c-bd0fd501dc68"}]}]	Michała Bałuckiego 14	0.00	\N	[]	f
7656	865e98b0-a346-11f0-9fcc-bf32f2dae555	\N	\N	2025-10-07 06:28:32.483	READY_FOR_PROCESSING	allegro-pl	102694434	Client:102694434	zvv864av6z+71cf35c30@allegromail.pl	\N	Marzena Nagórka	+48 609 438 239	Adamów 17a, 	96-115	Nowy Kawęczyn	PL	8e677b5e-a346-11f0-a284-071dd65bf45d	PAID	AF	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	dzień dobry, poproszę kolor obicia: WE1 - welur czarny. Pozdrawiam	t	\N	2025-10-07 06:28:32.483	\N	2025-10-09 19:35:20.522399	ONLINE	f	[{"id": "RFBEOjEwMjY5OTY5NzExNzJV", "waybill": "1026996971172U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:47.636Z", "lineItems": [{"id": "865793d0-a346-11f0-9fcc-bf32f2dae555"}]}, {"id": "RFBEOjEwMjY5OTY5NzEyOTJV", "waybill": "1026996971292U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:47.837Z", "lineItems": [{"id": "865793d0-a346-11f0-9fcc-bf32f2dae555"}]}]	\N	0.00	\N	[]	f
7658	dcd790a2-a33e-11f0-b871-03a75625f948	\N	\N	2025-10-07 05:32:14.577	READY_FOR_PROCESSING	allegro-pl	2571925	kustek_2004	1577z7ts6d+279e29594@allegromail.pl	\N	Jacek Kustosik	+48 605 125 260	Południowa 24	95-035	Ozorków	PL	dd0b4b87-a33e-11f0-baf9-a33944a1116d	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-07 05:32:14.577	\N	2025-10-09 19:35:24.240742	ONLINE	f	[{"id": "RFBEOjEwMjY5ODkyODI5MThV", "waybill": "1026989282918U", "carrierId": "DPD", "createdAt": "2025-10-07T09:26:17.291Z", "lineItems": [{"id": "dcd26082-a33e-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY5ODkyODMwOTlV", "waybill": "1026989283099U", "carrierId": "DPD", "createdAt": "2025-10-07T09:26:17.519Z", "lineItems": [{"id": "dcd26082-a33e-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7659	3a93dcb0-a32d-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-07 03:28:47.757	READY_FOR_PROCESSING	allegro-pl	27345867	Nikosiaa5	zfd2p0s7o5+79a272f57@allegromail.pl	\N	Nikola Wicka	+48 796 430 704	Ignacego Matuszewskiego 11	80-288	GDAŃSK	PL	428abeae-a32d-11f0-a417-fd831f6ae8ec	PAID	AF	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	Materiał  F04	t	\N	2025-10-07 03:28:47.757	\N	2025-10-09 19:35:25.830315	ONLINE	f	[{"id": "RFBEOjEwMjY5NTQyMjgxOTNV", "waybill": "1026954228193U", "carrierId": "DPD", "createdAt": "2025-10-07T04:38:02.663Z", "lineItems": [{"id": "3a8cd7d0-a32d-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
47	394fc140-a1eb-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 13:02:00.102	READY_FOR_PROCESSING	allegro-pl	44178885	krzyskonin	20hgxoh50t+73215da44@allegromail.pl	\N	Krzysztof Przybylski	+48 535 095 804	Ul.Wyzwolenia 5/81	62-510	Konin	\N	39712c73-a1eb-11f0-b9a1-9fd75769370f	PAID	PAYU	t	328.99	\N	Allegro Kurier DPD	14.99	PLN	328.99	PLN	Material na siedzisko z materiału o kodzie WE1. Pozdrawiam 	f	\N	2025-10-08 14:30:52.22	\N	2025-10-09 19:35:27.436274	ONLINE	f	[]	\N	0.00	\N	[]	f
7661	ef3fe2b0-9e02-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-08 01:11:39.258	CANCELLED	allegro-pl	21868358	sylwia4258	aqxzyoslha+70e0acd15@allegromail.pl	\N	Sylwia Rejman	+48 607 676 799	\N	\N	\N	\N	ef63e633-9e02-11f0-b9a1-9fd75769370f	UNPAID	PAYU	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	kolor obicia welur jasnoszary WE2.  kolor wieszaków czarny 	t	\N	\N	\N	2025-10-09 19:35:28.936689	ONLINE	f	[]	\N	0.00	\N	[]	f
7662	30520490-9d63-11f0-a677-a5b8c1586284	\N	\N	2025-10-07 01:15:30.58	CANCELLED	allegro-pl	5245834	GenCode	1cylqscdvc+71ceb6f85@allegromail.pl	M&H Hubert Lachtara	Hubert Lachtara	+48 533 425 222	\N	\N	\N	\N	3833d760-9d63-11f0-baf9-a33944a1116d	UNPAID	AF	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	\N	t	\N	\N	\N	2025-10-09 19:35:30.351716	ONLINE	t	[]	Osówka 33C	0.00	\N	[]	f
7663	0e64f410-9d35-11f0-8058-6bb39f24a57a	\N	\N	2025-10-07 01:09:41.924	CANCELLED	allegro-pl	8960922	madziastr1992	k9cpc4s4ox+41bd02ef4@allegromail.pl	\N	Magdalena Strzelczyk	+48 530 584 172	\N	\N	\N	\N	725c9082-9d62-11f0-a417-fd831f6ae8ec	UNPAID	AF	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	Dzień dobry, \n\nProszę i przyslanie wieszaków w kolorze szczotkowanego złota, natomiast jeśli chodzi o kolor obic to proszę zeby był to czarny welur. Chciałabym u Państwa kupić równiez dwa dodatkowe wieszaki w kolorze szczotkowanego złota, proszę o kontakt jeśli to możliwe. 	t	\N	2025-09-29 18:43:11.488	\N	2025-10-09 19:35:31.762006	ONLINE	t	[]	Osówka 33c	0.00	\N	[]	f
16	969f5ca0-a238-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 22:18:38.395	READY_FOR_PROCESSING	allegro-pl	22002746	Saakeee	rb61i0fh2x+406d83e04@allegromail.pl	\N	Artur Majdoszka	+48 601 929 294	Kijowska 3/55	85-703	Bydgoszcz	PL	96ce0e0c-a238-11f0-91d4-7961b40d7b05	PAID	P24	t	1140.00	PLN	Allegro Kurier DPD	0.00	PLN	1140.00	PLN	proszę o tkaninę ES1	t	\N	2025-10-05 22:18:38.395	\N	2025-10-09 19:39:45.567104	ONLINE	f	[{"id": "RFBEOjEwMjcxNDA0NzcwMDFV", "waybill": "1027140477001U", "carrierId": "DPD", "createdAt": "2025-10-09T06:38:04.819Z", "lineItems": [{"id": "963f6250-a238-11f0-b1e3-b7ce882fc700"}, {"id": "963f6251-a238-11f0-b1e3-b7ce882fc700"}]}, {"id": "RFBEOjEwMjcxNDA0NzcxNDBV", "waybill": "1027140477140U", "carrierId": "DPD", "createdAt": "2025-10-09T06:38:05.035Z", "lineItems": [{"id": "963f6250-a238-11f0-b1e3-b7ce882fc700"}, {"id": "963f6251-a238-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
76	cee26871-a12d-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-04 14:27:39.591	READY_FOR_PROCESSING	allegro-pl	115589707	Client:115589707	ezz8chcixp+67e06ed89@allegromail.pl	\N	Agnieszka Sepioło	+48 792 012 447	A. Zgrzebnioka 16A/18	41-717	Ruda Śląska	PL	cf10565f-a12d-11f0-91d4-7961b40d7b05	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Poproszę kolor siedziska czarny welur WE1.	t	\N	2025-10-04 14:27:39.591	\N	2025-10-09 19:41:17.079634	ONLINE	f	[{"id": "RFBEOjEwMjY4NDY2ODk0NDFV", "waybill": "1026846689441U", "carrierId": "DPD", "createdAt": "2025-10-06T05:17:19Z", "lineItems": [{"id": "cedcea31-a12d-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
17	ed908310-a236-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 22:06:27.103	READY_FOR_PROCESSING	allegro-pl	10162321	jola260173	apw1it6j05+1d9d9df57@allegromail.pl	\N	Jolanta Stasiorowska	+48 880 066 033	Oś.XXX-Lecia 11/41	47-303	Krapkowice	PL	edb39c39-a236-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	564.00	PLN	Allegro Kurier DPD	0.00	PLN	564.00	PLN	\N	t	\N	2025-10-05 22:06:27.103	\N	2025-10-09 19:39:47.255143	ONLINE	f	[{"id": "RFBEOjEwMjY5NjQxMjY3NDFV", "waybill": "1026964126741U", "carrierId": "DPD", "createdAt": "2025-10-07T06:24:29.011Z", "lineItems": [{"id": "ed8c3d50-a236-11f0-b1e3-b7ce882fc700"}]}, {"id": "RFBEOjEwMjY5NjQxMjY4MDFV", "waybill": "1026964126801U", "carrierId": "DPD", "createdAt": "2025-10-07T06:24:29.161Z", "lineItems": [{"id": "ed8c3d50-a236-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
20	293909b0-a22c-11f0-809f-f9f6de958f67	\N	\N	2025-10-05 20:47:22.417	READY_FOR_PROCESSING	allegro-pl	49172203	Client:49172203	y5thla94kr+7df22af92@allegromail.pl	\N	Klara Ruta	+48 573 068 211	Wyzwolenia 72	84-120	Władysławowo	PL	2976af23-a22c-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	1426.00	PLN	Allegro Kurier DPD	0.00	PLN	1426.00	PLN	\N	t	\N	2025-10-05 20:47:22.417	\N	2025-10-09 19:39:51.969786	ONLINE	f	[{"id": "RFBEOjEwMjY5NjQ0Nzc0NDhV", "waybill": "1026964477448U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:50.596Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}, {"id": "RFBEOjEwMjY5NjQ0Nzc1MzdV", "waybill": "1026964477537U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:50.887Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}, {"id": "RFBEOjEwMjY5NjQ0Nzc2MjlV", "waybill": "1026964477629U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:51.157Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}, {"id": "RFBEOjEwMjY5NjQ0Nzc3NjhV", "waybill": "1026964477768U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:51.410Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}]	\N	0.00	\N	[]	f
22	56379be0-a225-11f0-a82d-fde841cbe8d5	\N	\N	2025-10-05 19:59:20.655	READY_FOR_PROCESSING	allegro-pl	23392865	izabela806	lzdcljckn0+2fae5c5a9@allegromail.pl	DANMAR P.U.P.H. Mariusz Czerwiński	Izabela Czerwińska	+48 794 901 172	Juhasowa 9/1	92-008	Łódź	PL	565bed92-a225-11f0-91d4-7961b40d7b05	PAID	P24	t	1179.00	PLN	Allegro Kurier DPD	0.00	PLN	1179.00	PLN	Kod koloru siedziska TH3	t	\N	2025-10-05 19:59:20.655	\N	2025-10-09 19:39:55.275374	ONLINE	f	[{"id": "RFBEOjEwMjY5Njc3NzI3OTFV", "waybill": "1026967772791U", "carrierId": "DPD", "createdAt": "2025-10-07T06:51:08.625Z", "lineItems": [{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5"}]}, {"id": "RFBEOjEwMjY5Njc3NzI4NzlV", "waybill": "1026967772879U", "carrierId": "DPD", "createdAt": "2025-10-07T06:51:08.842Z", "lineItems": [{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5"}]}, {"id": "RFBEOjEwMjY5Njc3NzI5MzhV", "waybill": "1026967772938U", "carrierId": "DPD", "createdAt": "2025-10-07T06:51:09.073Z", "lineItems": [{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5"}]}]	\N	0.00	\N	[]	f
23	26221bd0-a223-11f0-bddc-ebae77b3e555	\N	\N	2025-10-05 19:40:58.174	READY_FOR_PROCESSING	allegro-pl	2248500	konrad_ST	5f8rptto36+1d4d811d0@allegromail.pl	\N	Konrad Stefański	+48 503 353 570	Sikorskiego 1/13	05-500	Piaseczno	PL	265dc580-a223-11f0-96eb-67f4404dbe40	PAID	PAYU	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	\N	t	\N	2025-10-05 19:40:58.174	\N	2025-10-09 19:39:57.070851	ONLINE	f	[{"id": "RFBEOjEwMjY5NjgyMDEwNjNV", "waybill": "1026968201063U", "carrierId": "DPD", "createdAt": "2025-10-07T06:54:14.356Z", "lineItems": [{"id": "261aefe0-a223-11f0-bddc-ebae77b3e555"}, {"id": "261aefe1-a223-11f0-bddc-ebae77b3e555"}]}]	\N	0.00	\N	[]	f
24	568e1d20-a221-11f0-83df-53954cf6c551	\N	\N	2025-10-05 19:31:34.986	READY_FOR_PROCESSING	allegro-pl	5042203	Sawek86	8btb1eum23+4b3e77da4@allegromail.pl	\N	Sławomir Bicz	+48 691 340 465	ul. Szmaragdowa  16/62	20-570	Lublin	PL	56ca8a54-a221-11f0-a417-fd831f6ae8ec	PAID	P24	t	2209.00	PLN	Allegro Kurier DPD	0.00	PLN	2209.00	PLN	H1 Haczyk czarny \nF04 Fjord Czarny\noraz zgodnie z rozmową telefoniczną proszę o 2 listewki w kolorze Wotan w rozmiarze 60 cm szerokości na 9 cm wysokości oklejone z 4 stron.	t	\N	2025-10-05 19:31:34.986	\N	2025-10-09 19:39:58.724698	ONLINE	f	[{"id": "RFBEOjEwMjY5MDY0NTkyMTZV", "waybill": "1026906459216U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.155Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDY0NTkzNzdV", "waybill": "1026906459377U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.376Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDY0NTk0MDBV", "waybill": "1026906459400U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.590Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDY0NTk1MTdV", "waybill": "1026906459517U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.804Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk1MjFV", "waybill": "1026909139521U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:33.170Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk2NDFV", "waybill": "1026909139641U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:34Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk3NTZV", "waybill": "1026909139756U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:34Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk4OTZV", "waybill": "1026909139896U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:34Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjcxNjQ4OTg1ODJV", "waybill": "1027164898582U", "carrierId": "DPD", "createdAt": "2025-10-09T09:47:28.525Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}]	\N	0.00	\N	[]	f
25	c5ae0f50-a21f-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-05 19:18:13.705	READY_FOR_PROCESSING	allegro-pl	40935541	Client:40935541	o0aga42jr3+6e1175916@allegromail.pl	\N	Krzysztof Gietz	+48 691 955 188	Żmichowskiej 9/3	51-680	Wrocław	PL	c5cf050d-a21f-11f0-b9a1-9fd75769370f	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	OBICIE TH4	t	\N	2025-10-05 19:18:13.705	\N	2025-10-09 19:40:00.385471	ONLINE	f	[{"id": "RFBEOjEwMjY4MzA1MTQ1MDVV", "waybill": "1026830514505U", "carrierId": "DPD", "createdAt": "2025-10-05T19:32:47Z", "lineItems": [{"id": "c5a90640-a21f-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY4NDQ3ODU4ODBV", "waybill": "1026844785880U", "carrierId": "DPD", "createdAt": "2025-10-06T05:01:03.942Z", "lineItems": [{"id": "c5a90640-a21f-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
27	ebc198d0-a21d-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 19:03:54.029	READY_FOR_PROCESSING	allegro-pl	15338578	iwonab1991	oqirqn49b9+69c4a1767@allegromail.pl	\N	Iwona Wróbel	+48 607 580 233	Borowa 591	39-305	Borowa	PL	ec064307-a21d-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	1320.00	PLN	Allegro Kurier DPD	0.00	PLN	1320.00	PLN	\N	t	\N	2025-10-05 19:03:54.029	\N	2025-10-09 19:40:03.351154	ONLINE	f	[{"id": "RFBEOjEwMjY5Njg5MzM3MDVV", "waybill": "1026968933705U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.233Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM4OTNV", "waybill": "1026968933893U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.513Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM5MTZV", "waybill": "1026968933916U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.755Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
28	a997f0e0-a217-11f0-83df-53954cf6c551	\N	\N	2025-10-05 18:25:19.86	READY_FOR_PROCESSING	allegro-pl	22584124	emileek79	nkpfs6hyog+51a248b57@allegromail.pl	\N	EMILIAN SZYMAŃSKI	+48 785 411 229	CISEW 149 C	62-700	TUREK	PL	5247d71d-a218-11f0-ae11-e76c74c7cf77	PAID	P24	t	1148.00	PLN	Allegro Kurier DPD	0.00	PLN	1148.00	PLN	TKANIA DO SIEDZISKA - HUGO CZARNY TH1 - PROSZĘ WYROBIĆ SIĘ Z DOSTAWĄ W TYM TYGODNIU BO MAM WOLNE	t	\N	2025-10-05 18:25:19.86	\N	2025-10-09 19:40:05.138351	ONLINE	f	[{"id": "RFBEOjEwMjY4OTI4NTAzMzdV", "waybill": "1026892850337U", "carrierId": "DPD", "createdAt": "2025-10-06T09:36:18.305Z", "lineItems": [{"id": "a9904fc0-a217-11f0-83df-53954cf6c551"}, {"id": "a9904fc1-a217-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY4OTI4NTA0NjhV", "waybill": "1026892850468U", "carrierId": "DPD", "createdAt": "2025-10-06T09:36:18.657Z", "lineItems": [{"id": "a9904fc0-a217-11f0-83df-53954cf6c551"}, {"id": "a9904fc1-a217-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY4OTI4NTA1MjFV", "waybill": "1026892850521U", "carrierId": "DPD", "createdAt": "2025-10-06T09:36:18.915Z", "lineItems": [{"id": "a9904fc0-a217-11f0-83df-53954cf6c551"}, {"id": "a9904fc1-a217-11f0-83df-53954cf6c551"}]}]	\N	0.00	\N	[]	f
29	6fcc9b40-a20d-11f0-bdc8-e34a18959311	\N	\N	2025-10-05 17:08:43.416	READY_FOR_PROCESSING	allegro-pl	26269530	witaminecka	c2lyu43dxu+339e9bde1@allegromail.pl	\N	Olga Dłubała	+48 721 019 476	Katowicka 39a	42-262	Kolonia Poczesna	PL	6fef8ce1-a20d-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	czarny, welur gladki czarny WE1	t	\N	2025-10-05 17:08:43.416	\N	2025-10-09 19:40:06.790098	ONLINE	f	[{"id": "RFBEOjEwMjY5NjU0NDI3NjJV", "waybill": "1026965442762U", "carrierId": "DPD", "createdAt": "2025-10-07T06:33:59.773Z", "lineItems": [{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5NjU0NDI4MDJV", "waybill": "1026965442802U", "carrierId": "DPD", "createdAt": "2025-10-07T06:33:59.991Z", "lineItems": [{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5NjU0NDI5ODNV", "waybill": "1026965442983U", "carrierId": "DPD", "createdAt": "2025-10-07T06:34:00.187Z", "lineItems": [{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311"}]}]	\N	0.00	\N	[]	f
34	2dddfd50-a203-11f0-bdc8-e34a18959311	\N	\N	2025-10-05 15:53:21.281	READY_FOR_PROCESSING	allegro-pl	6026252	zoja73	kvrbunm4hs+49f8c2e54@allegromail.pl	\N	Waldemar Wiśniewski	+48 691 165 762	Mickiewicza 37/2	16-515	PUŃSK	PL	2dfe3076-a203-11f0-baf9-a33944a1116d	PAID	AF	t	963.00	PLN	Allegro Kurier DPD	0.00	PLN	963.00	PLN	\N	t	\N	2025-10-05 15:53:21.281	\N	2025-10-09 19:40:14.39478	ONLINE	f	[{"id": "RFBEOjEwMjY5Njk1NDU3NjFV", "waybill": "1026969545761U", "carrierId": "DPD", "createdAt": "2025-10-07T07:04:04.727Z", "lineItems": [{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5Njk1NDU4NDlV", "waybill": "1026969545849U", "carrierId": "DPD", "createdAt": "2025-10-07T07:04:04.929Z", "lineItems": [{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5Njk1NDU5OTZV", "waybill": "1026969545996U", "carrierId": "DPD", "createdAt": "2025-10-07T07:04:05.136Z", "lineItems": [{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311"}]}]	\N	0.00	\N	[]	f
35	c68fea00-a202-11f0-9468-2bd22967b382	\N	\N	2025-10-05 15:52:51.361	READY_FOR_PROCESSING	allegro-pl	9187840	kipriotis	ygjowkffz6+3e9b27f54@allegromail.pl	\N	Agnieszka Świetlikowska	+48 609 129 803	ul. K. Wyki 1/33	01-318	Warszawa	PL	ed0be826-a202-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	9.98	PLN	884.98	PLN	uchwyty do obydwu szafek - U1 czarny\nsiedzisko WE5 welur niebieski	t	\N	2025-10-05 15:52:51.361	\N	2025-10-09 19:40:15.890965	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzEzOTU4MzJV", "waybill": "1026971395832U", "carrierId": "DPD", "createdAt": "2025-10-07T07:16:46.447Z", "lineItems": [{"id": "c688be10-a202-11f0-9468-2bd22967b382"}, {"id": "c688be11-a202-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzEzOTU5NzdV", "waybill": "1026971395977U", "carrierId": "DPD", "createdAt": "2025-10-07T07:16:46.626Z", "lineItems": [{"id": "c688be10-a202-11f0-9468-2bd22967b382"}, {"id": "c688be11-a202-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
38	bce3c350-a1f8-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 14:43:54.253	READY_FOR_PROCESSING	allegro-pl	50234473	Client:50234473	dqp6ih9abn+3c657dbc9@allegromail.pl	\N	Weronika Maksymowicz	+48 512 946 999	Klonownica Duża 52A	21-504	Rokitno	PL	bd2427ef-a1f8-11f0-ae11-e76c74c7cf77	PAID	P24	t	1032.00	PLN	Allegro Kurier DPD	0.00	PLN	1032.00	PLN	zestaw: ES1 - Eko skóra Czarny\npanel: ES1 - Eko skóra Czarny\nwieszak: H1 - Czarny (półmat)	t	\N	2025-10-05 14:43:54.253	\N	2025-10-09 19:40:20.304219	ONLINE	f	[{"id": "RFBEOjEwMjY5NzE5NDQ4MjdV", "waybill": "1026971944827U", "carrierId": "DPD", "createdAt": "2025-10-07T07:20:27.751Z", "lineItems": [{"id": "bcdce581-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce580-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce582-a1f8-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5NzE5NDQ5NzhV", "waybill": "1026971944978U", "carrierId": "DPD", "createdAt": "2025-10-07T07:20:28.033Z", "lineItems": [{"id": "bcdce581-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce580-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce582-a1f8-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
41	463f6510-a1f3-11f0-9468-2bd22967b382	\N	\N	2025-10-05 14:01:01.967	READY_FOR_PROCESSING	allegro-pl	3967855	asik821	9ptc9d7sk3+7466bf774@allegromail.pl	\N	Joanna Barbara Niewiadomska	+48 530 111 223	Sacharowa 47 m 8, bl.344	92-519	Łódź	PL	5223fbee-a1f3-11f0-a417-fd831f6ae8ec	PAID	AF	t	1705.00	PLN	Allegro Kurier DPD	0.00	PLN	1705.00	PLN	\N	t	\N	2025-10-05 14:01:01.967	\N	2025-10-09 19:40:24.949312	ONLINE	f	[{"id": "RFBEOjEwMjY5NzM1NDY5MzdV", "waybill": "1026973546937U", "carrierId": "DPD", "createdAt": "2025-10-07T07:31:23.115Z", "lineItems": [{"id": "46381210-a1f3-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzM1NDcwNDRV", "waybill": "1026973547044U", "carrierId": "DPD", "createdAt": "2025-10-07T07:31:23.414Z", "lineItems": [{"id": "46381210-a1f3-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzM1NDcxMDVV", "waybill": "1026973547105U", "carrierId": "DPD", "createdAt": "2025-10-07T07:31:23.701Z", "lineItems": [{"id": "46381210-a1f3-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
42	3bdeafe0-a1f3-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 13:58:49.976	READY_FOR_PROCESSING	allegro-pl	53808012	Client:53808012	3hwter5ktz+4316a877@allegromail.pl	\N	Małgorzata Miedzianko	+48 698 694 482	Moniuszki, 66 I /306	58-300	Wałbrzych	PL	3e24f6b3-a1f3-11f0-96eb-67f4404dbe40	PAID	AF	t	954.00	PLN	Allegro Kurier DPD	0.00	PLN	954.00	PLN	\N	t	\N	2025-10-05 13:58:49.976	\N	2025-10-09 19:40:26.431286	ONLINE	t	[{"id": "RFBEOjEwMjY5NzM4NDU5NDdV", "waybill": "1026973845947U", "carrierId": "DPD", "createdAt": "2025-10-07T07:33:23.998Z", "lineItems": [{"id": "3bd7f920-a1f3-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5NzM4NDYwMzVV", "waybill": "1026973846035U", "carrierId": "DPD", "createdAt": "2025-10-07T07:33:24.236Z", "lineItems": [{"id": "3bd7f920-a1f3-11f0-a6cc-b3145592fdde"}]}]	Moniuszki 66 I /306	0.00	\N	[]	f
79	4a9b1490-a123-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 13:09:56.199	READY_FOR_PROCESSING	allegro-pl	106650919	Client:106650919	8dtg41s9t4+7fd99ce38@allegromail.pl	\N	Sebastian Konieczny	+48 535 397 690	Grudzińskiego 18e / 19	62-020	Swarzędz	PL	4c4b5cfa-a123-11f0-a417-fd831f6ae8ec	PAID	AF	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	\N	f	\N	2025-10-04 13:09:56.199	\N	2025-10-09 19:41:21.538709	ONLINE	f	[{"id": "RFBEOjEwMjY4NDc5Mjg0ODZV", "waybill": "1026847928486U", "carrierId": "DPD", "createdAt": "2025-10-06T05:27:40.017Z", "lineItems": [{"id": "4a945dd0-a123-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
44	698624e0-a1ef-11f0-84a0-0fb86e0c96e9	\N	\N	2025-10-05 13:30:35.732	READY_FOR_PROCESSING	allegro-pl	15441956	magury23	tg5xgf7w28+6edf37422@allegromail.pl	\N	Małgorzata Guryn	+48 512 364 138	Wąwozowa 27 m 1	02-796	Warszawa	PL	69a7b6ed-a1ef-11f0-91d4-7961b40d7b05	PAID	P24	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-10-05 13:30:35.732	\N	2025-10-09 19:40:29.418346	ONLINE	f	[{"id": "RFBEOjEwMjY5NzQzMDExNThV", "waybill": "1026974301158U", "carrierId": "DPD", "createdAt": "2025-10-07T07:36:27.685Z", "lineItems": [{"id": "6981df20-a1ef-11f0-84a0-0fb86e0c96e9"}]}, {"id": "RFBEOjEwMjY5NzQzMDEyMzhV", "waybill": "1026974301238U", "carrierId": "DPD", "createdAt": "2025-10-07T07:36:27.867Z", "lineItems": [{"id": "6981df20-a1ef-11f0-84a0-0fb86e0c96e9"}]}]	\N	0.00	\N	[]	f
45	6c211080-a1ee-11f0-ac86-5dc583ff1e95	\N	\N	2025-10-05 13:24:31.15	READY_FOR_PROCESSING	allegro-pl	74273419	Client:74273419	t0yz0qrqr9+6d02bc742@allegromail.pl	\N	Sylwia Cygan	+48 691 567 494	30 stycznia 15	66-300	Międzyrzecz	PL	911d9a42-a1ee-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1347.99	PLN	H1 haki,eko skóra ES2 jasno szary	t	\N	2025-10-05 13:24:31.15	\N	2025-10-09 19:40:30.915188	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzQ0ODg4MzZV", "waybill": "1026974488836U", "carrierId": "DPD", "createdAt": "2025-10-07T07:37:46.222Z", "lineItems": [{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzQ0ODg5MjVV", "waybill": "1026974488925U", "carrierId": "DPD", "createdAt": "2025-10-07T07:37:46.422Z", "lineItems": [{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzQ0ODkwMzZV", "waybill": "1026974489036U", "carrierId": "DPD", "createdAt": "2025-10-07T07:37:46.587Z", "lineItems": [{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95"}]}]	\N	0.00	\N	[]	f
46	9a2d1e40-a1eb-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 13:03:42.723	READY_FOR_PROCESSING	allegro-pl	17267587	Justys-24	qmbkuix3ux+1ed5d5414@allegromail.pl	\N	Justyna Dopierała	+48 723 887 176	ul. Legionów Polskich 5/57	62-700	Turek	PL	9a6a00d6-a1eb-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	707.00	PLN	Allegro Kurier DPD	0.00	PLN	707.00	PLN	Kolor haków H1 (czarny)	t	\N	2025-10-05 13:03:42.723	\N	2025-10-09 19:40:32.414177	ONLINE	f	[{"id": "RFBEOjEwMjY4NDUyMjk4NDBV", "waybill": "1026845229840U", "carrierId": "DPD", "createdAt": "2025-10-06T05:05:24.491Z", "lineItems": [{"id": "9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed"}, {"id": "9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4NDUyMjk5MjlV", "waybill": "1026845229929U", "carrierId": "DPD", "createdAt": "2025-10-06T05:05:24.755Z", "lineItems": [{"id": "9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed"}, {"id": "9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
48	c50f7971-a1df-11f0-ac86-5dc583ff1e95	\N	\N	2025-10-05 11:40:19.889	READY_FOR_PROCESSING	allegro-pl	90712689	Client:90712689	ik7ovzupoh+46aef3f54@allegromail.pl	\N	Irmina Paciorkowska	+48 733 140 596	Gorzowska 114,	66-431	Santok	PL	03880fc0-a1e0-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	9.98	PLN	1000.98	PLN	\N	t	\N	2025-10-05 11:40:19.889	\N	2025-10-09 19:40:34.036455	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzUxMDY4MDRV", "waybill": "1026975106804U", "carrierId": "DPD", "createdAt": "2025-10-07T07:42:29.219Z", "lineItems": [{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95"}, {"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzUxMDY5MTNV", "waybill": "1026975106913U", "carrierId": "DPD", "createdAt": "2025-10-07T07:42:29.393Z", "lineItems": [{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95"}, {"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzUxMDcwODBV", "waybill": "1026975107080U", "carrierId": "DPD", "createdAt": "2025-10-07T07:42:29.572Z", "lineItems": [{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95"}, {"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95"}]}]	\N	0.00	\N	[]	f
51	d47b0d00-a1d7-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 10:43:04.528	READY_FOR_PROCESSING	allegro-pl	10982585	vento3000	q3kse6ip9x+16360a105@allegromail.pl	\N	Aleksandra Sienkiewicz-Otrębska	+48 788 392 686	Golisza 6C / 7	71-782	Szczecin	PL	d4bdbb9b-a1d7-11f0-96eb-67f4404dbe40	PAID	AF	t	977.00	PLN	Allegro Kurier DPD	0.00	PLN	977.00	PLN	Obicie Velvet niebieski, wieszaki czarne.	t	\N	2025-10-05 10:43:04.528	\N	2025-10-09 19:40:38.630984	ONLINE	f	[{"id": "RFBEOjEwMjY5NzU5MzQzMzBV", "waybill": "1026975934330U", "carrierId": "DPD", "createdAt": "2025-10-07T07:48:19.803Z", "lineItems": [{"id": "d4736be0-a1d7-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY5NzU5MzQ0NjdV", "waybill": "1026975934467U", "carrierId": "DPD", "createdAt": "2025-10-07T07:48:20.048Z", "lineItems": [{"id": "d4736be0-a1d7-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
52	e23a1a50-a1d5-11f0-8865-a987ea6c1e01	\N	\N	2025-10-05 10:31:53.166	READY_FOR_PROCESSING	allegro-pl	23392865	izabela806	lzdcljckn0+3c630781@allegromail.pl	DANMAR P.U.P.H. Mariusz Czerwiński	Izabela Czerwińska	+48 794 901 172	Juhasowa 9/1	92-008	Łódź	PL	e27946a4-a1d5-11f0-a417-fd831f6ae8ec	PAID	P24	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	kod koloru TH3	t	\N	2025-10-05 10:31:53.166	\N	2025-10-09 19:40:40.095051	ONLINE	f	[]	\N	828.00	2025-10-06 20:03:53.864	[{"id": "95774407-a2ef-11f0-a0c8-b30e01c12685", "order": {"id": "e23a1a50-a1d5-11f0-8865-a987ea6c1e01"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "e27946a4-a1d5-11f0-a417-fd831f6ae8ec"}, "deposits": [], "createdAt": "2025-10-06T20:03:53.864Z", "lineItems": [{"id": "e2333c80-a1d5-11f0-8865-a987ea6c1e01", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "828.00", "currency": "PLN"}}]	t
53	da174e91-a1d2-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 10:05:53.322	READY_FOR_PROCESSING	allegro-pl	37593094	Client:37593094	1togw0nbgl+2d7a1bee6@allegromail.pl	\N	Aurelia Anderson	+48 723 676 120	Słoneczna 29A	88-306	Dąbrowa	PL	da53bc3c-a1d2-11f0-a417-fd831f6ae8ec	PAID	AF	t	1319.00	PLN	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	\N	t	\N	2025-10-05 10:05:53.322	\N	2025-10-09 19:40:41.82403	ONLINE	f	[{"id": "RFBEOjEwMjY4NzMzNDc2NTZV", "waybill": "1026873347656U", "carrierId": "DPD", "createdAt": "2025-10-06T07:48:41.776Z", "lineItems": [{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4NzMzNDc3MDVV", "waybill": "1026873347705U", "carrierId": "DPD", "createdAt": "2025-10-06T07:48:41.947Z", "lineItems": [{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4NzMzNDc4OTNV", "waybill": "1026873347893U", "carrierId": "DPD", "createdAt": "2025-10-06T07:48:42.180Z", "lineItems": [{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
56	4289c930-a1c9-11f0-b871-03a75625f948	\N	\N	2025-10-05 08:59:46.466	READY_FOR_PROCESSING	allegro-pl	6535160	oossii87	6cp8o5s9t5+61e56fd9@allegromail.pl	\N	Dawid Osiński	+48 691 885 616	Białobłocka 10	85-363	Bydgoszcz	PL	67b0492e-a1c9-11f0-b9a1-9fd75769370f	PAID	AF	t	628.00	PLN	Allegro Kurier DPD	0.00	PLN	628.00	PLN	Witam, wybieram ES 4 (brąz)	t	\N	2025-10-05 08:59:46.466	\N	2025-10-09 19:40:46.948068	ONLINE	f	[{"id": "RFBEOjEwMjY4NDU0NzQwMDVV", "waybill": "1026845474005U", "carrierId": "DPD", "createdAt": "2025-10-06T05:07:18Z", "lineItems": [{"id": "4284e730-a1c9-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY4NDU0NzQxODhV", "waybill": "1026845474188U", "carrierId": "DPD", "createdAt": "2025-10-06T05:07:18Z", "lineItems": [{"id": "4284e730-a1c9-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
58	ed350e50-a1c2-11f0-9468-2bd22967b382	\N	\N	2025-10-05 08:13:05.977	READY_FOR_PROCESSING	allegro-pl	66943638	Client:66943638	pvzcqrma45+7574d74d1@allegromail.pl	\N	Bozena Glina	+48 605 092 067	Aleja Reymonta 8 m 1002	01-842	Warszawa	PL	ed739e10-a1c2-11f0-96eb-67f4404dbe40	PAID	P24	t	985.98	PLN	Allegro Kurier DPD	29.98	PLN	985.98	PLN	\N	f	\N	2025-10-05 08:13:05.977	\N	2025-10-09 19:40:49.965101	ONLINE	f	[{"id": "RFBEOjEwMjY5ODA0MzU0NDRV", "waybill": "1026980435444U", "carrierId": "DPD", "createdAt": "2025-10-07T08:21:51.906Z", "lineItems": [{"id": "ed2dbb50-a1c2-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5ODA0MzU1MjFV", "waybill": "1026980435521U", "carrierId": "DPD", "createdAt": "2025-10-07T08:21:52.070Z", "lineItems": [{"id": "ed2dbb50-a1c2-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
60	95595a70-a1bc-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 07:28:35.636	READY_FOR_PROCESSING	allegro-pl	1102723	karios	x59ro6fnz9+2917eea86@allegromail.pl	\N	Adam Kruczyński	+48 885 362 434	Trzeszczany, 173	22-554	Trzeszczany	PL	9598116f-a1bc-11f0-96eb-67f4404dbe40	PAID	P24	t	1590.00	PLN	Allegro Kurier DPD	0.00	PLN	1590.00	PLN	\N	t	\N	2025-10-05 07:28:35.636	\N	2025-10-09 19:40:52.977557	ONLINE	f	[{"id": "RFBEOjEwMjY5Nzk5ODQ4MjJV", "waybill": "1026979984822U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:26.405Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODQ5NDNV", "waybill": "1026979984943U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:26.709Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODUwMDZV", "waybill": "1026979985006U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:27.004Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODUxOTVV", "waybill": "1026979985195U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:27.252Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODUyODdV", "waybill": "1026979985287U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:27.531Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
61	61bbd700-a1b8-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-05 06:57:09.24	READY_FOR_PROCESSING	allegro-pl	3099544	diamel	uiq4reasf0+3ef401aa1@allegromail.pl	\N	Ireneusz Białoń	+48 728 916 799	Kowaniec 99	34-400	Nowy Targ	PL	6a7cbf99-a1b8-11f0-b9a1-9fd75769370f	PAID	P24	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	\N	t	\N	2025-10-05 06:57:09.24	\N	2025-10-09 19:40:54.766485	ONLINE	f	[{"id": "RFBEOjEwMjY4NDU2MjU5MjlV", "waybill": "1026845625929U", "carrierId": "DPD", "createdAt": "2025-10-06T05:08:40.532Z", "lineItems": [{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY4NDU2MjYwNTdV", "waybill": "1026845626057U", "carrierId": "DPD", "createdAt": "2025-10-06T05:08:40.688Z", "lineItems": [{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY4NDU2MjYxNDRV", "waybill": "1026845626144U", "carrierId": "DPD", "createdAt": "2025-10-06T05:08:40.827Z", "lineItems": [{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
66	db63fdd0-a159-11f0-9468-2bd22967b382	\N	\N	2025-10-04 19:41:05.125	READY_FOR_PROCESSING	allegro-pl	54910695	klaudyskax94	5b55ogok3w+46f351ae8@allegromail.pl	\N	Klaudia Wałczyk	+48 501 503 231	al.Żoł. I AWP 25/74	22-100	Chełm	PL	dba12e88-a159-11f0-a284-071dd65bf45d	PAID	P24	t	1009.00	PLN	Allegro Kurier DPD	0.00	PLN	1009.00	PLN	WE1 WELUR CZARNY kolor siedziska	t	\N	2025-10-04 19:41:05.125	\N	2025-10-09 19:41:02.125041	ONLINE	f	[{"id": "RFBEOjEwMjY5NjY1OTIwNzVV", "waybill": "1026966592075U", "carrierId": "DPD", "createdAt": "2025-10-07T06:42:22.494Z", "lineItems": [{"id": "db5d2000-a159-11f0-9468-2bd22967b382"}, {"id": "db5d2001-a159-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NjY1OTIxOTRV", "waybill": "1026966592194U", "carrierId": "DPD", "createdAt": "2025-10-07T06:42:22.682Z", "lineItems": [{"id": "db5d2000-a159-11f0-9468-2bd22967b382"}, {"id": "db5d2001-a159-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
69	80593270-a145-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-04 17:15:29.011	READY_FOR_PROCESSING	allegro-pl	22300676	jadwisia64	98p7ledlzb+38e0ad6f6@allegromail.pl	\N	jadwiga seklecka	+48 664 463 739	Toruńska 71 / 69	87-800	Włocławek	PL	807b8867-a145-11f0-baf9-a33944a1116d	PAID	P24	t	773.00	PLN	Allegro Kurier DPD	0.00	PLN	773.00	PLN	THP1hugo pik grafit	t	\N	2025-10-04 17:15:29.011	\N	2025-10-09 19:41:06.740201	ONLINE	f	[{"id": "RFBEOjEwMjY5ODE2MTYyOTdV", "waybill": "1026981616297U", "carrierId": "DPD", "createdAt": "2025-10-07T08:30:53.849Z", "lineItems": [{"id": "8054c5a0-a145-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY5ODE2MTYzNDBV", "waybill": "1026981616340U", "carrierId": "DPD", "createdAt": "2025-10-07T08:30:54.163Z", "lineItems": [{"id": "8054c5a0-a145-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
71	20dbfe80-a141-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-04 16:44:22.475	READY_FOR_PROCESSING	allegro-pl	5530849	MrFreez_21	bzypb7e8g3+29e2b3707@allegromail.pl	\N	Paweł Grzywna	+48 501 790 801	ul. Częstochowska 38	42-310	Żarki	PL	2a567266-a141-11f0-a284-071dd65bf45d	PAID	PAYU	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	Wybieram kolor siedziska TH3 - Tkanina Hugo Grafitowy	t	\N	2025-10-04 16:44:22.475	\N	2025-10-09 19:41:09.706651	ONLINE	f	[{"id": "RFBEOjEwMjY5ODIxNjk3MDBV", "waybill": "1026982169700U", "carrierId": "DPD", "createdAt": "2025-10-07T08:34:47.289Z", "lineItems": [{"id": "20d547c0-a141-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY5ODIxNjk4NDBV", "waybill": "1026982169840U", "carrierId": "DPD", "createdAt": "2025-10-07T08:34:47.535Z", "lineItems": [{"id": "20d547c0-a141-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
72	2413b570-a137-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 15:36:09.293	READY_FOR_PROCESSING	allegro-pl	10351791	1zyrafka	mmprme7av9+5c59ec8a6@allegromail.pl	\N	Jolanta Stępień	+48 781 298 635	Kozanowska 89 / 6	54-152	Wrocław	PL	8db110c6-a137-11f0-96eb-67f4404dbe40	PAID	P24	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	kolor tapicerki F03	f	\N	2025-10-04 15:36:09.293	\N	2025-10-09 19:41:11.166047	ONLINE	f	[{"id": "RFBEOjEwMjY4NDY1NzM3MzlV", "waybill": "1026846573739U", "carrierId": "DPD", "createdAt": "2025-10-06T05:16:22.272Z", "lineItems": [{"id": "240ed370-a137-11f0-8323-6df02f435f6c"}]}, {"id": "RFBEOjAwMDAwNDAwMzAyODlM", "waybill": "0000040030289L", "carrierId": "DPD", "createdAt": "2025-10-09T13:25:11Z", "lineItems": [{"id": "240ed370-a137-11f0-8323-6df02f435f6c"}]}]	\N	0.00	\N	[]	f
73	893ee8c2-a137-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 15:35:27.865	READY_FOR_PROCESSING	allegro-pl	38521102	Client:38521102	4qpl8m68vx+7b40fd458@allegromail.pl	\N	Adam Barut	+48 692 633 038	Strażacka 12	34-325	Łodygowice	PL	898bd060-a137-11f0-96eb-67f4404dbe40	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-04 15:35:27.865	\N	2025-10-09 19:41:12.644539	ONLINE	f	[{"id": "RFBEOjEwMjY5ODQ3Mjg3NjRV", "waybill": "1026984728764U", "carrierId": "DPD", "createdAt": "2025-10-07T08:52:50.912Z", "lineItems": [{"id": "89365d47-a137-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY5ODQ3Mjg4NzZV", "waybill": "1026984728876U", "carrierId": "DPD", "createdAt": "2025-10-07T08:52:51.532Z", "lineItems": [{"id": "89365d47-a137-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
91	04ed7ed0-a095-11f0-9468-2bd22967b382	\N	\N	2025-10-03 20:17:42.6	READY_FOR_PROCESSING	allegro-pl	2917271	Elnets	g0xal2lm3b+5aba6c4d2@allegromail.pl	\N	Henryk Rejek	+48 693 505 604	Wyzwolenia 119	44-321	Marklowice	PL	05288c7d-a095-11f0-a284-071dd65bf45d	PAID	PAYU	t	682.00	PLN	Allegro Kurier DPD	0.00	PLN	682.00	PLN	\N	t	\N	2025-10-03 20:17:42.6	\N	2025-10-09 19:52:23.59694	ONLINE	f	[{"id": "RFBEOjEwMjY4OTIxODY2MDRV", "waybill": "1026892186604U", "carrierId": "DPD", "createdAt": "2025-10-06T09:32:36.635Z", "lineItems": [{"id": "04e679f0-a095-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY4OTIxODY3NTdV", "waybill": "1026892186757U", "carrierId": "DPD", "createdAt": "2025-10-06T09:32:36.808Z", "lineItems": [{"id": "04e679f0-a095-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
92	ce2b1f40-a091-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-03 19:50:30.861	READY_FOR_PROCESSING	allegro-pl	4808772	renegad82	memqlt6x3g+515277702@allegromail.pl	\N	Jacek Wywrót	+48 662 272 999	Żyznów 263	38-111	Żyznów	PL	ce50d048-a091-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1057.00	PLN	Allegro Kurier DPD	0.00	PLN	1057.00	PLN	\N	t	\N	2025-10-03 19:50:30.861	\N	2025-10-09 19:52:25.112887	ONLINE	f	[{"id": "RFBEOjEwMjY4NjI0MDEwNzlV", "waybill": "1026862401079U", "carrierId": "DPD", "createdAt": "2025-10-06T06:52:41.153Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY4NjI0MDExOThV", "waybill": "1026862401198U", "carrierId": "DPD", "createdAt": "2025-10-06T06:52:41.339Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY4NjI3MDA1MjJV", "waybill": "1026862700522U", "carrierId": "DPD", "createdAt": "2025-10-06T06:54:17.210Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY4NjI3MDA2MDJV", "waybill": "1026862700602U", "carrierId": "DPD", "createdAt": "2025-10-06T06:54:17.471Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
93	931ad870-a085-11f0-ba82-ed153ccc4447	\N	\N	2025-10-03 18:20:32.809	READY_FOR_PROCESSING	allegro-pl	45755505	Client:45755505	r99ufav7hh+2270da6b7@allegromail.pl	\N	Dawid Dannheisig	+48 535 812 942	P. Teatralny 8	50-051	Wrocław	PL	978f49ec-a085-11f0-baf9-a33944a1116d	PAID	AF	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-10-03 18:20:32.809	\N	2025-10-09 19:52:26.741725	ONLINE	f	[{"id": "RFBEOjEwMjY4OTcxODMwNjdV", "waybill": "1026897183067U", "carrierId": "DPD", "createdAt": "2025-10-06T10:02:15.277Z", "lineItems": [{"id": "9315a850-a085-11f0-ba82-ed153ccc4447"}]}, {"id": "RFBEOjEwMjY4OTcxODMxMjJV", "waybill": "1026897183122U", "carrierId": "DPD", "createdAt": "2025-10-06T10:02:15.474Z", "lineItems": [{"id": "9315a850-a085-11f0-ba82-ed153ccc4447"}]}]	\N	0.00	\N	[]	f
96	6d6894b0-a07a-11f0-a6cc-b3145592fdde	\N	\N	2025-10-03 17:01:11.041	READY_FOR_PROCESSING	allegro-pl	54712970	Client:54712970	qgyp4ddcna+7cb2c9843@allegromail.pl	\N	Marta Witkowska	+48 669 763 958	Rzeczna 10	84-123	Mrzezino	PL	8c7ef55c-a07a-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	529.99	PLN	\N	f	\N	2025-10-03 17:01:11.041	\N	2025-10-09 19:52:31.15798	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5MDM3MTE0ODZV", "waybill": "1026903711486U", "carrierId": "DPD", "createdAt": "2025-10-06T10:40:16.165Z", "lineItems": [{"id": "6d5d7120-a07a-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
98	b85b60b0-a066-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-03 14:42:16.277	READY_FOR_PROCESSING	allegro-pl	5557325	emka88_2006	wr6wk7yk1j+be8ad560@allegromail.pl	\N	Magdalena Graszkiewicz	+48 783 758 905	Sokola 3a	57-401	Nowa Ruda	PL	187e20ca-a067-11f0-baf9-a33944a1116d	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	proszę o kolor hugo czarny (materiałowe siedzisko)	t	\N	2025-10-03 14:42:16.277	\N	2025-10-09 19:52:34.156421	ONLINE	f	[{"id": "RFBEOjEwMjY4NDcwOTYzMDFV", "waybill": "1026847096301U", "carrierId": "DPD", "createdAt": "2025-10-06T05:20:48.389Z", "lineItems": [{"id": "b856a5c0-a066-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7740	2ec843f0-a05b-11f0-819e-1344c439828f	\N	\N	2025-10-03 13:21:44.774	READY_FOR_PROCESSING	allegro-pl	1658455	janek_krak	v0n7y11rmi+19113f3e7@allegromail.pl	\N	Jan Sienkowski	+48 500 375 612	Osiedle Piastów 77 / 21	31-625	Kraków	PL	3eabcdbf-a05b-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	4308.80	PLN	Allegro Kurier DPD	0.00	PLN	4308.80	PLN	\N	t	\N	2025-10-03 13:21:44.774	\N	2025-10-09 19:52:37.640577	ONLINE	t	[]	Osiedle Piastów 77/21	0.00	\N	[]	f
7741	89083cb0-a058-11f0-9468-2bd22967b382	\N	\N	2025-10-03 12:57:59.387	READY_FOR_PROCESSING	allegro-pl	87515187	Client:87515187	idiv5bir5g+7382a7767@allegromail.pl	\N	Aleksandra  Nagrodzka	+48 514 638 270	Myszkowo 5/3a	82-100	Nowy Dwór Gdański	PL	90c4111f-a058-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1709.99	PLN	\N	t	\N	2025-10-03 12:57:59.387	\N	2025-10-09 19:52:39.753389	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5MDUyNTA2NzVV", "waybill": "1026905250675U", "carrierId": "DPD", "createdAt": "2025-10-06T10:49:27.778Z", "lineItems": [{"id": "89015ee0-a058-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5MDUyNTA3NjJV", "waybill": "1026905250762U", "carrierId": "DPD", "createdAt": "2025-10-06T10:49:27.926Z", "lineItems": [{"id": "89015ee0-a058-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5MDUyNTA4MjJV", "waybill": "1026905250822U", "carrierId": "DPD", "createdAt": "2025-10-06T10:49:28.078Z", "lineItems": [{"id": "89015ee0-a058-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7742	f6464f80-a056-11f0-bc87-8159fe565898	\N	\N	2025-10-03 12:47:53.849	READY_FOR_PROCESSING	allegro-pl	102760190	Client:102760190	yvns2ywksc+58b229386@allegromail.pl	\N	Tomasz Wolan	+48 788 945 389	Jana Szczeszyńskiego, 20/1	45-570	Opole	PL	f6868d78-a056-11f0-ae11-e76c74c7cf77	PAID	P24	t	1841.99	PLN	Allegro Kurier DPD	14.99	PLN	1841.99	PLN	\N	f	\N	2025-10-03 12:47:53.849	\N	2025-10-09 19:52:41.570887	ONLINE	f	[{"id": "RFBEOjEwMjY4OTE1OTA1MjNV", "waybill": "1026891590523U", "carrierId": "DPD", "createdAt": "2025-10-06T09:29:07.411Z", "lineItems": [{"id": "f63e1220-a056-11f0-bc87-8159fe565898"}]}, {"id": "RFBEOjEwMjY4OTE1OTA2MTVV", "waybill": "1026891590615U", "carrierId": "DPD", "createdAt": "2025-10-06T09:29:07.638Z", "lineItems": [{"id": "f63e1220-a056-11f0-bc87-8159fe565898"}]}, {"id": "RFBEOjEwMjY4OTE1OTA3OThV", "waybill": "1026891590798U", "carrierId": "DPD", "createdAt": "2025-10-06T09:29:07.881Z", "lineItems": [{"id": "f63e1220-a056-11f0-bc87-8159fe565898"}]}]	\N	0.00	\N	[]	f
7743	a7a598b0-a054-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-03 12:31:46.342	READY_FOR_PROCESSING	allegro-pl	25147213	irek2908	lbzf457bnc+6a83900d8@allegromail.pl	\N	Ireneusz Śniatkowski	+48 536 907 262	Łoźnica 55/5	72-110	Przybiernów	PL	a7e2a1c4-a054-11f0-a417-fd831f6ae8ec	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	tkanina obicia WE3 	t	\N	2025-10-03 12:31:46.342	\N	2025-10-09 19:52:43.152649	ONLINE	f	[{"id": "RFBEOjEwMjY4NDc2NzY0OTNV", "waybill": "1026847676493U", "carrierId": "DPD", "createdAt": "2025-10-06T05:25:32.355Z", "lineItems": [{"id": "a79e45b0-a054-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7744	19d100b0-a054-11f0-b871-03a75625f948	\N	\N	2025-10-03 12:28:30.79	READY_FOR_PROCESSING	allegro-pl	5638811	chomiczek_20	juv6uofpjb+50265e062@allegromail.pl	\N	Agnieszka Rybienik	+48 667 125 100	ul. Rogozińskiego 3/16	37-700	Przemyśl	PL	1dce1ef8-a054-11f0-91d4-7961b40d7b05	PAID	AF	t	675.00	PLN	Allegro Kurier DPD	0.00	PLN	675.00	PLN	zamiast poduszki ma byc dodatkowa pólka do szafki zgodnie z wczesniejsza rozmową	t	\N	2025-10-03 12:28:30.79	\N	2025-10-09 19:52:44.773914	ONLINE	f	[{"id": "RFBEOjEwMjY5MDIwNzkwMTJV", "waybill": "1026902079012U", "carrierId": "DPD", "createdAt": "2025-10-06T10:31:50.735Z", "lineItems": [{"id": "19cc45c1-a054-11f0-b871-03a75625f948"}, {"id": "19cc45c0-a054-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY5MDIwNzkxNTNV", "waybill": "1026902079153U", "carrierId": "DPD", "createdAt": "2025-10-06T10:31:51.114Z", "lineItems": [{"id": "19cc45c1-a054-11f0-b871-03a75625f948"}, {"id": "19cc45c0-a054-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7745	c1c0f760-a042-11f0-8c4d-9bd96e1ccd86	\N	\N	2025-10-03 10:23:41.774	READY_FOR_PROCESSING	allegro-pl	102756293	Client:102756293	wy5hfqykfd+e2cd8e96@allegromail.pl	\N	Kinga Filipek	+48 535 268 412	Spacerowa 20 C	08-530	Dęblin	PL	cb99b84e-a042-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	832.99	PLN	Kolor obicia - welur grafitowy 	t	\N	2025-10-03 10:23:41.774	\N	2025-10-09 19:52:46.497018	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY4NDQxMTgxMjhV", "waybill": "1026844118128U", "carrierId": "DPD", "createdAt": "2025-10-06T04:52:28.731Z", "lineItems": [{"id": "c1bba030-a042-11f0-8c4d-9bd96e1ccd86"}]}, {"id": "RFBEOjEwMjY4NDQxMTgyNDhV", "waybill": "1026844118248U", "carrierId": "DPD", "createdAt": "2025-10-06T04:52:28.876Z", "lineItems": [{"id": "c1bba030-a042-11f0-8c4d-9bd96e1ccd86"}]}]	\N	0.00	\N	[]	f
7746	029c0ad0-a03f-11f0-bc5e-258a5e1e619a	\N	\N	2025-10-03 10:04:06.239	READY_FOR_PROCESSING	allegro-pl	86209546	Client:86209546	s1ulppy30x+769529b61@allegromail.pl	\N	Marta Pietrańczyk	+48 665 747 821	Poręba Wielka ul. Lachetówka2	32-600	Poręba Wielka	PL	243d3433-a03f-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	615.99	PLN	\N	t	\N	2025-10-03 10:04:06.239	\N	2025-10-09 19:52:48.104858	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5MDYwMDAzMjJV", "waybill": "1026906000322U", "carrierId": "DPD", "createdAt": "2025-10-06T10:53:22.130Z", "lineItems": [{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a"}]}, {"id": "RFBEOjEwMjY5MDYwMDA0MTVV", "waybill": "1026906000415U", "carrierId": "DPD", "createdAt": "2025-10-06T10:53:22.380Z", "lineItems": [{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a"}]}, {"id": "RFBEOjEwMjcxMjg3MTMzMzBV", "waybill": "1027128713330U", "carrierId": "DPD", "createdAt": "2025-10-09T04:14:07Z", "lineItems": [{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a"}]}]	\N	0.00	\N	[]	f
7753	839dfc50-9fc8-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 19:47:53.535	READY_FOR_PROCESSING	allegro-pl	42306977	kaczmar-michal	kiuifgz4l4+3dab32400@allegromail.pl	\N	Michał Kaczmarek	+48 783 286 826	Wierzbowa 25	99-220	Wartkowice	PL	8dd3d104-9fc8-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1027.99	PLN	Proszę kolor we1 - czarny welur \nDziękuję 	t	\N	2025-10-02 19:47:53.535	\N	2025-10-09 19:52:59.035883	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3NTkxMDgxNTBV", "waybill": "1026759108150U", "carrierId": "DPD", "createdAt": "2025-10-03T11:29:05.764Z", "lineItems": [{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTkxMDgyNzBV", "waybill": "1026759108270U", "carrierId": "DPD", "createdAt": "2025-10-03T11:29:05.961Z", "lineItems": [{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTkxMDgzODNV", "waybill": "1026759108383U", "carrierId": "DPD", "createdAt": "2025-10-03T11:29:06.153Z", "lineItems": [{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7754	70857c70-9fc7-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 19:40:28.221	READY_FOR_PROCESSING	allegro-pl	111315111	MSDOMEX	tgzxg5xleh+2108d93e2@allegromail.pl	DOMEX Małgorzata Sidorowicz	MAŁGORZATA SIDOROWICZ	+48 605 991 580	SZEROKA 14	69-108	Grzmiąca	PL	70c71a0f-9fc7-11f0-ae11-e76c74c7cf77	PAID	P24	t	587.00	PLN	Allegro Kurier DPD	0.00	PLN	587.00	PLN	\N	t	\N	2025-10-02 19:40:28.221	\N	2025-10-09 19:53:00.995018	ONLINE	t	[{"id": "RFBEOjEwMjY3NTkyOTQzMThV", "waybill": "1026759294318U", "carrierId": "DPD", "createdAt": "2025-10-03T11:31:27.045Z", "lineItems": [{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTkyOTQ0MjdV", "waybill": "1026759294427U", "carrierId": "DPD", "createdAt": "2025-10-03T11:31:27.428Z", "lineItems": [{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed"}]}]	ul. Szeroka 14	0.00	\N	[]	f
7747	b3746960-a03f-11f0-8737-b36df7580750	\N	\N	2025-10-03 10:03:56.121	READY_FOR_PROCESSING	allegro-pl	101747100	Client:101747100	ocsom0y1jm+f5e57783@allegromail.pl	\N	Piotr Przybyła	+48 603 753 513	Ligonia 21	43-254	Krzyżowice	PL	ba56f527-a03f-11f0-b9a1-9fd75769370f	PAID	P24	t	1138.59	PLN	Allegro Kurier DPD	14.99	PLN	1138.59	PLN	\N	f	\N	2025-10-03 10:03:56.121	\N	2025-10-09 19:52:49.691873	ONLINE	f	[{"id": "RFBEOjEwMjY5MDczODM2NDJV", "waybill": "1026907383642U", "carrierId": "DPD", "createdAt": "2025-10-06T11:02:09.896Z", "lineItems": [{"id": "b369bb00-a03f-11f0-8737-b36df7580750"}]}, {"id": "RFBEOjEwMjY5MDczODM3NTlV", "waybill": "1026907383759U", "carrierId": "DPD", "createdAt": "2025-10-06T11:02:10.230Z", "lineItems": [{"id": "b369bb00-a03f-11f0-8737-b36df7580750"}]}, {"id": "RFBEOjEwMjY5MDczODM4OTlV", "waybill": "1026907383899U", "carrierId": "DPD", "createdAt": "2025-10-06T11:02:10.548Z", "lineItems": [{"id": "b369bb00-a03f-11f0-8737-b36df7580750"}]}]	\N	0.00	\N	[]	f
7748	933c1fe0-a034-11f0-ba82-ed153ccc4447	\N	\N	2025-10-03 08:40:57.259	READY_FOR_PROCESSING	allegro-pl	24345630	alisshiaa	dnxinr3iaf+5b6b9f046@allegromail.pl	\N	Alicja Dąbrowa	+48 663 621 355	Sowia 7B / 38	61-131	Poznań	PL	99e7e362-a034-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Czarny welur	t	\N	2025-10-03 08:40:57.259	\N	2025-10-09 19:52:51.327492	ONLINE	t	[{"id": "RFBEOjEwMjY5MDc2NjI2MDJV", "waybill": "1026907662602U", "carrierId": "DPD", "createdAt": "2025-10-06T11:04:04.116Z", "lineItems": [{"id": "93373de0-a034-11f0-ba82-ed153ccc4447"}]}]	Szara 11/2	0.00	\N	[]	f
7749	c96f6d90-a031-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-03 08:22:17.496	READY_FOR_PROCESSING	allegro-pl	20160914	mikouaj1	1i5hwzbmhh+4a1c3a682@allegromail.pl	\N	Mikołaj Kazaniecki	+48 731 340 700	Grunwaldzka 228	85-438	Bydgoszcz	PL	c9a8cd1d-a031-11f0-ae11-e76c74c7cf77	PAID	AF	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-10-03 08:22:17.496	\N	2025-10-09 19:52:52.87265	ONLINE	f	[{"id": "RFBEOjEwMjY4NDQyMDU2OTJV", "waybill": "1026844205692U", "carrierId": "DPD", "createdAt": "2025-10-06T04:53:46.751Z", "lineItems": [{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY4NDQyMDU3NzdV", "waybill": "1026844205777U", "carrierId": "DPD", "createdAt": "2025-10-06T04:53:46.899Z", "lineItems": [{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY4NDQyMDU4ODlV", "waybill": "1026844205889U", "carrierId": "DPD", "createdAt": "2025-10-06T04:53:47.040Z", "lineItems": [{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7750	0b578860-a027-11f0-93a2-8fc85806f760	\N	\N	2025-10-03 07:06:43.796	READY_FOR_PROCESSING	allegro-pl	109302475	Client:109302475	yeihtzmkr9+a66bcd39@allegromail.pl	\N	Angelika Pietryka	+48 530 402 281	Lubasz 144	33-230	Szczucin	PL	0b90250e-a027-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	Welur gładki WE1 - welur czarny 	f	\N	2025-10-03 07:06:43.796	\N	2025-10-09 19:52:54.443322	ONLINE	f	[{"id": "RFBEOjEwMjY3NTc0MDIzOTZV", "waybill": "1026757402396U", "carrierId": "DPD", "createdAt": "2025-10-03T11:08:49.658Z", "lineItems": [{"id": "0b50d1a0-a027-11f0-93a2-8fc85806f760"}]}]	\N	0.00	\N	[]	f
7751	6a50f510-a025-11f0-bc5e-258a5e1e619a	\N	\N	2025-10-03 06:55:16.511	READY_FOR_PROCESSING	allegro-pl	33582428	lukimag2012	j6abbixb7k+65be0f8f2@allegromail.pl	\N	Magdalena Pirzecka	+48 697 255 151	Przedszkolna 39	55-002	Gajków	PL	6d47ee0b-a025-11f0-ae11-e76c74c7cf77	PAID	P24	t	578.99	PLN	Allegro Kurier DPD	14.99	PLN	578.99	PLN	\N	f	\N	2025-10-03 06:55:16.511	\N	2025-10-09 19:52:56.006326	ONLINE	t	[{"id": "RFBEOjEwMjY3NTgxMDI0NzdV", "waybill": "1026758102477U", "carrierId": "DPD", "createdAt": "2025-10-03T11:17:08.447Z", "lineItems": [{"id": "6a4a1740-a025-11f0-bc5e-258a5e1e619a"}]}, {"id": "RFBEOjEwMjY3NTgxMDI1MDBV", "waybill": "1026758102500U", "carrierId": "DPD", "createdAt": "2025-10-03T11:17:08.640Z", "lineItems": [{"id": "6a4a1740-a025-11f0-bc5e-258a5e1e619a"}]}]	Poprzeczna 7	0.00	\N	[]	f
7752	a9ba08f0-9fd4-11f0-9468-2bd22967b382	\N	\N	2025-10-02 21:14:24.59	READY_FOR_PROCESSING	allegro-pl	69284867	Client:69284867	enx0syvsy1+530b352d2@allegromail.pl	\N	Anna Dirska	+48 696 843 447	Grabów Wójtostwo, 66	63-520	Grabów nad Prosną	PL	a9f69cfa-9fd4-11f0-96eb-67f4404dbe40	PAID	AF	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-10-02 21:14:24.59	\N	2025-10-09 19:52:57.528802	ONLINE	f	[{"id": "RFBEOjEwMjY3NTgyNTg5MDZV", "waybill": "1026758258906U", "carrierId": "DPD", "createdAt": "2025-10-03T11:18:54.181Z", "lineItems": [{"id": "a9b37940-9fd4-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY3NTgyNTkwNDdV", "waybill": "1026758259047U", "carrierId": "DPD", "createdAt": "2025-10-03T11:18:54.341Z", "lineItems": [{"id": "a9b37940-9fd4-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7756	a248daf0-9fc6-11f0-8c53-b9e6d89e658e	\N	\N	2025-10-02 19:35:33.148	READY_FOR_PROCESSING	allegro-pl	5408323	mariak7	1im4k5gxls+6c5ac8342@allegromail.pl	\N	janusz wojdak	+48 63 279 58 15	28 czerwca 1956 r 346 / 37	61-437	Poznań	PL	c2fc70b1-9fc6-11f0-91d4-7961b40d7b05	PAID	AF	t	346.99	PLN	Allegro Kurier DPD	14.99	PLN	346.99	PLN	\N	f	\N	2025-10-02 19:35:33.148	\N	2025-10-09 19:53:02.566909	ONLINE	f	[{"id": "RFBEOjEwMjY4NTk2NjA1OTBV", "waybill": "1026859660590U", "carrierId": "DPD", "createdAt": "2025-10-06T06:38:36.387Z", "lineItems": [{"id": "a241d610-9fc6-11f0-8c53-b9e6d89e658e"}]}]	\N	0.00	\N	[]	f
7757	91d17a80-9fbf-11f0-8234-ff8a51029ee2	\N	\N	2025-10-02 18:49:57.283	READY_FOR_PROCESSING	allegro-pl	19429620	bittersweet88	v50nej3aci+4b660d785@allegromail.pl	PRACOWNIA MOWY I ROZWOJU Sylwia Apola-Piórkowska	Sylwia Apola-Piórkowska	+48 500 470 786	Os. Gen. Maczka 8 / 25	37-100	Łańcut	PL	730e9ce8-9fc0-11f0-b9a1-9fd75769370f	PAID	P24	t	1887.00	PLN	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	\N	t	\N	2025-10-02 18:49:57.283	\N	2025-10-09 19:53:04.368113	ONLINE	f	[{"id": "RFBEOjEwMjY3NTk1MTM4NDFV", "waybill": "1026759513841U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY3NTk1MTM5MjhV", "waybill": "1026759513928U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY3NTk1MTQwNTRV", "waybill": "1026759514054U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY3NTk1MTQxMzlV", "waybill": "1026759514139U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59.063Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}]	\N	0.00	\N	[]	f
7758	42529150-9fc0-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 18:48:12.216	READY_FOR_PROCESSING	allegro-pl	42778352	Client:42778352	paojwvy2q1+3a39f6cd7@allegromail.pl	\N	Marlena Madetko	+48 784 768 389	Cyganerii 1/11	43-100	Tychy	PL	4af591e2-9fc0-11f0-a417-fd831f6ae8ec	PAID	AF	t	462.00	PLN	Allegro Kurier DPD	0.00	PLN	462.00	PLN	\N	t	\N	2025-10-02 18:48:12.216	\N	2025-10-09 19:53:05.921164	ONLINE	f	[{"id": "RFBEOjEwMjY3NTk4MTU4NjhV", "waybill": "1026759815868U", "carrierId": "DPD", "createdAt": "2025-10-03T11:37:34.766Z", "lineItems": [{"id": "424b1740-9fc0-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7759	4c292230-9fb0-11f0-b42c-9325c9d7bd4d	\N	\N	2025-10-02 16:55:22.842	READY_FOR_PROCESSING	allegro-pl	28833092	Client:28833092	mt0tvhk1n2+203983da7@allegromail.pl	\N	Aneta Lisewska	+48 781 240 436	Motorowa 2 / 23	20-214	Lublin	PL	4c48e016-9fb0-11f0-91d4-7961b40d7b05	PAID	P24	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	Dzień dobry, \nkolor siedziska TH1 (Hugo czarny)	t	\N	2025-10-02 16:55:22.842	\N	2025-10-09 19:53:07.494846	ONLINE	f	[{"id": "RFBEOjEwMjY3NjAwNjQwNDdV", "waybill": "1026760064047U", "carrierId": "DPD", "createdAt": "2025-10-03T11:40:44.277Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjEwMjY3NjAwNjQxMDJV", "waybill": "1026760064102U", "carrierId": "DPD", "createdAt": "2025-10-03T11:40:44.568Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjEwMjY3NjAwNjQyMTBV", "waybill": "1026760064210U", "carrierId": "DPD", "createdAt": "2025-10-03T11:40:44.848Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjAwMDAwMzk5NjM4MjBM", "waybill": "0000039963820L", "carrierId": "DPD", "createdAt": "2025-10-07T01:06:10Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjAwMDAwMzk5NjM4MTlM", "waybill": "0000039963819L", "carrierId": "DPD", "createdAt": "2025-10-07T01:06:10Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjAwMDAwMzk5NjM4MjFM", "waybill": "0000039963821L", "carrierId": "DPD", "createdAt": "2025-10-07T01:06:10Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}]	\N	0.00	\N	[]	f
7760	7862c470-9fae-11f0-8d27-959e7a05a75b	\N	\N	2025-10-02 16:41:42.725	READY_FOR_PROCESSING	allegro-pl	27710761	Liptoniasty2	aqph54wcwg+134c4d741@allegromail.pl	\N	Łukasz Kozłowski	+48 515 540 144	Polanka 4A/7	65-557	Zielona Góra	PL	9054af0d-9fae-11f0-b9a1-9fd75769370f	PAID	P24	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	obicie TH3	t	\N	2025-10-02 16:41:42.725	\N	2025-10-09 19:53:08.982673	ONLINE	f	[{"id": "RFBEOjEwMjY3NjAyMTQwNzFV", "waybill": "1026760214071U", "carrierId": "DPD", "createdAt": "2025-10-03T11:42:53.912Z", "lineItems": [{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b"}]}, {"id": "RFBEOjEwMjY3NjAyMTQxNTBV", "waybill": "1026760214150U", "carrierId": "DPD", "createdAt": "2025-10-03T11:42:54.079Z", "lineItems": [{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b"}]}, {"id": "RFBEOjEwMjY3NjAyMTQyNzBV", "waybill": "1026760214270U", "carrierId": "DPD", "createdAt": "2025-10-03T11:42:54.229Z", "lineItems": [{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b"}]}]	\N	0.00	\N	[]	f
7761	c8cc0a70-9fa9-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-02 16:08:09.378	READY_FOR_PROCESSING	allegro-pl	635300	Daurel	kqvtg3o370+b134a927@allegromail.pl	\N	Dariusz Brzeziński	+48 739 114 959	Wyszyńskiego 8/25	72-010	Police	PL	ec459dd2-9fa9-11f0-b9a1-9fd75769370f	PAID	AF	t	1015.00	PLN	Allegro Kurier DPD	0.00	PLN	1015.00	PLN	\N	t	\N	2025-10-02 16:08:09.378	\N	2025-10-09 19:53:10.465002	ONLINE	f	[{"id": "RFBEOjEwMjY3NjA0NDg2MDZV", "waybill": "1026760448606U", "carrierId": "DPD", "createdAt": "2025-10-03T11:45:54.012Z", "lineItems": [{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52"}]}, {"id": "RFBEOjEwMjY3NjA0NDg3NjdV", "waybill": "1026760448767U", "carrierId": "DPD", "createdAt": "2025-10-03T11:45:54.252Z", "lineItems": [{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52"}]}]	\N	0.00	\N	[]	f
7762	035de560-9fa9-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 16:03:59.187	READY_FOR_PROCESSING	allegro-pl	3345412	Radeon17	khljf2z29f+6062af054@allegromail.pl	\N	Radkowiak Piotr	+48 733 706 707	Krężnicka 132	20-518	Lublin	PL	3d0c975d-9fa9-11f0-ae11-e76c74c7cf77	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	proszę o zamieszczenie informacji dla kuriera z prośbą o kontakt przed dostawą 	t	\N	2025-10-02 16:03:59.187	\N	2025-10-09 19:53:11.994259	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMxNjk5NzFV", "waybill": "1026723169971U", "carrierId": "DPD", "createdAt": "2025-10-03T04:56:40.248Z", "lineItems": [{"id": "0356e080-9fa9-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3MjMxNzAwMTZV", "waybill": "1026723170016U", "carrierId": "DPD", "createdAt": "2025-10-03T04:56:40.384Z", "lineItems": [{"id": "0356e080-9fa9-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7763	e451b440-9fa7-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-02 15:54:31.739	READY_FOR_PROCESSING	allegro-pl	28499563	Client:28499563	thufsgebxx+254e94209@allegromail.pl	\N	Sławomir Szymański	+48 512 270 599	Dworcowa 19	66-010	Nowogród Bobrzański	PL	e48bd752-9fa7-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	\N	f	\N	2025-10-02 15:54:31.739	\N	2025-10-09 19:53:13.524776	ONLINE	f	[{"id": "RFBEOjEwMjY3MjY4NzY0MDFV", "waybill": "1026726876401U", "carrierId": "DPD", "createdAt": "2025-10-03T05:56:32Z", "lineItems": [{"id": "e44aaf60-9fa7-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7764	e194c910-9fa5-11f0-ad8a-5d9c081a41b2	\N	\N	2025-10-02 15:39:27.043	READY_FOR_PROCESSING	allegro-pl	38104675	Client:38104675	xw92u2cusv+55d4ad069@allegromail.pl	\N	Lucyna Paszkiewicz	+48 726 005 987	Krzemień Pierwszy 90	23-304	Krzemień	PL	f4e0aa8c-9fa5-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	686.99	PLN	\N	t	\N	2025-10-02 15:39:27.043	\N	2025-10-09 19:53:15.032791	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3NjA2NTA1ODlV", "waybill": "1026760650589U", "carrierId": "DPD", "createdAt": "2025-10-03T11:48:21.799Z", "lineItems": [{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2"}]}, {"id": "RFBEOjEwMjY3NjA2NTA2ODFV", "waybill": "1026760650681U", "carrierId": "DPD", "createdAt": "2025-10-03T11:48:21.995Z", "lineItems": [{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2"}]}]	\N	0.00	\N	[]	f
7765	87ed6070-9fa0-11f0-89e4-21adac12f2a9	\N	\N	2025-10-02 15:02:38.412	READY_FOR_PROCESSING	allegro-pl	5293089	Metalsiwy	4xojs4byyg+412915c51@allegromail.pl	SWIM TEAM TOMASZ SIEWIOR	Tomasz Siewior	+48 502 181 354	Willowa, 5	32-620	Brzeszcze	PL	96db3f6a-9fa0-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-02 15:02:38.412	\N	2025-10-09 19:53:16.741965	ONLINE	t	[{"id": "RFBEOjEwMjY3MjY5Mjg5NDFV", "waybill": "1026726928941U", "carrierId": "DPD", "createdAt": "2025-10-03T05:57:13.735Z", "lineItems": [{"id": "87e8a580-9fa0-11f0-89e4-21adac12f2a9"}]}]	Willowa, 5	0.00	\N	[]	f
7766	65161d90-9f9f-11f0-8234-ff8a51029ee2	\N	\N	2025-10-02 14:54:36.104	READY_FOR_PROCESSING	allegro-pl	43066770	Moderato12	l6kf8t4c08+1de21ac67@allegromail.pl	\N	Janina Borejko	+48 792 659 021	ul. Rolna 2	49-340	Lewin Brzeski	PL	6a25e461-9f9f-11f0-b9a1-9fd75769370f	PAID	P24	t	478.00	PLN	Allegro Kurier DPD	0.00	PLN	478.00	PLN	\N	t	\N	2025-10-02 14:54:36.104	\N	2025-10-09 19:53:18.25358	ONLINE	t	[{"id": "RFBEOjEwMjY3MjMwOTQwNjZV", "waybill": "1026723094066U", "carrierId": "DPD", "createdAt": "2025-10-03T04:54:33Z", "lineItems": [{"id": "651189b0-9f9f-11f0-8234-ff8a51029ee2"}]}]	ul. Rolna 2	0.00	\N	[]	f
7767	ed2acaf0-9f9a-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 14:23:38.566	READY_FOR_PROCESSING	allegro-pl	107500864	Client:107500864	qmyeuzwelc+3458e5b4@allegromail.pl	\N	Renata Woźniak	+48 796 277 800	Bohaterów Studzienek 3/20	26-670	Pionki	PL	363363a4-9f9b-11f0-b9a1-9fd75769370f	PAID	P24	t	787.99	PLN	Allegro Kurier DPD	14.99	PLN	787.99	PLN	\N	f	\N	2025-10-02 14:23:38.566	\N	2025-10-09 19:53:19.823755	ONLINE	f	[{"id": "RFBEOjEwMjY3NTc5ODk5OTJV", "waybill": "1026757989992U", "carrierId": "DPD", "createdAt": "2025-10-03T11:15:45.481Z", "lineItems": [{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTc5OTAwNjNV", "waybill": "1026757990063U", "carrierId": "DPD", "createdAt": "2025-10-03T11:15:45.738Z", "lineItems": [{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7768	c0eec9a0-9f9a-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 14:20:44.648	READY_FOR_PROCESSING	allegro-pl	40005232	Client:40005232	qa9kmztunx+7456f90a6@allegromail.pl	\N	Ewelina Kowalska	+48 572 944 921	Wysocice 120	32-075	Gołcza	PL	c1306683-9f9a-11f0-a284-071dd65bf45d	PAID	P24	t	2012.98	PLN	Allegro Kurier DPD	29.98	PLN	2012.98	PLN	Kolor uchwytów: U1 czarny \nObicie siedziska:F04 Fjord Czarny	f	\N	2025-10-02 14:20:44.648	\N	2025-10-09 19:53:21.391471	ONLINE	f	[{"id": "RFBEOjEwMjY3NTcwNzM4NDhV", "waybill": "1026757073848U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:44.950Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzM5OTNV", "waybill": "1026757073993U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.127Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzQwMTFV", "waybill": "1026757074011U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.295Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzQxNTBV", "waybill": "1026757074150U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.459Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzQyNDJV", "waybill": "1026757074242U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.630Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7769	2f4e0e71-9f9a-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-02 14:15:45.56	READY_FOR_PROCESSING	allegro-pl	41766359	Talaxo	dq2itggs7l+23d6608d1@allegromail.pl	\N	Natalia Nowacka 	+48 535 440 934	Wrzesiny 16	98-160	Sędziejowice	PL	2f8af11a-9f9a-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	966.00	PLN	Allegro Kurier DPD	0.00	PLN	966.00	PLN	\N	t	\N	2025-10-02 14:15:45.56	\N	2025-10-09 19:53:23.050134	ONLINE	f	[{"id": "RFBEOjEwMjY3Mjc1MDU0ODNV", "waybill": "1026727505483U", "carrierId": "DPD", "createdAt": "2025-10-03T06:04:41.299Z", "lineItems": [{"id": "2f47cce2-9f9a-11f0-96ea-bf4f56b08af2"}, {"id": "2f47cce1-9f9a-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY3Mjc1MDU1NzBV", "waybill": "1026727505570U", "carrierId": "DPD", "createdAt": "2025-10-03T06:04:41.488Z", "lineItems": [{"id": "2f47cce2-9f9a-11f0-96ea-bf4f56b08af2"}, {"id": "2f47cce1-9f9a-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7770	ec7230b0-9f97-11f0-86d6-599d2223cd68	\N	\N	2025-10-02 13:59:36.392	READY_FOR_PROCESSING	allegro-pl	38728891	PedzacyKefir	pvdiaqhto6+1305df571@allegromail.pl	\N	Marcin Zdanowicz	+48 515 750 925	Aleja wojska Polskiego 16 / 34	05-800	Pruszków	PL	ecaddadc-9f97-11f0-ae11-e76c74c7cf77	PAID	AF	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	\N	f	\N	2025-10-02 13:59:36.392	\N	2025-10-09 19:53:24.66678	ONLINE	f	[{"id": "RFBEOjEwMjY3MjY5OTM1NjNV", "waybill": "1026726993563U", "carrierId": "DPD", "createdAt": "2025-10-03T05:58:14Z", "lineItems": [{"id": "ec69f350-9f97-11f0-86d6-599d2223cd68"}]}]	\N	0.00	\N	[]	f
7771	2204e780-9f67-11f0-a6ba-19e7472c74e3	\N	\N	2025-10-02 08:11:23.232	READY_FOR_PROCESSING	allegro-pl	5109587	arturkrotka	wskj9r4jus+5d06526@allegromail.pl	\N	Artur Gawin	+48 602 589 003	Elizy Orzeszkowej 1	77-141	Borzytuchom	PL	5604aca1-9f67-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-02 08:11:23.232	\N	2025-10-09 19:53:26.173347	ONLINE	f	[{"id": "RFBEOjEwMjY3NjEzMjQ1MzVV", "waybill": "1026761324535U", "carrierId": "DPD", "createdAt": "2025-10-03T11:56:33.474Z", "lineItems": [{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3"}]}, {"id": "RFBEOjEwMjY3NjEzMjQ2MTVV", "waybill": "1026761324615U", "carrierId": "DPD", "createdAt": "2025-10-03T11:56:33.636Z", "lineItems": [{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3"}]}]	\N	0.00	\N	[]	f
7772	b004e730-9f65-11f0-8234-ff8a51029ee2	\N	\N	2025-10-02 08:01:05.199	READY_FOR_PROCESSING	allegro-pl	11552489	aisaK-a89	v5hok3hu4u+47b75c675@allegromail.pl	\N	Katarzyna Taudul	+48 531 655 643	ul. Kawaleryjska 70/50 m.4	15-601	Białystok	PL	b2a3fc54-9f65-11f0-b9a1-9fd75769370f	PAID	AF	t	1016.00	PLN	Allegro Kurier DPD	0.00	PLN	1016.00	PLN	\N	t	\N	2025-10-02 08:01:05.199	\N	2025-10-09 19:53:27.696527	ONLINE	f	[{"id": "RFBEOjEwMjY4NDEwMDMwMTRV", "waybill": "1026841003014U", "carrierId": "DPD", "createdAt": "2025-10-06T04:04:02.826Z", "lineItems": [{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY4NDEwMDMxNzFV", "waybill": "1026841003171U", "carrierId": "DPD", "createdAt": "2025-10-06T04:04:02.973Z", "lineItems": [{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2"}]}]	\N	0.00	\N	[]	f
7773	2bf328a0-9f63-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 07:41:45.493	READY_FOR_PROCESSING	allegro-pl	3283491	shadow_ss	dk25cwns07+1262475f1@allegromail.pl	\N	Piotr Karolewski	+48 661 367 643	Srebrna 9/6	26-800	Białobrzegi	PL	2c2f47c5-9f63-11f0-96eb-67f4404dbe40	PAID	PAYU	t	523.00	PLN	Allegro Kurier DPD	0.00	PLN	523.00	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-10-02 07:41:45.493	\N	2025-10-09 19:53:29.220197	ONLINE	f	[{"id": "RFBEOjEwMjY4NDExMTY2ODFV", "waybill": "1026841116681U", "carrierId": "DPD", "createdAt": "2025-10-06T04:06:17.054Z", "lineItems": [{"id": "2beb8780-9f63-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7774	8a61c600-9f57-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 06:54:16.539	READY_FOR_PROCESSING	allegro-pl	138276228	Client:138276228	iom6rn67ws+3696c7f8@allegromail.pl	\N	Violetta Jarosz	+48 730 800 004	Daszyńskiego 2 / 11	59-220	Legnica	PL	7725a9e9-9f5c-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	792.99	PLN	EP2 PIK Czarny	f	\N	2025-10-02 06:54:16.539	\N	2025-10-09 19:53:30.70906	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3NTc2MTk5NzFV", "waybill": "1026757619971U", "carrierId": "DPD", "createdAt": "2025-10-03T11:11:31.471Z", "lineItems": [{"id": "8a5ac120-9f57-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTc2MjAwNDVV", "waybill": "1026757620045U", "carrierId": "DPD", "createdAt": "2025-10-03T11:11:31.684Z", "lineItems": [{"id": "8a5ac120-9f57-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7779	7cab93f0-9ef9-11f0-a910-6fc8854d80a9	\N	\N	2025-10-01 19:21:16.193	READY_FOR_PROCESSING	allegro-pl	19591819	Joanna0531	lfyotcu4q7+71f6d02a9@allegromail.pl	\N	Joanna Glonka	+48 602 333 941	pl.Świętej Barbary 4 / 2	41-902	Bytom	PL	9fa8568f-9ef9-11f0-ae11-e76c74c7cf77	PAID	P24	t	454.00	PLN	Allegro Kurier DPD	0.00	PLN	454.00	PLN	\N	t	\N	2025-10-01 19:21:16.193	\N	2025-10-09 19:56:36.504283	ONLINE	f	[{"id": "RFBEOjEwMjY2NDA0MjYwNTlV", "waybill": "1026640426059U", "carrierId": "DPD", "createdAt": "2025-10-02T04:38:33.447Z", "lineItems": [{"id": "7ca46800-9ef9-11f0-a910-6fc8854d80a9"}]}]	\N	0.00	\N	[]	f
7781	19377490-9efb-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 19:17:24.913	READY_FOR_PROCESSING	allegro-pl	68399891	Client:68399891	scbkxp9q8b+14253f064@allegromail.pl	\N	Beata Kozioł	+48 507 976 102	Wiśniowa Góra, Konopnickiej 31/2	95-020	Andrespol	PL	195dc155-9efb-11f0-baf9-a33944a1116d	PAID	P24	t	600.00	PLN	Allegro Kurier DPD	0.00	PLN	600.00	PLN	\N	t	\N	2025-10-01 19:17:24.913	\N	2025-10-09 19:56:39.284741	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMyNzI5MjFV", "waybill": "1026723272921U", "carrierId": "DPD", "createdAt": "2025-10-03T04:59:02.627Z", "lineItems": [{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY3MjMyNzMwMjhV", "waybill": "1026723273028U", "carrierId": "DPD", "createdAt": "2025-10-03T04:59:02.771Z", "lineItems": [{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjcwMDE5Mjk3NTBV", "waybill": "1027001929750U", "carrierId": "DPD", "createdAt": "2025-10-07T11:01:58Z", "lineItems": [{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7782	506a6d11-9efa-11f0-a6cc-b3145592fdde	\N	\N	2025-10-01 19:14:35.051	READY_FOR_PROCESSING	allegro-pl	50385363	Client:50385363	ufp90cv84u+676d54f17@allegromail.pl	\N	Szymon Grześkowiak	+48 697 597 277	Wiśniowa 67	62-300	Września	PL	50ab6e2a-9efa-11f0-96eb-67f4404dbe40	PAID	AF	t	689.00	PLN	Allegro Kurier DPD	0.00	PLN	689.00	PLN	Czarny welur 	t	\N	2025-10-01 19:14:35.051	\N	2025-10-09 19:56:40.880156	ONLINE	f	[{"id": "RFBEOjEwMjY2ODA2MTA2MDVV", "waybill": "1026680610605U", "carrierId": "DPD", "createdAt": "2025-10-02T10:23:54.200Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY2ODA2MTA3MjhV", "waybill": "1026680610728U", "carrierId": "DPD", "createdAt": "2025-10-02T10:23:54.379Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY2ODA3NDE2NDFV", "waybill": "1026680741641U", "carrierId": "DPD", "createdAt": "2025-10-02T10:24:55.871Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY2ODA3NDE3OTZV", "waybill": "1026680741796U", "carrierId": "DPD", "createdAt": "2025-10-02T10:24:56.086Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7783	9c74d050-9ef6-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-01 19:10:15.625	CANCELLED	allegro-pl	22091132	andygut	vs638z6rka+1f95337f8@allegromail.pl	\N	Adrian Chyła	+48 691 323 822	\N	\N	\N	\N	bf3db0f4-9ef6-11f0-b9a1-9fd75769370f	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	\N	t	\N	2025-10-01 19:00:32.188	\N	2025-10-09 19:56:42.365344	ONLINE	f	[]	\N	0.00	\N	[]	f
7784	a6a4ce00-9ef5-11f0-817a-fb3753e68c2d	\N	\N	2025-10-01 18:38:22.736	READY_FOR_PROCESSING	allegro-pl	46790604	Client:46790604	htzlyqf5at+474ba4059@allegromail.pl	\N	Rita KNIEJA	+48 881 961 187	Lubieszów 68 / 2	67-100	Lubieszów	PL	a6e3373d-9ef5-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	kolor WE 3 WELUR GRAFITOWY 	t	\N	2025-10-01 18:38:22.736	\N	2025-10-09 19:56:43.629286	ONLINE	f	[{"id": "RFBEOjEwMjY2NDUwMjA4ODBV", "waybill": "1026645020880U", "carrierId": "DPD", "createdAt": "2025-10-02T05:41:51.531Z", "lineItems": [{"id": "a69df030-9ef5-11f0-817a-fb3753e68c2d"}]}]	\N	0.00	\N	[]	f
7785	a07eb210-9ef1-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 18:09:17.432	READY_FOR_PROCESSING	allegro-pl	26814807	SylwesterMical	id90bp4yxj+63aaae8d2@allegromail.pl	\N	Sylwester MIcał	+48 696 167 721	ul. Leśne Wzgórze 59	35-213	Rzeszów	PL	a0a1cb6e-9ef1-11f0-baf9-a33944a1116d	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-01 18:09:17.432	\N	2025-10-09 19:56:45.005664	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMzMTc5NDNV", "waybill": "1026723317943U", "carrierId": "DPD", "createdAt": "2025-10-03T05:00:05.271Z", "lineItems": [{"id": "a0795ae0-9ef1-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7786	9eabe350-9ef0-11f0-88a7-41bf7e4bf551	\N	\N	2025-10-01 18:04:12.547	READY_FOR_PROCESSING	allegro-pl	65926053	Client:65926053	ob09t2bsie+5c88df214@allegromail.pl	\N	Grzegorz Górski	+48 663 840 949	Braci Gładyszów 15	32-830	Wojnicz	PL	9eed330c-9ef0-11f0-ae11-e76c74c7cf77	PAID	P24	t	773.00	PLN	Allegro Kurier DPD	0.00	PLN	773.00	PLN	siedzisko będzie w kolorze eko skóra pikowana czarna (EP2)	t	\N	2025-10-01 18:04:12.547	\N	2025-10-09 19:56:46.384312	ONLINE	f	[{"id": "RFBEOjEwMjY2ODg5MjkxMDRV", "waybill": "1026688929104U", "carrierId": "DPD", "createdAt": "2025-10-02T11:33:01.446Z", "lineItems": [{"id": "9ea46940-9ef0-11f0-88a7-41bf7e4bf551"}]}, {"id": "RFBEOjEwMjY2ODg5MjkyMTJV", "waybill": "1026688929212U", "carrierId": "DPD", "createdAt": "2025-10-02T11:33:01.657Z", "lineItems": [{"id": "9ea46940-9ef0-11f0-88a7-41bf7e4bf551"}]}]	\N	0.00	\N	[]	f
7788	302ccc60-9eef-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 17:54:46.635	READY_FOR_PROCESSING	allegro-pl	107302999	czarnula1209	v916ka0frn+3198b7d99@allegromail.pl	\N	Klaudia Piotrowska	+48 795 625 932	Gustawa Morcinka 9 / 33	41-303	Dąbrowa Górnicza	PL	a13431a4-9eef-11f0-ae11-e76c74c7cf77	PAID	P24	t	1136.00	PLN	Allegro Kurier DPD	0.00	PLN	1136.00	PLN	\N	t	\N	2025-10-01 17:54:46.635	\N	2025-10-09 19:56:49.168469	ONLINE	f	[{"id": "RFBEOjEwMjY2ODc2OTM4ODBV", "waybill": "1026687693880U", "carrierId": "DPD", "createdAt": "2025-10-02T11:23:07.708Z", "lineItems": [{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314"}]}, {"id": "RFBEOjEwMjY2ODc2OTM5NjFV", "waybill": "1026687693961U", "carrierId": "DPD", "createdAt": "2025-10-02T11:23:07.928Z", "lineItems": [{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314"}]}, {"id": "RFBEOjEwMjY2ODc2OTQwNzVV", "waybill": "1026687694075U", "carrierId": "DPD", "createdAt": "2025-10-02T11:23:08.139Z", "lineItems": [{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7789	0999c490-9eef-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 17:53:21.613	READY_FOR_PROCESSING	allegro-pl	101260963	Client:101260963	wyt1s80a8q+76769ace2@allegromail.pl	\N	Małgorzata Jankiewicz	+48 505 996 385	Fałata 20a / 3	41-902	Bytom	PL	09c123ae-9eef-11f0-baf9-a33944a1116d	PAID	AF	t	930.00	PLN	Allegro Kurier DPD	0.00	PLN	930.00	PLN	Siedzisko eko skóra pikowana czarna	t	\N	2025-10-01 17:53:21.613	\N	2025-10-09 19:56:50.506069	ONLINE	f	[{"id": "RFBEOjEwMjY2NzM5NTMzMzVV", "waybill": "1026673953335U", "carrierId": "DPD", "createdAt": "2025-10-02T09:29:17.786Z", "lineItems": [{"id": "099509a0-9eef-11f0-96ea-bf4f56b08af2"}, {"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY2NzM5NTM0NzBV", "waybill": "1026673953470U", "carrierId": "DPD", "createdAt": "2025-10-02T09:29:17.961Z", "lineItems": [{"id": "099509a0-9eef-11f0-96ea-bf4f56b08af2"}, {"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7790	d9e76130-9eee-11f0-b465-492415e4339b	\N	\N	2025-10-01 18:00:04.378	READY_FOR_PROCESSING	allegro-pl	35269963	dzikaroza3	4jqbinao0j+28f8a2ae5@allegromail.pl	F.H.KWIACIARNIA 'DZIKA RÓŻA'	Izabela Stalka	+48 514 356 225	Ul.Woźnicka 200	42-350	Koziegłowy	PL	0cef8a0e-9ef0-11f0-baf9-a33944a1116d	PAID	AF	t	75.00	PLN	Allegro Kurier DPD	0.00	PLN	75.00	PLN	WE1 - Welur Czarny	t	\N	2025-10-01 18:00:04.378	\N	2025-10-09 19:56:51.957313	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMzOTE0NDRV", "waybill": "1026723391444U", "carrierId": "DPD", "createdAt": "2025-10-03T05:01:31.763Z", "lineItems": [{"id": "d9e03540-9eee-11f0-b465-492415e4339b"}]}]	\N	0.00	\N	[]	f
7792	304bca40-9ee8-11f0-a30a-89acbba18695	\N	\N	2025-10-01 17:02:46.929	READY_FOR_PROCESSING	allegro-pl	71921502	Client:71921502	n3fe5g711b+4a2157fd9@allegromail.pl	\N	Diana Kolomiichuk	+48 509 832 529	Dębicka 303 / F/1	35-213	Rzeszów	PL	307599dd-9ee8-11f0-91d4-7961b40d7b05	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-01 17:02:46.929	\N	2025-10-09 19:56:54.685248	ONLINE	f	[{"id": "RFBEOjEwMjY3MjM3NzgwNTlV", "waybill": "1026723778059U", "carrierId": "DPD", "createdAt": "2025-10-03T05:09:06.868Z", "lineItems": [{"id": "3046e840-9ee8-11f0-a30a-89acbba18695"}]}, {"id": "RFBEOjEwMjY3MjM3NzgxMTRV", "waybill": "1026723778114U", "carrierId": "DPD", "createdAt": "2025-10-03T05:09:07.069Z", "lineItems": [{"id": "3046e840-9ee8-11f0-a30a-89acbba18695"}]}, {"id": "RFBEOjEwMjY3NDI0Njg0MTRV", "waybill": "1026742468414U", "carrierId": "DPD", "createdAt": "2025-10-03T08:34:29.341Z", "lineItems": [{"id": "3046e840-9ee8-11f0-a30a-89acbba18695"}]}]	\N	0.00	\N	[]	f
7793	1c67b9d0-9ee3-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 16:25:13.526	READY_FOR_PROCESSING	allegro-pl	6623235	wujekadam	bqey5g7z77+4b0623c62@allegromail.pl	\N	Adam Parus	+48 502 258 712	Ofiar Katynia 21 / 2	55-120	Oborniki Śląskie	PL	1c8b966b-9ee3-11f0-b9a1-9fd75769370f	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-01 16:25:13.526	\N	2025-10-09 19:56:56.000052	ONLINE	f	[{"id": "RFBEOjEwMjY2NDYxNDAyMTdV", "waybill": "1026646140217U", "carrierId": "DPD", "createdAt": "2025-10-02T05:53:13.338Z", "lineItems": [{"id": "1c637410-9ee3-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7803	3099f270-9eb5-11f0-8bdf-5dc6c72e14d7	\N	\N	2025-10-01 10:59:25.107	READY_FOR_PROCESSING	allegro-pl	116353712	Client:116353712	ozyn5gq59j+79d4f49d4@allegromail.pl	\N	Martyna Pasionek	+48 609 158 519	Witkow 46	59-225	Witków	PL	30dd3d3b-9eb5-11f0-96eb-67f4404dbe40	PAID	P24	t	704.00	PLN	Allegro Kurier DPD	0.00	PLN	704.00	PLN	\N	t	\N	2025-10-01 10:59:25.107	\N	2025-10-09 19:57:09.349826	ONLINE	f	[{"id": "RFBEOjEwMjY3MjI1MjkxODdV", "waybill": "1026722529187U", "carrierId": "DPD", "createdAt": "2025-10-03T04:39:16.091Z", "lineItems": [{"id": "30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7"}]}, {"id": "RFBEOjEwMjY3MjI1MjkyMDdV", "waybill": "1026722529207U", "carrierId": "DPD", "createdAt": "2025-10-03T04:39:16.300Z", "lineItems": [{"id": "30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7"}]}]	\N	0.00	\N	[]	f
7804	40166730-9eb3-11f0-908e-ff3baa2fe7b0	\N	\N	2025-10-01 10:44:31.351	READY_FOR_PROCESSING	allegro-pl	103485438	Client:103485438	1do8y5rubi+32e3b9525@allegromail.pl	\N	Elżbieta Józiak	+48 600 023 695	Polnej Róży 1 / 1201	02-798	Warszawa	PL	405963b5-9eb3-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Tapicerka WE2	t	\N	2025-10-01 10:44:31.351	\N	2025-10-09 19:57:10.639494	ONLINE	f	[{"id": "RFBEOjEwMjY2NTY2MjkyMDdV", "waybill": "1026656629207U", "carrierId": "DPD", "createdAt": "2025-10-02T07:15:29.805Z", "lineItems": [{"id": "400f1430-9eb3-11f0-908e-ff3baa2fe7b0"}]}]	\N	0.00	\N	[]	f
7795	a8520470-9ed7-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-01 15:03:16.27	READY_FOR_PROCESSING	allegro-pl	137085688	Client:137085688	ct3fpa5e6b+8159e667@allegromail.pl	\N	Aleksandra Piotrowska	+48 795 659 810	Skałka 54	26-065	Piekoszów	PL	b98e3feb-9ed7-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	756.99	PLN	\N	f	\N	2025-10-01 15:03:16.27	\N	2025-10-09 19:56:58.835539	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2NzU1MDAzODhV", "waybill": "1026675500388U", "carrierId": "DPD", "createdAt": "2025-10-02T09:41:56.790Z", "lineItems": [{"id": "a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY2NzU1MDA0ODlV", "waybill": "1026675500489U", "carrierId": "DPD", "createdAt": "2025-10-02T09:41:56.956Z", "lineItems": [{"id": "a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7796	38ccaba0-9ed7-11f0-a7f2-a59be15353c3	\N	\N	2025-10-01 15:00:04.549	READY_FOR_PROCESSING	allegro-pl	119183446	Client:119183446	c2fb0535yk+45758d0a6@allegromail.pl	\N	Iwona Toczko	+48 667 864 617	Ogrodowa 8	21-200	Parczew	PL	390918f4-9ed7-11f0-ae11-e76c74c7cf77	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-01 15:00:04.549	\N	2025-10-09 19:57:00.131947	ONLINE	f	[{"id": "RFBEOjEwMjY2NTA3Nzk0NThV", "waybill": "1026650779458U", "carrierId": "DPD", "createdAt": "2025-10-02T06:31:48.747Z", "lineItems": [{"id": "38c53190-9ed7-11f0-a7f2-a59be15353c3"}]}, {"id": "RFBEOjEwMjY2NTA3Nzk1NDNV", "waybill": "1026650779543U", "carrierId": "DPD", "createdAt": "2025-10-02T06:31:48.970Z", "lineItems": [{"id": "38c53190-9ed7-11f0-a7f2-a59be15353c3"}]}]	\N	0.00	\N	[]	f
7797	10ac49e0-9ed3-11f0-a0f2-ad990a13a62d	\N	\N	2025-10-01 14:31:32.941	READY_FOR_PROCESSING	allegro-pl	38111450	Client:38111450	g4fufv360p+1c1751256@allegromail.pl	\N	Adrian Rugieł	+48 796 405 178	J.Narodowej 91 U1	50-301	Wrocław	PL	1a1c84a3-9ed3-11f0-96eb-67f4404dbe40	PAID	P24	t	434.00	PLN	Allegro Kurier DPD	0.00	PLN	434.00	PLN	\N	t	\N	2025-10-01 14:31:32.941	\N	2025-10-09 19:57:01.41938	ONLINE	t	[{"id": "RFBEOjEwMjY3MjM4MjgwNTZV", "waybill": "1026723828056U", "carrierId": "DPD", "createdAt": "2025-10-03T05:10:11.110Z", "lineItems": [{"id": "10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d"}]}]	Ul. Jedności Narodowej 91/ U1	0.00	\N	[]	f
7798	d60883b0-9eca-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-01 13:31:32.411	READY_FOR_PROCESSING	allegro-pl	5119788	m-a-x-	44jwdnwe0h+417221383@allegromail.pl	\N	Adam Turek	+48 507 306 509	Kęsy Pańki 4a	06-126	Gzy	PL	ee30e77f-9eca-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	475.99	PLN	\N	t	\N	2025-10-01 13:31:32.411	\N	2025-10-09 19:57:02.766441	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3MjM4NzYzMjhV", "waybill": "1026723876328U", "carrierId": "DPD", "createdAt": "2025-10-03T05:11:03Z", "lineItems": [{"id": "d603c8c0-9eca-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
7799	e55fb2a0-9ec7-11f0-a30a-89acbba18695	\N	\N	2025-10-01 13:12:02.448	READY_FOR_PROCESSING	allegro-pl	5847359	aniagorkaa	m3oqntbmdu+1d8e3ac94@allegromail.pl	\N	Anna Górczyńska	+48 609 450 375	Uczniowska 1	81-647	Gdynia	PL	e581e136-9ec7-11f0-b9a1-9fd75769370f	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	TH3 - Tkanina Hugo Grafitowy	t	\N	2025-10-01 13:12:02.448	\N	2025-10-09 19:57:04.087597	ONLINE	f	[{"id": "RFBEOjEwMjY3MjM5MTg0NDBV", "waybill": "1026723918440U", "carrierId": "DPD", "createdAt": "2025-10-03T05:11:54Z", "lineItems": [{"id": "e55ad0a0-9ec7-11f0-a30a-89acbba18695"}]}]	\N	0.00	\N	[]	f
7800	cf3fa2a0-9ec7-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-01 13:10:57.884	READY_FOR_PROCESSING	allegro-pl	135752837	Client:135752837	oefimlg8do+3d1860066@allegromail.pl	\N	Olga Kłos-Drozdowicz	+48 664 585 684	Bukowskiego 7 / 71	03-982	Warszawa	PL	e99ce780-9ec7-11f0-96eb-67f4404dbe40	PAID	AF	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	Kolor tkaniny:  TH4	f	\N	2025-10-01 13:10:57.884	\N	2025-10-09 19:57:05.397666	ONLINE	f	[{"id": "RFBEOjEwMjY2NTA3Mjg3NjdV", "waybill": "1026650728767U", "carrierId": "DPD", "createdAt": "2025-10-02T06:31:21.744Z", "lineItems": [{"id": "cf384fa0-9ec7-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7801	4dc92860-9ec5-11f0-9e10-59ae2eaec9de	\N	\N	2025-10-01 12:51:19.449	READY_FOR_PROCESSING	allegro-pl	125907554	Client:125907554	a9lhcbetoa+2738a9c01@allegromail.pl	\N	Anna Rak	+48 531 804 432	Wieniawskiego 55 / zd	35-330	Rzeszów	PL	4df5b714-9ec5-11f0-a284-071dd65bf45d	PAID	PAYU	t	1333.99	PLN	Allegro Kurier DPD	14.99	PLN	1333.99	PLN	\N	f	\N	2025-10-01 12:51:19.449	\N	2025-10-09 19:57:06.705213	ONLINE	f	[{"id": "RFBEOjEwMjY2NzU2NTg1NTFV", "waybill": "1026675658551U", "carrierId": "DPD", "createdAt": "2025-10-02T09:43:17.424Z", "lineItems": [{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NzU2NTg2NTlV", "waybill": "1026675658659U", "carrierId": "DPD", "createdAt": "2025-10-02T09:43:17.649Z", "lineItems": [{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NzU2NTg3MDZV", "waybill": "1026675658706U", "carrierId": "DPD", "createdAt": "2025-10-02T09:43:17.876Z", "lineItems": [{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de"}]}]	\N	0.00	\N	[]	f
7802	ab770670-9ebc-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 11:49:53.186	READY_FOR_PROCESSING	allegro-pl	24885194	bartuskziom4	43flp6aw6i+5979f67f9@allegromail.pl	\N	Justyna Grabowska	+48 513 999 029	Ogrodowa 9A	08-124	Niwiski	PL	ab8e38ad-9ebc-11f0-b9a1-9fd75769370f	PAID	AF	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	\N	t	\N	2025-10-01 11:49:53.186	\N	2025-10-09 19:57:08.02041	ONLINE	f	[{"id": "RFBEOjEwMjY3MjM5NTkyMDBV", "waybill": "1026723959200U", "carrierId": "DPD", "createdAt": "2025-10-03T05:12:44Z", "lineItems": [{"id": "ab724b80-9ebc-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7884	093fd080-a54c-11f0-b989-75c7faccd1ca	\N	\N	2025-10-09 20:12:24.416	READY_FOR_PROCESSING	allegro-pl	125422347	Client:125422347	c4220u7mnc+2252f96a2@allegromail.pl	\N	Monika Zasada	+48 512 098 086	Szeligi 13	09-472	Słupno	\N	09951d47-a54c-11f0-96eb-67f4404dbe40	PAID	P24	t	1319.00	\N	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	H1.  ES1	t	\N	2025-10-09 20:17:28.59	\N	2025-10-09 20:20:44.305026	ONLINE	f	[]	\N	0.00	\N	[]	f
7807	81c7cfb0-9eaa-11f0-bc92-992b6815467a	\N	\N	2025-10-01 09:40:52.449	READY_FOR_PROCESSING	allegro-pl	21295001	minoka9	74n823nhr7+5ab5a4991@allegromail.pl	\N	Monika Kucharczak	+48 608 832 227	Grzybów 29D	39-308	Grzybów	PL	81eb5d69-9eaa-11f0-baf9-a33944a1116d	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Tkanina TH3 	t	\N	2025-10-01 09:40:52.449	\N	2025-10-09 19:57:14.883124	ONLINE	f	[{"id": "RFBEOjEwMjY2NjA0MjcyNzBV", "waybill": "1026660427270U", "carrierId": "DPD", "createdAt": "2025-10-02T07:43:41.936Z", "lineItems": [{"id": "81c1b530-9eaa-11f0-bc92-992b6815467a"}]}]	\N	0.00	\N	[]	f
7808	5f2c19c0-9eaa-11f0-817a-fb3753e68c2d	\N	\N	2025-10-01 09:41:13.891	CANCELLED	allegro-pl	50174885	Client:50174885	ppr8di1rde+7626b35f0@allegromail.pl	\N	Natalia Longier	+48 530 400 390	\N	\N	\N	\N	5f69e702-9eaa-11f0-96eb-67f4404dbe40	UNPAID	PAYU	t	\N	\N	Allegro Kurier DPD	0.00	PLN	793.10	PLN	\N	t	\N	\N	\N	2025-10-09 19:57:16.230465	ONLINE	f	[]	\N	0.00	\N	[]	f
7809	f1a501f0-9ea9-11f0-908e-ff3baa2fe7b0	\N	\N	2025-10-01 09:50:32.092	CANCELLED	allegro-pl	38470041	Client:38470041	tfvthfpx0x+2680e20e6@allegromail.pl	\N	Iza Jóźwiak	+48 506 153 501	Chodzieska 23	60-418	Poznań	PL	f910bb0f-9ea9-11f0-a284-071dd65bf45d	PAID	AF	t	505.50	PLN	Kurier DPD	17.00	PLN	505.50	PLN	wzór F04 kolor czarny 	f	\N	2025-10-01 09:36:23.48	\N	2025-10-09 19:57:17.494417	ONLINE	f	[]	\N	505.50	2025-10-01 09:52:11.178	[{"id": "4ce69a52-9eac-11f0-a0c8-1dbe9f7e626d", "order": {"id": "f1a501f0-9ea9-11f0-908e-ff3baa2fe7b0"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "f910bb0f-9ea9-11f0-a284-071dd65bf45d"}, "delivery": {"value": {"amount": "17.00", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-01T09:52:11.178Z", "lineItems": [{"id": "f19d39c0-9ea9-11f0-908e-ff3baa2fe7b0", "type": "AMOUNT", "value": {"amount": "488.50", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "505.50", "currency": "PLN"}}]	f
7810	779405a0-9ea4-11f0-8996-07b46275101a	\N	\N	2025-10-01 08:58:09.974	READY_FOR_PROCESSING	allegro-pl	11980132	Ewa2197	jemlxwo0zg+5105ff5f9@allegromail.pl	\N	Ewa Osipa	+48 792 592 983	Słoneczna 7	55-093	Brzezia Łaka	PL	7ff14a39-9ea4-11f0-b9a1-9fd75769370f	PAID	AF	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	ES1 - Eko skóra Czarny	t	\N	2025-10-01 08:58:09.974	\N	2025-10-09 19:57:18.846639	ONLINE	f	[{"id": "RFBEOjEwMjY2NjA1Mzg2NzBV", "waybill": "1026660538670U", "carrierId": "DPD", "createdAt": "2025-10-02T07:44:34.631Z", "lineItems": [{"id": "778e3940-9ea4-11f0-8996-07b46275101a"}]}, {"id": "RFBEOjEwMjY2NjA1Mzg3ODNV", "waybill": "1026660538783U", "carrierId": "DPD", "createdAt": "2025-10-02T07:44:34.830Z", "lineItems": [{"id": "778e3940-9ea4-11f0-8996-07b46275101a"}]}]	\N	0.00	\N	[]	f
7811	2a06f6d0-9ea4-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 08:54:55.157	READY_FOR_PROCESSING	allegro-pl	41247325	mirabelka97	3e6vypb5e1+6635ac709@allegromail.pl	PAULA DECO Paulina Brajerek	Paulina Brajerek	+48 663 036 390	Lipowa 4a	67-321	Leszno Górne	PL	2a294c5e-9ea4-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	793.10	PLN	Allegro Kurier DPD	0.00	PLN	793.10	PLN	Poproszę o siedzisko z eko skóry w odcieniu brązu. 	t	\N	2025-10-01 08:54:55.157	\N	2025-10-09 19:57:20.184865	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQyODM5ODlV", "waybill": "1026724283989U", "carrierId": "DPD", "createdAt": "2025-10-03T05:18:09.096Z", "lineItems": [{"id": "29fbd340-9ea4-11f0-9dc3-f9a3debc1314"}]}, {"id": "RFBEOjEwMjY3MjQyODQwODdV", "waybill": "1026724284087U", "carrierId": "DPD", "createdAt": "2025-10-03T05:18:09.248Z", "lineItems": [{"id": "29fbd340-9ea4-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7812	52261250-9ea3-11f0-bc92-992b6815467a	\N	\N	2025-10-01 08:50:53.473	READY_FOR_PROCESSING	allegro-pl	2991758	berdonka	a7bu6e6pap+287927141@allegromail.pl	\N	Henryk Tomecki	+48 795 616 058	Centaura 27 / 26	44-117	Gliwice	PL	559fd001-9ea3-11f0-baf9-a33944a1116d	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	szafka kolor biały ,siedzisko WE3 - Welur Grafitowy	t	\N	2025-10-01 08:50:53.473	\N	2025-10-09 19:57:21.523599	ONLINE	t	[{"id": "RFBEOjEwMjY2NTY0MDY0NzRV", "waybill": "1026656406474U", "carrierId": "DPD", "createdAt": "2025-10-02T07:13:54.758Z", "lineItems": [{"id": "52209410-9ea3-11f0-bc92-992b6815467a"}]}]	Centaura 27 / 26	0.00	\N	[]	f
7814	f6358130-9e96-11f0-817a-fb3753e68c2d	\N	\N	2025-10-01 09:27:11.642	CANCELLED	allegro-pl	38470041	Client:38470041	tfvthfpx0x+646751359@allegromail.pl	\N	Iza Jóźwiak	+48 506 153 501	Chodzieska 23	60-418	Poznań	PL	25bd04bc-9e97-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	505.50	PLN	Kurier DPD	17.00	PLN	505.50	PLN	wzór F04 kolor czarny	f	\N	2025-10-01 07:21:48.029	\N	2025-10-09 19:57:24.177602	ONLINE	f	[]	\N	505.50	2025-10-01 09:27:44.262	[{"id": "e29b7ae6-9ea8-11f0-bb0d-430e2488e63a", "order": {"id": "f6358130-9e96-11f0-817a-fb3753e68c2d"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "25bd04bc-9e97-11f0-bdd7-1b3dfdcd18cd"}, "delivery": {"value": {"amount": "17.00", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-01T09:27:44.262Z", "lineItems": [{"id": "f62ea360-9e96-11f0-817a-fb3753e68c2d", "type": "AMOUNT", "value": {"amount": "488.50", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "505.50", "currency": "PLN"}}]	f
7815	62229f70-9e94-11f0-8fc5-3736e68905c7	\N	\N	2025-10-01 07:03:22.378	READY_FOR_PROCESSING	allegro-pl	11938293	dorota22235	fl82g2koxq+6dd1f7062@allegromail.pl	\N	Dorota BOGDAŃSKA	+48 515 163 243	Kolejowa 2a / 11	22-100	Chełm	PL	9f0e7ac5-9e94-11f0-baf9-a33944a1116d	PAID	AF	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	\N	t	\N	2025-10-01 07:03:22.378	\N	2025-10-09 19:57:25.539499	ONLINE	t	[]	PIASTOWSKA 7	0.00	\N	[]	f
7817	9162c891-997c-11f0-b7ad-bf8cbe88f0cf	\N	\N	2025-10-02 01:16:12.156	CANCELLED	allegro-pl	34257770	Client:34257770	z5j7zw9sdu+a4c98294@allegromail.pl	\N	Dorota Życińska	+48 607 989 771	\N	\N	\N	\N	919a2d11-997c-11f0-ab95-f7c208471a67	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1704.10	PLN	\N	t	\N	\N	\N	2025-10-09 19:54:36.654006	ONLINE	f	[]	\N	0.00	\N	[]	f
7775	1b962310-9f11-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-01 21:54:53.625	READY_FOR_PROCESSING	allegro-pl	126192032	Client:126192032	55id3acc24+52d7a8657@allegromail.pl	\N	Paweł Czerwiński	+48 577 479 555	Żołnierzy 2 AWP 25 / 13	59-220	Legnica	PL	36fa2943-9f11-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-01 21:54:53.625	\N	2025-10-09 19:56:30.606999	ONLINE	f	[{"id": "RFBEOjEwMjY3MjIyNjQwOTBV", "waybill": "1026722264090U", "carrierId": "DPD", "createdAt": "2025-10-03T04:31:31Z", "lineItems": [{"id": "1b8f9360-9f11-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7776	e8756a60-9f04-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-01 20:30:29.635	READY_FOR_PROCESSING	allegro-pl	43150009	43150009	a4k717aij4+94f33475@allegromail.pl	\N	Swietłana Łarkowa	+48 666 942 227	Krasińskiego 11	46-220	Byczyna	PL	e897e6d1-9f04-11f0-b9a1-9fd75769370f	PAID	AF	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-10-01 20:30:29.635	\N	2025-10-09 19:56:32.292077	ONLINE	f	[{"id": "RFBEOjEwMjY3MjIzMjM4ODlV", "waybill": "1026722323889U", "carrierId": "DPD", "createdAt": "2025-10-03T04:32:59Z", "lineItems": [{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY3MjIzMjM5NDRV", "waybill": "1026722323944U", "carrierId": "DPD", "createdAt": "2025-10-03T04:32:59Z", "lineItems": [{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY3MjIzMjQwNzhV", "waybill": "1026722324078U", "carrierId": "DPD", "createdAt": "2025-10-03T04:32:59Z", "lineItems": [{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7777	a1e0a350-9f02-11f0-b871-03a75625f948	\N	\N	2025-10-01 20:12:01.111	READY_FOR_PROCESSING	allegro-pl	46536149	Client:46536149	3jqlqk6rlk+713ffc0a4@allegromail.pl	\N	Wiktor Graczyk	+48 791 487 497	Podgórna 60 / 13	87-100	Toruń	PL	ab3dcc22-9f02-11f0-baf9-a33944a1116d	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	TH1	t	\N	2025-10-01 20:12:01.111	\N	2025-10-09 19:56:33.686565	ONLINE	f	[{"id": "RFBEOjEwMjY2NDQ4ODMzNjZV", "waybill": "1026644883366U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:31.619Z", "lineItems": [{"id": "a1dbe860-9f02-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7778	c68f7410-9efd-11f0-88a7-41bf7e4bf551	\N	\N	2025-10-01 19:36:57.145	READY_FOR_PROCESSING	allegro-pl	39909528	Client:39909528	4jdjvvy3oi+4201a8ae8@allegromail.pl	\N	Katarzyna Rolak	+48 730 261 216	Sikorskiego 4/13	05-480	Karczew	PL	ec438db1-9efd-11f0-a284-071dd65bf45d	PAID	PAYU	t	802.99	PLN	Allegro Kurier DPD	14.99	PLN	802.99	PLN	\N	f	\N	2025-10-01 19:36:57.145	\N	2025-10-09 19:56:35.082567	ONLINE	f	[{"id": "RFBEOjEwMjY2ODY3OTAyNTJV", "waybill": "1026686790252U", "carrierId": "DPD", "createdAt": "2025-10-02T11:15:48.596Z", "lineItems": [{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551"}]}, {"id": "RFBEOjEwMjY2ODY3OTAzNDVV", "waybill": "1026686790345U", "carrierId": "DPD", "createdAt": "2025-10-02T11:15:48.807Z", "lineItems": [{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551"}]}, {"id": "RFBEOjEwMjcxNjMzNjIwMjdV", "waybill": "1027163362027U", "carrierId": "DPD", "createdAt": "2025-10-09T09:35:31.499Z", "lineItems": [{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551"}]}]	\N	0.00	\N	[]	f
7780	53444b90-9efb-11f0-9e10-59ae2eaec9de	\N	\N	2025-10-01 19:21:54.968	READY_FOR_PROCESSING	allegro-pl	22091132	andygut	vs638z6rka+22f0a1336@allegromail.pl	\N	Adrian Chyła	+48 691 323 822	os. 700 - lecia 4C/14	86-170	NOWE	PL	56935044-9efb-11f0-a417-fd831f6ae8ec	PAID	P24	t	1319.00	PLN	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	Uchwyty H1\nTkanina F04 Fjord Czarny 	t	\N	2025-10-01 19:21:54.968	\N	2025-10-09 19:56:37.890424	ONLINE	f	[{"id": "RFBEOjEwMjY2NDY0NDI2NjlV", "waybill": "1026646442669U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:00.934Z", "lineItems": [{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NDY0NDI3NDhV", "waybill": "1026646442748U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:01.058Z", "lineItems": [{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NDY0NDI4ODhV", "waybill": "1026646442888U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:03Z", "lineItems": [{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de"}]}]	\N	0.00	\N	[]	f
7787	ebf4b2a0-9eef-11f0-9efe-27a29450b6fd	\N	\N	2025-10-01 17:58:05.395	READY_FOR_PROCESSING	allegro-pl	11064817	red_witch1	orc2xt5c0e+1dad73032@allegromail.pl	\N	Karolina Sośnicka	+48 577 881 286	Pocztowa5/1	37-700	Przemyśl	PL	ec1dbe73-9eef-11f0-b9a1-9fd75769370f	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	proszę o wykonanie siedziska z tkaniny Hugo w czarnym kolorze	t	\N	2025-10-01 17:58:05.395	\N	2025-10-09 19:56:47.728981	ONLINE	f	[{"id": "RFBEOjEwMjY2NDYwNDI3NTNV", "waybill": "1026646042753U", "carrierId": "DPD", "createdAt": "2025-10-02T05:52:17.604Z", "lineItems": [{"id": "ebefa990-9eef-11f0-9efe-27a29450b6fd"}]}, {"id": "RFBEOjAwMDAwMzk5MDE5MzJM", "waybill": "0000039901932L", "carrierId": "DPD", "createdAt": "2025-10-04T06:45:47Z", "lineItems": [{"id": "ebefa990-9eef-11f0-9efe-27a29450b6fd"}]}]	\N	0.00	\N	[]	f
7791	1fad91d0-9eea-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 17:20:16.663	READY_FOR_PROCESSING	allegro-pl	101170108	Client:101170108	46sx39nne1+25c3ed829@allegromail.pl	\N	Anita Będziechowska	+48 603 624 265	Głogowska 154A / 18	60-205	Poznań	PL	cbec6bfe-9eea-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	382.20	PLN	Allegro Kurier DPD	0.00	PLN	382.20	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-10-01 17:20:16.663	\N	2025-10-09 19:56:53.308922	ONLINE	f	[{"id": "RFBEOjEwMjY2NzM2MjY5NzRV", "waybill": "1026673626974U", "carrierId": "DPD", "createdAt": "2025-10-02T09:26:34.835Z", "lineItems": [{"id": "1fa29550-9eea-11f0-96ea-bf4f56b08af2"}]}]	\N	80.00	2025-10-08 18:05:01.942	[{"id": "4f5845da-a471-11f0-9a6c-fd39df90ab15", "order": {"id": "1fad91d0-9eea-11f0-96ea-bf4f56b08af2"}, "reason": "COMPLAINT", "status": "SUCCESS", "payment": {"id": "cbec6bfe-9eea-11f0-bdd7-1b3dfdcd18cd"}, "deposits": [], "createdAt": "2025-10-08T18:05:01.942Z", "lineItems": [{"id": "1fa29550-9eea-11f0-96ea-bf4f56b08af2", "type": "AMOUNT", "value": {"amount": "80.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "80.00", "currency": "PLN"}, "sellerComment": "zwrot z tytułu uszkodzenia w transporcie "}]	f
7794	7421cf30-9ed9-11f0-b465-492415e4339b	\N	\N	2025-10-01 15:18:54.4	READY_FOR_PROCESSING	allegro-pl	48879549	Client:48879549	5r09on9gvb+92205fa6@allegromail.pl	\N	Lucas Farris	+48 534 663 276	Ulica Podwale 74/19	50-449	Wroclaw	PL	745f74d5-9ed9-11f0-96eb-67f4404dbe40	PAID	AF	t	2259.98	PLN	Allegro Kurier DPD	29.98	PLN	2259.98	PLN	Chcielibyśmy, aby drzwi szafki SUPRA otwierały się na prawą stronę (odwrotnie niż na rysunku).\nKolory haków: H1 - Czarny\nKolor panel: ES1 - Eko skóra Czarny	f	\N	2025-10-01 15:18:54.4	\N	2025-10-09 19:56:57.338125	ONLINE	f	[{"id": "RFBEOjEwMjY2ODIwODMxMTdV", "waybill": "1026682083117U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODMyMzdV", "waybill": "1026682083237U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODMzNDhV", "waybill": "1026682083348U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31.101Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODM0NTNV", "waybill": "1026682083453U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31.367Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODM1MDhV", "waybill": "1026682083508U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31.604Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}]	\N	0.00	\N	[]	f
7805	2e56f660-9eac-11f0-9468-2bd22967b382	\N	\N	2025-10-01 09:53:24.961	READY_FOR_PROCESSING	allegro-pl	38470041	Client:38470041	tfvthfpx0x+3a4da5d17@allegromail.pl	\N	Iza Jóźwiak	+48 506 153 501	Chodzieska 23	60-418	Poznań	PL	5d7b4b86-9eac-11f0-b9a1-9fd75769370f	PAID	AF	t	505.50	PLN	Kurier DPD	17.00	PLN	505.50	PLN	wzór Hugo czarny ( TH 1)	f	\N	2025-10-01 09:53:24.961	\N	2025-10-09 19:57:12.194263	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQwNTUxMzVV", "waybill": "1026724055135U", "carrierId": "DPD", "createdAt": "2025-10-03T05:14:15.846Z", "lineItems": [{"id": "2e4f7c50-9eac-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7806	dc70e320-9eaa-11f0-8ace-e54796c9c1e2	\N	\N	2025-10-01 09:42:26.192	READY_FOR_PROCESSING	allegro-pl	50174885	Client:50174885	ppr8di1rde+767d131b4@allegromail.pl	\N	Natalia Longier	+48 530 400 390	Studzian 223a	37-200	Przeworsk	PL	e8bd3c20-9eaa-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	798.09	PLN	\N	t	\N	2025-10-01 09:42:26.192	\N	2025-10-09 19:57:13.518163	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3MjQxMTMzMDlV", "waybill": "1026724113309U", "carrierId": "DPD", "createdAt": "2025-10-03T05:15:16.136Z", "lineItems": [{"id": "dc660db0-9eaa-11f0-8ace-e54796c9c1e2"}]}, {"id": "RFBEOjEwMjY3MjQxMTM0NDhV", "waybill": "1026724113448U", "carrierId": "DPD", "createdAt": "2025-10-03T05:15:16.360Z", "lineItems": [{"id": "dc660db0-9eaa-11f0-8ace-e54796c9c1e2"}]}]	\N	0.00	\N	[]	f
7813	d41ce880-9e97-11f0-8996-07b46275101a	\N	\N	2025-10-01 07:30:51.252	READY_FOR_PROCESSING	allegro-pl	11634406	nosek29	wkpd0v7hx7+319b6e745@allegromail.pl	\N	Mateusz Mosak	+48 661 406 560	Wola Gardzienicka 28	21-050	Piaski	PL	e4d09381-9e97-11f0-baf9-a33944a1116d	PAID	AF	t	1045.00	PLN	Allegro Kurier DPD	0.00	PLN	1045.00	PLN	kolor paneli ściennych oraz siedziska ES4 - Eko skóra Brąz \nkolor wieszaków  H3 - Złoto szczotkowane	t	\N	2025-10-01 07:30:51.252	\N	2025-10-09 19:57:22.849985	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQ0NjA4MDFV", "waybill": "1026724460801U", "carrierId": "DPD", "createdAt": "2025-10-03T05:21:09.776Z", "lineItems": [{"id": "d41854a0-9e97-11f0-8996-07b46275101a"}]}, {"id": "RFBEOjEwMjY3MjQ0NjA5MDhV", "waybill": "1026724460908U", "carrierId": "DPD", "createdAt": "2025-10-03T05:21:09.922Z", "lineItems": [{"id": "d41854a0-9e97-11f0-8996-07b46275101a"}]}]	\N	0.00	\N	[]	f
7859	dfc2f4f0-9e55-11f0-b871-03a75625f948	\N	\N	2025-09-30 23:33:52.798	READY_FOR_PROCESSING	allegro-pl	136644980	Client:136644980	jkc0oyvond+7fd345921@allegromail.pl	\N	Natalia Wójtowicz	+48 739 173 325	Cmentarna 1b / Natalia W3ójtowicz	59-220	Legnica	PL	e9747e9a-9e55-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	318.99	PLN	\N	t	\N	2025-09-30 23:33:52.798	\N	2025-10-09 19:57:26.879438	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2MDA5NzI2MjJV", "waybill": "1026600972622U", "carrierId": "DPD", "createdAt": "2025-10-01T10:56:18.246Z", "lineItems": [{"id": "dfbeaf30-9e55-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7860	93cb0710-9e3f-11f0-9325-2757f66ce3c4	\N	\N	2025-09-30 20:54:23.644	READY_FOR_PROCESSING	allegro-pl	14840110	kapi_55	52vikrz5nc+85ed9b37@allegromail.pl	\N	Renata Ciupa	+48 797 629 233	Zubowice 70A	22-435	Komarów	PL	a1422426-9e3f-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	330.99	PLN	F02 Fjord jasny szary	t	\N	2025-09-30 20:54:23.644	\N	2025-10-09 19:57:28.363695	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2NDUwNjA0OTNV", "waybill": "1026645060493U", "carrierId": "DPD", "createdAt": "2025-10-02T05:42:17.859Z", "lineItems": [{"id": "93c67330-9e3f-11f0-9325-2757f66ce3c4"}]}]	\N	0.00	\N	[]	f
7861	0dc8aad0-9e37-11f0-8fb0-7b363fae20c7	\N	\N	2025-09-30 20:01:14.876	READY_FOR_PROCESSING	allegro-pl	17719320	13kasia101991	2ajt4ud09a+334d1a8d6@allegromail.pl	\N	Katarzyna Kociemba	+48 669 274 794	ul. Łąkowa 46	63-421	Janków Przygodzki	PL	0dee0dfc-9e37-11f0-b9a1-9fd75769370f	PAID	P24	t	1540.00	PLN	Allegro Kurier DPD	0.00	PLN	1540.00	PLN	Witam. Kolor haków oraz uchwytów: złoto szczotkowane; Kolor siedziska: WELUR GRAFITOWY WE3. Także mam prośbę czy byłaby możliwość dosłania dwóch uchwytów do szafy w kolorze złota szczotkowanego?! Jeśli tak to poproszę o wiadomość telefoniczną i dokonam zapłate, aby wysłać w komplecie. W jakichkolwiek pytań proszę o kontakt telefoniczny 669274794. Pozdrawiam Katarzyna Serafin	t	\N	2025-09-30 20:01:14.876	\N	2025-10-09 19:57:29.728304	ONLINE	f	[{"id": "RFBEOjEwMjY2NTM5NzI0MTVV", "waybill": "1026653972415U", "carrierId": "DPD", "createdAt": "2025-10-02T06:55:08.958Z", "lineItems": [{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7"}]}, {"id": "RFBEOjEwMjY2NTM5NzI1NzRV", "waybill": "1026653972574U", "carrierId": "DPD", "createdAt": "2025-10-02T06:55:09.125Z", "lineItems": [{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7"}]}, {"id": "RFBEOjEwMjY2NTM5NzI2ODJV", "waybill": "1026653972682U", "carrierId": "DPD", "createdAt": "2025-10-02T06:55:09.234Z", "lineItems": [{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7"}]}]	\N	0.00	\N	[]	f
7862	8f544d00-9e34-11f0-8cf9-590a844f62e8	\N	\N	2025-09-30 19:41:00.365	READY_FOR_PROCESSING	allegro-pl	10611294	casablancamg	mdxvzlu66a+6cf13d4f8@allegromail.pl	\N	Monika Reroń	+48 795 395 035	Daszyńskiego 25 / 9	25-408	Kielce	PL	8f77b454-9e34-11f0-b9a1-9fd75769370f	PAID	AF	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	Obicie eko skóra gładka czarna ES1, wieszak czarny H1	t	\N	2025-09-30 19:41:00.365	\N	2025-10-09 19:57:31.206095	ONLINE	f	[{"id": "RFBEOjEwMjY1NzY3MTI2OTBV", "waybill": "1026576712690U", "carrierId": "DPD", "createdAt": "2025-10-01T07:43:56.995Z", "lineItems": [{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY1NzY3MTI3MDNV", "waybill": "1026576712703U", "carrierId": "DPD", "createdAt": "2025-10-01T07:43:57.223Z", "lineItems": [{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY1NzY3MTI4OTFV", "waybill": "1026576712891U", "carrierId": "DPD", "createdAt": "2025-10-01T07:43:57.419Z", "lineItems": [{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8"}]}]	\N	0.00	\N	[]	f
7816	40649dc0-9e30-11f0-b286-41f712537da1	\N	\N	2025-10-01 08:30:44.771	READY_FOR_PROCESSING	allegro-pl	6778332	harnas_nr9	dgk645wq8b+74d7114e8@allegromail.pl	\N	Grzesiek Burak	+48 799 309 974	Skrzyszów 113	33-156	Skrzyszów	PL	40a0e468-9e30-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Kolor tapicerki \nWelur czarny (WE1)	t	\N	2025-10-01 08:30:44.771	\N	2025-10-09 19:57:32.670068	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQzODI3MzZV", "waybill": "1026724382736U", "carrierId": "DPD", "createdAt": "2025-10-03T05:19:50.450Z", "lineItems": [{"id": "405d98e0-9e30-11f0-b286-41f712537da1"}]}, {"id": "RFBEOjEwMjcwOTMzMzMzOTBV", "waybill": "1027093333390U", "carrierId": "DPD", "createdAt": "2025-10-08T11:29:25.902Z", "lineItems": [{"id": "405d98e0-9e30-11f0-b286-41f712537da1"}]}]	\N	0.00	\N	[]	f
7864	6bba81a0-9e2c-11f0-a459-a9c1a10b0527	\N	\N	2025-09-30 18:39:11.105	READY_FOR_PROCESSING	allegro-pl	107044076	Client:107044076	vcs2cndx9q+2b5c33627@allegromail.pl	\N	Dominik  Goj	+48 721 936 087	Chorzowska 57 ( zakład fryzjerski Anna)	41-902	Bytom	PL	aae79a69-9e2c-11f0-91d4-7961b40d7b05	PAID	P24	t	1360.00	PLN	Kurier DPD	17.00	PLN	1360.00	PLN	\N	f	\N	2025-09-30 18:39:11.105	\N	2025-10-09 19:57:34.124208	ONLINE	f	[{"id": "RFBEOjEwMjY2NDUyODIxMDRV", "waybill": "1026645282104U", "carrierId": "DPD", "createdAt": "2025-10-02T05:44:48.438Z", "lineItems": [{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527"}]}, {"id": "RFBEOjEwMjY2NDUyODIyMjRV", "waybill": "1026645282224U", "carrierId": "DPD", "createdAt": "2025-10-02T05:44:48.642Z", "lineItems": [{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527"}]}, {"id": "RFBEOjEwMjY2NDUyODIzODFV", "waybill": "1026645282381U", "carrierId": "DPD", "createdAt": "2025-10-02T05:44:48.894Z", "lineItems": [{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527"}]}]	\N	0.00	\N	[]	f
7865	9687df20-9e29-11f0-a07b-27f19dcfd61a	\N	\N	2025-09-30 18:17:10.134	READY_FOR_PROCESSING	allegro-pl	39054990	MalWeres	c5yjr5ee8n+6b67fe644@allegromail.pl	\N	Małgorzata Adryan	+48 514 981 197	Sulimów 31/44	08-110	Siedlce	PL	9fe75142-9e29-11f0-b9a1-9fd75769370f	PAID	P24	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-09-30 18:17:10.134	\N	2025-10-09 19:57:35.69216	ONLINE	f	[{"id": "RFBEOjEwMjY2NDU0NDY5NTlV", "waybill": "1026645446959U", "carrierId": "DPD", "createdAt": "2025-10-02T05:46:31.937Z", "lineItems": [{"id": "9682fd20-9e29-11f0-a07b-27f19dcfd61a"}]}]	\N	0.00	\N	[]	f
7866	d2623fa0-9e28-11f0-a6cc-b3145592fdde	\N	\N	2025-09-30 18:11:20.264	READY_FOR_PROCESSING	allegro-pl	103634964	Client:103634964	4oxhnwf379+534a2ebe4@allegromail.pl	\N	Justyna Walczak	+48 500 769 406	Bartąska 162/20	10-687	Bartąg	PL	d944a443-9e28-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	336.99	PLN	\N	t	\N	2025-09-30 18:11:20.264	\N	2025-10-09 19:57:37.239716	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3MzYwODk2NzhV", "waybill": "1026736089678U", "carrierId": "DPD", "createdAt": "2025-10-03T07:31:48.314Z", "lineItems": [{"id": "d25ac590-9e28-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7867	f42c0090-9e1d-11f0-820b-7b684c0899aa	\N	\N	2025-09-30 16:55:13.832	READY_FOR_PROCESSING	allegro-pl	127922122	Client:127922122	3l8tn0dpnh+170e6042@allegromail.pl	\N	Mariusz R Rogowski	+48 503 786 097	pionierów lubuskich 74	66-002	Zielona góra Stary Kisielin	PL	24ceb810-9e1e-11f0-bb32-51209e96d6bb	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	847.99	PLN	Witam, zamawiam zestaw Dab wotan, eko skóra ES4 ciemny brąz, Pozdrawiam	f	\N	2025-09-30 16:55:13.832	\N	2025-10-09 19:57:38.745835	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY1NzE0NjE2ODJV", "waybill": "1026571461682U", "carrierId": "DPD", "createdAt": "2025-10-01T07:04:14.198Z", "lineItems": [{"id": "f42522c0-9e1d-11f0-820b-7b684c0899aa"}]}, {"id": "RFBEOjEwMjY1NzE0NjE3MzFV", "waybill": "1026571461731U", "carrierId": "DPD", "createdAt": "2025-10-01T07:04:14.401Z", "lineItems": [{"id": "f42522c0-9e1d-11f0-820b-7b684c0899aa"}]}]	\N	0.00	\N	[]	f
7868	221d3350-9e1b-11f0-8e98-fdfd51e10ba4	\N	\N	2025-09-30 16:34:58.998	READY_FOR_PROCESSING	allegro-pl	9193108	Golden-Tiger	ry4a0p50dx+6d1e2ffb1@allegromail.pl	\N	Sebastian Idzikowski	+48 508 800 271	Roweckiego 71/2	72-009	Police	PL	225dbee6-9e1b-11f0-96eb-67f4404dbe40	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	TH1 - Tkanina Hugo Czarny	t	\N	2025-09-30 16:34:58.998	\N	2025-10-09 19:57:40.882458	ONLINE	f	[{"id": "RFBEOjEwMjY1NzE2MTM0MjZV", "waybill": "1026571613426U", "carrierId": "DPD", "createdAt": "2025-10-01T07:05:13.244Z", "lineItems": [{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY1NzE2MTM1MDdV", "waybill": "1026571613507U", "carrierId": "DPD", "createdAt": "2025-10-01T07:05:13.453Z", "lineItems": [{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY1NzE3NzY1NjlV", "waybill": "1026571776569U", "carrierId": "DPD", "createdAt": "2025-10-01T07:06:31Z", "lineItems": [{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7869	881920f1-9e17-11f0-b871-03a75625f948	\N	\N	2025-09-30 16:13:12.628	READY_FOR_PROCESSING	allegro-pl	102157276	Client:102157276	slmxglvatp+2aea6ed04@allegromail.pl	\N	Izabela Bułka	+48 501 121 251	Bolesławicka 26 / 72	03-352	Warszawa	PL	41bb41bf-9e18-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	1338.99	PLN	HAKI       H1-CZARNY \nOBICIE    ES1-CZARNY\n	f	\N	2025-09-30 16:13:12.628	\N	2025-10-09 19:57:42.387318	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY1NzUxMzc1NDBV", "waybill": "1026575137540U", "carrierId": "DPD", "createdAt": "2025-10-01T07:31:49.505Z", "lineItems": [{"id": "880cc4e1-9e17-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY1NzUxMzc2MzJV", "waybill": "1026575137632U", "carrierId": "DPD", "createdAt": "2025-10-01T07:31:49.655Z", "lineItems": [{"id": "880cc4e1-9e17-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY1NzUxMzc3MTdV", "waybill": "1026575137717U", "carrierId": "DPD", "createdAt": "2025-10-01T07:31:49.814Z", "lineItems": [{"id": "880cc4e1-9e17-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7870	0305dfa0-9e0f-11f0-9fa0-ab34abe0805b	\N	\N	2025-09-30 15:09:36.307	READY_FOR_PROCESSING	allegro-pl	3155920	kasik1989	44e8e31hyk+23e8d255@allegromail.pl	\N	Katarzyna Pankiewicz	+48 604 978 784	Pułaskiego 4 / 16	05-400	Otwock	PL	3fed75c5-9e0f-11f0-baf9-a33944a1116d	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Thp2 Hugo pik  jasny szary	t	\N	2025-09-30 15:09:36.307	\N	2025-10-09 19:57:43.912526	ONLINE	f	[{"id": "RFBEOjEwMjY1NzE3MTE5ODdV", "waybill": "1026571711987U", "carrierId": "DPD", "createdAt": "2025-10-01T07:06:00.774Z", "lineItems": [{"id": "02fe8ca0-9e0f-11f0-9fa0-ab34abe0805b"}]}]	\N	0.00	\N	[]	f
7871	dc71b140-9e0c-11f0-a758-8bcc0e9ae972	\N	\N	2025-09-30 14:51:52.964	READY_FOR_PROCESSING	allegro-pl	1252658	44han44	ict5en0k0c+1638bbd11@allegromail.pl	\N	JACEK PASADYN	+48 502 891 486	Grodzka 9 D/ 5	73-110	Stargard	PL	f56cce43-9e0c-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	466.99	PLN	\N	t	\N	2025-09-30 14:51:52.964	\N	2025-10-09 19:57:45.32572	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2NDU2NDc0MzBV", "waybill": "1026645647430U", "carrierId": "DPD", "createdAt": "2025-10-02T05:48:44.123Z", "lineItems": [{"id": "dc6afa80-9e0c-11f0-a758-8bcc0e9ae972"}]}]	\N	0.00	\N	[]	f
7872	b291b770-9e03-11f0-9a42-bb8e9ffafe52	\N	\N	2025-09-30 13:49:06.533	READY_FOR_PROCESSING	allegro-pl	103974972	Sitodrukarnia2	m9q2xq33a6+617f4c7f3@allegromail.pl	Sitodrukarnia Sp zoo 	Sitodrukarnia2	+48 603 677 814	Dębowa 22	11-034	Stawiguda	PL	c3d39853-9e03-11f0-91d4-7961b40d7b05	PAID	P24	t	846.00	PLN	Allegro Kurier DPD	0.00	PLN	846.00	PLN	\N	t	\N	2025-09-30 13:49:06.533	\N	2025-10-09 19:57:46.731225	ONLINE	f	[{"id": "RFBEOjEwMjY2NDU3NTcwNTVV", "waybill": "1026645757055U", "carrierId": "DPD", "createdAt": "2025-10-02T05:49:47.521Z", "lineItems": [{"id": "b2861eb0-9e03-11f0-9a42-bb8e9ffafe52"}]}, {"id": "RFBEOjEwMjY2NDU3NTcxNDZV", "waybill": "1026645757146U", "carrierId": "DPD", "createdAt": "2025-10-02T05:49:47.687Z", "lineItems": [{"id": "b2861eb0-9e03-11f0-9a42-bb8e9ffafe52"}]}]	\N	0.00	\N	[]	f
7873	a5d6df40-9dfb-11f0-b871-03a75625f948	\N	\N	2025-09-30 12:49:55.968	READY_FOR_PROCESSING	allegro-pl	98599178	Client:98599178	ljiwmlgkk7+7beadf523@allegromail.pl	\N	weronika saczuk	+48 887 807 113	sowinskiego 16/109	05-120	legionowo	PL	b2a90a1f-9dfb-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	\N	f	\N	2025-09-30 12:49:55.968	\N	2025-10-09 19:57:48.157165	ONLINE	f	[{"id": "RFBEOjEwMjY1NzQ5ODQ2NTBV", "waybill": "1026574984650U", "carrierId": "DPD", "createdAt": "2025-10-01T07:30:34Z", "lineItems": [{"id": "a5d22450-9dfb-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7874	7d54c060-9df5-11f0-8cf9-590a844f62e8	\N	\N	2025-09-30 12:06:06.401	READY_FOR_PROCESSING	allegro-pl	11450458	renata_mr1	sxm0wop0gz+60bf71fa2@allegromail.pl	\N	Renata Mikulska	+48 662 059 761	Struga 5	76-200	Słupsk	PL	7d76a0f8-9df5-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	dzień dobry,\npoproszę siedzisko i panele materiał welur czarny WE1	t	\N	2025-09-30 12:06:06.401	\N	2025-10-09 19:57:49.555196	ONLINE	f	[{"id": "RFBEOjEwMjY2NDU5NzA2ODZV", "waybill": "1026645970686U", "carrierId": "DPD", "createdAt": "2025-10-02T05:51:35.216Z", "lineItems": [{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY2NDU5NzA3NzlV", "waybill": "1026645970779U", "carrierId": "DPD", "createdAt": "2025-10-02T05:51:35.427Z", "lineItems": [{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY2NDU5NzA4NjdV", "waybill": "1026645970867U", "carrierId": "DPD", "createdAt": "2025-10-02T05:51:35.635Z", "lineItems": [{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8"}]}]	\N	0.00	\N	[]	f
7875	42171941-9def-11f0-8498-f546d68c9b4c	\N	\N	2025-09-30 11:19:58.707	READY_FOR_PROCESSING	allegro-pl	120709116	Client:120709116	cj7bqfjfpj+10f45c750@allegromail.pl	\N	Paulina Derewecka	+48 575 005 347	Chłaniów 72	22-335	Żółkiewka	PL	4262c8b5-9def-11f0-96eb-67f4404dbe40	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-30 11:19:58.707	\N	2025-10-09 19:57:50.952607	ONLINE	f	[{"id": "RFBEOjEwMjY1Nzc4OTA4NDlV", "waybill": "1026577890849U", "carrierId": "DPD", "createdAt": "2025-10-01T07:52:46.282Z", "lineItems": [{"id": "420f5111-9def-11f0-8498-f546d68c9b4c"}]}]	\N	0.00	\N	[]	f
7876	d24b4190-9dee-11f0-8dfb-8df075740e6d	\N	\N	2025-09-30 11:17:32.71	READY_FOR_PROCESSING	allegro-pl	21888986	thepolishkiller	99xdbddrkb+216cbb027@allegromail.pl	\N	Dawid Zimny	+48 509 503 333	Kiepury 38/5	58-506	Jelenia Góra	PL	d287fd54-9dee-11f0-a284-071dd65bf45d	PAID	AF	t	1102.00	PLN	Allegro Kurier DPD	0.00	PLN	1102.00	PLN	Kolor siedziska - WELUR GRAFIT  WE3	t	\N	2025-09-30 11:17:32.71	\N	2025-10-09 19:57:52.411291	ONLINE	f	[{"id": "RFBEOjEwMjY2NDQ2Nzg1NDNV", "waybill": "1026644678543U", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:15.204Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ2Nzg2NjNV", "waybill": "1026644678663U", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:15.427Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ2Nzg3NTRV", "waybill": "1026644678754U", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:15.633Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ4NzUzODVV", "waybill": "1026644875385U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:26.806Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ4NzU0MTJV", "waybill": "1026644875412U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:27Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ4NzU1MjVV", "waybill": "1026644875525U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:27.176Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}]	\N	0.00	\N	[]	f
7877	ae763330-9dec-11f0-b286-41f712537da1	\N	\N	2025-09-30 11:01:55.693	READY_FOR_PROCESSING	allegro-pl	94125153	Client:94125153	383c4v2pmp+7467c9008@allegromail.pl	\N	Emilia Karwacka	+48 505 118 319	Łączna 26	19-500	Gołdap	PL	b712f207-9dec-11f0-a417-fd831f6ae8ec	PAID	P24	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-09-30 11:01:55.693	\N	2025-10-09 19:57:53.994553	ONLINE	f	[{"id": "RFBEOjEwMjY1NzE5NDc1NDJV", "waybill": "1026571947542U", "carrierId": "DPD", "createdAt": "2025-10-01T07:07:46.677Z", "lineItems": [{"id": "ae6eb920-9dec-11f0-b286-41f712537da1"}]}]	\N	0.00	\N	[]	f
7878	0cb72551-9deb-11f0-8cf9-590a844f62e8	\N	\N	2025-09-30 10:49:14.346	READY_FOR_PROCESSING	allegro-pl	24794229	anka94719	o30crhoeks+4fc64bc05@allegromail.pl	\N	Anna Świątoniowska	+48 504 413 902	świerkowa 22	05-077	Zakręt	PL	0cdde7e7-9deb-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	532.00	PLN	Allegro Kurier DPD	0.00	PLN	532.00	PLN	\N	t	\N	2025-09-30 10:49:14.346	\N	2025-10-09 19:57:55.455939	ONLINE	f	[{"id": "RFBEOjEwMjY1NzIwMDQ3ODVV", "waybill": "1026572004785U", "carrierId": "DPD", "createdAt": "2025-10-01T07:08:15.592Z", "lineItems": [{"id": "0cb131e1-9deb-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY1NzIwMDQ4MjVV", "waybill": "1026572004825U", "carrierId": "DPD", "createdAt": "2025-10-01T07:08:15.769Z", "lineItems": [{"id": "0cb131e1-9deb-11f0-8cf9-590a844f62e8"}]}]	\N	0.00	\N	[]	f
7879	7379e230-9de3-11f0-9fa0-ab34abe0805b	\N	\N	2025-09-30 09:55:50.334	READY_FOR_PROCESSING	allegro-pl	20176486	tomas_271	ao27mocu4z+336f40131@allegromail.pl	\N	Tomasz Sprycha	+48 603 787 005	ul. Ks. Brzóski  15B/64	21-400	Łuków	PL	8383432f-9de3-11f0-ae11-e76c74c7cf77	PAID	P24	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	proszę o pilną wysyłkę	t	\N	2025-09-30 09:55:50.334	\N	2025-10-09 19:57:56.94902	ONLINE	f	[{"id": "RFBEOjEwMjY2NDYyOTY4OTVV", "waybill": "1026646296895U", "carrierId": "DPD", "createdAt": "2025-10-02T05:54:46.455Z", "lineItems": [{"id": "7372dd50-9de3-11f0-9fa0-ab34abe0805b"}]}, {"id": "RFBEOjEwMjY2NDYyOTY5MDZV", "waybill": "1026646296906U", "carrierId": "DPD", "createdAt": "2025-10-02T05:54:46.617Z", "lineItems": [{"id": "7372dd50-9de3-11f0-9fa0-ab34abe0805b"}]}]	\N	0.00	\N	[]	f
7880	0c5badf0-9de2-11f0-a07b-27f19dcfd61a	\N	\N	2025-09-30 09:44:31.776	READY_FOR_PROCESSING	allegro-pl	28940504	kozik696	d01gto408n+150287d80@allegromail.pl	\N	Urszula Koziatek	+48 502 917 134	Osiedleńcza 32	12-100	Szczytno	PL	0c7e9f7d-9de2-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-30 09:44:31.776	\N	2025-10-09 19:57:58.390649	ONLINE	f	[{"id": "RFBEOjEwMjY1MjIxMTgxNjhV", "waybill": "1026522118168U", "carrierId": "DPD", "createdAt": "2025-09-30T11:26:57.455Z", "lineItems": [{"id": "0c56a4e0-9de2-11f0-a07b-27f19dcfd61a"}]}]	\N	0.00	\N	[]	f
7881	3eb44790-9de1-11f0-86f1-176f8757ee95	\N	\N	2025-09-30 09:42:14.277	READY_FOR_PROCESSING	allegro-pl	90892065	Falcon-14-	rp9su4q41p+389242421@allegromail.pl	\N	Krystian Pietruszka	+48 888 664 913	Ubieszyn 200	37-204	Tryńcza	PL	3edbf3f4-9de1-11f0-91d4-7961b40d7b05	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	H1 czarny, WE1 welur czarny	t	\N	2025-09-30 09:42:14.277	\N	2025-10-09 19:58:00.080525	ONLINE	f	[{"id": "RFBEOjEwMjY2NDY0ODIyNDhV", "waybill": "1026646482248U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:24Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}, {"id": "RFBEOjEwMjY2NDY0ODIwNDlV", "waybill": "1026646482049U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:25.328Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}, {"id": "RFBEOjEwMjY2NDY0ODIxNTZV", "waybill": "1026646482156U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:25.472Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}]	\N	0.00	\N	[]	f
7882	85dfad80-9ddc-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-09-30 09:08:00.451	READY_FOR_PROCESSING	allegro-pl	48995678	Client:48995678	5h9di18g00+593958fc1@allegromail.pl	\N	Urszula Wasielewska	+48 507 682 471	Górki 29	05-155	Leoncin	PL	9122d40f-9ddc-11f0-b9a1-9fd75769370f	PAID	P24	t	193.00	PLN	Allegro Kurier DPD	0.00	PLN	193.00	PLN	\N	t	\N	2025-09-30 09:08:00.451	\N	2025-10-09 19:58:01.535305	ONLINE	f	[{"id": "RFBEOjEwMjY2NDcxMzI1NzdV", "waybill": "1026647132577U", "carrierId": "DPD", "createdAt": "2025-10-02T06:02:49.813Z", "lineItems": [{"id": "85db67c0-9ddc-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7883	b5d243a0-9ddb-11f0-956d-ab7d0b07bcfc	\N	\N	2025-09-30 09:02:28.042	READY_FOR_PROCESSING	allegro-pl	43076655	Client:43076655	p14qj8aomw+242978729@allegromail.pl	\N	Bożena Rozynek-Kloc	+48 501 975 512	Złota 3 / 20	78-100	Kołobrzeg	PL	d32b8ad7-9ddb-11f0-91d4-7961b40d7b05	PAID	AF	t	454.00	PLN	Allegro Kurier DPD	0.00	PLN	454.00	PLN	\N	t	\N	2025-09-30 09:02:28.042	\N	2025-10-09 19:58:03.011366	ONLINE	f	[{"id": "RFBEOjEwMjY1MjIyMjcyOTdV", "waybill": "1026522227297U", "carrierId": "DPD", "createdAt": "2025-09-30T11:27:55.502Z", "lineItems": [{"id": "b5cd61a0-9ddb-11f0-956d-ab7d0b07bcfc"}]}]	\N	0.00	\N	[]	f
\.


--
-- Data for Name: products; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.products (id, product_id, external_id, name, description, image_url, category, created_at, updated_at) FROM stdin;
49	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	\N	\N	\N	2025-10-06 17:16:03.65876	2025-10-09 19:57:26.879438
27	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:00.268817	2025-10-09 19:57:02.766441
64	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:06.528834	2025-10-09 19:40:26.431286
3	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	\N	\N	\N	2025-10-06 17:15:54.931668	2025-10-06 20:34:44.62111
37	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:01.723085	2025-10-09 19:39:57.070851
5	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	\N	\N	\N	2025-10-06 17:15:55.367397	2025-10-06 20:34:45.449282
15	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	\N	\N	\N	2025-10-06 17:15:57.801176	2025-10-06 20:34:50.028838
33	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	\N	\N	\N	2025-10-06 17:16:01.144793	2025-10-09 19:52:56.006326
23	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:59.543827	2025-10-09 19:56:56.000052
17	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	\N	\N	\N	2025-10-06 17:15:58.24065	2025-10-06 20:34:50.851745
7	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	\N	\N	\N	2025-10-06 17:15:55.802962	2025-10-09 19:57:52.411291
12	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:57.290996	2025-10-09 19:57:50.952607
62	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	\N	\N	\N	2025-10-06 17:16:06.095193	2025-10-09 19:56:54.685248
30	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	\N	\N	\N	2025-10-06 17:16:00.779237	2025-10-09 19:41:00.64849
26	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	\N	\N	\N	2025-10-06 17:16:00.051972	2025-10-09 19:39:47.255143
29	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	\N	\N	2025-10-06 17:16:00.561855	2025-10-09 19:39:50.461152
18	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	\N	\N	\N	2025-10-06 17:15:58.457404	2025-10-06 20:34:51.264554
54	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-06 17:16:04.599818	2025-10-09 19:40:14.39478
24	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	\N	\N	\N	2025-10-06 17:15:59.76086	2025-10-09 19:39:45.567104
1	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	\N	\N	\N	2025-10-06 17:15:54.48828	2025-10-09 19:53:18.25358
55	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	\N	\N	\N	2025-10-06 17:16:04.818144	2025-10-09 19:40:15.890965
59	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-09 19:40:20.304219
11	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	\N	\N	\N	2025-10-06 17:15:56.714736	2025-10-06 20:34:47.944898
8	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:15:56.019495	2025-10-06 20:34:46.71877
21	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:15:59.112099	2025-10-06 20:34:52.478694
19	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	\N	\N	\N	2025-10-06 17:15:58.673348	2025-10-06 20:34:51.668214
14	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	\N	\N	\N	2025-10-06 17:15:57.584293	2025-10-06 20:34:49.624446
42	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:02.528744	2025-10-09 19:40:01.827597
51	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:03.948398	2025-10-09 19:40:09.875236
48	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	\N	\N	\N	2025-10-06 17:16:03.441281	2025-10-09 19:40:06.790098
34	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-09 19:39:55.275374
6	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	\N	\N	\N	2025-10-06 17:15:55.584	2025-10-06 20:34:45.860476
31	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	\N	\N	\N	2025-10-06 17:16:00.779237	2025-10-09 19:39:51.969786
65	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-06 17:16:06.745646	2025-10-09 19:41:21.538709
41	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	\N	\N	\N	2025-10-06 17:16:02.302127	2025-10-09 19:57:58.390649
53	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	\N	\N	\N	2025-10-06 17:16:04.383082	2025-10-09 19:40:12.904683
63	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:06.312678	2025-10-09 19:40:24.949312
16	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:15:58.019796	2025-10-09 19:40:05.138351
2	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:15:54.712851	2025-10-09 19:57:31.206095
9	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	\N	\N	\N	2025-10-06 17:15:56.281456	2025-10-09 19:57:21.523599
39	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	\N	\N	\N	2025-10-06 17:16:02.012334	2025-10-09 19:39:58.724698
43	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:02.750302	2025-10-09 19:40:03.351154
57	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-06 17:16:05.11784	2025-10-09 19:57:38.745835
25	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	\N	\N	\N	2025-10-06 17:15:59.76086	2025-10-09 19:39:45.567104
28	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:00.268817	2025-10-09 19:39:48.761018
40	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	\N	\N	\N	2025-10-06 17:16:02.012334	2025-10-09 19:39:58.724698
35	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-09 19:39:55.275374
44	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:02.750302	2025-10-09 19:40:03.351154
50	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	\N	\N	\N	2025-10-06 17:16:03.65876	2025-10-09 19:40:08.266022
47	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	\N	\N	\N	2025-10-06 17:16:03.113694	2025-10-09 19:40:05.138351
38	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	\N	\N	\N	2025-10-06 17:16:01.723085	2025-10-09 19:39:57.070851
56	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:04.818144	2025-10-09 19:40:15.890965
60	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-09 19:40:20.304219
36	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-09 19:39:55.275374
45	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:02.750302	2025-10-09 19:40:03.351154
102	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	\N	\N	\N	2025-10-06 17:16:14.681236	2025-10-09 19:41:20.077393
2465	15463830012	5905806220605	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	\N	\N	\N	2025-10-06 19:06:28.487973	2025-10-06 20:34:39.878245
80	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:09.916884	2025-10-09 19:40:48.482457
347	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	\N	\N	\N	2025-10-06 17:47:48.719607	2025-10-06 20:34:42.05297
91	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	\N	\N	\N	2025-10-06 17:16:12.241757	2025-10-09 19:41:03.693467
83	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	\N	\N	\N	2025-10-06 17:16:10.568092	2025-10-09 19:57:00.131947
99	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	\N	\N	\N	2025-10-06 17:16:14.021211	2025-10-09 19:41:15.60664
74	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-06 17:16:08.608804	2025-10-09 19:40:38.630984
97	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:13.585282	2025-10-09 19:41:12.644539
78	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	\N	\N	\N	2025-10-06 17:16:09.483689	2025-10-09 19:40:45.426522
348	16859417789	5905806210613	Półka ścienna 80x18x20cm CZARNY	\N	\N	\N	2025-10-06 17:47:48.935022	2025-10-06 20:34:42.462722
98	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	\N	\N	\N	2025-10-06 17:16:13.804885	2025-10-09 19:52:51.327492
75	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	\N	\N	\N	2025-10-06 17:16:08.824264	2025-10-09 19:57:20.184865
13	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	\N	\N	\N	2025-10-06 17:15:57.290996	2025-10-09 19:53:23.050134
4261	13855292522	5905806200010	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	\N	\N	\N	2025-10-09 19:30:10.421346	2025-10-09 19:32:59.478629
2071	14384920401	5905806201840	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	\N	\N	\N	2025-10-06 18:54:54.271088	2025-10-06 20:34:40.421628
87	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:11.149895	2025-10-09 19:58:03.011366
105	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	\N	\N	\N	2025-10-06 17:16:15.373135	2025-10-09 19:41:24.543023
104	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	\N	\N	\N	2025-10-06 17:16:15.120059	2025-10-09 19:41:22.997025
81	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	\N	\N	\N	2025-10-06 17:16:10.134542	2025-10-09 19:40:49.965101
82	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	\N	\N	\N	2025-10-06 17:16:10.351011	2025-10-09 19:40:51.486052
112	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	\N	\N	\N	2025-10-06 17:16:16.919578	2025-10-06 17:22:43.502874
113	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	\N	\N	\N	2025-10-06 17:16:17.140211	2025-10-06 17:22:43.709715
88	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:11.372612	2025-10-09 19:40:57.767472
90	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	\N	\N	\N	2025-10-06 17:16:11.988705	2025-10-09 19:41:02.125041
61	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-09 19:40:20.304219
921	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	\N	\N	\N	2025-10-06 18:33:52.316864	2025-10-06 20:34:41.2389
94	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	\N	\N	\N	2025-10-06 17:16:12.929991	2025-10-09 19:57:46.731225
115	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:17.582405	2025-10-09 19:52:23.59694
77	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	\N	\N	\N	2025-10-06 17:16:09.262461	2025-10-09 19:40:43.902051
109	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	\N	\N	\N	2025-10-06 17:16:16.253145	2025-10-06 18:44:05.727554
114	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	\N	\N	\N	2025-10-06 17:16:17.357182	2025-10-09 19:57:32.670068
106	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	\N	\N	\N	2025-10-06 17:16:15.595209	2025-10-09 19:53:29.220197
93	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	\N	\N	\N	2025-10-06 17:16:12.713229	2025-10-09 19:56:46.384312
66	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:06.963906	2025-10-09 19:57:56.94902
4269	16859415981	5905806210293	Półka ścienna 50x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:31:22.023459	2025-10-09 19:33:05.168128
349	12487594410	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	\N	\N	\N	2025-10-06 17:47:49.145144	2025-10-06 20:34:42.937473
32	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	\N	\N	\N	2025-10-06 17:16:00.779237	2025-10-09 19:39:51.969786
4270	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:31:23.649783	2025-10-09 19:57:49.555196
101	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	\N	\N	\N	2025-10-06 17:16:14.4606	2025-10-09 19:41:18.581203
2464	15250482464	5905806215212	Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN	\N	\N	\N	2025-10-06 19:06:28.487973	2025-10-06 20:34:39.878245
4	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	\N	\N	\N	2025-10-06 17:15:55.148372	2025-10-09 19:40:30.915188
4281	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:40.905893	2025-10-09 19:52:28.20184
73	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:08.392572	2025-10-09 19:40:37.130684
70	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	\N	\N	\N	2025-10-06 17:16:07.872784	2025-10-09 19:53:21.391471
76	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	\N	\N	\N	2025-10-06 17:16:09.045078	2025-10-09 19:40:41.82403
4273	16271341145	5905806233391	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:28.322666	2025-10-09 19:33:10.435375
4278	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	\N	\N	\N	2025-10-09 19:31:36.142585	2025-10-09 19:33:17.087355
4274	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	\N	\N	\N	2025-10-09 19:31:29.906789	2025-10-09 19:53:08.982673
350	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	\N	\N	\N	2025-10-06 17:47:49.356668	2025-10-09 19:33:07.807719
72	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	\N	\N	\N	2025-10-06 17:16:08.165996	2025-10-09 19:57:24.177602
4275	16602435285	5905806234589	Komoda Bini 50x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:31.443342	2025-10-09 19:33:13.158206
92	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:12.494462	2025-10-09 19:53:16.741965
4279	14387672711	5905806202335	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	\N	\N	\N	2025-10-09 19:31:37.693463	2025-10-09 19:33:18.40805
84	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	\N	\N	\N	2025-10-06 17:16:10.568092	2025-10-09 19:40:52.977557
4392	16415944014	5905806231885	Szafka na buty VB100x30D2N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:59.370898	2025-10-09 19:34:59.370898
4280	16901480273	5905806234022	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	\N	\N	\N	2025-10-09 19:31:37.693463	2025-10-09 19:33:18.40805
4361	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:18.70771	2025-10-09 19:35:02.367047
4287	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:31:51.486236	2025-10-09 19:33:31.441819
4401	12263585961	5905204699218	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:35:12.962774	2025-10-09 19:35:12.962774
4289	15876902214	5905806215175	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	\N	\N	\N	2025-10-09 19:31:54.529971	2025-10-09 19:33:34.232752
4291	15225620833	5905806213386	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY	\N	\N	\N	2025-10-09 19:31:57.659294	2025-10-09 19:33:37.044975
4292	14388158414	5905806202694	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	\N	\N	\N	2025-10-09 19:31:59.239898	2025-10-09 19:33:38.4484
4518	16644957145	5905806204179	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	\N	\N	\N	2025-10-09 19:52:52.87265	2025-10-09 19:52:52.87265
4294	17358967427	5905806237825	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	\N	\N	\N	2025-10-09 19:32:02.509518	2025-10-09 19:33:41.242995
4525	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	\N	\N	\N	2025-10-09 19:53:02.566909	2025-10-09 19:57:37.239716
4345	10862932479	5905806209532	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	\N	\N	\N	2025-10-09 19:33:55.297684	2025-10-09 19:33:55.297684
4347	15178440255	5905806210118	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	\N	\N	\N	2025-10-09 19:33:58.363732	2025-10-09 19:33:58.363732
4350	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	\N	\N	\N	2025-10-09 19:34:03.124553	2025-10-09 19:34:03.124553
4351	15919730348	5905806228830	Komoda Bones 60x30D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:04.745058	2025-10-09 19:34:04.745058
4352	16521833793	5905806227130	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	\N	\N	\N	2025-10-09 19:34:06.275499	2025-10-09 19:34:06.275499
4353	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	\N	\N	\N	2025-10-09 19:34:06.275499	2025-10-09 19:34:06.275499
4359	15321911032	5905806216912	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	\N	\N	\N	2025-10-09 19:34:15.671607	2025-10-09 19:34:15.671607
4508	15446678390	5905806219623	Szafka na buty 60x30D2N1Supra SONOMA	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:52:37.640577
4366	14910130346	5905806204049	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:34:27.019116	2025-10-09 19:34:27.019116
4367	14910130495	5905806204056	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	\N	\N	\N	2025-10-09 19:34:28.488246	2025-10-09 19:34:28.488246
4369	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:34:31.511017	2025-10-09 19:34:33.083616
4403	14024671782	5905806201307	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	\N	\N	\N	2025-10-09 19:35:15.94631	2025-10-09 19:35:15.94631
4375	15319542575	5905806213973	Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN	\N	\N	\N	2025-10-09 19:34:39.487081	2025-10-09 19:34:39.487081
4376	16625971969	5905806222524	Siedzisko tapicerowane 80x29cm do szafki 80x30	\N	\N	\N	2025-10-09 19:34:41.063664	2025-10-09 19:34:41.063664
4372	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	\N	\N	\N	2025-10-09 19:34:35.013449	2025-10-09 19:34:42.565499
4378	17636751422	5905806205121	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	\N	\N	\N	2025-10-09 19:34:44.063468	2025-10-09 19:34:44.063468
4383	12196226645	5905806203615	Wieszak ścienny WP80 na ubrania 80cm Lancelot	\N	\N	\N	2025-10-09 19:34:48.866238	2025-10-09 19:34:48.866238
4384	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:50.349499	2025-10-09 19:34:51.982135
4304	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-09 19:32:16.817152	2025-10-09 19:57:35.69216
4389	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	\N	\N	\N	2025-10-09 19:34:54.833203	2025-10-09 19:34:54.833203
4390	15221332021	5905806214130	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	\N	\N	\N	2025-10-09 19:34:56.309954	2025-10-09 19:34:56.309954
4391	16276325492	5905806233957	Komoda Bini 60x36D1N1 BIAŁY	\N	\N	\N	2025-10-09 19:34:57.866778	2025-10-09 19:34:57.866778
4405	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	\N	\N	\N	2025-10-09 19:35:18.983524	2025-10-09 19:35:18.983524
4411	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:35:30.351716	2025-10-09 19:58:00.080525
4407	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-09 19:35:22.641558	2025-10-09 19:35:22.641558
4530	12476571893	5905204699492	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:53:10.465002	2025-10-09 19:53:10.465002
4282	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:42.479409	2025-10-09 20:15:49.82405
4509	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:56:39.284741
85	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	\N	\N	\N	2025-10-06 17:16:10.568092	2025-10-09 19:40:52.977557
4368	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-09 19:34:29.944915	2025-10-09 19:57:04.087597
4503	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	\N	\N	\N	2025-10-09 19:52:32.634675	2025-10-09 19:52:32.634675
4404	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	\N	\N	\N	2025-10-09 19:35:17.471156	2025-10-09 19:56:58.835539
4506	12258788829	5905806216936	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:52:37.640577
4507	11742813479	5905806204025	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:52:37.640577
4510	15225574066	5905806213461	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY	\N	\N	\N	2025-10-09 19:52:39.753389	2025-10-09 19:52:39.753389
4293	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	\N	\N	\N	2025-10-09 19:32:00.94504	2025-10-09 19:52:41.570887
4513	16383693560	5905806234046	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	\N	\N	\N	2025-10-09 19:52:44.773914	2025-10-09 19:52:44.773914
4515	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	\N	\N	\N	2025-10-09 19:52:48.104858	2025-10-09 19:52:48.104858
4516	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	\N	\N	\N	2025-10-09 19:52:49.691873	2025-10-09 19:52:49.691873
4522	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-09 19:52:59.035883	2025-10-09 19:52:59.035883
4523	15315961595	5905806214673	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	\N	\N	\N	2025-10-09 19:53:00.995018	2025-10-09 19:53:00.995018
4362	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:34:20.228418	2025-10-09 19:53:04.368113
4381	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:34:47.220975	2025-10-09 19:57:09.349826
71	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	\N	\N	\N	2025-10-06 17:16:07.872784	2025-10-09 19:56:30.606999
4527	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:53:05.921164	2025-10-09 19:57:45.32572
4380	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:34:45.591752	2025-10-09 19:57:52.411291
4349	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	\N	\N	\N	2025-10-09 19:34:01.533573	2025-10-09 19:53:13.524776
4533	16602441323	5905806234770	Komoda Bini 100x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:15.032791	2025-10-09 19:53:15.032791
4536	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	\N	\N	\N	2025-10-09 19:53:19.823755	2025-10-09 19:53:19.823755
4537	15251019919	5905806204162	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:21.391471	2025-10-09 19:53:21.391471
4542	16383698094	5905806234084	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	\N	\N	\N	2025-10-09 19:53:26.173347	2025-10-09 19:53:26.173347
4543	15134391509	5905806209372	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	\N	\N	\N	2025-10-09 19:53:27.696527	2025-10-09 19:53:27.696527
4589	15193798429	5905806213133	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	\N	\N	\N	2025-10-09 19:54:36.654006	2025-10-09 19:54:36.654006
4547	12266500239	5905204699126	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA	\N	\N	\N	2025-10-09 19:53:33.737674	2025-10-09 19:56:32.292077
4553	17358870548	5905806237849	Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:53:42.878691	2025-10-09 19:56:40.880156
4558	12405971238	5905204699140	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:53:51.995858	2025-10-09 19:56:49.168469
4560	15258837181	5905806211023	Wieszak ścienny W60 na ubrania 60cm LANCELOT	\N	\N	\N	2025-10-09 19:53:53.565148	2025-10-09 19:56:50.506069
4561	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	\N	\N	\N	2025-10-09 19:53:55.230226	2025-10-09 19:56:51.957313
4565	17477972814	5905806238716 	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	\N	\N	\N	2025-10-09 19:54:01.464395	2025-10-09 19:56:57.338125
4566	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	\N	\N	\N	2025-10-09 19:54:01.464395	2025-10-09 19:56:57.338125
4569	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	\N	\N	\N	2025-10-09 19:54:06.148716	2025-10-09 19:57:01.41938
4574	16271343737	5905806233476	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	\N	\N	\N	2025-10-09 19:54:13.839513	2025-10-09 19:57:08.02041
4582	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-09 19:54:25.797748	2025-10-09 19:57:18.846639
4585	16760747405	5905806236156	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:54:30.407398	2025-10-09 19:57:22.849985
4633	15919629053	5905806228588	Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA	\N	\N	\N	2025-10-09 19:57:29.728304	2025-10-09 19:57:29.728304
4636	12266500390	5905204699133	Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-09 19:57:34.124208	2025-10-09 19:57:34.124208
4640	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	\N	\N	\N	2025-10-09 19:57:40.882458	2025-10-09 19:57:40.882458
4650	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:57:53.994553	2025-10-09 19:57:53.994553
4651	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	\N	\N	\N	2025-10-09 19:57:55.455939	2025-10-09 19:57:55.455939
4655	15258837630	5905806211030	Wieszak ścienny W60 na ubrania 60cm ARISTAN	\N	\N	\N	2025-10-09 19:58:01.535305	2025-10-09 19:58:01.535305
4551	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	\N	\N	\N	2025-10-09 19:53:39.800122	2025-10-09 20:20:44.305026
\.


--
-- Data for Name: sync_logs; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.sync_logs (id, sync_started_at, sync_completed_at, status, orders_fetched, orders_new, orders_updated, error_message, sync_duration_ms) FROM stdin;
1	2025-10-06 15:09:30.474	2025-10-06 15:09:50.029	SUCCESS	100	2	98	\N	19555
2	2025-10-06 15:12:50.103	2025-10-06 15:13:10.006	SUCCESS	100	0	100	\N	19903
3	2025-10-06 15:15:50.103	2025-10-06 15:16:09.415	SUCCESS	100	0	100	\N	19312
4	2025-10-06 15:17:53.012	2025-10-06 15:17:53.05	ERROR	0	0	0	No active connection	38
5	2025-10-06 15:21:07.453	2025-10-06 15:21:09.745	ERROR	0	0	0	No active connection	2292
6	2025-10-06 15:22:24.415	2025-10-06 15:22:24.692	ERROR	0	0	0	No active connection	277
7	2025-10-06 15:29:11.574	2025-10-06 15:29:11.625	ERROR	0	0	0	No active connection	51
8	2025-10-06 15:29:12.15	2025-10-06 15:29:12.437	ERROR	0	0	0	No active connection	287
9	2025-10-06 15:40:54.62	2025-10-06 15:41:14.559	SUCCESS	100	1	99	\N	19939
10	2025-10-06 15:44:46.596	2025-10-06 15:45:06.706	SUCCESS	100	0	100	\N	20110
11	2025-10-06 15:48:06.782	\N	RUNNING	0	0	0	\N	\N
12	2025-10-06 15:51:30.818	2025-10-06 15:51:50.922	SUCCESS	100	1	99	\N	20104
13	2025-10-06 15:56:25.687	2025-10-06 15:56:46.051	SUCCESS	100	0	100	\N	20364
14	2025-10-06 16:01:05.942	2025-10-06 16:01:25.678	SUCCESS	100	0	100	\N	19736
15	2025-10-06 16:03:38.978	2025-10-06 16:03:57.923	SUCCESS	100	0	100	\N	18945
16	2025-10-06 16:04:25.752	2025-10-06 16:04:45.923	SUCCESS	100	0	100	\N	20171
17	2025-10-06 16:07:25.752	2025-10-06 16:07:45.077	SUCCESS	100	0	100	\N	19325
18	2025-10-06 16:10:25.752	2025-10-06 16:10:47.373	SUCCESS	100	0	100	\N	21621
19	2025-10-06 16:13:59.027	2025-10-06 16:14:21.421	SUCCESS	100	0	100	\N	22394
20	2025-10-06 16:17:21.511	2025-10-06 16:17:43.942	SUCCESS	100	0	100	\N	22431
21	2025-10-06 16:20:21.511	2025-10-06 16:20:41.131	SUCCESS	100	0	100	\N	19620
22	2025-10-06 16:23:21.511	2025-10-06 16:23:41.731	SUCCESS	100	1	99	\N	20220
23	2025-10-06 16:26:21.512	2025-10-06 16:26:40.902	SUCCESS	100	0	100	\N	19390
24	2025-10-06 16:29:21.513	2025-10-06 16:29:41.814	SUCCESS	100	0	100	\N	20301
25	2025-10-06 16:32:21.516	2025-10-06 16:32:42.029	SUCCESS	100	0	100	\N	20513
26	2025-10-06 16:35:21.516	2025-10-06 16:35:41.663	SUCCESS	100	0	100	\N	20147
27	2025-10-06 16:37:00.95	2025-10-06 16:37:20.764	SUCCESS	100	0	100	\N	19814
28	2025-10-06 16:40:20.837	2025-10-06 16:40:42.877	SUCCESS	100	0	100	\N	22040
29	2025-10-06 16:43:20.837	2025-10-06 16:43:41.121	SUCCESS	100	1	99	\N	20284
30	2025-10-06 16:45:11.851	2025-10-06 16:45:31.267	SUCCESS	100	1	99	\N	19416
31	2025-10-06 16:48:31.336	2025-10-06 16:48:53.366	SUCCESS	100	0	100	\N	22030
32	2025-10-06 16:49:38.341	2025-10-06 16:49:57.684	SUCCESS	100	0	100	\N	19343
33	2025-10-06 16:52:57.753	2025-10-06 16:53:20.124	SUCCESS	100	0	100	\N	22371
34	2025-10-06 16:55:57.754	2025-10-06 16:56:17.405	SUCCESS	100	0	100	\N	19651
35	2025-10-06 16:58:57.755	2025-10-06 16:59:17.615	SUCCESS	100	0	100	\N	19860
36	2025-10-06 17:01:57.755	2025-10-06 17:02:17.964	SUCCESS	100	1	99	\N	20209
37	2025-10-06 17:10:39.111	2025-10-06 17:10:58.808	SUCCESS	100	0	100	\N	19697
38	2025-10-06 17:15:53.189	2025-10-06 17:16:17.783	SUCCESS	100	0	100	\N	24594
39	2025-10-06 17:19:17.856	2025-10-06 17:19:44.515	SUCCESS	100	0	100	\N	26659
40	2025-10-06 17:22:17.857	2025-10-06 17:22:44.314	SUCCESS	100	0	100	\N	26457
41	2025-10-06 17:47:47.375	2025-10-06 17:48:11.223	SUCCESS	100	5	95	\N	23848
42	2025-10-06 17:51:11.298	2025-10-06 17:51:37.765	SUCCESS	100	0	100	\N	26467
43	2025-10-06 18:09:49.784	2025-10-06 18:10:14.362	SUCCESS	100	0	100	\N	24578
44	2025-10-06 18:13:14.44	2025-10-06 18:13:40.761	SUCCESS	100	0	100	\N	26321
45	2025-10-06 18:16:14.441	2025-10-06 18:16:40.661	SUCCESS	100	0	100	\N	26220
46	2025-10-06 18:33:51.029	2025-10-06 18:34:15.269	SUCCESS	100	1	99	\N	24240
47	2025-10-06 18:37:15.347	2025-10-06 18:37:38.89	SUCCESS	100	0	100	\N	23543
48	2025-10-06 18:40:15.348	2025-10-06 18:40:38.473	SUCCESS	100	0	100	\N	23125
49	2025-10-06 18:41:42.458	2025-10-06 18:42:05.524	SUCCESS	100	0	100	\N	23066
50	2025-10-06 18:42:42.459	2025-10-06 18:43:06.02	SUCCESS	100	0	100	\N	23561
51	2025-10-06 18:43:09.267	2025-10-06 18:43:33.018	SUCCESS	100	0	100	\N	23751
52	2025-10-06 18:43:42.459	2025-10-06 18:44:05.926	SUCCESS	100	0	100	\N	23467
53	2025-10-06 18:46:16.258	2025-10-06 18:46:40.189	SUCCESS	100	1	99	\N	23931
54	2025-10-06 18:51:28.672	2025-10-06 18:51:55.116	SUCCESS	100	0	100	\N	26444
55	2025-10-06 18:52:31.548	2025-10-06 18:52:55.13	SUCCESS	100	0	100	\N	23582
56	2025-10-06 18:54:52.979	2025-10-06 18:55:16.66	SUCCESS	100	1	99	\N	23681
57	2025-10-06 18:57:28.262	2025-10-06 18:57:51.655	SUCCESS	100	0	100	\N	23393
58	2025-10-06 19:00:32.241	2025-10-06 19:00:55.318	SUCCESS	100	0	100	\N	23077
59	2025-10-06 19:01:32.242	\N	RUNNING	0	0	0	\N	\N
60	2025-10-06 19:06:27.231	2025-10-06 19:06:50.902	SUCCESS	100	1	99	\N	23671
61	2025-10-06 19:08:09.451	2025-10-06 19:08:33.216	SUCCESS	100	0	100	\N	23765
62	2025-10-06 19:09:50.973	2025-10-06 19:10:14.693	SUCCESS	100	0	100	\N	23720
63	2025-10-06 19:16:28.842	2025-10-06 19:16:53.529	SUCCESS	100	0	100	\N	24687
64	2025-10-06 19:19:00.109	\N	RUNNING	0	0	0	\N	\N
65	2025-10-06 19:25:31.047	2025-10-06 19:25:56.919	SUCCESS	100	0	0	\N	25872
66	2025-10-06 19:28:35.67	2025-10-06 19:28:58.632	SUCCESS	100	0	0	\N	22962
67	2025-10-06 19:32:55.188	2025-10-06 19:32:55.536	ERROR	0	0	0	No active connection	348
68	2025-10-06 19:33:21.773	2025-10-06 19:34:08.194	SUCCESS	100	10	90	\N	46421
69	2025-10-06 19:38:16.756	2025-10-06 19:38:17.03	ERROR	0	0	0	No active connection	274
70	2025-10-06 19:38:21.403	\N	RUNNING	0	0	0	\N	\N
71	2025-10-06 19:44:43.47	2025-10-06 19:45:29.711	SUCCESS	100	0	100	\N	46241
72	2025-10-06 20:11:48.021	2025-10-06 20:12:35.36	SUCCESS	100	0	100	\N	47339
73	2025-10-06 20:15:35.436	2025-10-06 20:16:22.475	SUCCESS	100	0	100	\N	47039
74	2025-10-06 20:18:32.553	2025-10-06 20:19:20.821	SUCCESS	100	0	100	\N	48268
75	2025-10-06 20:19:32.553	2025-10-06 20:20:20.113	SUCCESS	100	0	100	\N	47560
76	2025-10-06 20:20:32.553	\N	RUNNING	0	0	0	\N	\N
77	2025-10-06 20:27:49.842	2025-10-06 20:28:36.692	SUCCESS	100	0	100	\N	46850
78	2025-10-06 20:31:36.765	2025-10-06 20:32:24.972	SUCCESS	100	0	100	\N	48207
79	2025-10-06 20:34:36.765	2025-10-06 20:35:22.54	SUCCESS	100	0	100	\N	45775
81	2025-10-09 18:39:35.712	2025-10-09 18:40:40.699	ERROR	100	0	0	column "order_code" can only be updated to DEFAULT	64987
82	2025-10-09 18:41:08.455	2025-10-09 18:41:09.174	ERROR	0	0	0	column "order_code" can only be updated to DEFAULT	719
83	2025-10-09 18:48:14.64	2025-10-09 18:48:15.093	ERROR	0	0	0	relation "commerce.orders_order_number_seq" does not exist	453
84	2025-10-09 18:49:14.64	2025-10-09 18:49:15.451	ERROR	0	0	0	relation "commerce.orders_order_number_seq" does not exist	811
85	2025-10-09 18:52:57.479	2025-10-09 18:52:58.277	SUCCESS	0	0	0	\N	798
86	2025-10-09 18:53:58.392	2025-10-09 18:53:59.449	SUCCESS	0	0	0	\N	1057
87	2025-10-09 18:54:58.393	2025-10-09 18:54:59.165	SUCCESS	0	0	0	\N	772
88	2025-10-09 18:55:54.277	2025-10-09 18:55:55.066	SUCCESS	0	0	0	\N	789
89	2025-10-09 18:55:58.394	2025-10-09 18:55:58.837	SUCCESS	0	0	0	\N	443
90	2025-10-09 18:57:21.506	2025-10-09 18:57:22.318	SUCCESS	0	0	0	\N	812
91	2025-10-09 18:58:22.428	2025-10-09 18:58:23.483	SUCCESS	0	0	0	\N	1055
92	2025-10-09 18:59:22.428	2025-10-09 18:59:23.216	SUCCESS	0	0	0	\N	788
93	2025-10-09 19:16:50.406	2025-10-09 19:16:52.086	SUCCESS	1	0	0	\N	1680
94	2025-10-09 19:17:52.194	2025-10-09 19:17:52.977	SUCCESS	0	0	0	\N	783
95	2025-10-09 19:18:52.195	2025-10-09 19:18:52.993	SUCCESS	0	0	0	\N	798
96	2025-10-09 19:19:52.195	2025-10-09 19:19:53.222	SUCCESS	0	0	0	\N	1027
97	2025-10-09 19:20:41.597	2025-10-09 19:20:42.403	SUCCESS	0	0	0	\N	806
98	2025-10-09 19:21:42.516	2025-10-09 19:21:43.283	SUCCESS	0	0	0	\N	767
99	2025-10-09 19:23:03.119	2025-10-09 19:23:03.901	SUCCESS	0	0	0	\N	782
100	2025-10-09 19:24:03.119	2025-10-09 19:24:03.917	SUCCESS	0	0	0	\N	798
101	2025-10-09 19:25:03.119	2025-10-09 19:25:04.122	SUCCESS	0	0	0	\N	1003
102	2025-10-09 19:26:03.544	2025-10-09 19:26:04.335	SUCCESS	0	0	0	\N	791
103	2025-10-09 19:27:04.446	2025-10-09 19:27:05.521	SUCCESS	0	0	0	\N	1075
104	2025-10-09 19:27:07.387	2025-10-09 19:27:07.855	SUCCESS	0	0	0	\N	468
105	2025-10-09 19:28:07.972	2025-10-09 19:28:08.762	SUCCESS	0	0	0	\N	790
106	2025-10-09 19:29:07.973	2025-10-09 19:29:08.779	SUCCESS	0	0	0	\N	806
107	2025-10-09 19:29:27.248	2025-10-09 19:29:27.934	SUCCESS	0	0	0	\N	686
108	2025-10-09 19:31:17.138	2025-10-09 19:31:18.191	SUCCESS	0	0	0	\N	1053
109	2025-10-09 19:32:17.137	2025-10-09 19:32:17.601	SUCCESS	0	0	0	\N	464
110	2025-10-09 19:33:21.223	2025-10-09 19:33:22.406	SUCCESS	0	0	0	\N	1183
111	2025-10-09 19:34:21.222	2025-10-09 19:34:21.673	SUCCESS	0	0	0	\N	451
112	2025-10-09 19:35:21.223	2025-10-09 19:35:21.881	SUCCESS	0	0	0	\N	658
113	2025-10-09 19:37:10.916	2025-10-09 19:37:12.139	SUCCESS	0	0	0	\N	1223
114	2025-10-09 19:38:42.807	2025-10-09 19:38:43.623	SUCCESS	0	0	0	\N	816
115	2025-10-09 19:39:42.807	2025-10-09 19:39:43.617	SUCCESS	0	0	0	\N	810
116	2025-10-09 19:40:42.806	2025-10-09 19:40:43.243	SUCCESS	0	0	0	\N	437
117	2025-10-09 19:42:28.559	2025-10-09 19:42:29.838	SUCCESS	0	0	0	\N	1279
118	2025-10-09 19:43:28.558	2025-10-09 19:43:29.583	SUCCESS	0	0	0	\N	1025
119	2025-10-09 19:44:28.558	2025-10-09 19:44:29.566	SUCCESS	0	0	0	\N	1008
120	2025-10-09 19:45:28.558	2025-10-09 19:45:29.791	SUCCESS	0	0	0	\N	1233
121	2025-10-09 19:46:57.671	2025-10-09 19:46:58.987	SUCCESS	0	0	0	\N	1316
122	2025-10-09 19:47:57.672	2025-10-09 19:47:58.911	SUCCESS	0	0	0	\N	1239
123	2025-10-09 19:48:57.673	2025-10-09 19:48:58.933	SUCCESS	0	0	0	\N	1260
124	2025-10-09 19:49:57.673	2025-10-09 19:49:58.752	SUCCESS	0	0	0	\N	1079
125	2025-10-09 19:51:39.818	2025-10-09 19:51:40.66	SUCCESS	0	0	0	\N	842
126	2025-10-09 19:52:39.817	2025-10-09 19:52:41.034	SUCCESS	0	0	0	\N	1217
127	2025-10-09 19:53:39.817	2025-10-09 19:53:41.074	SUCCESS	0	0	0	\N	1257
128	2025-10-09 19:54:39.817	2025-10-09 19:54:40.33	SUCCESS	0	0	0	\N	513
129	2025-10-09 19:55:39.817	2025-10-09 19:55:41.081	SUCCESS	0	0	0	\N	1264
130	2025-10-09 19:56:39.817	2025-10-09 19:56:40.627	SUCCESS	0	0	0	\N	810
131	2025-10-09 19:57:39.817	2025-10-09 19:57:40.273	SUCCESS	0	0	0	\N	456
132	2025-10-09 19:59:05.966	2025-10-09 19:59:06.991	SUCCESS	0	0	0	\N	1025
133	2025-10-09 20:00:05.967	2025-10-09 20:00:07.218	SUCCESS	0	0	0	\N	1251
134	2025-10-09 20:01:05.967	2025-10-09 20:01:07.007	SUCCESS	0	0	0	\N	1040
135	2025-10-09 20:02:05.968	2025-10-09 20:02:07.22	SUCCESS	0	0	0	\N	1252
136	2025-10-09 20:03:05.968	2025-10-09 20:03:06.785	SUCCESS	0	0	0	\N	817
137	2025-10-09 20:04:16.197	2025-10-09 20:04:17.529	SUCCESS	0	0	0	\N	1332
138	2025-10-09 20:05:16.196	2025-10-09 20:05:17.206	SUCCESS	0	0	0	\N	1010
139	2025-10-09 20:06:16.197	2025-10-09 20:06:17.478	SUCCESS	0	0	0	\N	1281
140	2025-10-09 20:07:16.196	2025-10-09 20:07:16.979	SUCCESS	0	0	0	\N	783
141	2025-10-09 20:08:16.196	2025-10-09 20:08:16.97	SUCCESS	0	0	0	\N	774
142	2025-10-09 20:09:57.682	2025-10-09 20:09:58.529	SUCCESS	0	0	0	\N	847
143	2025-10-09 20:10:57.682	2025-10-09 20:10:58.713	SUCCESS	0	0	0	\N	1031
144	2025-10-09 20:11:57.683	2025-10-09 20:11:58.488	SUCCESS	0	0	0	\N	805
145	2025-10-09 20:12:57.684	2025-10-09 20:13:00.482	SUCCESS	1	0	1	\N	2798
146	2025-10-09 20:13:57.685	2025-10-09 20:14:00.853	SUCCESS	1	0	1	\N	3168
147	2025-10-09 20:15:27.224	2025-10-09 20:15:30.528	SUCCESS	1	0	1	\N	3304
148	2025-10-09 20:16:27.224	2025-10-09 20:16:30.048	SUCCESS	1	0	1	\N	2824
149	2025-10-09 20:17:27.226	2025-10-09 20:17:29.754	SUCCESS	1	0	1	\N	2528
150	2025-10-09 20:18:43.12	2025-10-09 20:18:46.154	SUCCESS	1	0	1	\N	3034
151	2025-10-09 20:19:43.121	2025-10-09 20:19:45.925	SUCCESS	1	0	1	\N	2804
152	2025-10-09 20:20:43.122	2025-10-09 20:20:45.903	SUCCESS	1	0	1	\N	2781
153	2025-10-09 20:22:35.734	2025-10-09 20:22:37.828	SUCCESS	1	0	0	\N	2094
154	2025-10-09 20:23:35.763	2025-10-09 20:23:37.577	SUCCESS	1	0	0	\N	1814
155	2025-10-09 20:24:35.793	2025-10-09 20:24:37.662	SUCCESS	1	0	0	\N	1869
156	2025-10-09 20:25:35.794	2025-10-09 20:25:37.577	SUCCESS	1	0	0	\N	1783
\.


--
-- Data for Name: products; Type: TABLE DATA; Schema: catalog; Owner: neondb_owner
--

COPY catalog.products (id, source, product_id, external_id, name, description, image_url, category, created_at, updated_at, raw_data) FROM stdin;
2	ALLEGRO	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:03.948398	2025-10-06 17:22:30.916739	\N
4	ALLEGRO	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	\N	\N	\N	2025-10-06 17:15:57.801176	2025-10-06 17:22:24.927228	\N
5	ALLEGRO	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-06 17:16:05.11784	2025-10-06 17:22:32.250706	\N
7	ALLEGRO	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:57.290996	2025-10-06 17:22:31.12584	\N
15	ALLEGRO	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:59.543827	2025-10-06 17:22:26.662347	\N
22	ALLEGRO	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:02.528744	2025-10-06 17:22:29.536323	\N
30	ALLEGRO	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:15:56.019495	2025-10-06 17:22:23.221558	\N
31	ALLEGRO	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-06 17:22:28.425145	\N
32	ALLEGRO	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:01.723085	2025-10-06 17:22:28.775281	\N
36	ALLEGRO	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-06 17:16:06.745646	2025-10-06 17:22:41.581542	\N
40	ALLEGRO	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:15:58.019796	2025-10-06 17:22:30.099521	\N
42	ALLEGRO	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	\N	\N	\N	2025-10-06 17:16:03.65876	2025-10-06 17:22:30.611858	\N
44	ALLEGRO	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-06 17:16:04.599818	2025-10-06 17:22:31.552868	\N
46	ALLEGRO	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:04.818144	2025-10-06 17:22:31.760269	\N
48	ALLEGRO	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-06 17:22:32.515181	\N
49	ALLEGRO	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-06 17:22:32.515181	\N
50	ALLEGRO	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	\N	5905806212952_1.jpg	\N	2025-10-06 17:16:06.095193	2025-10-09 19:06:29.061691	\N
52	ALLEGRO	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	5905204699454_1.jpg	\N	2025-10-06 17:16:06.528834	2025-10-09 19:06:33.827015	\N
16	ALLEGRO	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	\N	5905806238860_1.jpg	\N	2025-10-06 17:15:59.76086	2025-10-09 19:06:40.739629	\N
37	ALLEGRO	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	\N	5905806233896_1.jpg	\N	2025-10-06 17:16:02.750302	2025-10-09 19:06:02.713826	\N
28	ALLEGRO	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	\N	5905806200027_1.jpg	\N	2025-10-06 17:15:55.802962	2025-10-09 19:06:46.84282	\N
3	ALLEGRO	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	\N	5905806213034_1.jpg	\N	2025-10-06 17:15:58.457404	2025-10-09 19:06:25.86479	\N
12	ALLEGRO	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	\N	5905806231922_1.jpg	\N	2025-10-06 17:16:04.818144	2025-10-09 19:06:49.778923	\N
41	ALLEGRO	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	\N	5905806203578_1.jpg	\N	2025-10-06 17:16:03.113694	2025-10-06 20:29:18.424548	\N
21	ALLEGRO	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	\N	5905806201994_1.jpg	\N	2025-10-06 17:16:02.302127	2025-10-09 19:06:51.857579	\N
23	ALLEGRO	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	\N	5905204699973_1.jpg	\N	2025-10-06 17:16:03.65876	2025-10-06 20:29:22.02912	\N
8	ALLEGRO	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	\N	5905806237191_1.jpg	\N	2025-10-06 17:15:55.367397	2025-10-09 19:06:54.602816	\N
17	ALLEGRO	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	\N	5905806202045_1.jpg	\N	2025-10-06 17:15:56.714736	2025-10-09 19:06:55.672312	\N
10	ALLEGRO	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	\N	5905806202250_1.jpg	\N	2025-10-06 17:15:56.281456	2025-10-09 19:07:02.733555	\N
27	ALLEGRO	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	5905806202366_1.jpg	\N	2025-10-06 17:16:00.561855	2025-10-09 19:07:03.732208	\N
34	ALLEGRO	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	\N	5905806237160_1.jpg	\N	2025-10-06 17:16:02.012334	2025-10-09 19:07:13.618914	\N
20	ALLEGRO	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	\N	5905806203899_1.jpg	\N	2025-10-06 17:15:58.673348	2025-10-09 19:07:16.483515	\N
39	ALLEGRO	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	\N	5905806208337_1.jpg	\N	2025-10-06 17:15:54.48828	2025-10-09 19:07:25.916836	\N
56	ALLEGRO	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	\N	5905806208344_1.jpg	\N	2025-10-06 17:16:10.568092	2025-10-09 19:07:22.761862	\N
1	ALLEGRO	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	\N	5905806214192_1.jpg	\N	2025-10-06 17:16:01.144793	2025-10-09 19:07:28.67588	\N
6	ALLEGRO	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	\N	5905806218220_1.jpg	\N	2025-10-06 17:16:03.441281	2025-10-09 19:05:58.050342	\N
24	ALLEGRO	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	\N	5905806208788_1.jpg	\N	2025-10-06 17:16:00.051972	2025-10-09 19:07:29.695534	\N
57	ALLEGRO	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	\N	5905806214208_1.jpg	\N	2025-10-06 17:16:10.568092	2025-10-09 19:07:30.713542	\N
26	ALLEGRO	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	\N	5905806203790_1.jpg	\N	2025-10-06 17:16:00.268817	2025-10-09 19:07:40.69171	\N
33	ALLEGRO	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	\N	5905806203714_1.jpg	\N	2025-10-06 17:16:01.723085	2025-10-09 19:07:44.6666	\N
55	ALLEGRO	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	\N	5905806203677_1.jpg	\N	2025-10-06 17:16:01.360803	2025-10-09 19:07:45.912979	\N
35	ALLEGRO	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	\N	5905806221473_1.jpg	\N	2025-10-06 17:16:02.012334	2025-10-09 19:07:50.690279	\N
14	ALLEGRO	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	\N	5905806213423_1.jpg	\N	2025-10-06 17:15:55.584	2025-10-09 19:05:43.800369	\N
58	ALLEGRO	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	\N	5905204699591_1.jpg	\N	2025-10-06 17:16:14.021211	2025-10-09 19:05:52.770332	\N
47	ALLEGRO	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	\N	5905806216974_1.jpg	\N	2025-10-06 17:15:57.584293	2025-10-06 20:28:46.795152	\N
11	ALLEGRO	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	\N	5905806234558_1.jpg	\N	2025-10-06 17:16:00.779237	2025-10-09 19:06:01.612012	\N
13	ALLEGRO	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	\N	5905806234473_1.jpg	\N	2025-10-06 17:16:02.750302	2025-10-06 20:28:54.066652	\N
38	ALLEGRO	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	\N	5905806234596_1.jpg	\N	2025-10-06 17:16:02.750302	2025-10-09 19:06:04.606023	\N
29	ALLEGRO	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	\N	5905806234688_1.jpg	\N	2025-10-06 17:16:00.779237	2025-10-09 19:06:05.703613	\N
43	ALLEGRO	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	\N	5905806228229_1.jpg	\N	2025-10-06 17:15:58.24065	2025-10-09 19:06:14.814035	\N
25	ALLEGRO	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	\N	5905806209020_1.jpg	\N	2025-10-06 17:16:00.268817	2025-10-09 19:06:26.953561	\N
61	ALLEGRO	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	\N	\N	\N	2025-10-06 17:16:07.872784	2025-10-06 17:22:34.72799	\N
63	ALLEGRO	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:08.392572	2025-10-06 17:22:35.211303	\N
64	ALLEGRO	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:11.372612	2025-10-06 17:22:38.133873	\N
65	ALLEGRO	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	\N	\N	\N	2025-10-06 17:16:11.988705	2025-10-06 17:22:38.737	\N
67	ALLEGRO	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:12.494462	2025-10-06 17:22:39.219797	\N
73	ALLEGRO	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	\N	\N	\N	2025-10-06 17:16:15.120059	2025-10-06 17:22:41.788842	\N
74	ALLEGRO	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	\N	\N	\N	2025-10-06 17:16:15.373135	2025-10-06 17:22:42.030751	\N
76	ALLEGRO	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:13.585282	2025-10-06 17:22:42.667603	\N
80	ALLEGRO	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	\N	\N	\N	2025-10-06 17:16:13.804885	2025-10-06 17:22:40.537619	\N
82	ALLEGRO	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	\N	\N	\N	2025-10-06 17:16:17.357182	2025-10-06 17:22:43.916719	\N
84	ALLEGRO	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:17.582405	2025-10-06 17:22:44.123278	\N
85	ALLEGRO	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	\N	\N	\N	2025-10-06 17:16:09.045078	2025-10-06 17:22:35.837192	\N
87	ALLEGRO	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-06 17:22:32.515181	\N
88	ALLEGRO	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:06.963906	2025-10-06 17:22:33.859528	\N
169	SHOPER	918	5905806205473	Szafka na buty VB100x36D S1 siedzisko schowek 100cm Artisan	\N	5905806205473_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-09 19:06:44.748644	{"id": "27017", "tax": "0%", "code": "5905806205473", "name": "Szafka na buty VB100x36D S1 siedzisko schowek 100cm Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "546.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1277", "tax_value": "0", "product_id": "918", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
66	ALLEGRO	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	\N	5905806208429_1.jpg	\N	2025-10-06 17:16:12.241757	2025-10-09 19:06:21.945037	\N
75	ALLEGRO	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	\N	5905806206678_1.jpg	\N	2025-10-06 17:16:15.595209	2025-10-09 19:06:45.860481	\N
94	ALLEGRO	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	\N	5905806202199_1.jpg	\N	2025-10-06 17:16:10.351011	2025-10-09 19:06:57.816718	\N
81	ALLEGRO	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	\N	5905806216813_1.jpg	\N	2025-10-06 17:16:17.140211	2025-10-09 19:07:06.554588	\N
69	ALLEGRO	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	\N	5905806202380_1.jpg	\N	2025-10-06 17:16:12.929991	2025-10-09 19:07:09.492387	\N
78	ALLEGRO	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	\N	5905806202403_1.jpg	\N	2025-10-06 17:16:09.262461	2025-10-09 19:07:11.688683	\N
86	ALLEGRO	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	\N	5905806214109_1.jpg	\N	2025-10-06 17:16:00.779237	2025-10-09 19:07:17.734689	\N
60	ALLEGRO	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	\N	5905806208252_1.jpg	\N	2025-10-06 17:16:11.149895	2025-10-09 19:07:18.822512	\N
79	ALLEGRO	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	\N	5905806221923_1.jpg	\N	2025-10-06 17:16:16.919578	2025-10-09 19:07:19.953896	\N
93	ALLEGRO	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	\N	5905806208320_1.jpg	\N	2025-10-06 17:16:10.134542	2025-10-09 19:07:24.942329	\N
90	ALLEGRO	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	\N	5905806203660_1.jpg	\N	2025-10-06 17:15:57.290996	2025-10-09 19:07:43.535118	\N
168	SHOPER	910	5905806203592	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	\N	5905806203592_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-09 19:07:46.910727	{"id": "27016", "tax": "23%", "code": "5905806203592", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "278.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1269", "tax_value": "23", "product_id": "910", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
89	ALLEGRO	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	\N	5905806237795_1.jpg	\N	2025-10-06 17:15:55.148372	2025-10-09 19:05:54.621148	\N
68	ALLEGRO	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	\N	5905806217902_1.jpg	\N	2025-10-06 17:16:12.713229	2025-10-09 19:07:51.729782	\N
51	ALLEGRO	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	\N	5905806213379_1.jpg	\N	2025-10-06 17:16:06.312678	2025-10-09 19:05:43.075343	\N
83	ALLEGRO	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	5905806207569_1.jpg	\N	2025-10-06 17:16:08.608804	2025-10-09 19:05:48.835787	\N
91	ALLEGRO	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	\N	5905806229035_1.jpg	\N	2025-10-06 17:16:09.483689	2025-10-09 19:06:10.564901	\N
71	ALLEGRO	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	\N	5905806209549_1.jpg	\N	2025-10-06 17:16:14.4606	2025-10-09 19:06:28.154688	\N
72	ALLEGRO	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	\N	5905806209525_1.jpg	\N	2025-10-06 17:16:14.681236	2025-10-09 19:06:29.969858	\N
59	ALLEGRO	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	\N	5905806209662_1.jpg	\N	2025-10-06 17:16:07.872784	2025-10-09 19:06:30.891785	\N
70	ALLEGRO	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	\N	5905806208580_1.jpg	\N	2025-10-06 17:16:08.824264	2025-10-09 19:07:59.202239	\N
95	ALLEGRO	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	\N	5905806208986_1.jpg	\N	2025-10-06 17:16:10.568092	2025-10-09 19:06:31.825327	\N
92	ALLEGRO	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	\N	5905806233643_1.jpg	\N	2025-10-06 17:16:09.916884	2025-10-09 19:06:38.798278	\N
77	ALLEGRO	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	\N	5905806204087_1.jpg	\N	2025-10-06 17:16:16.253145	2025-10-09 19:06:41.909016	\N
62	ALLEGRO	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	\N	5905806205435_1.jpg	\N	2025-10-06 17:16:08.165996	2025-10-09 19:06:42.960207	\N
174	SHOPER	708	5905806202267	Szafka na buty VB80x30D S1 siedzisko schowek 80cm SO	\N	\N	\N	2025-10-06 18:33:07.700476	2025-10-06 18:33:07.700476	{"id": "27013", "tax": "0%", "code": "5905806202267", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm SO", "type": "0", "unit": "szt.", "pkwiu": "", "price": "399.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23150", "quantity": "1", "stock_id": "1037", "tax_value": "0", "product_id": "708", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
179	SHOPER	2806	5905806211016	Wieszak ścienny W60 na ubrania 60cm WOTAN	\N	\N	\N	2025-10-06 18:33:08.83739	2025-10-06 18:33:08.83739	{"id": "27010", "tax": "23%", "code": "5905806211016", "name": "Wieszak ścienny W60 na ubrania 60cm WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "193.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "3204", "tax_value": "23", "product_id": "2806", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
177	SHOPER	589	5905806217681	Szafka na buty z szufladą Tres2 60x92x30 DĄB WOTAN	\N	5905806217681_1.jpg	\N	2025-10-06 18:33:08.83739	2025-10-09 19:07:32.660709	{"id": "27008", "tax": "23%", "code": "5905806217681", "name": "Szafka na buty z szufladą Tres2 60x92x30 DĄB WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "452.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "918", "tax_value": "23", "product_id": "589", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
173	SHOPER	2428	5905806233544	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 CZARNY WOTAN	\N	5905806233544_1.jpg	\N	2025-10-06 18:33:07.209279	2025-10-09 19:06:16.880065	{"id": "27014", "tax": "23%", "code": "5905806233544", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 CZARNY WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "418.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23151", "quantity": "1", "stock_id": "2826", "tax_value": "23", "product_id": "2428", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
181	SHOPER	3580	5905806238587	 Szafka na buty VB100x36D1N1 Dąb Estana	\N	5905806238587_1.jpg	\N	2025-10-06 18:33:10.090647	2025-10-09 19:05:42.064661	{"id": "27006", "tax": "23%", "code": "5905806238587", "name": " Szafka na buty VB100x36D1N1 Dąb Estana", "type": "0", "unit": "szt.", "pkwiu": "", "price": "546.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23146", "quantity": "1", "stock_id": "3978", "tax_value": "23", "product_id": "3580", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
172	SHOPER	1064	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA	\N	5905204699560_1.jpg	\N	2025-10-06 18:33:06.723802	2025-10-09 19:05:50.611991	{"id": "27015", "tax": "23%", "code": "5905204699560", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1283.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23152", "quantity": "1", "stock_id": "1434", "tax_value": "23", "product_id": "1064", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
178	SHOPER	2822	5905806235067	Szafka na buty Supra-Nex 50x36x244 D1N1 WOTAN	\N	5905806235067_1.jpg	\N	2025-10-06 18:33:08.83739	2025-10-09 19:06:39.769833	{"id": "27009", "tax": "23%", "code": "5905806235067", "name": "Szafka na buty Supra-Nex 50x36x244 D1N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1309.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "3220", "tax_value": "23", "product_id": "2822", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
176	SHOPER	165	5905806208955	Szafka nocna NOX 40x36  2 szuflady schowek biały	\N	5905806208955_1.jpg	\N	2025-10-06 18:33:08.207471	2025-10-09 19:07:34.566112	{"id": "27012", "tax": "23%", "code": "5905806208955", "name": "Szafka nocna NOX 40x36  2 szuflady schowek biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "352.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23149", "quantity": "1", "stock_id": "494", "tax_value": "23", "product_id": "165", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
175	SHOPER	2030	5905806228199	Komoda Bones 60x36D4N1 ARTISAN	\N	5905806228199_1.jpg	\N	2025-10-06 18:33:08.207471	2025-10-09 19:06:12.674052	{"id": "27011", "tax": "23%", "code": "5905806228199", "name": "Komoda Bones 60x36D4N1 ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "725.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23149", "quantity": "1", "stock_id": "2428", "tax_value": "23", "product_id": "2030", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
180	SHOPER	1627	5905806217001	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny	\N	5905806217001_1.jpg	\N	2025-10-06 18:33:09.587604	2025-10-09 19:05:45.557867	{"id": "27007", "tax": "23%", "code": "5905806217001", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1887.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23147", "quantity": "1", "stock_id": "2013", "tax_value": "23", "product_id": "1627", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
183	SHOPER	860	5905806203370	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele CZARNY-LANCELOT	\N	\N	\N	2025-10-06 18:52:35.818776	2025-10-06 18:52:35.818776	{"id": "27021", "tax": "0%", "code": "5905806203370", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele CZARNY-LANCELOT", "type": "0", "unit": "szt.", "pkwiu": "", "price": "811.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23155", "quantity": "1", "stock_id": "1204", "tax_value": "0", "product_id": "860", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
184	SHOPER	986	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	\N	5905806208580_1.jpg	\N	2025-10-06 19:00:30.430201	2025-10-09 19:07:59.202239	{"id": "27022", "tax": "23%", "code": "5905806208580", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "828.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23156", "quantity": "1", "stock_id": "1356", "tax_value": "23", "product_id": "986", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
170	SHOPER	892	5905806208412	Panel ścienny tapicerowany 80x30	\N	5905806208412_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-09 19:06:19.856253	{"id": "27018", "tax": "23%", "code": "5905806208412", "name": "Panel ścienny tapicerowany 80x30", "type": "0", "unit": "szt.", "pkwiu": "", "price": "75.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "3", "stock_id": "1251", "tax_value": "23", "product_id": "892", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
171	SHOPER	1231	5905806213232	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Dąb Artisan	\N	5905806213232_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-09 19:06:35.820545	{"id": "27019", "tax": "23%", "code": "5905806213232", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1015.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1609", "tax_value": "23", "product_id": "1231", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
187	ALLEGRO	15463830012	5905806220605	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	\N	5905806220605_1.jpg	\N	2025-10-06 19:33:23.533952	2025-10-09 19:06:36.792929	{"id": "c8d78270-a2e6-11f0-a638-c7e352f2113f", "tax": null, "offer": {"id": "15463830012", "name": "Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan", "external": {"id": "5905806220605"}, "productSet": null}, "price": {"amount": "1052.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:01:56.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1052.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
189	ALLEGRO	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	\N	\N	\N	2025-10-06 19:33:24.984842	2025-10-06 19:33:24.984842	{"id": "b22cb0e0-a2e1-11f0-aba2-b3553c261cc2", "tax": null, "offer": {"id": "16901470101", "name": "Wieszak ścienny WP100 na ubrania 100cm WOTAN", "external": {"id": "5905806211528"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:26:05.247Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
9	ALLEGRO	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	\N	5905806202205_1.jpg	\N	2025-10-06 17:16:01.360803	2025-10-09 19:06:58.835971	\N
45	ALLEGRO	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	\N	5905806218855_1.jpg	\N	2025-10-06 17:15:54.931668	2025-10-09 19:06:37.809073	\N
54	ALLEGRO	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	\N	5905806222005_1.jpg	\N	2025-10-06 17:15:59.76086	2025-10-09 19:07:26.855221	\N
19	ALLEGRO	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	\N	5905204699089_1.jpg	\N	2025-10-06 17:15:54.712851	2025-10-09 19:05:56.854241	\N
182	SHOPER	3702	5905806238525	Próbki płyt meblowych	\N	5905806238525_1.jpg	\N	2025-10-06 18:46:15.550476	2025-10-09 19:06:23.594463	{"id": "27020", "tax": "23%", "code": "5905806238525", "name": "Próbki płyt meblowych", "type": "0", "unit": "szt.", "pkwiu": "", "price": "30.00", "option": "", "weight": "2", "loyalty": null, "unit_fp": "0", "order_id": "23154", "quantity": "1", "stock_id": "4100", "tax_value": "23", "product_id": "3702", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
185	SHOPER	2590	5905806231984	Szafka na buty VB60x36D2N1 WOTAN	\N	5905806231984_1.jpg	\N	2025-10-06 19:27:17.659069	2025-10-09 19:07:00.638246	{"id": "27023", "tax": "23%", "code": "5905806231984", "name": "Szafka na buty VB60x36D2N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "368.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23157", "quantity": "1", "stock_id": "2988", "tax_value": "23", "product_id": "2590", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
18	ALLEGRO	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	\N	5905806234268_1.jpg	\N	2025-10-06 17:15:59.112099	2025-10-09 19:06:17.893336	\N
188	ALLEGRO	14384920401	5905806201840	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	\N	5905806201840_1.jpg	\N	2025-10-06 19:33:24.102967	2025-10-09 19:06:48.754115	{"id": "90776680-a2e5-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14384920401", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN", "external": {"id": "5905806201840"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:52:40.641Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
53	ALLEGRO	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	\N	5905806203585_1.jpg	\N	2025-10-06 17:16:04.383082	2025-10-09 19:07:48.844921	\N
190	ALLEGRO	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	\N	\N	\N	2025-10-06 19:33:25.920887	2025-10-06 19:33:25.920887	{"id": "35817720-a2db-11f0-8b51-87d1833631ec", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919784886", "name": "Komoda Bones 50x36D1N1 WOTAN", "external": {"id": "5905806228991"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:38:33.286Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
192	ALLEGRO	12487594410	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	\N	5905204699560_1.jpg	\N	2025-10-06 19:33:26.829456	2025-10-09 19:05:50.611991	{"id": "b08f0010-a2d9-11f0-abd8-f5344f24907b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487594410", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699560"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:29:26.939Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
197	SHOPER	3713	5905806240306	Komoda Bones 80x36D1N1 Wotan	\N	5905806240306_1.jpg	\N	2025-10-09 19:00:46.54845	2025-10-09 19:06:15.915705	{"id": "27043", "tax": "23%", "code": "5905806240306", "name": "Komoda Bones 80x36D1N1 Wotan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "758.00", "option": "", "weight": "30", "loyalty": null, "unit_fp": "0", "order_id": "23173", "quantity": "1", "stock_id": "4111", "tax_value": "23", "product_id": "3713", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
199	SHOPER	3361	5905806203509	Zestaw 80x30D1N1 WP80 szafka na buty z wieszakiem LANCELOT	\N	\N	\N	2025-10-09 19:01:05.885702	2025-10-09 19:01:05.885702	{"id": "27052", "tax": "23%", "code": "5905806203509", "name": "Zestaw 80x30D1N1 WP80 szafka na buty z wieszakiem LANCELOT", "type": "0", "unit": "szt.", "pkwiu": "", "price": "677.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23178", "quantity": "1", "stock_id": "3759", "tax_value": "23", "product_id": "3361", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
193	ALLEGRO	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	\N	5905806238310_1.jpg	\N	2025-10-06 19:33:27.296289	2025-10-09 19:06:34.804301	{"id": "617f48e0-a2d9-11f0-a638-c7e352f2113f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17395006524", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY", "external": {"id": "5905806238310"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:26:46.285Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
200	SHOPER	2104	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:01:07.26201	2025-10-09 19:01:07.26201	{"id": "27050", "tax": "23%", "code": "5905806228946", "name": "Komoda Bones 50x36D1N1 ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "638.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23177", "quantity": "1", "stock_id": "2502", "tax_value": "23", "product_id": "2104", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
201	SHOPER	3206	5905806227253	Garderoba 60x30D1N1 3PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:01:07.26201	2025-10-09 19:01:07.26201	{"id": "27051", "tax": "0%", "code": "5905806227253", "name": "Garderoba 60x30D1N1 3PAN szafka na buty wieszak panele ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "747.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23177", "quantity": "1", "stock_id": "3604", "tax_value": "0", "product_id": "3206", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
202	SHOPER	1314	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:01:08.794663	2025-10-09 19:01:08.794663	{"id": "27048", "tax": "23%", "code": "5905806214581", "name": "Szafka na buty z szufladą Tres 100x36D1N1 SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "611.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23176", "quantity": "1", "stock_id": "1692", "tax_value": "23", "product_id": "1314", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
198	SHOPER	2145	5905806229011	Komoda Bones 60x36D4N1 CZARNY	\N	5905806229011_1.jpg	\N	2025-10-09 19:01:04.235908	2025-10-09 19:06:13.821015	{"id": "27053", "tax": "23%", "code": "5905806229011", "name": "Komoda Bones 60x36D4N1 CZARNY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "725.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23179", "quantity": "1", "stock_id": "2543", "tax_value": "23", "product_id": "2145", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
191	ALLEGRO	16859417789	5905806210613	Półka ścienna 80x18x20cm CZARNY	\N	5905806210613_1.jpg	\N	2025-10-06 19:33:26.374775	2025-10-09 19:06:24.366078	{"id": "132bc050-a2da-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16859417789", "name": "Półka ścienna 80x18x20cm CZARNY", "external": {"id": "5905806210613"}, "productSet": null}, "price": {"amount": "98.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:30:22.850Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "98.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
203	SHOPER	1480	5905806215991	Szafka na buty z wieszakiem VB50x36D1N1 WP50  SONOMA	\N	\N	\N	2025-10-09 19:01:08.794663	2025-10-09 19:01:08.794663	{"id": "27049", "tax": "23%", "code": "5905806215991", "name": "Szafka na buty z wieszakiem VB50x36D1N1 WP50  SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "531.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23176", "quantity": "1", "stock_id": "1866", "tax_value": "23", "product_id": "1480", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
204	SHOPER	1641	5905806218558	Tkanina Fjord Czarny	\N	\N	\N	2025-10-09 19:01:10.253988	2025-10-09 19:01:10.253988	{"id": "27044", "tax": "23%", "code": "5905806218558", "name": "Tkanina Fjord Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "30.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23174", "quantity": "1", "stock_id": "2039", "tax_value": "23", "product_id": "1641", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
207	SHOPER	974	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	\N	\N	\N	2025-10-09 19:01:14.203914	2025-10-09 19:01:14.203914	{"id": "27033", "tax": "23%", "code": "5905806208467", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma", "type": "0", "unit": "szt.", "pkwiu": "", "price": "780.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23167", "quantity": "1", "stock_id": "1344", "tax_value": "23", "product_id": "974", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
214	SHOPER	348	5905204699096	Garderoba 90x36cm V60 Supra30 4 Panele D1 SONOMA	\N	5905204699096_1.jpg	\N	2025-10-09 19:01:57.873794	2025-10-09 19:05:55.725173	{"id": "27037", "tax": "23%", "code": "5905204699096", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1391.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23169", "quantity": "1", "stock_id": "677", "tax_value": "23", "product_id": "348", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
212	SHOPER	1219	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	\N	5905806213560_1.jpg	\N	2025-10-09 19:01:55.104179	2025-10-09 19:06:32.869557	{"id": "27040", "tax": "23%", "code": "5905806213560", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "954.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "1597", "tax_value": "23", "product_id": "1219", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
205	SHOPER	890	5905806208429	Panel ścienny tapicerowany pan1x60x30	\N	5905806208429_1.jpg	\N	2025-10-09 19:01:10.253988	2025-10-09 19:06:21.945037	{"id": "27045", "tax": "23%", "code": "5905806208429", "name": "Panel ścienny tapicerowany pan1x60x30", "type": "0", "unit": "szt.", "pkwiu": "", "price": "64.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23174", "quantity": "1", "stock_id": "1249", "tax_value": "23", "product_id": "890", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
215	SHOPER	3711	5905806240115	Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR	\N	5905806240115_1.jpg	\N	2025-10-09 19:01:59.153419	2025-10-09 19:06:56.695083	{"id": "27030", "tax": "23%", "code": "5905806240115", "name": "Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR", "type": "0", "unit": "szt.", "pkwiu": "", "price": "350.00", "option": "", "weight": "18", "loyalty": null, "unit_fp": "0", "order_id": "23164", "quantity": "1", "stock_id": "4109", "tax_value": "23", "product_id": "3711", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
210	SHOPER	732	5905806202502	Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	5905806202502_1.jpg	\N	2025-10-09 19:01:49.623499	2025-10-09 19:07:10.580966	{"id": "27047", "tax": "0%", "code": "5905806202502", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "423.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23175", "quantity": "1", "stock_id": "1061", "tax_value": "0", "product_id": "732", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
209	SHOPER	963	5905806208399	Szafka na buty z szufladą Tres 60x36 Czarny Biały	\N	5905806208399_1.jpg	\N	2025-10-09 19:01:49.623499	2025-10-09 19:07:23.842595	{"id": "27046", "tax": "23%", "code": "5905806208399", "name": "Szafka na buty z szufladą Tres 60x36 Czarny Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "478.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23175", "quantity": "1", "stock_id": "1328", "tax_value": "23", "product_id": "963", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
213	SHOPER	1787	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	\N	5905806208344_1.jpg	\N	2025-10-09 19:01:55.104179	2025-10-09 19:07:22.761862	{"id": "27041", "tax": "23%", "code": "5905806208344", "name": "Szafka na buty z szufladą Tres 60x36 Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "478.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "2185", "tax_value": "23", "product_id": "1787", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
208	SHOPER	1000	5905806211375	Wieszak ścienny W100 na ubrania 100cm SONOMA	\N	5905806211375_1.jpg	\N	2025-10-09 19:01:14.203914	2025-10-09 19:07:36.545483	{"id": "27034", "tax": "23%", "code": "5905806211375", "name": "Wieszak ścienny W100 na ubrania 100cm SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "241.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23167", "quantity": "1", "stock_id": "1370", "tax_value": "23", "product_id": "1000", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
206	SHOPER	909	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	\N	5905806203585_1.jpg	\N	2025-10-09 19:01:12.890428	2025-10-09 19:07:48.844921	{"id": "27042", "tax": "23%", "code": "5905806203585", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "278.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23172", "quantity": "1", "stock_id": "1268", "tax_value": "23", "product_id": "909", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
186	ALLEGRO	15250482464	5905806215212	Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN	\N	5905806215212_1.jpg	\N	2025-10-06 19:33:23.533952	2025-10-09 19:05:44.458097	{"id": "c8d78271-a2e6-11f0-a638-c7e352f2113f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15250482464", "name": "Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN", "external": {"id": "5905806215212"}, "productSet": null}, "price": {"amount": "1832.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:01:56.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1832.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
211	SHOPER	3496	5905806237825	Garderoba 60x36D1N1-4PAN szafka na buty wieszak panele Kaszmir	\N	5905806237825_1.jpg	\N	2025-10-09 19:01:55.104179	2025-10-09 19:05:47.76327	{"id": "27039", "tax": "0%", "code": "5905806237825", "name": "Garderoba 60x36D1N1-4PAN szafka na buty wieszak panele Kaszmir", "type": "0", "unit": "szt.", "pkwiu": "", "price": "835.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "3894", "tax_value": "0", "product_id": "3496", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
216	SHOPER	719	5905806202373	Szafka na buty VB80x30D S1 siedzisko 80cm Czarny	\N	5905806202373_1.jpg	\N	2025-10-09 19:02:00.450016	2025-10-09 19:07:01.707897	{"id": "27029", "tax": "0%", "code": "5905806202373", "name": "Szafka na buty VB80x30D S1 siedzisko 80cm Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "399.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23163", "quantity": "1", "stock_id": "1048", "tax_value": "0", "product_id": "719", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
217	ALLEGRO	13855292522	5905806200010	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	\N	\N	\N	2025-10-09 19:30:10.915407	2025-10-09 19:30:10.915407	{"id": "27407420-a544-11f0-bb74-8b6fbb6f100b", "tax": null, "offer": {"id": "13855292522", "name": "Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT", "external": {"id": "5905806200010"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T19:15:34.727Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
218	ALLEGRO	16859415981	5905806210293	Półka ścienna 50x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:31:22.488416	2025-10-09 19:31:22.488416	{"id": "13758aa0-a537-11f0-9cb2-b90a5baab897", "tax": null, "offer": {"id": "16859415981", "name": "Półka ścienna 50x18x20cm WOTAN", "external": {"id": "5905806210293"}, "productSet": null}, "price": {"amount": "76.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:41:40.314Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "76.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
219	ALLEGRO	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:31:24.056133	2025-10-09 19:31:24.056133	{"id": "69bea6b0-a534-11f0-a008-2360f331b758", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155167503", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN", "external": {"id": "5905806208443"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:24:14.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
220	ALLEGRO	16271341145	5905806233391	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:28.746481	2025-10-09 19:31:28.746481	{"id": "6a923310-a523-11f0-a204-f12f4b71e7fe", "tax": null, "offer": {"id": "16271341145", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN", "external": {"id": "5905806233391"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:22:17.049Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
221	ALLEGRO	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	\N	\N	\N	2025-10-09 19:31:30.312269	2025-10-09 19:31:30.312269	{"id": "e9a4c980-a521-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508963", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot", "external": {"id": "5905204699102"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:14:38.004Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
222	ALLEGRO	16602435285	5905806234589	Komoda Bini 50x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:31.851944	2025-10-09 19:31:31.851944	{"id": "6d481a60-a51a-11f0-a588-b391296a673a", "tax": null, "offer": {"id": "16602435285", "name": "Komoda Bini 50x36 D1N1 WOTAN", "external": {"id": "5905806234589"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T14:16:23.628Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
223	ALLEGRO	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	\N	\N	\N	2025-10-09 19:31:36.551395	2025-10-09 19:31:36.551395	{"id": "891abea0-a50b-11f0-9b0c-e511fc7361fa", "tax": null, "offer": {"id": "16698543601", "name": "Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan", "external": {"id": "5905806237023"}, "productSet": null}, "price": {"amount": "1430.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T12:31:32.872Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1430.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "62.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
224	ALLEGRO	14387672711	5905806202335	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	\N	\N	\N	2025-10-09 19:31:38.174424	2025-10-09 19:31:38.174424	{"id": "2688a332-a4ff-11f0-b9bf-2795de008363", "tax": null, "offer": {"id": "14387672711", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan", "external": {"id": "5905806202335"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T11:07:01.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
225	ALLEGRO	16901480273	5905806234022	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	\N	\N	\N	2025-10-09 19:31:38.174424	2025-10-09 19:31:38.174424	{"id": "2688a331-a4ff-11f0-b9bf-2795de008363", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "16901480273", "name": "Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN", "external": {"id": "5905806234022"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T11:07:01.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
226	ALLEGRO	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:41.337269	2025-10-09 19:31:41.337269	{"id": "8c283cd0-a4f7-11f0-a444-6d64b3cc877f", "tax": null, "offer": {"id": "16602434150", "name": "Komoda Bini 50x30x82 D1N1 SONOMA", "external": {"id": "5905806234510"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T10:07:46.307Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
227	ALLEGRO	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:42.890879	2025-10-09 19:31:42.890879	{"id": "24386810-a4f3-11f0-a588-b391296a673a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919776759", "name": "Komoda Bones 60x36D1N1 SONOMA", "external": {"id": "5905806228861"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:35:26.392Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
228	ALLEGRO	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:31:51.879859	2025-10-09 19:31:51.879859	{"id": "5cdbdb20-a4df-11f0-961e-6d069f850ff8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12224099030", "name": "Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699249"}, "productSet": null}, "price": {"amount": "884.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T07:13:40.284Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "884.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "38.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
229	ALLEGRO	15876902214	5905806215175	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	\N	\N	\N	2025-10-09 19:31:54.962898	2025-10-09 19:31:54.962898	{"id": "55056c90-a4da-11f0-9b0c-e511fc7361fa", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15876902214", "name": "Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY", "external": {"id": "5905806215175"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T06:38:48.216Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
230	ALLEGRO	15225620833	5905806213386	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY	\N	\N	\N	2025-10-09 19:31:58.07485	2025-10-09 19:31:58.07485	{"id": "a9d22d60-a4cd-11f0-a588-b391296a673a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15225620833", "name": "Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY", "external": {"id": "5905806213386"}, "productSet": null}, "price": {"amount": "1705.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T05:09:23.478Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1705.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
231	ALLEGRO	14388158414	5905806202694	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	\N	\N	\N	2025-10-09 19:31:59.668882	2025-10-09 19:31:59.668882	{"id": "e64932f0-a493-11f0-a471-6bb0586de370", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14388158414", "name": "Garderoba 50x36P2WPB szafka na buty wieszak Sonoma", "external": {"id": "5905806202694"}, "productSet": null}, "price": {"amount": "643.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T22:16:43.843Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "643.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
232	ALLEGRO	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	\N	\N	\N	2025-10-09 19:32:01.342774	2025-10-09 19:32:01.342774	{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15321913673", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan", "external": {"id": "5905806216943"}, "productSet": null}, "price": {"amount": "1750.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T20:37:25.568Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1750.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "76.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
233	ALLEGRO	17358967427	5905806237825	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	\N	\N	\N	2025-10-09 19:32:02.920419	2025-10-09 19:32:02.920419	{"id": "04305191-a480-11f0-bfb1-c5232bd647f2", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "17358967427", "name": "Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir", "external": {"id": "5905806237825"}, "productSet": null}, "price": {"amount": "835.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T19:51:26.263Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "835.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
234	ALLEGRO	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-09 19:32:17.226597	2025-10-09 19:32:17.226597	{"id": "5da1b6e0-a455-11f0-b989-75c7faccd1ca", "tax": null, "offer": {"id": "16271340785", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806233292"}, "productSet": null}, "price": {"amount": "368.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:45:05.974Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "368.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "16.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
235	ALLEGRO	10862932479	5905806209532	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	\N	\N	\N	2025-10-09 19:33:55.704691	2025-10-09 19:33:55.704691	{"id": "cac93f00-a454-11f0-a471-6bb0586de370", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "10862932479", "name": "Szafka komoda na buty 80x30 D2N1 Altus BIAŁY", "external": {"id": "5905806209532"}, "productSet": null}, "price": {"amount": "532.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:41:38.668Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "532.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "23.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
236	ALLEGRO	15178440255	5905806210118	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	\N	\N	\N	2025-10-09 19:33:58.780544	2025-10-09 19:33:58.780544	{"id": "3b62aea0-a44f-11f0-88a6-1f93f938b7b3", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15178440255", "name": "Szafka komoda na buty 80x36 D2N2 Altus ARTISAN", "external": {"id": "5905806210118"}, "productSet": null}, "price": {"amount": "636.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:01:34.608Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "636.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
237	ALLEGRO	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	\N	\N	\N	2025-10-09 19:34:01.943813	2025-10-09 19:34:01.943813	{"id": "8ed915f0-a43c-11f0-96d3-f7121b08a32c", "tax": null, "offer": {"id": "14384922015", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806201871"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T11:47:36.900Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
238	ALLEGRO	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	\N	\N	\N	2025-10-09 19:34:03.538387	2025-10-09 19:34:03.538387	{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14655550516", "name": "Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan", "external": {"id": "5905806205015"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:40:58.713Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
239	ALLEGRO	15919730348	5905806228830	Komoda Bones 60x30D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:05.149018	2025-10-09 19:34:05.149018	{"id": "bce19ae0-a431-11f0-af7e-5f793825db67", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919730348", "name": "Komoda Bones 60x30D1N1 SONOMA", "external": {"id": "5905806228830"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:30:50.598Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
240	ALLEGRO	16521833793	5905806227130	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	\N	\N	\N	2025-10-09 19:34:06.759391	2025-10-09 19:34:06.759391	{"id": "36702f81-a431-11f0-8f13-933da22fca3d", "tax": null, "offer": {"id": "16521833793", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY", "external": {"id": "5905806227130"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:29:53.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
241	ALLEGRO	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	\N	\N	\N	2025-10-09 19:34:06.759391	2025-10-09 19:34:06.759391	{"id": "36702f80-a431-11f0-8f13-933da22fca3d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15408455867", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY", "external": {"id": "5905806218688"}, "productSet": null}, "price": {"amount": "1015.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:29:53.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1015.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
242	ALLEGRO	15321911032	5905806216912	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	\N	\N	\N	2025-10-09 19:34:16.065253	2025-10-09 19:34:16.065253	{"id": "ae640510-a41e-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15321911032", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan", "external": {"id": "5905806216912"}, "productSet": null}, "price": {"amount": "1750.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T08:16:19.689Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1750.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "76.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
243	ALLEGRO	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:19.098291	2025-10-09 19:34:19.098291	{"id": "2b052750-a412-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "16319658329", "name": "Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806234398"}, "productSet": null}, "price": {"amount": "674.30", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T06:44:05.207Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "674.30", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "29.70", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
244	ALLEGRO	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:34:20.621698	2025-10-09 19:34:20.621698	{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258723368", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma", "external": {"id": "5905806216981"}, "productSet": null}, "price": {"amount": "1887.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T06:26:35.802Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1887.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
245	ALLEGRO	14910130346	5905806204049	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:34:27.397521	2025-10-09 19:34:27.397521	{"id": "bd041570-a3cd-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14910130346", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806204049"}, "productSet": null}, "price": {"amount": "811.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T22:37:03.666Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "811.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
246	ALLEGRO	14910130495	5905806204056	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	\N	\N	\N	2025-10-09 19:34:28.864582	2025-10-09 19:34:28.864582	{"id": "3cc896c0-a3cc-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14910130495", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY", "external": {"id": "5905806204056"}, "productSet": null}, "price": {"amount": "811.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T22:27:10.760Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "811.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
247	ALLEGRO	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-09 19:34:30.326811	2025-10-09 19:34:30.326811	{"id": "bb0feac0-a3c6-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:44:05.528Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
248	ALLEGRO	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:34:31.926296	2025-10-09 19:34:31.926296	{"id": "876a7b40-a3c6-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16859419202", "name": "Półka ścienna 60x18x20cm WOTAN", "external": {"id": "5905806210439"}, "productSet": null}, "price": {"amount": "87.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:42:42.773Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "87.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
249	ALLEGRO	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	\N	\N	\N	2025-10-09 19:34:35.391646	2025-10-09 19:34:35.391646	{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14383316918", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały", "external": {"id": "5905806201758"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:11:14.096Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
250	ALLEGRO	15319542575	5905806213973	Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN	\N	\N	\N	2025-10-09 19:34:39.906358	2025-10-09 19:34:39.906358	{"id": "a1cdbc90-a3ad-11f0-a3bc-ef5c37833579", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15319542575", "name": "Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN", "external": {"id": "5905806213973"}, "productSet": null}, "price": {"amount": "1645.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:47:31.831Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1645.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
251	ALLEGRO	16625971969	5905806222524	Siedzisko tapicerowane 80x29cm do szafki 80x30	\N	\N	\N	2025-10-09 19:34:41.444673	2025-10-09 19:34:41.444673	{"id": "7c6a6280-a3aa-11f0-a15e-754093089519", "tax": null, "offer": {"id": "16625971969", "name": "Siedzisko tapicerowane 80x29cm do szafki 80x30", "external": {"id": "5905806222524"}, "productSet": null}, "price": {"amount": "75.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:33:02.465Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "75.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
252	ALLEGRO	17636751422	5905806205121	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	\N	\N	\N	2025-10-09 19:34:44.442189	2025-10-09 19:34:44.442189	{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17636751422", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA", "external": {"id": "5905806205121"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:13:53.667Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
253	ALLEGRO	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:34:46.040975	2025-10-09 19:34:46.040975	{"id": "47073e70-a39f-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571569", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905806213560"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:04:37.686Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
254	ALLEGRO	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:34:47.681114	2025-10-09 19:34:47.681114	{"id": "14d905a1-a39f-11f0-b56d-0ba559d87e46", "tax": null, "offer": {"id": "16602434536", "name": "Komoda Bini 50x30x82 D1N1 WOTAN", "external": {"id": "5905806234527"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:01:47.983Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
255	ALLEGRO	12196226645	5905806203615	Wieszak ścienny WP80 na ubrania 80cm Lancelot	\N	\N	\N	2025-10-09 19:34:49.240924	2025-10-09 19:34:49.240924	{"id": "5b983f70-a39e-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "12196226645", "name": "Wieszak ścienny WP80 na ubrania 80cm Lancelot", "external": {"id": "5905806203615"}, "productSet": null}, "price": {"amount": "278.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:55:30.772Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "278.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
256	ALLEGRO	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:50.800284	2025-10-09 19:34:50.800284	{"id": "f1c1d391-a39d-11f0-8d43-e5c6c6646cd8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919728876", "name": "Komoda Bones 60x36D1N1 ARTISAN", "external": {"id": "5905806228793"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:53:45.966Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
257	ALLEGRO	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	\N	\N	\N	2025-10-09 19:34:55.214301	2025-10-09 19:34:55.214301	{"id": "d2701550-a399-11f0-a3bc-ef5c37833579", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15319529269", "name": "Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN", "external": {"id": "5905806213812"}, "productSet": null}, "price": {"amount": "1557.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:23:05.385Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1557.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
258	ALLEGRO	15221332021	5905806214130	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	\N	\N	\N	2025-10-09 19:34:56.692218	2025-10-09 19:34:56.692218	{"id": "aa3a44e0-a397-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221332021", "name": "Szafka na buty z szufladą Tres 50x36 Dąb Wotan", "external": {"id": "5905806214130"}, "productSet": null}, "price": {"amount": "447.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:08:03.409Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "447.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
259	ALLEGRO	16276325492	5905806233957	Komoda Bini 60x36D1N1 BIAŁY	\N	\N	\N	2025-10-09 19:34:58.255169	2025-10-09 19:34:58.255169	{"id": "816e3d00-a397-11f0-9288-ef897151e2e1", "tax": null, "offer": {"id": "16276325492", "name": "Komoda Bini 60x36D1N1 BIAŁY", "external": {"id": "5905806233957"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:07:07.415Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
260	ALLEGRO	16415944014	5905806231885	Szafka na buty VB100x30D2N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:59.752861	2025-10-09 19:34:59.752861	{"id": "8a81ae80-a393-11f0-bc71-87ddccc94446", "tax": null, "offer": {"id": "16415944014", "name": "Szafka na buty VB100x30D2N1 ARTISAN", "external": {"id": "5905806231885"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T15:43:37.315Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
261	ALLEGRO	12263585961	5905204699218	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:35:13.347269	2025-10-09 19:35:13.347269	{"id": "88af56c1-a357-11f0-bc71-87ddccc94446", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12263585961", "name": "Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699218"}, "productSet": null}, "price": {"amount": "1052.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T08:28:26.205Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1052.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
262	ALLEGRO	14024671782	5905806201307	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	\N	\N	\N	2025-10-09 19:35:16.329333	2025-10-09 19:35:16.329333	{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8", "tax": null, "offer": {"id": "14024671782", "name": "Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot", "external": {"id": "5905806201307"}, "productSet": null}, "price": {"amount": "532.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T07:30:28.729Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "532.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
263	ALLEGRO	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	\N	\N	\N	2025-10-09 19:35:17.859367	2025-10-09 19:35:17.859367	{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T07:04:50.959Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
264	ALLEGRO	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	\N	\N	\N	2025-10-09 19:35:19.36659	2025-10-09 19:35:19.36659	{"id": "a6a3fb32-a349-11f0-9d2c-bd0fd501dc68", "tax": null, "offer": {"id": "13854397976", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN", "external": {"id": "5905204699997"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T06:49:07.597Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
265	ALLEGRO	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-09 19:35:23.030281	2025-10-09 19:35:23.030281	{"id": "a6f1c6b0-a341-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16271344068", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN", "external": {"id": "5905806233490"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T05:52:04.196Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
266	ALLEGRO	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:35:30.758556	2025-10-09 19:35:30.758556	{"id": "304affb0-9d63-11f0-a677-a5b8c1586284", "tax": null, "offer": {"id": "17358940752", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir", "external": {"id": "5905806237801"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-29T18:37:53.401Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
267	ALLEGRO	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	\N	\N	\N	2025-10-09 19:52:33.022688	2025-10-09 19:52:33.022688	{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696167", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały", "external": {"id": "5905806208566"}, "productSet": null}, "price": {"amount": "793.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T14:45:19.720Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "793.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
268	ALLEGRO	12258788829	5905806216936	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:52:38.260123	2025-10-09 19:52:38.260123	{"id": "2ebd6e82-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258788829", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma", "external": {"id": "5905806216936"}, "productSet": null}, "price": {"amount": "1827.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1827.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
269	ALLEGRO	11742813479	5905806204025	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	\N	\N	\N	2025-10-09 19:52:38.260123	2025-10-09 19:52:38.260123	{"id": "2ebd6e83-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11742813479", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA", "external": {"id": "5905806204025"}, "productSet": null}, "price": {"amount": "776.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "776.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
270	ALLEGRO	15446678390	5905806219623	Szafka na buty 60x30D2N1Supra SONOMA	\N	\N	\N	2025-10-09 19:52:38.260123	2025-10-09 19:52:38.260123	{"id": "2ebd6e81-a05b-11f0-819e-1344c439828f", "tax": null, "offer": {"id": "15446678390", "name": "Szafka na buty 60x30D2N1Supra SONOMA", "external": {"id": "5905806219623"}, "productSet": null}, "price": {"amount": "1105.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1105.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
271	ALLEGRO	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	\N	\N	\N	2025-10-09 19:52:38.260123	2025-10-09 19:52:38.260123	{"id": "2ebd6e80-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221504597", "name": "Szafka na buty z szufladą Tres 80x36 Dąb Wotan", "external": {"id": "5905806214253"}, "productSet": null}, "price": {"amount": "600.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "600.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
272	ALLEGRO	15225574066	5905806213461	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY	\N	\N	\N	2025-10-09 19:52:40.140262	2025-10-09 19:52:40.140262	{"id": "89015ee0-a058-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15225574066", "name": "Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY", "external": {"id": "5905806213461"}, "productSet": null}, "price": {"amount": "1705.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:57:59.253Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1705.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
273	ALLEGRO	16383693560	5905806234046	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	\N	\N	\N	2025-10-09 19:52:45.217892	2025-10-09 19:52:45.217892	{"id": "19cc45c1-a054-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "16383693560", "name": "Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY", "external": {"id": "5905806234046"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:28:28.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
274	ALLEGRO	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	\N	\N	\N	2025-10-09 19:52:48.527521	2025-10-09 19:52:48.527521	{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15229738794", "name": "Szafka na buty z szufladą Tres 100x36D1N1 WOTAN", "external": {"id": "5905806214574"}, "productSet": null}, "price": {"amount": "611.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:04:06.189Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "611.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
275	ALLEGRO	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	\N	\N	\N	2025-10-09 19:52:50.096528	2025-10-09 19:52:50.096528	{"id": "b369bb00-a03f-11f0-8737-b36df7580750", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15410023447", "name": "Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan", "external": {"id": "5905806218879"}, "productSet": null}, "price": {"amount": "1123.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:00:22.614Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1123.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "49.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
276	ALLEGRO	16644957145	5905806204179	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	\N	\N	\N	2025-10-09 19:52:53.294006	2025-10-09 19:52:53.294006	{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "16644957145", "name": "Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN", "external": {"id": "5905806204179"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T08:22:15.599Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
277	ALLEGRO	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-09 19:52:59.565071	2025-10-09 19:52:59.565071	{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440332407", "name": "Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN", "external": {"id": "5905806218176"}, "productSet": null}, "price": {"amount": "1023.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:47:53.396Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1023.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
278	ALLEGRO	15315961595	5905806214673	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	\N	\N	\N	2025-10-09 19:53:01.402189	2025-10-09 19:53:01.402189	{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15315961595", "name": "Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY", "external": {"id": "5905806214673"}, "productSet": null}, "price": {"amount": "587.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:40:08.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "587.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
279	ALLEGRO	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	\N	\N	\N	2025-10-09 19:53:02.963613	2025-10-09 19:53:02.963613	{"id": "a241d610-9fc6-11f0-8c53-b9e6d89e658e", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10945431249", "name": "Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały", "external": {"id": "5905806208191"}, "productSet": null}, "price": {"amount": "332.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:35:20.332Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "332.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
280	ALLEGRO	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:53:06.305605	2025-10-09 19:53:06.305605	{"id": "424b1740-9fc0-11f0-8509-57e61af36c1f", "tax": null, "offer": {"id": "16276327427", "name": "Komoda Bini 60x36D1N1 SONOMA", "external": {"id": "5905806233995"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T18:48:09.646Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
281	ALLEGRO	12476571893	5905204699492	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:53:10.853809	2025-10-09 19:53:10.853809	{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571893", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały", "external": {"id": "5905204699492"}, "productSet": null}, "price": {"amount": "1015.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T16:07:49.871Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1015.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
282	ALLEGRO	16602441323	5905806234770	Komoda Bini 100x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:15.422578	2025-10-09 19:53:15.422578	{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2", "tax": null, "offer": {"id": "16602441323", "name": "Komoda Bini 100x36 D1N1 WOTAN", "external": {"id": "5905806234770"}, "productSet": null}, "price": {"amount": "682.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T15:39:26.910Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "682.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
283	ALLEGRO	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	\N	\N	\N	2025-10-09 19:53:20.219267	2025-10-09 19:53:20.219267	{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440329487", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA", "external": {"id": "5905806217995"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:23:26.503Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
284	ALLEGRO	15251019919	5905806204162	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:21.859258	2025-10-09 19:53:21.859258	{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15251019919", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN", "external": {"id": "5905806204162"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:20:28.097Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
285	ALLEGRO	16383698094	5905806234084	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	\N	\N	\N	2025-10-09 19:53:26.561265	2025-10-09 19:53:26.561265	{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3", "tax": null, "offer": {"id": "16383698094", "name": "Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY", "external": {"id": "5905806234084"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T08:11:20.907Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
286	ALLEGRO	15134391509	5905806209372	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	\N	\N	\N	2025-10-09 19:53:28.085804	2025-10-09 19:53:28.085804	{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2", "tax": null, "offer": {"id": "15134391509", "name": "Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY", "external": {"id": "5905806209372"}, "productSet": null}, "price": {"amount": "1016.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T08:01:02.229Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1016.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
287	ALLEGRO	12266500239	5905204699126	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA	\N	\N	\N	2025-10-09 19:53:34.124913	2025-10-09 19:53:34.124913	{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266500239", "name": "Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA", "external": {"id": "5905204699126"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T20:30:27.830Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
288	ALLEGRO	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	\N	\N	\N	2025-10-09 19:53:40.214695	2025-10-09 19:53:40.214695	{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487657175", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699614"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:19:10.157Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
289	ALLEGRO	17358870548	5905806237849	Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:53:43.314516	2025-10-09 19:53:43.314516	{"id": "5062f300-9efa-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17358870548", "name": "Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir", "external": {"id": "5905806237849"}, "productSet": null}, "price": {"amount": "363.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:13:20.451Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "363.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
290	ALLEGRO	12405971238	5905204699140	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:53:52.411705	2025-10-09 19:53:52.411705	{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12405971238", "name": "Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905204699140"}, "productSet": null}, "price": {"amount": "1136.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:54:29.258Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1136.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
291	ALLEGRO	15258837181	5905806211023	Wieszak ścienny W60 na ubrania 60cm LANCELOT	\N	\N	\N	2025-10-09 19:53:54.029929	2025-10-09 19:53:54.029929	{"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "15258837181", "name": "Wieszak ścienny W60 na ubrania 60cm LANCELOT", "external": {"id": "5905806211023"}, "productSet": null}, "price": {"amount": "193.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:51:37.691Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "BUNDLE"}], "originalPrice": {"amount": "193.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
292	ALLEGRO	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	\N	\N	\N	2025-10-09 19:53:55.625141	2025-10-09 19:53:55.625141	{"id": "d9e03540-9eee-11f0-b465-492415e4339b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11769341228", "name": "Panel ścienny tapicerowany pan1x80x30", "external": {"id": "5905806208412"}, "productSet": null}, "price": {"amount": "75.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:48:50.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "75.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
293	ALLEGRO	17477972814	5905806238716 	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	\N	\N	\N	2025-10-09 19:54:01.930469	2025-10-09 19:54:01.930469	{"id": "741a7c31-9ed9-11f0-b465-492415e4339b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17477972814", "name": "Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR", "external": {"id": "5905806238716 "}, "productSet": null}, "price": {"amount": "1373.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T15:18:19.500Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1373.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
294	ALLEGRO	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	\N	\N	\N	2025-10-09 19:54:01.930469	2025-10-09 19:54:01.930469	{"id": "741a7c30-9ed9-11f0-b465-492415e4339b", "tax": null, "offer": {"id": "17478159653", "name": "Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR", "external": {"id": "5905806238679"}, "productSet": null}, "price": {"amount": "857.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T15:18:19.500Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "857.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
295	ALLEGRO	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	\N	\N	\N	2025-10-09 19:54:06.564881	2025-10-09 19:54:06.564881	{"id": "10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11873257937", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Sonoma", "external": {"id": "5905806208351"}, "productSet": null}, "price": {"amount": "434.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T14:31:13.809Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "434.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
296	ALLEGRO	16271343737	5905806233476	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	\N	\N	\N	2025-10-09 19:54:14.234736	2025-10-09 19:54:14.234736	{"id": "ab724b80-9ebc-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16271343737", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT", "external": {"id": "5905806233476"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T11:49:39.791Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
297	ALLEGRO	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-09 19:54:26.194085	2025-10-09 19:54:26.194085	{"id": "778e3940-9ea4-11f0-8996-07b46275101a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112614579", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208504"}, "productSet": null}, "price": {"amount": "780.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T08:58:07.596Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "780.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
298	ALLEGRO	16760747405	5905806236156	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:54:30.841405	2025-10-09 19:54:30.841405	{"id": "d41854a0-9e97-11f0-8996-07b46275101a", "tax": null, "offer": {"id": "16760747405", "name": "Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806236156"}, "productSet": null}, "price": {"amount": "1045.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T07:30:40.068Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1045.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
299	ALLEGRO	15193798429	5905806213133	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	\N	\N	\N	2025-10-09 19:54:37.061635	2025-10-09 19:54:37.061635	{"id": "915b4e80-997c-11f0-b7ad-bf8cbe88f0cf", "tax": null, "offer": {"id": "15193798429", "name": "Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały", "external": {"id": "5905806213133"}, "productSet": null}, "price": {"amount": "1704.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-24T19:28:31.880Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1704.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "74.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
300	SHOPER	2624	5905806231090	Szafka na buty VB80x30D2N1 CZARNY	\N	\N	\N	2025-10-09 19:56:42.184496	2025-10-09 19:56:42.184496	{"id": "27054", "tax": "0%", "code": "5905806231090", "name": "Szafka na buty VB80x30D2N1 CZARNY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "417.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23180", "quantity": "1", "stock_id": "3022", "tax_value": "0", "product_id": "2624", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
301	ALLEGRO	15919629053	5905806228588	Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA	\N	\N	\N	2025-10-09 19:57:30.118678	2025-10-09 19:57:30.118678	{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919629053", "name": "Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA", "external": {"id": "5905806228588"}, "productSet": null}, "price": {"amount": "1540.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T20:01:00.302Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1540.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
302	ALLEGRO	12266500390	5905204699133	Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-09 19:57:34.529382	2025-10-09 19:57:34.529382	{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266500390", "name": "Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT", "external": {"id": "5905204699133"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T18:39:01.681Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
303	ALLEGRO	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	\N	\N	\N	2025-10-09 19:57:41.277086	2025-10-09 19:57:41.277086	{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862725041", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma", "external": {"id": "5905204699966"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T16:33:59.773Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
304	ALLEGRO	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:57:54.369344	2025-10-09 19:57:54.369344	{"id": "ae6eb920-9dec-11f0-b286-41f712537da1", "tax": null, "offer": {"id": "16602435161", "name": "Komoda Bini 50x36 D1N1 SONOMA", "external": {"id": "5905806234572"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T11:01:43.772Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
305	ALLEGRO	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	\N	\N	\N	2025-10-09 19:57:55.825537	2025-10-09 19:57:55.825537	{"id": "0cb131e1-9deb-11f0-8cf9-590a844f62e8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14209799601", "name": "Szafka na buty Supra 30x30 D1N1 słupek Wotan", "external": {"id": "5905806201659"}, "productSet": null}, "price": {"amount": "532.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T10:49:12.333Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "532.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
306	ALLEGRO	15258837630	5905806211030	Wieszak ścienny W60 na ubrania 60cm ARISTAN	\N	\N	\N	2025-10-09 19:58:01.912169	2025-10-09 19:58:01.912169	{"id": "85db67c0-9ddc-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "15258837630", "name": "Wieszak ścienny W60 na ubrania 60cm ARISTAN", "external": {"id": "5905806211030"}, "productSet": null}, "price": {"amount": "193.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T09:06:09.646Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "193.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
\.


--
-- Data for Name: order_items; Type: TABLE DATA; Schema: commerce; Owner: neondb_owner
--

COPY commerce.order_items (id, order_id, source, source_item_id, product_id, offer_id, offer_external_id, name, quantity, price, currency, tax_rate, tax_subject, image_url, created_at, offer_name, unit_price, total_price, country_code, payment_type, invoice_required, raw_data, returns_quantity) FROM stdin;
131	0f4b3bd9-dbaf-4b9a-b31a-106f1c0d177a	ALLEGRO	04e679f0-a095-11f0-9468-2bd22967b382	84	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	1	682.00	PLN	\N	\N	\N	2025-10-06 17:22:44.123278	Komoda Bini 100x36 D1N1 SONOMA	682.00	682.00	\N	ONLINE	f	{"id": "04e679f0-a095-11f0-9468-2bd22967b382", "tax": null, "offer": {"id": "16602440992", "name": "Komoda Bini 100x36 D1N1 SONOMA", "external": {"id": "5905806234763"}, "productSet": null}, "price": {"amount": "682.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T20:17:34.990Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "682.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
129	b65d938d-1d55-4411-97e6-96e30b4b0e34	ALLEGRO	ce26b270-a091-11f0-bfbd-d3aacc6a2e00	90	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	2025-10-06 16:59:17.426577	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	229.00	229.00	\N	ONLINE	f	{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14604181578", "name": "Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan", "external": {"id": "5905806203660"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T19:50:21.756Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
133	b65d938d-1d55-4411-97e6-96e30b4b0e34	ALLEGRO	ce26b271-a091-11f0-bfbd-d3aacc6a2e00	5	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	2025-10-06 16:59:17.426577	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	\N	ONLINE	f	{"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "17887745924", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T19:50:21.756Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
115	cdd0107c-a02c-4d82-a6a2-06407e6fcae0	ALLEGRO	db036950-a07f-11f0-9a42-bb8e9ffafe52	\N	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	2025-10-06 16:40:42.71881	Komoda Bini 50x30x82 D1N1 SONOMA	352.00	352.00	\N	ONLINE	f	{"id": "db036950-a07f-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16602434150", "name": "Komoda Bini 50x30x82 D1N1 SONOMA", "external": {"id": "5905806234510"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T17:40:24.993Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
114	7c6d9066-fc54-43ab-bcbd-f3d5db2c1580	ALLEGRO	115a0100-a07e-11f0-a6cc-b3145592fdde	69	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	2025-10-06 16:20:40.974899	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	405.20	405.20	\N	ONLINE	f	{"id": "115a0100-a07e-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14387674355", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202380"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T17:27:25.814Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
116	87b06386-d191-47bd-8365-c28f693cdd86	ALLEGRO	b856a5c0-a066-11f0-96ea-bf4f56b08af2	67	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	2025-10-06 13:12:02.351111	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	326.00	326.00	\N	ONLINE	f	{"id": "b856a5c0-a066-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862736322", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma", "external": {"id": "5905806202007"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T14:39:59.568Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
8	8fe91da7-4ba0-45cc-a46d-da5031612ed2	ALLEGRO	bcdce582-a1f8-11f0-a6cc-b3145592fdde	87	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	1	773.00	PLN	\N	\N	\N	2025-10-06 17:22:32.515181	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	773.00	773.00	\N	ONLINE	f	{"id": "bcdce582-a1f8-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440328552", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT", "external": {"id": "5905806216875"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T14:43:45.396Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
111	ae7217ab-3d6c-4686-988a-aa59cbc94c77	ALLEGRO	49144960-a066-11f0-b871-03a75625f948	\N	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	2025-10-06 13:12:02.526651	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	326.00	326.00	\N	ONLINE	t	{"id": "49144960-a066-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "14384922015", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806201871"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T14:36:30.528Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2062	4c2527dc-b949-4037-adc3-ce4541e2e8f2	ALLEGRO	\N	304	16602435161	5905806234572	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:54.369344	Komoda Bini 50x36 D1N1 SONOMA	385.00	385.00	PL	ONLINE	f	{"id": "ae6eb920-9dec-11f0-b286-41f712537da1", "tax": null, "offer": {"id": "16602435161", "name": "Komoda Bini 50x36 D1N1 SONOMA", "external": {"id": "5905806234572"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T11:01:43.772Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
19	d315b374-e336-4845-be1f-b67c1bfc48d2	ALLEGRO	68bad8c0-a0f6-11f0-8323-6df02f435f6c	21	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	5905806201994_1.jpg	2025-10-06 17:22:43.295573	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	\N	\N	\N	\N	f	\N	0
1904	93912bad-43e9-479a-9517-de1108ee083e	ALLEGRO	\N	268	12258788829	5905806216936	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:38.260123	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	1827.00	1827.00	PL	ONLINE	t	{"id": "2ebd6e82-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258788829", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma", "external": {"id": "5905806216936"}, "productSet": null}, "price": {"amount": "1827.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1827.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1905	93912bad-43e9-479a-9517-de1108ee083e	ALLEGRO	\N	269	11742813479	5905806204025	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:38.260123	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	776.80	776.80	PL	ONLINE	t	{"id": "2ebd6e83-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11742813479", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA", "external": {"id": "5905806204025"}, "productSet": null}, "price": {"amount": "776.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "776.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1906	93912bad-43e9-479a-9517-de1108ee083e	ALLEGRO	\N	270	15446678390	5905806219623	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:38.260123	Szafka na buty 60x30D2N1Supra SONOMA	1105.00	1105.00	PL	ONLINE	t	{"id": "2ebd6e81-a05b-11f0-819e-1344c439828f", "tax": null, "offer": {"id": "15446678390", "name": "Szafka na buty 60x30D2N1Supra SONOMA", "external": {"id": "5905806219623"}, "productSet": null}, "price": {"amount": "1105.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1105.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1907	93912bad-43e9-479a-9517-de1108ee083e	ALLEGRO	\N	271	15221504597	5905806214253	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:38.260123	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	600.00	600.00	PL	ONLINE	t	{"id": "2ebd6e80-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221504597", "name": "Szafka na buty z szufladą Tres 80x36 Dąb Wotan", "external": {"id": "5905806214253"}, "productSet": null}, "price": {"amount": "600.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "600.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1910	d54b7e0b-655e-444b-8731-b52a7a17a4b2	ALLEGRO	\N	232	15321913673	5905806216943	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:41.976173	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	1827.00	1827.00	PL	ONLINE	f	{"id": "f63e1220-a056-11f0-bc87-8159fe565898", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15321913673", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan", "external": {"id": "5905806216943"}, "productSet": null}, "price": {"amount": "1827.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:47:41.939Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1827.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1912	a02f2666-0535-442d-bf91-17b7ebaf1aa9	ALLEGRO	\N	273	16383693560	5905806234046	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:45.217892	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	638.00	638.00	PL	ONLINE	f	{"id": "19cc45c1-a054-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "16383693560", "name": "Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY", "external": {"id": "5905806234046"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:28:28.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1913	a02f2666-0535-442d-bf91-17b7ebaf1aa9	ALLEGRO	\N	\N	17567410245	\N	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:45.217892	Poduszka ozdobna, dekoracyjna 50x30cm	37.00	37.00	PL	ONLINE	f	{"id": "19cc45c0-a054-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "17567410245", "name": "Poduszka ozdobna, dekoracyjna 50x30cm", "external": null, "productSet": null}, "price": {"amount": "37.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:28:28.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "37.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
38	6f0c8145-d4a8-44a6-b062-42e6235d199a	ALLEGRO	e4edbd40-a204-11f0-9d66-3d00eb1ccfed	7	17946229799	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:31.12584	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	326.00	326.00	\N	ONLINE	f	{"id": "e4edbd40-a204-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "17946229799", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T16:05:37.753Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1646	a08036df-bd6c-4456-8a00-940b3f88035d	ALLEGRO	\N	94	14384932329	5905806202199	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:33.463028	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	350.00	350.00	PL	ONLINE	f	{"id": "5441b350-a51a-11f0-9bfc-3dd64ee50ad6", "tax": null, "offer": {"id": "14384932329", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806202199"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T14:15:49.018Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
41	b8fca34c-d886-423e-8d22-4f5ca87f6916	ALLEGRO	c688be10-a202-11f0-9468-2bd22967b382	12	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	1	344.00	PLN	\N	\N	\N	2025-10-06 17:22:31.760269	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	344.00	344.00	\N	CASH_ON_DELIVERY	f	{"id": "c688be10-a202-11f0-9468-2bd22967b382", "tax": null, "offer": {"id": "16415950409", "name": "Szafka na buty VB50x36 D2N1 DĄB ARTISAN", "external": {"id": "5905806231922"}, "productSet": null}, "price": {"amount": "344.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T15:52:51.208Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "344.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1908	6b4139bb-a130-4fe7-8bc3-6de2d8937d9a	ALLEGRO	\N	272	15225574066	5905806213461	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:40.140262	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY	1705.00	1705.00	PL	CASH_ON_DELIVERY	f	{"id": "89015ee0-a058-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15225574066", "name": "Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY", "external": {"id": "5905806213461"}, "productSet": null}, "price": {"amount": "1705.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:57:59.253Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1705.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
71	8fe91da7-4ba0-45cc-a46d-da5031612ed2	ALLEGRO	bcdce581-a1f8-11f0-a6cc-b3145592fdde	48	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	1	54.00	PLN	\N	\N	\N	2025-10-06 17:22:32.515181	Panel ścienny tapicerowany pan1x50x35	54.00	54.00	\N	ONLINE	f	{"id": "bcdce581-a1f8-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11769358337", "name": "Panel ścienny tapicerowany pan1x50x35", "external": {"id": "5905806222357"}, "productSet": null}, "price": {"amount": "54.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T14:43:45.396Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "54.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1911	758e63ce-f920-40ee-9db8-2c9351f9fdfd	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:43.56169	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "a79e45b0-a054-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:31:25.319Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1916	1956507b-1bfb-445d-b8fd-9a5d53c11489	ALLEGRO	\N	275	15410023447	5905806218879	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:50.096528	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	1123.60	1123.60	PL	ONLINE	f	{"id": "b369bb00-a03f-11f0-8737-b36df7580750", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15410023447", "name": "Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan", "external": {"id": "5905806218879"}, "productSet": null}, "price": {"amount": "1123.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:00:22.614Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1123.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "49.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1917	e005566f-52bc-4ffd-a2a7-e546443f1dbf	ALLEGRO	\N	80	14387675243	5905806202441	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:51.736911	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	423.00	423.00	PL	ONLINE	t	{"id": "93373de0-a034-11f0-ba82-ed153ccc4447", "tax": null, "offer": {"id": "14387675243", "name": "Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny", "external": {"id": "5905806202441"}, "productSet": null}, "price": {"amount": "423.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T08:40:54.699Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "423.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1918	6691dd67-e933-4d6e-b243-33cc0574d347	ALLEGRO	\N	276	16644957145	5905806204179	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:53.294006	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	1343.00	1343.00	PL	ONLINE	f	{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "16644957145", "name": "Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN", "external": {"id": "5905806204179"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T08:22:15.599Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1919	6eb105c6-c9b8-42b6-8772-4859f48bf244	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:54.84649	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "0b50d1a0-a027-11f0-93a2-8fc85806f760", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T07:06:39.712Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1920	2195238b-7a4d-4ab1-8811-aeb10bf49743	ALLEGRO	\N	1	15221503220	5905806214192	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:56.429692	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	564.00	564.00	PL	ONLINE	t	{"id": "6a4a1740-a025-11f0-bc5e-258a5e1e619a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221503220", "name": "Szafka na buty z szufladą Tres 80x30 Dąb Wotan", "external": {"id": "5905806214192"}, "productSet": null}, "price": {"amount": "564.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T06:52:40.437Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "564.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1921	b074f782-32cd-4135-adcf-5bf5c8e0a9d9	ALLEGRO	\N	88	15315950401	5905806214581	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:57.933596	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	611.00	611.00	PL	ONLINE	f	{"id": "a9b37940-9fd4-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15315950401", "name": "Szafka na buty z szufladą Tres 100x36D1N1 SONOMA", "external": {"id": "5905806214581"}, "productSet": null}, "price": {"amount": "611.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T21:14:22.290Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "611.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2063	1c22292f-1a0b-4c7d-b2b3-de82b2e11783	ALLEGRO	\N	305	14209799601	5905806201659	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:55.825537	Szafka na buty Supra 30x30 D1N1 słupek Wotan	532.00	532.00	PL	ONLINE	f	{"id": "0cb131e1-9deb-11f0-8cf9-590a844f62e8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14209799601", "name": "Szafka na buty Supra 30x30 D1N1 słupek Wotan", "external": {"id": "5905806201659"}, "productSet": null}, "price": {"amount": "532.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T10:49:12.333Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "532.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
110	9a074663-43bf-4e50-98f1-fe636f44d8b9	ALLEGRO	9315a850-a085-11f0-ba82-ed153ccc4447	\N	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	2025-10-06 16:43:40.964738	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	788.00	788.00	\N	ONLINE	f	{"id": "9315a850-a085-11f0-ba82-ed153ccc4447", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571569", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905806213560"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T18:20:18.980Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1914	af990d51-95ff-48d6-8f3b-7d00456a376f	ALLEGRO	\N	5	17887745924	5905806208597	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:46.945721	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	PL	CASH_ON_DELIVERY	f	{"id": "c1bba030-a042-11f0-8c4d-9bd96e1ccd86", "tax": null, "offer": {"id": "17887745924", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:23:41.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1915	f0767596-e3d2-40bd-b308-8f61de46497b	ALLEGRO	\N	274	15229738794	5905806214574	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:48.527521	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	611.00	611.00	PL	CASH_ON_DELIVERY	f	{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15229738794", "name": "Szafka na buty z szufladą Tres 100x36D1N1 WOTAN", "external": {"id": "5905806214574"}, "productSet": null}, "price": {"amount": "611.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:04:06.189Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "611.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1922	7c2bc3c5-8345-4b0d-9148-1197e170af19	ALLEGRO	\N	277	15440332407	5905806218176	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:52:59.565071	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	1023.00	1023.00	PL	CASH_ON_DELIVERY	f	{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440332407", "name": "Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN", "external": {"id": "5905806218176"}, "productSet": null}, "price": {"amount": "1023.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:47:53.396Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1023.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1923	f1fa53bb-224d-4ac8-b50d-40faa2b100d7	ALLEGRO	\N	278	15315961595	5905806214673	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:01.402189	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	587.00	587.00	PL	ONLINE	t	{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15315961595", "name": "Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY", "external": {"id": "5905806214673"}, "productSet": null}, "price": {"amount": "587.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:40:08.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "587.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
108	b8fca34c-d886-423e-8d22-4f5ca87f6916	ALLEGRO	c688be11-a202-11f0-9468-2bd22967b382	46	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	1	531.00	PLN	\N	\N	\N	2025-10-06 17:22:31.760269	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	531.00	531.00	\N	CASH_ON_DELIVERY	f	{"id": "c688be11-a202-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155237434", "name": "Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN", "external": {"id": "5905806209129"}, "productSet": null}, "price": {"amount": "531.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T15:52:51.208Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "531.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2064	7225d041-1e07-4f97-aec3-aa90ba023f76	ALLEGRO	\N	88	15315950401	5905806214581	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:57.324587	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	611.00	611.00	PL	ONLINE	f	{"id": "7372dd50-9de3-11f0-9fa0-ab34abe0805b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15315950401", "name": "Szafka na buty z szufladą Tres 100x36D1N1 SONOMA", "external": {"id": "5905806214581"}, "productSet": null}, "price": {"amount": "611.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T09:55:41.998Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "611.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2065	829fc9e3-d523-41a2-a343-d151b7932523	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:58.764992	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "0c56a4e0-9de2-11f0-a07b-27f19dcfd61a", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T09:44:29.276Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2066	e79a565d-ad39-42de-990d-a8d2e6351414	ALLEGRO	\N	266	17358940752	5905806237801	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:58:00.464655	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1391.00	1391.00	PL	ONLINE	f	{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17358940752", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir", "external": {"id": "5905806237801"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T09:41:55.261Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
175	41318b56-757a-4bd2-9a48-12ab04b35df3	SHOPER	\N	177	589	5905806217681	\N	1	\N	PLN	\N	\N	5905806217681_1.jpg	2025-10-06 18:33:08.83739	Szafka na buty z szufladą Tres2 60x92x30 DĄB WOTAN	452.00	452.00	PL	ONLINE	f	{"id": "27008", "tax": "23%", "code": "5905806217681", "name": "Szafka na buty z szufladą Tres2 60x92x30 DĄB WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "452.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "918", "tax_value": "23", "product_id": "589", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
92	c860c1c8-7dd9-4836-95b3-30aef01b346e	ALLEGRO	dc02d5b0-a134-11f0-96ea-bf4f56b08af2	80	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	2025-10-06 17:22:40.537619	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	423.00	423.00	\N	ONLINE	f	{"id": "dc02d5b0-a134-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "14387675243", "name": "Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny", "external": {"id": "5905806202441"}, "productSet": null}, "price": {"amount": "423.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T15:15:14.658Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "423.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1925	9c3e0586-35d1-4150-b7a1-cf015039194b	ALLEGRO	\N	279	10945431249	5905806208191	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:02.963613	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	332.00	332.00	PL	ONLINE	f	{"id": "a241d610-9fc6-11f0-8c53-b9e6d89e658e", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10945431249", "name": "Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały", "external": {"id": "5905806208191"}, "productSet": null}, "price": {"amount": "332.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:35:20.332Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "332.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
170	d5a8ba47-ba23-4000-9d3e-22a7c2c56baf	SHOPER	\N	172	1064	5905204699560	\N	1	\N	PLN	\N	\N	5905204699560_1.jpg	2025-10-06 18:33:06.723802	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA	1283.00	1283.00	PL	ONLINE	f	{"id": "27015", "tax": "23%", "code": "5905204699560", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1283.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23152", "quantity": "1", "stock_id": "1434", "tax_value": "23", "product_id": "1064", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
2067	c2c33378-f06a-43dc-a8ef-c32a591355e9	ALLEGRO	\N	306	15258837630	5905806211030	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:58:01.912169	Wieszak ścienny W60 na ubrania 60cm ARISTAN	193.00	193.00	PL	ONLINE	f	{"id": "85db67c0-9ddc-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "15258837630", "name": "Wieszak ścienny W60 na ubrania 60cm ARISTAN", "external": {"id": "5905806211030"}, "productSet": null}, "price": {"amount": "193.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T09:06:09.646Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "193.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
171	5c667f98-22eb-41a7-9c05-6cc5dde0116f	SHOPER	\N	173	2428	5905806233544	\N	1	\N	PLN	\N	\N	5905806233544_1.jpg	2025-10-06 18:33:07.209279	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 CZARNY WOTAN	418.00	418.00	PL	ONLINE	f	{"id": "27014", "tax": "23%", "code": "5905806233544", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 CZARNY WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "418.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23151", "quantity": "1", "stock_id": "2826", "tax_value": "23", "product_id": "2428", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
328	0f31b776-fce0-43a7-936a-655f7e33bbf9	ALLEGRO	\N	187	15463830012	5905806220605	\N	1	\N	PLN	\N	\N	5905806220605_1.jpg	2025-10-06 19:33:23.533952	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	1052.00	1052.00	PL	ONLINE	t	{"id": "c8d78270-a2e6-11f0-a638-c7e352f2113f", "tax": null, "offer": {"id": "15463830012", "name": "Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan", "external": {"id": "5905806220605"}, "productSet": null}, "price": {"amount": "1052.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:01:56.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1052.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
172	e0e98e16-c86c-43c2-a850-3725d7f7c3f9	SHOPER	\N	174	708	5905806202267	\N	1	\N	PLN	\N	\N	\N	2025-10-06 18:33:07.700476	Szafka na buty VB80x30D S1 siedzisko schowek 80cm SO	399.00	399.00	PL	ONLINE	f	{"id": "27013", "tax": "0%", "code": "5905806202267", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm SO", "type": "0", "unit": "szt.", "pkwiu": "", "price": "399.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23150", "quantity": "1", "stock_id": "1037", "tax_value": "0", "product_id": "708", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
176	41318b56-757a-4bd2-9a48-12ab04b35df3	SHOPER	\N	178	2822	5905806235067	\N	1	\N	PLN	\N	\N	5905806235067_1.jpg	2025-10-06 18:33:08.83739	Szafka na buty Supra-Nex 50x36x244 D1N1 WOTAN	1309.00	1309.00	PL	ONLINE	f	{"id": "27009", "tax": "23%", "code": "5905806235067", "name": "Szafka na buty Supra-Nex 50x36x244 D1N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1309.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "3220", "tax_value": "23", "product_id": "2822", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
173	2246fa7a-7f3e-403c-a1d8-2680da01d327	SHOPER	\N	175	2030	5905806228199	\N	1	\N	PLN	\N	\N	5905806228199_1.jpg	2025-10-06 18:33:08.207471	Komoda Bones 60x36D4N1 ARTISAN	725.00	725.00	PL	ONLINE	f	{"id": "27011", "tax": "23%", "code": "5905806228199", "name": "Komoda Bones 60x36D4N1 ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "725.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23149", "quantity": "1", "stock_id": "2428", "tax_value": "23", "product_id": "2030", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1926	284fd879-2b65-4b0d-83f2-61dc3733c3c4	ALLEGRO	\N	244	12258723368	5905806216981	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:04.769946	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1887.00	1887.00	PL	ONLINE	f	{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258723368", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma", "external": {"id": "5905806216981"}, "productSet": null}, "price": {"amount": "1887.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T18:49:37.914Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1887.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1927	81c22484-47e3-4dcf-8ef8-c91f58f46f52	ALLEGRO	\N	280	16276327427	5905806233995	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:06.305605	Komoda Bini 60x36D1N1 SONOMA	462.00	462.00	PL	ONLINE	f	{"id": "424b1740-9fc0-11f0-8509-57e61af36c1f", "tax": null, "offer": {"id": "16276327427", "name": "Komoda Bini 60x36D1N1 SONOMA", "external": {"id": "5905806233995"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T18:48:09.646Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
166	9e6986ba-a653-4c50-af11-9fb8d88c7ecd	SHOPER	\N	168	910	5905806203592	\N	1	\N	PLN	\N	\N	5905806203592_1.jpg	2025-10-06 18:33:05.894736	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	278.00	278.00	PL	ONLINE	f	{"id": "27016", "tax": "23%", "code": "5905806203592", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "278.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1269", "tax_value": "23", "product_id": "910", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1928	cf05789a-1f63-4f3d-ab5c-e8bddd0c3d71	ALLEGRO	\N	219	15155167503	5905806208443	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:07.880567	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1391.00	1391.00	PL	ONLINE	f	{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155167503", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN", "external": {"id": "5905806208443"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T16:55:09.351Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1929	5d711f4a-6c5f-486a-b476-23f2d97289d5	ALLEGRO	\N	221	12266508963	5905204699102	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:09.384561	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1391.00	1391.00	PL	ONLINE	f	{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508963", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot", "external": {"id": "5905204699102"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T16:41:35.829Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1930	94d24309-ef27-4ae7-8a75-23c8c7a49965	ALLEGRO	\N	281	12476571893	5905204699492	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:10.853809	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	1015.00	1015.00	PL	ONLINE	f	{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571893", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały", "external": {"id": "5905204699492"}, "productSet": null}, "price": {"amount": "1015.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T16:07:49.871Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1015.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
180	6fc73f76-ed30-4028-b7e8-02fa678f9f91	SHOPER	\N	180	1627	5905806217001	\N	1	\N	PLN	\N	\N	5905806217001_1.jpg	2025-10-06 18:33:10.613957	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny	1887.00	1887.00	PL	ONLINE	f	{"id": "27005", "tax": "23%", "code": "5905806217001", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1887.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23145", "quantity": "1", "stock_id": "2013", "tax_value": "23", "product_id": "1627", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
49	c43c79a3-9478-4977-ad54-46c2220d3b8c	ALLEGRO	46381210-a1f3-11f0-9468-2bd22967b382	51	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	1	1705.00	PLN	\N	\N	\N	2025-10-06 17:22:33.239849	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	1705.00	1705.00	\N	ONLINE	f	{"id": "46381210-a1f3-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15225570547", "name": "Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY", "external": {"id": "5905806213379"}, "productSet": null}, "price": {"amount": "1705.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T14:00:59.581Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1705.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
179	281871b1-2bce-46a1-ab5f-fae0bfffe6ff	SHOPER	\N	181	3580	5905806238587	\N	1	\N	PLN	\N	\N	5905806238587_1.jpg	2025-10-06 18:33:10.090647	 Szafka na buty VB100x36D1N1 Dąb Estana	546.00	546.00	PL	ONLINE	f	{"id": "27006", "tax": "23%", "code": "5905806238587", "name": " Szafka na buty VB100x36D1N1 Dąb Estana", "type": "0", "unit": "szt.", "pkwiu": "", "price": "546.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23146", "quantity": "1", "stock_id": "3978", "tax_value": "23", "product_id": "3580", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
94	ee12913d-06ca-42fe-b608-835d6dc0f474	ALLEGRO	cedcea31-a12d-11f0-b1e3-b7ce882fc700	21	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:40.953939	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	\N	ONLINE	f	{"id": "cedcea31-a12d-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T14:27:37.412Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
169	9e6986ba-a653-4c50-af11-9fb8d88c7ecd	SHOPER	\N	171	1231	5905806213232	\N	1	\N	PLN	\N	\N	5905806213232_1.jpg	2025-10-06 18:33:05.894736	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Dąb Artisan	1015.00	1015.00	PL	ONLINE	f	{"id": "27019", "tax": "23%", "code": "5905806213232", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1015.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1609", "tax_value": "23", "product_id": "1231", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1931	085ed17b-7007-4c38-bae4-ed3e5b9562cb	ALLEGRO	\N	95	12266374192	5905806208986	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:12.409129	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	556.00	556.00	PL	ONLINE	f	{"id": "0356e080-9fa9-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266374192", "name": "Szafka na buty Supra 30 słupek 30x36 D1N1 Biały", "external": {"id": "5905806208986"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T16:02:56.688Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1932	35a2b49c-e3ea-4693-aa44-fae45c6374ae	ALLEGRO	\N	237	14384922015	5905806201871	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:13.913636	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "e44aaf60-9fa7-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "14384922015", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806201871"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T15:54:28.685Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1933	83b7f27c-b110-4e0b-a884-3c6479d384a5	ALLEGRO	\N	282	16602441323	5905806234770	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:15.422578	Komoda Bini 100x36 D1N1 WOTAN	682.00	682.00	PL	CASH_ON_DELIVERY	f	{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2", "tax": null, "offer": {"id": "16602441323", "name": "Komoda Bini 100x36 D1N1 WOTAN", "external": {"id": "5905806234770"}, "productSet": null}, "price": {"amount": "682.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T15:39:26.910Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "682.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1934	f0d21bdf-cf44-4fcd-adf0-371ba61d1586	ALLEGRO	\N	67	10862736322	5905806202007	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:17.130215	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	326.00	326.00	PL	ONLINE	t	{"id": "87e8a580-9fa0-11f0-89e4-21adac12f2a9", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862736322", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma", "external": {"id": "5905806202007"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T15:02:21.379Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1935	68547125-ab30-4750-86d4-1e3fb804a38c	ALLEGRO	\N	39	15221043126	5905806208337	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:18.665558	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	478.00	478.00	PL	ONLINE	t	{"id": "651189b0-9f9f-11f0-8234-ff8a51029ee2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221043126", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Wotan", "external": {"id": "5905806208337"}, "productSet": null}, "price": {"amount": "478.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:53:00.329Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "478.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
214	52b6a491-ba06-4141-9b76-c01b9fa87a74	SHOPER	\N	183	860	5905806203370	\N	1	\N	PLN	\N	\N	\N	2025-10-06 18:52:35.818776	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele CZARNY-LANCELOT	811.00	811.00	PL	ONLINE	f	{"id": "27021", "tax": "0%", "code": "5905806203370", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele CZARNY-LANCELOT", "type": "0", "unit": "szt.", "pkwiu": "", "price": "811.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23155", "quantity": "1", "stock_id": "1204", "tax_value": "0", "product_id": "860", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
198	e1cb5ad6-c9e5-44f0-a551-1b3722f121b6	SHOPER	\N	182	3702	5905806238525	\N	1	\N	PLN	\N	\N	5905806238525_1.jpg	2025-10-06 18:46:15.550476	Próbki płyt meblowych	30.00	30.00	PL	ONLINE	f	{"id": "27020", "tax": "23%", "code": "5905806238525", "name": "Próbki płyt meblowych", "type": "0", "unit": "szt.", "pkwiu": "", "price": "30.00", "option": "", "weight": "2", "loyalty": null, "unit_fp": "0", "order_id": "23154", "quantity": "1", "stock_id": "4100", "tax_value": "23", "product_id": "3702", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
34	244d10e9-782c-4a37-9e12-48b2e91449f0	ALLEGRO	c5a90640-a21f-11f0-96ea-bf4f56b08af2	21	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:29.329328	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	\N	ONLINE	f	{"id": "c5a90640-a21f-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:17:05.231Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
178	d580b61e-f8d7-4cf8-a3fc-571ed0422a91	SHOPER	\N	180	1627	5905806217001	\N	1	\N	PLN	\N	\N	5905806217001_1.jpg	2025-10-06 18:33:09.587604	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny	1887.00	1887.00	PL	ONLINE	f	{"id": "27007", "tax": "23%", "code": "5905806217001", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1887.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23147", "quantity": "1", "stock_id": "2013", "tax_value": "23", "product_id": "1627", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1575	ed92a7fe-50e9-43a7-956a-136a19fde8a7	SHOPER	\N	198	2145	5905806229011	\N	1	\N	PLN	\N	\N	5905806229011_1.jpg	2025-10-09 19:01:04.235908	Komoda Bones 60x36D4N1 CZARNY	725.00	725.00	PL	ONLINE	f	{"id": "27053", "tax": "23%", "code": "5905806229011", "name": "Komoda Bones 60x36D4N1 CZARNY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "725.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23179", "quantity": "1", "stock_id": "2543", "tax_value": "23", "product_id": "2145", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1936	36211d28-aef3-4c1e-8cbb-09f2cfbb32f0	ALLEGRO	\N	283	15440329487	5905806217995	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:20.219267	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	773.00	773.00	PL	ONLINE	f	{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440329487", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA", "external": {"id": "5905806217995"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:23:26.503Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
326	2781fe9d-4535-488f-a7c5-2ce3d3dfbd9d	ALLEGRO	\N	15	14384932878	5905806202212	\N	1	\N	PLN	\N	\N	\N	2025-10-06 19:33:23.028246	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	350.00	350.00	PL	ONLINE	f	{"id": "c01fd770-a2e8-11f0-8144-0ba8ff5b8d19", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384932878", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202212"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:19:55.518Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1937	ceb5d237-29c6-45f6-9303-4f0637c80e1f	ALLEGRO	\N	284	15251019919	5905806204162	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:21.859258	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	1391.00	1391.00	PL	ONLINE	f	{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15251019919", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN", "external": {"id": "5905806204162"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:20:28.097Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
230	94afc2e6-04df-439f-a903-9206384b1bc7	SHOPER	\N	184	986	5905806208580	\N	1	\N	PLN	\N	\N	5905806208580_1.jpg	2025-10-06 19:00:30.430201	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	828.00	828.00	PL	CASH_ON_DELIVERY	f	{"id": "27022", "tax": "23%", "code": "5905806208580", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "828.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23156", "quantity": "1", "stock_id": "1356", "tax_value": "23", "product_id": "986", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
181	ce7996dc-24f5-4a67-980d-5044c9f1683c	SHOPER	\N	180	1627	5905806217001	\N	1	\N	PLN	\N	\N	5905806217001_1.jpg	2025-10-06 18:33:11.083847	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny	1887.00	1887.00	PL	ONLINE	f	{"id": "27004", "tax": "23%", "code": "5905806217001", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1887.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23144", "quantity": "1", "stock_id": "2013", "tax_value": "23", "product_id": "1627", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
327	0f31b776-fce0-43a7-936a-655f7e33bbf9	ALLEGRO	\N	186	15250482464	5905806215212	\N	1	\N	PLN	\N	\N	5905806215212_1.jpg	2025-10-06 19:33:23.533952	Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN	1832.00	1832.00	PL	ONLINE	t	{"id": "c8d78271-a2e6-11f0-a638-c7e352f2113f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15250482464", "name": "Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN", "external": {"id": "5905806215212"}, "productSet": null}, "price": {"amount": "1832.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:01:56.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1832.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1577	8ffe12a4-7c8b-492a-971e-b493835ed612	SHOPER	\N	200	2104	5905806228946	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:07.26201	Komoda Bones 50x36D1N1 ARTISAN	638.00	638.00	PL	ONLINE	f	{"id": "27050", "tax": "23%", "code": "5905806228946", "name": "Komoda Bones 50x36D1N1 ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "638.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23177", "quantity": "1", "stock_id": "2502", "tax_value": "23", "product_id": "2104", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
310	55061b08-83b4-4b61-afa4-d1cb1d944443	SHOPER	\N	185	2590	5905806231984	\N	1	\N	PLN	\N	\N	5905806231984_1.jpg	2025-10-06 19:27:17.659069	Szafka na buty VB60x36D2N1 WOTAN	368.00	368.00	PL	ONLINE	f	{"id": "27023", "tax": "23%", "code": "5905806231984", "name": "Szafka na buty VB60x36D2N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "368.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23157", "quantity": "1", "stock_id": "2988", "tax_value": "23", "product_id": "2590", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1645	f9723d0d-1d72-46a9-9b2b-4ca20e07e565	ALLEGRO	\N	222	16602435285	5905806234589	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:31.851944	Komoda Bini 50x36 D1N1 WOTAN	385.00	385.00	PL	ONLINE	f	{"id": "6d481a60-a51a-11f0-a588-b391296a673a", "tax": null, "offer": {"id": "16602435285", "name": "Komoda Bini 50x36 D1N1 WOTAN", "external": {"id": "5905806234589"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T14:16:23.628Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
331	e6eb3577-fb28-4f52-8107-cc875e961990	ALLEGRO	\N	189	16901470101	5905806211528	\N	1	\N	PLN	\N	\N	\N	2025-10-06 19:33:24.984842	Wieszak ścienny WP100 na ubrania 100cm WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "b22cb0e0-a2e1-11f0-aba2-b3553c261cc2", "tax": null, "offer": {"id": "16901470101", "name": "Wieszak ścienny WP100 na ubrania 100cm WOTAN", "external": {"id": "5905806211528"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:26:05.247Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
332	1776e572-dfbb-4034-b56d-75d4fbecc56b	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-06 19:33:25.49879	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "25f005b0-a2db-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:38:43.272Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
333	fef5b7f8-5c66-4dd1-bad1-fd4311def8bd	ALLEGRO	\N	190	15919784886	5905806228991	\N	1	\N	PLN	\N	\N	\N	2025-10-06 19:33:25.920887	Komoda Bones 50x36D1N1 WOTAN	638.00	638.00	PL	ONLINE	f	{"id": "35817720-a2db-11f0-8b51-87d1833631ec", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919784886", "name": "Komoda Bones 50x36D1N1 WOTAN", "external": {"id": "5905806228991"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:38:33.286Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1938	ceb5d237-29c6-45f6-9303-4f0637c80e1f	ALLEGRO	\N	59	15176238729	5905806209662	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:21.859258	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	592.00	592.00	PL	ONLINE	f	{"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176238729", "name": "Szafka komoda na buty 80x36 D2N1 Altus WOTAN", "external": {"id": "5905806209662"}, "productSet": null}, "price": {"amount": "592.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:20:28.097Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "592.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
334	6874e3ad-3d6d-4448-8beb-25720ddd6daf	ALLEGRO	\N	191	16859417789	5905806210613	\N	1	\N	PLN	\N	\N	5905806210613_1.jpg	2025-10-06 19:33:26.374775	Półka ścienna 80x18x20cm CZARNY	98.00	98.00	PL	ONLINE	f	{"id": "132bc050-a2da-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16859417789", "name": "Półka ścienna 80x18x20cm CZARNY", "external": {"id": "5905806210613"}, "productSet": null}, "price": {"amount": "98.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:30:22.850Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "98.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1939	fab488f6-725a-4990-b233-f6051b1bf37c	ALLEGRO	\N	90	14604181578	5905806203660	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:23.509116	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	229.00	229.00	PL	ONLINE	f	{"id": "2f47cce2-9f9a-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14604181578", "name": "Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan", "external": {"id": "5905806203660"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:15:42.071Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
336	33dd4f3c-67c5-46a3-829a-2d98dad1956a	ALLEGRO	\N	193	17395006524	5905806238310	\N	1	\N	PLN	\N	\N	5905806238310_1.jpg	2025-10-06 19:33:27.296289	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	788.00	788.00	PL	ONLINE	f	{"id": "617f48e0-a2d9-11f0-a638-c7e352f2113f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17395006524", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY", "external": {"id": "5905806238310"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:26:46.285Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1576	7b16d5be-8f53-43d7-a68b-37b3f9307458	SHOPER	\N	199	3361	5905806203509	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:05.885702	Zestaw 80x30D1N1 WP80 szafka na buty z wieszakiem LANCELOT	677.00	677.00	PL	ONLINE	f	{"id": "27052", "tax": "23%", "code": "5905806203509", "name": "Zestaw 80x30D1N1 WP80 szafka na buty z wieszakiem LANCELOT", "type": "0", "unit": "szt.", "pkwiu": "", "price": "677.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23178", "quantity": "1", "stock_id": "3759", "tax_value": "23", "product_id": "3361", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
335	c48102bf-5063-4cff-85cd-4216a60acc73	ALLEGRO	\N	192	12487594410	5905204699560	\N	1	\N	PLN	\N	\N	5905204699560_1.jpg	2025-10-06 19:33:26.829456	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	1283.00	1283.00	PL	ONLINE	f	{"id": "b08f0010-a2d9-11f0-abd8-f5344f24907b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487594410", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699560"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:29:26.939Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
57	7bcd4fec-5914-4850-a79c-188d72d914fc	ALLEGRO	c96cfca0-a1de-11f0-954f-f9092bddbf0d	62	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	2025-10-06 17:22:35.004857	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	510.00	510.00	\N	ONLINE	f	{"id": "c96cfca0-a1de-11f0-954f-f9092bddbf0d", "tax": null, "offer": {"id": "15048053205", "name": "Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny", "external": {"id": "5905806205435"}, "productSet": null}, "price": {"amount": "510.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T11:35:25.210Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "510.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
14	90d4630d-41f1-434f-81da-4a333cecdef9	ALLEGRO	989491f0-a2b1-11f0-96ea-bf4f56b08af2	89	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	5905806237795_1.jpg	2025-10-06 17:22:23.659096	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1343.00	1343.00	\N	ONLINE	f	{"id": "989491f0-a2b1-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17358916449", "name": "Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir", "external": {"id": "5905806237795"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T12:40:27.330Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1940	fab488f6-725a-4990-b233-f6051b1bf37c	ALLEGRO	\N	263	15372387250	5905806217926	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:23.509116	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	737.00	737.00	PL	ONLINE	f	{"id": "2f47cce1-9f9a-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:15:42.071Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1941	3e0695e9-6a84-4f4d-acc6-5d6ae3197ca0	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:25.053846	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "ec69f350-9f97-11f0-86d6-599d2223cd68", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T13:59:34.211Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1942	bddf780b-878b-4c75-9f15-dfa6f102f564	ALLEGRO	\N	285	16383698094	5905806234084	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:26.561265	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	638.00	638.00	PL	ONLINE	f	{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3", "tax": null, "offer": {"id": "16383698094", "name": "Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY", "external": {"id": "5905806234084"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T08:11:20.907Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1943	e26c36aa-3406-41a6-b329-d3bc1ae0bdf6	ALLEGRO	\N	286	15134391509	5905806209372	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:28.085804	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	1016.00	1016.00	PL	ONLINE	f	{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2", "tax": null, "offer": {"id": "15134391509", "name": "Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY", "external": {"id": "5905806209372"}, "productSet": null}, "price": {"amount": "1016.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T08:01:02.229Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1016.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1944	8beda61d-4973-4308-bacb-094eeb506036	ALLEGRO	\N	75	15225857105	5905806206678	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:29.608552	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	523.00	523.00	PL	ONLINE	f	{"id": "2beb8780-9f63-11f0-8509-57e61af36c1f", "tax": null, "offer": {"id": "15225857105", "name": "Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY", "external": {"id": "5905806206678"}, "productSet": null}, "price": {"amount": "523.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T07:41:40.704Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "523.00", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "23.00", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1945	179a9249-19f4-43cd-9779-9faeaad1091f	ALLEGRO	\N	68	15440328823	5905806217902	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:31.124514	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	773.00	773.00	PL	CASH_ON_DELIVERY	f	{"id": "8a5ac120-9f57-11f0-8509-57e61af36c1f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440328823", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY", "external": {"id": "5905806217902"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T06:54:16.495Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1947	103bf957-88c6-489d-841c-e1b4f19cb6fe	ALLEGRO	\N	287	12266500239	5905204699126	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:34.124913	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA	1343.00	1343.00	PL	ONLINE	f	{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266500239", "name": "Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA", "external": {"id": "5905204699126"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T20:30:27.830Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1578	8ffe12a4-7c8b-492a-971e-b493835ed612	SHOPER	\N	201	3206	5905806227253	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:07.26201	Garderoba 60x30D1N1 3PAN szafka na buty wieszak panele ARTISAN	747.00	747.00	PL	ONLINE	f	{"id": "27051", "tax": "0%", "code": "5905806227253", "name": "Garderoba 60x30D1N1 3PAN szafka na buty wieszak panele ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "747.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23177", "quantity": "1", "stock_id": "3604", "tax_value": "0", "product_id": "3206", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1948	6c48d7d9-25c8-4b64-87b0-dd86f5418a6a	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:35.68323	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "a1dbe860-9f02-11f0-b871-03a75625f948", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T20:11:58.320Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1949	54732381-b923-4d56-bedf-ade438d7c6b8	ALLEGRO	\N	253	12476571569	5905806213560	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:37.16221	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	788.00	788.00	PL	ONLINE	f	{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571569", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905806213560"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:36:53.081Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2094	034c0cd0-c96b-457e-aae5-6b9633703159	ALLEGRO	\N	288	12487657175	5905204699614	\N	1	\N	PLN	\N	\N	\N	2025-10-09 20:12:59.298082	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1319.00	1319.00	PL	ONLINE	f	{"id": "0938cba0-a54c-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487657175", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699614"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T20:12:24.285Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2	b6397282-b449-4034-a1b6-021994abfb57	ALLEGRO	74e6a880-a28c-11f0-9d66-3d00eb1ccfed	43	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	1	725.00	PLN	\N	\N	5905806228229_1.jpg	2025-10-06 17:22:25.409418	Komoda Bones 60x36D4N1 SONOMA	725.00	725.00	\N	ONLINE	t	{"id": "74e6a880-a28c-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919529373", "name": "Komoda Bones 60x36D4N1 SONOMA", "external": {"id": "5905806228229"}, "productSet": null}, "price": {"amount": "725.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T08:15:10.801Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "725.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1951	c5896a78-436c-4527-ad87-b6ab7a54692a	ALLEGRO	\N	288	12487657175	5905204699614	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:40.214695	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1319.00	1319.00	PL	ONLINE	f	{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487657175", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699614"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:19:10.157Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1954	17ba29e3-6330-4b0e-9c20-b26273fd15e4	ALLEGRO	\N	\N	17736467450	\N	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:43.314516	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	326.00	326.00	PL	ONLINE	f	{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17736467450", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR", "external": null, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:13:20.451Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1580	a3253de2-eee8-433a-bfbf-a704f0e66fe6	SHOPER	\N	203	1480	5905806215991	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:08.794663	Szafka na buty z wieszakiem VB50x36D1N1 WP50  SONOMA	531.00	531.00	PL	ONLINE	f	{"id": "27049", "tax": "23%", "code": "5905806215991", "name": "Szafka na buty z wieszakiem VB50x36D1N1 WP50  SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "531.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23176", "quantity": "1", "stock_id": "1866", "tax_value": "23", "product_id": "1480", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1956	70e3de57-e2b7-4a20-8ea5-c76d6e2d57fa	ALLEGRO	\N	19	12266508168	5905204699089	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:44.932963	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	PL	ONLINE	f	{"id": "9c695ea0-9ef6-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T18:45:15.903Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1957	816c81f7-bb42-4dbf-b2c0-5bce31c0f564	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:46.284673	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "a69df030-9ef5-11f0-817a-fb3753e68c2d", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T18:38:20.909Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1958	4cda50ee-4425-4c0b-9adc-28a786ca48ba	ALLEGRO	\N	\N	17475498034	\N	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:47.812905	Szafka na buty z siedziskiem i schowkiem VB80x30D1N1 Dąb Estana	399.00	399.00	PL	ONLINE	f	{"id": "a0795ae0-9ef1-11f0-9dc3-f9a3debc1314", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17475498034", "name": "Szafka na buty z siedziskiem i schowkiem VB80x30D1N1 Dąb Estana", "external": null, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T18:09:14.622Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1959	39f7dfb8-5c10-477c-9199-3f84fdffa08e	ALLEGRO	\N	68	15440328823	5905806217902	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:49.317116	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	773.00	773.00	PL	ONLINE	f	{"id": "9ea46940-9ef0-11f0-88a7-41bf7e4bf551", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440328823", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY", "external": {"id": "5905806217902"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T18:04:04.088Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
26	dd3ba2e2-8844-4718-ab23-f6352685d107	ALLEGRO	2931ddc1-a22c-11f0-809f-f9f6de958f67	29	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	1	594.00	PLN	\N	\N	\N	2025-10-06 17:22:27.850836	Komoda Bini 80x36 D1N1 CZARNY	594.00	594.00	\N	ONLINE	f	{"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67", "tax": null, "offer": {"id": "16602437468", "name": "Komoda Bini 80x36 D1N1 CZARNY", "external": {"id": "5905806234688"}, "productSet": null}, "price": {"amount": "594.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T20:47:20.515Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "594.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1952	008ea785-127b-446a-b211-0140afd67f34	ALLEGRO	\N	271	15221504597	5905806214253	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:41.755564	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	600.00	600.00	PL	ONLINE	f	{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221504597", "name": "Szafka na buty z szufladą Tres 80x36 Dąb Wotan", "external": {"id": "5905806214253"}, "productSet": null}, "price": {"amount": "600.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:17:09.018Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "600.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1654	215661aa-657d-4f9c-83d3-3914eaff33b0	ALLEGRO	\N	227	15919776759	5905806228861	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:44.458356	Komoda Bones 60x36D1N1 SONOMA	671.00	671.00	PL	ONLINE	f	{"id": "f61927d0-a4f2-11f0-9b0c-e511fc7361fa", "tax": null, "offer": {"id": "15919776759", "name": "Komoda Bones 60x36D1N1 SONOMA", "external": {"id": "5905806228861"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:33:27.499Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
70	97b76337-7ff2-4380-8f3b-a2feadfba1da	ALLEGRO	9357c2a0-a1ff-11f0-8e98-fdfd51e10ba4	5	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	2025-10-06 17:22:32.250706	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	\N	ONLINE	f	{"id": "9357c2a0-a1ff-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "17887745924", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T15:28:16.747Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
42	235511e9-44ef-46ad-97a3-f3715468bfb7	ALLEGRO	0dbe4b40-a200-11f0-a6cc-b3145592fdde	5	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	2025-10-06 17:22:32.036786	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	\N	ONLINE	f	{"id": "0dbe4b40-a200-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17887745924", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T15:30:18.136Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1581	75a92b08-4031-418c-a35b-b9b648ee603b	SHOPER	\N	204	1641	5905806218558	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:10.253988	Tkanina Fjord Czarny	30.00	30.00	PL	ONLINE	f	{"id": "27044", "tax": "23%", "code": "5905806218558", "name": "Tkanina Fjord Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "30.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23174", "quantity": "1", "stock_id": "2039", "tax_value": "23", "product_id": "1641", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
580	057c6343-8315-47fb-a556-fab77911fd81	ALLEGRO	\N	61	14387670556	5905806202274	\N	1	\N	PLN	\N	\N	\N	2025-10-06 20:11:49.708065	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	399.00	399.00	PL	ONLINE	t	{"id": "0b5a9500-a2ed-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "14387670556", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT", "external": {"id": "5905806202274"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:46:27.502Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1584	d578be8d-e700-4b72-b2ed-5af05fed2897	SHOPER	\N	206	909	5905806203585	\N	1	\N	PLN	\N	\N	5905806203585_1.jpg	2025-10-09 19:01:12.890428	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	278.00	278.00	PL	ONLINE	f	{"id": "27042", "tax": "23%", "code": "5905806203585", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "278.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23172", "quantity": "1", "stock_id": "1268", "tax_value": "23", "product_id": "909", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1961	67637759-7cc5-4be9-a09d-9d9ac7ef759c	ALLEGRO	\N	290	12405971238	5905204699140	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:52.411705	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	1136.00	1136.00	PL	ONLINE	f	{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12405971238", "name": "Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905204699140"}, "productSet": null}, "price": {"amount": "1136.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:54:29.258Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1136.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
44	24894c6e-1b00-4b4d-9e3f-5ebfef998748	ALLEGRO	394b5470-a1eb-11f0-b1e3-b7ce882fc700	\N	17736463271	\N	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm KASZMIR	1	314.00	PLN	\N	\N	\N	2025-10-06 17:22:34.549815	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm KASZMIR	314.00	314.00	\N	ONLINE	f	{"id": "394b5470-a1eb-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "17736463271", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm KASZMIR", "external": null, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:01:59.971Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
58	7776686b-4fd2-46c3-a720-ba3310e1499b	ALLEGRO	a2030480-a1d8-11f0-aa33-a79405b55c6d	63	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	1	638.00	PLN	\N	\N	\N	2025-10-06 17:22:35.211303	Komoda Bones 50x36D1N1 ARTISAN	638.00	638.00	\N	CASH_ON_DELIVERY	f	{"id": "a2030480-a1d8-11f0-aa33-a79405b55c6d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919782083", "name": "Komoda Bones 50x36D1N1 ARTISAN", "external": {"id": "5905806228946"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T10:49:18.244Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1962	5a05c42a-1875-4fbb-bc7d-cc7850fc6ad0	ALLEGRO	\N	263	15372387250	5905806217926	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:54.029929	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	737.00	737.00	PL	ONLINE	f	{"id": "099509a0-9eef-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:51:37.691Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "BUNDLE"}], "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1964	0e9f6ebc-a0ed-4094-a698-15ba1e1696be	ALLEGRO	\N	292	11769341228	5905806208412	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:55.625141	Panel ścienny tapicerowany pan1x80x30	75.00	75.00	PL	ONLINE	f	{"id": "d9e03540-9eee-11f0-b465-492415e4339b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11769341228", "name": "Panel ścienny tapicerowany pan1x80x30", "external": {"id": "5905806208412"}, "productSet": null}, "price": {"amount": "75.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:48:50.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "75.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1585	b84f4552-5f5b-4255-8164-e7036a7b893b	SHOPER	\N	207	974	5905806208467	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:14.203914	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	780.00	780.00	PL	ONLINE	f	{"id": "27033", "tax": "23%", "code": "5905806208467", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma", "type": "0", "unit": "szt.", "pkwiu": "", "price": "780.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23167", "quantity": "1", "stock_id": "1344", "tax_value": "23", "product_id": "974", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
62	eb287617-26ff-4d14-99c2-124801b432ea	ALLEGRO	337c3b80-a1ce-11f0-954f-f9092bddbf0d	78	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	405.20	PLN	\N	\N	\N	2025-10-06 17:22:36.044306	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	405.20	405.20	\N	CASH_ON_DELIVERY	f	{"id": "337c3b80-a1ce-11f0-954f-f9092bddbf0d", "tax": null, "offer": {"id": "14387674657", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN", "external": {"id": "5905806202403"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T09:36:51.235Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1966	12828ab1-9b26-4c96-a067-d8afc5caf32b	ALLEGRO	\N	50	15176152026	5905806212952	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:58.794083	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	556.00	556.00	PL	ONLINE	f	{"id": "3046e840-9ee8-11f0-a30a-89acbba18695", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176152026", "name": "Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan", "external": {"id": "5905806212952"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:02:39.290Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
64	3c777858-cd76-4bbd-90da-f0c4fa7cf941	ALLEGRO	7eb56d10-a1bf-11f0-bfbd-d3aacc6a2e00	94	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	2025-10-06 17:22:37.134988	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	350.00	350.00	\N	ONLINE	f	{"id": "7eb56d10-a1bf-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14384932329", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806202199"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T07:47:19.820Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1967	e70a8394-ff67-4861-b837-72f089885d96	ALLEGRO	\N	15	14384932878	5905806202212	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:00.306078	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	350.00	350.00	PL	ONLINE	f	{"id": "1c637410-9ee3-11f0-9dc3-f9a3debc1314", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384932878", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202212"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T16:25:00.873Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1968	a3b400ae-afdc-4d4a-8340-034eadd1e84d	ALLEGRO	\N	293	17477972814	5905806238716 	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:01.930469	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	1373.00	1373.00	PL	ONLINE	f	{"id": "741a7c31-9ed9-11f0-b465-492415e4339b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17477972814", "name": "Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR", "external": {"id": "5905806238716 "}, "productSet": null}, "price": {"amount": "1373.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T15:18:19.500Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1373.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1586	b84f4552-5f5b-4255-8164-e7036a7b893b	SHOPER	\N	208	1000	5905806211375	\N	1	\N	PLN	\N	\N	5905806211375_1.jpg	2025-10-09 19:01:14.203914	Wieszak ścienny W100 na ubrania 100cm SONOMA	241.00	241.00	PL	ONLINE	f	{"id": "27034", "tax": "23%", "code": "5905806211375", "name": "Wieszak ścienny W100 na ubrania 100cm SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "241.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23167", "quantity": "1", "stock_id": "1370", "tax_value": "23", "product_id": "1000", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1969	a3b400ae-afdc-4d4a-8340-034eadd1e84d	ALLEGRO	\N	294	17478159653	5905806238679	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:01.930469	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	857.00	857.00	PL	ONLINE	f	{"id": "741a7c30-9ed9-11f0-b465-492415e4339b", "tax": null, "offer": {"id": "17478159653", "name": "Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR", "external": {"id": "5905806238679"}, "productSet": null}, "price": {"amount": "857.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T15:18:19.500Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "857.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1970	1ec324ea-bd73-43a5-8f11-17a1965cb99d	ALLEGRO	\N	263	15372387250	5905806217926	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:03.578276	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	737.00	737.00	PL	CASH_ON_DELIVERY	f	{"id": "a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T15:03:16.227Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1971	d715c391-fe1a-4afa-b0a2-7b17ba1deb55	ALLEGRO	\N	95	12266374192	5905806208986	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:05.049238	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	556.00	556.00	PL	ONLINE	f	{"id": "38c53190-9ed7-11f0-a7f2-a59be15353c3", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266374192", "name": "Szafka na buty Supra 30 słupek 30x36 D1N1 Biały", "external": {"id": "5905806208986"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T14:59:35.029Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1972	92dacabd-570d-4342-a83b-921a9ef78d0d	ALLEGRO	\N	295	11873257937	5905806208351	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:06.564881	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	434.00	434.00	PL	ONLINE	t	{"id": "10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11873257937", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Sonoma", "external": {"id": "5905806208351"}, "productSet": null}, "price": {"amount": "434.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T14:31:13.809Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "434.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1973	1f81869b-81b4-4f28-935c-a6362ed42c78	ALLEGRO	\N	25	10862951244	5905806209020	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:08.212558	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	471.00	471.00	PL	CASH_ON_DELIVERY	f	{"id": "d603c8c0-9eca-11f0-b1e3-b7ce882fc700", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "10862951244", "name": "Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma", "external": {"id": "5905806209020"}, "productSet": null}, "price": {"amount": "471.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T13:31:32.369Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "471.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
329	0fcf54da-3dc9-4879-bfb0-bbe7e75c05fb	ALLEGRO	\N	188	14384920401	5905806201840	\N	1	\N	PLN	\N	\N	5905806201840_1.jpg	2025-10-06 19:33:24.102967	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	326.00	326.00	PL	ONLINE	f	{"id": "90776680-a2e5-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14384920401", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN", "external": {"id": "5905806201840"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:52:40.641Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1974	59ce4d08-6cb3-4d16-baf3-928c4ac336da	ALLEGRO	\N	247	14384985982	5905806202236	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:09.705915	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	350.00	350.00	PL	ONLINE	f	{"id": "e55ad0a0-9ec7-11f0-a30a-89acbba18695", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T13:11:49.501Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1574	842fcdfd-b0a5-4d33-b407-02b618c0e6c7	SHOPER	\N	197	3713	5905806240306	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:00:46.54845	Komoda Bones 80x36D1N1 Wotan	758.00	758.00	PL	ONLINE	f	{"id": "27043", "tax": "23%", "code": "5905806240306", "name": "Komoda Bones 80x36D1N1 Wotan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "758.00", "option": "", "weight": "30", "loyalty": null, "unit_fp": "0", "order_id": "23173", "quantity": "1", "stock_id": "4111", "tax_value": "23", "product_id": "3713", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
31	2ef91208-577e-461d-8abc-14b328d29ec0	ALLEGRO	261aefe1-a223-11f0-bddc-ebae77b3e555	33	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	1	229.00	PLN	\N	\N	\N	2025-10-06 17:22:28.775281	Wieszak ścienny WP60 na ubrania 60cm Lancelot	229.00	229.00	\N	ONLINE	f	{"id": "261aefe1-a223-11f0-bddc-ebae77b3e555", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "12196322651", "name": "Wieszak ścienny WP60 na ubrania 60cm Lancelot", "external": {"id": "5905806203714"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:40:53.755Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
12	d69a47ab-eb94-47b6-a0a2-627d5debec6f	ALLEGRO	246b58f0-a2c4-11f0-8e98-fdfd51e10ba4	28	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	5905806200027_1.jpg	2025-10-06 17:22:23.014482	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	\N	ONLINE	f	{"id": "246b58f0-a2c4-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T14:54:35.621Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1579	a3253de2-eee8-433a-bfbf-a704f0e66fe6	SHOPER	\N	202	1314	5905806214581	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:01:08.794663	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	611.00	611.00	PL	ONLINE	f	{"id": "27048", "tax": "23%", "code": "5905806214581", "name": "Szafka na buty z szufladą Tres 100x36D1N1 SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "611.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23176", "quantity": "1", "stock_id": "1692", "tax_value": "23", "product_id": "1314", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1976	a1159c96-63ff-4366-adfc-c9a037d62fc8	ALLEGRO	\N	288	12487657175	5905204699614	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:12.745891	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1319.00	1319.00	PL	ONLINE	f	{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487657175", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699614"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T12:51:16.424Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1977	d8327f3d-663f-4cf7-93ca-c64ed590125a	ALLEGRO	\N	296	16271343737	5905806233476	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:14.234736	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	418.00	418.00	PL	ONLINE	f	{"id": "ab724b80-9ebc-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16271343737", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT", "external": {"id": "5905806233476"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T11:49:39.791Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1978	0738537b-0d9b-4e6a-a1f1-ed7ccd4b49c0	ALLEGRO	\N	254	16602434536	5905806234527	\N	2	\N	PLN	\N	\N	\N	2025-10-09 19:54:15.759767	Komoda Bini 50x30x82 D1N1 WOTAN	352.00	704.00	PL	ONLINE	f	{"id": "30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7", "tax": null, "offer": {"id": "16602434536", "name": "Komoda Bini 50x30x82 D1N1 WOTAN", "external": {"id": "5905806234527"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T10:59:10.592Z", "quantity": 2, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1979	8937f497-e247-4bd6-a175-39e8ee9d2c01	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:17.328672	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "400f1430-9eb3-11f0-908e-ff3baa2fe7b0", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T10:44:07.618Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1981	476e2d7b-6be5-4e49-bd2f-1ded6b8d15f4	ALLEGRO	\N	70	15112696299	5905806208580	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:20.3501	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	793.10	793.10	PL	CASH_ON_DELIVERY	f	{"id": "dc660db0-9eaa-11f0-8ace-e54796c9c1e2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696299", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "external": {"id": "5905806208580"}, "productSet": null}, "price": {"amount": "793.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T09:42:26.148Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "793.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1982	88270902-59d4-4755-9157-336770aa78ff	ALLEGRO	\N	7	14384927614	5905806202014	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:21.849266	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	326.00	326.00	PL	ONLINE	f	{"id": "81c1b530-9eaa-11f0-bc92-992b6815467a", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T09:40:50.129Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1984	18f7f8b7-fd9f-4ad3-9aba-2e7c3bb44421	ALLEGRO	\N	62	15048053205	5905806205435	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:24.712071	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	488.50	488.50	PL	ONLINE	f	{"id": "f19d39c0-9ea9-11f0-908e-ff3baa2fe7b0", "tax": null, "offer": {"id": "15048053205", "name": "Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny", "external": {"id": "5905806205435"}, "productSet": null}, "price": {"amount": "488.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T09:36:20.588Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "488.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "21.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1985	a9bb25a6-9b19-4977-8a23-e3f02fe09333	ALLEGRO	\N	297	15112614579	5905806208504	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:26.194085	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	780.00	780.00	PL	ONLINE	f	{"id": "778e3940-9ea4-11f0-8996-07b46275101a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112614579", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208504"}, "productSet": null}, "price": {"amount": "780.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T08:58:07.596Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "780.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1986	0c35e0f8-8855-4b8c-be94-a0015861b905	ALLEGRO	\N	70	15112696299	5905806208580	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:27.755999	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	793.10	793.10	PL	ONLINE	f	{"id": "29fbd340-9ea4-11f0-9dc3-f9a3debc1314", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696299", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "external": {"id": "5905806208580"}, "productSet": null}, "price": {"amount": "793.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T08:54:48.537Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "793.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1592	b317681f-e325-4590-9d5e-bda71e244434	SHOPER	\N	209	963	5905806208399	\N	1	\N	PLN	\N	\N	5905806208399_1.jpg	2025-10-09 19:01:49.623499	Szafka na buty z szufladą Tres 60x36 Czarny Biały	478.00	478.00	PL	ONLINE	f	{"id": "27046", "tax": "23%", "code": "5905806208399", "name": "Szafka na buty z szufladą Tres 60x36 Czarny Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "478.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23175", "quantity": "1", "stock_id": "1328", "tax_value": "23", "product_id": "963", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
7	c813b593-8256-4b64-96ac-f2e45526a6f7	ALLEGRO	a9904fc0-a217-11f0-83df-53954cf6c551	40	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	2025-10-06 17:22:30.099521	Komoda Bones 50x36D1N1 SONOMA	638.00	638.00	\N	ONLINE	f	{"id": "a9904fc0-a217-11f0-83df-53954cf6c551", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919784146", "name": "Komoda Bones 50x36D1N1 SONOMA", "external": {"id": "5905806228984"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T18:25:05.693Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1987	f41aafa7-4623-4afb-8c77-1e7208918ab7	ALLEGRO	\N	10	14387669377	5905806202250	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:29.272675	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	399.00	399.00	PL	ONLINE	t	{"id": "52209410-9ea3-11f0-bc92-992b6815467a", "tax": null, "offer": {"id": "14387669377", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202250"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T08:49:28.620Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
17	e5313940-bbfe-4bd1-8ef0-b82e3a14462e	ALLEGRO	95525590-a1bc-11f0-a6cc-b3145592fdde	56	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	1	434.00	PLN	\N	\N	\N	2025-10-06 17:22:37.344062	Szafka na buty z szufladą Tres 60x36 Biały	434.00	434.00	\N	ONLINE	f	{"id": "95525590-a1bc-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11750203551", "name": "Szafka na buty z szufladą Tres 60x36 Biały", "external": {"id": "5905806208344"}, "productSet": null}, "price": {"amount": "434.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T07:28:22.122Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "434.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1988	34f1d20b-b695-40a6-beee-812af0cd220e	ALLEGRO	\N	298	16760747405	5905806236156	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:30.841405	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	1045.00	1045.00	PL	ONLINE	f	{"id": "d41854a0-9e97-11f0-8996-07b46275101a", "tax": null, "offer": {"id": "16760747405", "name": "Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806236156"}, "productSet": null}, "price": {"amount": "1045.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T07:30:40.068Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1045.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1992	e6fba33d-7134-4c9b-9a07-a2d051243f31	ALLEGRO	\N	299	15193798429	5905806213133	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:37.061635	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	1704.10	1704.10	PL	ONLINE	f	{"id": "915b4e80-997c-11f0-b7ad-bf8cbe88f0cf", "tax": null, "offer": {"id": "15193798429", "name": "Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały", "external": {"id": "5905806213133"}, "productSet": null}, "price": {"amount": "1704.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-24T19:28:31.880Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1704.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "74.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1593	b317681f-e325-4590-9d5e-bda71e244434	SHOPER	\N	210	732	5905806202502	\N	1	\N	PLN	\N	\N	5905806202502_1.jpg	2025-10-09 19:01:49.623499	Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY	423.00	423.00	PL	ONLINE	f	{"id": "27047", "tax": "0%", "code": "5905806202502", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "423.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23175", "quantity": "1", "stock_id": "1061", "tax_value": "0", "product_id": "732", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1990	2c5366d1-fbe5-43d9-bcfb-d97cc6974045	ALLEGRO	\N	69	14387674355	5905806202380	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:34.02311	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	405.20	405.20	PL	ONLINE	t	{"id": "62172dc0-9e94-11f0-8fc5-3736e68905c7", "tax": null, "offer": {"id": "14387674355", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202380"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T07:03:04.957Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1582	75a92b08-4031-418c-a35b-b9b648ee603b	SHOPER	\N	205	890	5905806208429	\N	1	\N	PLN	\N	\N	5905806208429_1.jpg	2025-10-09 19:01:10.253988	Panel ścienny tapicerowany pan1x60x30	64.00	64.00	PL	ONLINE	f	{"id": "27045", "tax": "23%", "code": "5905806208429", "name": "Panel ścienny tapicerowany pan1x60x30", "type": "0", "unit": "szt.", "pkwiu": "", "price": "64.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23174", "quantity": "1", "stock_id": "1249", "tax_value": "23", "product_id": "890", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1991	264fe800-bffc-4404-a928-22113c790d8a	ALLEGRO	\N	82	14387674903	5905806202427	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:35.565175	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	423.00	423.00	PL	ONLINE	f	{"id": "405d98e0-9e30-11f0-b286-41f712537da1", "tax": null, "offer": {"id": "14387674903", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN", "external": {"id": "5905806202427"}, "productSet": null}, "price": {"amount": "423.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T19:05:15.199Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "423.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
11	f9339066-7dee-4c67-97c3-c019a3cd6baf	ALLEGRO	b5e56000-a2c9-11f0-abd8-f5344f24907b	14	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	1	1705.00	PLN	\N	\N	5905806213423_1.jpg	2025-10-06 17:22:22.805021	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	1705.00	1705.00	\N	ONLINE	f	{"id": "b5e56000-a2c9-11f0-abd8-f5344f24907b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15225572646", "name": "Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN", "external": {"id": "5905806213423"}, "productSet": null}, "price": {"amount": "1705.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T15:37:17.263Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1705.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1631	65751643-e666-4fe0-9e20-c0bf92bdd52e	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:30:12.531797	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "9b096e40-a53d-11f0-a008-2360f331b758", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T18:29:50.769Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1652	737eb7ac-48a8-492d-9e84-97c2efa8b9a6	ALLEGRO	\N	226	16602434150	5905806234510	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:41.337269	Komoda Bini 50x30x82 D1N1 SONOMA	352.00	352.00	PL	ONLINE	f	{"id": "8c283cd0-a4f7-11f0-a444-6d64b3cc877f", "tax": null, "offer": {"id": "16602434150", "name": "Komoda Bini 50x30x82 D1N1 SONOMA", "external": {"id": "5905806234510"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T10:07:46.307Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1653	14715677-f1b5-4b7e-a168-f7c12c8b2445	ALLEGRO	\N	227	15919776759	5905806228861	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:42.890879	Komoda Bones 60x36D1N1 SONOMA	671.00	671.00	PL	ONLINE	f	{"id": "24386810-a4f3-11f0-a588-b391296a673a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919776759", "name": "Komoda Bones 60x36D1N1 SONOMA", "external": {"id": "5905806228861"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:35:26.392Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
330	507cfd68-3932-42a4-adc4-cd9d4c152e02	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-06 19:33:24.565117	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	CASH_ON_DELIVERY	f	{"id": "7a2d07a0-a2e4-11f0-bee6-2fee815ffc9f", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:45:13.052Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1946	7dc90a23-fa48-4aad-8360-607f37295862	ALLEGRO	\N	61	14387670556	5905806202274	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:32.627536	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	399.00	399.00	PL	ONLINE	f	{"id": "1b8f9360-9f11-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14387670556", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT", "external": {"id": "5905806202274"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T21:54:51.083Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1950	26e543d1-c77c-4c1a-956a-94c950dd6794	ALLEGRO	\N	60	11873248609	5905806208252	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:38.65677	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	454.00	454.00	PL	ONLINE	f	{"id": "7ca46800-9ef9-11f0-a910-6fc8854d80a9", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11873248609", "name": "Szafka na buty z szufladą Tres 60x30 Dąb Sonoma", "external": {"id": "5905806208252"}, "productSet": null}, "price": {"amount": "454.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:20:46.543Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "454.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
5	dd3ba2e2-8844-4718-ab23-f6352685d107	ALLEGRO	2931ddc0-a22c-11f0-809f-f9f6de958f67	86	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	1	447.00	PLN	\N	\N	\N	2025-10-06 17:22:27.850836	Szafka na buty z szufladą Tres 50x36 Czarny	447.00	447.00	\N	ONLINE	f	{"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221331957", "name": "Szafka na buty z szufladą Tres 50x36 Czarny", "external": {"id": "5905806214109"}, "productSet": null}, "price": {"amount": "447.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T20:47:20.515Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "447.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1599	02f41866-d60f-4390-a7ed-ee8f0f225f4a	SHOPER	\N	212	1219	5905806213560	\N	1	\N	PLN	\N	\N	5905806213560_1.jpg	2025-10-09 19:01:55.104179	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	954.00	954.00	PL	ONLINE	f	{"id": "27040", "tax": "23%", "code": "5905806213560", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "954.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "1597", "tax_value": "23", "product_id": "1219", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
167	9e6986ba-a653-4c50-af11-9fb8d88c7ecd	SHOPER	\N	169	918	5905806205473	\N	1	\N	PLN	\N	\N	5905806205473_1.jpg	2025-10-06 18:33:05.894736	Szafka na buty VB100x36D S1 siedzisko schowek 100cm Artisan	546.00	546.00	PL	ONLINE	f	{"id": "27017", "tax": "0%", "code": "5905806205473", "name": "Szafka na buty VB100x36D S1 siedzisko schowek 100cm Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "546.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1277", "tax_value": "0", "product_id": "918", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
168	9e6986ba-a653-4c50-af11-9fb8d88c7ecd	SHOPER	\N	170	892	5905806208412	\N	3	\N	PLN	\N	\N	5905806208412_1.jpg	2025-10-06 18:33:05.894736	Panel ścienny tapicerowany 80x30	75.00	225.00	PL	ONLINE	f	{"id": "27018", "tax": "23%", "code": "5905806208412", "name": "Panel ścienny tapicerowany 80x30", "type": "0", "unit": "szt.", "pkwiu": "", "price": "75.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "3", "stock_id": "1251", "tax_value": "23", "product_id": "892", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1600	02f41866-d60f-4390-a7ed-ee8f0f225f4a	SHOPER	\N	213	1787	5905806208344	\N	1	\N	PLN	\N	\N	5905806208344_1.jpg	2025-10-09 19:01:55.104179	Szafka na buty z szufladą Tres 60x36 Biały	478.00	478.00	PL	ONLINE	f	{"id": "27041", "tax": "23%", "code": "5905806208344", "name": "Szafka na buty z szufladą Tres 60x36 Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "478.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "2185", "tax_value": "23", "product_id": "1787", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
177	41318b56-757a-4bd2-9a48-12ab04b35df3	SHOPER	\N	179	2806	5905806211016	\N	1	\N	PLN	\N	\N	\N	2025-10-06 18:33:08.83739	Wieszak ścienny W60 na ubrania 60cm WOTAN	193.00	193.00	PL	ONLINE	f	{"id": "27010", "tax": "23%", "code": "5905806211016", "name": "Wieszak ścienny W60 na ubrania 60cm WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "193.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "3204", "tax_value": "23", "product_id": "2806", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1638	e0d4113f-524d-4ac7-97b2-148f0a0bfc87	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:20.897766	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "200fb511-a537-11f0-b89d-d9b346103272", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:43:22.600Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1601	aec982b8-7efd-41b7-abce-7806eba6e059	SHOPER	\N	172	1064	5905204699560	\N	1	\N	PLN	\N	\N	5905204699560_1.jpg	2025-10-09 19:01:56.620361	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA	1283.00	1283.00	PL	CASH_ON_DELIVERY	f	{"id": "27038", "tax": "23%", "code": "5905204699560", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1283.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23170", "quantity": "1", "stock_id": "1434", "tax_value": "23", "product_id": "1064", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1602	392d1d77-2b6a-4a83-acc4-6b0703a228b1	SHOPER	\N	214	348	5905204699096	\N	1	\N	PLN	\N	\N	5905204699096_1.jpg	2025-10-09 19:01:57.873794	Garderoba 90x36cm V60 Supra30 4 Panele D1 SONOMA	1391.00	1391.00	PL	ONLINE	f	{"id": "27037", "tax": "23%", "code": "5905204699096", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1391.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23169", "quantity": "1", "stock_id": "677", "tax_value": "23", "product_id": "348", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1603	20e9c1cf-a1e5-44fc-832d-8fea54c59f5a	SHOPER	\N	215	3711	5905806240115	\N	1	\N	PLN	\N	\N	5905806240115_1.jpg	2025-10-09 19:01:59.153419	Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR	350.00	350.00	PL	ONLINE	f	{"id": "27030", "tax": "23%", "code": "5905806240115", "name": "Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR", "type": "0", "unit": "szt.", "pkwiu": "", "price": "350.00", "option": "", "weight": "18", "loyalty": null, "unit_fp": "0", "order_id": "23164", "quantity": "1", "stock_id": "4109", "tax_value": "23", "product_id": "3711", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1604	55afcebb-6ec5-4cd0-9f60-21739a40f4bd	SHOPER	\N	216	719	5905806202373	\N	1	\N	PLN	\N	\N	5905806202373_1.jpg	2025-10-09 19:02:00.450016	Szafka na buty VB80x30D S1 siedzisko 80cm Czarny	399.00	399.00	PL	ONLINE	f	{"id": "27029", "tax": "0%", "code": "5905806202373", "name": "Szafka na buty VB80x30D S1 siedzisko 80cm Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "399.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23163", "quantity": "1", "stock_id": "1048", "tax_value": "0", "product_id": "719", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
174	2246fa7a-7f3e-403c-a1d8-2680da01d327	SHOPER	\N	176	165	5905806208955	\N	1	\N	PLN	\N	\N	5905806208955_1.jpg	2025-10-06 18:33:08.207471	Szafka nocna NOX 40x36  2 szuflady schowek biały	352.00	352.00	PL	ONLINE	f	{"id": "27012", "tax": "23%", "code": "5905806208955", "name": "Szafka nocna NOX 40x36  2 szuflady schowek biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "352.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23149", "quantity": "1", "stock_id": "494", "tax_value": "23", "product_id": "165", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1955	17ba29e3-6330-4b0e-9c20-b26273fd15e4	ALLEGRO	\N	289	17358870548	5905806237849	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:43.314516	Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir	363.00	363.00	PL	ONLINE	f	{"id": "5062f300-9efa-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17358870548", "name": "Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir", "external": {"id": "5905806237849"}, "productSet": null}, "price": {"amount": "363.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:13:20.451Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "363.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1639	c921097a-e45f-4f6f-acfe-9c48c8f93aad	ALLEGRO	\N	218	16859415981	5905806210293	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:22.488416	Półka ścienna 50x18x20cm WOTAN	76.00	76.00	PL	ONLINE	f	{"id": "13758aa0-a537-11f0-9cb2-b90a5baab897", "tax": null, "offer": {"id": "16859415981", "name": "Półka ścienna 50x18x20cm WOTAN", "external": {"id": "5905806210293"}, "productSet": null}, "price": {"amount": "76.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:41:40.314Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "76.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1640	9499e014-c8c0-4cd4-887d-8c0fd4e1c85c	ALLEGRO	\N	219	15155167503	5905806208443	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:24.056133	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1391.00	1391.00	PL	ONLINE	f	{"id": "69bea6b0-a534-11f0-a008-2360f331b758", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155167503", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN", "external": {"id": "5905806208443"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:24:14.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1641	57872f54-2e91-4da0-bf52-de62492b0c97	ALLEGRO	\N	193	17395006524	5905806238310	\N	2	\N	PLN	\N	\N	\N	2025-10-09 19:31:25.632705	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	788.00	1576.00	PL	ONLINE	t	{"id": "84c5aba0-a527-11f0-a444-6d64b3cc877f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17395006524", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY", "external": {"id": "5905806238310"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T16:02:52.677Z", "quantity": 2, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
844	7b9eb330-afdc-4252-912b-679a31477216	ALLEGRO	\N	47	12258666208	5905806216974	\N	1	\N	PLN	\N	\N	\N	2025-10-06 20:18:34.063021	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1807.60	1807.60	PL	ONLINE	f	{"id": "24b42850-a2f1-11f0-8144-0ba8ff5b8d19", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258666208", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały", "external": {"id": "5905806216974"}, "productSet": null}, "price": {"amount": "1807.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T20:15:36.551Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1807.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "79.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
2004	8ae035a3-5115-4256-a0b8-5715ca440eaa	SHOPER	\N	300	2624	5905806231090	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:56:42.184496	Szafka na buty VB80x30D2N1 CZARNY	417.00	417.00	PL	ONLINE	f	{"id": "27054", "tax": "0%", "code": "5905806231090", "name": "Szafka na buty VB80x30D2N1 CZARNY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "417.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23180", "quantity": "1", "stock_id": "3022", "tax_value": "0", "product_id": "2624", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1642	ae54c34b-f630-4eb4-842e-5837c6920405	ALLEGRO	\N	70	15112696299	5905806208580	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:27.158566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	828.00	828.00	PL	CASH_ON_DELIVERY	f	{"id": "78e66230-a526-11f0-8895-094b8cada9e7", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696299", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "external": {"id": "5905806208580"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:47:41.783Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1598	02f41866-d60f-4390-a7ed-ee8f0f225f4a	SHOPER	\N	211	3496	5905806237825	\N	1	\N	PLN	\N	\N	5905806237825_1.jpg	2025-10-09 19:01:55.104179	Garderoba 60x36D1N1-4PAN szafka na buty wieszak panele Kaszmir	835.00	835.00	PL	ONLINE	f	{"id": "27039", "tax": "0%", "code": "5905806237825", "name": "Garderoba 60x36D1N1-4PAN szafka na buty wieszak panele Kaszmir", "type": "0", "unit": "szt.", "pkwiu": "", "price": "835.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "3894", "tax_value": "0", "product_id": "3496", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}	0
1643	bd1e1594-21d3-49c0-905d-eee147e801ce	ALLEGRO	\N	220	16271341145	5905806233391	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:28.746481	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	385.00	385.00	PL	CASH_ON_DELIVERY	f	{"id": "6a923310-a523-11f0-a204-f12f4b71e7fe", "tax": null, "offer": {"id": "16271341145", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN", "external": {"id": "5905806233391"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:22:17.049Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1644	cdba7d73-9557-4a98-bd7f-ee89a3d4f6d0	ALLEGRO	\N	221	12266508963	5905204699102	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:30.312269	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1332.40	1332.40	PL	ONLINE	f	{"id": "e9a4c980-a521-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508963", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot", "external": {"id": "5905204699102"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:14:38.004Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
9	9120b07e-b435-4487-8f36-3126c7a1ce37	ALLEGRO	8979ccc0-a2d5-11f0-9468-2bd22967b382	39	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	457.80	PLN	\N	\N	5905806208337_1.jpg	2025-10-06 17:22:21.615647	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	457.80	457.80	\N	ONLINE	f	{"id": "8979ccc0-a2d5-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221043126", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Wotan", "external": {"id": "5905806208337"}, "productSet": null}, "price": {"amount": "457.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:00:03.523Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "457.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "20.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1655	e7e53fe6-7cbd-4722-aae5-7ec4cee02504	ALLEGRO	\N	5	17887745924	5905806208597	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:45.892442	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	PL	ONLINE	f	{"id": "2ce52120-a4f2-11f0-9da2-81c6f7d897d8", "tax": null, "offer": {"id": "17887745924", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:29:07.525Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1656	d1e25eae-fee7-4d46-bf26-7c4c8436f698	ALLEGRO	\N	\N	17533930958	\N	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:47.431983	Szafka na buty Supra 30 słupek 30x36 Kaszmir	556.00	556.00	PL	ONLINE	f	{"id": "a96e3110-a4f1-11f0-a402-d9289fd02c21", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17533930958", "name": "Szafka na buty Supra 30 słupek 30x36 Kaszmir", "external": null, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:24:24.246Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1657	79c0d464-0d62-47be-9725-f3ace19ce5d2	ALLEGRO	\N	9	14384932618	5905806202205	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:48.890305	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	335.20	335.20	PL	ONLINE	f	{"id": "3ded5b70-a4ef-11f0-b9bf-2795de008363", "tax": null, "offer": {"id": "14384932618", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA", "external": {"id": "5905806202205"}, "productSet": null}, "price": {"amount": "335.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:06:39.369Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "335.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "14.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1658	c384aca6-9c8d-465a-8389-299dc746dbbe	ALLEGRO	\N	7	14384927614	5905806202014	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:50.398223	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	312.20	312.20	PL	ONLINE	f	{"id": "b8c50eb0-a4ea-11f0-b89d-d9b346103272", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "312.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T08:35:45.667Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "312.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "13.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1659	c8f6104b-cba6-4725-b1b3-0b134e90e9a3	ALLEGRO	\N	228	12224099030	5905204699249	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:51.879859	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	884.10	884.10	PL	ONLINE	f	{"id": "5cdbdb20-a4df-11f0-961e-6d069f850ff8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12224099030", "name": "Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699249"}, "productSet": null}, "price": {"amount": "884.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T07:13:40.284Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "884.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "38.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1660	6ce99d71-4f59-4081-9309-05d7dd53d81f	ALLEGRO	\N	61	14387670556	5905806202274	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:53.404281	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	399.00	399.00	PL	ONLINE	f	{"id": "6d47a3d0-a4db-11f0-a444-6d64b3cc877f", "tax": null, "offer": {"id": "14387670556", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT", "external": {"id": "5905806202274"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T06:45:21.126Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1960	8a0baf40-f7b4-42a8-bafc-858168f8f921	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:50.886247	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "ebefa990-9eef-11f0-9efe-27a29450b6fd", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:57:52.997Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1963	5a05c42a-1875-4fbb-bc7d-cc7850fc6ad0	ALLEGRO	\N	291	15258837181	5905806211023	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:54.029929	Wieszak ścienny W60 na ubrania 60cm LANCELOT	193.00	193.00	PL	ONLINE	f	{"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "15258837181", "name": "Wieszak ścienny W60 na ubrania 60cm LANCELOT", "external": {"id": "5905806211023"}, "productSet": null}, "price": {"amount": "193.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:51:37.691Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "BUNDLE"}], "originalPrice": {"amount": "193.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1965	2c5a2e12-5b01-48c2-a1a6-a225dc453352	ALLEGRO	\N	10	14387669377	5905806202250	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:53:57.197604	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	382.20	382.20	PL	ONLINE	f	{"id": "1fa29550-9eea-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "14387669377", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202250"}, "productSet": null}, "price": {"amount": "382.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:20:07.146Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "382.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "11.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1975	ae9d28e4-477b-4862-ac94-7e56c2de2684	ALLEGRO	\N	7	14384927614	5905806202014	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:11.240798	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	326.00	326.00	PL	ONLINE	f	{"id": "cf384fa0-9ec7-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T13:10:44.122Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1980	c733a614-76d6-4651-93d3-4d9e942325df	ALLEGRO	\N	62	15048053205	5905806205435	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:18.821335	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	488.50	488.50	PL	ONLINE	f	{"id": "2e4f7c50-9eac-11f0-9468-2bd22967b382", "tax": null, "offer": {"id": "15048053205", "name": "Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny", "external": {"id": "5905806205435"}, "productSet": null}, "price": {"amount": "488.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T09:53:08.834Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "488.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "21.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1662	ff8a934c-9f8b-44fa-9f22-091c1862be12	ALLEGRO	\N	10	14387669377	5905806202250	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:56.545104	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	399.00	399.00	PL	ONLINE	f	{"id": "6af0df61-a4d7-11f0-8311-bd038e33f1de", "tax": null, "offer": {"id": "14387669377", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202250"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T06:23:10.962Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1663	bfe017fb-4066-4c2e-831a-7bca6bcdb9d3	ALLEGRO	\N	230	15225620833	5905806213386	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:58.07485	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY	1705.00	1705.00	PL	CASH_ON_DELIVERY	f	{"id": "a9d22d60-a4cd-11f0-a588-b391296a673a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15225620833", "name": "Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY", "external": {"id": "5905806213386"}, "productSet": null}, "price": {"amount": "1705.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T05:09:23.478Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1705.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1664	25b9f7f6-ba9f-4aa3-9dd8-7c201374654e	ALLEGRO	\N	231	14388158414	5905806202694	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:59.668882	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	643.00	643.00	PL	ONLINE	f	{"id": "e64932f0-a493-11f0-a471-6bb0586de370", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14388158414", "name": "Garderoba 50x36P2WPB szafka na buty wieszak Sonoma", "external": {"id": "5905806202694"}, "productSet": null}, "price": {"amount": "643.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T22:16:43.843Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "643.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1665	3977c810-5ed9-4ce0-9d15-8899d5b2daa5	ALLEGRO	\N	232	15321913673	5905806216943	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:01.342774	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	1750.10	1750.10	PL	ONLINE	f	{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15321913673", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan", "external": {"id": "5905806216943"}, "productSet": null}, "price": {"amount": "1750.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T20:37:25.568Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1750.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "76.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1666	6486c884-e696-47a7-8233-f3c48ba6a051	ALLEGRO	\N	233	17358967427	5905806237825	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:02.920419	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	835.00	835.00	PL	ONLINE	f	{"id": "04305191-a480-11f0-bfb1-c5232bd647f2", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "17358967427", "name": "Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir", "external": {"id": "5905806237825"}, "productSet": null}, "price": {"amount": "835.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T19:51:26.263Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "835.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1667	9d420082-e0fb-42ec-844d-f41f4ba4dcfc	ALLEGRO	\N	19	12266508168	5905204699089	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:04.466551	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	PL	ONLINE	f	{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T19:49:06.484Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1668	a2706de3-bbda-4843-8783-2fade86e1de5	ALLEGRO	\N	9	14384932618	5905806202205	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:06.189943	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	335.20	335.20	PL	ONLINE	f	{"id": "88f62210-a47b-11f0-a471-6bb0586de370", "tax": null, "offer": {"id": "14384932618", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA", "external": {"id": "5905806202205"}, "productSet": null}, "price": {"amount": "335.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T19:22:42.849Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "335.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "14.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1669	5ad5a2a0-1a94-40a8-90a3-26fdd8f42f6c	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:07.69505	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "a867c890-a478-11f0-8895-094b8cada9e7", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T18:58:48.438Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1670	5913d0e7-dfeb-4da8-a6b2-4708d9aae013	ALLEGRO	\N	26	14705411728	5905806203790	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:09.310286	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	196.30	196.30	PL	ONLINE	f	{"id": "05a100f2-a472-11f0-a685-3b2ebe8a80a1", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14705411728", "name": "Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma", "external": {"id": "5905806203790"}, "productSet": null}, "price": {"amount": "196.30", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T18:32:35.520Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "196.30", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "8.70", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1671	5913d0e7-dfeb-4da8-a6b2-4708d9aae013	ALLEGRO	\N	2	11957206330	5905806208467	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:09.310286	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	747.10	747.10	PL	ONLINE	f	{"id": "05a100f1-a472-11f0-a685-3b2ebe8a80a1", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11957206330", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma", "external": {"id": "5905806208467"}, "productSet": null}, "price": {"amount": "747.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T18:32:35.520Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "747.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "32.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1672	a69a2902-a128-495c-94e1-1bb397a4f874	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:10.962298	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "d74d5850-a473-11f0-b12e-53a023ce25d9", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T18:24:49.282Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1673	cdf19d45-1965-41f9-b698-54198d9836cb	ALLEGRO	\N	9	14384932618	5905806202205	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:12.487298	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	335.20	335.20	PL	ONLINE	f	{"id": "a89e4d70-a46e-11f0-b989-75c7faccd1ca", "tax": null, "offer": {"id": "14384932618", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA", "external": {"id": "5905806202205"}, "productSet": null}, "price": {"amount": "335.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T17:47:55.573Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "335.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "14.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1674	3aa589d7-de4f-4aac-9ee6-c190e5a30bc1	ALLEGRO	\N	67	10862736322	5905806202007	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:14.067446	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	326.00	326.00	PL	ONLINE	f	{"id": "958e7590-a46c-11f0-a685-3b2ebe8a80a1", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862736322", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma", "external": {"id": "5905806202007"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T17:32:03.941Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1983	738e6032-eed7-49e1-bc7e-4b17403ae641	ALLEGRO	\N	70	15112696299	5905806208580	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:23.370989	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	793.10	793.10	PL	ONLINE	f	{"id": "5f2514e0-9eaa-11f0-817a-fb3753e68c2d", "tax": null, "offer": {"id": "15112696299", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "external": {"id": "5905806208580"}, "productSet": null}, "price": {"amount": "793.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T09:38:50.323Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "793.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1989	a0c5aaad-ebbf-4c79-a412-3f6cd216050a	ALLEGRO	\N	62	15048053205	5905806205435	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:54:32.475022	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	488.50	488.50	PL	ONLINE	f	{"id": "f62ea360-9e96-11f0-817a-fb3753e68c2d", "tax": null, "offer": {"id": "15048053205", "name": "Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny", "external": {"id": "5905806205435"}, "productSet": null}, "price": {"amount": "488.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T07:21:45.607Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "488.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "21.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
2041	eda43e61-4b1b-429b-b79f-65e7f6c16a6a	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:27.268525	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	CASH_ON_DELIVERY	f	{"id": "dfbeaf30-9e55-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T23:33:52.755Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2042	8be6b806-096c-4430-b6dd-3754aa0e7ab7	ALLEGRO	\N	\N	17736467450	\N	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:28.719657	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	326.00	326.00	PL	CASH_ON_DELIVERY	f	{"id": "93c67330-9e3f-11f0-9325-2757f66ce3c4", "tax": null, "offer": {"id": "17736467450", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR", "external": null, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T20:54:23.601Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1630	3d84e298-8659-4012-bc61-23897c860fb1	ALLEGRO	\N	217	13855292522	5905806200010	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:30:10.915407	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	314.00	314.00	PL	ONLINE	f	{"id": "27407420-a544-11f0-bb74-8b6fbb6f100b", "tax": null, "offer": {"id": "13855292522", "name": "Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT", "external": {"id": "5905806200010"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T19:15:34.727Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1632	3f4b3619-e27d-45d8-b50e-2a0ca1baaf86	ALLEGRO	\N	80	14387675243	5905806202441	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:30:14.04976	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	405.20	405.20	PL	ONLINE	f	{"id": "b53a64e0-a538-11f0-9da2-81c6f7d897d8", "tax": null, "offer": {"id": "14387675243", "name": "Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny", "external": {"id": "5905806202441"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:54:22.175Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1675	9b852911-8183-4d15-8431-401afba54631	ALLEGRO	\N	69	14387674355	5905806202380	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:15.624389	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	405.20	405.20	PL	ONLINE	f	{"id": "274f87d0-a45e-11f0-9583-47424f8c2810", "tax": null, "offer": {"id": "14387674355", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202380"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T15:50:37.355Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1676	7b86a49b-c9bf-42f3-80a4-d09a8705d67c	ALLEGRO	\N	234	16271340785	5905806233292	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:32:17.226597	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	368.80	368.80	PL	ONLINE	f	{"id": "5da1b6e0-a455-11f0-b989-75c7faccd1ca", "tax": null, "offer": {"id": "16271340785", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806233292"}, "productSet": null}, "price": {"amount": "368.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:45:05.974Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "368.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "16.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
2043	0110a4fd-c122-4c82-b46d-f19dd1683bf6	ALLEGRO	\N	301	15919629053	5905806228588	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:30.118678	Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA	1540.00	1540.00	PL	ONLINE	f	{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919629053", "name": "Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA", "external": {"id": "5905806228588"}, "productSet": null}, "price": {"amount": "1540.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T20:01:00.302Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1540.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2044	30dbf027-8f9e-4d2f-9b31-1daa10060932	ALLEGRO	\N	19	12266508168	5905204699089	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:31.593772	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	PL	ONLINE	f	{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T19:40:42.223Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1647	f41fe909-e4d4-438e-b6ca-e08a20998b95	ALLEGRO	\N	19	12266508168	5905204699089	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:35.004326	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	PL	CASH_ON_DELIVERY	f	{"id": "b3ee0730-a516-11f0-a5d7-371746f07634", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T13:51:11.209Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1648	b31849dc-801b-4b25-9164-df11a6f2410d	ALLEGRO	\N	223	16698543601	5905806237023	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:36.551395	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	1430.10	1430.10	PL	ONLINE	f	{"id": "891abea0-a50b-11f0-9b0c-e511fc7361fa", "tax": null, "offer": {"id": "16698543601", "name": "Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan", "external": {"id": "5905806237023"}, "productSet": null}, "price": {"amount": "1430.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T12:31:32.872Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1430.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "62.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1649	c78a3f58-8c26-4bfb-8274-ce55c6673c93	ALLEGRO	\N	224	14387672711	5905806202335	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:38.174424	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	399.00	399.00	PL	ONLINE	f	{"id": "2688a332-a4ff-11f0-b9bf-2795de008363", "tax": null, "offer": {"id": "14387672711", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan", "external": {"id": "5905806202335"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T11:07:01.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1650	c78a3f58-8c26-4bfb-8274-ce55c6673c93	ALLEGRO	\N	225	16901480273	5905806234022	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:38.174424	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	229.00	229.00	PL	ONLINE	f	{"id": "2688a331-a4ff-11f0-b9bf-2795de008363", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "16901480273", "name": "Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN", "external": {"id": "5905806234022"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T11:07:01.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1651	8594e5a6-7728-43e1-b9d4-457936823c56	ALLEGRO	\N	\N	17731209472	\N	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:39.81364	Szafka na buty VB60x30D1N2 BIAŁY	370.00	370.00	PL	ONLINE	f	{"id": "ce875730-a4fe-11f0-961e-6d069f850ff8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17731209472", "name": "Szafka na buty VB60x30D1N2 BIAŁY", "external": null, "productSet": null}, "price": {"amount": "370.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T10:58:14.473Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "370.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1661	bb57a6f1-5bb9-4ccd-8c00-f7a99662c8cf	ALLEGRO	\N	229	15876902214	5905806215175	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:31:54.962898	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	352.00	352.00	PL	ONLINE	f	{"id": "55056c90-a4da-11f0-9b0c-e511fc7361fa", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15876902214", "name": "Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY", "external": {"id": "5905806215175"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T06:38:48.216Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1720	6500ac7a-b6f2-4770-a305-aede508e800a	ALLEGRO	\N	235	10862932479	5905806209532	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:33:55.704691	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	532.60	532.60	PL	ONLINE	f	{"id": "cac93f00-a454-11f0-a471-6bb0586de370", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "10862932479", "name": "Szafka komoda na buty 80x30 D2N1 Altus BIAŁY", "external": {"id": "5905806209532"}, "productSet": null}, "price": {"amount": "532.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:41:38.668Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "532.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "23.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1721	e334454d-1b96-44de-83f2-6afbdb9fa9dc	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:33:57.235008	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	312.20	312.20	PL	ONLINE	f	{"id": "71c4a610-a44f-11f0-a4f0-7ba876f09f6f", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "312.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:03:10.064Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "312.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "9.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1740	da9171f9-2660-4afc-ab08-21b0fac28516	ALLEGRO	\N	11	16602434928	5905806234558	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:24.201807	Komoda Bini 50x36 D1N1 CZARNY	385.00	385.00	PL	CASH_ON_DELIVERY	f	{"id": "7ecddf40-a3fd-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "16602434928", "name": "Komoda Bini 50x36 D1N1 CZARNY", "external": {"id": "5905806234558"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T04:16:19.747Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1722	a14601b7-76e0-4db3-8eef-d1e4ab03fe70	ALLEGRO	\N	236	15178440255	5905806210118	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:33:58.780544	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	636.00	636.00	PL	ONLINE	f	{"id": "3b62aea0-a44f-11f0-88a6-1f93f938b7b3", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15178440255", "name": "Szafka komoda na buty 80x36 D2N2 Altus ARTISAN", "external": {"id": "5905806210118"}, "productSet": null}, "price": {"amount": "636.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:01:34.608Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "636.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1723	08b0dd40-225e-4e93-ba09-53bd84d5ec53	ALLEGRO	\N	15	14384932878	5905806202212	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:00.371438	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	350.00	350.00	PL	ONLINE	f	{"id": "25b23f70-a446-11f0-9322-81ad33e97c6b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384932878", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202212"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T12:56:30.140Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1724	4686c52a-6899-4edb-99be-cd64465dcda3	ALLEGRO	\N	237	14384922015	5905806201871	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:01.943813	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "8ed915f0-a43c-11f0-96d3-f7121b08a32c", "tax": null, "offer": {"id": "14384922015", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806201871"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T11:47:36.900Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1725	939dc1d9-3826-493d-bc58-7ee945cc93f9	ALLEGRO	\N	238	14655550516	5905806205015	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:03.538387	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	1283.00	1283.00	PL	ONLINE	f	{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14655550516", "name": "Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan", "external": {"id": "5905806205015"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:40:58.713Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1726	68b73ce8-bd47-46fb-8d78-55a59feb0e71	ALLEGRO	\N	239	15919730348	5905806228830	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:05.149018	Komoda Bones 60x30D1N1 SONOMA	638.00	638.00	PL	ONLINE	f	{"id": "bce19ae0-a431-11f0-af7e-5f793825db67", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919730348", "name": "Komoda Bones 60x30D1N1 SONOMA", "external": {"id": "5905806228830"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:30:50.598Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1727	7dd2619f-8b24-46e9-a81b-a461e4f2600e	ALLEGRO	\N	240	16521833793	5905806227130	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:06.759391	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	1319.00	1319.00	PL	ONLINE	f	{"id": "36702f81-a431-11f0-8f13-933da22fca3d", "tax": null, "offer": {"id": "16521833793", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY", "external": {"id": "5905806227130"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:29:53.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1728	7dd2619f-8b24-46e9-a81b-a461e4f2600e	ALLEGRO	\N	241	15408455867	5905806218688	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:06.759391	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	1015.00	1015.00	PL	ONLINE	f	{"id": "36702f80-a431-11f0-8f13-933da22fca3d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15408455867", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY", "external": {"id": "5905806218688"}, "productSet": null}, "price": {"amount": "1015.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:29:53.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1015.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1729	8e6e0467-d444-44d9-918a-26a2c15f70b9	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:08.410006	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	312.20	312.20	PL	CASH_ON_DELIVERY	f	{"id": "97a6a5d0-a42d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "312.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:01:04.382Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "312.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "9.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1730	c012ebe3-025b-4c87-af64-1c4d8221bca2	ALLEGRO	\N	7	14384927614	5905806202014	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:09.987683	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	312.20	312.20	PL	ONLINE	f	{"id": "82f7f590-a42c-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "312.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T09:54:09.273Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "312.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "13.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1731	277c9f6f-fc18-491a-b298-e22fc1affe22	ALLEGRO	\N	9	14384932618	5905806202205	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:11.5134	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	335.20	335.20	PL	ONLINE	f	{"id": "a9221120-a426-11f0-96d3-f7121b08a32c", "tax": null, "offer": {"id": "14384932618", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA", "external": {"id": "5905806202205"}, "productSet": null}, "price": {"amount": "335.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T09:12:34.231Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "335.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "14.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1732	8378ead4-0ea8-4cbc-ac63-a97fb4052bb6	ALLEGRO	\N	67	10862736322	5905806202007	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:13.047893	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	326.00	326.00	PL	ONLINE	f	{"id": "c322ac20-a425-11f0-b1f1-69448e84eb62", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862736322", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma", "external": {"id": "5905806202007"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T09:07:20.687Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1733	faec503a-0391-43fe-8d1d-48061778ab34	ALLEGRO	\N	89	17358916449	5905806237795	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:14.580463	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1343.00	1343.00	PL	CASH_ON_DELIVERY	f	{"id": "c35646a0-a422-11f0-af7e-5f793825db67", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17358916449", "name": "Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir", "external": {"id": "5905806237795"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T08:46:35.018Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1734	9f3a3402-2296-4612-a79e-a2e6969dd99b	ALLEGRO	\N	242	15321911032	5905806216912	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:16.065253	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	1750.10	1750.10	PL	ONLINE	f	{"id": "ae640510-a41e-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15321911032", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan", "external": {"id": "5905806216912"}, "productSet": null}, "price": {"amount": "1750.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T08:16:19.689Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1750.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "76.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1735	9edd3d68-8c2d-4d6e-9969-248095788769	ALLEGRO	\N	5	17453875719	5905806208597	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:17.602684	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	PL	CASH_ON_DELIVERY	f	{"id": "76a77190-a41c-11f0-a40a-ffbafd460211", "tax": null, "offer": {"id": "17453875719", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T08:02:09.205Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1736	55af0ddf-e255-4e69-b26e-497efb356f28	ALLEGRO	\N	243	16319658329	5905806234398	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:19.098291	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	674.30	674.30	PL	ONLINE	f	{"id": "2b052750-a412-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "16319658329", "name": "Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806234398"}, "productSet": null}, "price": {"amount": "674.30", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T06:44:05.207Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "674.30", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "29.70", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1737	f84af56f-3a53-4d07-8884-0750e575ed34	ALLEGRO	\N	244	12258723368	5905806216981	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:20.621698	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1887.00	1887.00	PL	ONLINE	f	{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258723368", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma", "external": {"id": "5905806216981"}, "productSet": null}, "price": {"amount": "1887.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T06:26:35.802Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1887.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1738	089758f3-eb55-41c5-86a0-616e3b5ca9e0	ALLEGRO	\N	5	17453875719	5905806208597	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:22.713109	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	PL	ONLINE	f	{"id": "4b5cda51-a40a-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17453875719", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T05:49:16.316Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2046	4f0a49a2-4450-4d78-b6d5-ab767eb6d8af	ALLEGRO	\N	302	12266500390	5905204699133	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:34.529382	Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT	1343.00	1343.00	PL	ONLINE	f	{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266500390", "name": "Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT", "external": {"id": "5905204699133"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T18:39:01.681Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2047	3e9a64ad-295d-4471-bb19-f7da80caaae6	ALLEGRO	\N	234	16271340785	5905806233292	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:36.114412	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	385.00	385.00	PL	ONLINE	f	{"id": "9682fd20-9e29-11f0-a07b-27f19dcfd61a", "tax": null, "offer": {"id": "16271340785", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806233292"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T18:16:58.170Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1741	4a1e9597-39cf-4828-b478-632afd8b5e47	ALLEGRO	\N	61	14387670556	5905806202274	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:25.942869	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	399.00	399.00	PL	ONLINE	f	{"id": "3bbe63a0-a3d5-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14387670556", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT", "external": {"id": "5905806202274"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T23:28:22.759Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1742	72cbca9f-84f9-40c5-9507-99e822bb784c	ALLEGRO	\N	245	14910130346	5905806204049	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:27.397521	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	811.00	811.00	PL	CASH_ON_DELIVERY	t	{"id": "bd041570-a3cd-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14910130346", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806204049"}, "productSet": null}, "price": {"amount": "811.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T22:37:03.666Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "811.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1743	64d261cb-2093-4939-a598-460f85a08b66	ALLEGRO	\N	246	14910130495	5905806204056	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:28.864582	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	811.00	811.00	PL	CASH_ON_DELIVERY	t	{"id": "3cc896c0-a3cc-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14910130495", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY", "external": {"id": "5905806204056"}, "productSet": null}, "price": {"amount": "811.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T22:27:10.760Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "811.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1744	1fabcee2-dd4b-4ee0-ab19-3d8dd4b17c8e	ALLEGRO	\N	247	14384985982	5905806202236	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:30.326811	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	350.00	350.00	PL	ONLINE	f	{"id": "bb0feac0-a3c6-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:44:05.528Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1745	930ee721-f7ee-4818-9260-995693521fa4	ALLEGRO	\N	\N	17532641274	\N	\N	4	\N	PLN	\N	\N	\N	2025-10-09 19:34:31.926296	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3.00	12.00	PL	ONLINE	f	{"id": "876a7b41-a3c6-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "17532641274", "name": "Nóżka 2cmN1 z tworzywa sztucznego CZARNY", "external": null, "productSet": null}, "price": {"amount": "3.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:42:42.773Z", "quantity": 4, "vouchers": [], "discounts": null, "originalPrice": {"amount": "3.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1746	930ee721-f7ee-4818-9260-995693521fa4	ALLEGRO	\N	248	16859419202	5905806210439	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:31.926296	Półka ścienna 60x18x20cm WOTAN	87.00	87.00	PL	ONLINE	f	{"id": "876a7b40-a3c6-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16859419202", "name": "Półka ścienna 60x18x20cm WOTAN", "external": {"id": "5905806210439"}, "productSet": null}, "price": {"amount": "87.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:42:42.773Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "87.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1748	979e0c41-5589-441e-84fb-3bff797ebcdc	ALLEGRO	\N	247	14384985982	5905806202236	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:33.615877	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	350.00	350.00	PL	ONLINE	f	{"id": "3f028560-a3c5-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:34:41.347Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	1
1747	979e0c41-5589-441e-84fb-3bff797ebcdc	ALLEGRO	\N	248	16859419202	5905806210439	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:33.615877	Półka ścienna 60x18x20cm WOTAN	87.00	87.00	PL	ONLINE	f	{"id": "3f028561-a3c5-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16859419202", "name": "Półka ścienna 60x18x20cm WOTAN", "external": {"id": "5905806210439"}, "productSet": null}, "price": {"amount": "87.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:34:41.347Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "87.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	1
1758	a44bcbf5-0912-4c1c-9025-e38a4211bdea	ALLEGRO	\N	253	12476571569	5905806213560	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:46.040975	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	788.00	788.00	PL	ONLINE	f	{"id": "47073e70-a39f-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571569", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905806213560"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:04:37.686Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2048	e3e857cd-2313-4d0d-9fa0-967e7b19230f	ALLEGRO	\N	279	10945431249	5905806208191	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:37.64072	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	332.00	332.00	PL	CASH_ON_DELIVERY	f	{"id": "d25ac590-9e28-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10945431249", "name": "Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały", "external": {"id": "5905806208191"}, "productSet": null}, "price": {"amount": "332.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T18:11:20.124Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "332.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1749	4da4607e-ba11-4133-aea2-21534897a8bd	ALLEGRO	\N	249	14383316918	5905806201758	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:35.391646	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	1263.50	1263.50	PL	ONLINE	f	{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14383316918", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały", "external": {"id": "5905806201758"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:11:14.096Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1750	ff52fd1b-a499-4188-bf55-bd04051c1531	ALLEGRO	\N	78	14387674657	5905806202403	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:36.885052	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	405.20	405.20	PL	ONLINE	f	{"id": "0a12b630-a3b2-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "14387674657", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN", "external": {"id": "5905806202403"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T19:17:32.893Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1751	15aff086-0b54-4e26-a967-0a439919cc7e	ALLEGRO	\N	243	16319658329	5905806234398	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:38.402514	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	674.30	674.30	PL	CASH_ON_DELIVERY	f	{"id": "8f862f00-a3b1-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "16319658329", "name": "Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806234398"}, "productSet": null}, "price": {"amount": "674.30", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T19:16:10.466Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "674.30", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "29.70", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1752	61b462b5-777a-4fd2-b2b3-b4cac2b3c6d9	ALLEGRO	\N	250	15319542575	5905806213973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:39.906358	Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN	1645.00	1645.00	PL	ONLINE	f	{"id": "a1cdbc90-a3ad-11f0-a3bc-ef5c37833579", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15319542575", "name": "Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN", "external": {"id": "5905806213973"}, "productSet": null}, "price": {"amount": "1645.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:47:31.831Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1645.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1753	61b462b5-777a-4fd2-b2b3-b4cac2b3c6d9	ALLEGRO	\N	\N	17532641274	\N	\N	8	\N	PLN	\N	\N	\N	2025-10-09 19:34:39.906358	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3.00	24.00	PL	ONLINE	f	{"id": "a1cdbc91-a3ad-11f0-a3bc-ef5c37833579", "tax": null, "offer": {"id": "17532641274", "name": "Nóżka 2cmN1 z tworzywa sztucznego CZARNY", "external": null, "productSet": null}, "price": {"amount": "3.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:47:31.831Z", "quantity": 8, "vouchers": [], "discounts": null, "originalPrice": {"amount": "3.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1754	f1ae8924-edc3-4677-b851-fed946303a73	ALLEGRO	\N	251	16625971969	5905806222524	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:41.444673	Siedzisko tapicerowane 80x29cm do szafki 80x30	75.00	75.00	PL	ONLINE	f	{"id": "7c6a6280-a3aa-11f0-a15e-754093089519", "tax": null, "offer": {"id": "16625971969", "name": "Siedzisko tapicerowane 80x29cm do szafki 80x30", "external": {"id": "5905806222524"}, "productSet": null}, "price": {"amount": "75.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:33:02.465Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "75.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1755	3312a140-95bf-4e07-9fa2-0bb214a5eccd	ALLEGRO	\N	249	14383316918	5905806201758	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:42.942694	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	1263.50	1263.50	PL	ONLINE	f	{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f", "tax": null, "offer": {"id": "14383316918", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały", "external": {"id": "5905806201758"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:22:26.692Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1756	2b934da5-6991-4b78-841d-bbac70590883	ALLEGRO	\N	252	17636751422	5905806205121	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:44.442189	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	1263.50	1263.50	PL	ONLINE	f	{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17636751422", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA", "external": {"id": "5905806205121"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:13:53.667Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1757	a44bcbf5-0912-4c1c-9025-e38a4211bdea	ALLEGRO	\N	19	12266508168	5905204699089	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:46.040975	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	PL	ONLINE	f	{"id": "47073e71-a39f-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:04:37.686Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
118	b53a599f-a822-49d8-91f3-3ac1c38a1627	ALLEGRO	a1584f30-a120-11f0-9d66-3d00eb1ccfed	75	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	1	523.00	PLN	\N	\N	5905806206678_1.jpg	2025-10-06 17:22:42.252564	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	\N	\N	\N	\N	f	\N	0
1759	e907d5d3-e4a2-4925-bf27-6ef84db2c3de	ALLEGRO	\N	254	16602434536	5905806234527	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:47.681114	Komoda Bini 50x30x82 D1N1 WOTAN	352.00	352.00	PL	ONLINE	f	{"id": "14d905a1-a39f-11f0-b56d-0ba559d87e46", "tax": null, "offer": {"id": "16602434536", "name": "Komoda Bini 50x30x82 D1N1 WOTAN", "external": {"id": "5905806234527"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:01:47.983Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1760	e907d5d3-e4a2-4925-bf27-6ef84db2c3de	ALLEGRO	\N	23	13854421583	5905204699973	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:47.681114	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	PL	ONLINE	f	{"id": "14d905a0-a39f-11f0-b56d-0ba559d87e46", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:01:47.983Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1761	9e823194-d779-4ecc-9dd2-1d11a6cd0d92	ALLEGRO	\N	255	12196226645	5905806203615	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:49.240924	Wieszak ścienny WP80 na ubrania 80cm Lancelot	278.00	278.00	PL	ONLINE	f	{"id": "5b983f70-a39e-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "12196226645", "name": "Wieszak ścienny WP80 na ubrania 80cm Lancelot", "external": {"id": "5905806203615"}, "productSet": null}, "price": {"amount": "278.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:55:30.772Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "278.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1762	45559852-853f-4030-ba80-897714ad8659	ALLEGRO	\N	256	15919728876	5905806228793	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:50.800284	Komoda Bones 60x36D1N1 ARTISAN	671.00	671.00	PL	ONLINE	f	{"id": "f1c1d391-a39d-11f0-8d43-e5c6c6646cd8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919728876", "name": "Komoda Bones 60x36D1N1 ARTISAN", "external": {"id": "5905806228793"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:53:45.966Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1763	45559852-853f-4030-ba80-897714ad8659	ALLEGRO	\N	247	14384985982	5905806202236	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:50.800284	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	350.00	350.00	PL	ONLINE	f	{"id": "f1c1d390-a39d-11f0-8d43-e5c6c6646cd8", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:53:45.966Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1764	b7606d98-0f1f-49e2-9f6e-e84d71469d62	ALLEGRO	\N	256	15919728876	5905806228793	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:52.430989	Komoda Bones 60x36D1N1 ARTISAN	671.00	671.00	PL	ONLINE	f	{"id": "1e0396b1-a39d-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "15919728876", "name": "Komoda Bones 60x36D1N1 ARTISAN", "external": {"id": "5905806228793"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:48:42.269Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1765	b7606d98-0f1f-49e2-9f6e-e84d71469d62	ALLEGRO	\N	247	14384985982	5905806202236	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:52.430989	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	350.00	350.00	PL	ONLINE	f	{"id": "1e0396b0-a39d-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:48:42.269Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1766	7fee3ba3-c85b-40ad-94a5-c782a1f10313	ALLEGRO	\N	95	12266374192	5905806208986	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:53.79647	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	556.00	556.00	PL	CASH_ON_DELIVERY	f	{"id": "0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266374192", "name": "Szafka na buty Supra 30 słupek 30x36 D1N1 Biały", "external": {"id": "5905806208986"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:24:36.838Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1767	3d874707-cd5a-4d39-9a35-dd1c88b8d3ca	ALLEGRO	\N	257	15319529269	5905806213812	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:55.214301	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	1557.00	1557.00	PL	ONLINE	f	{"id": "d2701550-a399-11f0-a3bc-ef5c37833579", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15319529269", "name": "Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN", "external": {"id": "5905806213812"}, "productSet": null}, "price": {"amount": "1557.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:23:05.385Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1557.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1768	5746a4ea-de6b-4446-8ee4-11b0f867ab0a	ALLEGRO	\N	258	15221332021	5905806214130	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:56.692218	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	447.00	447.00	PL	ONLINE	f	{"id": "aa3a44e0-a397-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221332021", "name": "Szafka na buty z szufladą Tres 50x36 Dąb Wotan", "external": {"id": "5905806214130"}, "productSet": null}, "price": {"amount": "447.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:08:03.409Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "447.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1769	b3c8c79d-6d91-4dbf-b0ea-0cd11290c245	ALLEGRO	\N	259	16276325492	5905806233957	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:58.255169	Komoda Bini 60x36D1N1 BIAŁY	462.00	462.00	PL	ONLINE	f	{"id": "816e3d00-a397-11f0-9288-ef897151e2e1", "tax": null, "offer": {"id": "16276325492", "name": "Komoda Bini 60x36D1N1 BIAŁY", "external": {"id": "5905806233957"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:07:07.415Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1770	05047a1f-d7c6-472d-bd1d-5485b886a3c3	ALLEGRO	\N	260	16415944014	5905806231885	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:34:59.752861	Szafka na buty VB100x30D2N1 ARTISAN	556.00	556.00	PL	ONLINE	f	{"id": "8a81ae80-a393-11f0-bc71-87ddccc94446", "tax": null, "offer": {"id": "16415944014", "name": "Szafka na buty VB100x30D2N1 ARTISAN", "external": {"id": "5905806231885"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T15:43:37.315Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1771	59230730-50c1-423b-9c04-eac4d8ba8628	ALLEGRO	\N	67	10862736322	5905806202007	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:01.279466	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	326.00	326.00	PL	ONLINE	f	{"id": "e7b2d3c0-a390-11f0-8d43-e5c6c6646cd8", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862736322", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma", "external": {"id": "5905806202007"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T15:22:03.184Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1772	f5aa3ed7-d781-4739-956a-37210076e5de	ALLEGRO	\N	243	16319658329	5905806234398	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:02.756008	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	674.30	674.30	PL	ONLINE	f	{"id": "eebcaf10-a38b-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16319658329", "name": "Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806234398"}, "productSet": null}, "price": {"amount": "674.30", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T14:43:49.924Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "674.30", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "29.70", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1773	d58956c5-232e-429f-aa45-7461eba81da4	ALLEGRO	\N	226	16602434150	5905806234510	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:04.227976	Komoda Bini 50x30x82 D1N1 SONOMA	352.00	352.00	PL	ONLINE	f	{"id": "e16d1eb0-a388-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "16602434150", "name": "Komoda Bini 50x30x82 D1N1 SONOMA", "external": {"id": "5905806234510"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T14:21:53.970Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1774	621e0bd5-643c-421a-aa43-3bffeb0dd929	ALLEGRO	\N	10	14387669377	5905806202250	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:05.702991	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	399.00	399.00	PL	CASH_ON_DELIVERY	f	{"id": "5233d220-a37e-11f0-8d43-e5c6c6646cd8", "tax": null, "offer": {"id": "14387669377", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202250"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T13:12:18.555Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1775	991f5d11-f5f1-4edd-922e-0f99ce36bca0	ALLEGRO	\N	94	14384932329	5905806202199	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:07.21129	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	350.00	350.00	PL	ONLINE	f	{"id": "8aed7630-a373-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14384932329", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806202199"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T12:00:24.414Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	1
1776	390ebe63-aa22-4bd0-b11a-a5a843679fec	ALLEGRO	\N	59	15176238729	5905806209662	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:08.90527	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	592.00	592.00	PL	ONLINE	f	{"id": "d16885a0-a373-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176238729", "name": "Szafka komoda na buty 80x36 D2N1 Altus WOTAN", "external": {"id": "5905806209662"}, "productSet": null}, "price": {"amount": "592.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T11:50:58.042Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "592.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1777	80934770-3166-4eee-9466-5270587b13f6	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:10.393228	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "04ad5400-a373-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T11:48:41.952Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2049	15712224-0c47-4d13-b4cd-5b6272ef3f5b	ALLEGRO	\N	5	17887745924	5905806208597	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:39.146217	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	828.00	828.00	PL	CASH_ON_DELIVERY	f	{"id": "f42522c0-9e1d-11f0-820b-7b684c0899aa", "tax": null, "offer": {"id": "17887745924", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208597"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T16:55:13.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1778	14971a93-114f-4206-8726-d7b4dd0c8c8f	ALLEGRO	\N	76	15919776449	5905806228854	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:11.870022	Komoda Bones 60x36D1N1 LANCELOT	671.00	671.00	PL	CASH_ON_DELIVERY	f	{"id": "79d42a10-a364-11f0-a3bc-ef5c37833579", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919776449", "name": "Komoda Bones 60x36D1N1 LANCELOT", "external": {"id": "5905806228854"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T10:01:02.105Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1779	81e52f89-9615-4c3b-a2ab-df58e77f7290	ALLEGRO	\N	261	12263585961	5905204699218	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:13.347269	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	1052.00	1052.00	PL	ONLINE	f	{"id": "88af56c1-a357-11f0-bc71-87ddccc94446", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12263585961", "name": "Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699218"}, "productSet": null}, "price": {"amount": "1052.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T08:28:26.205Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1052.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1780	3fed7229-1037-420f-830e-290d37d218ff	ALLEGRO	\N	36	14384928066	5905806202038	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:14.866365	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	326.00	326.00	PL	ONLINE	f	{"id": "6b0a8530-a353-11f0-a15e-754093089519", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384928066", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202038"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T08:03:01.496Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1781	1c9a991a-d0a9-4a5f-9c16-72d0a38a17d5	ALLEGRO	\N	262	14024671782	5905806201307	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:16.329333	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	532.00	532.00	PL	ONLINE	f	{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8", "tax": null, "offer": {"id": "14024671782", "name": "Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot", "external": {"id": "5905806201307"}, "productSet": null}, "price": {"amount": "532.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T07:30:28.729Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "532.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1782	7e1201dc-1b8f-4fd4-8490-6fa4b7424f9f	ALLEGRO	\N	263	15372387250	5905806217926	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:17.859367	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	737.00	737.00	PL	ONLINE	f	{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T07:04:50.959Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1783	bc759282-e4ff-4811-8b54-ddc2ffc0bd5a	ALLEGRO	\N	264	13854397976	5905204699997	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:19.36659	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	314.00	314.00	PL	ONLINE	t	{"id": "a6a3fb32-a349-11f0-9d2c-bd0fd501dc68", "tax": null, "offer": {"id": "13854397976", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN", "external": {"id": "5905204699997"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T06:49:07.597Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1784	28a14e02-7733-4286-be5d-27322a8911b4	ALLEGRO	\N	263	15372387250	5905806217926	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:20.906119	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	737.00	737.00	PL	ONLINE	f	{"id": "865793d0-a346-11f0-9fcc-bf32f2dae555", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T06:28:03.421Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1785	0d378812-b931-4dd0-8a6c-36971a073b39	ALLEGRO	\N	265	16271344068	5905806233490	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:23.030281	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	418.00	418.00	PL	ONLINE	f	{"id": "a6f1c6b0-a341-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16271344068", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN", "external": {"id": "5905806233490"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T05:52:04.196Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1787	69be7f1c-d76e-4fc8-9cb8-e1d7c09db27b	ALLEGRO	\N	95	12266374192	5905806208986	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:24.648917	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	556.00	556.00	PL	ONLINE	f	{"id": "dcd26082-a33e-11f0-b871-03a75625f948", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266374192", "name": "Szafka na buty Supra 30 słupek 30x36 D1N1 Biały", "external": {"id": "5905806208986"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T05:32:06.377Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1788	1db6fabe-4abc-48d4-bf6a-e1a152d1fcf3	ALLEGRO	\N	7	14384927614	5905806202014	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:26.252978	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	312.20	312.20	PL	ONLINE	f	{"id": "3a8cd7d0-a32d-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "312.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T03:28:45.853Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "312.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "13.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
1790	e7392daa-c807-4123-aaf0-a884e3e6750b	ALLEGRO	\N	244	12258723368	5905806216981	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:29.338899	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1887.00	1887.00	PL	ONLINE	f	{"id": "ef3b4ed0-9e02-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "12258723368", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma", "external": {"id": "5905806216981"}, "productSet": null}, "price": {"amount": "1887.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T13:40:59.383Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1887.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1791	fa4899b2-d8b4-4021-bddc-bd2c1c9f6266	ALLEGRO	\N	266	17358940752	5905806237801	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:30.758556	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1391.00	1391.00	PL	ONLINE	t	{"id": "304affb0-9d63-11f0-a677-a5b8c1586284", "tax": null, "offer": {"id": "17358940752", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir", "external": {"id": "5905806237801"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-29T18:37:53.401Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1792	9b0db316-dee1-473d-ab2f-bc64ef5ad788	ALLEGRO	\N	266	17358940752	5905806237801	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:35:32.173827	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1391.00	1391.00	PL	ONLINE	t	{"id": "0e603920-9d35-11f0-8058-6bb39f24a57a", "tax": null, "offer": {"id": "17358940752", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir", "external": {"id": "5905806237801"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-29T13:11:00.683Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2050	b138e94d-adc5-4457-9a63-a318c1a30299	ALLEGRO	\N	303	10862725041	5905204699966	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:41.277086	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	314.00	314.00	PL	ONLINE	f	{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862725041", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma", "external": {"id": "5905204699966"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T16:33:59.773Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
16	7042939b-0721-4224-9c3c-63c5ef9cda1d	ALLEGRO	05f81d30-a2a7-11f0-a638-c7e352f2113f	\N	17567410245	\N	Poduszka ozdobna, dekoracyjna 50x30cm	1	37.00	PLN	\N	\N	\N	2025-10-06 17:22:24.075953	Poduszka ozdobna, dekoracyjna 50x30cm	37.00	37.00	\N	CASH_ON_DELIVERY	f	{"id": "05f81d30-a2a7-11f0-a638-c7e352f2113f", "tax": null, "offer": {"id": "17567410245", "name": "Poduszka ozdobna, dekoracyjna 50x30cm", "external": null, "productSet": null}, "price": {"amount": "37.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T11:27:11.345Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "37.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
4	a59d114d-a441-487d-8095-10382a284351	ALLEGRO	0927d4f0-a289-11f0-b024-2112831760cb	20	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	1	341.00	PLN	\N	\N	5905806203899_1.jpg	2025-10-06 17:22:25.827874	Szafka na buty z szufladą Tres 30x30x82 Biały	341.00	341.00	\N	ONLINE	f	{"id": "0927d4f0-a289-11f0-b024-2112831760cb", "tax": null, "offer": {"id": "12266463730", "name": "Szafka na buty z szufladą Tres 30x30x82 Biały", "external": {"id": "5905806203899"}, "productSet": null}, "price": {"amount": "341.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T07:50:20.815Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "341.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
10	c51004bb-f607-48a9-ad09-b1d3b39fe31c	ALLEGRO	085ce430-a2d3-11f0-bfbd-d3aacc6a2e00	45	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	1	1136.00	PLN	\N	\N	5905806218855_1.jpg	2025-10-06 17:22:22.166781	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	1136.00	1136.00	\N	ONLINE	f	{"id": "085ce430-a2d3-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15410022839", "name": "Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan", "external": {"id": "5905806218855"}, "productSet": null}, "price": {"amount": "1136.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T16:42:57.631Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1136.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
15	dc3896d9-7ab3-4325-87a3-3b4718b53ee9	ALLEGRO	3f514580-a2b0-11f0-9468-2bd22967b382	17	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	1	326.00	PLN	\N	\N	5905806202045_1.jpg	2025-10-06 17:22:23.86809	Szafka na buty VB60x30D1N1 Dąb Olejowany	326.00	326.00	\N	ONLINE	t	{"id": "3f514580-a2b0-11f0-9468-2bd22967b382", "tax": null, "offer": {"id": "17380187713", "name": "Szafka na buty VB60x30D1N1 Dąb Olejowany", "external": {"id": "5905806202045"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T12:33:10.359Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
3	328ffa0c-bfcf-47f7-afaf-fd8601605086	ALLEGRO	b58b30b0-a28a-11f0-abd8-f5344f24907b	3	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	1	471.00	PLN	\N	\N	5905806213034_1.jpg	2025-10-06 17:22:25.617356	Szafka komoda na buty 50x30 D2N1 Altus Czarny	471.00	471.00	\N	ONLINE	f	{"id": "b58b30b0-a28a-11f0-abd8-f5344f24907b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15179529808", "name": "Szafka komoda na buty 50x30 D2N1 Altus Czarny", "external": {"id": "5905806213034"}, "productSet": null}, "price": {"amount": "471.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T08:07:17.041Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "471.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
6	30365a40-4659-4c20-b1fa-f4c543794907	ALLEGRO	ebb87110-a21d-11f0-a6cc-b3145592fdde	38	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	1	550.00	PLN	\N	\N	\N	2025-10-06 17:22:29.745472	Komoda Bini 80x30x82 D1N1 BIAŁY	550.00	550.00	\N	ONLINE	f	{"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16602435582", "name": "Komoda Bini 80x30x82 D1N1 BIAŁY", "external": {"id": "5905806234596"}, "productSet": null}, "price": {"amount": "550.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:03:50.665Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "550.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
1	e70107a7-450e-4f55-883c-71a0f9f9055d	ALLEGRO	38cc44e0-a2a5-11f0-a6c9-036cfc044caf	\N	17736445207	\N	Szafka na buty VB60x30D1N1 KASZMIR	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:24.256142	Szafka na buty VB60x30D1N1 KASZMIR	326.00	326.00	\N	ONLINE	f	{"id": "38cc44e0-a2a5-11f0-a6c9-036cfc044caf", "tax": null, "offer": {"id": "17736445207", "name": "Szafka na buty VB60x30D1N1 KASZMIR", "external": null, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T11:12:51.380Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
13	81dffdde-4bfb-440c-ac94-350c284be66a	ALLEGRO	e77ea240-a2bd-11f0-b024-2112831760cb	30	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	1	1283.00	PLN	\N	\N	\N	2025-10-06 17:22:23.221558	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	1283.00	1283.00	\N	ONLINE	t	{"id": "e77ea240-a2bd-11f0-b024-2112831760cb", "tax": null, "offer": {"id": "12487594818", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT", "external": {"id": "5905806204988"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T14:09:28.909Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
32	2b80dd7c-e525-4615-b83f-a659f1821cbd	ALLEGRO	56867c00-a221-11f0-83df-53954cf6c551	34	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	1	1352.00	PLN	\N	\N	\N	2025-10-06 17:22:29.053007	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	1352.00	1352.00	\N	ONLINE	f	{"id": "56867c00-a221-11f0-83df-53954cf6c551", "tax": null, "offer": {"id": "16723583463", "name": "Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN", "external": {"id": "5905806237160"}, "productSet": null}, "price": {"amount": "1352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:31:23.064Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
35	7c49d061-39b5-44ca-a916-3cdeee5050be	ALLEGRO	1ec95e30-a21d-11f0-8c5e-eb0a288ebc91	22	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	1	418.00	PLN	\N	\N	\N	2025-10-06 17:22:29.536323	Komoda Bini 60x30D1N1 SONOMA	418.00	418.00	\N	ONLINE	f	{"id": "1ec95e30-a21d-11f0-8c5e-eb0a288ebc91", "tax": null, "offer": {"id": "16276323396", "name": "Komoda Bini 60x30D1N1 SONOMA", "external": {"id": "5905806233933"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:04:42.655Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
21	49cd32a5-2c58-40dc-b9e0-6f347c0e0502	ALLEGRO	ed8c3d50-a236-11f0-b1e3-b7ce882fc700	24	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	1	564.00	PLN	\N	\N	\N	2025-10-06 17:22:27.154856	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	564.00	564.00	\N	ONLINE	f	{"id": "ed8c3d50-a236-11f0-b1e3-b7ce882fc700", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155170458", "name": "Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY", "external": {"id": "5905806208788"}, "productSet": null}, "price": {"amount": "564.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T22:03:35.684Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "564.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
46	2ba7e38f-439c-471b-a24f-e61e1791fcac	ALLEGRO	95248c91-a271-11f0-9468-2bd22967b382	28	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	5905806200027_1.jpg	2025-10-06 17:22:26.454754	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	\N	ONLINE	f	{"id": "95248c91-a271-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T05:03:08.713Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
24	9933579a-1eb8-455f-b365-b31a88b5b024	ALLEGRO	68c5d8f1-a22d-11f0-954f-f9092bddbf0d	27	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	1	399.00	PLN	\N	\N	\N	2025-10-06 17:22:27.642475	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	399.00	399.00	\N	ONLINE	t	{"id": "68c5d8f1-a22d-11f0-954f-f9092bddbf0d", "tax": null, "offer": {"id": "14387673937", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY", "external": {"id": "5905806202366"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T20:55:53.370Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
22	55660f82-8870-46b4-beb2-5b3a193ab248	ALLEGRO	93baa581-a233-11f0-a6cc-b3145592fdde	25	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	2025-10-06 17:22:27.365276	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	471.00	471.00	\N	ONLINE	f	{"id": "93baa581-a233-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "10862951244", "name": "Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma", "external": {"id": "5905806209020"}, "productSet": null}, "price": {"amount": "471.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T21:48:39.331Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "471.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
43	f42c3807-6a5e-4a55-aa5d-838c83aa0c52	ALLEGRO	88f95b90-a1f8-11f0-8865-a987ea6c1e01	\N	17532811873	\N	Szafka na buty, słupek SUPRA-TRES 30x30 Biały	1	532.00	PLN	\N	\N	\N	2025-10-06 17:22:32.860073	Szafka na buty, słupek SUPRA-TRES 30x30 Biały	532.00	532.00	\N	CASH_ON_DELIVERY	f	{"id": "88f95b90-a1f8-11f0-8865-a987ea6c1e01", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17532811873", "name": "Szafka na buty, słupek SUPRA-TRES 30x30 Biały", "external": null, "productSet": null}, "price": {"amount": "532.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T14:35:55.579Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "532.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
20	16cfc692-2a5a-458d-a014-13439bea66f3	ALLEGRO	963f6250-a238-11f0-b1e3-b7ce882fc700	16	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	1	595.00	PLN	\N	\N	\N	2025-10-06 17:22:26.873981	Szafka na buty VB100x30 D3N3 CZARNY	595.00	595.00	\N	ONLINE	f	{"id": "963f6250-a238-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "17496557717", "name": "Szafka na buty VB100x30 D3N3 CZARNY", "external": {"id": "5905806238860"}, "productSet": null}, "price": {"amount": "595.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T22:16:07.898Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "595.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
45	c754e354-d98d-42be-ae7d-d4e20d121df0	ALLEGRO	d8377250-a293-11f0-997b-19b8e7655382	40	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	2025-10-06 17:22:25.196084	Komoda Bones 50x36D1N1 SONOMA	638.00	638.00	\N	ONLINE	t	{"id": "d8377250-a293-11f0-997b-19b8e7655382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919784146", "name": "Komoda Bones 50x36D1N1 SONOMA", "external": {"id": "5905806228984"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T09:10:11.307Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
25	dd3ba2e2-8844-4718-ab23-f6352685d107	ALLEGRO	2931ddc2-a22c-11f0-809f-f9f6de958f67	11	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	2025-10-06 17:22:27.850836	Komoda Bini 50x36 D1N1 CZARNY	385.00	385.00	\N	ONLINE	f	{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67", "tax": null, "offer": {"id": "16602434928", "name": "Komoda Bini 50x36 D1N1 CZARNY", "external": {"id": "5905806234558"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T20:47:20.515Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
27	37bc82ad-3f6e-4acc-86c3-ebecf9468c90	ALLEGRO	52c3f190-a228-11f0-a6cc-b3145592fdde	1	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	1	564.00	PLN	\N	\N	\N	2025-10-06 17:22:28.205008	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	564.00	564.00	\N	ONLINE	f	{"id": "52c3f190-a228-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221503220", "name": "Szafka na buty z szufladą Tres 80x30 Dąb Wotan", "external": {"id": "5905806214192"}, "productSet": null}, "price": {"amount": "564.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T20:23:18.180Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "564.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
28	a6d867c9-a1f4-4f17-b1a8-a7f1b68e88b7	ALLEGRO	56326bc1-a225-11f0-a82d-fde841cbe8d5	9	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	350.00	PLN	\N	\N	\N	2025-10-06 17:22:28.425145	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	350.00	350.00	\N	ONLINE	f	{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5", "tax": null, "offer": {"id": "14384932618", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA", "external": {"id": "5905806202205"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:57:12.998Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
29	a6d867c9-a1f4-4f17-b1a8-a7f1b68e88b7	ALLEGRO	56326bc2-a225-11f0-a82d-fde841cbe8d5	31	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	1	600.00	PLN	\N	\N	\N	2025-10-06 17:22:28.425145	Szafka na buty z szufladą Tres 80x82x36 SONOMA	600.00	600.00	\N	ONLINE	f	{"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11873260685", "name": "Szafka na buty z szufladą Tres 80x82x36 SONOMA", "external": {"id": "5905806214246"}, "productSet": null}, "price": {"amount": "600.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:57:12.998Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "600.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
30	2ef91208-577e-461d-8abc-14b328d29ec0	ALLEGRO	261aefe0-a223-11f0-bddc-ebae77b3e555	32	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	1	508.00	PLN	\N	\N	\N	2025-10-06 17:22:28.775281	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	508.00	508.00	\N	ONLINE	f	{"id": "261aefe0-a223-11f0-bddc-ebae77b3e555", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155236665", "name": "Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT", "external": {"id": "5905806209099"}, "productSet": null}, "price": {"amount": "508.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:40:53.755Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "508.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
33	2b80dd7c-e525-4615-b83f-a659f1821cbd	ALLEGRO	56867c01-a221-11f0-83df-53954cf6c551	35	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	1	857.00	PLN	\N	\N	\N	2025-10-06 17:22:29.053007	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	857.00	857.00	\N	ONLINE	f	{"id": "56867c01-a221-11f0-83df-53954cf6c551", "tax": null, "offer": {"id": "16458885091", "name": "Zestaw Tres60x36D1N1 3PAN WP60 WOTAN", "external": {"id": "5905806221473"}, "productSet": null}, "price": {"amount": "857.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:31:23.064Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "857.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
36	30365a40-4659-4c20-b1fa-f4c543794907	ALLEGRO	ebb87112-a21d-11f0-a6cc-b3145592fdde	13	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	1	352.00	PLN	\N	\N	\N	2025-10-06 17:22:29.745472	Komoda Bini 50x30x82 D1N1 BIAŁY	352.00	352.00	\N	ONLINE	f	{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16602433072", "name": "Komoda Bini 50x30x82 D1N1 BIAŁY", "external": {"id": "5905806234473"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:03:50.665Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
37	30365a40-4659-4c20-b1fa-f4c543794907	ALLEGRO	ebb87111-a21d-11f0-a6cc-b3145592fdde	37	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	1	418.00	PLN	\N	\N	\N	2025-10-06 17:22:29.745472	Komoda Bini 60x30D1N1 BIAŁY	418.00	418.00	\N	ONLINE	f	{"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16276316851", "name": "Komoda Bini 60x30D1N1 BIAŁY", "external": {"id": "5905806233896"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:03:50.665Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
39	34a01310-5c7f-4619-9e29-e80772b4db8b	ALLEGRO	9f451900-a204-11f0-b1e3-b7ce882fc700	53	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	1	278.00	PLN	\N	\N	\N	2025-10-06 17:22:31.344493	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	278.00	278.00	\N	ONLINE	f	{"id": "9f451900-a204-11f0-b1e3-b7ce882fc700", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14563825336", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan", "external": {"id": "5905806203585"}, "productSet": null}, "price": {"amount": "278.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T16:03:06.006Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "278.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
47	5813452e-d741-4fc9-a07c-f084e42b3867	ALLEGRO	36303050-a270-11f0-8e98-fdfd51e10ba4	15	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	2025-10-06 17:22:26.662347	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	350.00	350.00	\N	ONLINE	f	{"id": "36303050-a270-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384932878", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202212"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T04:53:41.211Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
40	4f5560ee-c2a1-483c-bc48-1958ab3166f3	ALLEGRO	2dd9b790-a203-11f0-bdc8-e34a18959311	44	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	1	963.00	PLN	\N	\N	\N	2025-10-06 17:22:31.552868	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	963.00	963.00	\N	ONLINE	f	{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440331779", "name": "Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN", "external": {"id": "5905806218077"}, "productSet": null}, "price": {"amount": "963.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T15:53:18.563Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "963.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
63	def8def3-46ae-4688-8e6e-cf21d61c550a	ALLEGRO	ed2dbb50-a1c2-11f0-9468-2bd22967b382	93	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	2	478.00	PLN	\N	\N	\N	2025-10-06 17:22:36.928155	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	478.00	956.00	\N	ONLINE	f	{"id": "ed2dbb50-a1c2-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221043005", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Artisan", "external": {"id": "5905806208320"}, "productSet": null}, "price": {"amount": "478.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T08:12:54.123Z", "quantity": 2, "vouchers": [], "discounts": null, "originalPrice": {"amount": "478.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
48	710b8345-77bd-479f-bafb-dd032326624b	ALLEGRO	caf0a280-a1f6-11f0-9468-2bd22967b382	50	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	3	556.00	PLN	\N	\N	\N	2025-10-06 17:22:33.032891	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	556.00	1668.00	\N	ONLINE	f	{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176152026", "name": "Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan", "external": {"id": "5905806212952"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T14:24:59.191Z", "quantity": 3, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
52	b9cb96e4-1cf4-4b19-8c40-c3b37e2601a5	ALLEGRO	6981df20-a1ef-11f0-84a0-0fb86e0c96e9	88	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	2025-10-06 17:22:33.859528	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	611.00	611.00	\N	ONLINE	f	{"id": "6981df20-a1ef-11f0-84a0-0fb86e0c96e9", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15315950401", "name": "Szafka na buty z szufladą Tres 100x36D1N1 SONOMA", "external": {"id": "5905806214581"}, "productSet": null}, "price": {"amount": "611.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:30:23.179Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "611.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
73	cbd0b39b-389c-44a7-ae00-5cbdb7e35652	ALLEGRO	6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95	89	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	2025-10-06 17:22:34.067525	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1343.00	1343.00	\N	CASH_ON_DELIVERY	f	{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17358916449", "name": "Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir", "external": {"id": "5905806237795"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:24:31.107Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
53	aa8eb221-d302-4cef-8734-3453bc50ffcd	ALLEGRO	9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed	39	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	478.00	PLN	\N	\N	\N	2025-10-06 17:22:34.274417	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	478.00	478.00	\N	ONLINE	f	{"id": "9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221043126", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Wotan", "external": {"id": "5905806208337"}, "productSet": null}, "price": {"amount": "478.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:03:39.318Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "478.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
59	04d9c243-0201-4f18-b698-e093252d0419	ALLEGRO	d4736be0-a1d7-11f0-9d66-3d00eb1ccfed	83	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	1	977.00	PLN	\N	\N	\N	2025-10-06 17:22:35.421425	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	977.00	977.00	\N	ONLINE	f	{"id": "d4736be0-a1d7-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "15109022782", "name": "Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806207569"}, "productSet": null}, "price": {"amount": "977.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T10:42:49.308Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "977.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2052	17867747-19bf-436a-852f-e8f559715eb3	ALLEGRO	\N	288	12487657175	5905204699614	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:42.761625	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1319.00	1319.00	PL	CASH_ON_DELIVERY	f	{"id": "880cc4e1-9e17-11f0-b871-03a75625f948", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487657175", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699614"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T16:13:12.576Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
65	953a93d0-a93a-44d7-8f07-8c4c389731a9	ALLEGRO	8ea377b0-a162-11f0-a6cc-b3145592fdde	\N	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:38.345264	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	326.00	326.00	\N	ONLINE	f	{"id": "8ea377b0-a162-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17736467450", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR", "external": null, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T20:42:42.880Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
50	41811f92-37a2-4f2a-8b79-27bbbb5c5346	ALLEGRO	3bd7f920-a1f3-11f0-a6cc-b3145592fdde	52	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	1	954.00	PLN	\N	\N	\N	2025-10-06 17:22:33.446871	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	954.00	954.00	\N	ONLINE	t	{"id": "3bd7f920-a1f3-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476639410", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699454"}, "productSet": null}, "price": {"amount": "954.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:58:47.640Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "954.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
55	c5b4062c-f9fd-4d41-8668-9a0d616a2ae5	ALLEGRO	c507ff61-a1df-11f0-ac86-5dc583ff1e95	59	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	2025-10-06 17:22:34.72799	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	592.00	592.00	\N	CASH_ON_DELIVERY	f	{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176238729", "name": "Szafka komoda na buty 80x36 D2N1 Altus WOTAN", "external": {"id": "5905806209662"}, "productSet": null}, "price": {"amount": "592.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T11:40:19.846Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "592.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
51	49b990dc-6be3-421d-ad31-90d958774a4f	ALLEGRO	d63af130-a1f2-11f0-b871-03a75625f948	36	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:33.653189	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	326.00	326.00	\N	ONLINE	f	{"id": "d63af130-a1f2-11f0-b871-03a75625f948", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384928066", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202038"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:55:11.423Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
54	aa8eb221-d302-4cef-8734-3453bc50ffcd	ALLEGRO	9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed	90	17946230281	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	2025-10-06 17:22:34.274417	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	229.00	229.00	\N	ONLINE	f	{"id": "9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17946230281", "name": "Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan", "external": {"id": "5905806203660"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T13:03:39.318Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
56	c5b4062c-f9fd-4d41-8668-9a0d616a2ae5	ALLEGRO	c507ff62-a1df-11f0-ac86-5dc583ff1e95	61	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	2025-10-06 17:22:34.72799	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	399.00	399.00	\N	CASH_ON_DELIVERY	f	{"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95", "tax": null, "offer": {"id": "14387670556", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT", "external": {"id": "5905806202274"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T11:40:19.846Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
61	68ca0c58-dff9-4645-8600-f736a00c866c	ALLEGRO	da1070c0-a1d2-11f0-9d66-3d00eb1ccfed	85	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	1	1319.00	PLN	\N	\N	\N	2025-10-06 17:22:35.837192	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	1319.00	1319.00	\N	ONLINE	f	{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15121615649", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan", "external": {"id": "5905806205138"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T10:05:51.190Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
66	dcb5f907-8ac0-4937-9a25-c01f7e4251b1	ALLEGRO	db5d2000-a159-11f0-9468-2bd22967b382	\N	17739061173	\N	Wieszak ścienny WP60 na ubrania 60cm SONOMA CZARNY	1	229.00	PLN	\N	\N	\N	2025-10-06 17:22:38.737	Wieszak ścienny WP60 na ubrania 60cm SONOMA CZARNY	229.00	229.00	\N	ONLINE	f	{"id": "db5d2000-a159-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17739061173", "name": "Wieszak ścienny WP60 na ubrania 60cm SONOMA CZARNY", "external": null, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T19:40:54.407Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
67	4abb640d-8c86-435e-a171-6fd48f18a86c	ALLEGRO	f03afef0-a14c-11f0-a6cc-b3145592fdde	\N	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	1	3.00	PLN	\N	\N	\N	2025-10-06 17:22:38.978783	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3.00	3.00	\N	ONLINE	f	{"id": "f03afef0-a14c-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "17532641274", "name": "Nóżka 2cmN1 z tworzywa sztucznego CZARNY", "external": null, "productSet": null}, "price": {"amount": "3.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T18:09:59.499Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "3.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
60	70786c41-d391-400a-9721-ceab1189d76e	ALLEGRO	e2333c80-a1d5-11f0-8865-a987ea6c1e01	70	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	2025-10-06 17:22:35.628887	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	828.00	828.00	\N	ONLINE	f	{"id": "e2333c80-a1d5-11f0-8865-a987ea6c1e01", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696299", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "external": {"id": "5905806208580"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T10:30:21.692Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	1
69	16cfc692-2a5a-458d-a014-13439bea66f3	ALLEGRO	963f6251-a238-11f0-b1e3-b7ce882fc700	54	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	1	545.00	PLN	\N	\N	\N	2025-10-06 17:22:26.873981	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	545.00	545.00	\N	ONLINE	f	{"id": "963f6251-a238-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "15685809460", "name": "Szafka na buty z szufladą Tres 60x36D1N3 CZARNY", "external": {"id": "5905806222005"}, "productSet": null}, "price": {"amount": "545.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T22:16:07.898Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "545.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
98	d963ef78-a78f-4bf0-948f-9eee8e12e085	ALLEGRO	8d6be4c0-a2a4-11f0-8d49-a16d7ed74f8d	90	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	5905806203660_1.jpg	2025-10-06 17:22:24.429299	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	229.00	229.00	\N	ONLINE	f	{"id": "8d6be4c0-a2a4-11f0-8d49-a16d7ed74f8d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14604181578", "name": "Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan", "external": {"id": "5905806203660"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T11:09:13.896Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
75	c813b593-8256-4b64-96ac-f2e45526a6f7	ALLEGRO	a9904fc1-a217-11f0-83df-53954cf6c551	41	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	1	510.00	PLN	\N	\N	\N	2025-10-06 17:22:30.099521	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	510.00	510.00	\N	ONLINE	f	{"id": "a9904fc1-a217-11f0-83df-53954cf6c551", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11906888620", "name": "Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA", "external": {"id": "5905806203578"}, "productSet": null}, "price": {"amount": "510.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T18:25:05.693Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "510.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
78	720b5cc7-78d6-4b63-88d0-db10f7b37100	ALLEGRO	65d12870-a1c9-11f0-9d66-3d00eb1ccfed	92	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	1	715.00	PLN	\N	\N	\N	2025-10-06 17:22:36.720278	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	715.00	715.00	\N	CASH_ON_DELIVERY	f	{"id": "65d12870-a1c9-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "16271360906", "name": "Szafka na buty Supra-Nex 30x30D1N1 SONOMA", "external": {"id": "5905806233643"}, "productSet": null}, "price": {"amount": "715.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T08:59:31.609Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "715.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
82	01390247-d785-4251-8909-ce6295a17d59	ALLEGRO	0f3d3ed1-a16b-11f0-8e98-fdfd51e10ba4	64	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	1	352.00	PLN	\N	\N	\N	2025-10-06 17:22:38.133873	Komoda Bini 50x30x82 D1N1 LANCELOT	352.00	352.00	\N	ONLINE	f	{"id": "0f3d3ed1-a16b-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "16602433840", "name": "Komoda Bini 50x30x82 D1N1 LANCELOT", "external": {"id": "5905806234503"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T21:43:06.157Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
83	5c016a78-6980-41bb-bdfa-982dca026591	ALLEGRO	6a952650-a15f-11f0-8e98-fdfd51e10ba4	11	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	2025-10-06 17:22:38.523804	Komoda Bini 50x36 D1N1 CZARNY	385.00	385.00	\N	CASH_ON_DELIVERY	f	{"id": "6a952650-a15f-11f0-8e98-fdfd51e10ba4", "tax": null, "offer": {"id": "16602434928", "name": "Komoda Bini 50x36 D1N1 CZARNY", "external": {"id": "5905806234558"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T20:21:06.397Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
79	e5313940-bbfe-4bd1-8ef0-b82e3a14462e	ALLEGRO	95525592-a1bc-11f0-a6cc-b3145592fdde	95	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	2025-10-06 17:22:37.344062	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	556.00	556.00	\N	ONLINE	f	{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266374192", "name": "Szafka na buty Supra 30 słupek 30x36 D1N1 Biały", "external": {"id": "5905806208986"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T07:28:22.122Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
80	e214eeea-3883-45bf-ba8a-adde21c88ea7	ALLEGRO	61b176c0-a1b8-11f0-96ea-bf4f56b08af2	19	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	2025-10-06 17:22:37.710939	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	\N	ONLINE	f	{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T06:56:59.174Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
81	94a65272-c59b-40af-a410-bf63ed041ce1	ALLEGRO	00c72ba0-a16f-11f0-a6cc-b3145592fdde	60	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	434.90	PLN	\N	\N	\N	2025-10-06 17:22:37.920142	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	434.90	434.90	\N	ONLINE	f	{"id": "00c72ba0-a16f-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11873248609", "name": "Szafka na buty z szufladą Tres 60x30 Dąb Sonoma", "external": {"id": "5905806208252"}, "productSet": null}, "price": {"amount": "434.90", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T22:11:42.352Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "434.90", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "19.10", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
86	e739a360-57ef-43e5-9eb1-c8e28c6a6b5a	ALLEGRO	286a31c0-a14c-11f0-9468-2bd22967b382	67	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:39.219797	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	326.00	326.00	\N	ONLINE	f	{"id": "286a31c0-a14c-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10862736322", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma", "external": {"id": "5905806202007"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T18:07:12.154Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
87	7e2adc34-4753-44fd-9c39-d3684d639c13	ALLEGRO	8054c5a0-a145-11f0-96ea-bf4f56b08af2	68	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	2025-10-06 17:22:39.427395	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	773.00	773.00	\N	ONLINE	f	{"id": "8054c5a0-a145-11f0-96ea-bf4f56b08af2", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440328823", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY", "external": {"id": "5905806217902"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T17:15:18.576Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
88	df78982c-e809-45cc-ad5f-74fb3c0cc16c	ALLEGRO	2faa5190-a142-11f0-9d66-3d00eb1ccfed	69	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	2025-10-06 17:22:39.670299	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	405.20	405.20	\N	CASH_ON_DELIVERY	f	{"id": "2faa5190-a142-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14387674355", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202380"}, "productSet": null}, "price": {"amount": "405.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T16:50:53.606Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "405.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "17.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
2054	49aad1c3-c7f8-48d6-a12f-6f8c871e60b1	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:44.289041	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "02fe8ca0-9e0f-11f0-9fa0-ab34abe0805b", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T15:09:24.325Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
90	812d92c8-ae7f-4af6-9a85-a6b93e90a02f	ALLEGRO	240ed370-a137-11f0-8323-6df02f435f6c	28	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	2025-10-06 17:22:40.113335	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	\N	ONLINE	f	{"id": "240ed370-a137-11f0-8323-6df02f435f6c", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T15:36:02.940Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
91	5f06f3bd-2012-4881-8617-9b5942114f45	ALLEGRO	89365d47-a137-11f0-9d66-3d00eb1ccfed	76	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	2025-10-06 17:22:40.327157	Komoda Bones 60x36D1N1 LANCELOT	671.00	671.00	\N	ONLINE	f	{"id": "89365d47-a137-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919776449", "name": "Komoda Bones 60x36D1N1 LANCELOT", "external": {"id": "5905806228854"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T15:35:18.251Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
95	d3cc3ffc-5ec5-4412-ac8f-b9e78b1df761	ALLEGRO	985984e0-a129-11f0-bfbd-d3aacc6a2e00	71	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	1	556.00	PLN	\N	\N	\N	2025-10-06 17:22:41.166625	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	556.00	556.00	\N	ONLINE	f	{"id": "985984e0-a129-11f0-bfbd-d3aacc6a2e00", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176150939", "name": "Szafka komoda na buty 80x30 D2N1 Altus CZARNY", "external": {"id": "5905806209549"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T13:54:59.448Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2055	0a771a40-fb99-4f32-8984-96235a887564	ALLEGRO	\N	280	16276327427	5905806233995	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:45.69614	Komoda Bini 60x36D1N1 SONOMA	462.00	462.00	PL	CASH_ON_DELIVERY	f	{"id": "dc6afa80-9e0c-11f0-a758-8bcc0e9ae972", "tax": null, "offer": {"id": "16276327427", "name": "Komoda Bini 60x36D1N1 SONOMA", "external": {"id": "5905806233995"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T14:51:52.912Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
99	a5f44356-0989-4375-8faa-c20d22c721a8	ALLEGRO	ea7b73e0-a283-11f0-aba2-b3553c261cc2	7	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:26.036292	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	326.00	326.00	\N	CASH_ON_DELIVERY	f	{"id": "ea7b73e0-a283-11f0-aba2-b3553c261cc2", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T07:13:41.947Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
96	50e72ed3-2ae9-456f-852b-6da16ddd4653	ALLEGRO	96277490-a127-11f0-b1e3-b7ce882fc700	72	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	1	556.00	PLN	\N	\N	\N	2025-10-06 17:22:41.374771	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	556.00	556.00	\N	ONLINE	f	{"id": "96277490-a127-11f0-b1e3-b7ce882fc700", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15176150526", "name": "Szafka komoda na buty 80x30 D2N1 Altus WOTAN", "external": {"id": "5905806209525"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T13:41:13.285Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
100	d02f8404-fda6-4b9b-8399-62e3f31095c1	ALLEGRO	fe967e60-a27e-11f0-a6cc-b3145592fdde	18	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	1	671.00	PLN	\N	\N	5905806234268_1.jpg	2025-10-06 17:22:26.243504	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	671.00	671.00	\N	ONLINE	f	{"id": "fe967e60-a27e-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16319665889", "name": "Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY", "external": {"id": "5905806234268"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T06:39:21.161Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
76	8304bd82-e41c-486e-987d-c280ad9446ea	ALLEGRO	68eb0ca0-a20b-11f0-b1e3-b7ce882fc700	23	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	2025-10-06 17:22:30.611858	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	314.00	\N	ONLINE	f	{"id": "68eb0ca0-a20b-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T16:51:31.756Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
101	05170028-af4e-44c5-aaa9-826387282c4f	ALLEGRO	4e8d66b0-a1ce-11f0-954f-f9092bddbf0d	91	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	1	692.00	PLN	\N	\N	\N	2025-10-06 17:22:36.25207	Komoda Bones 50x36D4N1 CZARNY	692.00	692.00	\N	CASH_ON_DELIVERY	f	{"id": "4e8d66b0-a1ce-11f0-954f-f9092bddbf0d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15977138561", "name": "Komoda Bones 50x36D4N1 CZARNY", "external": {"id": "5905806229035"}, "productSet": null}, "price": {"amount": "692.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T09:34:01.088Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "692.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
77	62e1d675-cc25-4729-8a45-7215a2f66dc6	ALLEGRO	4284e730-a1c9-11f0-b871-03a75625f948	23	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	2	314.00	PLN	\N	\N	\N	2025-10-06 17:22:36.458881	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	314.00	628.00	\N	ONLINE	f	{"id": "4284e730-a1c9-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "13854421583", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN", "external": {"id": "5905204699973"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T08:59:43.591Z", "quantity": 2, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
84	dcb5f907-8ac0-4937-9a25-c01f7e4251b1	ALLEGRO	db5d2001-a159-11f0-9468-2bd22967b382	65	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	1	780.00	PLN	\N	\N	\N	2025-10-06 17:22:38.737	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	780.00	780.00	\N	ONLINE	f	{"id": "db5d2001-a159-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112615224", "name": "Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma", "external": {"id": "5905806208528"}, "productSet": null}, "price": {"amount": "780.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T19:40:54.407Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "780.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
89	5e96adc2-ecb2-419b-b8b6-cc6bdfd1785c	ALLEGRO	20d547c0-a141-11f0-8e98-fdfd51e10ba4	70	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	2025-10-06 17:22:39.897707	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	828.00	828.00	\N	ONLINE	f	{"id": "20d547c0-a141-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696299", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "external": {"id": "5905806208580"}, "productSet": null}, "price": {"amount": "828.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T16:43:58.017Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "828.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
85	4abb640d-8c86-435e-a171-6fd48f18a86c	ALLEGRO	f03afef1-a14c-11f0-a6cc-b3145592fdde	66	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	1	64.00	PLN	\N	\N	\N	2025-10-06 17:22:38.978783	Panel ścienny tapicerowany pan1x60x30	64.00	64.00	\N	ONLINE	f	{"id": "f03afef1-a14c-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11769334649", "name": "Panel ścienny tapicerowany pan1x60x30", "external": {"id": "5905806208429"}, "productSet": null}, "price": {"amount": "64.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T18:09:59.499Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "64.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
93	28373c96-eae0-4096-aa13-4fb9cfafb4e2	ALLEGRO	b6576ec0-a134-11f0-8323-6df02f435f6c	58	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	1	1286.40	PLN	\N	\N	\N	2025-10-06 17:22:40.745235	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	1286.40	1286.40	\N	ONLINE	f	{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c", "tax": null, "offer": {"id": "12487659714", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot", "external": {"id": "5905204699591"}, "productSet": null}, "price": {"amount": "1286.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T15:15:02.547Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1286.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "56.60", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
74	a6d867c9-a1f4-4f17-b1a8-a7f1b68e88b7	ALLEGRO	56326bc0-a225-11f0-a82d-fde841cbe8d5	55	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	1	229.00	PLN	\N	\N	\N	2025-10-06 17:22:28.425145	Wieszak ścienny WP60 na ubrania 60cm Sonoma	229.00	229.00	\N	ONLINE	f	{"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11711299117", "name": "Wieszak ścienny WP60 na ubrania 60cm Sonoma", "external": {"id": "5905806203677"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:57:12.998Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
102	d963ef78-a78f-4bf0-948f-9eee8e12e085	ALLEGRO	8d6be4c1-a2a4-11f0-8d49-a16d7ed74f8d	7	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	2025-10-06 17:22:24.429299	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	312.20	312.20	\N	ONLINE	f	{"id": "8d6be4c1-a2a4-11f0-8d49-a16d7ed74f8d", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "312.20", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T11:09:13.896Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "312.20", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "13.80", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
103	4381e6d9-06a8-4017-bf15-d64f778abc81	ALLEGRO	5bcb2310-a29d-11f0-a638-c7e352f2113f	47	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1	1807.60	PLN	\N	\N	\N	2025-10-06 17:22:24.712894	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1807.60	1807.60	\N	ONLINE	f	{"id": "5bcb2310-a29d-11f0-a638-c7e352f2113f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258666208", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały", "external": {"id": "5905806216974"}, "productSet": null}, "price": {"amount": "1807.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T10:16:50.021Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1807.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "79.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
104	e63563fc-37be-4c24-921e-830509407cec	ALLEGRO	597b6050-a295-11f0-bee6-2fee815ffc9f	4	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	1	229.00	PLN	\N	\N	\N	2025-10-06 17:22:24.927228	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	229.00	229.00	\N	ONLINE	t	{"id": "597b6050-a295-11f0-bee6-2fee815ffc9f", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10983158854", "name": "Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY", "external": {"id": "5905806203691"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T09:18:15.286Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
105	48a8d4ed-5176-472a-a776-5918e0b761df	ALLEGRO	6fc7b940-a20d-11f0-bdc8-e34a18959311	6	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	1	1391.00	PLN	\N	\N	\N	2025-10-06 17:22:30.377734	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	1391.00	1391.00	\N	ONLINE	f	{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15251020703", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY", "external": {"id": "5905806218220"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T17:07:10.414Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
106	8304bd82-e41c-486e-987d-c280ad9446ea	ALLEGRO	68eb0ca1-a20b-11f0-b1e3-b7ce882fc700	42	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	1	169.00	PLN	\N	\N	\N	2025-10-06 17:22:30.611858	Wieszak ścienny W50 na ubrania 50cm WOTAN	169.00	169.00	\N	ONLINE	f	{"id": "68eb0ca1-a20b-11f0-b1e3-b7ce882fc700", "tax": null, "offer": {"id": "15258808621", "name": "Wieszak ścienny W50 na ubrania 50cm WOTAN", "external": {"id": "5905806210873"}, "productSet": null}, "price": {"amount": "169.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T16:51:31.756Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "169.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
107	933d79e8-1d0d-4705-9dfc-983c1e2647ff	ALLEGRO	2af87750-a208-11f0-a6cc-b3145592fdde	2	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	780.00	PLN	\N	\N	\N	2025-10-06 17:22:30.916739	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	780.00	780.00	\N	ONLINE	f	{"id": "2af87750-a208-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11957206330", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma", "external": {"id": "5905806208467"}, "productSet": null}, "price": {"amount": "780.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T16:32:10.577Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "780.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
109	179bc866-0fe9-42e5-a432-4715feb74acf	ALLEGRO	61829350-a2d0-11f0-abc1-17dd0035cfdf	89	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	5905806237795_1.jpg	2025-10-06 17:22:22.377839	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1343.00	1343.00	\N	ONLINE	f	{"id": "61829350-a2d0-11f0-abc1-17dd0035cfdf", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17358916449", "name": "Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir", "external": {"id": "5905806237795"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T16:22:54.591Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
112	6b972d73-4f87-4cd0-9950-acd81563fd74	ALLEGRO	aa78ce30-a2cb-11f0-8144-0ba8ff5b8d19	8	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	1	326.00	PLN	\N	\N	5905806237191_1.jpg	2025-10-06 17:22:22.597949	Szafka na buty VB60x30D1N1 Dąb Estana	326.00	326.00	\N	CASH_ON_DELIVERY	f	{"id": "aa78ce30-a2cb-11f0-8144-0ba8ff5b8d19", "tax": null, "offer": {"id": "16724404597", "name": "Szafka na buty VB60x30D1N1 Dąb Estana", "external": {"id": "5905806237191"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T15:48:52.071Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
113	cf942176-b813-433c-b529-fb6a5ea1153c	ALLEGRO	c2fa28c0-a2b5-11f0-abc1-17dd0035cfdf	10	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	5905806202250_1.jpg	2025-10-06 17:22:23.443624	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	399.00	399.00	\N	ONLINE	f	{"id": "c2fa28c0-a2b5-11f0-abc1-17dd0035cfdf", "tax": null, "offer": {"id": "14387669377", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202250"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T13:12:14.933Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
117	b768b4b0-f684-4eb1-b9d6-12ee29fa1134	ALLEGRO	6d5d7120-a07a-11f0-a6cc-b3145592fdde	62	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	2025-10-06 15:45:06.545374	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	510.00	510.00	\N	CASH_ON_DELIVERY	f	{"id": "6d5d7120-a07a-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "15048053205", "name": "Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny", "external": {"id": "5905806205435"}, "productSet": null}, "price": {"amount": "510.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T17:01:10.863Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "510.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
122	d053430d-76a6-455b-ae76-95a2193997e2	ALLEGRO	9a46abc0-a2d2-11f0-a6cc-b3145592fdde	19	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	5905204699089_1.jpg	2025-10-06 17:22:21.955482	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1332.40	1332.40	\N	CASH_ON_DELIVERY	f	{"id": "9a46abc0-a2d2-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508168", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY", "external": {"id": "5905204699089"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T16:43:54.949Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
120	666e5522-dbf1-4f72-9511-6d4a560353df	ALLEGRO	90c2b400-a0fb-11f0-bfbd-d3aacc6a2e00	76	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	2025-10-06 17:22:42.667603	Komoda Bones 60x36D1N1 LANCELOT	\N	\N	\N	\N	f	\N	0
126	bad6ef66-ff8c-452a-b800-5152956c6631	ALLEGRO	42c47ec0-a0f9-11f0-baf0-af7ea74e3d0e	78	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	423.00	PLN	\N	\N	5905806202403_1.jpg	2025-10-06 17:22:43.087375	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	\N	\N	\N	\N	f	\N	0
119	8f75bc05-3ba7-4023-8fd5-84e5d0b5768e	ALLEGRO	37e02660-a114-11f0-9e86-bf15ec8cf3e6	53	14563824746	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	1	278.00	PLN	\N	\N	5905806203585_1.jpg	2025-10-06 17:22:42.460682	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	\N	\N	\N	\N	f	\N	0
121	5d8e3f78-d944-41ed-8b40-6d0c74fb60d8	ALLEGRO	03b81770-a066-11f0-aafc-c30e0e10a738	\N	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	5905806201871_1.jpg	2025-10-06 13:12:02.680534	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	\N	\N	\N	\N	f	\N	0
125	c70850e4-3b5c-493e-b860-b5ae544df2f8	ALLEGRO	d0b22790-a0fa-11f0-b1e3-b7ce882fc700	77	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	1	510.00	PLN	\N	\N	5905806204087_1.jpg	2025-10-06 17:22:42.879744	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	\N	\N	\N	\N	f	\N	0
127	438b86e4-2289-4d3d-8c1c-385c51d967e3	ALLEGRO	e0e56600-a0f4-11f0-8323-6df02f435f6c	79	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	1	521.00	PLN	\N	\N	5905806221923_1.jpg	2025-10-06 17:22:43.502874	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	\N	\N	\N	\N	f	\N	0
128	8b4b6f50-d933-4fc6-ac80-14dcbb2c00c1	ALLEGRO	2febe8b0-a0e5-11f0-96ea-bf4f56b08af2	81	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	1	443.00	PLN	\N	\N	5905806216813_1.jpg	2025-10-06 17:22:43.709715	Szafka na buty VB80x30D1N2 LANCELOT	\N	\N	\N	\N	f	\N	0
130	933b430a-e977-4963-9618-52c7190b7332	ALLEGRO	45619110-a0a7-11f0-a6cc-b3145592fdde	82	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	2025-10-06 17:22:43.916719	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	423.00	423.00	\N	ONLINE	f	{"id": "45619110-a0a7-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14387674903", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN", "external": {"id": "5905806202427"}, "productSet": null}, "price": {"amount": "423.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T22:22:14.923Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "423.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
23	55660f82-8870-46b4-beb2-5b3a193ab248	ALLEGRO	93baa580-a233-11f0-a6cc-b3145592fdde	26	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	1	205.00	PLN	\N	\N	\N	2025-10-06 17:22:27.365276	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	205.00	205.00	\N	ONLINE	f	{"id": "93baa580-a233-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14705411728", "name": "Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma", "external": {"id": "5905806203790"}, "productSet": null}, "price": {"amount": "205.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T21:48:39.331Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "205.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
72	8fe91da7-4ba0-45cc-a46d-da5031612ed2	ALLEGRO	bcdce580-a1f8-11f0-a6cc-b3145592fdde	49	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	1	205.00	PLN	\N	\N	\N	2025-10-06 17:22:32.515181	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	205.00	205.00	\N	ONLINE	f	{"id": "bcdce580-a1f8-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "13463849818", "name": "Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot", "external": {"id": "5905806203813"}, "productSet": null}, "price": {"amount": "205.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T14:43:45.396Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "205.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
124	87a310f9-9326-41bf-8d57-50921f97af43	ALLEGRO	01540950-a122-11f0-9d66-3d00eb1ccfed	74	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	1	423.00	PLN	\N	\N	\N	2025-10-06 17:22:42.030751	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	423.00	423.00	\N	ONLINE	f	{"id": "01540950-a122-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14387674513", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO", "external": {"id": "5905806202397"}, "productSet": null}, "price": {"amount": "423.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T13:01:25.649Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "423.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
132	6f3db238-e720-4c99-894e-b5661937a5b5	ALLEGRO	2f4df840-a067-11f0-9d66-3d00eb1ccfed	\N	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	1	793.10	PLN	\N	\N	\N	2025-10-06 15:16:09.26268	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	793.10	793.10	\N	ONLINE	f	{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696167", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały", "external": {"id": "5905806208566"}, "productSet": null}, "price": {"amount": "793.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T14:45:19.720Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "793.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}	0
18	e5313940-bbfe-4bd1-8ef0-b82e3a14462e	ALLEGRO	95525591-a1bc-11f0-a6cc-b3145592fdde	57	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	1	600.00	PLN	\N	\N	\N	2025-10-06 17:22:37.344062	Szafka na buty z szufladą Tres 80x36D1N1 Biały	600.00	600.00	\N	ONLINE	f	{"id": "95525591-a1bc-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11750247503", "name": "Szafka na buty z szufladą Tres 80x36D1N1 Biały", "external": {"id": "5905806214208"}, "productSet": null}, "price": {"amount": "600.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T07:28:22.122Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "600.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
97	2bfcaf2a-8a07-4fda-8c31-00cfbd5e74fe	ALLEGRO	4a945dd0-a123-11f0-a6cc-b3145592fdde	36	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	2025-10-06 17:22:41.581542	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	326.00	326.00	\N	ONLINE	f	{"id": "4a945dd0-a123-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14384928066", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202038"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T13:09:42.312Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
68	65272b9b-89e1-49e4-a831-e607e403d7ca	ALLEGRO	6699c980-a122-11f0-baf0-af7ea74e3d0e	\N	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3	3.00	PLN	\N	\N	\N	2025-10-06 17:22:41.788842	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3.00	9.00	\N	ONLINE	f	{"id": "6699c980-a122-11f0-baf0-af7ea74e3d0e", "tax": null, "offer": {"id": "17532641274", "name": "Nóżka 2cmN1 z tworzywa sztucznego CZARNY", "external": null, "productSet": null}, "price": {"amount": "3.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T13:03:04.693Z", "quantity": 3, "vouchers": [], "discounts": null, "originalPrice": {"amount": "3.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
123	65272b9b-89e1-49e4-a831-e607e403d7ca	ALLEGRO	6699c981-a122-11f0-baf0-af7ea74e3d0e	73	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	1	58.00	PLN	\N	\N	\N	2025-10-06 17:22:41.788842	Siedzisko tapicerowane 50x29cm do szafki 50x30	58.00	58.00	\N	ONLINE	f	{"id": "6699c981-a122-11f0-baf0-af7ea74e3d0e", "tax": null, "offer": {"id": "16625973548", "name": "Siedzisko tapicerowane 50x29cm do szafki 50x30", "external": {"id": "5905806222531"}, "productSet": null}, "price": {"amount": "58.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-04T13:03:04.693Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "58.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2056	cebeb4c3-fbbb-4ba7-9245-712dc19c1b3d	ALLEGRO	\N	69	14387674355	5905806202380	\N	2	\N	PLN	\N	\N	\N	2025-10-09 19:57:47.115851	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	423.00	846.00	PL	ONLINE	f	{"id": "b2861eb0-9e03-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "14387674355", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY", "external": {"id": "5905806202380"}, "productSet": null}, "price": {"amount": "423.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T13:48:54.042Z", "quantity": 2, "vouchers": [], "discounts": null, "originalPrice": {"amount": "423.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2057	c1724024-75d2-4311-a6e5-80f7be0f6fb4	ALLEGRO	\N	21	14384926745	5905806201994	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:48.530965	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	326.00	326.00	PL	ONLINE	f	{"id": "a5d22450-9dfb-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "14384926745", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "external": {"id": "5905806201994"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T12:49:35.958Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2058	64e00aaf-9980-43ed-811d-cbd58c0c3cbd	ALLEGRO	\N	219	15155167503	5905806208443	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:49.929815	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1391.00	1391.00	PL	ONLINE	f	{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155167503", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN", "external": {"id": "5905806208443"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T12:06:04.215Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2059	9eac2b45-c379-4173-a727-f5c610f0f048	ALLEGRO	\N	7	14384927614	5905806202014	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:51.326497	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	326.00	326.00	PL	ONLINE	f	{"id": "420f5111-9def-11f0-8498-f546d68c9b4c", "tax": null, "offer": {"id": "14384927614", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN", "external": {"id": "5905806202014"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T11:19:40.875Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2060	71b075d9-68e5-446d-b48e-4d83d416f231	ALLEGRO	\N	253	12476571569	5905806213560	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:52.868974	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	788.00	788.00	PL	ONLINE	f	{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571569", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905806213560"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T11:16:56.685Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "BUNDLE"}], "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
2061	71b075d9-68e5-446d-b48e-4d83d416f231	ALLEGRO	\N	28	10814138050	5905806200027	\N	1	\N	PLN	\N	\N	\N	2025-10-09 19:57:52.868974	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	314.00	314.00	PL	ONLINE	f	{"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10814138050", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806200027"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T11:16:56.685Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "BUNDLE"}], "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}	0
\.


--
-- Data for Name: orders; Type: TABLE DATA; Schema: commerce; Owner: neondb_owner
--

COPY commerce.orders (id, order_number, order_code, source, source_order_id, order_date, status, buyer_login, buyer_email, buyer_company, buyer_first_name, buyer_last_name, buyer_phone, buyer_address, buyer_zip, buyer_city, buyer_country_code, payment_id, payment_status, payment_type, payment_provider, payment_amount, payment_currency, delivery_method, delivery_amount, delivery_currency, total_to_pay_amount, total_to_pay_currency, buyer_notes, invoice_required, tracking_numbers, raw_payload, created_at, updated_at, buyer_company_name, delivery_address, refund_amount, has_returns, billing_address, shipments, refund_date, refund_reconciliation, payment_last_date, billing_zip, billing_city, billing_country_code, tax_id, smart, allegro_pay, odoo_order_id) FROM stdin;
30365a40-4659-4c20-b1fa-f4c543794907	175	AL-175	ALLEGRO	ebc198d0-a21d-11f0-a6cc-b3145592fdde	2025-10-05 19:03:54.029	SENT	iwonab1991	oqirqn49b9+69c4a1767@allegromail.pl	\N	Iwona	Wróbel	+48 607 580 233	Borowa 591, 39-305 Borowa	39-305	Borowa	PL	ec064307-a21d-11f0-a417-fd831f6ae8ec	PENDING	ONLINE	PAYU	1320.00	PLN	Allegro Kurier DPD	0.00	PLN	1320.00	PLN	\N	f	\N	{"id": "ebc198d0-a21d-11f0-a6cc-b3145592fdde", "note": null, "buyer": {"id": "15338578", "email": "oqirqn49b9+69c4a1767@allegromail.pl", "guest": false, "login": "iwonab1991", "address": {"city": "Borowa", "street": "Borowa 591", "postCode": "39-305", "countryCode": "PL"}, "lastName": "Wróbel", "firstName": "Iwona", "companyName": null, "phoneNumber": "+48 607 580 233", "preferences": {"language": "pl-PL"}, "personalIdentity": null}, "status": "READY_FOR_PROCESSING", "invoice": {"address": null, "dueDate": null, "features": null, "required": false}, "payment": {"id": "ec064307-a21d-11f0-a417-fd831f6ae8ec", "type": "ONLINE", "features": [], "provider": "PAYU", "finishedAt": "2025-10-05T19:03:54.029Z", "paidAmount": {"amount": "1320.00", "currency": "PLN"}, "refundDate": null, "refundAmount": 0, "reconciliation": null, "refundReconciliation": []}, "summary": {"totalToPay": {"amount": "1320.00", "currency": "PLN"}}, "delivery": {"cost": {"amount": "0.00", "currency": "PLN"}, "time": {"to": "2025-10-10T21:59:59.999Z", "from": "2025-10-09T22:00:00Z", "dispatch": {"to": "2025-10-08T21:59:59.999Z", "from": "2025-10-08T21:59:59.999Z"}, "guaranteed": null}, "smart": true, "method": {"id": "c3066682-97a3-42fe-9eb5-3beeccab840c", "name": "Allegro Kurier DPD"}, "address": {"city": "Borowa", "street": "Borowa 591", "zipCode": "39-305", "lastName": "Wróbel", "firstName": "Mariusz", "modifiedAt": null, "companyName": null, "countryCode": "PL", "phoneNumber": "+48607580233"}, "pickupPoint": null, "cancellation": null, "calculatedNumberOfPackages": 3}, "revision": "819b5836", "discounts": [], "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16602433072", "name": "Komoda Bini 50x30x82 D1N1 BIAŁY", "external": {"id": "5905806234473"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:03:50.665Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16276316851", "name": "Komoda Bini 60x30D1N1 BIAŁY", "external": {"id": "5905806233896"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:03:50.665Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "16602435582", "name": "Komoda Bini 80x30x82 D1N1 BIAŁY", "external": {"id": "5905806234596"}, "productSet": null}, "price": {"amount": "550.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-05T19:03:50.665Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "550.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}], "shipments": [{"id": "RFBEOjEwMjY5Njg5MzM3MDVV", "waybill": "1026968933705U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.233Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM4OTNV", "waybill": "1026968933893U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.513Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM5MTZV", "waybill": "1026968933916U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.755Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}], "updatedAt": "2025-10-05T19:03:54.029Z", "surcharges": [], "fulfillment": {"status": "SENT", "shipmentSummary": {"lineItemsSent": "ALL"}}, "marketplace": {"id": "allegro-pl"}, "customerReturns": [{"id": "9037a8be-bd1d-479e-8972-8079f851b162", "buyer": {"email": "mt8uc79f2q@allegromail.pl", "login": "AnetaJ5"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-120x36cm-v60-supra60-4-panele-d1-bia-12258666208?navCategoryId=20277&snapshot=MjAyMi0wNy0zMVQxOToxNToxMy45NDhaO2J1eWVyO2I0MTAzNzg0MTk0MTVmM2FmN2I0OWI0NTE5ZmMyMDQ5ODhiYjYzZjk5MWQyZmE2ODBmNTJkNDZjMGRjMDZkMzg%3D", "name": "Garderoba 120x36cm V60 Supra60 4 Panele D1 BIA", "price": {"amount": "1520.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12258666208", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "123a1b21-1105-11ed-bbd3-6b6427496643", "parcels": [], "createdAt": "2022-08-08T09:56:34.909Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "843O/2022"}, {"id": "3696892f-343b-46df-81f8-0218da362d4e", "buyer": {"email": "iqdmyduvcp@allegromail.pl", "login": "brzozowiak"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x36cm-v60-supra30-4-panele-d1-bia-12266508168?navCategoryId=20277&snapshot=MjAyMi0wOC0xNVQxNzowMzo1NS43MDhaO2J1eWVyOzE5Y2QwMTkwYjI0YzQ0NDdiOTQyY2VhNDM5NzZmMTM1ZTVmNzJhYzdjNjg0YjQ3NjkxNjMxYjA3N2RiNGQ5YjA%3D", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 BIA", "price": {"amount": "1070.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266508168", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "01bd3581-1cbc-11ed-ac22-050cfff5b55a", "parcels": [{"sender": {"phoneNumber": "+48512156149"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-08-22T08:07:17.036Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-08-20T11:46:40.951Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8563/2022"}, {"id": "b9777c6a-3f46-462e-ba34-7f1d71311c00", "buyer": {"email": "jjz4fhqhwq@allegromail.pl", "login": "Client:46616004"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x30d-siedzisko-schowek-80cm-lan-11678695472?navCategoryId=20277&snapshot=MjAyMi0wOC0xNFQwODo0MDo1Ni41MTlaO2J1eWVyOzk0NGVjMGYzOTk1OGFjZTA0OTkzYzQ2MGI3ZDI4NWUzNWYyN2EyYWYyM2ViOWU5NjI5NTNjMmU1YjY0MWY3MzI%3D", "name": "Szafka na buty V80x30D siedzisko schowek 80cm LAN", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Witam! Jestem zmuszona odesłać szafkę-paczkę,ponieważ towart dotarl uszkodzony. Jest to dosyć widoczna wada której nie da się ukryć niestety. Posiadam zdjęcia,  chętnie dołączę jako dowód. "}, "offerId": "11678695472", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "c9e0c831-1bac-11ed-b010-71e7783f672c", "parcels": [{"sender": {"phoneNumber": "+48513223042"}, "waybill": null, "carrierId": "INPOST", "createdAt": "2022-08-23T21:18:26.546Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-08-23T21:16:55.415Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK75/2022"}, {"id": "b0e4aeb2-2439-4c44-acb4-ba6d12b7d495", "buyer": {"email": "tqkklxdqiy@allegromail.pl", "login": "Client:29046140"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-slupek-polus172x30so-11873228248?navCategoryId=20277&snapshot=MjAyMi0wOC0xOVQyMTowODoxOC42ODhaO2J1eWVyOzk1YzhlMDMzMzdmNTVlN2VjZDE0ZTMyMGM1MzkyMjQwOTgwMDNmM2I2NDE2N2NlODZiM2ExNmM5NzQ0YmVkMjM%3D", "name": "Szafka na buty słupek polus172x30SO", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11873228248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d481e761-2002-11ed-a4b6-2796c774bfb5", "parcels": [], "createdAt": "2022-08-29T12:51:02.077Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y22/2022"}, {"id": "2b336b61-73ac-4a92-8d68-9544381d1349", "buyer": {"email": "3a4h2rloz1@allegromail.pl", "login": "sylwox"}, "items": [{"url": "https://allegro.pl/oferta/zestaw-100x30d2alt-szafka-na-buty-z-siedziskiem-so-12041568683?navCategoryId=20277&snapshot=MjAyMi0wOC0xNlQxODowMjo0OC42NDBaO2J1eWVyO2IyZTQ0ZWFmZjhkMjA2NGY3NTBlZDk3NjQ1Y2U4MjNlMmFiY2M3Nzc2YmRiZGE3NzFlNWYxZWIwMzVhYjBkMGU%3D", "name": "Zestaw 100x30D2Alt szafka na buty z siedziskiem SO", "price": {"amount": "638.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12041568683", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "7ab4fff1-1d8d-11ed-8746-65bb8d4a51d3", "parcels": [{"sender": {"phoneNumber": "+48509128006"}, "waybill": "00159007738162485158", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-09-02T15:40:44.695Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-02T15:40:02.728Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7RP/2022"}, {"id": "7436e8db-3eb9-4557-b90c-d504303ed267", "buyer": {"email": "pond179l0b@allegromail.pl", "login": "kluska333"}, "items": [{"url": "https://allegro.pl/oferta/szafka-nocna-40x36-nox1-biala-2-szuflady-schowek-12154681943?navCategoryId=20294&snapshot=MjAyMi0wOC0yOFQxNzoyNjoyNy45OTFaO2J1eWVyO2M3NWQ4MTdjN2FhZDBmMjk3MGI1Zjk5YmU2ZWI1MmYzNDhhYmNiNzA4ZjdiNjBiMjcxM2Q0NWMwOTc1NGJjOWI%3D", "name": "Szafka nocna 40x36 nox1 biała 2 szuflady schowek", "price": {"amount": "229.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12154681943", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8992e831-26f6-11ed-a0b8-5531037899f2", "parcels": [{"sender": {"phoneNumber": "+48517400028"}, "waybill": "1000495009540U", "carrierId": "DPD", "createdAt": "2022-09-03T11:40:25.752Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-03T11:39:17.277Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L6X3/2022"}, {"id": "42d43332-20d2-4bf9-98c3-bb569cdaa3e7", "buyer": {"email": "z434ha736n@allegromail.pl", "login": "Client:88668947"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0wOC0xNVQyMDozMToxMi4yOTlaO2J1eWVyOzg5NmRlNjgzNDYzNmZmMDlkZTk5MTZiMzQ3YTUyNWRlZmE2ZGM0Mzc4NWYxZTUzOTBkODQ2ODJhZmRhODllZDM%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "afa9fc22-1cd8-11ed-a6bc-458a8cca5908", "parcels": [{"sender": {"phoneNumber": "+48517983628"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-09-04T18:00:57.489Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-04T17:58:19.844Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8X2R/2022"}, {"id": "ac5263ab-b444-48dc-aa2e-ce40e525527f", "buyer": {"email": "e6n38stpdu@allegromail.pl", "login": "Client:64409347"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-80x36cm-v50-supra30-4-panele-d1-bia-12487657175?navCategoryId=20277&snapshot=MjAyMi0wOC0yNFQxODo0MDoxOS4xMjVaO2J1eWVyO2EyZGRiZTFiYzU5ZjlmNDZhN2EzMDlmNWVlNGMzYzQxMmM5OTJjM2FlNWRkN2Y5Zjk3ZDc5ODIxNmU5ZmFhNGQ%3D", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIA", "price": {"amount": "1035.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12487657175", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "cec99201-23db-11ed-9f12-63118f43da94", "parcels": [], "createdAt": "2022-09-21T14:07:44.392Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G52/2022"}, {"id": "6eff5044-f08b-4287-966f-0ff1c62eede9", "buyer": {"email": "gpa98c2hji@allegromail.pl", "login": "Client:43343932"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?snapshot=MjAyMi0wOS0yMVQwNzo0NjoyOC4zNzZaO2J1eWVyOzI1MDdiODRlMzViMzcxMzZiYWJlMzVlOGY0MTBlMTVjZWQ4ZTg3YmVjYzFlMTUxOGJiZmM1MTU5NzRhZDFlNWY%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "659c9b42-3981-11ed-bf70-e5b1e9d32a61", "parcels": [], "createdAt": "2022-09-26T17:27:12.811Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NOM/2022"}, {"id": "964f3da7-3941-44d4-a957-9578d730e2ec", "buyer": {"email": "8dio0bnx8c@allegromail.pl", "login": "mateuszkunc"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0wOS0yMVQxMToxMjowOC43NDhaO2J1eWVyO2Y2Y2EzZjAyNjY4ZDE2NWQzZTUzOGZiY2JlOGFiNGM5MTM2NzM4OGI2MzA4MThjMmY1MzFmY2M1M2U4NWUzYzQ%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "2b74bc01-399e-11ed-80fa-a764c95d1596", "parcels": [{"sender": {"phoneNumber": "+48692303083"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-09-27T05:16:56.973Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-27T05:16:40.260Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LR2X/2022"}, {"id": "ad218913-f0e0-4254-8d69-36ba3b6babcf", "buyer": {"email": "70ilwbxbk3@allegromail.pl", "login": "goldencars77"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-60x30-wieszak-wp60-d1-lan-12273961847?navCategoryId=20277&snapshot=MjAyMi0wOS0xOVQwOTo0OTozMy4zNjdaO2J1eWVyOzRlOGZkZWRkMTRkMTU0ZGQzZWJmYWNiNWIxYmE4ODUzZWZmYmYwZjE4ZTExOGIwMDQ0ZjY1NGUxYjIwMGY3Zjg%3D", "name": "Szafka na buty One 60x30 Wieszak WP60 D1 LAN", "price": {"amount": "448.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12273961847", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "5012acb1-3800-11ed-ba15-3da8e39304ec", "parcels": [{"sender": {"phoneNumber": "+48733228928"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-09-27T09:54:54.384Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-27T09:54:42.506Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PXW/2022"}, {"id": "af8796cd-0f17-4048-937c-54e81c408fb0", "buyer": {"email": "wjma2m8fn9@allegromail.pl", "login": "lukbzl"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?snapshot=MjAyMi0wOS0yNlQwMDowNjoxMy40OTBaO2J1eWVyO2I1NGE3YzgxMWI1ZjQ1YzIxYWMxZGE2OGUxMDY5MTA5ZTVlYzg4NzZkMzZlZWViODIzMmQxNDYxZTk5MGQ1YWQ%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "e339a831-3d2e-11ed-9dd9-690772a53f55", "parcels": [{"sender": {"phoneNumber": "+48795851697"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-10-03T08:04:53.810Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-03T08:04:38.359Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L27X/2022"}, {"id": "fd426ad2-1810-4464-8d9b-a4bde313083d", "buyer": {"email": "omm307xqu8@allegromail.pl", "login": "arczi-44"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-lan-12266500390?navCategoryId=20277&snapshot=MjAyMi0xMC0wOVQxMTo0ODo1MS4xNDhaO2J1eWVyOzNmMzIyNTc4NDkwNjBiM2EzMzg4MjdhNGI1MGRiYjYxMjY4ZTRmZWFiMWU4MzY5NThlZGRmYzNjZjBiMWQ0YzI%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 LAN", "price": {"amount": "1080.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266500390", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "071b89f1-47c8-11ed-b85f-fbad9a675357", "parcels": [{"sender": {"phoneNumber": "+48514365028"}, "waybill": "1000514200092U", "carrierId": "DPD", "createdAt": "2022-10-17T08:47:34.562Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-17T08:47:05.700Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LWNK/2022"}, {"id": "16b3d7b4-9ba5-43b6-b280-d962050048a5", "buyer": {"email": "p9m7et5w27@allegromail.pl", "login": "Client:39195287"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-lan-12266500390?navCategoryId=20277&snapshot=MjAyMi0wOS0xOFQxMTo1MDo0Ni40ODVaO2J1eWVyOzE5YjA4YjhjODcyMjAxNTM3ODQyYWIxYjQ4MmMxNDliYWE5OGRiZTk2NGRiMGViYjBmODQzY2IxMGNmYjRhZDU%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 LAN", "price": {"amount": "1030.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266500390", "quantity": 1}], "refund": null, "status": "FINISHED", "orderId": "aa703741-3747-11ed-a287-9993c5228f05", "parcels": [{"sender": {"phoneNumber": "+48577304469"}, "waybill": "00159007738204662981", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-10-19T16:42:58.224Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-19T16:41:35.050Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8MR3/2022"}, {"id": "841c2067-717b-425f-a930-be93713b6363", "buyer": {"email": "tiokpbn9vp@allegromail.pl", "login": "Krycha_WNC"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-bia-12170501801?navCategoryId=112735&snapshot=MjAyMi0xMC0xN1QxMzoxODozNy43NTFaO2J1eWVyO2Y3OWY2YmYyYmZjZmYyNDU1NDZmNjM4NGUyZDc3Y2JiMTE2YzcwYTEyN2QyZjE3YjdjYTc5NjZmMWU0N2E5MzE%3D", "name": "Komoda z szufladami Vini4 80x30 BIA", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "TRANSPORT", "userComment": "1 róg paczki uszkodzony i w związku z tym wiekszość elementów w tym damym rogu uszkodzone"}, "offerId": "12170501801", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "1bd89e81-4e1e-11ed-9836-e9431026e850", "parcels": [{"sender": {"phoneNumber": "+48517196487"}, "waybill": "1000519636388U", "carrierId": "DPD", "createdAt": "2022-10-29T11:52:23.185Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48517196487"}, "waybill": "1000519636663U", "carrierId": "DPD", "createdAt": "2022-10-29T11:56:46.036Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-29T11:51:30.313Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L367/2022"}, {"id": "7025b2b2-df86-4add-9748-53d60efa0929", "buyer": {"email": "cmr0kr2n5a@allegromail.pl", "login": "mateo4121"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp50-na-ubrania-50cm-4-uchwyty-11711221934?navCategoryId=112733&snapshot=MjAyMi0xMC0yMlQyMDoyMzowNi40MzRaO2J1eWVyO2NjMmNiMjY5MzQ5M2ViNTFjNmEwNTkxNWU1YjlmN2EyNWY2NzlhNzhiMGU2NjQ0YTljMjIwZTdjMGM3ZTNkODU%3D", "name": "Wieszak ścienny WP50 na ubrania 50cm 4 uchwyty", "price": {"amount": "189.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11711221934", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "2f365940-5247-11ed-9f13-6140442851ad", "parcels": [{"sender": {"phoneNumber": "+48723880905"}, "waybill": "00159007738212115370", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-10-29T20:09:01.099Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-29T20:08:32.894Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "89OQ/2022"}, {"id": "796a3f95-9a93-476b-bc4b-06870400b563", "buyer": {"email": "nsbqf55joh@allegromail.pl", "login": "szaara"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-60x36-lan-12158046796?navCategoryId=20291&snapshot=MjAyMi0xMC0yNFQxOTowODoyNS42NTZaO2J1eWVyOzIwMDUwZWQzZjQwNTJjNWI3ZTEyYTIzMjI5NDJkNTQwMjI2MTc5ZTE3NDhhOWVkNTAyYmZjM2JjMzBkNjcxODA%3D", "name": "Komoda z szufladami Vini4 60x36 LAN", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12158046796", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "2c1235c0-53cf-11ed-ad2f-d9ae8869133d", "parcels": [{"sender": {"phoneNumber": "+48795787497"}, "waybill": "1000523057970U", "carrierId": "DPD", "createdAt": "2022-11-07T17:44:27.240Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-07T17:44:16.934Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8J7N/2022"}, {"id": "350accdf-2f2e-4518-9703-81c17973eea9", "buyer": {"email": "vkzd2zi0o1@allegromail.pl", "login": "Client:38978633"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-lan-11678652560?navCategoryId=20277&snapshot=MjAyMi0xMC0yM1QyMDoxMzo0Ny43NDZaO2J1eWVyOzVmMDgyMTczZGNmZjNmNjdmNGI4NjllYTEwOGY3Njg4ODgwMDJmYzc3NGVkYjZmYzhhOTNiM2VjMDAyMTA4ZDc%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm LAN", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11678652560", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "0a049240-530f-11ed-94a3-d1d83f561bb5", "parcels": [{"sender": {"phoneNumber": "+48660010000"}, "waybill": "1000524813781U", "carrierId": "DPD", "createdAt": "2022-11-11T09:45:45.399Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-11T09:45:27.765Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LZ2X/2022"}, {"id": "e64eecd1-b4c1-407e-be32-e3500038a752", "buyer": {"email": "nq0a6rl2rz@allegromail.pl", "login": "aniaparys92"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v60x30d-siedzisko-schowek-60cm-bc-10814131958?navCategoryId=20277&snapshot=MjAyMi0xMS0wMVQyMDo0ODowMi4wMDhaO2J1eWVyOzA0NzZjYjU5N2E4YmIwOWE1NjVlMTk5ZjA3MWZhOTg0NDg1NDUyMTkzMmExNDdlOTEwYmE3NDE2ZmVhNjJmMmI%3D", "name": "Szafka na buty V60x30D siedzisko schowek 60cm BC", "price": {"amount": "269.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Dzień dobry, w drzwiach szafki brakuje nawierconych otworów do przykrecenia zawiasow, instrukcja jest zupełnie nieczytelna, a rysunki są pomieszane."}, "offerId": "10814131958", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9ec36a10-5a25-11ed-ab7d-a7a418932807", "parcels": [{"sender": {"phoneNumber": "+48695546925"}, "waybill": "1000526731158U", "carrierId": "DPD", "createdAt": "2022-11-15T19:42:21.242Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-15T19:31:36.804Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L1GM/2022"}, {"id": "cbdce904-b973-418b-9231-2bba4b55b205", "buyer": {"email": "7nrpshnp9g@allegromail.pl", "login": "Leszel100"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMi0xMC0yOVQxOToyOTo1OS4zMjNaO2J1eWVyOzY5NDFiODY5ZGQ2ZWUyM2M2NzkyZjQ1ZDVhMjRjN2YyNjAyNzE2NzJiNmM0ZTQ3ODA0ZGNiOTA0MzQ2MTJmMzQ%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8457a5a0-57bf-11ed-9622-c3b1df87d802", "parcels": [], "createdAt": "2022-11-16T18:39:04.532Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8QP0/2022"}, {"id": "8171342b-f50a-4536-9932-ee5f5fe4ffb2", "buyer": {"email": "3g63pbzr14@allegromail.pl", "login": "rafdam79"}, "items": [{"url": "https://allegro.pl/oferta/zestaw-komoda-vini4-wieszak-panele-60x30-lan-12208750516?navCategoryId=20277&snapshot=MjAyMi0xMS0xM1QyMDoxMTowNC42NzVaO2J1eWVyOzJlNDc4MjhmNDdkNDE4YTQ1ZjViZWI4MTFkODE2NDQzZDZhY2E3YTRjMmY3ZmU3ZWVlNTIzMjA4ZDM1Y2UxMjE%3D", "name": "Zestaw Komoda Vini4 Wieszak Panele 60x30 LAN", "price": {"amount": "715.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12208750516", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "31b2ada0-638f-11ed-bd0d-fbeadcc384de", "parcels": [], "createdAt": "2022-11-17T09:35:42.317Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "80KG/2022"}, {"id": "ccdd54b8-6266-4116-984b-32eff10f0e63", "buyer": {"email": "m6p6dzi9h5@allegromail.pl", "login": "Client:50180365"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0xMS0xM1QxODowNDoyNC4xNDlaO2J1eWVyOzI3MmQxMjVkMzllZTk2ZGJmNTk2MWEwNTkyMmI4Y2IxZDRjNTQzMjNiODgwZjg0MjM3ZDE0NDA2Y2EyNDNkNDU%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8e20f5e0-637d-11ed-a5bf-a1baed429958", "parcels": [{"sender": {"phoneNumber": "+48535356862"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-11-24T06:49:48.406Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-24T06:49:41.197Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8O02/2022"}, {"id": "2d39cb92-4896-40ad-90cf-93fbbe1028dd", "buyer": {"email": "8ouqzrpefl@allegromail.pl", "login": "rodzynst88"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0xMS0wOFQwODoxNjoyNi4xNjJaO2J1eWVyOzZmNmIxMTkwOGJiMjAxZjhhNDA0MGFhMTFiZDJkZThmODhmOTdmMWYwYTM2YjIyNGQ4NDQxNDgxOWU3MjdjMTM%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "NOT_AS_DESCRIBED", "userComment": "Otrzymalam szafkę z szufladami zamiast szafkę na buty po rozmowie telefonicznej poinformowałam o zwrocie całkowitym zamówienia."}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "a0d87ee0-5f3d-11ed-8665-f3171c0e5f4b", "parcels": [{"sender": {"phoneNumber": "+48723565937"}, "waybill": "00159007738231974910", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-11-25T07:12:03.181Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-25T07:11:52.833Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "84XO/2022"}, {"id": "670863bc-3d06-4372-a9d9-6daf77c02266", "buyer": {"email": "cygwqpwyku@allegromail.pl", "login": "Joanna_ao10"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-lan-11678652560?navCategoryId=20277&snapshot=MjAyMi0xMS0xM1QxMjoxNzowMy43OTdaO2J1eWVyO2IxOTc2ZGZiZDY5NzdiYjg2ZTM5NWI0MWMyODQxM2RmNTY2YTVkNGY4NzQzMTA4MjZjNDA2OWI5Y2RmOTMxOGQ%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm LAN", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11678652560", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "b7d8b390-634c-11ed-a9e7-3ba9e926e6a9", "parcels": [{"sender": {"phoneNumber": "+48667268908"}, "waybill": "00159007738232650813", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-11-25T17:25:54.609Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-25T17:25:19.383Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8593/2022"}, {"id": "7a92d46b-4431-46fe-a5d5-ebda3a0eecfb", "buyer": {"email": "6n61ehm917@allegromail.pl", "login": "kamillo24buzka"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMi0xMS0yMlQxODozNTo0Ny4zMDdaO2J1eWVyOzVmNzFkMTYxNWQ4MmQ3OGI5ZWMzNDRjMGI4YjZlYTk3OTU1MjBjMWU3ZjUwZjAxMjkxMGE5ODRhNmEyN2FkNzE%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "56fa1f10-6a94-11ed-8683-75174dc2f989", "parcels": [{"sender": {"phoneNumber": "+48534812563"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-11-28T17:31:01.049Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-28T17:30:17.279Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LKX5/2022"}, {"id": "e7c533e0-fe77-4e66-ab8f-190a0b94a2d8", "buyer": {"email": "s1blkn1in7@allegromail.pl", "login": "ani1350"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v100x30d-siedzisko-schowek-100cm-so-11906888620?navCategoryId=20277&snapshot=MjAyMi0xMS0yNFQyMDoxOToyMC41NjNaO2J1eWVyOzMzZjFhNzMyNjU0YmJkYWE2NjAxN2Q5MWM0MmM1ZGRlYjdiMDE1ZTVlMWZjNjY1OTEwNTM0ZmI4ZDgxODE1YzA%3D", "name": "Szafka na buty V100x30D siedzisko schowek 100cm SO", "price": {"amount": "420.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11906888620", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "cc778ec1-6c34-11ed-b3f6-45a0d4a034f0", "parcels": [{"sender": {"phoneNumber": "+48693812018"}, "waybill": "00159007738243291616", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-12-07T20:04:42.177Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-07T20:02:16.145Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y32/2022"}, {"id": "b3b8b480-3bbf-4967-8389-55899c650c55", "buyer": {"email": "vc8eyrm4eu@allegromail.pl", "login": "dawidwet88"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-80x82x30-lan-12154906046?navCategoryId=20277&snapshot=MjAyMi0xMS0yM1QxMDowMjo1Ni4yMjJaO2J1eWVyO2RhOTFlMTUyOGM2NGFhOWI5YTliMmU3YWFhMGUzMTE0ZTEyOGM4MGYwYTk2ZDA3NzcwODU0MzUwMDM3NjVkYWI%3D", "name": "Szafka na buty z szufladą Tres 80x82x30 LAN", "price": {"amount": "439.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12154906046", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "ede868b0-6b15-11ed-b111-1f0e8ec9f686", "parcels": [{"sender": {"phoneNumber": "+48603953164"}, "waybill": "0000027592342T", "carrierId": "DPD", "createdAt": "2022-12-12T20:34:44.426Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-10T14:08:13.609Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7PP/2022"}, {"id": "af42b5a1-de82-4772-aae1-f167d515f1e4", "buyer": {"email": "sgs3j7xmku@allegromail.pl", "login": "miklisanna"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-lan-11678652560?navCategoryId=20277&snapshot=MjAyMi0xMS0zMFQxMDo1MjowMy41NTBaO2J1eWVyOzU0N2UwNDVkMmM2ZGFmODE2ODJmZjY1ZDU4OTdmNTQyMDE1NzQyZDkyMjYyMTNhM2FhZDM2ZWUxMTVkNmU1YmE%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm LAN", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11678652560", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?navCategoryId=20277&snapshot=MjAyMi0xMS0zMFQxMDo1MjowMy41NTBaO2J1eWVyOzM5NDljZGU4ZmYwZWFiNzhiNDZmOGFmMDhlMzdkMzliZWU5NWQ2ZDZkNWU2YjJkYzI3Y2M3ZmU3NTJlZmNmNDU%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d97a1860-709c-11ed-b9b0-f169eca286af", "parcels": [{"sender": {"phoneNumber": "+48791337706"}, "waybill": "00159007738254998061", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-12-19T16:04:42.896Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48791337706"}, "waybill": "00159007738256950159", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-12-22T16:31:51.265Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-19T16:03:09.363Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L693/2022"}, {"id": "77b565af-1f6d-4ea7-92f8-5509b71293a2", "buyer": {"email": "uubyqh5cdu@allegromail.pl", "login": "petuniekicia"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-60x30x80cm-altus4-bc-4polki-10862942640?navCategoryId=20277&snapshot=MjAyMi0xMS0yNVQwOTo0Mjo0MS4yNTRaO2J1eWVyOzFhOTBjMjRkY2ZmNzdkYWFlYWFmZWYzYTIxZDc4ZTg4MDc1NWRlYTI3Yjc5NzQ4YWQ3YzM5ODBiOTQwOGFjZjA%3D", "name": "Szafka komoda na buty 60x30x80cm Altus4 BC 4półki", "price": {"amount": "419.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10862942640", "quantity": 1}, {"url": "https://allegro.pl/oferta/zestaw-komoda-vini4-wieszak-panele-60x30-bia-12208749919?navCategoryId=20277&snapshot=MjAyMi0xMS0yNVQwOTo0Mjo0MS4yNTRaO2J1eWVyO2JmZWRkMzI4MDIxMDc4ODg0MjVjMGMxYTAxOGJlZDFhNzI1MDBmMGJkNzIzOTY0YTkxN2RiMjA4NWE5NjUzNjM%3D", "name": "Zestaw Komoda Vini4 Wieszak Panele 60x30 Bia", "price": {"amount": "715.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12208749919", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "ab1aa580-6ca4-11ed-81e9-ab20b1a39a8c", "parcels": [], "createdAt": "2022-12-22T12:35:40.835Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8X1R/2022"}, {"id": "8745db07-3f1e-423f-845b-0d453b37adde", "buyer": {"email": "533h2rsks8@allegromail.pl", "login": "rucia_2005"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x80x20-na-wezglowie-11769317928?snapshot=MjAyMi0xMi0wMlQxMjozMzoyMS41NjRaO2J1eWVyOzhkOGEyN2IyMTY2Y2YzMGI0OWJkMzk1NDE2MjQ0N2ZkNGE0NGMwMDg5YTNhN2IwNjUzNDk2YTlmZTc2M2EyZjU%3D", "name": "Panel ścienny tapicerowany pan1x80x20 na wezgłowie", "price": {"amount": "55.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11769317928", "quantity": 4}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "23123240-723d-11ed-97c9-e5fe31a8f0fc", "parcels": [{"sender": {"phoneNumber": "+48506457925"}, "waybill": "1000548350054U", "carrierId": "DPD", "createdAt": "2022-12-29T15:22:21.405Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-29T15:21:45.105Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8GK2/2022"}, {"id": "88b0189c-99b6-4a52-bdae-71ec5da7bd5b", "buyer": {"email": "tv81p57q0h@allegromail.pl", "login": "ogrodniczka7"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMi0xMi0xM1QxMjozNjowMS4wODVaO2J1eWVyOzFiNTM3NmJkZGY0NWQxMDNhOTNmZDlhNmQ5YTI5MjhhYWQ4ZjQ3NThjYTEyNGIxOTFlMDcxYTYwNWQ3ZDY3OTM%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}, {"url": "https://allegro.pl/oferta/wieszak-scienny-wp60-na-ubrania-60cm-5-uchwytow-10983158854?navCategoryId=112733&snapshot=MjAyMi0xMi0xM1QxMjozNjowMS4wODVaO2J1eWVyO2JmNDE5MjhjMDMxMzkyMzRhNTMxNWJlZTU5YTFhNmQ5NWM2ZjExNjMxN2Y3NDFjNGJlOGIyOWQzZGM1NTllOGY%3D", "name": "Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów", "price": {"amount": "199.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10983158854", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8bbb14f0-7ae0-11ed-933b-b3536ecd1b4d", "parcels": [{"sender": {"phoneNumber": "+48512072331"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-01-03T09:44:11.988Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-03T09:43:43.947Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8538/2023"}, {"id": "3192c306-e364-4ea5-943f-e19d5a08c0fb", "buyer": {"email": "4nvydm1gqs@allegromail.pl", "login": "mirsaw"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp60-na-ubrania-60cm-5-uchwytow-10983158854?navCategoryId=112733&snapshot=MjAyMy0wMS0wMVQxNzozMDoxOS4zNDM1NDJaO2J1eWVyO2E0Njk2MjM5MjU5YjNhMWE2YTdiMWFiMGYzNWNjZTZiYzYxOGRhZTg3M2ZiMDYwM2NkYTZiOGNlOGI1YjFmNzU%3D", "name": "Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów", "price": {"amount": "199.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10983158854", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "dc93d010-89f9-11ed-80d8-51cfcf6129a4", "parcels": [{"sender": {"phoneNumber": "+48601440142"}, "waybill": "1000550092359U", "carrierId": "DPD", "createdAt": "2023-01-04T15:04:01.751Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-04T15:01:23.553Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK5L/2023"}, {"id": "15e8fbdf-381d-4d21-a697-d7c8b9fd391b", "buyer": {"email": "zahv6z2si5@allegromail.pl", "login": "wrzesinscy_1"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-w80-na-ubrania-80cm-bialy-11711339631?navCategoryId=112733&snapshot=MjAyMy0wMS0xMFQxOTo0MDo1NS4zNjA5ODFaO2J1eWVyOzE2ODY1ZDJlMmM1MjY3ZTRjOGEzM2ZjNmRjOGEzOWUyM2RlOTUzMzA5MjU1ZmM0ZjhiMmI4Zjg4ZmE3YzY5ZDU%3D", "name": "Wieszak ścienny W80 na ubrania 80cm Biały", "price": {"amount": "179.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11711339631", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "9f4b1de0-911e-11ed-a39c-6f420a96a03d", "parcels": [{"sender": {"phoneNumber": "+48607192203"}, "waybill": "00159007738267011207", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-01-16T15:40:07.166Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-16T15:39:48.147Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y2L/2023"}, {"id": "8aaafc7a-9079-4a88-903f-f2964700e6c8", "buyer": {"email": "i350fhry3b@allegromail.pl", "login": "Client:49665756"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x30d-siedzisko-schowek-80cm-so-10862742707?navCategoryId=20277&snapshot=MjAyMy0wMS0xMlQxNjowMzowOC4zNDQ1MzlaO2J1eWVyO2FiODBiYWJmMzJhNjk3Mzk0ZGY5NDI0MzE3Mzk5ZTRjYmI5MDk0ZmVhNjA0MTA3Zjc4MjU0MDEyMTZiMGUxYjQ%3D", "name": "Szafka na buty V80x30D siedzisko schowek 80cm SO", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10862742707", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "82fc5990-9292-11ed-8c13-b16aa31c2d9b", "parcels": [{"sender": {"phoneNumber": "+48665277671"}, "waybill": "1000554708950U", "carrierId": "DPD", "createdAt": "2023-01-17T15:33:41.629Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-17T15:32:23.877Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7P8/2023"}, {"id": "21fd7306-dfbc-4096-bac0-99a06803d4f9", "buyer": {"email": "fuh12469fq@allegromail.pl", "login": "NoFearProXic"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-50x30-bia-12170502124?navCategoryId=112735&snapshot=MjAyMy0wMS0yNlQxMTozMTo0OS4xOTUwMTdaO2J1eWVyOzY3ZDIwY2IxY2Y1Y2VmZDEyMDQzMjk4NjRkNzYxMzVhNTJiZGFlNWI1YWNmYTkzMjA3NzZkODU3YTYyMDlhMDg%3D", "name": "Komoda z szufladami Vini4 50x30 BIA", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12170502124", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "e91e9dc0-9d6c-11ed-b4cc-3799265c3a16", "parcels": [{"sender": {"phoneNumber": "+48533499505"}, "waybill": "1000557970532U", "carrierId": "DPD", "createdAt": "2023-01-26T11:36:41.339Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-26T11:36:30.841Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L638/2023"}, {"id": "fa93d739-43b7-4c1b-8fb6-d80800e0d5b0", "buyer": {"email": "oe7g3c4dms@allegromail.pl", "login": "Client:41397258"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-120x36cm-v60-supra60-4-panele-d2-bia-12256752651?navCategoryId=20277&snapshot=MjAyMy0wMS0wOVQyMDowNjo1Mi43NDM2NzZaO2J1eWVyOzI3MDNkZjIxNDhiMjUxMGI1MDhiZDAwOTU2YTYyNDAxNDFiMzIxMTk0MmY5OGYxYmU4OGJjNDZmNjAyMzdkNjc%3D", "name": "Garderoba 120x36cm V60 Supra60 4 Panele D2 BIA", "price": {"amount": "1590.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12256752651", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "14a944c0-9059-11ed-8948-1ff3e631d098", "parcels": [{"sender": {"phoneNumber": "+48796169780"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-01-26T16:59:12.801Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-26T12:10:25.451Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8XR8/2023"}, {"id": "b44d6172-d0cd-476a-b5e0-9dffd36fefd7", "buyer": {"email": "sfkq36w8ar@allegromail.pl", "login": "Dom993"}, "items": [{"url": "https://allegro.pl/oferta/zestaw-100x30d2alt-szafka-na-buty-z-siedziskiem-bi-12041613245?navCategoryId=20277&snapshot=MjAyMy0wMS0yOVQxMToyMDo0Mi4yNzQ4NDJaO2J1eWVyO2Q4MWEyYWQ3ZTgwMTAwNmRmNDlhYTkxZjQ4YjgxMGNjOWZlMDBjNDA1NWFhNDM5YzBkYzBhM2IxYmViZmU3ZDE%3D", "name": "Zestaw 100x30D2Alt szafka na buty z siedziskiem BI", "price": {"amount": "638.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12041613245", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "cade4a20-9fc6-11ed-b60a-b171142c24de", "parcels": [{"sender": {"phoneNumber": "+48694128480"}, "waybill": "00159007738279029221", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-02-13T15:39:20.863Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-11T13:57:51.769Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G2L/2023"}, {"id": "86a7e875-0f33-4fef-a28d-b220fb73b699", "buyer": {"email": "dkgxi4osvy@allegromail.pl", "login": "GERMANMOTORS"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-lan-12170497248?navCategoryId=112735&snapshot=MjAyMy0wMi0wOFQyMDoxMjowOS4zNzYyNDlaO2J1eWVyO2JkMDA2ZGNiZDQ5ZWJhNTlkODM4M2FkMzJiZGJlMDVhMDY0YmZiNzYwMjY4NWFmYTY2YWViNzgwZGNiMWQyZjc%3D", "name": "Komoda z szufladami Vini4 80x30 LAN", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12170497248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "ca841e50-a7ec-11ed-b0d9-b1ab253f2ccf", "parcels": [{"sender": {"phoneNumber": "+48502965197"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-02-15T09:40:25.053Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-15T09:40:08.303Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NML/2023"}, {"id": "7a7dbea1-d135-4529-b014-fa862733bc54", "buyer": {"email": "aelip00irp@allegromail.pl", "login": "diana_0502"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-w60-na-ubrania-60cm-sonoma-11711327105?navCategoryId=112733&snapshot=MjAyMy0wMi0xNVQxNjozMzo0OS44ODEzNTRaO2J1eWVyOzRkYjYyZDA3NDQyMDgyNGMwNTAxZTA3ODMwODhkN2YzOTY3YWYzZGVlNDczYmEyNGU0ZTZiMmNlODYwNGU0ZTY%3D", "name": "Wieszak ścienny W60 na ubrania 60cm Sonoma", "price": {"amount": "159.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11711327105", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "6b548930-ad4e-11ed-b35a-7b06533a7a06", "parcels": [], "createdAt": "2023-02-20T18:38:05.016Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LRXL/2023"}, {"id": "d6fa469c-ec60-4f6e-ab62-25f8923becd7", "buyer": {"email": "u4ltuwo0wy@allegromail.pl", "login": "tomaszy"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-leo50x30-siedzisko-szuflady-d2-bia-12248274556?navCategoryId=20277&snapshot=MjAyMy0wMi0yM1QxOTo0MToxNC41MzUzNDZaO2J1eWVyOzc4NDJiYWRkYzRmMTc0MDgzMjYyYzZkNTA0ODNiNDZiMzQ1NTkzYmYwZDFmMjA4Y2M4OGVmZGRjYWVmMThmM2Y%3D", "name": "Szafka na buty Leo50x30 siedzisko szuflady D2 BIA", "price": {"amount": "279.00", "currency": "PLN"}, "reason": {"type": "OTHER_FLAW", "userComment": "brak kontaktu ze sprzedającym mimo mojego monitu odnośnie zamówienia , wysyłałem sms, dzwoniłem telefonicznie , pisałem wiadomości że jest błąd w zamówieniu , żadnego odzewu , ale fakturę wystawiono czyli ktoś pracuje , nie rozumiem takiego podejścia do klienta , w wiadomości do sprzedającego wpisywałem kolor obszycia ciemny grafit ( żona świadkiem siedziała obok podczas zamawiania) po otrzymaniu maila że jest realizowanie zamówienie ale z innym obszyciem sprawdziłem że mojej informacji nie ma ."}, "offerId": "12248274556", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "d52776b0-b3b1-11ed-a014-35a5e4462688", "parcels": [{"sender": {"phoneNumber": "+48502976966"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-02-25T19:13:23.972Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-25T19:12:21.842Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PWL/2023"}, {"id": "246e5f9e-4fa6-4e0e-8508-0e735aaaf992", "buyer": {"email": "hk3m146o0g@allegromail.pl", "login": "Client:46221542"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v60x36d-siedzisko-schowek-60cm-bc-10862764095?navCategoryId=20277&snapshot=MjAyMy0wMi0xMFQwNzoyNjozNS42MjMwOTlaO2J1eWVyO2UwM2MxYmUwM2MxZTk2MTMyOWI2NzRlYzRkZDQ2YzczMmM2NDI1ZDVmOTQzOTJhZmNiZjJlYjM0NjI5NmI5OTY%3D", "name": "Szafka na buty V60x36D siedzisko schowek 60cm BC", "price": {"amount": "289.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10862764095", "quantity": 1}], "refund": null, "status": "FINISHED", "orderId": "0cae5310-a912-11ed-85d6-f358e0aad7a0", "parcels": [{"sender": {"phoneNumber": "+48722430500"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-02-27T22:38:56.354Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48722430500"}, "waybill": "0000028537824T", "carrierId": "DPD", "createdAt": "2023-03-05T21:36:20.417Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-27T22:34:18.609Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L2XL/2023"}, {"id": "9f699a2e-a8c4-48ee-aea2-c67540c1fa25", "buyer": {"email": "jh6uqa919z@allegromail.pl", "login": "Pielegniareczka8"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x60x35-11769356716?navCategoryId=258819&snapshot=MjAyMy0wMi0yNlQxNDozMDowMC4wMzE5MDBaO2J1eWVyOzkyOWZmZTM1YTgwYzQyODFiMmM3NmFhN2NiMzcyYjE1NmJhMzgwYWVmM2UyODZlNzZlOTE2N2FiZWEyMGIxN2E%3D", "name": "Panel ścienny tapicerowany pan1x60x35", "price": {"amount": "55.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11769356716", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-na-buty-v60x36d-siedzisko-schowek-60cm-bc-10862764095?navCategoryId=20277&snapshot=MjAyMy0wMi0yNlQxNDozMDowMC4wMzE5MDBaO2J1eWVyOzRkMTFkYTg4YWMwMmQzMjVkYTQ3Mjg1OGU1MGU1NTI4ZDU5YjJkNzg0ZWI4N2JjNThjYWNmYzZhMDdiZGFlMmQ%3D", "name": "Szafka na buty V60x36D siedzisko schowek 60cm BC", "price": {"amount": "289.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10862764095", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x36x82-bia-12266463826?navCategoryId=20277&snapshot=MjAyMy0wMi0yNlQxNDozMDowMC4wMzE5MDFaO2J1eWVyOzAxMTQ0ZDIxZGU4NDcwMmU0OWU1N2Q2MGFhOTM3NDhkM2U2NjhiOGZmMTJlOWIzNjFmZmNjNGE1N2EwYTkxZmQ%3D", "name": "Szafka na buty z szufladą Tres 30x36x82 BIA", "price": {"amount": "205.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266463826", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "7ae01bd0-b5e1-11ed-96e3-ed7d5c9f46d7", "parcels": [{"sender": {"phoneNumber": "+48506848585"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-03-02T07:38:12.099Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-03-02T07:23:04.834Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LWKL/2023"}, {"id": "71491f86-5073-45a7-b9cd-0bbdd053d683", "buyer": {"email": "2e5zj2fmig@allegromail.pl", "login": "bogdandumala"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-bia-12170501801?navCategoryId=112735&snapshot=MjAyMy0wMy0wMVQxNjo1ODoxMC4xOTE1MjVaO2J1eWVyO2I2MmVjMGEwOGQyZDliYmY0ZDNjMjkxZDE4OWViZWZhYzU0YmU1NGZlYTVlYzYwYTcyNDZmN2M4YjIzODQzMDE%3D", "name": "Komoda z szufladami Vini4 80x30 BIA", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12170501801", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "3a0e05e0-b852-11ed-b651-3791ad49b98e", "parcels": [], "createdAt": "2023-03-08T13:35:11.182Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8M38/2023"}, {"id": "b5ffa941-615e-459b-9fc3-5792a211b330", "buyer": {"email": "fm6zaxabo8@allegromail.pl", "login": "Client:41974733"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-leo80x30-siedzisko-szuflady-d2-bia-12248368429?navCategoryId=20277&snapshot=MjAyMy0wMy0yOFQwNzoyMjo1Mi4wNzU4NDJaO2J1eWVyOzRjMmM2MjNhYjY3YTM3ZWU0YTk4Y2ExOWIwYTYwMzY4OWJmM2ZjZTZmMGE5N2E3NzRlNjhkYzc2YWI1OTBhNWY%3D", "name": "Szafka na buty Leo80x30 siedzisko szuflady D2 BIA", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12248368429", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "90e060c0-cd38-11ed-bc78-39c77bbc1a0b", "parcels": [], "createdAt": "2023-04-01T10:01:13.672Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L37L/2023"}, {"id": "25827ffa-20c8-48b9-b46c-5c73c4e92cbf", "buyer": {"email": "v4cxfvokme@allegromail.pl", "login": "lemandrole"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-so-12266500239?navCategoryId=20277&snapshot=MjAyMy0wMy0xN1QxNDoxNToyMS42MjAzNTZaO2J1eWVyOzQzODY0MzkwZjljZmViYzg4MDA4MzA4YmZlNjNiM2IwYzI3NTViYjRjNzZjYWEyNjlmOWUwYWM1M2RiZjc0YTg%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 SO", "price": {"amount": "1080.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266500239", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "0d52ca30-c4ce-11ed-9d26-33cba196705d", "parcels": [{"sender": {"phoneNumber": "+48606412119"}, "waybill": "00159007738293411156", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-04-05T08:18:50.368Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-04-05T08:18:26.820Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "89Q8/2023"}, {"id": "a9a933ee-933d-456b-bd92-0a3c5ea735db", "buyer": {"email": "zio1c9b51w@allegromail.pl", "login": "dimmu113"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x36p2wpb-szafka-na-buty-wieszak-panele-11743135331?navCategoryId=20277&snapshot=MjAyMy0wMy0zMFQxMjoyMzoxNS40MzIxOTVaO2J1eWVyOzA0ODM2ZTdlYTI2NjBkZWFkNGI5MGFiMTg3ZmVjOTdhYzgyMjk5MTc0MzkwNWUxMGJkNDZjNmUyODY2NjAyZGE%3D", "name": "Garderoba 50x36P2WPB szafka na buty wieszak panele", "price": {"amount": "550.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11743135331", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "296eccb0-cef5-11ed-8a5f-017a3724e12e", "parcels": [], "createdAt": "2023-04-17T14:28:55.028Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8JN8/2023"}, {"id": "5821905b-adf8-4d65-b846-9f727669d6e2", "buyer": {"email": "et9evk0hpa@allegromail.pl", "login": "Client:37533616"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-80x30x80cm-altus4-so-4polki-10862972212?navCategoryId=20277&snapshot=MjAyMy0wMy0zMFQxOToyNToxMi4yMDYwMDFaO2J1eWVyO2UxZDZiNDNiNzZjYmE2ZDcwYTlmNjNhNWUwODc5NDMyZWQ1MzdlODM2OTRlMDdiZDE0YzRjMjdhM2ExYTliY2U%3D", "name": "Szafka komoda na buty 80x30x80cm Altus4 SO 4półki", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10862972212", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "f0d61d51-cf2f-11ed-804f-b95d23bee293", "parcels": [{"sender": {"phoneNumber": "+48502579089"}, "waybill": "1000590532594U", "carrierId": "DPD", "createdAt": "2023-04-19T20:32:59.495Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48502579089"}, "waybill": "00159007738296634309", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-04-24T13:01:52.238Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-04-19T18:45:06.131Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LZXL/2023"}, {"id": "449808e3-d941-4325-90ef-738444b23ed3", "buyer": {"email": "lx4yrj55ny@allegromail.pl", "login": "katnos"}, "items": [{"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-60x36x202d1-lan-12263595440?navCategoryId=20277&snapshot=MjAyMy0wNS0xNVQwOTozMjozNS41NTA4NjhaO2J1eWVyOzQ3ZjcyYTdhNzVhY2RmMjgxYTZiYjJmNzNjZDdjNjQ3ODAyOWQ1NzMxNjgxYTExZTU5MTRlMjc2YjcyYWE5ZWI%3D", "name": "Szafka szafa komoda wysoka supra T 60x36x202D1-LAN", "price": {"amount": "869.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12263595440", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "79b124d0-f302-11ed-967e-adbeefcaaec4", "parcels": [{"sender": {"phoneNumber": "+48504710944"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-05-23T11:17:09.296Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-05-23T10:38:15.493Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L1ML/2023"}, {"id": "30de3631-9e38-4bd3-a43a-7f3d9e6306d7", "buyer": {"email": "3q9p9vjfpk@allegromail.pl", "login": "gienekgut102"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-60x30-d2-sonoma-12208159616?navCategoryId=20277&snapshot=MjAyMy0wNS0yNVQyMDowODo0My4yNzA2NTdaO2J1eWVyOzcyMWVjNTFiZmNlNjJjODM3Mzc4YmJjM2M4ZjY2MmJmNDRlNmFhZjQxOTMzZWQ3NGYwOWE5MGI3NDgwYTA2MjY%3D", "name": "Szafka na buty z szufladą Tres 60x30 D2 Sonoma", "price": {"amount": "499.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12208159616", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "375da350-fb37-11ed-bb71-a3f983f3b2ab", "parcels": [{"sender": {"phoneNumber": "+480505397063"}, "waybill": "00159007738300655740", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-06-05T16:36:58.715Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-06-04T18:23:51.819Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Q0L/2023"}, {"id": "2684a2bb-6a65-46da-9164-882153aa9662", "buyer": {"email": "bap2nlz7gv@allegromail.pl", "login": "mumin201413"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?navCategoryId=20277&snapshot=MjAyMy0wNi0xMFQxMToyNzo1NS4yNTM2NjJaO2J1eWVyO2IxZDRhYzA5NWEwZDVhNWNiN2M1ZGEzY2M1MGVmYzQyZjA0YzU3N2FhYTg4Mjk1NGRmNWU4MDJkMWMyNmEwYTM%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "c45674c0-0781-11ee-9dff-930f60850fef", "parcels": [{"sender": {"phoneNumber": "+48667069198"}, "waybill": "00159007738301484752", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-06-24T09:12:02.069Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-06-24T09:11:44.253Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "80GL/2023"}, {"id": "45991f08-cb60-40ca-b86f-1c5addff085a", "buyer": {"email": "axrsjz8t52@allegromail.pl", "login": "Client:101347531"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x36p2wpb-szafka-na-buty-wieszak-panele-11743135331?navCategoryId=20277&snapshot=MjAyMy0wNi0xMlQxMDo1NzoyMy4wNzY3MDFaO2J1eWVyOzYyYTNiN2U3MTY0YTI5ZTkyNjkxYjUzMWY4MTA5YjQ0MDdhNTVhMmY1ZDgwYjVjNTE0YTk5YTQzNGVhNWU2Mjk%3D", "name": "Garderoba 50x36P2WPB szafka na buty wieszak panele", "price": {"amount": "550.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11743135331", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-60x36x202d1-lan-12263595440?navCategoryId=20277&snapshot=MjAyMy0wNi0xMlQxMDo1NzoyMy4wNzY3MDVaO2J1eWVyOzQwMTg4NzMxZWI1OWNhNjlmZTA3MjgzOGU2MWQ0NTUxODg2YjVlOWVkYWZkNzllZGQxNDg1MTljYTZiZDViYTA%3D", "name": "Szafka szafa komoda wysoka supra T 60x36x202D1-LAN", "price": {"amount": "869.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12263595440", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "bdb550c0-090f-11ee-b26a-63d4d6710586", "parcels": [], "createdAt": "2023-06-25T10:29:19.034Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8O2L/2023"}, {"id": "54c09af5-6276-4b88-afc3-17753020f9b6", "buyer": {"email": "e0fm1d8zmp@allegromail.pl", "login": "Client:102638027"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-panele-11743127497?navCategoryId=20277&snapshot=MjAyMy0wNi0xOVQxODo1NzozOC4xNjMwODBaO2J1eWVyOzI3OWU4ZGFmOWYxYmMyYjFkNWZhYzZlMjUzZWNmZjcyMDYyZDZiZTlhYjVjYmQ5ZTc2Njk3ZTViZTFmNzYzYzU%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak panele", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11743127497", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "7ccaca90-0ed2-11ee-8ca6-e5ccdc8341ed", "parcels": [], "createdAt": "2023-06-26T17:51:56.768Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "841O/2023"}, {"id": "e5334b3c-66ae-441d-a9be-37aa4b9b676e", "buyer": {"email": "gc3vdcm2uw@allegromail.pl", "login": "mipweiss"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp50-ubrania-50cm-4-haki-lancelot-13463849818?navCategoryId=112733&snapshot=MjAyMy0wNi0yM1QxNDo1Mjo0MC4wMzI3NzQ0MDVaO2J1eWVyOzFjYjQ3YmMxNjc1MTQ0NWU4YjkyNTBhNjFhMzY1NTc0NGMyYWE5ODE0N2QxZGY0YjE5ZDZlOTdmN2ZiMmYwODY%3D", "name": "Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot", "price": {"amount": "189.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "13463849818", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "850e09a0-11d5-11ee-9b0d-f1f8bf5a1afa", "parcels": [{"sender": {"phoneNumber": "+48721812120"}, "waybill": "1000619916788U", "carrierId": "DPD", "createdAt": "2023-07-03T11:29:12.689Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-07-03T11:27:14.068Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8533/2023"}, {"id": "02f337c6-b973-4479-81b7-f3c9639c78b5", "buyer": {"email": "kvrjdcy31j@allegromail.pl", "login": "15DD"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x36-sonoma-11873255183?navCategoryId=20277&snapshot=MjAyMy0wNy0wN1QxMTozMzo1My45NzMyOTkyOTZaO2J1eWVyOzhiNjMwNGE1NzhlYTJkODZlNGI2YTk2ODMyYjFiYmJmZWY1MzczNzk1OGFiNGU5M2E4MjliMWQ2NTM4ODQzMDQ%3D", "name": "Szafka na buty z szufladą Tres 50x82x36 SONOMA", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11873255183", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "fb59adf0-1cb9-11ee-8dd2-9da167ce05a3", "parcels": [{"sender": {"phoneNumber": "+48696763737"}, "waybill": "1000623028175U", "carrierId": "DPD", "createdAt": "2023-07-11T05:34:12.274Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-07-11T05:33:34.631Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK25/2023"}, {"id": "eb39e2b6-a330-4ca3-ab60-217d16e99b5b", "buyer": {"email": "9aouignyyw@allegromail.pl", "login": "Client:95430342"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v60x30d2-siedzisko-schowek-60cm-10945440206?navCategoryId=20277&snapshot=MjAyMy0wNy0wOFQxMzowMjo1MS4zMTE1NzIzMzlaO2J1eWVyO2Y3Njg0MDY5NTI1OTQ5YTQ4ZjcxMWIzNTVkNzg4Mzk2M2VmZGE3ZjU5MzA0OWFhYzAxNTEzNTY0OTZjOGFkNGM%3D", "name": "Szafka na buty V60x30D2 siedzisko schowek 60cm", "price": {"amount": "289.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10945440206", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "5c075fa0-1d8f-11ee-a0ae-b1fbbfc07fa7", "parcels": [{"sender": {"phoneNumber": "+48693720998"}, "waybill": "0000030077553T", "carrierId": "DPD", "createdAt": "2023-07-13T10:07:42.948Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-07-13T10:02:43.470Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8YQ2/2023"}, {"id": "fe543a53-b9bb-46d2-8111-b99f18070ef3", "buyer": {"email": "4opzn7ooam@allegromail.pl", "login": "Client:110217585"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-60x30x80cm-altus4-so-4polki-12147316429?navCategoryId=20277&snapshot=MjAyMy0wNy0yM1QxNTowNDowMy4yODk3MTM0MzdaO2J1eWVyO2NmNWEyMzYwNDk1ZmJmZjc1ZTg1YTgzNmY1YmU2YjJiZTE0ODNjZTE1NTBmZjRkNzljOTZhYmI3NTBjZTYxMDE%3D", "name": "Szafka komoda na buty 60x30x80cm Altus4 SO 4półki", "price": {"amount": "419.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12147316429", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "1182a1b0-296a-11ee-8279-9da167ce05a3", "parcels": [], "createdAt": "2023-07-26T14:45:40.887Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7JP/2023"}, {"id": "ba17c5b0-e84b-4787-b876-b20c66c998a6", "buyer": {"email": "9e3d418xgl@allegromail.pl", "login": "Client:108118240"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x30x82-bia-12266463730?navCategoryId=20277&snapshot=MjAyMy0wOC0wNVQwOTowMDoyMS44MzYxNTU4MDRaO2J1eWVyOzBmYjYzZTcxMjMwMGY0MzNlYWZlOWIxYmFmMzlhZTVhNjdmMDM3YTI0MTlmNDQ3ZmM3ZmUwNGEzMWQ5YTFkOWQ%3D", "name": "Szafka na buty z szufladą Tres 30x30x82 BIA", "price": {"amount": "195.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12266463730", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "56168681-336e-11ee-84cd-a915ead073d8", "parcels": [{"sender": {"phoneNumber": "+48883145916"}, "waybill": "1000636294395U", "carrierId": "DPD", "createdAt": "2023-08-12T22:36:18.690Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-08-12T22:35:34.902Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L6N3/2023"}, {"id": "fec44e5f-05d1-41fd-9a95-1751ca5b4ebe", "buyer": {"email": "g3p5tr7clq@allegromail.pl", "login": "athlon63"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-wieszakiem-60x30wp60-s2d1-cza-wot-13877637961?navCategoryId=20277&snapshot=MjAyMy0wOC0yMlQxNzoxMDoyNC41MzU0MjA5NDlaO2J1eWVyOzllMTMzYzJkNzNiMTk0NDBlNDlkZWRkN2E5YjliZDRjYmI3YmNlMzZiMjkyNTExNzM5YzdlNWQ5MmZlNWJjOWM%3D", "name": "Szafka na buty z wieszakiem 60x30WP60 S2D1 CZA-WOT", "price": {"amount": "548.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "13877637961", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d6b3baa0-410c-11ee-9739-b378715ebc84", "parcels": [{"sender": {"phoneNumber": "+48723504869"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-08-28T07:55:34.896Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-08-28T07:55:20.529Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8XKR/2023"}, {"id": "7bd44e5d-8df6-46f6-899c-3c0ff8a9c190", "buyer": {"email": "znoxgd90x1@allegromail.pl", "login": "rogalikja"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-so-12266500239?navCategoryId=20277&snapshot=MjAyMy0wOC0yN1QxODoxNjo0Ny4wNDMxMzY2MzVaO2J1eWVyOzlkNDRjZWNiYmViZjRjM2E5YWYxNDk1YzFhNDY1YTgyZTkxOTEwOTRmOTgxNGMzYzQ3MjViMmQwY2FmODIzNjE%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 SO", "price": {"amount": "1080.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266500239", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-60x82x30d1-so-12224099030?navCategoryId=20277&snapshot=MjAyMy0wOC0yN1QxODoxNjo0Ny4wNDMxMzY5NTZaO2J1eWVyO2ZhZGVlOTMwMzJkM2M3NWJmY2U5ZTJiYjAyMDMwYzRiYjI0OWJkMzJiNzg5NjE1ZDNkNDQ4MmFiOTUzMTZlNzQ%3D", "name": "Szafka szafa komoda wysoka supra T 60x82x30D1-SO", "price": {"amount": "839.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12224099030", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "bc02b0b0-4505-11ee-b1fc-8d501ab0fe91", "parcels": [{"sender": {"phoneNumber": "+48508201278"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-08-30T03:43:19.061Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-08-30T03:43:05.675Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G42/2023"}, {"id": "9a162908-a466-4e9b-bc2f-1f2ef444bd49", "buyer": {"email": "y0or79vjqy@allegromail.pl", "login": "matrix510"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-sonoma-11873232153?snapshot=MjAyMy0wOC0zMFQxMjozODowMy4xMjkyNDUwNjlaO2J1eWVyO2JmNzcxZDM0ODk1YTY4YzljZDI0YzcxZDYwYWJmM2VmMWY0YmJlNWNjZWMyODM3ZmE1YzQxZjE3OTQwM2EyYWI%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 SONOMA", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11873232153", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "01eed3f0-4732-11ee-9905-85ad35cb2fe9", "parcels": [], "createdAt": "2023-09-03T15:16:26.492Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NNM/2023"}, {"id": "6f5c2275-fdd4-4b70-9460-c573fab3defd", "buyer": {"email": "v4wjsu92o9@allegromail.pl", "login": "soundmv"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-bia-12170501801?navCategoryId=112735&snapshot=MjAyMy0wOC0yMFQxNTozMDowNC40MjcwMzc1NDRaO2J1eWVyOzM1YmU5ZGRjYmRjY2Q1Y2ZkY2NkODczNjE5M2NjNzE4ZTVhNDU0MTgwYWVkY2QzY2Y4ZjZjMDc5NmQyNDcyNWI%3D", "name": "Komoda z szufladami Vini4 80x30 BIA", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12170501801", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "57e67ea0-3f6e-11ee-a49c-cb75f3118c88", "parcels": [], "createdAt": "2023-09-05T06:57:24.780Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LRNX/2023"}, {"id": "e46259e3-b4e4-44fb-b7de-86440ffc659f", "buyer": {"email": "4jddg2xfzk@allegromail.pl", "login": "Client:37017348"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-150x30cm-szafka-na-buty-czarny-bialy-14019382790?navCategoryId=20277&snapshot=MjAyMy0wOC0yOFQwNjoxOTo1Mi44NzM1MzkzNDBaO2J1eWVyOzY1MGI3OGZkZjA0ZDMwMTQwYThiNTI0MDY3MzI0MTdhY2Q5NDM3N2JhMzk4MWQwNDM1ODE2YzdlOTFiYmJjM2U%3D", "name": "Garderoba 150x30cm szafka na buty Czarny Biały", "price": {"amount": "2040.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14019382790", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d39ac6d0-456a-11ee-b394-8b61ccf71fe7", "parcels": [{"sender": {"phoneNumber": "+48608166665"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-09-11T11:34:18.138Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-07T13:37:28.942Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PKW/2023"}, {"id": "a5c134e2-652b-4300-a71e-7a5aa5cd6b3b", "buyer": {"email": "cv6iy6hfgq@allegromail.pl", "login": "mcholast"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x36d2-siedzisko-schowek-80cm-10945458023?navCategoryId=20277&snapshot=MjAyMy0wOC0zMVQwOToyMTozMC44MjM1NDkzMThaO2J1eWVyO2FiYWQ4ZWNiZWI1MmJjYjQ1ZWQ5OWVlNWEwODQzZTc3ZDEwOGZiYjI4MTA5YzA4ZWU4YmM5NjJhN2MzYTJjMGY%3D", "name": "Szafka na buty V80x36D2 siedzisko schowek 80cm", "price": {"amount": "409.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10945458023", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "a56c6e90-47df-11ee-8241-c1f9a2c2127c", "parcels": [{"sender": {"phoneNumber": "+48601663058"}, "waybill": "0000030728320T", "carrierId": "DPD", "createdAt": "2023-09-07T15:57:56.370Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-07T15:55:32.977Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L2KX/2023"}, {"id": "2a814581-9ed0-469c-a40e-62d54950a231", "buyer": {"email": "6h995o9w56@allegromail.pl", "login": "Client:85949222"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-i-siedziskiem-60x30dp3b-11750362603?navCategoryId=20277&snapshot=MjAyMy0wOS0wM1QxNzoxMzozNC4wNzAyNDIyMTNaO2J1eWVyOzM0NzM0ZDEwOGQyYmM1ZWRjMzdlM2QyYjM2ZmEyNTM4NzI5OTJkYTczZGQwMWYyMWNiYWUyZTNlMWEzNjNjMmM%3D", "name": "Szafka na buty z szufladą i siedziskiem 60x30DP3B", "price": {"amount": "977.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11750362603", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "0b0c7fc0-4a7d-11ee-b1fc-8d501ab0fe91", "parcels": [{"sender": {"phoneNumber": "+48600178360"}, "waybill": "0000030776315T", "carrierId": "DPD", "createdAt": "2023-09-11T14:10:08.011Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-11T14:05:36.712Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LWJK/2023"}, {"id": "b28c560e-9f60-40c9-90bc-95dd782b0cee", "buyer": {"email": "lxg279ni4d@allegromail.pl", "login": "kriss1796"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-80x30cm-v50-supra30-4-panele-d1-bia-12487594410?snapshot=MjAyMy0wOS0yNVQwODoxMjoyMy4yMzk4MzIxNDJaO2J1eWVyO2FkZjFjZjk1YzJiYzIxMDE3ZWMwZGE1NDZhNzI4N2JkY2VkY2EyM2MzODgwMjUxNGRjM2JiNTk4M2NkNGZkYmE%3D", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA", "price": {"amount": "1049.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12487594410", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d6513240-5b79-11ee-830c-7d59f32dd4e6", "parcels": [{"sender": {"phoneNumber": "+48796227152"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-09-25T11:49:46.025Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-25T11:48:53.009Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8MX3/2023"}, {"id": "16dafb80-0c8d-4487-985d-6cf5111453f9", "buyer": {"email": "lk2ou3hv1o@allegromail.pl", "login": "36674398"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-so-10862725041?navCategoryId=20277&snapshot=MjAyMy0xMC0wMlQxMzozNDozNC4zNTAwNjc5MTdaO2J1eWVyOzM3ZjNmZGE5Yjk2MzBkMmI1M2U2MTAyMjgzZjIxMjlmMzFmZmMwNzU0YWU3NGQ0ZmI2MWExMGM1N2ZiNWUyYTc%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm SO", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10862725041", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "192008e0-6128-11ee-bbd6-1103d1757491", "parcels": [{"sender": {"phoneNumber": "+48664914912"}, "waybill": "1000659329417U", "carrierId": "DPD", "createdAt": "2023-10-06T14:06:25.821Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-10-06T14:00:21.852Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L307/2023"}, {"id": "01d2382e-691b-4bdf-8e44-ac1ae35bc1b4", "buyer": {"email": "28hkf1eot2@allegromail.pl", "login": "Client:100184163"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-supra-30-slupek-30x36-d1-bia-12266374192?navCategoryId=20277&snapshot=MjAyMy0xMC0wMVQxNjoyNjo0MC4yMzU0Mjc3NTZaO2J1eWVyOzY5MTcxMThlN2ZjYjQxYjBhNTkwMDBmZWUwYWUyYzA4NDA3ZTBhNmM5NWY0ZjI0NThlNmI2ZGRhMTk2NmM4MTU%3D", "name": "Szafka na buty Supra 30 słupek 30x36-D1-BIA", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266374192", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "3fcc6a80-6077-11ee-b19c-658ad462c24b", "parcels": [], "createdAt": "2023-10-06T18:52:00.365Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "899Q/2023"}, {"id": "df8d1696-7b67-4a26-b41b-c63be35faa6f", "buyer": {"email": "ngt6hoaips@allegromail.pl", "login": "Client:46288752"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-sonoma-14030767203?navCategoryId=20277&snapshot=MjAyMy0xMC0xM1QxMjo1MDoyNC44MDgyMDgzNjRaO2J1eWVyOzhkZGZiMWEyN2E4NjZlYmI5ODA0YWEzNDVmYTEyM2VmNTc1NWViN2ZiYjQ1YzdhZmUxNDJkODU0MzI2Mzg0YTQ%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak Sonoma", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "14030767203", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "958d98b1-69c6-11ee-955e-d544f30d6fa9", "parcels": [], "createdAt": "2023-10-16T13:20:03.231Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8J6N/2023"}, {"id": "8663bc18-6167-4faf-a38e-3ddaab8cb6fd", "buyer": {"email": "a296sg4rsa@allegromail.pl", "login": "Client:111318418"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x36p2wpb-szafka-na-buty-wieszak-bialy-14388158063?navCategoryId=20277&snapshot=MjAyMy0xMC0wNVQxODoyMToxMi40NTUwMzQyMTJaO2J1eWVyO2Q4ZjY1MTFlNTc2MzRkNzUxMjUwZGRmYTYyM2U3NmZlNGMwNWNlNmQ5YTk0NzZhNDExOTNhZGU4NjYzZjYxODI%3D", "name": "Garderoba 50x36P2WPB szafka na buty wieszak Biały", "price": {"amount": "449.00", "currency": "PLN"}, "reason": {"type": "OTHER_FLAW", "userComment": "Boki szafki nie pasują bo są dwa lewe\\nProszę o kontakt to jest mój numer telefonu \\n609586769"}, "offerId": "14388158063", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "cb6ba150-63ab-11ee-8260-77f5b5733a57", "parcels": [{"sender": {"phoneNumber": "+48609586769"}, "waybill": "0000031199976T", "carrierId": "DPD", "createdAt": "2023-10-18T17:34:03.330Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-10-18T17:26:21.738Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LZZX/2023"}, {"id": "9f6641cf-2820-49a0-a3fb-d682797e468b", "buyer": {"email": "3r4leruqq7@allegromail.pl", "login": "Kca09"}, "items": [{"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-50x30x202d1-bia-12476571569?navCategoryId=20276&snapshot=MjAyMy0xMC0wOVQxNTozNDozMC42ODI4MzM5NzdaO2J1eWVyOzQ5ZmIwZjJhZDgxNDZkNTg1N2E0NGQ2MmM3YjM1ZGM4ZjkzZDMwYTE0OTg1ZWE1YjhmYTAwMTNlOWQ5ZTE4ODU%3D", "name": "Szafka szafa komoda wysoka supra T 50x30x202D1-BIA", "price": {"amount": "788.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "12476571569", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "3023cea0-66b9-11ee-b166-35f9e46bff2b", "parcels": [{"sender": {"phoneNumber": "+48881695442"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-10-25T06:36:14.061Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-10-25T06:35:48.060Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L1YM/2023"}, {"id": "68e06b9e-ee45-45a4-802a-28d36ab3e3d3", "buyer": {"email": "23cj9uvljp@allegromail.pl", "login": "Karolciiia15"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMy0xMC0wN1QwNzo0NjoyMi45OTg5MDMzMTRaO2J1eWVyOzQ0M2E3NDcwNjNjMmY0N2Y4ZjljYTI3NDg1ZDdjZGE1OTViYThmZWVjOTY1YjQ4ZGM4ZDE4OGJkOWIxMDUxZjQ%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "f909e380-64e4-11ee-91a7-dfeb98527315", "parcels": [], "createdAt": "2023-10-27T06:44:34.571Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Q10/2023"}, {"id": "a2ebce36-503b-4fcc-9c87-9305518a5743", "buyer": {"email": "cld9zroxbf@allegromail.pl", "login": "dnmax"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb80x30d-s1-siedzisko-schowek-80cm-bialy-14387669377?navCategoryId=20277&snapshot=MjAyMy0xMC0xNlQxMDoyMzoxOC4zOTcxMjk2MTJaO2J1eWVyO2M3MjRhZDRmNGQyZDJmZjI4YTkxNWFiMjdiNDQ3YTJiY2RiN2JmZGRjZWIwOTRlZDQyMzVjN2U3ZmU1MmEzNjc%3D", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "14387669377", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "f2690e90-6c0d-11ee-9e26-1dfad1b952ef", "parcels": [{"sender": {"phoneNumber": "+48506019362"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-04T00:16:38.359Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-04T00:15:45.526Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "80MG/2023"}, {"id": "231bbc5e-c406-46e2-8e98-9b50b7f90cec", "buyer": {"email": "jn96fmicwm@allegromail.pl", "login": "qubeko"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp60-na-ubrania-60cm-lancelot-12196322651?snapshot=MjAyMy0xMC0yNFQxNTowOToxMy4xMzY5NjQzMTlaO2J1eWVyO2Y0MDkzZjhjNGVmNzUxNTk2OGQ3ZTZhYzEwYjQxZDA0MjlhNzI3MDIxNjhkZGM4MGE0MDRmNzJlODY0MjZhOWM%3D", "name": "Wieszak ścienny WP60 na ubrania 60cm Lancelot", "price": {"amount": "199.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12196322651", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "36ce5910-727f-11ee-948c-e3b8932a9b47", "parcels": [{"sender": {"phoneNumber": "+48608379166"}, "waybill": "1000671390679U", "carrierId": "DPD", "createdAt": "2023-11-04T07:06:34.978Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-04T07:04:37.934Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8OR2/2023"}, {"id": "c86dc6b6-a632-4b69-be03-63423b76d82c", "buyer": {"email": "3lraugjh4y@allegromail.pl", "login": "Fuu_"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x50x25-11769325912?snapshot=MjAyMy0xMC0xMlQyMDowMzo1Ni4wNDczMzAzNDBaO2J1eWVyOzNiYTMzMjgwNDYxNjIzZjFjMmRlOGEzMjM5YjY1ZWYyMDZhMWUzNDFjOGRlODQxMGM0MjQyZTdiODFiNjYzZTg%3D", "name": "Panel ścienny tapicerowany pan1x50x25", "price": {"amount": "45.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11769325912", "quantity": 6}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "6d0ea500-693a-11ee-8d03-a1b5069dee90", "parcels": [{"sender": {"phoneNumber": "+48504538154"}, "waybill": "1000672284796U", "carrierId": "DPD", "createdAt": "2023-11-06T14:20:36.348Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-06T14:20:09.805Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "847O/2023"}, {"id": "7a061ba4-439d-414a-877c-70c47e4d75e8", "buyer": {"email": "szpfxvpyk0@allegromail.pl", "login": "Client:70484607"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x30x82-lan-12266464467?navCategoryId=20277&snapshot=MjAyMy0xMS0wNlQxOTo0MToyOC44MjYyNzU2MTRaO2J1eWVyOzRjMTg4Y2E4ODI2MzI2OTJhOTE4NjY1YjY3MDQ5NDY4ZThmM2ZiYTY3OTgwNTNjYWNhNDRiYTEyOGNiMWU4N2Y%3D", "name": "Szafka na buty z szufladą Tres 30x30x82 LAN", "price": {"amount": "195.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266464467", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "59e763d0-7cdc-11ee-9500-cf7c9859a90c", "parcels": [{"sender": {"phoneNumber": "+48664653067"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-07T18:31:33.869Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-07T12:37:37.817Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "85J3/2023"}, {"id": "68982b13-bb6e-4bc6-af5f-17f2e8262536", "buyer": {"email": "w1lcc2vr5v@allegromail.pl", "login": "lilia222"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v100x30d-siedzisko-schowek-100cm-bc-11769094598?navCategoryId=20277&snapshot=MjAyMy0xMS0wOFQxOToyMjoxMy4wNTYxMDY2NTdaO2J1eWVyO2Y0N2NlNWEzY2YxZmFlZWFhNDBjNmU1NDFhN2I2NTZlM2NjMDZhMzQ4MWY1MjAzMWVmYTk5Zjg5OTZlMzYyODQ%3D", "name": "Szafka na buty V100x30D siedzisko schowek 100cm BC", "price": {"amount": "420.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11769094598", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "f11ec4b0-7e6b-11ee-9bd6-75c0e4346569", "parcels": [{"sender": {"phoneNumber": "+48661081801"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-13T06:42:17.331Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-13T06:42:05.733Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK55/2023"}, {"id": "b6b6b74b-7f64-4007-8143-dcab03949b81", "buyer": {"email": "5pjjcsi5lu@allegromail.pl", "login": "THomassh007"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-80x30cm-su30-vb-4pan-wp50-n1-cza-d1-scandi-14383226684?navCategoryId=20277&snapshot=MjAyMy0xMC0xN1QxNjozNjoxNC43NzM5MTAxMjdaO2J1eWVyOzZiNmM3NmVjMDZmNzQ1NTAxZGNiYWRlNjkzNDRhMzA0NWUyYjA3YWJjZDk1ODJjNDdiNzQzY2I3NzVlZmMyMjc%3D", "name": "Garderoba 80x30cm SU30 VB-4PAN-WP50 N1 Cza D1 Scandi", "price": {"amount": "1085.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14383226684", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "2f1de420-6d0b-11ee-bcb3-f5e1b3e95720", "parcels": [], "createdAt": "2023-11-15T10:50:52.048Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8YY2/2023"}, {"id": "0efccf1f-36d1-49fb-9822-53f721827bc1", "buyer": {"email": "zu2f1475s7@allegromail.pl", "login": "irmo2009"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb80x30d-s1-siedzisko-schowek-80cm-bialy-14387669377?navCategoryId=20277&snapshot=MjAyMy0xMC0yN1QwNzo1MTowMC42NTcyNjk1MjhaO2J1eWVyOzgxNTc0ZmRhNDlmN2RjNDQwMWViMTBkZGY1M2NiY2RlNGMxOTgzMGZhZjI5MjI5ZWZkYWQzZTlkODVlMzJjMTg%3D", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "14387669377", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "7988a5b0-749d-11ee-959f-8dfacd8c2675", "parcels": [{"sender": {"phoneNumber": "+48509650170"}, "waybill": "1000677147659U", "carrierId": "DPD", "createdAt": "2023-11-16T06:33:27.286Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-16T06:32:21.805Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L71P/2023"}, {"id": "a230ed21-35e7-4a73-a70b-c9e8f1f037ea", "buyer": {"email": "y79a99eyqb@allegromail.pl", "login": "agaperla1"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb50x36d-s1-siedzisko-schowek-50cm-bialy-14384922015?snapshot=MjAyMy0xMC0yOFQxOTozOToxNi44NTQ0MDQyOTNaO2J1eWVyOzgyMmFiZjRmNWQ5Mjg2MGUyNjBjZDk3YWE2NGVlN2E5ZWMyNTE4OTFlOWRkNGMxMTZjYTgzOWUxN2I0ZjZjMjc%3D", "name": "Szafka na buty VB50x36D S1 siedzisko schowek 50cm BIAŁY", "price": {"amount": "269.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14384922015", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9dfc2d90-75c9-11ee-b479-77d9e9f94ff0", "parcels": [], "createdAt": "2023-11-16T19:50:04.717Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L613/2023"}, {"id": "5cbd23bd-f5de-408d-99dc-331d688a1ab0", "buyer": {"email": "dlwo629epp@allegromail.pl", "login": "kurka515"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-panele-11743127497?navCategoryId=20277&snapshot=MjAyMy0xMS0wNlQyMDo1ODo0MS44ODI3NjQ2MzBaO2J1eWVyOzU2YjYyYWZkNGNmNjYzNDY2Y2FmNmM4MGY3NzdiYjUzZTg1NDgzMTM0ZGRiZWNmMjdiNzRmNzRiMmU1OGY1OTI%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak panele", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11743127497", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "2e243070-7ce6-11ee-9bd6-75c0e4346569", "parcels": [{"sender": {"phoneNumber": "+48725080519"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-17T18:14:59.177Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-17T18:14:36.606Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8XZR/2023"}, {"id": "91c7df6b-3c04-45df-b0ee-389b84340859", "buyer": {"email": "20sedldzpy@allegromail.pl", "login": "agnieszka2547"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb80x36d-s1-siedzisko-80cm-czarny-14387675243?navCategoryId=20277&snapshot=MjAyMy0xMS0xNVQxODo0MzoxNy42MzY5NjU5NTdaO2J1eWVyOzIyNjVkYWU5NWZiMzJhMjA5MGJjYTk0NTQ0NDAwY2QwYjkwMGIyMGM3ZDdiODVjODM1ODIyZWE2Y2M0ZGE4MzE%3D", "name": "Szafka na buty VB80x36D S1 siedzisko 80cm Czarny", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14387675243", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "bb273651-83e6-11ee-b062-55983de6ab1e", "parcels": [], "createdAt": "2023-11-21T13:45:17.832Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8GY2/2023"}, {"id": "c43f1189-a87c-4f9e-bb43-c4e2ad7483b2", "buyer": {"email": "vjzvqvvgfd@allegromail.pl", "login": "Client:33178682"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb80x36d-s1-siedzisko-80cm-czarny-14387675243?snapshot=MjAyMy0xMS0xMVQxODoxNjo0OS40ODg1Mzg3MjlaO2J1eWVyO2FmNWNhOWNmZGEyYmUzNmU5NTEwOTczN2I5MzIzODE2ZDE3NWY1MjY1NGVjODMwNjQwNjA0YWZjNmIyNTNhZGU%3D", "name": "Szafka na buty VB80x36D S1 siedzisko 80cm Czarny", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "14387675243", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "4e9abf50-80be-11ee-b25f-0bae27a0189b", "parcels": [{"sender": {"phoneNumber": "+48600272283"}, "waybill": "1000680080524U", "carrierId": "DPD", "createdAt": "2023-11-21T18:28:18.011Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-21T18:27:34.465Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8N4M/2023"}, {"id": "9df13e1e-b81a-48ae-b7fd-68b601eb3f04", "buyer": {"email": "2hr87g9zeg@allegromail.pl", "login": "Client:41170820"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-panele-11743127497?navCategoryId=20277&snapshot=MjAyMy0xMS0wMlQxNjozNzo1NS4wNjU0OTM2MzZaO2J1eWVyOzgyZDRhZmIzZDM3MzgwMjVhYTc5MWRjMjUxNDkxMGNiM2I1N2QwOTQ5ZWI4MGQwZWY2NjI5NjhjMzFiZDMyZWE%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak panele", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "11743127497", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "dbd5c3b3-799d-11ee-8879-25a56cdff4c6", "parcels": [{"sender": {"phoneNumber": "+48606204388"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-24T18:12:10.467Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-24T18:11:23.159Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LR1X/2023"}, {"id": "43b7d726-088a-41a6-a7ba-ffdbaf04d3f1", "buyer": {"email": "kwn8lk1mih@allegromail.pl", "login": "allegronicus"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-leo60x36-siedzisko-szuflady-d2-so-12247865122?snapshot=MjAyMy0xMC0yNVQwMDo1OTo1MC40NTA1NTEwNjNaO2J1eWVyOzAxOGJjZTg3YzUxYWFjOGE3NjIwZDE2ZWZlZDQ0ZThjODlmNmY2Y2RjNzg3NDUwNTNlMDQ4M2EyOTVmMTNhOTE%3D", "name": "Szafka na buty Leo60x36 siedzisko szuflady D2 SO", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Trzy elementy  tej szafki są uszkodzone. Jeśli sprzedawca wymieni te elementy na wolne od wad, zachowam szafkę i nie będę jej odsyłał."}, "offerId": "12247865122", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "f70f5d00-72cf-11ee-a2a8-6fcf236ceff6", "parcels": [{"sender": {"phoneNumber": "+48604515147"}, "waybill": "1000682054815U", "carrierId": "DPD", "createdAt": "2023-11-24T22:30:11.734Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-24T22:29:51.585Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PPW/2023"}, {"id": "e37cef37-a256-4036-809f-c2a0fa14e714", "buyer": {"email": "dit58do14s@allegromail.pl", "login": "Jacek123_2010"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-wotan-14030767581?snapshot=MjAyMy0xMS0wOFQyMDo1MDowOS42MTU3MTY1MDFaO2J1eWVyO2JkMWVkYmQ5NzQ4ODUyMWU2ZmZmMDJiZmFjYWM0MzAwMjliMTUwZTk0NjVjNTViYWFjMWUwZDE4MmY3MjQ1NzY%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak Wotan", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "14030767581", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "3d5b8f50-7e78-11ee-96fd-b5f7844ff2ce", "parcels": [], "createdAt": "2023-11-29T07:05:05.470Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L2OX/2023"}, {"id": "687b22c1-1e69-4341-98c8-c86d873f6fba", "buyer": {"email": "ucbxekx28o@allegromail.pl", "login": "Client:96251690"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMy0xMC0zMVQwNzoyNzowNS40NjExMDIyNDZaO2J1eWVyOzM5NGI1NWZjMDM5ZGRmMjE0OGNkMzBjN2VkNDczNmVkODlkNTUyOThjZWRkNTVlOTkzMmI2NzE4M2U3YmIzNzA%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "FINISHED", "orderId": "49f700c0-77be-11ee-b479-77d9e9f94ff0", "parcels": [{"sender": {"phoneNumber": "+48608247312"}, "waybill": "1000685246365U", "carrierId": "DPD", "createdAt": "2023-11-30T10:05:00.376Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-30T10:03:11.239Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LW5K/2023"}, {"id": "4cecd05f-c909-4500-a72b-3c9de938950f", "buyer": {"email": "o9tlb3jled@allegromail.pl", "login": "1989pina"}, "items": [{"url": "https://allegro.pl/oferta/szafka-szafa-wysoka-supra-vini-80x30x202d1-bia-12649009467?navCategoryId=20291&snapshot=MjAyMy0xMS0xMlQwODo0NTowOC4yMjExNzczNDlaO2J1eWVyOzFlZWM5MDFiY2U5NzQ2NWNiMjRmYzgyZjQ0NzZmYzRkODNiMGMxNzhiOGMxOTRiY2IyNTFmZWRjYmIyNzUxZDI%3D", "name": "Szafka szafa wysoka supra VINI 80x30x202D1-BIA", "price": {"amount": "939.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Towar jest uszkodzony zdjęcie wysłane w wiadomości przez allegro dyskusję i brak elementów w paczce "}, "offerId": "12649009467", "quantity": 1}], "refund": null, "status": "FINISHED", "orderId": "94518960-8137-11ee-9099-99e484e39e41", "parcels": [{"sender": {"phoneNumber": "+48667835889"}, "waybill": "1000687251476U", "carrierId": "DPD", "createdAt": "2023-12-04T14:33:59.291Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48667835889"}, "waybill": "1000687252135U", "carrierId": "DPD", "createdAt": "2023-12-04T14:34:47.591Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48667835889"}, "waybill": "1000687253490U", "carrierId": "DPD", "createdAt": "2023-12-04T14:36:29.812Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-12-04T14:31:36.299Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8MY3/2023"}, {"id": "24455d65-5816-4543-8c70-5705b46dfac8", "buyer": {"email": "h6dieb02zk@allegromail.pl", "login": "satsat"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-120x30cm-s60-vb-4pan-wp60-czarny-d1-arti-13887808299?snapshot=MjAyMy0xMS0yMFQxMjoyMzozNi4yMzk5NDExNTRaO2J1eWVyOzA4NmVjY2NiMjYwM2MwMGRkYTRkNzFjNTc2MDkyMmYwZDU3MmZjZTRlZTA4ODNkZDYyYjE5N2M3NTQ5NTQ3ZjE%3D", "name": "Garderoba 120x30cm S60 VB-4PAN-WP60 Czarny D1 Arti", "price": {"amount": "1610.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "13887808299", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "1c2ec100-879f-11ee-8953-a3afe87774bb", "parcels": [], "createdAt": "2023-12-10T19:00:00.941Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L3J7/2023"}, {"id": "3d529645-3441-4449-8b37-ed025e3852e2", "buyer": {"email": "a8oyje8q1p@allegromail.pl", "login": "humies"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x50x35-11769358337?snapshot=MjAyMy0xMS0yNlQxNToxMjowNC42ODkwNDE3ODdaO2J1eWVyO2NhNDgyMzE2YmJmNzUyNmYwN2EzYWZmN2VkNjdlZjAwNTUyNGM4OThjNGUyYTYwM2IwMzJiYWYyOGE1MDMyNjM%3D", "name": "Panel ścienny tapicerowany pan1x50x35", "price": {"amount": "49.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11769358337", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "db959000-8c6d-11ee-a0c7-497d0e58e3f6", "parcels": [{"sender": {"phoneNumber": "+48733420529"}, "waybill": "00159007738306717398", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-12-16T17:19:30.018Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-12-16T17:17:24.261Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "895Q/2023"}, {"id": "f8b7457c-1357-44c9-880f-59b593b46b10", "buyer": {"email": "83lw87cg69@allegromail.pl", "login": "madziulax3"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb60x30d-s1-siedzisko-schowek-60cm-bialy-14384926745?navCategoryId=20277&snapshot=MjAyMy0xMi0yMVQxODoyMToxNi44NjA2ODQ4MDRaO2J1eWVyOzBlNGNjYTEyNDM0MDFkYTE3YWYzMmU4YjIyYzIzNzAyMDlmNTc4ZTg0YTZkMDc4ZGFmZTM0NzRiZWE2MzljNTc%3D", "name": "Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY", "price": {"amount": "269.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "14384926745", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9afdf090-a02d-11ee-a3dc-53f7301d2354", "parcels": [], "createdAt": "2023-12-28T22:25:32.950Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8J4N/2023"}, {"id": "b19aa6b1-ff9d-4cd1-939a-7668511c0945", "buyer": {"email": "jq1kgt8g0e@allegromail.pl", "login": "kolonix"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-120x36cm-v60-supra60-4-panele-d1-lan-12258761869?snapshot=MjAyMy0xMi0zMFQxODoyNzoxNi4zNTE0ODMzNzdaO2J1eWVyO2RhMmQ1ODViMGE0ODRmYjZlNzAxZWY1MTBhNmYxYTE0MWU2M2JmZDE2ZGViMjBiNGY0MTliMmI4NmI4OWM5NTE%3D", "name": "Garderoba 120x36cm V60 Supra60 4 Panele D1 LAN", "price": {"amount": "1590.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12258761869", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "54e36bc0-a740-11ee-9d4c-31ee45aedb1a", "parcels": [], "createdAt": "2024-01-01T15:22:05.780Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8538/2024"}, {"id": "7fb8ab5b-8c49-4490-acda-1e469e4604d3", "buyer": {"email": "acj7hdlx6v@allegromail.pl", "login": "markos1mk"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x30d-siedzisko-schowek-80cm-lan-11678695472?navCategoryId=20277&snapshot=MjAyMy0xMi0xMFQxOTozNDozNC43MjAxMDA4MDBaO2J1eWVyOzdkOTk1NDg5NWQwOTYzNWZiMjRjMTI1YjhmNzMxMzZlZGZhYzA5MWQxYzgyN2YxZDkyNWRjNzNkODhlYTc1NjQ%3D", "name": "Szafka na buty V80x30D siedzisko schowek 80cm LAN", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "11678695472", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "07473d40-9793-11ee-a1b9-b9ee6735ff8b", "parcels": [{"sender": {"phoneNumber": "+48504984945"}, "waybill": "1000703020413U", "carrierId": "DPD", "createdAt": "2024-01-09T14:44:53.643Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2024-01-05T20:00:22.950Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK5L/2024"}, {"id": "8f0b5d06-a8d9-4235-8a58-0eea64b78134", "buyer": {"email": "33klonydhx@allegromail.pl", "login": "Client:46613573"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-supra-30-slupek-30x36-d1-bia-12266374192?snapshot=MjAyMy0xMi0yOVQxMTowMjozNy4wNDYxNTU1MzNaO2J1eWVyOzZjNDQ0ZGU3Y2FmMzE0MGM3MmE5MzdjNmVkMDZjOGQxMjlhMjliZjg4ODUwYjk3ZGI3N2NlNjUzOTVhNDk2NDk%3D", "name": "Szafka na buty Supra 30 słupek 30x36-D1-BIA", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266374192", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9a6aeef0-a639-11ee-b3d1-d1dc446474ec", "parcels": [], "createdAt": "2024-01-07T11:49:28.121Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y2L/2024"}, {"id": "0942ef63-3ab7-4db6-b054-7ded82c41b2c", "buyer": {"email": "tntk7abmlm@allegromail.pl", "login": "ntfxp"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x30d-siedzisko-schowek-80cm-lan-11678695472?snapshot=MjAyMy0xMi0yN1QyMjoyNDowNC44NTc3NDc2OThaO2J1eWVyOzYzZTc0MDkwNmIxZDQ0NzZkNWRkYmM4M2YxZjJhYmNhNzE4NjAxZWRhNmNmZmMxZTQ1MjAzYzc0YmIxODMwNzY%3D", "name": "Szafka na buty V80x30D siedzisko schowek 80cm LAN", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11678695472", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9a5eb971-a506-11ee-9785-e1318688de4d", "parcels": [{"sender": {"phoneNumber": "+48668591495"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2024-01-08T14:49:17.944Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2024-01-08T14:49:00.117Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7P8/2024"}, {"id": "3f9bab94-1fe2-41f2-84e5-2c51e0e82648", "buyer": {"email": "9au0ad8ux7@allegromail.pl", "login": "Client:71803005"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-supra-30-slupek-30x36x192-d1-so-12266416456?navCategoryId=20277&snapshot=MjAyNC0wMS0wNFQwODoyNzoxNC4wMzA5MzEyNTBaO2J1eWVyOzlhYTE2Y2RiMzQyNjExZWExZjlmMjAxMDRmZmYxZGE0N2M2OTYyOThlN2JmYTRkMzYyOTQ5YTBiZmI0MThlY2M%3D", "name": "Szafka na buty Supra 30 słupek 30x36x192-D1-SO", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12266416456", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "bf5d76b0-aada-11ee-aec8-b5646d1484ba", "parcels": [], "createdAt": "2024-01-11T06:13:10.306Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L638/2024"}, {"id": "2d983c90-5314-41f8-96c7-416f93f00a3e", "buyer": {"email": "gg8ziduwtf@allegromail.pl", "login": "Kruszyna_b"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x30x82-bia-12266463730?navCategoryId=20277&snapshot=MjAyMy0xMi0xNlQxMTowMTo1MC42ODE0MzU2MTZaO2J1eWVyOzFlYjU1MjE3MWE4MTRmZGY4NjRkNDE1MGFkNjNhNTY4Njg4ZGNlYmVmY2FmY2U4NWI0NzRmOGFjZTRjNmEzOTE%3D", "name": "Szafka na buty z szufladą Tres 30x30x82 BIA", "price": {"amount": "195.00", "currency": "PLN"}, "reason": {"type": "OTHER_FLAW", "userComment": "Brak elementow, brak dzior na sruby...."}, "offerId": "12266463730", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "5e5795d0-9c02-11ee-9c00-1b967a392bbd", "parcels": [{"sender": {"phoneNumber": "+48505704345"}, "waybill": "1000704739879U", "carrierId": "DPD", "createdAt": "2024-01-13T11:22:37.186Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2024-01-13T11:22:12.058Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8XR8/2024"}, {"id": "d2b5f4cc-b882-4f44-a2fa-d6bc198f34ba", "buyer": {"email": "3dpi220rj2@allegromail.pl", "login": "Nadis44"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-s30-vb-4pan-wp60-czarny-d1-wotan-13883386251?navCategoryId=20277&snapshot=MjAyMy0xMi0xN1QxNTowNDoyNC42OTIwOTQ1NzZaO2J1eWVyOzRhNDczODNhYTRjMjBjYTdlYjkyYzEyNGRkMzk4MjhlMjMyYjBkZDI5MTY1NDRiMzE1M2Y2YjFkMGU0NjBjYjU%3D", "name": "Garderoba 90x30cm S30 VB-4PAN-WP60 Czarny D1 Wotan", "price": {"amount": "1120.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "13883386251", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "34517580-9ced-11ee-935c-59f41f343ce0", "parcels": [{"sender": {"phoneNumber": "+48661647683"}, "waybill": "0000032351808T", "carrierId": "DPD", "createdAt": "2024-01-17T09:00:54.025Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2024-01-16T20:49:55.878Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G2L/2024"}, {"id": "c58576e9-fc62-44dc-ac9b-ee850fcae8bb", "buyer": {"email": "uizuusaojn@allegromail.pl", "login": "MagdalenaTryba"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-supra-30-slupek-30x30-d1-lan-12266428157?navCategoryId=20277&snapshot=MjAyMy0xMi0yNlQxMDoxNzo1OS4wNjUwMzcwMzVaO2J1eWVyOzZkMTU1MWM1ZjI1NzZiZjFhZDhlYzEyYWVkYjZjODU5NTYwYjkxYjVmM2ViM2M3ZDI4YzBhZDRiZDhhMDA2MjQ%3D", "name": "Szafka na buty Supra 30 słupek 30x30-D1-LAN", "price": {"amount": "439.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266428157", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "a9903340-a3d7-11ee-821a-a9fc9d3fe62e", "parcels": [{"sender": {"phoneNumber": "+48507545098"}, "waybill": "0000032369579T", "carrierId": "DPD", "createdAt": "2024-01-17T18:23:01.352Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48507545098"}, "waybill": "0000032393444T", "carrierId": "DPD", "createdAt": "2024-01-20T14:58:35.921Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2024-01-17T18:09:46.217Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NML/2024"}, {"id": "eedc4ac8-b9d0-425b-b2f6-facddcc44206", "buyer": {"email": "vxmfq3r2so@allegromail.pl", "login": "ula367"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMy0xMi0yOFQxOTo0MDo0Mi40NzU2Mzg2NDBaO2J1eWVyO2YzMjM1MTBlMDE3NTYxYjFhNDdhNmY4YTg2YjIyOWJhYTkyNTMxNzgyYjBjY2NkZTE4ZDgxYzA4MDFhYTYwOTk%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "259.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Produkt uszkodzony. Jeden element pęknięty, drugi uderzony w dwóch miejscach. Posiadam zdjęcia w razie potrzeby. "}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "e4be0d10-a5b8-11ee-bd10-3bf6c65ce884", "parcels": [{"sender": {"phoneNumber": "+48788712133"}, "waybill": "1000707110041U", "carrierId": "DPD", "createdAt": "2024-01-18T11:24:38.882Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2024-01-18T11:22:54.254Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LRXL/2024"}, {"id": "32fa4219-1bba-4b25-be16-afc57b2ffb91", "buyer": {"email": "wwkfjmsdr7@allegromail.pl", "login": "itspdn"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-80x30x80cm-altus4-lan-4polki-10863038507?snapshot=MjAyMy0xMi0zMVQwOTowNDoyNS4wNTE4Mjc0ODJaO2J1eWVyO2ZiZjJhMWY5OTNmYjNiNmI4YzM4MTk2MWQ2MmEwMjRhOTMyMjQ1ZDY5YWQ5NDNlNzY3MTQ1MmFiYjFkZWQ5MWQ%3D", "name": "Szafka komoda na buty 80x30x80cm Altus4 LAN 4półki", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10863038507", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "7ae11b80-a7bb-11ee-b5cc-5bdbdcc97171", "parcels": [], "createdAt": "2024-01-18T11:58:04.218Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PWL/2024"}], "messageToSeller": null}	2025-10-06 17:22:29.745472	2025-10-09 20:21:05.365884	\N	{"city": "Borowa", "street": "Borowa 591", "zipCode": "39-305", "lastName": "Wróbel", "firstName": "Mariusz", "modifiedAt": null, "companyName": null, "countryCode": "PL", "phoneNumber": "+48607580233"}	0.00	f	{"required":false,"address":null,"dueDate":null,"features":null}	[{"id": "RFBEOjEwMjY5Njg5MzM3MDVV", "waybill": "1026968933705U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.233Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM4OTNV", "waybill": "1026968933893U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.513Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM5MTZV", "waybill": "1026968933916U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.755Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}]	\N	[]	\N	\N	\N	\N	\N	\N	\N	864
e79a565d-ad39-42de-990d-a8d2e6351414	3	AL-3	ALLEGRO	3eb44790-9de1-11f0-86f1-176f8757ee95	2025-09-30 09:42:14.277	SENT	Falcon-14-	rp9su4q41p+389242421@allegromail.pl	\N	Krystian	Pietruszka	+48 888 664 913	Ubieszyn 200, 37-204 Tryńcza	37-204	Tryńcza	PL	3edbf3f4-9de1-11f0-91d4-7961b40d7b05	PENDING	ONLINE	AF	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	H1 czarny, WE1 welur czarny	f	\N	{"id": "3eb44790-9de1-11f0-86f1-176f8757ee95", "note": null, "buyer": {"id": "90892065", "email": "rp9su4q41p+389242421@allegromail.pl", "guest": false, "login": "Falcon-14-", "address": {"city": "Grodzisko Dolne", "street": "Grodzisko Dolne 681", "postCode": "37-306", "countryCode": "PL"}, "lastName": "Pietruszka", "firstName": "Krystian", "companyName": null, "phoneNumber": "+48 888 664 913", "preferences": {"language": "pl-PL"}, "personalIdentity": null}, "status": "READY_FOR_PROCESSING", "invoice": {"address": null, "dueDate": null, "features": null, "required": false}, "payment": {"id": "3edbf3f4-9de1-11f0-91d4-7961b40d7b05", "type": "ONLINE", "features": [], "provider": "AF", "finishedAt": "2025-09-30T09:42:14.277Z", "paidAmount": {"amount": "1391.00", "currency": "PLN"}, "refundDate": null, "refundAmount": 0, "reconciliation": null, "refundReconciliation": []}, "summary": {"totalToPay": {"amount": "1391.00", "currency": "PLN"}}, "delivery": {"cost": {"amount": "0.00", "currency": "PLN"}, "time": {"to": "2025-10-03T21:59:59.999Z", "from": "2025-10-02T22:00:00Z", "dispatch": {"to": "2025-10-02T21:59:59.999Z", "from": "2025-10-01T22:00:00Z"}, "guaranteed": null}, "smart": true, "method": {"id": "c3066682-97a3-42fe-9eb5-3beeccab840c", "name": "Allegro Kurier DPD"}, "address": {"city": "Tryńcza", "street": "Ubieszyn 200", "zipCode": "37-204", "lastName": "Pietruszka", "firstName": "Agata", "modifiedAt": null, "companyName": null, "countryCode": "PL", "phoneNumber": "+48534862817"}, "pickupPoint": null, "cancellation": null, "calculatedNumberOfPackages": 1}, "revision": "1ab823c2", "discounts": [], "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17358940752", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir", "external": {"id": "5905806237801"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-30T09:41:55.261Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}], "shipments": [{"id": "RFBEOjEwMjY2NDY0ODIyNDhV", "waybill": "1026646482248U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:24Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}, {"id": "RFBEOjEwMjY2NDY0ODIwNDlV", "waybill": "1026646482049U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:25.328Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}, {"id": "RFBEOjEwMjY2NDY0ODIxNTZV", "waybill": "1026646482156U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:25.472Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}], "updatedAt": "2025-09-30T09:42:14.277Z", "surcharges": [], "fulfillment": {"status": "SENT", "shipmentSummary": {"lineItemsSent": "ALL"}}, "marketplace": {"id": "allegro-pl"}, "customerReturns": [{"id": "9037a8be-bd1d-479e-8972-8079f851b162", "buyer": {"email": "mt8uc79f2q@allegromail.pl", "login": "AnetaJ5"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-120x36cm-v60-supra60-4-panele-d1-bia-12258666208?navCategoryId=20277&snapshot=MjAyMi0wNy0zMVQxOToxNToxMy45NDhaO2J1eWVyO2I0MTAzNzg0MTk0MTVmM2FmN2I0OWI0NTE5ZmMyMDQ5ODhiYjYzZjk5MWQyZmE2ODBmNTJkNDZjMGRjMDZkMzg%3D", "name": "Garderoba 120x36cm V60 Supra60 4 Panele D1 BIA", "price": {"amount": "1520.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12258666208", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "123a1b21-1105-11ed-bbd3-6b6427496643", "parcels": [], "createdAt": "2022-08-08T09:56:34.909Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "843O/2022"}, {"id": "3696892f-343b-46df-81f8-0218da362d4e", "buyer": {"email": "iqdmyduvcp@allegromail.pl", "login": "brzozowiak"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x36cm-v60-supra30-4-panele-d1-bia-12266508168?navCategoryId=20277&snapshot=MjAyMi0wOC0xNVQxNzowMzo1NS43MDhaO2J1eWVyOzE5Y2QwMTkwYjI0YzQ0NDdiOTQyY2VhNDM5NzZmMTM1ZTVmNzJhYzdjNjg0YjQ3NjkxNjMxYjA3N2RiNGQ5YjA%3D", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 BIA", "price": {"amount": "1070.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266508168", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "01bd3581-1cbc-11ed-ac22-050cfff5b55a", "parcels": [{"sender": {"phoneNumber": "+48512156149"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-08-22T08:07:17.036Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-08-20T11:46:40.951Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8563/2022"}, {"id": "b9777c6a-3f46-462e-ba34-7f1d71311c00", "buyer": {"email": "jjz4fhqhwq@allegromail.pl", "login": "Client:46616004"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x30d-siedzisko-schowek-80cm-lan-11678695472?navCategoryId=20277&snapshot=MjAyMi0wOC0xNFQwODo0MDo1Ni41MTlaO2J1eWVyOzk0NGVjMGYzOTk1OGFjZTA0OTkzYzQ2MGI3ZDI4NWUzNWYyN2EyYWYyM2ViOWU5NjI5NTNjMmU1YjY0MWY3MzI%3D", "name": "Szafka na buty V80x30D siedzisko schowek 80cm LAN", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Witam! Jestem zmuszona odesłać szafkę-paczkę,ponieważ towart dotarl uszkodzony. Jest to dosyć widoczna wada której nie da się ukryć niestety. Posiadam zdjęcia,  chętnie dołączę jako dowód. "}, "offerId": "11678695472", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "c9e0c831-1bac-11ed-b010-71e7783f672c", "parcels": [{"sender": {"phoneNumber": "+48513223042"}, "waybill": null, "carrierId": "INPOST", "createdAt": "2022-08-23T21:18:26.546Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-08-23T21:16:55.415Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK75/2022"}, {"id": "b0e4aeb2-2439-4c44-acb4-ba6d12b7d495", "buyer": {"email": "tqkklxdqiy@allegromail.pl", "login": "Client:29046140"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-slupek-polus172x30so-11873228248?navCategoryId=20277&snapshot=MjAyMi0wOC0xOVQyMTowODoxOC42ODhaO2J1eWVyOzk1YzhlMDMzMzdmNTVlN2VjZDE0ZTMyMGM1MzkyMjQwOTgwMDNmM2I2NDE2N2NlODZiM2ExNmM5NzQ0YmVkMjM%3D", "name": "Szafka na buty słupek polus172x30SO", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11873228248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d481e761-2002-11ed-a4b6-2796c774bfb5", "parcels": [], "createdAt": "2022-08-29T12:51:02.077Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y22/2022"}, {"id": "2b336b61-73ac-4a92-8d68-9544381d1349", "buyer": {"email": "3a4h2rloz1@allegromail.pl", "login": "sylwox"}, "items": [{"url": "https://allegro.pl/oferta/zestaw-100x30d2alt-szafka-na-buty-z-siedziskiem-so-12041568683?navCategoryId=20277&snapshot=MjAyMi0wOC0xNlQxODowMjo0OC42NDBaO2J1eWVyO2IyZTQ0ZWFmZjhkMjA2NGY3NTBlZDk3NjQ1Y2U4MjNlMmFiY2M3Nzc2YmRiZGE3NzFlNWYxZWIwMzVhYjBkMGU%3D", "name": "Zestaw 100x30D2Alt szafka na buty z siedziskiem SO", "price": {"amount": "638.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12041568683", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "7ab4fff1-1d8d-11ed-8746-65bb8d4a51d3", "parcels": [{"sender": {"phoneNumber": "+48509128006"}, "waybill": "00159007738162485158", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-09-02T15:40:44.695Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-02T15:40:02.728Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7RP/2022"}, {"id": "7436e8db-3eb9-4557-b90c-d504303ed267", "buyer": {"email": "pond179l0b@allegromail.pl", "login": "kluska333"}, "items": [{"url": "https://allegro.pl/oferta/szafka-nocna-40x36-nox1-biala-2-szuflady-schowek-12154681943?navCategoryId=20294&snapshot=MjAyMi0wOC0yOFQxNzoyNjoyNy45OTFaO2J1eWVyO2M3NWQ4MTdjN2FhZDBmMjk3MGI1Zjk5YmU2ZWI1MmYzNDhhYmNiNzA4ZjdiNjBiMjcxM2Q0NWMwOTc1NGJjOWI%3D", "name": "Szafka nocna 40x36 nox1 biała 2 szuflady schowek", "price": {"amount": "229.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12154681943", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8992e831-26f6-11ed-a0b8-5531037899f2", "parcels": [{"sender": {"phoneNumber": "+48517400028"}, "waybill": "1000495009540U", "carrierId": "DPD", "createdAt": "2022-09-03T11:40:25.752Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-03T11:39:17.277Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L6X3/2022"}, {"id": "42d43332-20d2-4bf9-98c3-bb569cdaa3e7", "buyer": {"email": "z434ha736n@allegromail.pl", "login": "Client:88668947"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0wOC0xNVQyMDozMToxMi4yOTlaO2J1eWVyOzg5NmRlNjgzNDYzNmZmMDlkZTk5MTZiMzQ3YTUyNWRlZmE2ZGM0Mzc4NWYxZTUzOTBkODQ2ODJhZmRhODllZDM%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "afa9fc22-1cd8-11ed-a6bc-458a8cca5908", "parcels": [{"sender": {"phoneNumber": "+48517983628"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-09-04T18:00:57.489Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-04T17:58:19.844Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8X2R/2022"}, {"id": "ac5263ab-b444-48dc-aa2e-ce40e525527f", "buyer": {"email": "e6n38stpdu@allegromail.pl", "login": "Client:64409347"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-80x36cm-v50-supra30-4-panele-d1-bia-12487657175?navCategoryId=20277&snapshot=MjAyMi0wOC0yNFQxODo0MDoxOS4xMjVaO2J1eWVyO2EyZGRiZTFiYzU5ZjlmNDZhN2EzMDlmNWVlNGMzYzQxMmM5OTJjM2FlNWRkN2Y5Zjk3ZDc5ODIxNmU5ZmFhNGQ%3D", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIA", "price": {"amount": "1035.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12487657175", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "cec99201-23db-11ed-9f12-63118f43da94", "parcels": [], "createdAt": "2022-09-21T14:07:44.392Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G52/2022"}, {"id": "6eff5044-f08b-4287-966f-0ff1c62eede9", "buyer": {"email": "gpa98c2hji@allegromail.pl", "login": "Client:43343932"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?snapshot=MjAyMi0wOS0yMVQwNzo0NjoyOC4zNzZaO2J1eWVyOzI1MDdiODRlMzViMzcxMzZiYWJlMzVlOGY0MTBlMTVjZWQ4ZTg3YmVjYzFlMTUxOGJiZmM1MTU5NzRhZDFlNWY%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "659c9b42-3981-11ed-bf70-e5b1e9d32a61", "parcels": [], "createdAt": "2022-09-26T17:27:12.811Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NOM/2022"}, {"id": "964f3da7-3941-44d4-a957-9578d730e2ec", "buyer": {"email": "8dio0bnx8c@allegromail.pl", "login": "mateuszkunc"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0wOS0yMVQxMToxMjowOC43NDhaO2J1eWVyO2Y2Y2EzZjAyNjY4ZDE2NWQzZTUzOGZiY2JlOGFiNGM5MTM2NzM4OGI2MzA4MThjMmY1MzFmY2M1M2U4NWUzYzQ%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "2b74bc01-399e-11ed-80fa-a764c95d1596", "parcels": [{"sender": {"phoneNumber": "+48692303083"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-09-27T05:16:56.973Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-27T05:16:40.260Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LR2X/2022"}, {"id": "ad218913-f0e0-4254-8d69-36ba3b6babcf", "buyer": {"email": "70ilwbxbk3@allegromail.pl", "login": "goldencars77"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-60x30-wieszak-wp60-d1-lan-12273961847?navCategoryId=20277&snapshot=MjAyMi0wOS0xOVQwOTo0OTozMy4zNjdaO2J1eWVyOzRlOGZkZWRkMTRkMTU0ZGQzZWJmYWNiNWIxYmE4ODUzZWZmYmYwZjE4ZTExOGIwMDQ0ZjY1NGUxYjIwMGY3Zjg%3D", "name": "Szafka na buty One 60x30 Wieszak WP60 D1 LAN", "price": {"amount": "448.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12273961847", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "5012acb1-3800-11ed-ba15-3da8e39304ec", "parcels": [{"sender": {"phoneNumber": "+48733228928"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-09-27T09:54:54.384Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-09-27T09:54:42.506Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PXW/2022"}, {"id": "af8796cd-0f17-4048-937c-54e81c408fb0", "buyer": {"email": "wjma2m8fn9@allegromail.pl", "login": "lukbzl"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?snapshot=MjAyMi0wOS0yNlQwMDowNjoxMy40OTBaO2J1eWVyO2I1NGE3YzgxMWI1ZjQ1YzIxYWMxZGE2OGUxMDY5MTA5ZTVlYzg4NzZkMzZlZWViODIzMmQxNDYxZTk5MGQ1YWQ%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "e339a831-3d2e-11ed-9dd9-690772a53f55", "parcels": [{"sender": {"phoneNumber": "+48795851697"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-10-03T08:04:53.810Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-03T08:04:38.359Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L27X/2022"}, {"id": "fd426ad2-1810-4464-8d9b-a4bde313083d", "buyer": {"email": "omm307xqu8@allegromail.pl", "login": "arczi-44"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-lan-12266500390?navCategoryId=20277&snapshot=MjAyMi0xMC0wOVQxMTo0ODo1MS4xNDhaO2J1eWVyOzNmMzIyNTc4NDkwNjBiM2EzMzg4MjdhNGI1MGRiYjYxMjY4ZTRmZWFiMWU4MzY5NThlZGRmYzNjZjBiMWQ0YzI%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 LAN", "price": {"amount": "1080.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266500390", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "071b89f1-47c8-11ed-b85f-fbad9a675357", "parcels": [{"sender": {"phoneNumber": "+48514365028"}, "waybill": "1000514200092U", "carrierId": "DPD", "createdAt": "2022-10-17T08:47:34.562Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-17T08:47:05.700Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LWNK/2022"}, {"id": "16b3d7b4-9ba5-43b6-b280-d962050048a5", "buyer": {"email": "p9m7et5w27@allegromail.pl", "login": "Client:39195287"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-lan-12266500390?navCategoryId=20277&snapshot=MjAyMi0wOS0xOFQxMTo1MDo0Ni40ODVaO2J1eWVyOzE5YjA4YjhjODcyMjAxNTM3ODQyYWIxYjQ4MmMxNDliYWE5OGRiZTk2NGRiMGViYjBmODQzY2IxMGNmYjRhZDU%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 LAN", "price": {"amount": "1030.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266500390", "quantity": 1}], "refund": null, "status": "FINISHED", "orderId": "aa703741-3747-11ed-a287-9993c5228f05", "parcels": [{"sender": {"phoneNumber": "+48577304469"}, "waybill": "00159007738204662981", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-10-19T16:42:58.224Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-19T16:41:35.050Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8MR3/2022"}, {"id": "841c2067-717b-425f-a930-be93713b6363", "buyer": {"email": "tiokpbn9vp@allegromail.pl", "login": "Krycha_WNC"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-bia-12170501801?navCategoryId=112735&snapshot=MjAyMi0xMC0xN1QxMzoxODozNy43NTFaO2J1eWVyO2Y3OWY2YmYyYmZjZmYyNDU1NDZmNjM4NGUyZDc3Y2JiMTE2YzcwYTEyN2QyZjE3YjdjYTc5NjZmMWU0N2E5MzE%3D", "name": "Komoda z szufladami Vini4 80x30 BIA", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "TRANSPORT", "userComment": "1 róg paczki uszkodzony i w związku z tym wiekszość elementów w tym damym rogu uszkodzone"}, "offerId": "12170501801", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "1bd89e81-4e1e-11ed-9836-e9431026e850", "parcels": [{"sender": {"phoneNumber": "+48517196487"}, "waybill": "1000519636388U", "carrierId": "DPD", "createdAt": "2022-10-29T11:52:23.185Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48517196487"}, "waybill": "1000519636663U", "carrierId": "DPD", "createdAt": "2022-10-29T11:56:46.036Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-29T11:51:30.313Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L367/2022"}, {"id": "7025b2b2-df86-4add-9748-53d60efa0929", "buyer": {"email": "cmr0kr2n5a@allegromail.pl", "login": "mateo4121"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp50-na-ubrania-50cm-4-uchwyty-11711221934?navCategoryId=112733&snapshot=MjAyMi0xMC0yMlQyMDoyMzowNi40MzRaO2J1eWVyO2NjMmNiMjY5MzQ5M2ViNTFjNmEwNTkxNWU1YjlmN2EyNWY2NzlhNzhiMGU2NjQ0YTljMjIwZTdjMGM3ZTNkODU%3D", "name": "Wieszak ścienny WP50 na ubrania 50cm 4 uchwyty", "price": {"amount": "189.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11711221934", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "2f365940-5247-11ed-9f13-6140442851ad", "parcels": [{"sender": {"phoneNumber": "+48723880905"}, "waybill": "00159007738212115370", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-10-29T20:09:01.099Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-10-29T20:08:32.894Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "89OQ/2022"}, {"id": "796a3f95-9a93-476b-bc4b-06870400b563", "buyer": {"email": "nsbqf55joh@allegromail.pl", "login": "szaara"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-60x36-lan-12158046796?navCategoryId=20291&snapshot=MjAyMi0xMC0yNFQxOTowODoyNS42NTZaO2J1eWVyOzIwMDUwZWQzZjQwNTJjNWI3ZTEyYTIzMjI5NDJkNTQwMjI2MTc5ZTE3NDhhOWVkNTAyYmZjM2JjMzBkNjcxODA%3D", "name": "Komoda z szufladami Vini4 60x36 LAN", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12158046796", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "2c1235c0-53cf-11ed-ad2f-d9ae8869133d", "parcels": [{"sender": {"phoneNumber": "+48795787497"}, "waybill": "1000523057970U", "carrierId": "DPD", "createdAt": "2022-11-07T17:44:27.240Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-07T17:44:16.934Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8J7N/2022"}, {"id": "350accdf-2f2e-4518-9703-81c17973eea9", "buyer": {"email": "vkzd2zi0o1@allegromail.pl", "login": "Client:38978633"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-lan-11678652560?navCategoryId=20277&snapshot=MjAyMi0xMC0yM1QyMDoxMzo0Ny43NDZaO2J1eWVyOzVmMDgyMTczZGNmZjNmNjdmNGI4NjllYTEwOGY3Njg4ODgwMDJmYzc3NGVkYjZmYzhhOTNiM2VjMDAyMTA4ZDc%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm LAN", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11678652560", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "0a049240-530f-11ed-94a3-d1d83f561bb5", "parcels": [{"sender": {"phoneNumber": "+48660010000"}, "waybill": "1000524813781U", "carrierId": "DPD", "createdAt": "2022-11-11T09:45:45.399Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-11T09:45:27.765Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LZ2X/2022"}, {"id": "e64eecd1-b4c1-407e-be32-e3500038a752", "buyer": {"email": "nq0a6rl2rz@allegromail.pl", "login": "aniaparys92"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v60x30d-siedzisko-schowek-60cm-bc-10814131958?navCategoryId=20277&snapshot=MjAyMi0xMS0wMVQyMDo0ODowMi4wMDhaO2J1eWVyOzA0NzZjYjU5N2E4YmIwOWE1NjVlMTk5ZjA3MWZhOTg0NDg1NDUyMTkzMmExNDdlOTEwYmE3NDE2ZmVhNjJmMmI%3D", "name": "Szafka na buty V60x30D siedzisko schowek 60cm BC", "price": {"amount": "269.00", "currency": "PLN"}, "reason": {"type": "DAMAGED", "userComment": "Dzień dobry, w drzwiach szafki brakuje nawierconych otworów do przykrecenia zawiasow, instrukcja jest zupełnie nieczytelna, a rysunki są pomieszane."}, "offerId": "10814131958", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9ec36a10-5a25-11ed-ab7d-a7a418932807", "parcels": [{"sender": {"phoneNumber": "+48695546925"}, "waybill": "1000526731158U", "carrierId": "DPD", "createdAt": "2022-11-15T19:42:21.242Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-15T19:31:36.804Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L1GM/2022"}, {"id": "cbdce904-b973-418b-9231-2bba4b55b205", "buyer": {"email": "7nrpshnp9g@allegromail.pl", "login": "Leszel100"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMi0xMC0yOVQxOToyOTo1OS4zMjNaO2J1eWVyOzY5NDFiODY5ZGQ2ZWUyM2M2NzkyZjQ1ZDVhMjRjN2YyNjAyNzE2NzJiNmM0ZTQ3ODA0ZGNiOTA0MzQ2MTJmMzQ%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8457a5a0-57bf-11ed-9622-c3b1df87d802", "parcels": [], "createdAt": "2022-11-16T18:39:04.532Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8QP0/2022"}, {"id": "8171342b-f50a-4536-9932-ee5f5fe4ffb2", "buyer": {"email": "3g63pbzr14@allegromail.pl", "login": "rafdam79"}, "items": [{"url": "https://allegro.pl/oferta/zestaw-komoda-vini4-wieszak-panele-60x30-lan-12208750516?navCategoryId=20277&snapshot=MjAyMi0xMS0xM1QyMDoxMTowNC42NzVaO2J1eWVyOzJlNDc4MjhmNDdkNDE4YTQ1ZjViZWI4MTFkODE2NDQzZDZhY2E3YTRjMmY3ZmU3ZWVlNTIzMjA4ZDM1Y2UxMjE%3D", "name": "Zestaw Komoda Vini4 Wieszak Panele 60x30 LAN", "price": {"amount": "715.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12208750516", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "31b2ada0-638f-11ed-bd0d-fbeadcc384de", "parcels": [], "createdAt": "2022-11-17T09:35:42.317Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "80KG/2022"}, {"id": "ccdd54b8-6266-4116-984b-32eff10f0e63", "buyer": {"email": "m6p6dzi9h5@allegromail.pl", "login": "Client:50180365"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0xMS0xM1QxODowNDoyNC4xNDlaO2J1eWVyOzI3MmQxMjVkMzllZTk2ZGJmNTk2MWEwNTkyMmI4Y2IxZDRjNTQzMjNiODgwZjg0MjM3ZDE0NDA2Y2EyNDNkNDU%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8e20f5e0-637d-11ed-a5bf-a1baed429958", "parcels": [{"sender": {"phoneNumber": "+48535356862"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-11-24T06:49:48.406Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-24T06:49:41.197Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8O02/2022"}, {"id": "2d39cb92-4896-40ad-90cf-93fbbe1028dd", "buyer": {"email": "8ouqzrpefl@allegromail.pl", "login": "rodzynst88"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-one-50x30-wieszak-wp50-d1-lan-12273794191?navCategoryId=20277&snapshot=MjAyMi0xMS0wOFQwODoxNjoyNi4xNjJaO2J1eWVyOzZmNmIxMTkwOGJiMjAxZjhhNDA0MGFhMTFiZDJkZThmODhmOTdmMWYwYTM2YjIyNGQ4NDQxNDgxOWU3MjdjMTM%3D", "name": "Szafka na buty One 50x30 Wieszak WP50 D1 LAN", "price": {"amount": "408.00", "currency": "PLN"}, "reason": {"type": "NOT_AS_DESCRIBED", "userComment": "Otrzymalam szafkę z szufladami zamiast szafkę na buty po rozmowie telefonicznej poinformowałam o zwrocie całkowitym zamówienia."}, "offerId": "12273794191", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "a0d87ee0-5f3d-11ed-8665-f3171c0e5f4b", "parcels": [{"sender": {"phoneNumber": "+48723565937"}, "waybill": "00159007738231974910", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-11-25T07:12:03.181Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-25T07:11:52.833Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "84XO/2022"}, {"id": "670863bc-3d06-4372-a9d9-6daf77c02266", "buyer": {"email": "cygwqpwyku@allegromail.pl", "login": "Joanna_ao10"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-lan-11678652560?navCategoryId=20277&snapshot=MjAyMi0xMS0xM1QxMjoxNzowMy43OTdaO2J1eWVyO2IxOTc2ZGZiZDY5NzdiYjg2ZTM5NWI0MWMyODQxM2RmNTY2YTVkNGY4NzQzMTA4MjZjNDA2OWI5Y2RmOTMxOGQ%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm LAN", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11678652560", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "b7d8b390-634c-11ed-a9e7-3ba9e926e6a9", "parcels": [{"sender": {"phoneNumber": "+48667268908"}, "waybill": "00159007738232650813", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-11-25T17:25:54.609Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-25T17:25:19.383Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8593/2022"}, {"id": "7a92d46b-4431-46fe-a5d5-ebda3a0eecfb", "buyer": {"email": "6n61ehm917@allegromail.pl", "login": "kamillo24buzka"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMi0xMS0yMlQxODozNTo0Ny4zMDdaO2J1eWVyOzVmNzFkMTYxNWQ4MmQ3OGI5ZWMzNDRjMGI4YjZlYTk3OTU1MjBjMWU3ZjUwZjAxMjkxMGE5ODRhNmEyN2FkNzE%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "56fa1f10-6a94-11ed-8683-75174dc2f989", "parcels": [{"sender": {"phoneNumber": "+48534812563"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2022-11-28T17:31:01.049Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-11-28T17:30:17.279Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LKX5/2022"}, {"id": "e7c533e0-fe77-4e66-ab8f-190a0b94a2d8", "buyer": {"email": "s1blkn1in7@allegromail.pl", "login": "ani1350"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v100x30d-siedzisko-schowek-100cm-so-11906888620?navCategoryId=20277&snapshot=MjAyMi0xMS0yNFQyMDoxOToyMC41NjNaO2J1eWVyOzMzZjFhNzMyNjU0YmJkYWE2NjAxN2Q5MWM0MmM1ZGRlYjdiMDE1ZTVlMWZjNjY1OTEwNTM0ZmI4ZDgxODE1YzA%3D", "name": "Szafka na buty V100x30D siedzisko schowek 100cm SO", "price": {"amount": "420.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11906888620", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "cc778ec1-6c34-11ed-b3f6-45a0d4a034f0", "parcels": [{"sender": {"phoneNumber": "+48693812018"}, "waybill": "00159007738243291616", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-12-07T20:04:42.177Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-07T20:02:16.145Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y32/2022"}, {"id": "b3b8b480-3bbf-4967-8389-55899c650c55", "buyer": {"email": "vc8eyrm4eu@allegromail.pl", "login": "dawidwet88"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-80x82x30-lan-12154906046?navCategoryId=20277&snapshot=MjAyMi0xMS0yM1QxMDowMjo1Ni4yMjJaO2J1eWVyO2RhOTFlMTUyOGM2NGFhOWI5YTliMmU3YWFhMGUzMTE0ZTEyOGM4MGYwYTk2ZDA3NzcwODU0MzUwMDM3NjVkYWI%3D", "name": "Szafka na buty z szufladą Tres 80x82x30 LAN", "price": {"amount": "439.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12154906046", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "ede868b0-6b15-11ed-b111-1f0e8ec9f686", "parcels": [{"sender": {"phoneNumber": "+48603953164"}, "waybill": "0000027592342T", "carrierId": "DPD", "createdAt": "2022-12-12T20:34:44.426Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-10T14:08:13.609Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7PP/2022"}, {"id": "af42b5a1-de82-4772-aae1-f167d515f1e4", "buyer": {"email": "sgs3j7xmku@allegromail.pl", "login": "miklisanna"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-lan-11678652560?navCategoryId=20277&snapshot=MjAyMi0xMS0zMFQxMDo1MjowMy41NTBaO2J1eWVyOzU0N2UwNDVkMmM2ZGFmODE2ODJmZjY1ZDU4OTdmNTQyMDE1NzQyZDkyMjYyMTNhM2FhZDM2ZWUxMTVkNmU1YmE%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm LAN", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11678652560", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?navCategoryId=20277&snapshot=MjAyMi0xMS0zMFQxMDo1MjowMy41NTBaO2J1eWVyOzM5NDljZGU4ZmYwZWFiNzhiNDZmOGFmMDhlMzdkMzliZWU5NWQ2ZDZkNWU2YjJkYzI3Y2M3ZmU3NTJlZmNmNDU%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d97a1860-709c-11ed-b9b0-f169eca286af", "parcels": [{"sender": {"phoneNumber": "+48791337706"}, "waybill": "00159007738254998061", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-12-19T16:04:42.896Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48791337706"}, "waybill": "00159007738256950159", "carrierId": "POCZTA_POLSKA", "createdAt": "2022-12-22T16:31:51.265Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-19T16:03:09.363Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L693/2022"}, {"id": "77b565af-1f6d-4ea7-92f8-5509b71293a2", "buyer": {"email": "uubyqh5cdu@allegromail.pl", "login": "petuniekicia"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-60x30x80cm-altus4-bc-4polki-10862942640?navCategoryId=20277&snapshot=MjAyMi0xMS0yNVQwOTo0Mjo0MS4yNTRaO2J1eWVyOzFhOTBjMjRkY2ZmNzdkYWFlYWFmZWYzYTIxZDc4ZTg4MDc1NWRlYTI3Yjc5NzQ4YWQ3YzM5ODBiOTQwOGFjZjA%3D", "name": "Szafka komoda na buty 60x30x80cm Altus4 BC 4półki", "price": {"amount": "419.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10862942640", "quantity": 1}, {"url": "https://allegro.pl/oferta/zestaw-komoda-vini4-wieszak-panele-60x30-bia-12208749919?navCategoryId=20277&snapshot=MjAyMi0xMS0yNVQwOTo0Mjo0MS4yNTRaO2J1eWVyO2JmZWRkMzI4MDIxMDc4ODg0MjVjMGMxYTAxOGJlZDFhNzI1MDBmMGJkNzIzOTY0YTkxN2RiMjA4NWE5NjUzNjM%3D", "name": "Zestaw Komoda Vini4 Wieszak Panele 60x30 Bia", "price": {"amount": "715.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12208749919", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "ab1aa580-6ca4-11ed-81e9-ab20b1a39a8c", "parcels": [], "createdAt": "2022-12-22T12:35:40.835Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8X1R/2022"}, {"id": "8745db07-3f1e-423f-845b-0d453b37adde", "buyer": {"email": "533h2rsks8@allegromail.pl", "login": "rucia_2005"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x80x20-na-wezglowie-11769317928?snapshot=MjAyMi0xMi0wMlQxMjozMzoyMS41NjRaO2J1eWVyOzhkOGEyN2IyMTY2Y2YzMGI0OWJkMzk1NDE2MjQ0N2ZkNGE0NGMwMDg5YTNhN2IwNjUzNDk2YTlmZTc2M2EyZjU%3D", "name": "Panel ścienny tapicerowany pan1x80x20 na wezgłowie", "price": {"amount": "55.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11769317928", "quantity": 4}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "23123240-723d-11ed-97c9-e5fe31a8f0fc", "parcels": [{"sender": {"phoneNumber": "+48506457925"}, "waybill": "1000548350054U", "carrierId": "DPD", "createdAt": "2022-12-29T15:22:21.405Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2022-12-29T15:21:45.105Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8GK2/2022"}, {"id": "88b0189c-99b6-4a52-bdae-71ec5da7bd5b", "buyer": {"email": "tv81p57q0h@allegromail.pl", "login": "ogrodniczka7"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMi0xMi0xM1QxMjozNjowMS4wODVaO2J1eWVyOzFiNTM3NmJkZGY0NWQxMDNhOTNmZDlhNmQ5YTI5MjhhYWQ4ZjQ3NThjYTEyNGIxOTFlMDcxYTYwNWQ3ZDY3OTM%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}, {"url": "https://allegro.pl/oferta/wieszak-scienny-wp60-na-ubrania-60cm-5-uchwytow-10983158854?navCategoryId=112733&snapshot=MjAyMi0xMi0xM1QxMjozNjowMS4wODVaO2J1eWVyO2JmNDE5MjhjMDMxMzkyMzRhNTMxNWJlZTU5YTFhNmQ5NWM2ZjExNjMxN2Y3NDFjNGJlOGIyOWQzZGM1NTllOGY%3D", "name": "Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów", "price": {"amount": "199.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10983158854", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "8bbb14f0-7ae0-11ed-933b-b3536ecd1b4d", "parcels": [{"sender": {"phoneNumber": "+48512072331"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-01-03T09:44:11.988Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-03T09:43:43.947Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8538/2023"}, {"id": "3192c306-e364-4ea5-943f-e19d5a08c0fb", "buyer": {"email": "4nvydm1gqs@allegromail.pl", "login": "mirsaw"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp60-na-ubrania-60cm-5-uchwytow-10983158854?navCategoryId=112733&snapshot=MjAyMy0wMS0wMVQxNzozMDoxOS4zNDM1NDJaO2J1eWVyO2E0Njk2MjM5MjU5YjNhMWE2YTdiMWFiMGYzNWNjZTZiYzYxOGRhZTg3M2ZiMDYwM2NkYTZiOGNlOGI1YjFmNzU%3D", "name": "Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów", "price": {"amount": "199.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10983158854", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "dc93d010-89f9-11ed-80d8-51cfcf6129a4", "parcels": [{"sender": {"phoneNumber": "+48601440142"}, "waybill": "1000550092359U", "carrierId": "DPD", "createdAt": "2023-01-04T15:04:01.751Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-04T15:01:23.553Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK5L/2023"}, {"id": "15e8fbdf-381d-4d21-a697-d7c8b9fd391b", "buyer": {"email": "zahv6z2si5@allegromail.pl", "login": "wrzesinscy_1"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-w80-na-ubrania-80cm-bialy-11711339631?navCategoryId=112733&snapshot=MjAyMy0wMS0xMFQxOTo0MDo1NS4zNjA5ODFaO2J1eWVyOzE2ODY1ZDJlMmM1MjY3ZTRjOGEzM2ZjNmRjOGEzOWUyM2RlOTUzMzA5MjU1ZmM0ZjhiMmI4Zjg4ZmE3YzY5ZDU%3D", "name": "Wieszak ścienny W80 na ubrania 80cm Biały", "price": {"amount": "179.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11711339631", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "9f4b1de0-911e-11ed-a39c-6f420a96a03d", "parcels": [{"sender": {"phoneNumber": "+48607192203"}, "waybill": "00159007738267011207", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-01-16T15:40:07.166Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-16T15:39:48.147Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Y2L/2023"}, {"id": "8aaafc7a-9079-4a88-903f-f2964700e6c8", "buyer": {"email": "i350fhry3b@allegromail.pl", "login": "Client:49665756"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x30d-siedzisko-schowek-80cm-so-10862742707?navCategoryId=20277&snapshot=MjAyMy0wMS0xMlQxNjowMzowOC4zNDQ1MzlaO2J1eWVyO2FiODBiYWJmMzJhNjk3Mzk0ZGY5NDI0MzE3Mzk5ZTRjYmI5MDk0ZmVhNjA0MTA3Zjc4MjU0MDEyMTZiMGUxYjQ%3D", "name": "Szafka na buty V80x30D siedzisko schowek 80cm SO", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10862742707", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "82fc5990-9292-11ed-8c13-b16aa31c2d9b", "parcels": [{"sender": {"phoneNumber": "+48665277671"}, "waybill": "1000554708950U", "carrierId": "DPD", "createdAt": "2023-01-17T15:33:41.629Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-17T15:32:23.877Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7P8/2023"}, {"id": "21fd7306-dfbc-4096-bac0-99a06803d4f9", "buyer": {"email": "fuh12469fq@allegromail.pl", "login": "NoFearProXic"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-50x30-bia-12170502124?navCategoryId=112735&snapshot=MjAyMy0wMS0yNlQxMTozMTo0OS4xOTUwMTdaO2J1eWVyOzY3ZDIwY2IxY2Y1Y2VmZDEyMDQzMjk4NjRkNzYxMzVhNTJiZGFlNWI1YWNmYTkzMjA3NzZkODU3YTYyMDlhMDg%3D", "name": "Komoda z szufladami Vini4 50x30 BIA", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12170502124", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "e91e9dc0-9d6c-11ed-b4cc-3799265c3a16", "parcels": [{"sender": {"phoneNumber": "+48533499505"}, "waybill": "1000557970532U", "carrierId": "DPD", "createdAt": "2023-01-26T11:36:41.339Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-26T11:36:30.841Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L638/2023"}, {"id": "fa93d739-43b7-4c1b-8fb6-d80800e0d5b0", "buyer": {"email": "oe7g3c4dms@allegromail.pl", "login": "Client:41397258"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-120x36cm-v60-supra60-4-panele-d2-bia-12256752651?navCategoryId=20277&snapshot=MjAyMy0wMS0wOVQyMDowNjo1Mi43NDM2NzZaO2J1eWVyOzI3MDNkZjIxNDhiMjUxMGI1MDhiZDAwOTU2YTYyNDAxNDFiMzIxMTk0MmY5OGYxYmU4OGJjNDZmNjAyMzdkNjc%3D", "name": "Garderoba 120x36cm V60 Supra60 4 Panele D2 BIA", "price": {"amount": "1590.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12256752651", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "14a944c0-9059-11ed-8948-1ff3e631d098", "parcels": [{"sender": {"phoneNumber": "+48796169780"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-01-26T16:59:12.801Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-01-26T12:10:25.451Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8XR8/2023"}, {"id": "b44d6172-d0cd-476a-b5e0-9dffd36fefd7", "buyer": {"email": "sfkq36w8ar@allegromail.pl", "login": "Dom993"}, "items": [{"url": "https://allegro.pl/oferta/zestaw-100x30d2alt-szafka-na-buty-z-siedziskiem-bi-12041613245?navCategoryId=20277&snapshot=MjAyMy0wMS0yOVQxMToyMDo0Mi4yNzQ4NDJaO2J1eWVyO2Q4MWEyYWQ3ZTgwMTAwNmRmNDlhYTkxZjQ4YjgxMGNjOWZlMDBjNDA1NWFhNDM5YzBkYzBhM2IxYmViZmU3ZDE%3D", "name": "Zestaw 100x30D2Alt szafka na buty z siedziskiem BI", "price": {"amount": "638.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12041613245", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "cade4a20-9fc6-11ed-b60a-b171142c24de", "parcels": [{"sender": {"phoneNumber": "+48694128480"}, "waybill": "00159007738279029221", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-02-13T15:39:20.863Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-11T13:57:51.769Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G2L/2023"}, {"id": "86a7e875-0f33-4fef-a28d-b220fb73b699", "buyer": {"email": "dkgxi4osvy@allegromail.pl", "login": "GERMANMOTORS"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-lan-12170497248?navCategoryId=112735&snapshot=MjAyMy0wMi0wOFQyMDoxMjowOS4zNzYyNDlaO2J1eWVyO2JkMDA2ZGNiZDQ5ZWJhNTlkODM4M2FkMzJiZGJlMDVhMDY0YmZiNzYwMjY4NWFmYTY2YWViNzgwZGNiMWQyZjc%3D", "name": "Komoda z szufladami Vini4 80x30 LAN", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12170497248", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "ca841e50-a7ec-11ed-b0d9-b1ab253f2ccf", "parcels": [{"sender": {"phoneNumber": "+48502965197"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-02-15T09:40:25.053Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-15T09:40:08.303Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NML/2023"}, {"id": "7a7dbea1-d135-4529-b014-fa862733bc54", "buyer": {"email": "aelip00irp@allegromail.pl", "login": "diana_0502"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-w60-na-ubrania-60cm-sonoma-11711327105?navCategoryId=112733&snapshot=MjAyMy0wMi0xNVQxNjozMzo0OS44ODEzNTRaO2J1eWVyOzRkYjYyZDA3NDQyMDgyNGMwNTAxZTA3ODMwODhkN2YzOTY3YWYzZGVlNDczYmEyNGU0ZTZiMmNlODYwNGU0ZTY%3D", "name": "Wieszak ścienny W60 na ubrania 60cm Sonoma", "price": {"amount": "159.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11711327105", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "6b548930-ad4e-11ed-b35a-7b06533a7a06", "parcels": [], "createdAt": "2023-02-20T18:38:05.016Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LRXL/2023"}, {"id": "d6fa469c-ec60-4f6e-ab62-25f8923becd7", "buyer": {"email": "u4ltuwo0wy@allegromail.pl", "login": "tomaszy"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-leo50x30-siedzisko-szuflady-d2-bia-12248274556?navCategoryId=20277&snapshot=MjAyMy0wMi0yM1QxOTo0MToxNC41MzUzNDZaO2J1eWVyOzc4NDJiYWRkYzRmMTc0MDgzMjYyYzZkNTA0ODNiNDZiMzQ1NTkzYmYwZDFmMjA4Y2M4OGVmZGRjYWVmMThmM2Y%3D", "name": "Szafka na buty Leo50x30 siedzisko szuflady D2 BIA", "price": {"amount": "279.00", "currency": "PLN"}, "reason": {"type": "OTHER_FLAW", "userComment": "brak kontaktu ze sprzedającym mimo mojego monitu odnośnie zamówienia , wysyłałem sms, dzwoniłem telefonicznie , pisałem wiadomości że jest błąd w zamówieniu , żadnego odzewu , ale fakturę wystawiono czyli ktoś pracuje , nie rozumiem takiego podejścia do klienta , w wiadomości do sprzedającego wpisywałem kolor obszycia ciemny grafit ( żona świadkiem siedziała obok podczas zamawiania) po otrzymaniu maila że jest realizowanie zamówienie ale z innym obszyciem sprawdziłem że mojej informacji nie ma ."}, "offerId": "12248274556", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "d52776b0-b3b1-11ed-a014-35a5e4462688", "parcels": [{"sender": {"phoneNumber": "+48502976966"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-02-25T19:13:23.972Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-25T19:12:21.842Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PWL/2023"}, {"id": "246e5f9e-4fa6-4e0e-8508-0e735aaaf992", "buyer": {"email": "hk3m146o0g@allegromail.pl", "login": "Client:46221542"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v60x36d-siedzisko-schowek-60cm-bc-10862764095?navCategoryId=20277&snapshot=MjAyMy0wMi0xMFQwNzoyNjozNS42MjMwOTlaO2J1eWVyO2UwM2MxYmUwM2MxZTk2MTMyOWI2NzRlYzRkZDQ2YzczMmM2NDI1ZDVmOTQzOTJhZmNiZjJlYjM0NjI5NmI5OTY%3D", "name": "Szafka na buty V60x36D siedzisko schowek 60cm BC", "price": {"amount": "289.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10862764095", "quantity": 1}], "refund": null, "status": "FINISHED", "orderId": "0cae5310-a912-11ed-85d6-f358e0aad7a0", "parcels": [{"sender": {"phoneNumber": "+48722430500"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-02-27T22:38:56.354Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48722430500"}, "waybill": "0000028537824T", "carrierId": "DPD", "createdAt": "2023-03-05T21:36:20.417Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-02-27T22:34:18.609Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L2XL/2023"}, {"id": "9f699a2e-a8c4-48ee-aea2-c67540c1fa25", "buyer": {"email": "jh6uqa919z@allegromail.pl", "login": "Pielegniareczka8"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x60x35-11769356716?navCategoryId=258819&snapshot=MjAyMy0wMi0yNlQxNDozMDowMC4wMzE5MDBaO2J1eWVyOzkyOWZmZTM1YTgwYzQyODFiMmM3NmFhN2NiMzcyYjE1NmJhMzgwYWVmM2UyODZlNzZlOTE2N2FiZWEyMGIxN2E%3D", "name": "Panel ścienny tapicerowany pan1x60x35", "price": {"amount": "55.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11769356716", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-na-buty-v60x36d-siedzisko-schowek-60cm-bc-10862764095?navCategoryId=20277&snapshot=MjAyMy0wMi0yNlQxNDozMDowMC4wMzE5MDBaO2J1eWVyOzRkMTFkYTg4YWMwMmQzMjVkYTQ3Mjg1OGU1MGU1NTI4ZDU5YjJkNzg0ZWI4N2JjNThjYWNmYzZhMDdiZGFlMmQ%3D", "name": "Szafka na buty V60x36D siedzisko schowek 60cm BC", "price": {"amount": "289.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10862764095", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x36x82-bia-12266463826?navCategoryId=20277&snapshot=MjAyMy0wMi0yNlQxNDozMDowMC4wMzE5MDFaO2J1eWVyOzAxMTQ0ZDIxZGU4NDcwMmU0OWU1N2Q2MGFhOTM3NDhkM2U2NjhiOGZmMTJlOWIzNjFmZmNjNGE1N2EwYTkxZmQ%3D", "name": "Szafka na buty z szufladą Tres 30x36x82 BIA", "price": {"amount": "205.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266463826", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "7ae01bd0-b5e1-11ed-96e3-ed7d5c9f46d7", "parcels": [{"sender": {"phoneNumber": "+48506848585"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-03-02T07:38:12.099Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-03-02T07:23:04.834Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LWKL/2023"}, {"id": "71491f86-5073-45a7-b9cd-0bbdd053d683", "buyer": {"email": "2e5zj2fmig@allegromail.pl", "login": "bogdandumala"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-bia-12170501801?navCategoryId=112735&snapshot=MjAyMy0wMy0wMVQxNjo1ODoxMC4xOTE1MjVaO2J1eWVyO2I2MmVjMGEwOGQyZDliYmY0ZDNjMjkxZDE4OWViZWZhYzU0YmU1NGZlYTVlYzYwYTcyNDZmN2M4YjIzODQzMDE%3D", "name": "Komoda z szufladami Vini4 80x30 BIA", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12170501801", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "3a0e05e0-b852-11ed-b651-3791ad49b98e", "parcels": [], "createdAt": "2023-03-08T13:35:11.182Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8M38/2023"}, {"id": "b5ffa941-615e-459b-9fc3-5792a211b330", "buyer": {"email": "fm6zaxabo8@allegromail.pl", "login": "Client:41974733"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-leo80x30-siedzisko-szuflady-d2-bia-12248368429?navCategoryId=20277&snapshot=MjAyMy0wMy0yOFQwNzoyMjo1Mi4wNzU4NDJaO2J1eWVyOzRjMmM2MjNhYjY3YTM3ZWU0YTk4Y2ExOWIwYTYwMzY4OWJmM2ZjZTZmMGE5N2E3NzRlNjhkYzc2YWI1OTBhNWY%3D", "name": "Szafka na buty Leo80x30 siedzisko szuflady D2 BIA", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12248368429", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "90e060c0-cd38-11ed-bc78-39c77bbc1a0b", "parcels": [], "createdAt": "2023-04-01T10:01:13.672Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L37L/2023"}, {"id": "25827ffa-20c8-48b9-b46c-5c73c4e92cbf", "buyer": {"email": "v4cxfvokme@allegromail.pl", "login": "lemandrole"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-so-12266500239?navCategoryId=20277&snapshot=MjAyMy0wMy0xN1QxNDoxNToyMS42MjAzNTZaO2J1eWVyOzQzODY0MzkwZjljZmViYzg4MDA4MzA4YmZlNjNiM2IwYzI3NTViYjRjNzZjYWEyNjlmOWUwYWM1M2RiZjc0YTg%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 SO", "price": {"amount": "1080.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266500239", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "0d52ca30-c4ce-11ed-9d26-33cba196705d", "parcels": [{"sender": {"phoneNumber": "+48606412119"}, "waybill": "00159007738293411156", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-04-05T08:18:50.368Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-04-05T08:18:26.820Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "89Q8/2023"}, {"id": "a9a933ee-933d-456b-bd92-0a3c5ea735db", "buyer": {"email": "zio1c9b51w@allegromail.pl", "login": "dimmu113"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x36p2wpb-szafka-na-buty-wieszak-panele-11743135331?navCategoryId=20277&snapshot=MjAyMy0wMy0zMFQxMjoyMzoxNS40MzIxOTVaO2J1eWVyOzA0ODM2ZTdlYTI2NjBkZWFkNGI5MGFiMTg3ZmVjOTdhYzgyMjk5MTc0MzkwNWUxMGJkNDZjNmUyODY2NjAyZGE%3D", "name": "Garderoba 50x36P2WPB szafka na buty wieszak panele", "price": {"amount": "550.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11743135331", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "296eccb0-cef5-11ed-8a5f-017a3724e12e", "parcels": [], "createdAt": "2023-04-17T14:28:55.028Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8JN8/2023"}, {"id": "5821905b-adf8-4d65-b846-9f727669d6e2", "buyer": {"email": "et9evk0hpa@allegromail.pl", "login": "Client:37533616"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-80x30x80cm-altus4-so-4polki-10862972212?navCategoryId=20277&snapshot=MjAyMy0wMy0zMFQxOToyNToxMi4yMDYwMDFaO2J1eWVyO2UxZDZiNDNiNzZjYmE2ZDcwYTlmNjNhNWUwODc5NDMyZWQ1MzdlODM2OTRlMDdiZDE0YzRjMjdhM2ExYTliY2U%3D", "name": "Szafka komoda na buty 80x30x80cm Altus4 SO 4półki", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10862972212", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "f0d61d51-cf2f-11ed-804f-b95d23bee293", "parcels": [{"sender": {"phoneNumber": "+48502579089"}, "waybill": "1000590532594U", "carrierId": "DPD", "createdAt": "2023-04-19T20:32:59.495Z", "transportingWaybill": null, "transportingCarrierId": null}, {"sender": {"phoneNumber": "+48502579089"}, "waybill": "00159007738296634309", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-04-24T13:01:52.238Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-04-19T18:45:06.131Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LZXL/2023"}, {"id": "449808e3-d941-4325-90ef-738444b23ed3", "buyer": {"email": "lx4yrj55ny@allegromail.pl", "login": "katnos"}, "items": [{"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-60x36x202d1-lan-12263595440?navCategoryId=20277&snapshot=MjAyMy0wNS0xNVQwOTozMjozNS41NTA4NjhaO2J1eWVyOzQ3ZjcyYTdhNzVhY2RmMjgxYTZiYjJmNzNjZDdjNjQ3ODAyOWQ1NzMxNjgxYTExZTU5MTRlMjc2YjcyYWE5ZWI%3D", "name": "Szafka szafa komoda wysoka supra T 60x36x202D1-LAN", "price": {"amount": "869.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12263595440", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "79b124d0-f302-11ed-967e-adbeefcaaec4", "parcels": [{"sender": {"phoneNumber": "+48504710944"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-05-23T11:17:09.296Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-05-23T10:38:15.493Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L1ML/2023"}, {"id": "30de3631-9e38-4bd3-a43a-7f3d9e6306d7", "buyer": {"email": "3q9p9vjfpk@allegromail.pl", "login": "gienekgut102"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-60x30-d2-sonoma-12208159616?navCategoryId=20277&snapshot=MjAyMy0wNS0yNVQyMDowODo0My4yNzA2NTdaO2J1eWVyOzcyMWVjNTFiZmNlNjJjODM3Mzc4YmJjM2M4ZjY2MmJmNDRlNmFhZjQxOTMzZWQ3NGYwOWE5MGI3NDgwYTA2MjY%3D", "name": "Szafka na buty z szufladą Tres 60x30 D2 Sonoma", "price": {"amount": "499.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12208159616", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "375da350-fb37-11ed-bb71-a3f983f3b2ab", "parcels": [{"sender": {"phoneNumber": "+480505397063"}, "waybill": "00159007738300655740", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-06-05T16:36:58.715Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-06-04T18:23:51.819Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Q0L/2023"}, {"id": "2684a2bb-6a65-46da-9164-882153aa9662", "buyer": {"email": "bap2nlz7gv@allegromail.pl", "login": "mumin201413"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-lan-12154896248?navCategoryId=20277&snapshot=MjAyMy0wNi0xMFQxMToyNzo1NS4yNTM2NjJaO2J1eWVyO2IxZDRhYzA5NWEwZDVhNWNiN2M1ZGEzY2M1MGVmYzQyZjA0YzU3N2FhYTg4Mjk1NGRmNWU4MDJkMWMyNmEwYTM%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 LAN", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12154896248", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "c45674c0-0781-11ee-9dff-930f60850fef", "parcels": [{"sender": {"phoneNumber": "+48667069198"}, "waybill": "00159007738301484752", "carrierId": "POCZTA_POLSKA", "createdAt": "2023-06-24T09:12:02.069Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-06-24T09:11:44.253Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "80GL/2023"}, {"id": "45991f08-cb60-40ca-b86f-1c5addff085a", "buyer": {"email": "axrsjz8t52@allegromail.pl", "login": "Client:101347531"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x36p2wpb-szafka-na-buty-wieszak-panele-11743135331?navCategoryId=20277&snapshot=MjAyMy0wNi0xMlQxMDo1NzoyMy4wNzY3MDFaO2J1eWVyOzYyYTNiN2U3MTY0YTI5ZTkyNjkxYjUzMWY4MTA5YjQ0MDdhNTVhMmY1ZDgwYjVjNTE0YTk5YTQzNGVhNWU2Mjk%3D", "name": "Garderoba 50x36P2WPB szafka na buty wieszak panele", "price": {"amount": "550.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11743135331", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-60x36x202d1-lan-12263595440?navCategoryId=20277&snapshot=MjAyMy0wNi0xMlQxMDo1NzoyMy4wNzY3MDVaO2J1eWVyOzQwMTg4NzMxZWI1OWNhNjlmZTA3MjgzOGU2MWQ0NTUxODg2YjVlOWVkYWZkNzllZGQxNDg1MTljYTZiZDViYTA%3D", "name": "Szafka szafa komoda wysoka supra T 60x36x202D1-LAN", "price": {"amount": "869.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12263595440", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "bdb550c0-090f-11ee-b26a-63d4d6710586", "parcels": [], "createdAt": "2023-06-25T10:29:19.034Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8O2L/2023"}, {"id": "54c09af5-6276-4b88-afc3-17753020f9b6", "buyer": {"email": "e0fm1d8zmp@allegromail.pl", "login": "Client:102638027"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-panele-11743127497?navCategoryId=20277&snapshot=MjAyMy0wNi0xOVQxODo1NzozOC4xNjMwODBaO2J1eWVyOzI3OWU4ZGFmOWYxYmMyYjFkNWZhYzZlMjUzZWNmZjcyMDYyZDZiZTlhYjVjYmQ5ZTc2Njk3ZTViZTFmNzYzYzU%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak panele", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11743127497", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "7ccaca90-0ed2-11ee-8ca6-e5ccdc8341ed", "parcels": [], "createdAt": "2023-06-26T17:51:56.768Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "841O/2023"}, {"id": "e5334b3c-66ae-441d-a9be-37aa4b9b676e", "buyer": {"email": "gc3vdcm2uw@allegromail.pl", "login": "mipweiss"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp50-ubrania-50cm-4-haki-lancelot-13463849818?navCategoryId=112733&snapshot=MjAyMy0wNi0yM1QxNDo1Mjo0MC4wMzI3NzQ0MDVaO2J1eWVyOzFjYjQ3YmMxNjc1MTQ0NWU4YjkyNTBhNjFhMzY1NTc0NGMyYWE5ODE0N2QxZGY0YjE5ZDZlOTdmN2ZiMmYwODY%3D", "name": "Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot", "price": {"amount": "189.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "13463849818", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "850e09a0-11d5-11ee-9b0d-f1f8bf5a1afa", "parcels": [{"sender": {"phoneNumber": "+48721812120"}, "waybill": "1000619916788U", "carrierId": "DPD", "createdAt": "2023-07-03T11:29:12.689Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-07-03T11:27:14.068Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8533/2023"}, {"id": "02f337c6-b973-4479-81b7-f3c9639c78b5", "buyer": {"email": "kvrjdcy31j@allegromail.pl", "login": "15DD"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x36-sonoma-11873255183?navCategoryId=20277&snapshot=MjAyMy0wNy0wN1QxMTozMzo1My45NzMyOTkyOTZaO2J1eWVyOzhiNjMwNGE1NzhlYTJkODZlNGI2YTk2ODMyYjFiYmJmZWY1MzczNzk1OGFiNGU5M2E4MjliMWQ2NTM4ODQzMDQ%3D", "name": "Szafka na buty z szufladą Tres 50x82x36 SONOMA", "price": {"amount": "369.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11873255183", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "fb59adf0-1cb9-11ee-8dd2-9da167ce05a3", "parcels": [{"sender": {"phoneNumber": "+48696763737"}, "waybill": "1000623028175U", "carrierId": "DPD", "createdAt": "2023-07-11T05:34:12.274Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-07-11T05:33:34.631Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK25/2023"}, {"id": "eb39e2b6-a330-4ca3-ab60-217d16e99b5b", "buyer": {"email": "9aouignyyw@allegromail.pl", "login": "Client:95430342"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v60x30d2-siedzisko-schowek-60cm-10945440206?navCategoryId=20277&snapshot=MjAyMy0wNy0wOFQxMzowMjo1MS4zMTE1NzIzMzlaO2J1eWVyO2Y3Njg0MDY5NTI1OTQ5YTQ4ZjcxMWIzNTVkNzg4Mzk2M2VmZGE3ZjU5MzA0OWFhYzAxNTEzNTY0OTZjOGFkNGM%3D", "name": "Szafka na buty V60x30D2 siedzisko schowek 60cm", "price": {"amount": "289.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10945440206", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "5c075fa0-1d8f-11ee-a0ae-b1fbbfc07fa7", "parcels": [{"sender": {"phoneNumber": "+48693720998"}, "waybill": "0000030077553T", "carrierId": "DPD", "createdAt": "2023-07-13T10:07:42.948Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-07-13T10:02:43.470Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8YQ2/2023"}, {"id": "fe543a53-b9bb-46d2-8111-b99f18070ef3", "buyer": {"email": "4opzn7ooam@allegromail.pl", "login": "Client:110217585"}, "items": [{"url": "https://allegro.pl/oferta/szafka-komoda-na-buty-60x30x80cm-altus4-so-4polki-12147316429?navCategoryId=20277&snapshot=MjAyMy0wNy0yM1QxNTowNDowMy4yODk3MTM0MzdaO2J1eWVyO2NmNWEyMzYwNDk1ZmJmZjc1ZTg1YTgzNmY1YmU2YjJiZTE0ODNjZTE1NTBmZjRkNzljOTZhYmI3NTBjZTYxMDE%3D", "name": "Szafka komoda na buty 60x30x80cm Altus4 SO 4półki", "price": {"amount": "419.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12147316429", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "1182a1b0-296a-11ee-8279-9da167ce05a3", "parcels": [], "createdAt": "2023-07-26T14:45:40.887Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L7JP/2023"}, {"id": "ba17c5b0-e84b-4787-b876-b20c66c998a6", "buyer": {"email": "9e3d418xgl@allegromail.pl", "login": "Client:108118240"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x30x82-bia-12266463730?navCategoryId=20277&snapshot=MjAyMy0wOC0wNVQwOTowMDoyMS44MzYxNTU4MDRaO2J1eWVyOzBmYjYzZTcxMjMwMGY0MzNlYWZlOWIxYmFmMzlhZTVhNjdmMDM3YTI0MTlmNDQ3ZmM3ZmUwNGEzMWQ5YTFkOWQ%3D", "name": "Szafka na buty z szufladą Tres 30x30x82 BIA", "price": {"amount": "195.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12266463730", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "56168681-336e-11ee-84cd-a915ead073d8", "parcels": [{"sender": {"phoneNumber": "+48883145916"}, "waybill": "1000636294395U", "carrierId": "DPD", "createdAt": "2023-08-12T22:36:18.690Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-08-12T22:35:34.902Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L6N3/2023"}, {"id": "fec44e5f-05d1-41fd-9a95-1751ca5b4ebe", "buyer": {"email": "g3p5tr7clq@allegromail.pl", "login": "athlon63"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-wieszakiem-60x30wp60-s2d1-cza-wot-13877637961?navCategoryId=20277&snapshot=MjAyMy0wOC0yMlQxNzoxMDoyNC41MzU0MjA5NDlaO2J1eWVyOzllMTMzYzJkNzNiMTk0NDBlNDlkZWRkN2E5YjliZDRjYmI3YmNlMzZiMjkyNTExNzM5YzdlNWQ5MmZlNWJjOWM%3D", "name": "Szafka na buty z wieszakiem 60x30WP60 S2D1 CZA-WOT", "price": {"amount": "548.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "13877637961", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d6b3baa0-410c-11ee-9739-b378715ebc84", "parcels": [{"sender": {"phoneNumber": "+48723504869"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-08-28T07:55:34.896Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-08-28T07:55:20.529Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8XKR/2023"}, {"id": "7bd44e5d-8df6-46f6-899c-3c0ff8a9c190", "buyer": {"email": "znoxgd90x1@allegromail.pl", "login": "rogalikja"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-90x30cm-v60-supra30-4-panele-d1-so-12266500239?navCategoryId=20277&snapshot=MjAyMy0wOC0yN1QxODoxNjo0Ny4wNDMxMzY2MzVaO2J1eWVyOzlkNDRjZWNiYmViZjRjM2E5YWYxNDk1YzFhNDY1YTgyZTkxOTEwOTRmOTgxNGMzYzQ3MjViMmQwY2FmODIzNjE%3D", "name": "Garderoba 90x30cm V60 Supra30 4 Panele D1 SO", "price": {"amount": "1080.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12266500239", "quantity": 1}, {"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-60x82x30d1-so-12224099030?navCategoryId=20277&snapshot=MjAyMy0wOC0yN1QxODoxNjo0Ny4wNDMxMzY5NTZaO2J1eWVyO2ZhZGVlOTMwMzJkM2M3NWJmY2U5ZTJiYjAyMDMwYzRiYjI0OWJkMzJiNzg5NjE1ZDNkNDQ4MmFiOTUzMTZlNzQ%3D", "name": "Szafka szafa komoda wysoka supra T 60x82x30D1-SO", "price": {"amount": "839.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12224099030", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "bc02b0b0-4505-11ee-b1fc-8d501ab0fe91", "parcels": [{"sender": {"phoneNumber": "+48508201278"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-08-30T03:43:19.061Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-08-30T03:43:05.675Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8G42/2023"}, {"id": "9a162908-a466-4e9b-bc2f-1f2ef444bd49", "buyer": {"email": "y0or79vjqy@allegromail.pl", "login": "matrix510"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-50x82x30-sonoma-11873232153?snapshot=MjAyMy0wOC0zMFQxMjozODowMy4xMjkyNDUwNjlaO2J1eWVyO2JmNzcxZDM0ODk1YTY4YzljZDI0YzcxZDYwYWJmM2VmMWY0YmJlNWNjZWMyODM3ZmE1YzQxZjE3OTQwM2EyYWI%3D", "name": "Szafka na buty z szufladą Tres 50x82x30 SONOMA", "price": {"amount": "349.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "11873232153", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "01eed3f0-4732-11ee-9905-85ad35cb2fe9", "parcels": [], "createdAt": "2023-09-03T15:16:26.492Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8NNM/2023"}, {"id": "6f5c2275-fdd4-4b70-9460-c573fab3defd", "buyer": {"email": "v4wjsu92o9@allegromail.pl", "login": "soundmv"}, "items": [{"url": "https://allegro.pl/oferta/komoda-z-szufladami-vini4-80x30-bia-12170501801?navCategoryId=112735&snapshot=MjAyMy0wOC0yMFQxNTozMDowNC40MjcwMzc1NDRaO2J1eWVyOzM1YmU5ZGRjYmRjY2Q1Y2ZkY2NkODczNjE5M2NjNzE4ZTVhNDU0MTgwYWVkY2QzY2Y4ZjZjMDc5NmQyNDcyNWI%3D", "name": "Komoda z szufladami Vini4 80x30 BIA", "price": {"amount": "389.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "12170501801", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "57e67ea0-3f6e-11ee-a49c-cb75f3118c88", "parcels": [], "createdAt": "2023-09-05T06:57:24.780Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LRNX/2023"}, {"id": "e46259e3-b4e4-44fb-b7de-86440ffc659f", "buyer": {"email": "4jddg2xfzk@allegromail.pl", "login": "Client:37017348"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-150x30cm-szafka-na-buty-czarny-bialy-14019382790?navCategoryId=20277&snapshot=MjAyMy0wOC0yOFQwNjoxOTo1Mi44NzM1MzkzNDBaO2J1eWVyOzY1MGI3OGZkZjA0ZDMwMTQwYThiNTI0MDY3MzI0MTdhY2Q5NDM3N2JhMzk4MWQwNDM1ODE2YzdlOTFiYmJjM2U%3D", "name": "Garderoba 150x30cm szafka na buty Czarny Biały", "price": {"amount": "2040.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14019382790", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d39ac6d0-456a-11ee-b394-8b61ccf71fe7", "parcels": [{"sender": {"phoneNumber": "+48608166665"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-09-11T11:34:18.138Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-07T13:37:28.942Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8PKW/2023"}, {"id": "a5c134e2-652b-4300-a71e-7a5aa5cd6b3b", "buyer": {"email": "cv6iy6hfgq@allegromail.pl", "login": "mcholast"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v80x36d2-siedzisko-schowek-80cm-10945458023?navCategoryId=20277&snapshot=MjAyMy0wOC0zMVQwOToyMTozMC44MjM1NDkzMThaO2J1eWVyO2FiYWQ4ZWNiZWI1MmJjYjQ1ZWQ5OWVlNWEwODQzZTc3ZDEwOGZiYjI4MTA5YzA4ZWU4YmM5NjJhN2MzYTJjMGY%3D", "name": "Szafka na buty V80x36D2 siedzisko schowek 80cm", "price": {"amount": "409.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "10945458023", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "a56c6e90-47df-11ee-8241-c1f9a2c2127c", "parcels": [{"sender": {"phoneNumber": "+48601663058"}, "waybill": "0000030728320T", "carrierId": "DPD", "createdAt": "2023-09-07T15:57:56.370Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-07T15:55:32.977Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L2KX/2023"}, {"id": "2a814581-9ed0-469c-a40e-62d54950a231", "buyer": {"email": "6h995o9w56@allegromail.pl", "login": "Client:85949222"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-i-siedziskiem-60x30dp3b-11750362603?navCategoryId=20277&snapshot=MjAyMy0wOS0wM1QxNzoxMzozNC4wNzAyNDIyMTNaO2J1eWVyOzM0NzM0ZDEwOGQyYmM1ZWRjMzdlM2QyYjM2ZmEyNTM4NzI5OTJkYTczZGQwMWYyMWNiYWUyZTNlMWEzNjNjMmM%3D", "name": "Szafka na buty z szufladą i siedziskiem 60x30DP3B", "price": {"amount": "977.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11750362603", "quantity": 1}], "refund": null, "status": "DELIVERED", "orderId": "0b0c7fc0-4a7d-11ee-b1fc-8d501ab0fe91", "parcels": [{"sender": {"phoneNumber": "+48600178360"}, "waybill": "0000030776315T", "carrierId": "DPD", "createdAt": "2023-09-11T14:10:08.011Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-11T14:05:36.712Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LWJK/2023"}, {"id": "b28c560e-9f60-40c9-90bc-95dd782b0cee", "buyer": {"email": "lxg279ni4d@allegromail.pl", "login": "kriss1796"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-80x30cm-v50-supra30-4-panele-d1-bia-12487594410?snapshot=MjAyMy0wOS0yNVQwODoxMjoyMy4yMzk4MzIxNDJaO2J1eWVyO2FkZjFjZjk1YzJiYzIxMDE3ZWMwZGE1NDZhNzI4N2JkY2VkY2EyM2MzODgwMjUxNGRjM2JiNTk4M2NkNGZkYmE%3D", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA", "price": {"amount": "1049.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12487594410", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "d6513240-5b79-11ee-830c-7d59f32dd4e6", "parcels": [{"sender": {"phoneNumber": "+48796227152"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-09-25T11:49:46.025Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-09-25T11:48:53.009Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8MX3/2023"}, {"id": "16dafb80-0c8d-4487-985d-6cf5111453f9", "buyer": {"email": "lk2ou3hv1o@allegromail.pl", "login": "36674398"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-so-10862725041?navCategoryId=20277&snapshot=MjAyMy0xMC0wMlQxMzozNDozNC4zNTAwNjc5MTdaO2J1eWVyOzM3ZjNmZGE5Yjk2MzBkMmI1M2U2MTAyMjgzZjIxMjlmMzFmZmMwNzU0YWU3NGQ0ZmI2MWExMGM1N2ZiNWUyYTc%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm SO", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "10862725041", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "192008e0-6128-11ee-bbd6-1103d1757491", "parcels": [{"sender": {"phoneNumber": "+48664914912"}, "waybill": "1000659329417U", "carrierId": "DPD", "createdAt": "2023-10-06T14:06:25.821Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-10-06T14:00:21.852Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L307/2023"}, {"id": "01d2382e-691b-4bdf-8e44-ac1ae35bc1b4", "buyer": {"email": "28hkf1eot2@allegromail.pl", "login": "Client:100184163"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-supra-30-slupek-30x36-d1-bia-12266374192?navCategoryId=20277&snapshot=MjAyMy0xMC0wMVQxNjoyNjo0MC4yMzU0Mjc3NTZaO2J1eWVyOzY5MTcxMThlN2ZjYjQxYjBhNTkwMDBmZWUwYWUyYzA4NDA3ZTBhNmM5NWY0ZjI0NThlNmI2ZGRhMTk2NmM4MTU%3D", "name": "Szafka na buty Supra 30 słupek 30x36-D1-BIA", "price": {"amount": "459.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266374192", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "3fcc6a80-6077-11ee-b19c-658ad462c24b", "parcels": [], "createdAt": "2023-10-06T18:52:00.365Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "899Q/2023"}, {"id": "df8d1696-7b67-4a26-b41b-c63be35faa6f", "buyer": {"email": "ngt6hoaips@allegromail.pl", "login": "Client:46288752"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-sonoma-14030767203?navCategoryId=20277&snapshot=MjAyMy0xMC0xM1QxMjo1MDoyNC44MDgyMDgzNjRaO2J1eWVyOzhkZGZiMWEyN2E4NjZlYmI5ODA0YWEzNDVmYTEyM2VmNTc1NWViN2ZiYjQ1YzdhZmUxNDJkODU0MzI2Mzg0YTQ%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak Sonoma", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "14030767203", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "958d98b1-69c6-11ee-955e-d544f30d6fa9", "parcels": [], "createdAt": "2023-10-16T13:20:03.231Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8J6N/2023"}, {"id": "8663bc18-6167-4faf-a38e-3ddaab8cb6fd", "buyer": {"email": "a296sg4rsa@allegromail.pl", "login": "Client:111318418"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x36p2wpb-szafka-na-buty-wieszak-bialy-14388158063?navCategoryId=20277&snapshot=MjAyMy0xMC0wNVQxODoyMToxMi40NTUwMzQyMTJaO2J1eWVyO2Q4ZjY1MTFlNTc2MzRkNzUxMjUwZGRmYTYyM2U3NmZlNGMwNWNlNmQ5YTk0NzZhNDExOTNhZGU4NjYzZjYxODI%3D", "name": "Garderoba 50x36P2WPB szafka na buty wieszak Biały", "price": {"amount": "449.00", "currency": "PLN"}, "reason": {"type": "OTHER_FLAW", "userComment": "Boki szafki nie pasują bo są dwa lewe\\nProszę o kontakt to jest mój numer telefonu \\n609586769"}, "offerId": "14388158063", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "cb6ba150-63ab-11ee-8260-77f5b5733a57", "parcels": [{"sender": {"phoneNumber": "+48609586769"}, "waybill": "0000031199976T", "carrierId": "DPD", "createdAt": "2023-10-18T17:34:03.330Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-10-18T17:26:21.738Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LZZX/2023"}, {"id": "9f6641cf-2820-49a0-a3fb-d682797e468b", "buyer": {"email": "3r4leruqq7@allegromail.pl", "login": "Kca09"}, "items": [{"url": "https://allegro.pl/oferta/szafka-szafa-komoda-wysoka-supra-t-50x30x202d1-bia-12476571569?navCategoryId=20276&snapshot=MjAyMy0xMC0wOVQxNTozNDozMC42ODI4MzM5NzdaO2J1eWVyOzQ5ZmIwZjJhZDgxNDZkNTg1N2E0NGQ2MmM3YjM1ZGM4ZjkzZDMwYTE0OTg1ZWE1YjhmYTAwMTNlOWQ5ZTE4ODU%3D", "name": "Szafka szafa komoda wysoka supra T 50x30x202D1-BIA", "price": {"amount": "788.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "12476571569", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "3023cea0-66b9-11ee-b166-35f9e46bff2b", "parcels": [{"sender": {"phoneNumber": "+48881695442"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-10-25T06:36:14.061Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-10-25T06:35:48.060Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L1YM/2023"}, {"id": "68e06b9e-ee45-45a4-802a-28d36ab3e3d3", "buyer": {"email": "23cj9uvljp@allegromail.pl", "login": "Karolciiia15"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v50x30d-siedzisko-schowek-50cm-bc-10814138050?navCategoryId=20277&snapshot=MjAyMy0xMC0wN1QwNzo0NjoyMi45OTg5MDMzMTRaO2J1eWVyOzQ0M2E3NDcwNjNjMmY0N2Y4ZjljYTI3NDg1ZDdjZGE1OTViYThmZWVjOTY1YjQ4ZGM4ZDE4OGJkOWIxMDUxZjQ%3D", "name": "Szafka na buty V50x30D siedzisko schowek 50cm BC", "price": {"amount": "249.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "10814138050", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "f909e380-64e4-11ee-91a7-dfeb98527315", "parcels": [], "createdAt": "2023-10-27T06:44:34.571Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8Q10/2023"}, {"id": "a2ebce36-503b-4fcc-9c87-9305518a5743", "buyer": {"email": "cld9zroxbf@allegromail.pl", "login": "dnmax"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb80x30d-s1-siedzisko-schowek-80cm-bialy-14387669377?navCategoryId=20277&snapshot=MjAyMy0xMC0xNlQxMDoyMzoxOC4zOTcxMjk2MTJaO2J1eWVyO2M3MjRhZDRmNGQyZDJmZjI4YTkxNWFiMjdiNDQ3YTJiY2RiN2JmZGRjZWIwOTRlZDQyMzVjN2U3ZmU1MmEzNjc%3D", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "14387669377", "quantity": 1}], "refund": null, "status": "CREATED", "orderId": "f2690e90-6c0d-11ee-9e26-1dfad1b952ef", "parcels": [{"sender": {"phoneNumber": "+48506019362"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-04T00:16:38.359Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-04T00:15:45.526Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "80MG/2023"}, {"id": "231bbc5e-c406-46e2-8e98-9b50b7f90cec", "buyer": {"email": "jn96fmicwm@allegromail.pl", "login": "qubeko"}, "items": [{"url": "https://allegro.pl/oferta/wieszak-scienny-wp60-na-ubrania-60cm-lancelot-12196322651?snapshot=MjAyMy0xMC0yNFQxNTowOToxMy4xMzY5NjQzMTlaO2J1eWVyO2Y0MDkzZjhjNGVmNzUxNTk2OGQ3ZTZhYzEwYjQxZDA0MjlhNzI3MDIxNjhkZGM4MGE0MDRmNzJlODY0MjZhOWM%3D", "name": "Wieszak ścienny WP60 na ubrania 60cm Lancelot", "price": {"amount": "199.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "12196322651", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "36ce5910-727f-11ee-948c-e3b8932a9b47", "parcels": [{"sender": {"phoneNumber": "+48608379166"}, "waybill": "1000671390679U", "carrierId": "DPD", "createdAt": "2023-11-04T07:06:34.978Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-04T07:04:37.934Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8OR2/2023"}, {"id": "c86dc6b6-a632-4b69-be03-63423b76d82c", "buyer": {"email": "3lraugjh4y@allegromail.pl", "login": "Fuu_"}, "items": [{"url": "https://allegro.pl/oferta/panel-scienny-tapicerowany-pan1x50x25-11769325912?snapshot=MjAyMy0xMC0xMlQyMDowMzo1Ni4wNDczMzAzNDBaO2J1eWVyOzNiYTMzMjgwNDYxNjIzZjFjMmRlOGEzMjM5YjY1ZWYyMDZhMWUzNDFjOGRlODQxMGM0MjQyZTdiODFiNjYzZTg%3D", "name": "Panel ścienny tapicerowany pan1x50x25", "price": {"amount": "45.00", "currency": "PLN"}, "reason": {"type": "DONT_LIKE_IT", "userComment": ""}, "offerId": "11769325912", "quantity": 6}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "6d0ea500-693a-11ee-8d03-a1b5069dee90", "parcels": [{"sender": {"phoneNumber": "+48504538154"}, "waybill": "1000672284796U", "carrierId": "DPD", "createdAt": "2023-11-06T14:20:36.348Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-06T14:20:09.805Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "847O/2023"}, {"id": "7a061ba4-439d-414a-877c-70c47e4d75e8", "buyer": {"email": "szpfxvpyk0@allegromail.pl", "login": "Client:70484607"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-z-szuflada-tres-30x30x82-lan-12266464467?navCategoryId=20277&snapshot=MjAyMy0xMS0wNlQxOTo0MToyOC44MjYyNzU2MTRaO2J1eWVyOzRjMTg4Y2E4ODI2MzI2OTJhOTE4NjY1YjY3MDQ5NDY4ZThmM2ZiYTY3OTgwNTNjYWNhNDRiYTEyOGNiMWU4N2Y%3D", "name": "Szafka na buty z szufladą Tres 30x30x82 LAN", "price": {"amount": "195.00", "currency": "PLN"}, "reason": {"type": "MISTAKE", "userComment": ""}, "offerId": "12266464467", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "59e763d0-7cdc-11ee-9500-cf7c9859a90c", "parcels": [{"sender": {"phoneNumber": "+48664653067"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-07T18:31:33.869Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-07T12:37:37.817Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "85J3/2023"}, {"id": "68982b13-bb6e-4bc6-af5f-17f2e8262536", "buyer": {"email": "w1lcc2vr5v@allegromail.pl", "login": "lilia222"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-v100x30d-siedzisko-schowek-100cm-bc-11769094598?navCategoryId=20277&snapshot=MjAyMy0xMS0wOFQxOToyMjoxMy4wNTYxMDY2NTdaO2J1eWVyO2Y0N2NlNWEzY2YxZmFlZWFhNDBjNmU1NDFhN2I2NTZlM2NjMDZhMzQ4MWY1MjAzMWVmYTk5Zjg5OTZlMzYyODQ%3D", "name": "Szafka na buty V100x30D siedzisko schowek 100cm BC", "price": {"amount": "420.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11769094598", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "f11ec4b0-7e6b-11ee-9bd6-75c0e4346569", "parcels": [{"sender": {"phoneNumber": "+48661081801"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-13T06:42:17.331Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-13T06:42:05.733Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "LK55/2023"}, {"id": "b6b6b74b-7f64-4007-8143-dcab03949b81", "buyer": {"email": "5pjjcsi5lu@allegromail.pl", "login": "THomassh007"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-80x30cm-su30-vb-4pan-wp50-n1-cza-d1-scandi-14383226684?navCategoryId=20277&snapshot=MjAyMy0xMC0xN1QxNjozNjoxNC43NzM5MTAxMjdaO2J1eWVyOzZiNmM3NmVjMDZmNzQ1NTAxZGNiYWRlNjkzNDRhMzA0NWUyYjA3YWJjZDk1ODJjNDdiNzQzY2I3NzVlZmMyMjc%3D", "name": "Garderoba 80x30cm SU30 VB-4PAN-WP50 N1 Cza D1 Scandi", "price": {"amount": "1085.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14383226684", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "2f1de420-6d0b-11ee-bcb3-f5e1b3e95720", "parcels": [], "createdAt": "2023-11-15T10:50:52.048Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "8YY2/2023"}, {"id": "0efccf1f-36d1-49fb-9822-53f721827bc1", "buyer": {"email": "zu2f1475s7@allegromail.pl", "login": "irmo2009"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb80x30d-s1-siedzisko-schowek-80cm-bialy-14387669377?navCategoryId=20277&snapshot=MjAyMy0xMC0yN1QwNzo1MTowMC42NTcyNjk1MjhaO2J1eWVyOzgxNTc0ZmRhNDlmN2RjNDQwMWViMTBkZGY1M2NiY2RlNGMxOTgzMGZhZjI5MjI5ZWZkYWQzZTlkODVlMzJjMTg%3D", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY", "price": {"amount": "329.00", "currency": "PLN"}, "reason": {"type": "OVERDUE_DELIVERY", "userComment": ""}, "offerId": "14387669377", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "7988a5b0-749d-11ee-959f-8dfacd8c2675", "parcels": [{"sender": {"phoneNumber": "+48509650170"}, "waybill": "1000677147659U", "carrierId": "DPD", "createdAt": "2023-11-16T06:33:27.286Z", "transportingWaybill": null, "transportingCarrierId": null}], "createdAt": "2023-11-16T06:32:21.805Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L71P/2023"}, {"id": "a230ed21-35e7-4a73-a70b-c9e8f1f037ea", "buyer": {"email": "y79a99eyqb@allegromail.pl", "login": "agaperla1"}, "items": [{"url": "https://allegro.pl/oferta/szafka-na-buty-vb50x36d-s1-siedzisko-schowek-50cm-bialy-14384922015?snapshot=MjAyMy0xMC0yOFQxOTozOToxNi44NTQ0MDQyOTNaO2J1eWVyOzgyMmFiZjRmNWQ5Mjg2MGUyNjBjZDk3YWE2NGVlN2E5ZWMyNTE4OTFlOWRkNGMxMTZjYTgzOWUxN2I0ZjZjMjc%3D", "name": "Szafka na buty VB50x36D S1 siedzisko schowek 50cm BIAŁY", "price": {"amount": "269.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "14384922015", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "9dfc2d90-75c9-11ee-b479-77d9e9f94ff0", "parcels": [], "createdAt": "2023-11-16T19:50:04.717Z", "rejection": null, "marketplaceId": "allegro-pl", "referenceNumber": "L613/2023"}, {"id": "5cbd23bd-f5de-408d-99dc-331d688a1ab0", "buyer": {"email": "dlwo629epp@allegromail.pl", "login": "kurka515"}, "items": [{"url": "https://allegro.pl/oferta/garderoba-50x30p2wpb-szafka-na-buty-wieszak-panele-11743127497?navCategoryId=20277&snapshot=MjAyMy0xMS0wNlQyMDo1ODo0MS44ODI3NjQ2MzBaO2J1eWVyOzU2YjYyYWZkNGNmNjYzNDY2Y2FmNmM4MGY3NzdiYjUzZTg1NDgzMTM0ZGRiZWNmMjdiNzRmNzRiMmU1OGY1OTI%3D", "name": "Garderoba 50x30P2WPB szafka na buty wieszak panele", "price": {"amount": "429.00", "currency": "PLN"}, "reason": {"type": "NONE", "userComment": ""}, "offerId": "11743127497", "quantity": 1}], "refund": null, "status": "COMMISSION_REFUNDED", "orderId": "2e243070-7ce6-11ee-9bd6-75c0e4346569", "parcels": [{"sender": {"phoneNumber": "+48725080519"}, "waybill": null, "carrierId": "UNKNOWN", "createdAt": "2023-11-17T18:14:59.177Z", "transportingWaybill": null, "transportingCa