import { FilterTabsBar, useFilterTabsBar } from './FilterTabsBar';
import { ManageFiltersDialog } from './ManageFiltersDialog';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Package, Link as LinkIcon, Search } from 'lucide-react';

interface OrdersTabsBarProps {
  planId: string;
  searchFilter: string;
  onSearchChange: (value: string) => void;
  showSetsOnly?: boolean;
  showCatalogLinked?: boolean;
  onToggleSetsOnly?: () => void;
  onToggleCatalogLinked?: () => void;
}

export function OrdersTabsBar({ 
  planId, 
  searchFilter, 
  onSearchChange,
  showSetsOnly = false,
  showCatalogLinked = false,
  onToggleSetsOnly,
  onToggleCatalogLinked
}: OrdersTabsBarProps) {
  const { tabs, tabsData } = useFilterTabsBar({
    planId,
    storageKeyPrefix: 'production-orders-tabs',
    searchFilter,
    onSearchChange,
    testIdPrefix: 'order-tab'
  });

  return (
    <div className="flex items-center gap-2 flex-wrap">
      {/* Search Input */}
      <div className="relative flex-shrink-0">
        <Search className="absolute left-2 top-1/2 transform -translate-y-1/2 h-3.5 w-3.5 text-muted-foreground" />
        <Input
          type="text"
          placeholder="Wyszukaj..."
          value={searchFilter || ''}
          onChange={(e) => onSearchChange(e.target.value)}
          className="pl-8 h-7 w-48 text-xs"
          data-testid="input-search-orders"
        />
      </div>

      {/* Manage Filters Button */}
      <ManageFiltersDialog
        tabs={tabsData.persistentTabs}
        onAddTab={tabsData.addTab}
        onRemoveTab={tabsData.removeTab}
        onToggleTab={tabsData.toggleTab}
        onReorderTabs={tabsData.reorderTabs}
      />
      
      {/* Active Filter Badges */}
      {tabs}
    </div>
  );
}
