import { useLocation } from "wouter";
import { Link2, Link2Off, Settings } from "lucide-react";
import { Button } from "@/components/ui/button";
import {
  Tooltip,
  TooltipContent,
  TooltipTrigger,
} from "@/components/ui/tooltip";

interface ConnectionStatusIconProps {
  isLinked: boolean;
  targetPath: string | null;
  targetSku?: string | null;
  productId: number | string;
  onManageLinks?: () => void;
}

export function ConnectionStatusIcon({
  isLinked,
  targetPath,
  targetSku,
  productId,
  onManageLinks,
}: ConnectionStatusIconProps) {
  const [, setLocation] = useLocation();
  
  const statusTooltip = isLinked && targetSku
    ? `Połączono: ${targetSku}`
    : "Niepołączony";

  const handleNavigate = () => {
    if (targetPath) {
      setLocation(targetPath);
    }
  };

  return (
    <div className="flex items-center gap-1">
      {/* Status icon - shows connection status and navigates */}
      <Tooltip>
        <TooltipTrigger asChild>
          <Button
            variant="outline"
            size="icon"
            onClick={handleNavigate}
            disabled={!targetPath}
            className={`hover-elevate ${
              isLinked
                ? "bg-emerald-500 dark:bg-emerald-600 text-white border-emerald-600 dark:border-emerald-700"
                : "bg-amber-500 dark:bg-amber-600 text-white border-amber-600 dark:border-amber-700"
            }`}
            data-testid={`icon-connection-${productId}`}
          >
            {isLinked ? (
              <Link2 className="h-4 w-4" />
            ) : (
              <Link2Off className="h-4 w-4" />
            )}
          </Button>
        </TooltipTrigger>
        <TooltipContent>
          <p>{statusTooltip}</p>
        </TooltipContent>
      </Tooltip>

      {/* Manage button - opens link management dialog */}
      {onManageLinks && (
        <Tooltip>
          <TooltipTrigger asChild>
            <Button
              variant="outline"
              size="icon"
              onClick={(e) => {
                e.stopPropagation();
                onManageLinks();
              }}
              className="h-9 w-9 hover-elevate"
              data-testid={`button-manage-links-${productId}`}
            >
              <Settings className="h-4 w-4" />
            </Button>
          </TooltipTrigger>
          <TooltipContent>
            <p>Zarządzaj połączeniami</p>
          </TooltipContent>
        </Tooltip>
      )}
    </div>
  );
}
