import { lazy } from "react";
import { Switch, Route, Redirect } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import { SidebarProvider, SidebarTrigger, useSidebar } from "@/components/ui/sidebar";
import { AppSidebar } from "@/components/app-sidebar";
import { ThemeProvider } from "@/components/theme-provider";
import { AuthProvider, useAuth } from "@/hooks/use-auth";
import { ProtectedRoute } from "@/lib/protected-route";
import Dashboard from "@/pages/dashboard";
import Settings from "@/pages/settings";
import OrderDetails from "@/pages/order-details";
import OrderChanges from "@/pages/order-changes";
import OrderMatching from "@/pages/order-matching";
import RecentUpdates from "@/pages/recent-updates";
import DateSync from "@/pages/date-sync";
import ProductsPage from "@/pages/products";
import ProductDetails from "@/pages/product-details";
import CatalogProductsPage from "@/pages/catalog-products";
import CatalogProductEditor from "@/pages/catalog-product-editor";
import CatalogSetsPage from "@/pages/catalog-sets";
import CatalogSetEditor from "@/pages/catalog-set-editor";
import AirtableMatcherPage from "@/pages/airtable-matcher";
import AccessoriesPage from "@/pages/accessories";
import AccessoryEditor from "@/pages/accessory-editor";
import AccessoriesLayout from "@/pages/accessories-layout";
import AccessoryGroupPage from "@/pages/accessory-group-page";
import TemplatesManager from "@/pages/templates-manager";
import TemplateEditor from "@/pages/template-editor";
import DictionariesLayout from "@/pages/dictionaries-layout";
import DictionaryTypePage from "@/pages/dictionary-type";
import DictionaryEntryEdit from "@/pages/dictionary-entry-edit";
import ProductMatrices from "@/pages/product-matrices";
import ProductMatrixEditor from "@/pages/product-matrix-editor";
import SetMatrices from "@/pages/set-matrices";
import SetMatrixSettings from "@/pages/set-matrix-settings";
import SetMatrixGenerate from "@/pages/set-matrix-generate";
import UsersPage from "@/pages/users";
import ApiTokensPage from "@/pages/api-tokens";
import ApiTokenLogsPage from "@/pages/api-token-logs";
import WebhooksPage from "@/pages/webhooks";
import WebhookLogsPage from "@/pages/webhook-logs";
import OdooConfig from "@/pages/odoo-config";
import AISettings from "@/pages/ai-settings";
import AuthPage from "@/pages/auth-page";
import ResetPasswordPage from "@/pages/reset-password-page";
import NotFound from "@/pages/not-found";
import FeesLayout from "@/pages/fees-layout";
import FeesSummary from "@/pages/fees-summary";
import FeesTable from "@/pages/fees-table";
import FeesGrouped from "@/pages/fees-grouped";
import FeesDaily from "@/pages/fees-daily";
import ErrorLogsPage from "@/pages/error-logs";
import SyncHealthPage from "@/pages/sync-health";
import WarehouseCategoryPage from "@/pages/warehouse-category";
import WarehouseCategoriesManager from "@/pages/warehouse-categories-manager";
import OkuciaPage from "@/pages/warehouse/okucia";
import PlytyPage from "@/pages/warehouse/plyty";
import SrubyPage from "@/pages/warehouse/sruby";
import TkaninyPage from "@/pages/warehouse/tkaniny";
import PiankiPage from "@/pages/warehouse/pianki";
import FormatkiPage from "@/pages/warehouse/formatki";
import ComponentTemplatesPage from "@/pages/component-templates";
import ComponentTemplateDetail from "@/pages/component-template-detail";
import BomListPage from "@/pages/bom-list";
import BomComponentsPage from "@/pages/bom-components";
import BomComponentDetail from "@/pages/bom-component-detail";
import MatrixTemplatesPage from "@/pages/matrix-templates";
import ProductionSettings from "@/pages/production-settings";
import ProductionCarriers from "@/pages/production-carriers";
import ProductionCarrierDetail from "@/pages/production-carrier-detail";
import ProductionCarrierEdit from "@/pages/production-carrier-edit";
import ProductionLocations from "@/pages/production-locations";
import ProductionWorkCenters from "@/pages/production-work-centers";
import ProductionWorkCenterDetail from "@/pages/production-work-center-detail";
import ProductionWorkCenterEdit from "@/pages/production-work-center-edit";
import ProductionRoutings from "@/pages/production-routings";
import ProductionRoutingDetail from "@/pages/production-routing-detail";
import ProductionRoutingEdit from "@/pages/production-routing-edit";
import ProductionOrders from "@/pages/production-orders";
import ProductionOrderNew from "@/pages/production-order-new";
import ProductionOrderDetail from "@/pages/production-order-detail";
import ProductionScan from "@/pages/production-scan";
import ProductionMovements from "@/pages/production-movements";
import ProductionPlans from "@/pages/production-plans";
import ProductionPlanNew from "@/pages/production-plan-new";
import ProductionPlanDetail from "@/pages/production-plan-detail";
import CuttingPatternsPage from "@/pages/cutting-patterns";
import CuttingPatternsNewPage from "@/pages/cutting-patterns-new";
import CuttingPatternsEditPage from "@/pages/cutting-patterns-edit";

function Router() {
  const { user, isLoading } = useAuth();

  // Show auth page if not logged in
  if (!isLoading && !user) {
    return (
      <Switch>
        <Route path="/auth" component={AuthPage} />
        <Route path="/reset-password" component={ResetPasswordPage} />
        <Route path="*">
          {() => {
            window.location.href = "/auth";
            return null;
          }}
        </Route>
      </Switch>
    );
  }

  // Show protected routes if logged in
  return (
    <Switch>
      <ProtectedRoute path="/" component={Dashboard} />
      <ProtectedRoute path="/order-changes" component={OrderChanges} />
      <ProtectedRoute path="/order-matching" component={OrderMatching} />
      <ProtectedRoute path="/recent-updates" component={RecentUpdates} />
      <ProtectedRoute path="/date-sync" component={DateSync} />
      <ProtectedRoute path="/products" component={ProductsPage} />
      <ProtectedRoute path="/product/:sku" component={ProductDetails} />
      <ProtectedRoute path="/catalog-products" component={CatalogProductsPage} />
      <ProtectedRoute path="/catalog-products/:id" component={CatalogProductEditor} />
      <ProtectedRoute path="/airtable-matcher" component={AirtableMatcherPage} />
      <ProtectedRoute path="/catalog-sets" component={CatalogSetsPage} />
      <ProtectedRoute path="/catalog-sets/:id" component={CatalogSetEditor} />
      <ProtectedRoute path="/accessories/new" component={AccessoryEditor} />
      <ProtectedRoute path="/accessories/:id/edit" component={AccessoryEditor} />
      <ProtectedRoute 
        path="/accessories/:groupCode" 
        component={() => (
          <AccessoriesLayout>
            <AccessoryGroupPage />
          </AccessoriesLayout>
        )}
      />
      <Route path="/accessories">
        <Redirect to="/accessories/tkanina_welur" />
      </Route>
      <ProtectedRoute path="/template-editor/:id" component={TemplateEditor} />
      <ProtectedRoute path="/templates-manager" component={TemplatesManager} />
      <ProtectedRoute path="/templates" component={TemplatesManager} />
      <ProtectedRoute path="/dictionaries/:type/:id/edit" component={DictionaryEntryEdit} />
      <ProtectedRoute 
        path="/dictionaries/:type" 
        component={() => (
          <DictionariesLayout>
            <DictionaryTypePage />
          </DictionariesLayout>
        )}
      />
      <Route path="/dictionaries">
        <Redirect to="/dictionaries/product_type" />
      </Route>
      <ProtectedRoute path="/product-matrices/:id/edit" component={ProductMatrixEditor} />
      <ProtectedRoute path="/product-matrices" component={ProductMatrices} />
      <ProtectedRoute path="/set-matrices/:id/generate" component={SetMatrixGenerate} />
      <ProtectedRoute path="/set-matrices/settings/:id" component={SetMatrixSettings} />
      <ProtectedRoute path="/set-matrices" component={SetMatrices} />
      <ProtectedRoute 
        path="/fees/summary" 
        component={() => (
          <FeesLayout>
            <FeesSummary />
          </FeesLayout>
        )}
      />
      <ProtectedRoute 
        path="/fees/table" 
        component={() => (
          <FeesLayout>
            <FeesTable />
          </FeesLayout>
        )}
      />
      <ProtectedRoute 
        path="/fees/grouped" 
        component={() => (
          <FeesLayout>
            <FeesGrouped />
          </FeesLayout>
        )}
      />
      <ProtectedRoute 
        path="/fees/daily" 
        component={() => (
          <FeesLayout>
            <FeesDaily />
          </FeesLayout>
        )}
      />
      <ProtectedRoute 
        path="/fees" 
        component={() => <Redirect to="/fees/summary" />}
      />
      <ProtectedRoute path="/settings" component={Settings} />
      <ProtectedRoute path="/users" component={UsersPage} />
      <ProtectedRoute path="/error-logs" component={ErrorLogsPage} />
      <ProtectedRoute path="/sync-health" component={SyncHealthPage} />
      <ProtectedRoute path="/api-tokens" component={ApiTokensPage} />
      <ProtectedRoute path="/api-tokens/logs" component={ApiTokenLogsPage} />
      <ProtectedRoute path="/webhooks" component={WebhooksPage} />
      <ProtectedRoute path="/webhooks/logs" component={WebhookLogsPage} />
      <ProtectedRoute path="/odoo" component={OdooConfig} />
      <ProtectedRoute path="/ai-settings" component={AISettings} />
      <ProtectedRoute path="/warehouse/categories-manager" component={WarehouseCategoriesManager} />
      <ProtectedRoute path="/warehouse/formatki" component={FormatkiPage} />
      <ProtectedRoute path="/warehouse/:category/:groupCode" component={WarehouseCategoryPage} />
      <ProtectedRoute path="/warehouse/:category" component={WarehouseCategoryPage} />
      <ProtectedRoute path="/matrix/:furnitureType" component={MatrixTemplatesPage} />
      <ProtectedRoute path="/matrix" component={MatrixTemplatesPage} />
      <ProtectedRoute path="/component-template/:id" component={ComponentTemplateDetail} />
      <ProtectedRoute path="/bom/component-templates" component={ComponentTemplatesPage} />
      <ProtectedRoute path="/bom-components/:id" component={BomComponentDetail} />
      <ProtectedRoute path="/bom-components" component={BomComponentsPage} />
      <ProtectedRoute path="/bom" component={BomListPage} />
      <ProtectedRoute path="/production/settings" component={ProductionSettings} />
      <ProtectedRoute path="/production/carriers/:id/edit" component={ProductionCarrierEdit} />
      <ProtectedRoute path="/production/carriers/:id" component={ProductionCarrierDetail} />
      <ProtectedRoute path="/production/carriers" component={ProductionCarriers} />
      <ProtectedRoute path="/production/locations" component={ProductionLocations} />
      <ProtectedRoute path="/production/work-centers/:id/edit" component={ProductionWorkCenterEdit} />
      <ProtectedRoute path="/production/work-centers/:id" component={ProductionWorkCenterDetail} />
      <ProtectedRoute path="/production/work-centers" component={ProductionWorkCenters} />
      <ProtectedRoute path="/production/routings/:id/edit" component={ProductionRoutingEdit} />
      <ProtectedRoute path="/production/routings/:id" component={ProductionRoutingDetail} />
      <ProtectedRoute path="/production/routings" component={ProductionRoutings} />
      <ProtectedRoute path="/production/orders/new" component={ProductionOrderNew} />
      <ProtectedRoute path="/production/orders/:id" component={ProductionOrderDetail} />
      <ProtectedRoute path="/production/orders" component={ProductionOrders} />
      <ProtectedRoute path="/production/plans/new" component={ProductionPlanNew} />
      <ProtectedRoute path="/production/plans/:id" component={ProductionPlanDetail} />
      <ProtectedRoute path="/production/plans" component={ProductionPlans} />
      <ProtectedRoute path="/production/scan" component={ProductionScan} />
      <ProtectedRoute path="/production/movements" component={ProductionMovements} />
      <ProtectedRoute path="/cutting-patterns/new" component={CuttingPatternsNewPage} />
      <ProtectedRoute path="/cutting-patterns/:id/edit" component={CuttingPatternsEditPage} />
      <ProtectedRoute path="/cutting-patterns" component={CuttingPatternsPage} />
      <ProtectedRoute path="/order/:orderNumber" component={OrderDetails} />
      <Route path="/auth" component={AuthPage} />
      <Route path="/reset-password" component={ResetPasswordPage} />
      <Route component={NotFound} />
    </Switch>
  );
}

function MainContent() {
  const { state } = useSidebar();
  
  return (
    <main className="flex-1 min-h-0 overflow-auto relative">
      {/* Floating sidebar trigger - visible only when sidebar is collapsed */}
      {state === "collapsed" && (
        <div className="fixed top-4 left-0 z-50">
          <SidebarTrigger data-testid="button-main-sidebar-toggle" className="rounded-r-md rounded-l-none shadow-md" />
        </div>
      )}
      <Router />
    </main>
  );
}

function AppContent() {
  const { user, isLoading } = useAuth();
  
  const style = {
    "--sidebar-width": "280px",
    "--sidebar-width-icon": "4rem",
  };

  // Show layout without sidebar during loading or for unauthenticated users
  if (isLoading || !user) {
    return (
      <main className="min-h-screen">
        <Router />
      </main>
    );
  }

  // Show layout with sidebar only for authenticated users
  return (
    <SidebarProvider style={style as React.CSSProperties}>
      <div className="flex h-screen w-full">
        <AppSidebar />
        <MainContent />
      </div>
    </SidebarProvider>
  );
}

export default function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <AuthProvider>
        <TooltipProvider>
          <ThemeProvider defaultTheme="dark">
            <AppContent />
            <Toaster />
          </ThemeProvider>
        </TooltipProvider>
      </AuthProvider>
    </QueryClientProvider>
  );
}
