-- Add thumbnail and medium URL columns to product_images table
-- This migration adds optimized image version URLs for better performance

ALTER TABLE catalog.product_images 
ADD COLUMN IF NOT EXISTS thumbnail_url TEXT,
ADD COLUMN IF NOT EXISTS medium_url TEXT;

-- Add comment explaining the columns
COMMENT ON COLUMN catalog.product_images.thumbnail_url IS 'Optimized thumbnail version (80x80px WebP) for list views';
COMMENT ON COLUMN catalog.product_images.medium_url IS 'Optimized medium version (400x400px WebP) for previews';
