import axios from 'axios';
import { pool } from './postgres.js';

async function debugOffer() {
  try {
    const tokenResult = await pool.query(`
      SELECT access_token FROM allegro_connections WHERE is_active = true LIMIT 1
    `);
    const accessToken = tokenResult.rows[0]?.access_token;

    if (!accessToken) {
      console.error('No access token');
      return;
    }

    const offerId = '16129550140'; // Zamówienie #00618

    console.log(`Checking offer ${offerId}...\n`);

    const response = await axios.get(
      `https://api.allegro.pl/offers/${offerId}`,
      {
        headers: {
          Authorization: `Bearer ${accessToken}`,
          Accept: 'application/vnd.allegro.public.v1+json',
        }
      }
    );
    
    console.log('\n\n=== Testing /offers endpoint ===');
    console.log('Images in offer:');
    if (response.data.images) {
      console.log(JSON.stringify(response.data.images, null, 2));
    } else {
      console.log('No images field');
    }

    console.log('Full response:', JSON.stringify(response.data, null, 2));
    console.log('\n\nImages array:');
    if (response.data.productSet && response.data.productSet.length > 0) {
      const product = response.data.productSet[0].product;
      if (product && product.images) {
        console.log(JSON.stringify(product.images, null, 2));
      } else {
        console.log('No images found in product');
      }
    }

  } catch (error: any) {
    console.error('Error:', error.response?.data || error.message);
  } finally {
    await pool.end();
  }
}

debugOffer();
