# Alpma OMS - Order Management System

## Overview
Alpma OMS is a professional web application designed for managing orders from Allegro and Shoper platforms. It automates order fetching, payment verification, and data synchronization to provide a unified e-commerce order management platform. The system aims to integrate with other business systems, such as Odoo, to improve operational efficiency and scalability for businesses operating on multiple e-commerce channels. Key features include comprehensive order management, real-time synchronization, a secure API, robust user authentication, and detailed statistics.

## User Preferences
- Język: Polski (wszystkie UI teksty)
- Motyw domyślny: Dark mode
- OAuth flow: Przekierowanie na stronę Allegro (jak w module Odoo)
- Częstotliwość synchronizacji: Co kilka minut (konfigurowalne: 1, 3, 5, 10 min)

## System Architecture

### UI/UX Decisions
The frontend uses React 18 with Vite, Shadcn UI (Radix UI, Tailwind CSS), and Wouter for routing. It supports dark/light modes, is fully mobile-responsive, and features a corpo ERP-style design with compact layouts, two-tone backgrounds, and accent-colored highlights. Specific UI elements include a global right sidebar with persistence, redesigned warehouse details pages with dictionary-driven hex color tiles and absolute-positioned stock badges, nested sidebar navigation for material categories, and dedicated edit pages for warehouse materials. Inventory count layouts are optimized for sequential numbering and integer-only input.

### Technical Implementations
The backend is built with Express.js and TypeScript. Data fetching and state management are handled by TanStack Query v5, with React Hook Form and Zod for form validation. Persistence utilizes a dual-layer storage for raw platform data and normalized `commerce.orders`. Authentication uses username/password with PostgreSQL, Passport.js, session management, and CSRF protection, alongside role-based access control.

Key modules and features include:
- **Product Management**: Allegro Fees Management, Product Catalog, Product Creator Dictionaries, Product Matrix/Generator, Set Matrix, Advanced Product Filtering, Template-Based Accessory System, Conditional AI Sections, Product Image Tags, Color Generation Tracking, Color Options.
- **Warehouse Management System**: Material inventory, gallery, supplier codes, server-side filtering, bulk operations, view modes, pagination, dictionary-driven color tiles, material edit, warehouse groups management, Formatki Stock Panels, Packaging Materials.
- **Production Module**: BOM Generation, Formatka Visualization, Production Module, Production Buffer/Warehouse Reservation System.
- **Automated Reservations**: Automatic Formatka Reservation System with two-tier search logic and `zlp_item_id` linking; Packed Products Reservation System with transactional integrity and UI toggles.
- **Inventory Tracking**: Serialized Inventory Tracking for Packed Products with FIFO management, defect tracking, unique serial numbers, and a dedicated UI for item-level status filtering and inventory counts.
- **Automated Systems**: Auto BOM Assignment, Order Matching, Automated Systems (Auto-Healing Synchronization, Nightly Full Sync), Async ZLP Generation with SSE for real-time progress, Automated SFTP backup system, Automatic WZ-SPAK document generation for packed products during ZLP generation.
- **Routing & Operations**: Production Routings Management with CRUD operations and drag-and-drop reordering; Operation-Level Routing Overrides supporting three-tier hierarchy for production plans.
- **Warehouse Documents**: Extended Warehouse Documents System supporting multi-source documents (WZ, PZ, MM) linked to production operations.
- **Material Tracking**: Multi-Source Material Tracking (`production.operation_material_sources`) for dependencies per work order with automatic status calculation.
- **Production Planning**: Dual-panel system with marketplace order filtering, catalog product mapping, persistent filters, collapsible order cards, batch operations, token-based filtering, multi-source product selection, and plan name templates.

### System Design Choices
The system employs a dual product architecture (`commerce.marketplace_products` and `catalog.products`) and a unified schema structure with dedicated schemas for `commerce`, `catalog`, `product_creator`, `warehouse`, and `production`. Modularity is achieved by separating `client`, `server`, and `shared` types. The architecture is designed for scalability and integration with Odoo.

## External Dependencies
- **Database**: PostgreSQL (Replit) with multiple schemas.
- **E-commerce Platforms**: Allegro API (OAuth, order synchronization, returns, payments/refunds), Shoper API (order synchronization, product details).
- **External File Storage**: Configurable SFTP (files.alpsys.pl) and local file storage.
- **Odoo Integration**: Direct integration via Cloudflare Tunnel for dual-mode synchronization, product export with field mapping, and SKU validation.
- **AI Integrations**: OpenAI for AI-assisted content generation (via Replit AI Integrations) with section-based AI prompt system.
- **Image Processing**: Puppeteer for automated accessory grid JPG rendering.