/**
 * Re-export navigation context hook for convenience
 * Usage: const { goBack, canGoBack } = useNavigation();
 * Then: onClick={() => goBack('/fallback-path', navigate)}
 */
export { useNavigation } from '@/contexts/navigation-context';

/**
 * Safely navigates back in browser history or falls back to a default path.
 * 
 * This is a legacy wrapper for compatibility. New code should use the useNavigation hook directly.
 * 
 * @deprecated Use useNavigation hook instead for proper context-based navigation tracking
 */
export const safeGoBack = (fallbackPath: string, navigate: (path: string) => void) => {
  if (typeof window === 'undefined') {
    return;
  }

  // Simply use browser back - this works reliably in most cases
  // For proper navigation tracking, use useNavigation hook instead
  window.history.back();
};
