import { ColumnDefinition, FilterGroupDefinition } from '@/hooks/useWarehouseTableState';

export const packedProductsColumns: ColumnDefinition[] = [
  { key: 'rowNumber', label: '#', defaultWidth: 40, defaultVisible: true },
  { key: 'image', label: '', defaultWidth: 40, defaultVisible: true },
  { key: 'productType', label: 'Typ', defaultWidth: 60, defaultVisible: true, sortKey: 'catalogProductType' },
  { key: 'name', label: 'Nazwa', defaultWidth: 200, defaultVisible: true, sortKey: 'name' },
  { key: 'sku', label: 'SKU', defaultWidth: 100, defaultVisible: true, sortKey: 'internalCode' },
  { key: 'quantity', label: 'Stan', defaultWidth: 60, defaultVisible: true, sortKey: 'quantity' },
  { key: 'reserved', label: 'Zarezerwow.', defaultWidth: 80, defaultVisible: true },
  { key: 'available', label: 'Dostępne', defaultWidth: 70, defaultVisible: true },
  { key: 'length', label: 'Długość', defaultWidth: 70, defaultVisible: true, sortKey: 'catalogLength' },
  { key: 'width', label: 'Szerokość', defaultWidth: 70, defaultVisible: true, sortKey: 'catalogWidth' },
  { key: 'color', label: 'Kolor', defaultWidth: 80, defaultVisible: true, sortKey: 'catalogColor' },
  { key: 'doors', label: 'Drzwi', defaultWidth: 60, defaultVisible: false, sortKey: 'catalogDoors' },
  { key: 'legs', label: 'Nogi', defaultWidth: 60, defaultVisible: false, sortKey: 'catalogLegs' },
  { key: 'location', label: 'Lokalizacja', defaultWidth: 100, defaultVisible: true },
  { key: 'carrier', label: 'Nośnik', defaultWidth: 80, defaultVisible: true },
  { key: 'group', label: 'Grupa', defaultWidth: 100, defaultVisible: true },
  { key: 'notes', label: 'Notatki', defaultWidth: 150, defaultVisible: false },
];

export const packedProductsFilterGroups: FilterGroupDefinition[] = [
  { 
    key: 'stock', 
    label: 'Stan magazynowy', 
    type: 'stock' 
  },
  { 
    key: 'productType', 
    label: 'Typ produktu', 
    type: 'triState',
    paramName: 'productTypes',
    excludeParamName: 'excludeProductTypes'
  },
  { 
    key: 'color', 
    label: 'Kolor', 
    type: 'triState',
    paramName: 'colors',
    excludeParamName: 'excludeColors'
  },
  { 
    key: 'location', 
    label: 'Lokalizacja', 
    type: 'triState',
    paramName: 'locationIds',
    excludeParamName: 'excludeLocationIds'
  },
  { 
    key: 'carrier', 
    label: 'Nośnik', 
    type: 'triState',
    paramName: 'carrierIds',
    excludeParamName: 'excludeCarrierIds'
  },
];

export const packedProductsSortableColumns: Record<string, string> = {
  name: 'name',
  sku: 'internalCode',
  productType: 'catalogProductType',
  length: 'catalogLength',
  width: 'catalogWidth',
  color: 'catalogColor',
  doors: 'catalogDoors',
  legs: 'catalogLegs',
  quantity: 'quantity',
};
