# Alpma OMS - Zarządzanie Zamówieniami

## Overview
Alpma OMS (Order Management System) is a professional web application for managing orders from Allegro and Shoper platforms. It automates order fetching, payment verification, and data synchronization. The project aims to provide a unified e-commerce order management platform, capable of integrating with other business systems like Odoo, to enhance operational efficiency and scalability for businesses operating on multiple platforms. Key capabilities include comprehensive order management, real-time synchronization, a secure API, robust user authentication, and detailed statistics.

## Recent Changes (November 14, 2025)
- **CRITICAL FIX #1**: Set generation color field bug - system was saving color INDEX (e.g., "9") instead of color NAME (e.g., "CZARNY") to `product_creator.product_sets.color` column
  - Fixed by using `actualColorName` variable (resolved color name) instead of raw `color` loop variable in INSERT/UPDATE queries
  - Affects lines 2001, 2032, 2223 in server/routes.ts
  - Existing sets with wrong color values will be automatically fixed on regeneration
- **CRITICAL FIX #2**: Set uniqueness bug - system was overwriting sets with same color but different configuration (doors/legs/colorOptions)
  - Root cause: `combination_key` and `SKU` only included color, not all differentiating parameters
  - Fixed `combination_key` to include: color, doors, legs, colorOptions, depth, panel count, hook length (line 1932-1943)
  - Fixed `SKU` to include: color, first colorOption, doors, legs (line 1920-1931)
  - Example: "CZARNY + drzwi-artisan" and "CZARNY + drzwi-biały" now create separate sets instead of overwriting
  - Existing sets need to be regenerated to get new unique SKUs
- **Cache Improvement**: Added `componentType` to queryKey in ComponentOverridesDialog to prevent stale cache results when switching between components
- **Enhanced Logging**: Added debug logging for search parameters (hasSemicolon, hasComma, length) to track semicolon-separated search usage

## User Preferences
- Język: Polski (wszystkie UI teksty)
- Motyw domyślny: Dark mode
- OAuth flow: Przekierowanie na stronę Allegro (jak w module Odoo)
- Częstotliwość synchronizacji: Co kilka minut (konfigurowalne: 1, 3, 5, 10 min)

## System Architecture

### UI/UX Decisions
- **Frontend Framework**: React 18 with Vite, Shadcn UI (Radix UI, Tailwind CSS).
- **Theming**: Dark/Light mode support.
- **Navigation**: Wouter for client-side routing.
- **Data Display**: Dashboard with key metrics and a detailed, sortable orders table.
- **Mobile Responsiveness**: Full mobile support with adaptive layouts.
- **Corpo ERP UI Design**: Compact, sharp-edged professional styling, two-tone backgrounds, clear spacing, accent-colored highlights for order numbers.

### Technical Implementations
- **Backend**: Express.js with TypeScript.
- **Data Fetching & State Management**: TanStack Query v5.
- **Form Handling**: React Hook Form with Zod validation.
- **Persistence**: Dual-layer storage for raw platform data and normalized `commerce.orders`.
- **Authentication**: Username/password with PostgreSQL, Passport.js, session management, CSRF protection.
- **Authorization**: Role-based access control (admin/manager/user).
- **Modules**: Allegro Fees Management, Product Catalog System, Product Creator Dictionaries, Product Matrix/Generator with Simple Color Management, Set Matrix Module, Advanced Product Filtering, Template-Based Accessory System, Conditional AI Sections, Product Image Tags System, Color Generation Tracking, Color Options System, Bidirectional Navigation between Set Matrices and Generated Catalog Sets, Enhanced Set Description System, Product-Set Relationship Protection, Warehouse Management System (material inventory, gallery, supplier codes, server-side filtering, bulk operations, view modes, pagination), Formatki Stock Panels Module (managing finished furniture components with intelligent naming, tracking, and dedicated UI), BOM (Bill of Materials) Generation System with Parent-Child Template Hierarchy and Intelligent Furniture Type Matching (exact match first, then fallback to base type; e.g., SUPRA-30 → SUPRA-30 or fallback to SUPRA, with case-insensitive and whitespace-safe matching; automatic drilling propagation, color codes, parameter locking, help dialog), Formatka Visualization System (realistic color rendering for Odoo export using Puppeteer, hex colors, special white handling, JPG output), Production Module (carriers, locations, work centers, material flow tracking, CRUD API).
- **Order Matching**: Tool for reconciling orders across platforms.
- **Automated Systems**: Auto-Healing Synchronization System, Nightly Full Sync scheduler.
- **Generation Progress Dialog**: Unified dialog for real-time progress and live SSE log streaming.
- **Timezone Handling**: Unified UTC storage with automatic DST conversion to Europe/Warsaw.
- **Backup System**: Automated SFTP backup with dual-source listing and transparent download fallback.

### Feature Specifications
- **OAuth Integration**: Secure OAuth 2.0 with Allegro.
- **Automated Synchronization**: Configurable cyclic synchronization for Allegro and Shoper.
- **Dashboard & Order Table**: Overview of orders, revenue, with filtering, searching, and sorting.
- **Configuration Panel**: Centralized settings for OAuth, synchronization, and connections.
- **Historia Zmian (Change History)**: Unified page with tabs for detected changes, recent updates, and sync logs.
- **User Management**: Admin-only CRUD for users, roles, and permissions.
- **API Token Management**: Admin-only CRUD for API tokens with audit logs.
- **Webhook Management**: Admin-only CRUD for webhook configurations and delivery logs.
- **Recent Updates**: Page for verifying orders by marketplace last_update timestamp.
- **BOM Export to Odoo**: Single and bulk export of Bill of Materials to Odoo ERP system.
- **Set Matrix Navigation**: Bidirectional navigation between Set Matrices and Generated Catalog Sets.
- **Production Planning Dual-Panel System**: Advanced order-to-production planning interface with dual-panel layout, marketplace order filtering, catalog product mapping, persistent filter state, collapsible order cards, one-click adding to plan, unmapped product handling, real-time statistics, active filters summary, exclusion of already-planned items. Includes a Custom Filterable Tabs System for user-defined filtering and Batch Operations System for bulk product selection and actions. Redesigned plan header with horizontal 80px layout featuring inline data elements (plan name, number with Hash icon, dates with Calendar icons, status/priority badges) separated by vertical dividers, with responsive flex-wrap for mobile. Optimized plan items table with combined dimension columns (L×W×H) and responsive width constraints. **Token-Based Filtering System**: Backend parses semicolon-delimited search tokens into structured filters - recognizes marketplace tokens (ALLEGRO, SHOPER), payment status tokens (PAID, UNPAID, PENDING), and treats remaining tokens as search terms. Supports multiple simultaneous marketplace/payment filters using SQL IN clauses.
- **Multi-Source Product Selection for ZLP**: Unified system for adding products to Production Plans (ZLP) from three sources: customer orders (marketplace), internal catalog products, and cutting patterns. Features visual category selector, unified add-to-plan handlers, recently-added tracking, and plan membership indicators across all sources.
- **Plan Name Templates System**: Template-based automatic plan naming with `{token|format}` syntax (date, datetime, seq), daily sequence counters, and metadata tracking on production plans. Includes three default templates: Zapas, Zamówienia, and Rozkroje.
- **Marketplace-to-Catalog Bidirectional Linking**: Extended linking system supporting both catalog products and catalog sets. Features tabbed UI (Products/Sets) in link dialog, separate search inputs with semicolon/comma filtering, link_type discriminator in database (product|set), backward-compatible API with XOR validation (catalogProductId vs catalogSetId), and unified suggestion rendering with entity-specific metadata.

### System Design Choices
- **Dual Product Architecture**: Marketplace Products (`commerce.marketplace_products`) and Generated Catalog Products (`catalog.products`).
- **Unified Schema**: `commerce` for order management, `catalog` for generated product catalog, `product_creator` for matrix/dictionary system, `warehouse` for material inventory management, `production` for manufacturing management.
- **Modularity**: Separated `client`, `server`, and `shared` types.
- **Scalability**: Designed for integration with Odoo.
- **Schema Consistency**: Dedicated schemas for catalog, warehouse, and production entities.

## External Dependencies
- **Database**: PostgreSQL (Replit) with multiple schemas.
- **E-commerce Platforms**:
    - **Allegro API**: OAuth, order synchronization, customer returns (BETA), payments/refunds.
    - **Shoper API**: Order synchronization, product details.
- **External File Storage**: Configurable SFTP (files.alpsys.pl) and local file storage with adapter pattern.
- **Odoo Integration**: Direct integration via Cloudflare Tunnel with dual-mode synchronization, product export with comprehensive field mapping, image base64 conversion, SKU validation.
- **AI Integrations**: OpenAI for AI-assisted content generation (via Replit AI Integrations) with section-based AI prompt system.
- **Accessory Grid JPG Rendering**: Automated system using Puppeteer for rendering accessory grids as JPG images, with caching.