import { pool } from './postgres.js';
import { downloadProductImages } from './allegro-api.js';

async function fixMissingBySearch() {
  try {
    console.log('🔄 Pobieranie brakujących zdjęć poprzez wyszukiwanie...\n');

    const tokenResult = await pool.query(`
      SELECT access_token FROM allegro_connections WHERE is_active = true LIMIT 1
    `);
    const accessToken = tokenResult.rows[0]?.access_token;

    if (!accessToken) {
      console.error('❌ Brak access token');
      return;
    }

    // Pobierz produkty bez zdjęć
    const result = await pool.query(`
      SELECT DISTINCT
        mp.offer_external_id,
        mp.name
      FROM commerce.marketplace_products mp
      WHERE (mp.image_url IS NULL OR mp.image_url = '')
      LIMIT 20
    `);

    console.log(`📊 Znaleziono ${result.rows.length} produktów bez zdjęć\n`);

    const items = result.rows.map((p: any) => ({
      productName: p.name,
      externalId: p.offer_external_id
    }));

    const downloadResult = await downloadProductImages(items, accessToken);
    
    console.log(`\n✅ Zakończono: ${downloadResult.success} sukces, ${downloadResult.failed} niepowodzeń`);

  } catch (error) {
    console.error('❌ Błąd:', error);
  } finally {
    await pool.end();
  }
}

fixMissingBySearch();
