from odoo import _, api, fields, models
from odoo.exceptions import UserError

from .market_mixin import ALLEGRO


class PaymentProvider(models.Model):
    _inherit = 'payment.provider'

    code = fields.Selection(selection_add=[(ALLEGRO, 'Allegro')], ondelete={ALLEGRO: 'set default'})

    def _compute_view_configuration_fields(self):
        super()._compute_view_configuration_fields()
        self.filtered(lambda provider_id: provider_id.code == ALLEGRO).update(
            {
                'show_credentials_page': False,
                'show_pre_msg': False,
                'show_done_msg': False,
                'show_cancel_msg': False,
                'show_pending_msg': False,
            }
        )

    @api.constrains('is_published', 'code')
    def _x_allegro_check_provider_is_published(self):
        if self.filtered(lambda provider_id: provider_id.code == ALLEGRO and provider_id.is_published):
            raise UserError(_('Allegro providers should never be published!'))

    @api.onchange('state')
    def _onchange_state_switch_is_published(self):
        if self.code == ALLEGRO:
            self.is_published = False
        else:
            super()._onchange_state_switch_is_published()

    def _get_default_payment_method_codes(self):
        if self.code == ALLEGRO:
            return [ALLEGRO]

        return super()._get_default_payment_method_codes()
