import logging

_logger = logging.getLogger(__name__)


# noinspection SqlWithoutWhere
def migrate(cr, version):
    _logger.info(f'end migration start (from {version})')

    # update payments
    _logger.info('update payment method for allegro payments')

    cr.execute('SELECT id from payment_method WHERE code = %s', ('allegro',))

    if allegro_method_id := cr.fetchone():
        cr.execute('SELECT id from payment_method WHERE code = %s', ('allegro_cash_on_delivery',))

        cod_method_id = cr.fetchone()
        _logger.info('update payment transactions')

        cr.execute(
            'UPDATE payment_transaction SET payment_method_id = %s WHERE payment_method_id = %s',
            (cod_method_id, allegro_method_id),
        )
        _logger.info('delete allegro payment method')
        cr.execute('DELETE FROM payment_method WHERE id = %s', (allegro_method_id,))

    _logger.info('end migration finished')
