# Specyfikacja Przepływu Produkcyjnego - Alpma OMS

## 1. Przegląd Procesu Produkcyjnego

Dokument opisuje kompleksowy przepływ materiałów i komponentów w procesie produkcyjnym firmy Alpma, od magazynu płyt meblowych do wysyłki gotowych produktów.

---

## 2. Schemat Przepływu Głównego

### 2.1. Magazyn Płyt → Cięcie Panelowe

```
┌─────────────────────┐
│  MAGAZYN PŁYT       │
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  PALETA PANELOWA    │  ← Operator nakłada płyty
│  (Nośnik)           │  ← Skanowanie kodów: PAL-001, PAL-002, PAL-003
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  START CIĘCIA       │
│  Piła Masterwood    │  ← Przypisanie materiału do palet 1,2,3
│  (Work Center)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  BUFOR PIŁY         │  ← Odkładanie po cięciu
│  PANELOWEJ          │
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           └─────────────────────┐
```

### 2.2. Rozwidlenie Po Cięciu

```
                      ┌──────────────────────────────┐
                      │   ZAKOŃCZENIE CIĘCIA         │
                      └────────┬─────────────────────┘
                               │
        ┌──────────────────────┼──────────────────────┐
        │                      │                      │
        ▼                      ▼                      ▼
┌──────────────┐      ┌──────────────┐      ┌──────────────┐
│ WIERCONE     │      │ OKLEJANE     │      │ BEZ OBRÓBKI  │
│              │      │              │      │              │
│ → BUFOR      │      │ → BUFOR      │      │ → MAGAZYN    │
│   WIERTARKI  │      │   OKLEINARKI │      │   FORMATEK   │
│              │      │              │      │   (HDF plecy)│
└──────────────┘      └──────────────┘      └──────────────┘
```

### 2.3. Ścieżka Specjalna - Tapicernia

```
┌─────────────────────┐
│  PŁYTA SUROWA       │
│  (po cięciu)        │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  WIERCENIE PUSZEK   │  ← Opcjonalne: zawiasy na siedziska
│  NA ZAWIASY         │
│  (Work Center)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  TAPICERNIA         │
│  Tapicerowanie      │
│  (Work Center)      │
└─────────────────────┘
```

### 2.4. Oklejanie

```
┌─────────────────────┐
│  BUFOR OKLEINARKI   │  ← Załadunek palety
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  OKLEINIARKA        │  ← Obróbka
│  Falit/Masterwood   │
│  (Work Center)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  BUFOR OKLEINARKI   │  ← Odkładanie po obróbce
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  BUFOR WIERTARKI    │
│  (Lokalizacja)      │
└─────────────────────┘
```

### 2.5. Wiercenie

```
┌─────────────────────┐
│  BUFOR WIERTARKI    │  ← Z okleinarki lub bezpośrednio
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  WIERTARKA          │  ← Obróbka
│  Master 1/2/Next    │
│  (Work Center)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  BUFOR WIERTARKI    │  ← Odkładanie po obróbce
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  BUFOR              │
│  KOMPLETOWANIA      │
│  (Lokalizacja)      │
└─────────────────────┘
```

### 2.6. Kompletowanie i Pakowanie

```
┌─────────────────────┐
│  BUFOR              │
│  KOMPLETOWANIA      │
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  KOMPLETOWANIE      │  ← Kompletowanie na nośniki
│  (Work Center)      │     • Wózek typ A
│                     │     • Wózek typ B
└──────────┬──────────┘     • Paleta EUR
           │                • Paleta niestandardowa
           │
           ▼
┌─────────────────────┐
│  TRANSPORT          │  ← Rolotok lub wózki
│  Do hali pakowania  │
└──────────┬──────────┘
           │
           ▼
┌─────────────────────┐
│  BUFOR PAKOWANIA    │
│  (Lokalizacja)      │
└──────────┬──────────┘
           │
           └─────────────────────┐
                                 │
        ┌────────────────────────┼────────────────────────┐
        │                        │                        │
        ▼                        ▼                        ▼
┌──────────────┐      ┌──────────────┐      ┌──────────────┐
│ PAKOWANIE    │      │ BUFOR        │      │ PRZYGOTOWANIE│
│ WYBRANYCH    │      │ (rolotok/    │      │ AKCESORIÓW   │
│ (zlecenie)   │      │ wózek/paleta)│      │ I OKUĆ       │
└──────┬───────┘      └──────────────┘      └──────┬───────┘
       │                                            │
       ▼                                            │
┌──────────────┐                                    │
│ PASKOWANIE   │ ←──────────────────────────────────┘
└──────┬───────┘
       │
       └─────────────────────┐
                             │
        ┌────────────────────┼────────────────────┐
        │                    │                    │
        ▼                    ▼                    ▼
┌──────────────┐    ┌──────────────┐    ┌──────────────┐
│ BUFOR        │    │ BUFOR        │    │ MAGAZYN      │
│ PAKOWANIA    │    │ WYSYŁKOWY    │    │ GOTOWYCH     │
│              │    │ (do wysłania)│    │ PRODUKTÓW    │
└──────────────┘    └──────────────┘    └──────────────┘
```

---

## 3. Kluczowe Elementy Systemu

### 3.1. Lokalizacje (Locations)

| Kod | Nazwa | Typ | Opis |
|-----|-------|-----|------|
| **MAG-PLY** | Magazyn Płyt | Magazyn | Początkowa lokalizacja płyt meblowych |
| **BUF-PIL** | Bufor Piły Panelowej | Bufor | Elementy po cięciu |
| **BUF-OKL** | Bufor Okleinarki | Bufor | Przed/po oklejaniu |
| **BUF-WIE** | Bufor Wiertarki | Bufor | Przed/po wierceniu |
| **BUF-KOM** | Bufor Kompletowania | Bufor | Przed kompletowaniem |
| **BUF-PAK** | Bufor Pakowania | Bufor | Hala pakowania |
| **BUF-WYS** | Bufor Wysyłkowy | Bufor | Gotowe do wysyłki |
| **MAG-FOR** | Magazyn Formatek | Magazyn | Formatki bez obróbki (HDF) |
| **MAG-GOT** | Magazyn Gotowych | Magazyn | Produkty spakowane |

### 3.2. Gniazda Robocze (Work Centers)

| Kod | Nazwa | Typ Operacji | Opis |
|-----|-------|--------------|------|
| **WC-PIL-MAS** | Piła Masterwood | Cięcie | Cięcie płyt na formatki |
| **WC-OKL-FAL** | Okleiniarka Falit | Oklejanie | Oklejanie krawędzi |
| **WC-OKL-MAS** | Okleiniarka Masterwood | Oklejanie | Oklejanie krawędzi |
| **WC-WIE-M1** | Wiertarka Master 1 | Wiercenie | Wiercenie otworów |
| **WC-WIE-M2** | Wiertarka Master 2 | Wiercenie | Wiercenie otworów |
| **WC-WIE-MNX** | Wiertarka Master Next | Wiercenie | Wiercenie otworów |
| **WC-TAP** | Tapicernia | Tapicerowanie | Tapicerowanie elementów |
| **WC-KOM** | Kompletowanie | Kompletowanie | Zbieranie komponentów |
| **WC-PAK** | Pakowanie | Pakowanie | Pakowanie produktów |
| **WC-PAS** | Paskowanie | Pakowanie | Zabezpieczanie palet |

### 3.3. Nośniki (Carriers)

| Typ | Kody Przykładowe | Zastosowanie |
|-----|-----------------|--------------|
| **Paleta Panelowa** | PPL-001, PPL-002, PPL-003 | Cięcie płyt |
| **Paleta EUR** | EUR-001...EUR-050 | Transport standardowy |
| **Wózek Typ A** | WOZ-A-001...A-020 | Kompletowanie małe |
| **Wózek Typ B** | WOZ-B-001...B-015 | Kompletowanie duże |
| **Wózek Typ C** | WOZ-C-001...C-010 | Transport specjalny |
| **Rolotok** | ROL-001...ROL-030 | Transport wewnętrzny |

### 3.4. Stany Materiału

- **raw** - Surowy (po cięciu)
- **edged** - Oklejony
- **drilled** - Wiercony
- **upholstered** - Tapicerowany
- **assembled** - Skompletowany
- **packed** - Spakowany
- **ready** - Gotowy do wysyłki

---

## 4. Status Implementacji

**Data aktualizacji:** 2025-11-11

### FAZA 1: Rozszerzenie Modelu Danych ✅ UKOŃCZONE

**Status:** Ukończone - wszystkie podstawowe struktury istnieją

- [x] Production Settings - moduł ustawień produkcji
- [x] Carrier Groups & Carriers - hierarchiczne grupy nośników (palety, wózki, rolotoki)
- [x] Locations (hierarchiczne) - 8 buforów Alpma (Magazyn, Piła, Okleiniarka, Wiertarka, Kompletowanie, Pakowanie, Wysyłka, Formatki)
- [x] Work Centers - 8 gniazd roboczych (Piła Masterwood, Okleiniarka Falit/Masterwood, Wiertarka Master 1/2/Next, Kompletowanie, Pakowanie)
- [x] Production Routings - trasowanie operacji z rozgałęzieniami
- [x] Production Orders (ZLP) - zlecenia produkcyjne z workflow
- [x] Material Consumption Norms - normy zużycia materiałów (płyty, okleiny, akcesoria) z warunkami wymiarowymi
- [x] Production Plans - plany produkcji z liniami planowania (agregacja zapotrzebowania z marketplace)

### FAZA 1.5: Planowanie Produkcji ⚠️ W TRAKCIE

**Status:** Częściowo ukończone - brakuje UI i logiki grupowania formatek

**Zrealizowane komponenty:**

#### A. Material Consumption Norms (Normy Zużycia Materiałów) ✅
- [x] Tabela `production.material_consumption_norms` - normy dla płyt, oklein, akcesoriów
- [x] Warunki wymiarowe (min/max długość/szerokość/wysokość)
- [x] UI Management - dodawanie/edycja norm z walidacją Zod
- [x] Backend CRUD `/api/production/norms/*`
- [x] **Decyzja:** Programowe wyliczanie materiałów (bez ręcznego BOM dla formatek)
  - Płyta: bazowa wartość m² + 20% odpad
  - Obrzeże: bazowa wartość mb + 2cm na każdą krawędź
  - System automatycznie liczy podczas generowania batchy

#### B. Production Plans (Plany Produkcji) ⚠️
- [x] Tabela `production.production_plans` - nagłówek planu
- [x] Tabela `production.production_plan_lines` - linie planowania z sourceType metadata
- [x] Agregacja zapotrzebowania z marketplace (Allegro/Shoper)
- [x] Dual-source selection (catalog products + marketplace orders)
- [x] UI: Lista planów `/production/plans`
- [x] UI: Tworzenie planu `/production/plans/new`
- [x] Backend endpoints `/api/production/plans/*` z demand aggregation
- [x] Detail page `/production/plans/:id` - podstawowa wersja
- [x] Available orders filtering (SQL-level: search, color, SKU, dimensions, customer, order, marketplace)
- [x] Collapsible orders z produktami jako children
- [x] Marketplace-catalog linking dialog
- [ ] **TODO:** Dual-panel responsive layout (CSS Grid)
- [ ] **TODO:** Filter presets jako 24px tiles (kolory, wymiary)
- [ ] **TODO:** Active filters summary panel
- [ ] **TODO:** Statistics panel (orders count, products count, plan lines, total quantity)
- [ ] **TODO:** Drag & Drop functionality

#### C. Production Orders (Zlecenia Produkcyjne) ✅
- [x] Tabela `production.production_orders` - zlecenia z workflow
- [x] Workflow stages: draft → confirmed → in_progress → cutting → ... → shipped
- [x] CRUD endpoints `/api/production/orders/*`
- [x] UI: Dashboard zleceń `/production/orders`
- [x] UI: Tworzenie zlecenia `/production/orders/new`
- [x] UI: Szczegóły zlecenia `/production/orders/:id`
- [x] Statistics endpoints (count by status)

#### D. BOM System Integration ✅
- [x] Tabela `production.bom_components` - komponenty BOM
- [x] UI: BOM Browser `/bom`
- [x] UI: BOM Components `/bom-components`
- [x] UI: Component Templates `/bom/component-templates`
- [x] Export BOM to Odoo (single + bulk)
- [x] Drilling information tracking (`drilling_required` field)
- [x] Auto-propagation: `component_templates.drilling_required` → `product_components.drilling_required`

#### E. Grupowanie Formatek (Batches) ❌ DO ZROBIENIA
- [ ] **Logika grupowania** według klucza: `${color}_drilling-${bool}_edging-${bool}`
- [ ] Endpoint: `POST /api/production/planning/lines/:id/generate-batches`
- [ ] Tabela: `production.formatka_batches` (lub rozszerzenie istniejącej)
- [ ] Algorytm:
  1. Pobierz BOM produktu z linii planu
  2. Dla każdego komponentu: ekstrahuj `color`, `drilling_required`, `edging_required`
  3. Grupuj według klucza
  4. Przypisz routing do każdego batch
  5. Automatycznie wylicz zużycie materiałów (normy + wymiary)
- [ ] UI: Accordion/Collapse view zgrupowanych batchy
- [ ] Możliwość ręcznego split/merge batchy

#### F. Częściowy Workflow ❌ DO ZROBIENIA
- [ ] Rozszerzenie `production_plan_lines`:
  - `stopBeforeStage?: string` - "packing", "picking", itp.
  - `targetLocation?: string` - "MAG-GOT", "MAG-FOR"
- [ ] UI: Split Line Dialog
- [ ] Backend: `POST /api/production/planning/lines/:id/split`
- [ ] Routing logic: conditional workflow based on `stopBeforeStage`
- [ ] **Przykład użycia:**
  - 15 szt → pełny workflow → pakowanie → wysyłka
  - 5 szt → częściowy workflow → STOP przed pakowaniem → MAG-GOT

**API Endpoints (Production Module):**
```
GET    /api/production/settings
PUT    /api/production/settings
GET    /api/production/norms
POST   /api/production/norms
GET    /api/production/norms/:id
PUT    /api/production/norms/:id
DELETE /api/production/norms/:id
GET    /api/production/plans
POST   /api/production/plans
GET    /api/production/plans/:id
PUT    /api/production/plans/:id
DELETE /api/production/plans/:id
POST   /api/production/plans/:id/lines
DELETE /api/production/plans/lines/:lineId
GET    /api/production/orders
POST   /api/production/orders
GET    /api/production/orders/:id
PUT    /api/production/orders/:id
DELETE /api/production/orders/:id
GET    /api/production/orders/stats

# Planning endpoints (używane w UI):
GET    /api/production/planning/plans/:id
GET    /api/production/planning/plans/:id/lines
POST   /api/production/planning/lines
DELETE /api/production/planning/lines/:id
GET    /api/production/planning/plans/:id/available-orders
GET    /api/production/demand/aggregate
POST   /api/production/planning/lines/:id/generate-batches  # TODO
POST   /api/production/planning/lines/:id/split             # TODO
```

**Frontend Pages:**
```
/production/settings           - Production Settings ✅
/production/plans              - Plans List ✅
/production/plans/new          - Create Plan ✅
/production/plans/:id          - Plan Detail ⚠️ (Częściowo - brak dual-panel, presets, stats)
/production/orders             - Orders Dashboard ✅
/production/orders/new         - Create Order ✅
/production/orders/:id         - Order Detail ✅
/bom                          - BOM Browser ✅
/bom-components               - BOM Components List ✅
/bom/component-templates      - Component Templates ✅
```

---

### FAZA 2: Śledzenie Materiałów (Material Flow Tracking) ✅ PODSTAWY ISTNIEJĄ

**Cel:** Rejestracja ruchu materiałów między lokalizacjami

**Status:** Tabele i struktura istnieją, wymaga rozbudowy UI

#### 2.1. Tabela: `production.production_material_movements` ✅

```typescript
{
  id: number
  movementDate: timestamp
  movementType: string           // 'production_start', 'between_locations', 'to_warehouse'
  
  // Materiał
  componentId: number | null      // FK do product_components (formatki)
  productId: number | null        // FK do catalog.products (produkty finalne)
  quantity: number
  unit: string                    // 'szt', 'm2', 'kg'
  
  // Lokalizacje
  sourceLocationId: number | null
  targetLocationId: number | null
  
  // Nośnik
  carrierId: number | null
  carrierCode: string | null
  
  // Kontekst produkcyjny
  productionOrderId: number | null
  workOrderId: number | null
  workCenterId: number | null
  routingOperationId: number | null
  
  // Operator i skanowanie
  operatorId: number | null
  scannedBarcode: string | null
  scanTimestamp: timestamp | null
  
  // Batch tracking
  batchNumber: string | null
  
  notes: text | null
  createdAt: timestamp
}
```

**Funkcjonalność:**
- [x] Dual-layer workflow tracking
- [x] Production orders: `workflow_stage` (Magazine→Cutting→...→Shipping)
- [x] Material movements: atomic batch transactions dla QR scanning
- [x] Location/carrier tracking
- [x] Operator/work order context

#### 2.2. Ekrany do implementacji ❌

1. **Skanowanie nośników** (`/production/scan`) - TODO
   - Skanowanie kodu kreskowego palety/wózka
   - Przypisanie do operacji/zlecenia
   - Rejestracja załadunku

2. **Ruch materiałów** (`/production/movements`) - TODO
   - Lista ruchów
   - Filtry: data, lokalizacja, nośnik, operator
   - Status w czasie rzeczywistym

3. **Mapa lokalizacji** (`/production/locations/map`) - TODO
   - Wizualizacja buforów
   - Poziom wypełnienia
   - Aktywne nośniki w lokalizacji

### FAZA 3: Wykonanie Operacji (Shop Floor Control) - TODO

**Cel:** Obsługa gniazd roboczych i rejestracja wykonania operacji

#### 3.1. Tabela: `production.work_center_operations` - PLANOWANE

```typescript
{
  id: number
  productionOrderId: number
  workCenterId: number
  operationId: number              // Z routing
  
  // Nośniki
  inputCarrierId: number           // Skąd pobrano
  outputCarrierIds: number[]       // Gdzie odłożono (może być kilka)
  
  // Czasy
  plannedStartTime: timestamp
  actualStartTime: timestamp | null
  plannedEndTime: timestamp
  actualEndTime: timestamp | null
  
  // Wykonanie
  operatorId: number
  status: string                   // 'pending', 'in_progress', 'completed', 'paused', 'cancelled'
  quantityPlanned: number
  quantityCompleted: number
  quantityRejected: number
  
  // Szczegóły
  notes: string | null
  pauseReasons: json | null        // [{reason, duration, timestamp}]
  qualityChecks: json | null
}
```

#### 3.2. Ekrany do implementacji - TODO

1. **Panel operatora** (`/production/shop-floor`)
   - Wybór gniazda roboczego
   - Lista przypisanych operacji
   - START/STOP/PAUZA
   - Skanowanie input/output carriers

2. **Monitor gniazd** (`/production/work-centers/monitor`)
   - Widok wszystkich gniazd
   - Status każdego w czasie rzeczywistym
   - Kolory: zielony (praca), żółty (pauza), czerwony (problem)

### FAZA 4: Kompletowanie i Pakowanie - TODO

**Cel:** Zarządzanie procesem kompletowania i pakowania

#### 4.1. Tabela: `production.picking_lists` - PLANOWANE

```typescript
{
  id: number
  productionOrderId: number
  pickingDate: timestamp
  
  // Komponenty do pobrania
  items: json[]                    // [{bomComponentId, quantity, locationId, picked}]
  
  // Nośnik docelowy
  targetCarrierId: number
  targetCarrierType: string        // 'pallet', 'cart-a', 'cart-b', 'rolltrack'
  
  // Akcesoria
  accessories: json[]              // [{warehouseMaterialId, quantity, picked}]
  
  status: string                   // 'pending', 'in_progress', 'completed'
  operatorId: number
}
```

#### 4.2. Tabela: `production.packing_orders` - PLANOWANE

```typescript
{
  id: number
  productionOrderId: number | null  // Może być zlecenie ad-hoc
  packingDate: timestamp
  
  // Źródło
  sourceCarrierId: number
  sourceLocationId: number
  
  // Pakowanie
  packageType: string              // 'box', 'pallet', 'custom'
  packageDimensions: json
  weight: number | null
  
  // Paskowanie
  strappingCompleted: boolean
  strappingDate: timestamp | null
  
  // Docelowa lokalizacja
  targetLocationId: number         // BUF-PAK lub BUF-WYS
  
  status: string
  operatorId: number
}
```

#### 4.3. Ekrany do implementacji - TODO

1. **Kompletowanie** (`/production/picking`)
   - Lista do skompletowania
   - Skanowanie komponentów
   - Potwierdzenie kompletności
   - Wybór nośnika docelowego

2. **Pakowanie** (`/production/packing`)
   - Lista do spakowania
   - Rejestracja wymiarów/wagi
   - Paskowanie
   - Wybór bufora docelowego

### FAZA 5: Raporty i Analityka - TODO

**Cel:** Monitoring wydajności i optymalizacja procesów

#### 5.1. Raporty do implementacji - TODO

1. **OEE (Overall Equipment Effectiveness)**
   - Dostępność gniazd
   - Wydajność (planed vs actual)
   - Jakość (good vs rejected)

2. **Przepustowość lokalizacji**
   - Ruch przez bufory
   - Czas przebywania w buforze
   - Wąskie gardła

3. **Wykorzystanie nośników**
   - Czas cyklu nośnika
   - Lokalizacja w czasie rzeczywistym
   - Historia ruchów

4. **Wydajność operatorów**
   - Wykonane operacje
   - Czas na operację
   - Jakość wykonania

---

## 5. Scenariusze Użycia (User Stories)

### US-1: Start Cięcia

**Jako** operator piły panelowej  
**Chcę** zarejestrować start cięcia z przypisaniem do palet  
**Aby** system wiedział gdzie odkładane są formatki

**Kroki:**
1. Wybór zlecenia produkcyjnego
2. Skanowanie kodu palety PPL-001
3. Skanowanie kodu palety PPL-002
4. Skanowanie kodu palety PPL-003
5. START operacji cięcia
6. System rejestruje: operator, czas start, palety output

### US-2: Zakończenie Cięcia i Transport

**Jako** operator piły  
**Chcę** zakończyć cięcie i określić dalszą ścieżkę  
**Aby** formatki trafiły do właściwego bufora

**Kroki:**
1. STOP operacji
2. Dla każdej palety wybór ścieżki:
   - "Wiercenie" → paleta do BUF-WIE
   - "Oklejanie" → paleta do BUF-OKL
   - "Magazyn" → paleta do MAG-FOR
3. System generuje task dla wózkarza/transportu

### US-3: Oklejanie z bufora

**Jako** operator okleinarki  
**Chcę** pobrać paletę z bufora i rozpocząć oklejanie  
**Aby** zarejestrować wykonanie operacji

**Kroki:**
1. Skanowanie palety w BUF-OKL
2. System pokazuje: co jest na palecie, z jakiego zlecenia
3. START operacji oklejania
4. Po zakończeniu: odkładanie na bufor
5. System aktualizuje status: paleta w BUF-OKL (po obróbce)
6. Automatyczne przesunięcie do BUF-WIE (jeśli routing wymaga wiercenia)

### US-4: Kompletowanie na wózek

**Jako** operator kompletowania  
**Chcę** skompletować zamówienie na wózek  
**Aby** przygotować do pakowania

**Kroki:**
1. Wybranie zlecenia produkcyjnego
2. System pokazuje picking list
3. Skanowanie wózka WOZ-A-005
4. Skanowanie każdego komponentu z bufora
5. Potwierdzenie kompletności
6. Transport na rolotoku do BUF-PAK

---

## 6. Integracje i Zależności

### 6.1. BOM (Bill of Materials) ✅
- Generowanie picking lists na podstawie BOM
- Automatyczne rezerwacje materiałów
- Śledzenie zużycia vs planowane
- **Drilling tracking:** `component_templates.drilling_required` → `product_components.drilling_required`
- **Formatka visualization:** `/api/catalog/formatka/:componentId/visualization`

### 6.2. Warehouse (Magazyn) ✅
- Pobieranie akcesoriów/okuć
- Aktualizacja stanów magazynowych
- Rezerwacje pod zlecenia produkcyjne
- **Material inventory:** `warehouse.materials` z kategoriami (Okucia, Płyty, Śruby, Tkaniny, Pianki)

### 6.3. Odoo ERP ⚠️
- Synchronizacja zleceń produkcyjnych - TODO
- Eksport statusów wykonania - TODO
- Raportowanie zużycia materiałów - TODO
- **BOM Export:** ✅ Single + bulk export do Odoo z automatic BOM line synchronization

---

## 7. Priorytety Implementacji (Roadmap)

### Sprint 1: UI Production Planning - Dual-Panel + Filters (2 dni) ⚠️ PRIORYTET
- [ ] CSS Grid responsive layout (left: orders, right: plan items + stats)
- [ ] 24px filter presets (kolory z tłem, wymiary)
- [ ] Active filters summary panel
- [ ] Statistics cards (orders count, products count, plan lines, total quantity)

### Sprint 2: Batch Generation Logic (3 dni) ⚠️ PRIORYTET
- [ ] Backend: algorytm grupowania formatek (color + drilling + edging)
- [ ] Endpoint: `/api/production/planning/lines/:id/generate-batches`
- [ ] Tabela: `production.formatka_batches`
- [ ] Programowe wyliczanie materiałów (normy + wymiary)
- [ ] UI: accordion view zgrupowanych batchy

### Sprint 3: Partial Workflow (2 dni)
- [ ] Rozszerzenie `production_plan_lines`: `stopBeforeStage`, `targetLocation`
- [ ] Split Line Dialog UI
- [ ] Backend: endpoint split line
- [ ] Routing logic: conditional workflow

### Sprint 4: Drag & Drop (2 dni) - FUTURE
- [ ] Draggable products/orders (left panel)
- [ ] Drop zone (right panel)
- [ ] Visual feedback
- [ ] Auto-scroll

### Sprint 5: Material Flow UI (3 dni)
- [ ] Ekran skanowania nośników (`/production/scan`)
- [ ] Historia ruchów materiałów (`/production/movements`)
- [ ] Mapa lokalizacji (`/production/locations/map`)

### Sprint 6: Shop Floor Control (5 dni) - LONG TERM
- [ ] Tabela `work_center_operations`
- [ ] Panel operatora
- [ ] Monitor gniazd roboczych
- [ ] START/STOP/PAUZA operacji

### Sprint 7: Kompletowanie i Pakowanie (4 dni) - LONG TERM
- [ ] Tabele `picking_lists`, `packing_orders`
- [ ] UI kompletowania
- [ ] UI pakowania
- [ ] Integracja z paskow aniem

### Sprint 8: Visualization & Analytics (5 dni) - FUTURE
- [ ] Flowchart przepływu formatek (React Flow)
- [ ] Real-time progress tracking
- [ ] OEE reports
- [ ] Wykorzystanie nośników
- [ ] Wydajność operatorów

---

## 8. Dokumentacja Uzupełniająca

- **[production-workflow-examples.md](./production-workflow-examples.md)** - Przykłady procesów produkcyjnych z timeline'ami
- **[production-plan-ui-specification.md](./production-plan-ui-specification.md)** - Szczegółowa specyfikacja UI dodawania produktów do planu

---

**Dokument zaktualizowany:** 2025-11-11  
**Wersja:** 2.0  
**Następne kroki:** Sprint 1 - Dual-Panel Layout + Filter Presets
