interface DictionaryItem {
  id: number;
  code: string;
  name: string | null;
  shortName: string | null;
  color: string | null;
  isActive: boolean;
}

export const getColorHex = (colorCode: string, colors: DictionaryItem[]): string | null => {
  if (!colorCode) return null;
  const colorItem = colors.find(c => c.code.toLowerCase() === colorCode.toLowerCase());
  return colorItem?.color || null;
};

export const getProductTypeColor = (typeCode: string, productTypes: DictionaryItem[]): string | null => {
  if (!typeCode) return null;
  const typeItem = productTypes.find(t => t.code.toLowerCase() === typeCode.toLowerCase());
  return typeItem?.color || null;
};

export const getTextColor = (bgColor: string): string => {
  if (!bgColor) return "#FFFFFF";
  
  // For HSL colors, extract lightness value
  const hslMatch = bgColor.match(/hsl\((\d+),\s*(\d+)%,\s*(\d+)%\)/);
  if (hslMatch) {
    const lightness = parseInt(hslMatch[3]);
    return lightness > 50 ? "#000000" : "#FFFFFF";
  }
  
  // For HEX colors, convert to RGB first
  const hexMatch = bgColor.match(/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i);
  if (hexMatch) {
    const r = parseInt(hexMatch[1], 16);
    const g = parseInt(hexMatch[2], 16);
    const b = parseInt(hexMatch[3], 16);
    const brightness = (r * 299 + g * 587 + b * 114) / 1000;
    return brightness > 128 ? "#000000" : "#FFFFFF";
  }
  
  // Fallback for rgb() format
  const rgbMatch = bgColor.match(/rgb\((\d+),\s*(\d+),\s*(\d+)\)/);
  if (rgbMatch) {
    const brightness = (parseInt(rgbMatch[1]) * 299 + parseInt(rgbMatch[2]) * 587 + parseInt(rgbMatch[3]) * 114) / 1000;
    return brightness > 128 ? "#000000" : "#FFFFFF";
  }
  
  return "#FFFFFF";
};
