import { useFilterTabsBar, type FilterTabsData } from './FilterTabsBar';

interface PlanTabsBarProps {
  planId: string;
  searchFilter: string;
  onSearchChange: (value: string) => void;
}

export function usePlanTabsBar({ planId, searchFilter, onSearchChange }: PlanTabsBarProps) {
  return useFilterTabsBar({
    planId,
    storageKeyPrefix: "production-plan-tabs",
    searchFilter,
    onSearchChange,
    testIdPrefix: "plan-tab"
  });
}

export type { FilterTabsData };
