import { Router } from "express";
import { settingsRouter } from "./settings";
import { normsRouter } from "./norms";
import { bufferRouter } from "./buffer";
import { setupCarrierRoutes } from "./carriers";
import { setupLocationRoutes } from "./locations";
import { setupLocationGroupRoutes } from "./location-groups";
import { registerWorkCenterRoutes } from "./work-centers";
import { registerRoutingRoutes } from "./routings";
import { registerOrderRoutes } from "./orders";
import { registerMaterialMovementRoutes } from "./material-movements";
import { registerBomRoutes } from "./boms";
import { registerComponentRoutes } from "./components";
import { registerPlanningRoutes } from "./planning";
import { registerProductGroupRoutes } from "./product-groups";
import { registerCuttingPatternRoutes } from "./cutting-patterns";
import { registerCutPatternTemplateRoutes } from "./cut-pattern-templates";
import { registerCutPatternRunRoutes } from "./cut-pattern-runs";
import planNameTemplatesRouter from "./plan-name-templates";
import type { Express } from "express";

export const productionRouter = Router();

// Mount sub-routers
productionRouter.use("/settings", settingsRouter);
productionRouter.use("/norms", normsRouter);
productionRouter.use("/buffer", bufferRouter);
productionRouter.use("/plan-name-templates", planNameTemplatesRouter);

// Import and setup routes that need app instance for direct mounting
export function setupProductionRoutes(app: Express) {
  setupCarrierRoutes(app);
  setupLocationRoutes(app);
  setupLocationGroupRoutes(app);
  registerWorkCenterRoutes(app);
  registerRoutingRoutes(app);
  registerOrderRoutes(app);
  registerMaterialMovementRoutes(app);
  registerBomRoutes(app);
  registerComponentRoutes(app);
  registerPlanningRoutes(app);
  registerProductGroupRoutes(app);
  registerCuttingPatternRoutes(app);
  registerCutPatternTemplateRoutes(app);
  registerCutPatternRunRoutes(app);
}

// Health check endpoint
productionRouter.get("/health", (req, res) => {
  res.json({ 
    status: "ok", 
    module: "production",
    timestamp: new Date().toISOString(),
  });
});
