#!/bin/bash
# Automatyczna naprawa uprawnień SFTP dla OMS file storage
# Uruchom na serwerze Hetzner jako root

echo "🔧 Automatyczna naprawa konfiguracji SFTP..."
echo ""

# Kolory
GREEN='\033[0;32m'
BLUE='\033[0;34m'
NC='\033[0m'

# 1. Utwórz główny folder
echo -e "${BLUE}📁 Tworzę folder /var/www/files/OMS...${NC}"
mkdir -p /var/www/files/OMS
echo -e "${GREEN}✅ Folder główny utworzony${NC}"

# 2. Utwórz wszystkie podfoldery
echo ""
echo -e "${BLUE}📂 Tworzę podfoldery...${NC}"
mkdir -p /var/www/files/OMS/products/images
mkdir -p /var/www/files/OMS/accessories/images
mkdir -p /var/www/files/OMS/exports/pdf
mkdir -p /var/www/files/OMS/exports/csv
mkdir -p /var/www/files/OMS/ai-cache
echo -e "${GREEN}✅ Wszystkie podfoldery utworzone${NC}"

# 3. Ustaw właściciela
echo ""
echo -e "${BLUE}👤 Ustawiam właściciela na oms-sftp...${NC}"
chown -R oms-sftp:oms-sftp /var/www/files/OMS
echo -e "${GREEN}✅ Właściciel ustawiony${NC}"

# 4. Ustaw uprawnienia
echo ""
echo -e "${BLUE}🔐 Ustawiam uprawnienia 755...${NC}"
chmod -R 755 /var/www/files/OMS
echo -e "${GREEN}✅ Uprawnienia ustawione${NC}"

# 5. Pokaż wynik
echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo -e "${GREEN}✅ KONFIGURACJA ZAKOŃCZONA!${NC}"
echo ""
echo "📊 Struktura folderów:"
ls -lah /var/www/files/OMS
echo ""
echo "📂 Podfoldery:"
find /var/www/files/OMS -type d -exec ls -ld {} \;
echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo "💡 Teraz możesz:"
echo "   1. Przetestować połączenie w OMS (Settings → Serwer plików → Test)"
echo "   2. Uruchomić migrację plików"
echo ""
