# Alpma OMS - Zarządzanie Zamówieniami

## Overview
Alpma OMS (Order Management System) is a professional web application for managing orders from Allegro and Shoper platforms. It automates order fetching, payment verification, and data synchronization. The project aims to provide a unified e-commerce order management platform, capable of integrating with other business systems like Odoo, to enhance operational efficiency and scalability for businesses operating on multiple platforms. Key capabilities include comprehensive order management, real-time synchronization, a secure API, robust user authentication, and detailed statistics.

## User Preferences
- Język: Polski (wszystkie UI teksty)
- Motyw domyślny: Dark mode
- OAuth flow: Przekierowanie na stronę Allegro (jak w module Odoo)
- Częstotliwość synchronizacji: Co kilka minut (konfigurowalne: 1, 3, 5, 10 min)

## System Architecture

### UI/UX Decisions
- **Frontend Framework**: React 18 with Vite, Shadcn UI (Radix UI, Tailwind CSS).
- **Theming**: Dark/Light mode support.
- **Navigation**: Wouter for client-side routing with `safeGoBack` helper.
- **Data Display**: Dashboard with key metrics and a detailed, sortable orders table.
- **Mobile Responsiveness**: Full mobile support with adaptive layouts.
- **Corpo ERP UI Design**: Compact, sharp-edged professional styling, two-tone backgrounds, clear spacing, accent-colored highlights.
- **Right Sidebar**: Global right sidebar with localStorage persistence, SSR guards, relationship visualizations.
- **Warehouse Details Pages**: Redesigned ERP-style compact layout with product images, dictionary-driven hex color tiles, absolute-positioned stock badges, uniform parameter tiles, comprehensive quick-action headers.
- **Warehouse Sidebar Navigation**: Nested submenu structure with "Grupy" links for all material categories, providing hierarchical navigation and quick group creation via a shared `CreateGroupDialog` component.
- **Warehouse Material Edit**: Dedicated edit pages for all warehouse materials via `/warehouse/{category}/{id}/edit` URLs, featuring inline group assignment with combobox selector and on-the-fly group creation.
- **Inventory Count Layout**: Optimized layout with sequential row numbering, "Spisano" input field immediately after product name, integer-only enforcement for "szt" unit, and responsive design.

### Technical Implementations
- **Backend**: Express.js with TypeScript.
- **Data Fetching & State Management**: TanStack Query v5.
- **Form Handling**: React Hook Form with Zod validation.
- **Persistence**: Dual-layer storage for raw platform data and normalized `commerce.orders`.
- **Authentication**: Username/password with PostgreSQL, Passport.js, session management, CSRF protection.
- **Authorization**: Role-based access control (admin/manager/user).
- **Image Optimization**: Automatic thumbnail generation system using Sharp library (3 WebP versions: thumbnail, medium, full-quality) for uploaded product images. Files stored locally.
- **Matrix Variant ID System**: Stable product identification system (`{matrixId}-{length}-{width}-{height}-{color}-{option1}...`) with UNIQUE database constraint and backfill script.
- **Modules**: Allegro Fees Management, Product Catalog, Product Creator Dictionaries, Product Matrix/Generator, Set Matrix, Advanced Product Filtering, Template-Based Accessory System, Conditional AI Sections, Product Image Tags, Color Generation Tracking, Color Options, Bidirectional Navigation between Set Matrices and Generated Catalog Sets, Enhanced Set Description, Product-Set Relationship Protection, Warehouse Management System (material inventory, gallery, supplier codes, server-side filtering, bulk operations, view modes, pagination, dictionary-driven color tiles, material edit, warehouse groups management), Formatki Stock Panels, Packaging Materials, BOM Generation, Formatka Visualization, Production Module, Production Buffer/Warehouse Reservation System.
- **Automatic Formatka Reservation System**: When adding products to production plans (ZLP), the system automatically searches warehouse inventory for matching formatki components based on BOM specifications, then creates buffer reservations. System uses two-tier search logic: first attempts to find dedicated formatki with exact position codes (e.g., WD-VB-600x300-N1-BIALY), then falls back to universal formatki matching dimensions and color (e.g., SIEDZISKO-VB-500x300-SUROWA). Warehouse UI displays three states for each material: total quantity, reserved quantity (red badge), and available quantity (green badge). Formatka properties stored in JSONB `specifications` column matching BOM structure (componentType, furnitureType, positionCode, length, width, thickness, color). Reservations created at plan line level with nullable `zlp_id` (before ZLP exists), linked via `zlp_item_id`.
- **Packed Products Reservation System**: Automatic transactional reservation system for packed products (produkty-spakowane) in warehouse. When adding packed products to production plans (ZLP), the system automatically increments `reserved_quantity` in `warehouse.packed_products` table within the same database transaction as plan line creation. When deleting plan lines, reservations are automatically released using `GREATEST(0, reserved_quantity - quantity)` to prevent negative values. Warehouse UI displays three KPI tiles for packed products: Stan mag. (total quantity), Zarezerwowane (reserved quantity with yellow background), Dostępne (available quantity with green background - calculated as quantity - reserved_quantity). System uses transactional integrity (BEGIN/COMMIT/ROLLBACK) to ensure reservation consistency and propagates errors to prevent partial failures. UI includes per-line reservation toggle buttons (Lock/Unlock icons) in plan items table for manual reserve/unreserve operations.
- **Serialized Inventory Tracking for Packed Products**: Item-level inventory tracking system enabling FIFO management, defect tracking, and individual unit lifecycle management. Each physical unit gets a unique serial number (`{catalogProductId}-{YYYYMMDD}-{seq}`) stored in `warehouse.packed_product_items` table with `source_type` and `source_id` for origin tracking (inventory_count, production, manual). Status lifecycle: available → reserved → shipped → returned/scrapped, with strict transition validation and concurrent-safe FIFO selection using `FOR UPDATE SKIP LOCKED`. Summary table (`packed_products`) aggregates from items table dynamically. Dedicated UI page at `/warehouse/produkty-spakowane/:id/items` with status filtering tabs (Dostępne, Zarezerwowane, Wysłane, Zwrócone, Wadliwe, Zezłomowane), "Dodaj do spisu" button creates inventory count for controlled stock adjustments, and source origin badges with navigation links. Inventory count finalize creates/scraps items automatically with FIFO ordering and proper source tracking.
- **Auto BOM Assignment**: When adding products to production plans, system automatically assigns active BOM (`bom_id`) from `bom.product_boms` table if product has defined BOM. Uses latest version with `is_active = true`.
- **Order Matching**: Tool for reconciling orders across platforms.
- **Automated Systems**: Auto-Healing Synchronization System (auto-fetch missing orders, retry failed syncs, detect missing orders in Odoo, runs every 15 min), Nightly Full Sync scheduler.
- **Generation Progress Dialog**: Unified dialog for real-time progress and live SSE log streaming.
- **Timezone Handling**: Unified UTC storage with automatic DST conversion to Europe/Warsaw.
- **Backup System**: Automated SFTP backup with dual-source listing and transparent download fallback.

### Feature Specifications
- **OAuth Integration**: Secure OAuth 2.0 with Allegro.
- **Automated Synchronization**: Configurable cyclic synchronization for Allegro and Shoper.
- **Dashboard & Order Table**: Overview of orders and revenue, with filtering, searching, and sorting.
- **Configuration Panel**: Centralized settings for OAuth, synchronization, and connections.
- **Historia Zmian (Change History)**: Unified page with tabs for detected changes, recent updates, and sync logs.
- **User Management**: Admin-only CRUD for users, roles, and permissions.
- **API Token Management**: Admin-only CRUD for API tokens with audit logs.
- **Webhook Management**: Admin-only CRUD for webhook configurations and delivery logs.
- **Recent Updates**: Page for verifying orders by marketplace `last_update` timestamp.
- **BOM Export to Odoo**: Single and bulk export of Bill of Materials to Odoo ERP system.
- **Set Matrix Navigation**: Bidirectional navigation between Set Matrices and Generated Catalog Sets.
- **Production Planning Dual-Panel System**: Advanced order-to-production planning interface with dual-panel layout, marketplace order filtering, catalog product mapping, persistent filter state, collapsible order cards, one-click adding to plan, unmapped product handling, real-time statistics, active filters summary, exclusion of already-planned items. Includes a Custom Filterable Tabs System and Batch Operations System. Redesigned plan header with horizontal 80px layout featuring inline data elements and responsive flex-wrap. Optimized plan items table with combined dimension columns. **Token-Based Filtering System**: Backend parses semicolon-delimited search tokens into structured filters (marketplace, payment status, general search terms).
- **Multi-Source Product Selection for ZLP**: Unified system for adding products to Production Plans (ZLP) from customer orders, internal catalog products, and cutting patterns, with visual category selector and recently-added tracking.
- **Plan Name Templates System**: Template-based automatic plan naming with `{token|format}` syntax, daily sequence counters, and metadata tracking on production plans.
- **Marketplace-to-Catalog Bidirectional Linking**: Extended linking system supporting both catalog products and catalog sets with tabbed UI, separate search inputs, `link_type` discriminator, and unified suggestion rendering.
- **Production Routings Management**: Full CRUD for production routings with inline operations editing, drag-and-drop reordering, auto-generated routing codes (e.g., "marsz_siedziska_tapicerowane") and operation codes.

### System Design Choices
- **Dual Product Architecture**: Marketplace Products (`commerce.marketplace_products`) and Generated Catalog Products (`catalog.products`).
- **Unified Schema**: `commerce` for order management, `catalog` for generated product catalog, `product_creator` for matrix/dictionary system, `warehouse` for material inventory management, `production` for manufacturing management.
- **Modularity**: Separated `client`, `server`, and `shared` types.
- **Scalability**: Designed for integration with Odoo.
- **Schema Consistency**: Dedicated schemas for catalog, warehouse, and production entities.

## External Dependencies
- **Database**: PostgreSQL (Replit) with multiple schemas.
- **E-commerce Platforms**:
    - **Allegro API**: OAuth, order synchronization, customer returns (BETA), payments/refunds.
    - **Shoper API**: Order synchronization, product details.
- **External File Storage**: Configurable SFTP (files.alpsys.pl) and local file storage with adapter pattern.
- **Odoo Integration**: Direct integration via Cloudflare Tunnel with dual-mode synchronization, product export with comprehensive field mapping, image base64 conversion, SKU validation.
- **AI Integrations**: OpenAI for AI-assisted content generation (via Replit AI Integrations) with section-based AI prompt system.
- **Accessory Grid JPG Rendering**: Automated system using Puppeteer for rendering accessory grids as JPG images, with caching.