# Przykładowe Procesy Produkcyjne - Alpma OMS

## Wprowadzenie

Dokument prezentuje rzeczywiste procesy produkcyjne dla typowych produktów Alpma, pokazując pełen przepływ od magazynu płyt do wysyłki.

---

## Przykład 1: Szafka z Siedziskiem Tapicerowanym (Pełny Workflow)

**Produkt:** Szafka do butów z siedziskiem tapicerowanym  
**SKU:** ALO-SZB-001  
**Komponenty BOM:**
- 2x Panel boczny (oklejany + wiercony)
- 1x Panel górny (oklejany + wiercony)
- 1x Panel dolny (oklejany + wiercony)
- 1x Siedzisko (tapicerowane + wiercone)
- 1x Plecy HDF (surowe)
- Akcesoria: zawiasy, wkręty, nóżki

---

### Krok 1: Generowanie Zlecenia Produkcyjnego

```
ZLP-2025-001234
├─ Produkt: ALO-SZB-001 (qty: 1)
├─ Priorytet: Normalny
├─ Termin: 2025-11-15
└─ Status: draft → confirmed
```

**System automatycznie:**
- Generuje routing na podstawie BOM
- Rezerwuje materiały z magazynu
- Tworzy picking list dla akcesoriów
- Przypisuje do dostępnych gniazd roboczych

---

### Krok 2: Cięcie Panelowe (WC-PIL-MAS)

**Lokalizacja start:** MAG-PLY  
**Gniazdo:** Piła Masterwood  
**Operator:** Jan Kowalski

#### Operacja:
1. **Załadunek materiału:**
   - Płyta biała 18mm → Paleta PPL-001
   - Płyta dąb 18mm → Paleta PPL-002
   - HDF 3mm → Paleta PPL-003

2. **Skanowanie palet:**
   ```
   SCAN: PPL-001 ✓
   SCAN: PPL-002 ✓
   SCAN: PPL-003 ✓
   ```

3. **START cięcia:**
   - System: "Rozpoczęto cięcie ZLP-2025-001234"
   - Czas start: 08:15

4. **Cięcie komponentów:**
   - Panel boczny L (480x400mm) → PPL-001
   - Panel boczny R (480x400mm) → PPL-001
   - Panel górny (800x400mm) → PPL-001
   - Panel dolny (800x400mm) → PPL-001
   - Siedzisko (800x400mm) → PPL-002
   - Plecy HDF (780x470mm) → PPL-003

5. **Identyfikacja typu formatki:**
   ```
   System: "Siedzisko (800x400mm) → Typ: SIEDZISKO"
   System: "Panel boczny L → Typ: PANEL"
   ```

6. **STOP cięcia:**
   - Czas end: 08:42
   - Czas rzeczywisty: 27 min (plan: 30 min)

#### Routing decyzje:

**Paleta PPL-001 (Panele białe):**
- Routing: Oklejanie → Wiercenie
- Akcja: Transport do **BUF-OKL**

**Paleta PPL-002 (Siedzisko dąb):**
- Typ formatki: **SIEDZISKO**
- Routing: Wiercenie puszek → Tapicerowanie → Wiercenie → Kompletowanie
- Akcja: Transport do **WC-WIE-M1** (wiercenie puszek na zawiasy)

**Paleta PPL-003 (HDF plecy):**
- Routing: Brak obróbki
- Akcja: Transport do **MAG-FOR** (magazyn formatek)

---

### Krok 3A: Oklejanie Paneli (WC-OKL-FAL)

**Lokalizacja:** BUF-OKL  
**Gniazdo:** Okleiniarka Falit  
**Operator:** Anna Nowak

#### Operacja:
1. **Pobranie z bufora:**
   ```
   SCAN: PPL-001 (BUF-OKL)
   System: "Paleta PPL-001 - 4 panele białe, ZLP-2025-001234"
   ```

2. **START oklejania:**
   - Czas start: 09:05
   - Taśma: Biała ABS 2mm

3. **Obróbka:**
   - Panel boczny L: wszystkie krawędzie ✓
   - Panel boczny R: wszystkie krawędzie ✓
   - Panel górny: 3 krawędzie (tylna surowa pod plecy) ✓
   - Panel dolny: 3 krawędzie ✓

4. **STOP oklejania:**
   - Czas end: 09:28
   - Odkładanie: **BUF-OKL** (strefa po obróbce)

5. **Automatyczny routing:**
   ```
   System: "Paleta PPL-001 → następna operacja: Wiercenie"
   System: "Generowanie zadania transportu → BUF-WIE"
   ```

---

### Krok 3B: Wiercenie Puszek + Tapicerowanie (SIEDZISKO)

**Lokalizacja:** WC-WIE-M1  
**Gniazdo:** Wiertarka Master 1  
**Operator:** Piotr Wiśniewski

#### Operacja 1 - Wiercenie puszek:
1. **Pobranie:**
   ```
   SCAN: PPL-002
   System: "Siedzisko 800x400mm dąb - wymaga wiercenia puszek na zawiasy"
   ```

2. **START wiercenia puszek:**
   - Czas start: 09:10
   - Program: PUSZKI_SIEDZISKO_35mm

3. **Wiercenie:**
   - 4x otwór Ø35mm głębokość 13mm ✓

4. **STOP:**
   - Czas end: 09:17
   - Odkładanie: Przygotowanie do tapicerni

#### Operacja 2 - Tapicerowanie:

**Lokalizacja:** WC-TAP  
**Gniazdo:** Tapicernia  
**Operator:** Maria Kowalska

1. **Pobranie:**
   ```
   SCAN: PPL-002
   System: "Siedzisko - po wierceniu puszek, gotowe do tapicerowania"
   ```

2. **START tapicerowania:**
   - Czas start: 10:30 (oczekiwanie w kolejce: 1h 13min)
   - Materiał: Tkanina szara CODE-TAP-05
   - Pianka: 40mm

3. **Tapicerowanie:**
   - Montaż pianki ✓
   - Obicie tkaniną ✓
   - Zszywanie spodu ✓

4. **STOP:**
   - Czas end: 10:52
   - Status: Siedzisko tapicerowane
   - Odkładanie: **BUF-WIE** (czeka na wiercenie montażowe)

---

### Krok 4: Wiercenie Montażowe (WC-WIE-M2)

**Lokalizacja:** BUF-WIE  
**Gniazdo:** Wiertarka Master 2  
**Operator:** Tomasz Zieliński

#### Przetwarzanie wszystkich komponentów:

1. **Pobranie palet z bufora:**
   ```
   SCAN: PPL-001 (panele oklejone)
   SCAN: PPL-002 (siedzisko tapicerowane)
   ```

2. **START wiercenia:**
   - Czas start: 11:15

3. **Wiercenie według programu CNC:**
   - Panel boczny L: otwory montażowe + zawiasowe ✓
   - Panel boczny R: otwory montażowe + zawiasowe ✓
   - Panel górny: otwory połączeniowe ✓
   - Panel dolny: otwory połączeniowe + nóżki ✓
   - Siedzisko tapicerowane: otwory montażowe ✓

4. **STOP wiercenia:**
   - Czas end: 11:47
   - Odkładanie: **BUF-KOM** (wszystko gotowe do kompletowania)

---

### Krok 5: Kompletowanie (WC-KOM)

**Lokalizacja:** BUF-KOM  
**Gniazdo:** Kompletowanie  
**Operator:** Ewa Lewandowska

#### Przygotowanie nośnika:
1. **Wybór wózka:**
   ```
   SCAN: WOZ-A-007
   System: "Wózek A-007 - pojemność: 8 paczek średnich"
   ```

#### Picking list - Komponenty:
2. **Skanowanie komponentów z BOM:**
   ```
   SCAN: Panel boczny L (z PPL-001) ✓
   SCAN: Panel boczny R (z PPL-001) ✓
   SCAN: Panel górny (z PPL-001) ✓
   SCAN: Panel dolny (z PPL-001) ✓
   SCAN: Siedzisko tapicerowane (z PPL-002) ✓
   ```

3. **Pobranie HDF z magazynu:**
   ```
   Przejście do MAG-FOR
   SCAN: Plecy HDF 780x470mm (z PPL-003) ✓
   ```

#### Picking list - Akcesoria:
4. **Kompletowanie akcesoriów** (przygotowane wcześniej równolegle):
   ```
   Lokalizacja: Strefa akcesoriów
   SCAN: Woreczek #1 - Zawiasy 4szt ✓
   SCAN: Woreczek #2 - Wkręty mix 20szt ✓
   SCAN: Woreczek #3 - Nóżki 4szt ✓
   SCAN: Karton instrukcji ✓
   ```

5. **Kompletność:**
   ```
   System: "Picking list 100% kompletna"
   System: "Wszystkie komponenty na WOZ-A-007"
   ```

6. **Transport:**
   - Wózek WOZ-A-007 → **ROLOTOK-1** → Hala pakowania

---

### Krok 6: Pakowanie (WC-PAK)

**Lokalizacja:** BUF-PAK (po transporcie rolotokiem)  
**Gniazdo:** Pakowanie  
**Operator:** Krzysztof Nowicki

#### Przygotowanie:
1. **Odbiór z rolotoka:**
   ```
   SCAN: WOZ-A-007 (przybył z BUF-KOM)
   System: "ZLP-2025-001234 - ALO-SZB-001 - 6 komponentów + akcesoria"
   ```

2. **Karton:**
   - Rozmiar: 850x450x150mm
   - Wypełnienie: Pianka wrap
   - Etykieta: Wygenerowana automatycznie

#### Pakowanie:
3. **Układanie w kartonie:**
   - Panel dolny (płasko, dół) ✓
   - Panele boczne (pionowo, boki) ✓
   - Panel górny (płasko, środek) ✓
   - Plecy HDF (płasko, góra) ✓
   - Siedzisko tapicerowane (ochrona pianką, góra) ✓
   - Woreczki z akcesoriami (bok) ✓
   - Instrukcja (góra) ✓

4. **Zamknięcie i etykietowanie:**
   ```
   Waga: 18.5 kg
   Wymiary: 850x450x150mm
   GENERUJ QR CODE: PKG-2025-001234-001
   ```

5. **Skanowanie paczki:**
   ```
   SCAN: PKG-2025-001234-001
   System: "Paczka zarejestrowana - status: SPAKOWANA"
   ```

#### Decyzja o paskowanie:
6. **Sprawdzenie kompletności zlecenia:**
   ```
   System: "ZLP-2025-001234 - wszystkie komponenty dostępne ✓"
   System: "Brak oczekiwań na klienta ✓"
   System: "Routing → PASKOWANIE"
   ```

7. **Transport na linię:**
   - Paczka → **linia transportowa** → maszyna paskująca

---

### Krok 7: Paskowanie (część WC-PAK)

**Lokalizacja:** Maszyna paskująca  
**Operator:** Krzysztof Nowicki

#### Operacja:
1. **Przygotowanie palety:**
   ```
   SCAN: EUR-025
   System: "Paleta EUR-025 aktywowana"
   ```

2. **Paskowanie kartonu:**
   - Paczka przechodzi przez maszynę
   - 2x pasek poziomy ✓
   - 1x pasek pionowy ✓

3. **Odkładanie na paletę:**
   ```
   SCAN: PKG-2025-001234-001 (przy odkładaniu na paletę)
   SCAN: EUR-025 (potwierdzenie palety)
   System: "Paczka PKG-2025-001234-001 → Paleta EUR-025"
   ```

4. **Status:**
   ```
   System: "ZLP-2025-001234 - COMPLETED ✓"
   System: "Paleta EUR-025 → BUF-WYS (bufor wysyłkowy)"
   ```

---

## Podsumowanie Procesu - Szafka ALO-SZB-001

### Timeline:
```
08:15 - START cięcia
08:42 - KONIEC cięcia (27 min)
09:05 - START oklejania paneli
09:28 - KONIEC oklejania (23 min)
09:10 - START wiercenia puszek (siedzisko)
09:17 - KONIEC wiercenia puszek (7 min)
10:30 - START tapicerowania (po kolejce)
10:52 - KONIEC tapicerowania (22 min)
11:15 - START wiercenia montażowego
11:47 - KONIEC wiercenia (32 min)
12:00 - Kompletowanie (około 15 min)
12:20 - Pakowanie + paskowanie (około 20 min)
12:40 - GOTOWE DO WYSYŁKI

CZAS CAŁKOWITY: 4h 25min
CZAS OBRÓBKI: ~2h 26min
CZAS OCZEKIWANIA: ~1h 59min
```

### Śledzenie materiałów:
```
Material Movements:
1. MAG-PLY → PPL-001 (panele białe)
2. MAG-PLY → PPL-002 (siedzisko dąb)
3. MAG-PLY → PPL-003 (HDF)
4. PPL-001 → BUF-OKL (po cięciu)
5. PPL-002 → WC-WIE-M1 (wiercenie puszek)
6. PPL-002 → WC-TAP (tapicernia)
7. PPL-001 → BUF-WIE (po oklejaniu)
8. PPL-002 → BUF-WIE (po tapicerowaniu)
9. PPL-001, PPL-002 → BUF-KOM (po wierceniu)
10. PPL-003 → MAG-FOR → WOZ-A-007 (HDF do kompletowania)
11. WOZ-A-007 → ROLOTOK-1 → BUF-PAK
12. PKG-2025-001234-001 → EUR-025 → BUF-WYS
```

---

## Przykład 2: Szafka Prosta (Bez Tapicerki)

**Produkt:** Szafka wisząca 2-drzwiowa  
**SKU:** ALO-SZW-002  
**Komponenty BOM:**
- 2x Panel boczny (oklejany + wiercony)
- 1x Panel górny (oklejany + wiercony)
- 1x Panel dolny (oklejany + wiercony)
- 1x Półka (oklejana + wiercona)
- 2x Drzwi (oklejane + wiercone)
- 1x Plecy HDF (surowe)
- Akcesoria: zawiasy drzwi, wsporniki, wkręty

### Uproszczony przepływ:

```
┌─────────────────┐
│ 1. CIĘCIE       │ Piła Masterwood (30 min)
│ PPL-001: panele │
│ PPL-002: drzwi  │
│ PPL-003: HDF    │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 2. OKLEJANIE    │ Okleiniarka Masterwood (35 min)
│ PPL-001, PPL-002│ Wszystkie komponenty (oprócz HDF)
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 3. WIERCENIE    │ Wiertarka Master 2 (40 min)
│ Wszystkie       │ Otwory montażowe + zawiasy
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 4. KOMPLETOWANIE│ (15 min)
│ WOZ-B-003       │ + HDF z magazynu + akcesoria
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 5. PAKOWANIE    │ (20 min)
│ PKG-...-002     │ Karton 900x600x150mm
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 6. PASKOWANIE   │
│ EUR-026         │ → BUF-WYS
└─────────────────┘

CZAS CAŁKOWITY: ~3h 30min
```

**Różnice vs. szafka z siedziskiem:**
- ❌ Brak tapicerni (oszczędność ~1h 30min)
- ❌ Brak wiercenia puszek
- ✅ Prostszy routing: Cięcie → Oklejanie → Wiercenie → Kompletowanie → Pakowanie

---

## Przykład 3: Plecy HDF (Minimalna Obróbka)

**Produkt:** Plecy HDF do szafki  
**SKU:** ALO-HDF-001  
**Routing:** BEZPOŚREDNI (cięcie → magazyn)

### Przepływ express:

```
┌─────────────────┐
│ 1. CIĘCIE       │ Piła Masterwood (5 min)
│ PPL-003: HDF    │ Format 780x470mm
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 2. MAGAZYN FOR  │ Odkładanie bez obróbki
│ MAG-FOR         │ Gotowe do użycia w kompletowaniu
└─────────────────┘

CZAS: 5-10 min
```

**Charakterystyka:**
- Brak oklejania (surowe krawędzie)
- Brak wiercenia (montaż gwoździkami/zszywkami)
- Składowanie w magazynie formatek
- Pobierane podczas kompletowania produktu finalnego

---

## Przykład 4: Szafka Oczekująca (Bez Paskowania)

**Produkt:** Szafka z niestandardowym siedziskiem  
**SKU:** ALO-SZB-CUST-001  
**Scenariusz:** Oczekiwanie na potwierdzenie koloru tkaniny od klienta

### Przepływ z buforem pakowania:

```
┌─────────────────┐
│ 1-4. STANDARDOWO│ Cięcie → Oklejanie → Wiercenie → Tapicerowanie
└────────┬────────┘ (Siedzisko w kolorze tymczasowym)
         │
         ▼
┌─────────────────┐
│ 5. KOMPLETOWANIE│ Wszystkie komponenty + akcesoria
│ WOZ-A-012       │ OPRÓCZ siedziska tapicerowanego
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 6. PAKOWANIE    │ Częściowe
│ PKG-...-003     │ Kartony: panele + plecy + SPACE dla siedziska
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 7. BUFOR PAK    │ ❌ NIE PASKUJEMY!
│ BUF-PAK         │ Status: OCZEKIWANIE_NA_KLIENTA
│ Paleta EUR-027  │ Notatka: "Czeka na potwierdzenie koloru tkaniny"
└────────┬────────┘
         │
         │ (Po 3 dniach - decyzja klienta: szary)
         ▼
┌─────────────────┐
│ 8. TAPICERNIA   │ Siedzisko w kolorze szarym
│ WC-TAP          │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ 9. UZUPEŁNIENIE │ Dodanie siedziska do paczki
│ WC-PAK          │ SCAN: PKG-...-003 (update)
└────────┬────────┘ SCAN: Siedzisko szare
         │
         ▼
┌─────────────────┐
│ 10. PASKOWANIE  │ TERAZ dopiero paskujemy
│ Linia paskująca │ PKG-...-003 → EUR-027 → BUF-WYS
└─────────────────┘

CZAS OCZEKIWANIA: 3 dni (biznesowy)
CZAS UZUPEŁNIENIA: 30 min
```

---

## Przykład 5: Produkcja Seryjna (10 Szafek Identycznych)

**Produkt:** 10x Szafka ALO-SZB-001  
**Optymalizacja:** Batch processing

### Strategia batch:

```
CIĘCIE (Batch 10 szt):
├─ PPL-001, PPL-002, PPL-003: Panele białe (40 paneli)
├─ PPL-004, PPL-005: Siedziska dąb (10 szt)
└─ PPL-006, PPL-007: HDF plecy (10 szt)
Czas: 3h 30min (vs 10x 27min = 4h 30min pojedynczo)

OKLEJANIE (Batch):
├─ Wszystkie panele białe jednocześnie
└─ Zmiana taśmy tylko raz
Czas: 2h 15min (oszczędność 45min)

WIERCENIE PUSZEK (Batch):
├─ 10 siedzisk jeden program CNC
└─ Bez przerw na setup
Czas: 50min (vs 10x 7min = 1h 10min)

TAPICEROWANIE (Batch):
├─ Przygotowanie materiału raz
├─ 10 siedzisk po kolei
└─ Efektywność: +15%
Czas: 3h 20min (vs 10x 22min = 3h 40min)

KOMPLETOWANIE (Po kolei):
├─ 10 wózków przygotowanych
├─ Picking list x10
└─ Równoległa praca 2 operatorów
Czas: 2h (vs 10x 15min = 2h 30min)

PAKOWANIE (Batch):
├─ 10 kartonów przygotowanych
├─ Linia pakująca
└─ 2 operatorów
Czas: 2h 30min (vs 10x 20min = 3h 20min)

PASKOWANIE (Ciągła linia):
└─ 10 paczek na 2 palety EUR
Czas: 25min

────────────────────────────────
CZAS CAŁKOWITY BATCH: ~14h 30min
CZAS POJEDYNCZO: 10x 4h 25min = 44h 15min

OSZCZĘDNOŚĆ: 29h 45min (67% efektywniejsze!)
```

---

## Wnioski i Best Practices

### 1. Identyfikacja Typu Formatki
```sql
-- W systemie podczas cięcia:
IF component_name LIKE '%SIEDZISKO%' THEN
  format_type = 'SIEDZISKO'
  routing = 'drill_holes → upholster → drill_mount → pick'
ELSE IF component_name LIKE '%PANEL%' THEN
  format_type = 'PANEL'
  routing = 'edge → drill → pick'
ELSE IF component_name LIKE '%HDF%' THEN
  format_type = 'BACK'
  routing = 'warehouse'
END IF
```

### 2. Decyzja o Paskowanie
```javascript
function shouldStrap(packingOrder) {
  // Sprawdź czy zlecenie kompletne
  const allComponentsReady = checkBomCompletion(packingOrder.productionOrderId);
  
  // Sprawdź czy są oczekiwania
  const hasClientPending = checkClientConfirmation(packingOrder.productionOrderId);
  
  if (allComponentsReady && !hasClientPending) {
    return 'STRAP_AND_SHIP';  // → Paskowanie → BUF-WYS
  } else {
    return 'BUFFER_ONLY';     // → BUF-PAK (bez paskowania)
  }
}
```

### 3. Rejestracja QR Flow
```
Pakowanie:
  SCAN QR_PACKAGE → status: PACKED
  
Transport (linia):
  Automatyczny tracking → status: IN_TRANSIT_TO_STRAPPING
  
Paskowanie:
  SCAN QR_PALLET → register pallet
  SCAN QR_PACKAGE → link package to pallet
  → status: STRAPPED_ON_PALLET
  
Odkładanie:
  SCAN QR_PALLET → confirm location
  → location: BUF-WYS
  → status: READY_TO_SHIP
```

---

**Dokument utworzony:** 2025-11-09  
**Wersja:** 1.0  
**Następne kroki:** Implementacja tabel i ekranów według mapy drogowej
