# Production Planning - UI/UX Design Decisions

## Overview
Dokumentacja wszystkich decyzji UI/UX dla systemu Production Planning w Alpma OMS.

## Dual-Panel Layout

### Layout Structure
- **Left Panel**: Dostępne Zamówienia (Orders Panel)
- **Right Panel**: Linie Produkcji (Plan Lines Panel)
- **Responsive**: CSS Grid layout z elastycznymi proporcjami

## Orders Panel - Design History

### Version 1.0 - Initial Implementation
**Date**: November 2025
**Changes**:
- Dual-panel responsive layout
- Collapsible order cards
- Product details with metadata
- Drag-and-drop functionality

### Version 2.0 - Corpo ERP Redesign
**Date**: November 11, 2025
**Changes**:
1. **Header Redesign**
   - Inline counters: "Zamówienia: X | Produkty: Y"
   - Compact, professional styling

2. **30px Controls Bar**
   - Merged visually with table (bg-muted/30)
   - Płaski/Grupowy toggle + Sortuj + Pokaż ilość

3. **Sharp Borders**
   - Changed from rounded-md to rounded-none
   - `border border-border` around order families

4. **Spacing & Two-Tone Backgrounds**
   - `space-y-4` between orders/groups
   - Families: lighter `bg-muted/40`
   - Gaps: darker background

5. **Order Number Highlighting**
   - `text-primary` + `font-semibold`
   - Quick visual scanning

6. **Grouped View Spacing**
   - First type group: `mt-2`
   - Other types: `border-t` (attached)

7. **Batch Selection System**
   - Checkboxes for multi-select
   - Bulk add toolbar with count
   - Toast notifications

### Version 3.0 - Tabular Layout (In Progress)
**Date**: November 11, 2025
**Critical Issues Identified**:
- Chaotic layout - images floating
- Name/surname not vertically aligned
- Inconsistent field presentation
- Too much spacing between rows
- Borders overlapping chaotically

**New Requirements**:

#### Field Order (Standardized)
All views must show fields in this exact order:
1. **Image** - 40x40px (grouped view)
2. **Order Number** (grouped view only, after image)
3. **Product Type** (Rodzaj)
4. **Length** (Długość)
5. **Width** (Szerokość)
6. **Color** (Kolor)
7. **Doors** (Drzwi)
8. **Legs** (Nogi)

#### Presentation Rules
- **Dictionary Colors**: Parameters displayed as colored badges using dictionary color values
- **No Dictionary**: Black background for parameters without dictionary colors
- **No Duplication**: Don't show order number in child rows when grouping by order (parent already shows it)
- **Consistent Alignment**: All fields vertically aligned in columns
- **Compact Spacing**: Minimal margins between rows for dense, professional look

#### Image Guidelines
- **Grouped View**: 40x40px images
- **Position**: Always first column
- **Fallback**: Placeholder icon if no image

#### Layout Strategy (TBD)
Options being evaluated:
1. HTML `<table>` for native tabular alignment
2. CSS Grid with defined columns
3. Enhanced flex layout with fixed widths

## Visual Design Tokens

### Colors
- **Order Numbers**: `text-primary` for highlighting
- **Backgrounds**: 
  - Order families: `bg-muted/40`
  - Gaps between: default background
- **Borders**: `border-border` with `rounded-none`

### Spacing
- **Between Groups**: `space-y-4` or equivalent margin
- **Controls Bar Height**: 30px
- **Row Heights**: 
  - Parent: 50px
  - Child: 40px
- **Indentation**: `pl-6` for child rows

### Typography
- **Order Numbers**: `font-semibold text-primary`
- **Metadata**: `text-xs` or `text-[10px]`
- **Status Badges**: `text-[9px]` - `text-[10px]`

## Interaction Patterns

### Drag and Drop
- Only mapped products are draggable
- Visual feedback: `opacity-50` while dragging
- Cursor states: `cursor-grab` → `cursor-grabbing`

### Batch Selection
- Checkbox on each product row
- Toolbar appears when items selected
- Shows count: "Zaznaczono: X"
- Actions: Clear, Bulk Add to Plan

### Expand/Collapse
- Orders/groups collapsible
- Icons: ChevronRight (collapsed) / ChevronDown (expanded)
- Auto-expand all on mount (configurable)

## Accessibility

### Test IDs
- All interactive elements have `data-testid`
- Pattern: `{action}-{target}-{id}`
- Examples:
  - `checkbox-select-${item.item_id}`
  - `product-row-${item.item_id}`
  - `button-bulk-add`

### Keyboard Navigation
- Tab order follows visual layout
- Checkboxes keyboard accessible
- Drag handles keyboard compatible (via DnD Kit)

## Performance Considerations

### Virtualization
- Future: Consider virtual scrolling for 1000+ products
- Current: Pagination with configurable page size

### State Management
- Local state for UI (expand/collapse, selection)
- TanStack Query for server data
- localStorage for user preferences (tabs, filters)

## Future Enhancements

### Planned Features
1. **Column Customization**: User-selectable visible columns
2. **Save Views**: Persist custom view configurations
3. **Bulk Remove**: Delete selected items from plan
4. **Export**: CSV/Excel export of filtered orders
5. **Advanced Filters**: Date ranges, price ranges, custom queries

### Under Consideration
1. **Inline Editing**: Quick edit product quantities
2. **Quick Actions Menu**: Right-click context menu
3. **Keyboard Shortcuts**: Power user shortcuts (e.g., Ctrl+A select all)
4. **Mobile Optimization**: Touch-friendly controls, swipe actions

---

## 📋 Changelog - Lista Zadań UI/UX

### ✅ Zadania Zrealizowane

- <span style="color: #22c55e; text-decoration: line-through;">✅ **Sticky Right Panel** (2025-11-11 17:28) - Prawa lista z dodanymi produktami pozostaje widoczna podczas scrollowania lewej listy</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Usuń Rounded Corners** (2025-11-11 17:28) - Wszystkie elementy mają ostre krawędzie (sharp corners) zgodnie z corpo ERP design</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Połącz Wizualnie Search + Tabela** (2025-11-11 17:28) - Wyszukiwarka i tabela wizualnie scalone bez przerw</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Padding dla Aktywnych Filtrów** (2025-11-11 17:28) - Panel z aktywnymi filtrami ma odpowiedni padding 16px</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Flat View - Prawdziwa Lista Płaska** (2025-11-11 17:22) - Widok płaski renderuje rzeczywistą płaską listę produktów bez grupowania</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Separator Między Produktami** (2025-11-11 17:30) - Odstęp 4px (space-y-1) między produktami w widoku grupowanym</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Fix Wymiarów "0"** (2025-11-11 17:30) - Zamiast "0" pokazuje się "-" dla brakujących wymiarów</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Fix Kolizji Badge D1** (2025-11-11 17:30) - Dodano min-w-0 + truncate do kolumn Color/Doors/Legs aby zapobiec nakładaniu się</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Padding Badge** (2025-11-11 17:30) - Zmieniono spacing metadanych z gap-1 na gap-2 (8px)</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Filtrowanie Order/Buyer** (2025-11-11 17:45) - Dual state synchronization: filtrowanie po nazwie kupującego, numerze zamówienia, emailu, SKU</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Order Background Grouping** (2025-11-11 18:02) - Deterministyczne alternujące tła (bg-background vs bg-muted/40) dla produktów z tego samego zamówienia w obu widokach</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Inline Counters w Nagłówku** (2025-11-11 17:28) - "Dostępne Zamówienia" + "Zamówienia: 100 | Produkty: 115" w jednej linii</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **30px Bar Nad Tabelą** (2025-11-11 18:14) - Pasek z kontrolkami (Płaski/Grupowy, Rozwiń, Sortuj, Pokaż) bezpośrednio nad tabelą pod wyszukiwarką</span>
- <span style="color: #22c55e; text-decoration: line-through;">✅ **Połączony Wizualnie z Tabelą** (2025-11-11 18:14) - Bar kontrolek i tabela połączone tłem i ramką jako jedna całość</span>

### 🚧 Zadania W Trakcie

- 🔄 **localStorage Persistence** - Zapamietywanie stanu: rozwinięte listy, tryb (płaski/grupowy), pozycja scrollowania

### 📋 Zadania Do Zrobienia

#### Drag & Drop System
- [ ] **Drag & Drop do Prawego Panelu** - Przenoszenie produktów z lewej listy do prawego okna z wybranymi produktami działające
- [ ] **Loader Podczas Dodawania** - Wizualna informacja zwrotna (spinner/loader) podczas dodawania produktu do planu
- [ ] **Highlight Dodanych Produktów** - Inny kolor wiersza (zielony flash) dla produktów dodanych do planu - widoczny natychmiast
- [ ] **Całkowity Wiersz Draggable** - Możliwość chwytania i przeciągania całego wiersza produktu (nie tylko części)
- [ ] **Ikonka Łapki** - Pojawienie się ikony "hand/grab" podczas hover nad wierszem produktu
- [ ] **Visual Feedback Drag** - Podczas przeciągania widoczny jest przeciągany wiersz + podświetlenie całego docelowego panelu
- [ ] **Blokada Drag w Obrębie Listy** - Drag & drop działa tylko między panelami (lewy→prawy), nie w obrębie jednej listy
- [ ] **Wiersz Nie Przesuwa Się** - Przy drag & drop wiersz pozostaje na miejscu w źródłowej liście, widać tylko "ghost" podczas przeciągania

#### Hierarchia i Layout  
- [ ] **Wcięcie Dla Dzieci** - Margines/wcięcie od lewej dla produktów w zamówieniu aby pokazać hierarchię rodzic-dziecko
- [ ] **Jednolite Tło Rodziny** - Rodzic (zamówienie) i dzieci (produkty) mają to samo tło
- [ ] **Wysokość Rodzica 50px** - Wiersz zamówienia (rodzica) ma wysokość 50px
- [ ] **Wysokość Dziecka 40px** - Wiersz produktu (dziecka) ma wysokość 40px (obecnie 30px)
- [ ] **Margines Między Zamówieniami** - Wyraźne odstępy/marginesy między różnymi zamówieniami/grupami dla wizualnej separacji
- [ ] **Dwutonowe Tła** - Jasniejsze tło dla rodziny zamówienia, ciemniejsze dla przerw/odstępów między zamówieniami
- [ ] **Ramka Wokół Rodziny** - Zamówienie z produktami otoczone wspólną ramką (border) dla wizualnego grupowania
- [ ] **Bez Rounded Corners na Ramkach** - Wszystkie ramki z ostrymi krawędziami (rounded-none)

#### Układ Tabelaryczny
- [ ] **Wyrównanie Pionowe** - Wszystkie elementy w wierszu (zdjęcie, imię, nazwisko, parametry) wyrównane w jednej linii
- [ ] **Kolejność Kolumn** - Zdjęcie → Rodzaj → Długość → Szerokość → Kolor → Drzwi → Nogi (standardowa kolejność dla wszystkich widoków)
- [ ] **Kafelki Parametrów** - Parametry wyświetlane w kafelkach/badge z kolorami pobranymi ze słowników
- [ ] **Czarne Kafelki dla Brakujących** - Parametry bez wartości w słownikach pokazane jako czarne kafelki/badge

#### Funkcjonalność
- [ ] **Domyślnie Rozwinięta Lista** - Lista zamówień domyślnie w stanie rozwiniętym przy pierwszym załadowaniu
- [ ] **Zapamietywanie Stanu Rozwinięć** - localStorage persistence dla rozwiniętych/zwiniętych zamówień i grup
- [ ] **Zapamietywanie Trybu Widoku** - localStorage persistence dla trybu Płaski/Grupowy
- [ ] **Zapamietywanie Pozycji Scroll** - localStorage persistence dla pozycji przewijania w obu panelach
- [ ] **Filtrowanie po Nazwach Produktów** - Filtrowanie zamówień po nazwach produktów i wartościach z filtrów
- [ ] **Brak Resetowania Po Dodaniu** - Zapobieganie resetowaniu ustawień (rozwinięcia, tryb, filtry) po dodaniu produktu do planu

#### Prawa Lista (Dodane Produkty)
- [ ] **Widoczność Prawej Listy** - Upewnienie się że lista dodanych produktów do planu jest zawsze widoczna po prawej stronie
- [ ] **Sticky Top podczas Scroll** - Górna część prawej listy pozostaje przyklejona na górze podczas scrollowania lewej listy

## Revision History

| Version | Date | Author | Changes |
|---------|------|--------|---------|
| 3.1 | 2025-11-11 18:14 | System | Controls bar repositioning + Task checklist |
| 3.0 | 2025-11-11 | System | Tabular layout redesign planning |
| 2.0 | 2025-11-11 | System | Corpo ERP redesign implementation |
| 1.0 | 2025-11 | System | Initial dual-panel system |
