// Helper functions for handling both old (string) and new (object) image formats

export type ImageEntry = string | {
  url: string;
  thumbnailUrl?: string;
  mediumUrl?: string;
};

export type ColorImagesRecord = Record<string, ImageEntry[]>;

export function getImageUrl(image: ImageEntry): string {
  return typeof image === 'string' ? image : image.url;
}

export function getImageThumbnail(image: ImageEntry): string {
  return typeof image === 'string' ? image : (image.thumbnailUrl || image.url);
}

export function getImageMedium(image: ImageEntry): string {
  return typeof image === 'string' ? image : (image.mediumUrl || image.url);
}

export function normalizeImageEntry(image: ImageEntry): { url: string; thumbnailUrl: string; mediumUrl: string } {
  if (typeof image === 'string') {
    return { url: image, thumbnailUrl: image, mediumUrl: image };
  }
  return {
    url: image.url,
    thumbnailUrl: image.thumbnailUrl || image.url,
    mediumUrl: image.mediumUrl || image.url
  };
}
