import logging

from odoo import SUPERUSER_ID, api
from odoo.addons.trilab_allegro import post_init_hook

_logger = logging.getLogger(__name__)


def migrate(cr, version):
    """Add/update payment - Allegro"""

    _logger.info(f'post migration start (from {version})')
    env = api.Environment(cr, SUPERUSER_ID, {})

    if provider_ids := env['payment.provider'].search(
        ['&', ('name', 'like', 'Allegro'), '|', ('code', '=', 'none'), ('module_id', '=', False)]
    ):
        _logger.info('update payment provider data')
        provider_ids.write({'code': 'allegro', 'module_id': env.ref('base.module_trilab_allegro').id})

    if not env['account.payment.method'].search_count([('code', '=', 'allegro')]):
        _logger.info('add account payment method')
        post_init_hook(env)

    _logger.info('post migration finished')
