import { pool } from './postgres.js';
import axios from 'axios';
import { saveOrderToCommerce } from './postgres.js';

async function restoreOrder() {
  try {
    console.log('🔄 Przywracanie zamówienia #00676...\n');

    const tokenResult = await pool.query(`
      SELECT access_token FROM allegro_connections WHERE is_active = true LIMIT 1
    `);
    const accessToken = tokenResult.rows[0]?.access_token;

    if (!accessToken) {
      console.error('❌ Brak access token');
      return;
    }

    const orderId = 'ee8f0010-b1c8-11f0-831f-cf35cc48a3c0';

    console.log(`📡 Pobieranie zamówienia ${orderId} z Allegro API...`);
    
    const response = await axios.get(
      `https://api.allegro.pl/order/checkout-forms/${orderId}`,
      {
        headers: {
          Authorization: `Bearer ${accessToken}`,
          Accept: 'application/vnd.allegro.public.v1+json',
        }
      }
    );

    const orderData = response.data;
    
    console.log(`✅ Pobrano dane zamówienia`);
    console.log(`   Produkty: ${orderData.lineItems?.length || 0}`);
    console.log(`   Kwota: ${orderData.summary?.totalToPay?.amount} ${orderData.summary?.totalToPay?.currency}`);

    await saveOrderToCommerce('ALLEGRO', orderId, orderData, [], [], accessToken);
    
    console.log('\n✅ Zamówienie zostało przywrócone');

  } catch (error: any) {
    console.error('❌ Błąd:', error.message);
  } finally {
    await pool.end();
  }
}

restoreOrder();
