interface ComponentTemplateThumbnailProps {
  baseLength: number;
  baseWidth: number;
  edge1?: boolean;
  edge2?: boolean;
  edge3?: boolean;
  edge4?: boolean;
  size?: 'xs' | 'sm' | 'md' | 'lg';
}

export function ComponentTemplateThumbnail({
  baseLength,
  baseWidth,
  edge1 = false,
  edge2 = false,
  edge3 = false,
  edge4 = false,
  size = 'md'
}: ComponentTemplateThumbnailProps) {
  const sizes = {
    xs: { width: 40, height: 40, padding: 6 },
    sm: { width: 60, height: 60, padding: 8 },
    md: { width: 80, height: 80, padding: 10 },
    lg: { width: 120, height: 120, padding: 15 }
  };

  const { width: svgWidth, height: svgHeight, padding } = sizes[size];
  const aspectRatio = baseLength / baseWidth;
  
  let rectWidth: number, rectHeight: number;
  
  if (aspectRatio > 1) {
    rectWidth = svgWidth - padding * 2;
    rectHeight = rectWidth / aspectRatio;
  } else {
    rectHeight = svgHeight - padding * 2;
    rectWidth = rectHeight * aspectRatio;
  }

  const rectX = (svgWidth - rectWidth) / 2;
  const rectY = (svgHeight - rectHeight) / 2;

  const edgeOffset = 2;
  const edges = [
    { active: edge1, x1: rectX, y1: rectY - edgeOffset, x2: rectX + rectWidth, y2: rectY - edgeOffset },
    { active: edge2, x1: rectX + rectWidth + edgeOffset, y1: rectY, x2: rectX + rectWidth + edgeOffset, y2: rectY + rectHeight },
    { active: edge3, x1: rectX, y1: rectY + rectHeight + edgeOffset, x2: rectX + rectWidth, y2: rectY + rectHeight + edgeOffset },
    { active: edge4, x1: rectX - edgeOffset, y1: rectY, x2: rectX - edgeOffset, y2: rectY + rectHeight },
  ];

  return (
    <svg
      width={svgWidth}
      height={svgHeight}
      viewBox={`0 0 ${svgWidth} ${svgHeight}`}
      className="flex-shrink-0"
    >
      <rect
        x={rectX}
        y={rectY}
        width={rectWidth}
        height={rectHeight}
        fill="hsl(var(--muted))"
        stroke="hsl(var(--border))"
        strokeWidth="1.5"
      />
      
      {edges.map((edge, index) => {
        if (!edge.active) return null;
        return (
          <line
            key={index}
            x1={edge.x1}
            y1={edge.y1}
            x2={edge.x2}
            y2={edge.y2}
            stroke="hsl(var(--primary))"
            strokeWidth="1.5"
          />
        );
      })}
    </svg>
  );
}
