import { FeesSubmenu } from "@/components/fees-submenu";

interface FeesLayoutProps {
  children: React.ReactNode;
}

export default function FeesLayout({ children }: FeesLayoutProps) {
  return (
    <div className="flex h-full w-full overflow-hidden">
      {/* Left submenu */}
      <div className="w-64 border-r bg-card flex-shrink-0 overflow-y-auto">
        <FeesSubmenu />
      </div>

      {/* Main content area */}
      <div className="flex-1 overflow-auto bg-background">
        {children}
      </div>
    </div>
  );
}
