import { Package, DollarSign, CheckCircle, Clock } from "lucide-react";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";

interface MetricsCardsProps {
  totalOrders: number;
  paidOrders: number;
  unpaidOrders: number;
  totalRevenue: string;
  isLoading?: boolean;
}

export function MetricsCards({
  totalOrders,
  paidOrders,
  unpaidOrders,
  totalRevenue,
  isLoading = false,
}: MetricsCardsProps) {
  const metrics = [
    {
      title: "Wszystkie zamówienia",
      value: totalOrders.toString(),
      icon: Package,
      testId: "metric-total-orders",
    },
    {
      title: "Opłacone",
      value: paidOrders.toString(),
      icon: CheckCircle,
      testId: "metric-paid-orders",
    },
    {
      title: "Nieopłacone",
      value: unpaidOrders.toString(),
      icon: Clock,
      testId: "metric-unpaid-orders",
    },
    {
      title: "Przychód całkowity",
      value: `${totalRevenue} PLN`,
      icon: DollarSign,
      testId: "metric-total-revenue",
    },
  ];

  if (isLoading) {
    return (
      <div className="grid gap-4 grid-cols-1 sm:grid-cols-2 md:grid-cols-4">
        {[1, 2, 3, 4].map((i) => (
          <Card key={i} className="min-w-0">
            <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2 gap-2">
              <CardTitle className="text-sm font-medium">
                <div className="h-4 w-32 bg-muted rounded animate-pulse" />
              </CardTitle>
              <div className="h-4 w-4 bg-muted rounded animate-pulse" />
            </CardHeader>
            <CardContent>
              <div className="h-8 w-24 bg-muted rounded animate-pulse" />
            </CardContent>
          </Card>
        ))}
      </div>
    );
  }

  return (
    <div className="grid gap-2 grid-cols-1 sm:grid-cols-2 md:grid-cols-4">
      {metrics.map((metric) => (
        <Card key={metric.title} className="bg-card/50 min-w-0">
          <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-1 pt-2 px-3">
            <CardTitle className="text-[10px] font-medium text-muted-foreground uppercase tracking-wide">
              {metric.title}
            </CardTitle>
            <metric.icon className="h-3 w-3 text-muted-foreground/70" />
          </CardHeader>
          <CardContent className="pb-2 px-3">
            <div
              className="text-base font-semibold tabular-nums"
              data-testid={metric.testId}
            >
              {metric.value}
            </div>
          </CardContent>
        </Card>
      ))}
    </div>
  );
}
