from odoo import models


class SaleOrder(models.Model):
    _inherit = 'sale.order'

    def x_allegro_action_preview_auction(self):
        self.ensure_one()

        if self.x_market_account_id and self.x_market_account_id.is_allegro() and self.client_order_ref:
            allegro_client = self.x_market_account_id.get_client()

            return {
                'type': 'ir.actions.act_url',
                'target': 'new',
                'url': allegro_client.get_auction_edit_url('orders', self.client_order_ref),
            }

        return None
