import logging

from odoo import SUPERUSER_ID, api
from odoo.addons.trilab_allegro.models.allegro_client import AllegroPayment

_logger = logging.getLogger(__name__)

VERSION = '18.0.2.0.0'
MODULE = 'trilab_allegro'
ALLEGRO = 'allegro'


def migrate(cr, version):
    _logger.info(f'end migration {VERSION} start (from {version})')

    env = api.Environment(cr, SUPERUSER_ID, {})

    for mapping_id in env['trilab.market.payment_terms'].search([('account_id.market', '=', ALLEGRO)]):
        mapping_id.payment_method_id = env.ref(f'trilab_allegro.payment_method_{mapping_id.allegro_code.lower()}').id
        mapping_id.payment_provider_id = env['payment.provider'].search(
            [('code', '=', ALLEGRO), ('company_id', '=', mapping_id.company_id.id)], limit=1
        )
        mapping_id.is_cod = mapping_id.allegro_code == AllegroPayment.CASH_ON_DELIVERY

    _logger.info(f'end migration {VERSION} finished')
