import logging

from odoo.upgrade import util

_logger = logging.getLogger(__name__)

VERSION = '18.0.1.0.2'
MODULE = 'trilab_allegro'


def migrate(cr, version):
    _logger.info(f'pre migration {VERSION} start (from {version})')

    if util.column_exists(cr, 'res_partner', 'x_allegro_id'):
        # migrate data
        cr.execute(
            """UPDATE res_partner
               SET ref          = 'allegro/' || COALESCE(x_allegro_id, ''),
                   x_allegro_id = NULL
               WHERE ref = 'allegro'
                 AND x_allegro_id IS NOT NULL"""
        )
        # update child addresses
        cr.execute(
            """UPDATE res_partner AS a
               SET ref = b.ref
               FROM res_partner b
               WHERE a.parent_id IS NOT NULL
                 AND (a.ref = 'allegro' OR a.ref IS NULL) 
                 AND a.parent_id = b.id
                 AND b.ref ~ '^allegro/'"""
        )

        # update remaining addresses w/o x_allegro_id
        cr.execute("UPDATE res_partner SET ref = 'allegro/' WHERE ref = 'allegro'")

    _logger.info(f'pre migration {VERSION} finished')
