import logging

from odoo.upgrade import util

_logger = logging.getLogger(__name__)

VERSION = '17.0.10.0.0'
MODULE = 'trilab_allegro'
REMOVE_PARAMETERS = (
    'trilab_allegro_client_id_prod',
    'trilab_allegro_client_secret_prod',
    'trilab_allegro_client_id_sandbox',
    'trilab_allegro_client_secret_sandbox',
)
RENAME_PARAMETERS = (
    ('payment_method_allegro_cash_on_delivery', 'payment_method_cash_on_delivery'),
    ('payment_method_allegro_wire_transfer', 'payment_method_wire_transfer'),
    ('payment_method_allegro_online', 'payment_method_online'),
    ('payment_method_allegro_split_payment', 'payment_method_split_payment'),
    ('payment_method_allegro_extended_term', 'payment_method_extended_term'),
)


# noinspection SqlWithoutWhere
def migrate(cr, version):
    _logger.info(f'pre migration {VERSION} start (from {version})')

    # remove parameters
    cr.execute(
        """DELETE FROM ir_config_parameter 
    WHERE id IN 
    (SELECT res_id FROM ir_model_data WHERE module = %s AND model = 'ir.config_parameter' AND name IN %s)""",
        (MODULE, REMOVE_PARAMETERS),
    )

    cr.execute(
        """DELETE FROM ir_model_data WHERE module = %s AND model = 'ir.config_parameter' AND name IN %s""",
        (MODULE, REMOVE_PARAMETERS),
    )

    # rename parameters
    for old, new in RENAME_PARAMETERS:
        _logger.info(f"rename_xmlid '{MODULE}.{old}' -> '{MODULE}.{new}'")
        util.rename_xmlid(cr, f'{MODULE}.{old}', f'{MODULE}.{new}', on_collision='merge')

    _logger.info(f'pre migration {VERSION} finished')
