-- ========================================
-- KROK 2: TRIGGERY
-- ========================================
-- UWAGA: Uruchom ten plik DOPIERO PO wykonaniu production-step1-tables.sql

-- Trigger set_order_number USUNIĘTY - id jest teraz SERIAL (autoincrement)

-- Trigger: Allegro -> Commerce (z podziałem imienia i nazwiska)
CREATE OR REPLACE FUNCTION public.sync_allegro_to_commerce()
RETURNS TRIGGER AS $$
DECLARE
    v_first_name VARCHAR;
    v_last_name VARCHAR;
    name_parts TEXT[];
BEGIN
    -- Rozdziel imię i nazwisko
    IF NEW.buyer_name IS NOT NULL THEN
        name_parts := string_to_array(TRIM(NEW.buyer_name), ' ');
        v_first_name := name_parts[1];
        IF array_length(name_parts, 1) > 1 THEN
            v_last_name := array_to_string(name_parts[2:array_length(name_parts, 1)], ' ');
        END IF;
    END IF;
    
    -- Sync do commerce.orders
    INSERT INTO commerce.orders (
        source, source_order_id, order_date, status,
        buyer_login, buyer_email, buyer_company, buyer_first_name, buyer_last_name,
        buyer_phone, buyer_address, buyer_zip, buyer_city, buyer_country_code,
        payment_id, payment_status, payment_type, payment_provider,
        payment_amount, payment_currency,
        delivery_method, delivery_amount, delivery_currency,
        total_to_pay_amount, total_to_pay_currency,
        buyer_notes, invoice_required, tracking_numbers, raw_payload
    ) VALUES (
        'ALLEGRO', NEW.order_id, NEW.order_date, NEW.seller_status,
        NEW.buyer_login, NEW.buyer_email, NEW.buyer_company, v_first_name, v_last_name,
        NEW.buyer_phone, NEW.buyer_address, NEW.buyer_zip, NEW.buyer_city, NEW.buyer_country_code,
        NEW.payment_id, NEW.payment_status, NEW.payment_type, NEW.payment_provider,
        NEW.payment_amount, NEW.payment_currency,
        NEW.delivery_method, NEW.delivery_amount, NEW.delivery_currency,
        NEW.total_to_pay_amount, NEW.total_to_pay_currency,
        NEW.buyer_notes, NEW.invoice_required, NEW.tracking_numbers,
        jsonb_build_object('order_id', NEW.order_id, 'marketplace', NEW.marketplace, 'smart', NEW.smart, 'allegro_pay', NEW.allegro_pay)
    )
    ON CONFLICT (source_order_id, source) DO UPDATE SET
        order_date = EXCLUDED.order_date, status = EXCLUDED.status,
        buyer_login = EXCLUDED.buyer_login, buyer_email = EXCLUDED.buyer_email,
        buyer_company = EXCLUDED.buyer_company, buyer_first_name = EXCLUDED.buyer_first_name, buyer_last_name = EXCLUDED.buyer_last_name,
        buyer_phone = EXCLUDED.buyer_phone, buyer_address = EXCLUDED.buyer_address,
        buyer_zip = EXCLUDED.buyer_zip, buyer_city = EXCLUDED.buyer_city, buyer_country_code = EXCLUDED.buyer_country_code,
        payment_id = EXCLUDED.payment_id, payment_status = EXCLUDED.payment_status,
        payment_type = EXCLUDED.payment_type, payment_provider = EXCLUDED.payment_provider,
        payment_amount = EXCLUDED.payment_amount, payment_currency = EXCLUDED.payment_currency,
        delivery_method = EXCLUDED.delivery_method, delivery_amount = EXCLUDED.delivery_amount, delivery_currency = EXCLUDED.delivery_currency,
        total_to_pay_amount = EXCLUDED.total_to_pay_amount, total_to_pay_currency = EXCLUDED.total_to_pay_currency,
        buyer_notes = EXCLUDED.buyer_notes, invoice_required = EXCLUDED.invoice_required,
        tracking_numbers = EXCLUDED.tracking_numbers, updated_at = NOW();
    
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS allegro_to_commerce_trigger ON allegro.orders;
CREATE TRIGGER allegro_to_commerce_trigger
AFTER INSERT OR UPDATE ON allegro.orders
FOR EACH ROW
EXECUTE FUNCTION public.sync_allegro_to_commerce();

-- Trigger: Shoper -> Commerce
CREATE OR REPLACE FUNCTION public.sync_shoper_to_commerce()
RETURNS TRIGGER AS $$
DECLARE
    v_raw jsonb;
    v_billing_address jsonb;
    v_delivery_address jsonb;
    v_first_name VARCHAR;
    v_last_name VARCHAR;
    v_phone VARCHAR;
    v_company VARCHAR;
    v_street VARCHAR;
    v_zip VARCHAR;
    v_city VARCHAR;
    v_country_code VARCHAR;
    v_delivery_cost NUMERIC;
BEGIN
    v_raw := NEW.raw_data;
    
    -- Dane z billing_address
    IF v_raw->>'billing_address' IS NOT NULL THEN
        v_billing_address := (v_raw->>'billing_address')::jsonb;
        v_first_name := v_billing_address->>'firstname';
        v_last_name := v_billing_address->>'lastname';
        v_phone := v_billing_address->>'phone';
        v_company := v_billing_address->>'company';
    END IF;
    
    -- Dane z delivery_address
    IF v_raw->>'delivery_address' IS NOT NULL THEN
        v_delivery_address := (v_raw->>'delivery_address')::jsonb;
        v_street := v_delivery_address->>'street1';
        v_zip := v_delivery_address->>'postcode';
        v_city := v_delivery_address->>'city';
        v_country_code := v_delivery_address->>'country_code';
    END IF;
    
    v_delivery_cost := (v_raw->>'shipping_cost')::numeric;
    
    -- Sync do commerce.orders
    INSERT INTO commerce.orders (
        source, source_order_id, order_date, status,
        buyer_login, buyer_email, buyer_company, buyer_first_name, buyer_last_name,
        buyer_phone, buyer_address, buyer_zip, buyer_city, buyer_country_code,
        payment_status, payment_type, payment_amount, payment_currency,
        delivery_amount, delivery_currency, total_to_pay_amount, total_to_pay_currency,
        buyer_notes, invoice_required, raw_payload
    ) VALUES (
        'SHOPER', NEW.shoper_order_id, NEW.order_date, NEW.fulfillment_status,
        NEW.buyer_login, NEW.buyer_email, v_company, v_first_name, v_last_name,
        v_phone, v_street, v_zip, v_city, v_country_code,
        NEW.payment_status,
        CASE WHEN (v_raw->>'payment_id')::int = 2 THEN 'ONLINE' ELSE 'CASH_ON_DELIVERY' END,
        NEW.total_amount, NEW.currency,
        v_delivery_cost, NEW.currency, NEW.total_amount, NEW.currency,
        v_raw->>'notes', false, v_raw
    )
    ON CONFLICT (source_order_id, source) DO UPDATE SET
        order_date = EXCLUDED.order_date, status = EXCLUDED.status,
        buyer_login = EXCLUDED.buyer_login, buyer_email = EXCLUDED.buyer_email,
        buyer_company = EXCLUDED.buyer_company, buyer_first_name = EXCLUDED.buyer_first_name, buyer_last_name = EXCLUDED.buyer_last_name,
        buyer_phone = EXCLUDED.buyer_phone, buyer_address = EXCLUDED.buyer_address,
        buyer_zip = EXCLUDED.buyer_zip, buyer_city = EXCLUDED.buyer_city, buyer_country_code = EXCLUDED.buyer_country_code,
        payment_status = EXCLUDED.payment_status, payment_type = EXCLUDED.payment_type,
        payment_amount = EXCLUDED.payment_amount, delivery_amount = EXCLUDED.delivery_amount,
        total_to_pay_amount = EXCLUDED.total_to_pay_amount,
        buyer_notes = EXCLUDED.buyer_notes, raw_payload = EXCLUDED.raw_payload,
        updated_at = NOW();
    
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS shoper_to_commerce_trigger ON shoper.orders;
CREATE TRIGGER shoper_to_commerce_trigger
AFTER INSERT OR UPDATE ON shoper.orders
FOR EACH ROW
EXECUTE FUNCTION public.sync_shoper_to_commerce();

-- ✅ WSZYSTKO GOTOWE!
