# Alpma OMS - Zarządzanie Zamówieniami

## Overview
Alpma OMS (Order Management System) is a professional web application for managing orders from Allegro and Shoper platforms. It automates order fetching, payment verification, and data synchronization. The project aims to provide a unified e-commerce order management platform, capable of integrating with other business systems like Odoo, to enhance operational efficiency and scalability for businesses operating on multiple platforms. Key capabilities include comprehensive order management, real-time synchronization, a secure API, robust user authentication, and detailed statistics.

## User Preferences
- Język: Polski (wszystkie UI teksty)
- Motyw domyślny: Dark mode
- OAuth flow: Przekierowanie na stronę Allegro (jak w module Odoo)
- Częstotliwość synchronizacji: Co kilka minut (konfigurowalne: 1, 3, 5, 10 min)

## System Architecture

### UI/UX Decisions
- **Frontend Framework**: React 18 with Vite, Shadcn UI (Radix UI, Tailwind CSS).
- **Theming**: Dark/Light mode support.
- **Navigation**: Wouter for client-side routing.
- **Data Display**: Dashboard with key metrics and a detailed, sortable orders table.
- **Mobile Responsiveness**: Full mobile support with adaptive layouts.

### Technical Implementations
- **Backend**: Express.js with TypeScript.
- **Data Fetching & State Management**: TanStack Query v5.
- **Form Handling**: React Hook Form with Zod validation.
- **Persistence**: Dual-layer storage for raw platform data and normalized `commerce.orders`.
- **Authentication**: Username/password with PostgreSQL, Passport.js, session management, CSRF protection.
- **Authorization**: Role-based access control (admin/manager/user).
- **Modules**: Allegro Fees Management, Product Catalog System, Product Creator Dictionaries with ShortName field (responsive UI with Sheet/Drawer mobile navigation, clickable table rows for editing), Product Matrix/Generator, Set Matrix Module with Color Management and Color Options, Advanced Product Filtering with Semicolon-based AND search, Template-Based Accessory System (with categorized submenu navigation: Okucia, Płyty, Tkaniny - responsive layout with Sheet/Drawer on mobile, group-based URLs /accessories/:groupCode), Conditional AI Sections, Product Image Tags System, Color Generation Tracking, Color Options System for Products and Sets, Bidirectional Navigation between Set Matrices and Generated Catalog Sets, Enhanced Set Description System (automatically builds comprehensive HTML descriptions by combining AI-generated content from component products), Product-Set Relationship Protection (prevents deletion of products used in sets with clear error messaging and displays set usage in product editor), Warehouse Management System (material inventory tracking with categories: Okucia, Płyty meblowe, Śruby, Tkaniny, Pianki - featuring material groups, gallery support, internal/external supplier codes, accessory linking capabilities, server-side filtering with ";" AND and "," OR operators, multiple view modes: list/compact/grid, pagination on top and bottom, bulk operations: delete/export to CSV, and group-based submenu navigation with dynamic URL pattern /warehouse/:category/:groupCode?).
- **Order Matching**: Tool for reconciling orders across platforms.
- **Automated Systems**: Auto-Healing Synchronization System, Nightly Full Sync scheduler.
- **Generation Progress Dialog**: Unified dialog for real-time progress and live SSE log streaming.
- **Timezone Handling**: Unified UTC storage with automatic DST conversion - All order dates stored in UTC (timestamptz), converted to Europe/Warsaw (CET/CEST) for display. Allegro dates received in UTC, Shoper dates converted from Europe/Warsaw to UTC at insert time using PostgreSQL timezone functions.
- **Backup System**: Automated SFTP backup with dual-source listing (local + files.alpsys.pl), automatic upload after backup creation, transparent download fallback for production persistence.

### Feature Specifications
- **OAuth Integration**: Secure OAuth 2.0 with Allegro.
- **Automated Synchronization**: Configurable cyclic synchronization for Allegro and Shoper.
- **Dashboard & Order Table**: Overview of orders, revenue, with filtering, searching, and sorting.
- **Configuration Panel**: Centralized settings for OAuth, synchronization, and connections.
- **Historia Zmian (Change History)**: Unified page with tabs for detected changes, recent updates, and sync logs.
- **User Management**: Admin-only CRUD for users, roles, and permissions.
- **API Token Management**: Admin-only CRUD for API tokens with audit logs.
- **Webhook Management**: Admin-only CRUD for webhook configurations and delivery logs.
- **Recent Updates**: Page for verifying orders by marketplace last_update timestamp.
- **Set Matrix Navigation**: Bidirectional navigation system between Set Matrices and Generated Catalog Sets:
  - Set Matrix Settings page displays all generated sets from that matrix with loading/empty states
  - Catalog Set Detail page shows source matrix information with link back to matrix
  - Clickable links throughout: Matrix → Generated Sets List → Set Detail → Back to Matrix
  - Consistent UI design matching product cards across all pages

### System Design Choices
- **Dual Product Architecture**: Marketplace Products (`commerce.marketplace_products`) and Generated Catalog Products (`catalog.products`).
- **Unified Schema**: `commerce` for order management, `catalog` for generated product catalog, `product_creator` for matrix/dictionary system, `warehouse` for material inventory management.
- **Modularity**: Separated `client`, `server`, and `shared` types.
- **Scalability**: Designed for integration with Odoo.
- **Schema Consistency**: All catalog products reside in `catalog.*` schema, all warehouse materials in `warehouse.*` schema.

## External Dependencies
- **Database**: PostgreSQL (Replit) with multiple schemas.
- **E-commerce Platforms**:
    - **Allegro API**: OAuth, order synchronization, customer returns (BETA), payments/refunds.
    - **Shoper API**: Order synchronization, product details.
- **External File Storage**: Configurable SFTP (files.alpsys.pl) and local file storage with adapter pattern for persistent file management (e.g., product images, exports).
- **Odoo Integration**: Direct integration via Cloudflare Tunnel with dual-mode synchronization.
- **AI Integrations**: OpenAI for AI-assisted content generation (via Replit AI Integrations) with section-based AI prompt system and accessory integration.
- **Accessory Grid JPG Rendering**: Automated system using Puppeteer for rendering accessory grids as JPG images, with caching.