# Design Guidelines: Integrator Zamówień Allegro

## Design Approach: Dashboard-Focused System
**Selected Approach:** Utility-first design system inspired by modern productivity tools (Linear, Vercel Dashboard, Stripe Dashboard)

**Justification:** This is a data-intensive administrative application requiring efficient information display, clear status visualization, and seamless workflow management. The focus is on speed, clarity, and reducing cognitive load for users managing multiple orders.

**Key Principles:**
- Information hierarchy through typography and spacing
- Instant visual feedback on data states
- Minimal distractions to maintain focus
- Professional, clean aesthetic that builds trust

## Core Design Elements

### A. Color Palette

**Dark Mode (Primary):**
- Background: 220 15% 8% (deep slate)
- Surface: 220 15% 12% (elevated panels)
- Border: 220 10% 20% (subtle dividers)
- Text Primary: 220 10% 95%
- Text Secondary: 220 8% 70%

**Status Colors:**
- Success (Paid): 142 76% 45% (vibrant green)
- Warning (Pending): 38 92% 55% (amber)
- Error (Unpaid): 0 72% 55% (red)
- Info (Shipped): 217 91% 60% (blue)
- Neutral: 220 9% 46% (gray)

**Accent:**
- Primary Action: 262 83% 58% (purple - Allegro brand alignment)
- Hover State: 262 83% 65%

### B. Typography

**Font Family:**
- Primary: 'Inter' (via Google Fonts CDN)
- Monospace: 'JetBrains Mono' (for order IDs, timestamps)

**Type Scale:**
- Headings: font-semibold, tracking-tight
- Body: font-normal, leading-relaxed
- Data Tables: font-medium, tabular-nums
- Labels: font-medium, text-sm, uppercase tracking-wide

### C. Layout System

**Spacing Primitives:** Consistently use Tailwind units of **2, 4, 6, 8, 12, 16** (e.g., p-4, gap-6, my-8)

**Grid Structure:**
- Main container: max-w-7xl mx-auto px-6
- Two-column layout: Sidebar (280px fixed) + Main content (flex-1)
- Card spacing: gap-6 for card grids
- Section spacing: py-8 between major sections

### D. Component Library

**Navigation:**
- Fixed sidebar with logo, main navigation items, and settings at bottom
- Top bar with sync status indicator, last refresh time, manual refresh button
- Breadcrumbs for configuration sections

**Data Display:**
- Table component with sticky header, alternating row backgrounds (subtle)
- Order cards for mobile/tablet view with collapsible details
- Status badges with icon + text, rounded-full design
- Metrics dashboard: 4-column grid showing total orders, paid/unpaid counts, revenue summary

**Forms (Configuration Panel):**
- Two-column form layout for API credentials
- Input fields with labels above, helper text below
- Toggle switches for auto-refresh settings
- Dropdown for refresh interval selection (1 min, 3 min, 5 min, 10 min)

**Overlays:**
- Modal for order details (full transaction info, buyer details, items)
- Toast notifications for sync success/errors (top-right positioning)
- Loading skeleton screens during data fetch

**Interactive Elements:**
- Primary buttons: filled with accent color, shadow-sm
- Secondary buttons: outline style with border-2
- Icon buttons: hover:bg-white/5 for subtle feedback
- Search bar: with icon, rounded-lg, border focus state

### E. Animations

**Minimal, Purposeful Motion:**
- Refresh spinner: gentle rotate animation on sync button
- Status badge transitions: fade in when data updates
- Table row hover: subtle background color transition (duration-150)
- No page transitions or scroll-triggered animations

## Specific Screens

**Dashboard (Main View):**
- Top metrics row: 4 stat cards (total orders today, pending payment, shipped, total revenue)
- Filters bar: date range picker, status filter chips, search by order ID
- Orders table: columns for Order ID, Buyer, Items Count, Total Amount, Payment Status, Shipping Status, Date
- Pagination at bottom with "Showing X-Y of Z orders"

**Configuration Panel:**
- Card-based layout with sections: API Credentials, Sync Settings, Display Preferences
- Visual feedback when credentials are validated (green checkmark)
- Test connection button with loading state

**Mobile Considerations:**
- Collapsible sidebar (hamburger menu)
- Stacked card view for orders instead of table
- Bottom navigation bar for quick actions

## Polish Language Integration
All UI text in Polish: "Zamówienia", "Płatności", "Status", "Odśwież", "Konfiguracja", "Ostatnia synchronizacja", etc.

## Images
**No hero images required** - this is a utility application focused on data display. Only use:
- Allegro logo in sidebar (SVG, 32x32px)
- Empty state illustration when no orders are found (simple SVG graphic with message "Brak zamówień")
- Loading state placeholder (animated skeleton screens)