import { Link, useRoute } from "wouter";
import { BarChart3, Table, PieChart, Calendar, TrendingDown } from "lucide-react";
import { cn } from "@/lib/utils";

type FeeSubPage = "summary" | "table" | "grouped" | "daily";

const FEE_PAGES: { 
  value: FeeSubPage; 
  label: string; 
  icon: typeof BarChart3;
}[] = [
  { value: "summary", label: "Zestawienia", icon: BarChart3 },
  { value: "table", label: "Tabela opłat", icon: Table },
  { value: "grouped", label: "Podział grupowany", icon: PieChart },
  { value: "daily", label: "Szczegółowe dzienne", icon: Calendar },
];

export function FeesSubmenu() {
  const [, summaryParams] = useRoute("/fees/summary");
  const [, tableParams] = useRoute("/fees/table");
  const [, groupedParams] = useRoute("/fees/grouped");
  const [, dailyParams] = useRoute("/fees/daily");
  
  let activePage: FeeSubPage | undefined;
  if (summaryParams) activePage = "summary";
  else if (tableParams) activePage = "table";
  else if (groupedParams) activePage = "grouped";
  else if (dailyParams) activePage = "daily";

  return (
    <div className="flex flex-col h-full">
      {/* Header */}
      <div className="border-b px-4 py-4 flex items-center justify-between gap-2">
        <div className="flex items-center gap-2">
          <TrendingDown className="h-5 w-5" />
          <h2 className="text-lg font-semibold">Opłaty Allegro</h2>
        </div>
      </div>

      {/* Menu items */}
      <div className="flex-1 overflow-y-auto">
        <div className="p-2">
          <div className="px-3 py-2 text-sm font-medium text-muted-foreground">
            Widoki
          </div>
          <nav className="space-y-1">
            {FEE_PAGES.map((page) => {
              const Icon = page.icon;
              const isActive = activePage === page.value;
              
              return (
                <Link 
                  key={page.value}
                  href={`/fees/${page.value}`}
                  data-testid={`link-fees-${page.value}`}
                >
                  <div
                    className={cn(
                      "flex items-center gap-3 px-3 py-2 rounded-md text-sm transition-colors hover-elevate active-elevate-2",
                      isActive 
                        ? "bg-accent text-accent-foreground font-medium" 
                        : "text-foreground"
                    )}
                  >
                    <Icon className="h-4 w-4 flex-shrink-0" />
                    <span className="truncate">{page.label}</span>
                  </div>
                </Link>
              );
            })}
          </nav>
        </div>
      </div>
    </div>
  );
}
